<?php
/*
Plugin Name: Editor Custom Color Palette
Description: A simple plugin to customize the color palette & text sizes & blocks from editor Gutenberg
Author: BLADOU Alain
Version: 3.1.9
Author URI: https://rouerguecreation.fr/
License:GPL v3
License URI: https://www.gnu.org/licenses/gpl-3.0.txt
Text Domain: editor-custom-color-palette
Domain Path: /languages
*/

/*
Editor Custom Color Palette is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
any later version.
 
Editor Custom Color Palette is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with Editor Custom Color Palette. If not, see https://www.gnu.org/licenses/gpl-3.0.txt.
*/


/***********************************************************************************************************
*
*  Editor Custom Color Palette [REV:3.1.9] 

*	   DÉFINITION DES CONSTANTES
*  1.  On charge le fichier de traduction
*  2.  On inclut les fichiers relatif a la page de réglages du plugin
*  3.  Actions a réaliser si l'utilisateur choisi d'initialiser les paramètres du plugin
*  4.  Actions a réaliser à l'activation du Plugin
*   4.1 Actions a réaliser aprés la mise à jour du plugin
*  5.  Uninstall Plugin
*  6.  RÉCUPÉRATION DES PARAMÉTRES DU PLUGIN DÉFINIT PAR L'UTILISATEUR
*  7.  chargement feuilles de style du plugin
*	7.1 chargement feuille de style pour les pages de réglages du plugin en back office
*	7.2 Ajout feuille de style des Icônes Dashicons pour WordPress en Front-end
*  8.  chargement scripts du plugin
*	8.1 Chargement script pour le Color Picker
*	8.2 Chargement script pour la personnalisation des blocs Gutenberg
*	8.3 Chargement script pour le bouton Upload Media
*	8.4 Chargement script pour l'upload Image en Avant sur l'écran Modification Rapide
*	8.5 Chargement script pour la mise a jour des métas de publication sur l'écran Modification Rapide
*	8.6 Chargement script pour Transformer le Bloc FAQ de Yoast en accordéon basculable
*	8.7 Chargement script pour Transformer le Bloc LISTE en accordéon basculable
*	8.8 Chargement script pour ajout d'une fonctionnalité de clic au lien des blocs
*	8.9 Chargement script pour le bouton retour vers le haut en admin
*	8.10 Chargement script pour le bouton retour vers le haut en Front End
*	8.11 Chargement scripts pour la lightbox en Front End
*	8.12 Chargement scripts pour le Slider Swiper en Front End
*	8.13 Chargement script pour le bloc icônes sociales flottant a droite
*	8.14 Chargement script pour le bloc icônes sociales avec liens de partage
*	8.15 Chargement script pour le compte a rebours
*	8.16 Chargement script pour une table responsive
*  9.  Lien Paramètres pour le plugin sur le panneau de la page des extensions 

*
*  10.  CONVERSION DES COULEURS DE LA PALETTE HEXADECIMAL EN RGBA
*  11. MODIFIER PALETTE DE COULEUR EDITEUR GUTENBERG
*   11.1 MODIFIER PALETTE DE COULEUR EDITEUR GUTENBERG INTITULEE THEME POUR UN THEME JSON
*   11.2 MODIFIER PALETTE DE COULEUR EDITEUR GUTENBERG INTITULEE PAR DEFAUT POUR LE THEME ASTRA  
*	11.3 REMPLACER LA PALETTE DE HUIT COULEURS PAR DÉDAUT DANS LE COLOR PICKER DU PERSONNALISEUR
*  12. DÉSACTIVER LES COULEURS & DÉGRADÉS PERSONNALISÉES
*   12.1 DÉSACTIVER LES COULEURS & DÉGRADÉS PERSONNALISÉES POUR UN THEME JSON 
*  13. TRANSPOSER LA PALETTE DE COULEURS EN VARIABLE CSS, APLIQUER LE STYLE EN ADMIN & FRONT END
*  14. MODIFIER PALETTE DE COULEUR ELEMENTOR
*  15. MODIFIER PALETTE DE COULEUR DIVI
*  16. SYNCHRONISER LA PALETTE DE COULEUR DE L'ÉDITEUR GUTENBERG ET D'ACF 
*  17. MODIFIER TAILLES POLICE EDITEUR GUTENBERG 
*   17.1 MODIFIER TAILLES POLICE EDITEUR GUTENBERG POUR UN THEME JSON  
*	17.2 TAILLE POLICE EDITEUR GUTENBERG PAR DEFAUT  
*  18. DÉSACTIVER LA TAILLE DE POLICE PERSONNALISÉE 
*   18.1 DÉSACTIVER LA TAILLE DE POLICE PERSONNALISÉE POUR UN THEME JSON

*  19. PERSONNALISER EDITEUR GUTENBERG 
*	19.1 DESACTIVER LE MODE PLEIN ECRAN DE GUTENBERG
*	19.2 ACTIVER LA FEUILLE DE STYLE PAR DÉFAUT
*	19.3 ALIGNEMENT LARGE & PLEINE LARGEUR POUR L 'EDITEUR DE BLOCS
*   19.4 EMBEDS RESPONSIVE (EX: Intégration Vidéos YouTUbe)
*   19.5 Activer la prise en charge des nouveaux paramètres de blocs Introduit depuis WordPress 6.0
*   19.6 Désactiver pour une image JPEG la génération d'image WebP par défaut pour les miniatures introduit depuis WordPress 6.1
*   19.7 Désactiver le téléchargement des images WebP & pour le format JPEG la  génération d'image WebP pour les miniatures
*   19.8 Désactiver la catégorie Openverse pour l'onglet média de l'inséreuse de blocs
*	19.9 Désactiver les onglets Paramètres & Styles pour la barre latérale onglet bloc
*   19.10 Couleur d'arrière plan de l'éditeur

*  20  ADMINISTRATION WORDPRESS
*   20.1 ÉCRAN DES PUBLICATIONS (ARTICLES  PAGES CPT)
*	 20.1.1 Ajout colonne Image En Avant & ID dans le back Office de wordpress pour les Pages & Articles & CPT
*	 20.1.2 Afficher l'image en avant & ID pour les Pages & Articles & CPT dans le back office de wordpress
*	 20.1.3 On organise les différentes colonnes de l'admin pour les articles & pages:  titre,ID,Catégories ...
*	 20.1.4 On organise les différentes colonnes de l'admin pour les CPT: Image En Avant ,titre,ID,Catégories ...
*	 20.1.5 Enregistre la colonne taxonomy-slug-catégorie du CPT comme triable
*    20.1.6 Ajouter des champs d'édition rapide en HTML pour l'Image Mise En Avant
*	 20.1.7 Filtrer les publications par auteur 
*	 20.1.8 Filtrer les publications personnalisées par catégories
*	 20.1.9 Filtrer les publications & Médiathèque par plage de dates
*	 20.1.10 Filtrer les Articles par status de publication
*	 20.1.11 Ajout d'options status de publication pour les actions groupés des articles
*	20.2 MÉDIATHÈQUE
*	 20.2.1 AJouter des colonnes dans la médiathèque pour l'identifiant du Média & Dimensions (L,H) & Taille 
*	 20.2.2 Enregistre les nouvelles colonnes Média comme triable
*	 20.2.3 Affichage du contenu des colonnes Média: ID & Dimensions (L,H) & Taille
*    20.2.4 Autoriser l'upload de tous types de format dans la bibliothèque médias
*	 20.2.5 Définir automatiquement le titre, le texte alternatif et la légende de l'image lors du téléchargement
*   20.3 COMPTES UTILISATEURS
*	 20.3.1 Ajout d'une colonne pour afficher la date d'enregistrement utilisateur 
*	 20.3.2 Ajout d'une colonne pour afficher la date de dernière connexion
*	 20.3.3 Autoriser les contributeurs a télécharger des médias dans la médiathèque
*   20.4 MODIFICATION DE LA PAGE CONNEXION WORDPRESS: LOGO & LIEN & MESSAGE D'ERREUR & SÉLECTEUR DE LANGUE
*	 20.4.1 Désactiver le sélecteur de langues
*    20.4.2 Afficher un message d'erreur personnalisé à vos utilisateurs
*    20.4.3 Désactiver la demande de vérification de l’adresse e-mail administrateur
*	 20.4.4 Changer l'URL du logo de la page de connexion afin qu'elle pointe vers la page d'accueil du site
*	 20.4.5 Texte a afficher lors du survol du Logo
*	 20.4.6 Personnalisation Style Formulaire de connexion
*	  20.4.6.1 Logo personnalisé du formulaire de connexion
*	  20.4.6.2 Personnalisation formulaire de connexion
*	  20.4.6.3 Image de fond Personnalisé pour la page de connexion
*   20.5 EMAIL WORDPRESS PAR DÉFAUT
*    20.5.1 Modification du nom de l'expéditeur et de l'adresse e-mail WordPress Par défaut
*	 20.5.2 Eviter que les mails de notification WordPress soit considéré comme des spams 
*   20.6 TABLEAU DE BORD
*	 20.6.1 Ajout dans le widget "d'un coup d'oeil" du tableau de bord du nombre de block réutilisable
*    20.6.2 Ajout dans le widget "d'un coup d'oeil" du tableau de bord du nombre d'utilisateur
*    20.6.3 Ajout dans le widget "d'un coup d'oeil" du tableau de bord du nombre pour les différents CPT 
*   20.7 AUTRES PERSONNALISATION DE L'ADMIN WORDPRESS
*	 20.7.1 Désactiver le sitemap de WordPress par défaut
*	 20.7.2 Activer Lien Connexion/déconnexion Admin WordPress en Local ou en Ligne
*
*
*  21. CSS DYNAMIQUE POUR PERSONNALISER LES ÉCRANS D'ADMINISTRATION DE WORDPRESS
*	21.1 Écran de publication page & articles & CPT: colonne image en avant
*	21.2 Style Modification Rapide Articles & Pages & CPT pour l'édition de l'image mise en avant
*   21.3 Suppression Notification Sur La Page De Réglage Du Plugin
*
*  22. PERSONNALISER INTERFACE PUBLIQUE
*	22.1 Bouton Retour Vers Le Haut interface publique
*   22.2 Ajouter une boîte d'informations sur l'auteur a la fin des articles
*	22.3 Filtrer l’affichage des extraits d'articles automatique
*
*  23. CSS DYNAMIQUE POUR PERSONNALISER L'INTERFACE PUBLIQUE
*	23.1 CSS Pour Bouton Retour Vers Le Haut
*	23.2 Boite d'informations sur l'auteur 
*	23.3 Lightbox Fancybox pour les publications
*
*  22. PERSONNALISER BLOCS GUTENBERG
*   22.1 Ajouter une nouvelle taille aux paramètres du bloc image 
*	22.2 Modifier les paramètres d'ajout de média par défaut
*	22.3 Ajout en Front End d'attribut URL Pour les bloc Groupe & Colonne 
*   22.4 AJOUT EN FRONT END DE LA VARIATION DU BLOCK GROUPE COMPTE A REBOURS 
*   22.5 Bloc Groupe: AJOUT EN FRONT END DU STYLE TABLE OF CONTENTS
*   22.6 Transformer le bloc Galerie de WordPress en un slider utilisant la bibliothèque Swiper
*   22.7 Bloc Icônes Sociales: transformer Liens Profil en Liens de Partage


*  21. ADDONS REUSABLE BLOCKS BACK OFFICE
*   21.1 Menu Bloc réutilisable en back office
*   21.2 INSERTION AUTOMATIQUE DE BLOC RÉUTILISABLE AVANT ET/OU APRÉS ARTICLES,PAGES,CPT
*	 21.2.1 Déclaration de Métas de publication
*	 21.2.2 Ajout des Métas de publication dans des colonnes pour les écrans qui listent les publications
*	 21.2.3 Ajouter des champs d'édition rapide en HTML pour les Métas de publication
*	 21.2.4 Ajouter des champs d'édition groupé en HTML pour les Métas de publication
*   21.3 AFFICHER PAR SHORTCODE UN BLOC RÉUTILISABLE SELON SON ID
*   21.4 FONCTION POUR AFFICHER DANS LE THEME UN BLOC RÉUTILISABLE SELON SON ID
*   21.5 Ajout de la colonne Intégration dans la page d'administration des blocs réutilisables
*   21.6 Afficher les shortcodes dans la colonne Intégration pour la page d'adminitration des blocs réutilisables

*  22. Créer une catégorie de bloc personnalisée dans WordPress Block Inserter

*  23. AJOUT AUX PARAMÉTRES DU BLOC PARAGRAPHE DE STYLES PERSONNALISÉS
*   23.1 Add Style Box Shadow(bloc paragraphe & bloc grouper & bloc colonne)
*	23.2 Add Style Card
*	23.3 Add Style Notice: Question
*	23.4 Add Style Notice: Info
*	23.5 Add Style Notice: Advice
*	23.6 Add Style Notice: Warning
*	23.7 Add Style Notice: Alert
*   23.8 Add Style Click to Tweet
*   23.9 Add Style Evidence
*
*  24. AJOUT AUX PARAMÉTRES DU BLOC LISTE DE STYLES PERSONNALISÉS
*   24.1 Add Style Square
*   24.2 Add Style Check
*   24.3 Add Style Check circle fill
*   24.4 Add Style Add 
*   24.5 Add Style Add circle fill
*   24.6 Add Style Push Spin 
*   24.7 Add Style Circle Duotone
*   24.8 Add Style Clear
*   24.9 Add Style Site
*   24.10 Add Style E-Mail
*   24.11 Add Style Phone
*   24.12 Add Style Facebook
*   24.13 Add Style YouTube
*   24.14 Add Style Twiter
*	24.15 Add Style Pinterest
*	24.16 Add Style Instagram
*	24.17 Add Style Linkedin
*   24.18 Add Style Calendar
*   24.19 Add Style Clock
*   24.20 Add Style Location
*	24.21 Add Style Diagram
*	24.22 Add ordonned disk-style
*	24.23 Add Style Accordion
*   24.24 Add Style Table Of Contents
*
*  25. AJOUT AUX PARAMÉTRES DU BLOC GROUPE DE STYLES PERSONNALISÉS
*	25.1 Add Style Table Of Contents
*
*  25. AJOUT AUX PARAMÉTRES DU BLOC IMAGE DE STYLES PERSONNALISÉS
*   25.1 Add Style Circle 
*   25.2 Add Style Filter Grayscale
*	25.3 Add Style Image Card
*
*  26. AJOUT AUX PARAMÉTRES DU BLOC BOUTON DE STYLES PERSONNALISÉS
*   26.1 Add style Outline hover arrow
*   26.2 Add style Download
* 
*  27. AJOUT AUX PARAMÉTRES DU BLOC PARENT COLONNES DE STYLES PERSONNALISÉS
*   27.1 Add Style Column reverse 
*   27.2 Add Style Responsive three columns
*
*  28. AJOUT AUX PARAMÉTRES DU BLOC MÉDIA & TEXTE DE STYLES PERSONNALISÉS
*   28.1 Add Style Half Background
*
*  29. AJOUT AUX PARAMÉTRES DU BLOC READ MORE DE STYLES PERSONNALISÉS
*
*  30. AJOUT AUX PARAMÉTRES DU BLOC TABLE DE STYLES PERSONNALISÉS
*
*  31. AJOUT AUX PARAMÉTRES DU BLOC SOCIAL LINKS DE STYLES PERSONNALISÉS
*
*  32. AJOUT EN FRONT END DU BOUTON CLICK TO TWEET POUR LE STYLE TWEET DU BLOC PARAGRAPHE
*
*  33. MODIFIER L'AVATAR PAR DEFAUT
*
*  34. CSS DYNAMIQUE 
*	34.1 CSS DYNAMIQUE PALETTE DE COULEURS GUTENBERG (Front End)(OLD)
*	34.2 CSS DYNAMIQUE TAILLES POLICE EDITEUR GUTENBERG (Front End)
*	34.3 CSS DYNAMIQUE PALETTE DE COULEURS GUTENBERG (Back office)(OLD)
*
*  35. STYLE BACK OFFICE PALETTE DE COULEURS
*
*  36. STYLE BACK OFFICE BLOCS EDITEUR GUTENBERG
*	36.1  CORRECTION BUG DU AU PLUGIN
*	36.2  RÈGLES GÉNÉRALES EDITEUR GUTENBERG
*	36.3  ALIGNEMENT LARGE & PLEINE LARGEUR POUR L 'EDITEUR DE BLOCS RÉGLES BACK OFFICE
*   36.4  EMBEDS RESPONSIVES LARGEUR MAX VIDÉOS INTÉGRÉES EN BACK OFFICE
*	36.5  FAIRE CORRESPONDRE LA LARGEUR DE L'EDITEUR & BLOC PARAGRAPHE & BLOC GROUP & BLOC TABLEAU & BLOC YOAST & BLOC LISTE & BLOC DÉTAILS A CELLE DU SITE RÉGLES BACK OFFICE
*   36.6  TITRE PAGE & ARTICLE & CPT BACK OFFICE
*	36.7  BLOC RÉUTILISABLE BLOCKQUOTE BACK OFFICE
*	36.8  BLOC RÉUTILISABLE METTRE EN ÉVIDENCE BACK OFFICE
*	36.9  STYLE BOX SHADOW BACK OFFICE
*   36.9.1 Style box shadow(page d'options du plugin) back office
*   36.9.2 Style box shadow(React JS) back office
*	36.10 BLOC PARAGRAPHE BACK OFFICE
*	  36.10.1 Style Card back office
*	  36.10.2 Style Notice: Question back office
*	  36.10.3 Style Notice: Info back office
*	  36.10.4 Style Notice: Advice back office
*	  36.10.5 Style Notice: Warning back office
*	  36.10.6 Style Notice: Alert back office
*	  36.10.7 Style Click to Tweet Back Office
*	  36.10.8 Style Evidence Back Office
*	  36.10.9 Style pour le format Tooltip Back Office
*     36.10.10 Style Contour Pour l'Icône Dashicon Ajouté au bloc paragraphe back office
*   36.11 BLOC GROUP BACK OFFICE
*	 36.11.1 Border Radius
*	 36.11.2 Alignement Left & Right Back Office
*    36.11.3 Style Variation InfoBox back office
*    36.11.4 Style Variation Countdown Timer back office
*    36.11.5 Style Table Of Contents back office
*    36.11.6 Formes de séparation back office
*    	36.11.6.1 Forme Inclinée(tilt) Back Office
*	 	36.11.6.2 Forme Inclinée avec opacité(tilt opacity) Back Office
*	 	36.11.6.3 Forme Flèche(Arrow) Back Office
*		36.11.6.4 Forme Incurvée(incurved) Back Office
*		36.11.6.5 Forme Incurvée assymétrique(curve asymmetrical) Back Office
*		36.11.6.6 Triangle (Triangle) Back Office
*		36.11.6.7 Triangle Assymétrique(Triangle Asymmetrical) Back Office
*		36.11.6.8 Forme Vagues(waves) Back Office
*		36.11.6.9 Forme Vagues avec opacité(waves opacity) Back Office
*		36.11.6.10 Forme Diviser(Split) Back Office
*		36.11.6.11 Forme Livre(Book) Back Office
*		36.11.6.12 Forme Ventilateur(Fan) Back Office
*		36.11.6.12 Régles Mobiles & tablettes Back Office
*   36.12 BLOC DÉTAILS BACK OFFICE
*	 37.8.2 Icône Dashicons Arrow Back Office
*   36.13 BLOC LISTE BACK OFFICE
*	 On fait correspondre respectivement la taille & couleur des items de liste à celles des Tailles de texte & couleurs sélectionné de la palette
*	 36.13.1 style Disc back office(style par défaut)
*	 36.13.2 Style Square back office
*    36.13.3 Style Check back office
*    36.13.4 Style Check circle fill back office
*    36.13.5 Style Add back office
*    36.13.6 Style Add circle fill back office
*    36.13.7 Style Push Spin back office
*    36.13.8 Style Circle Duotone back office 
*    36.13.9 Style Clear back office
*    36.13.10 Style Site back office
*    36.13.11 Style E-Mail back office
*    36.13.12 Style Phone back office
*    36.13.13 Style Facebook back office
*    36.13.14 Style YouTube back office
*	 36.13.15 Style Twiter back office
*    36.13.16 Style Pinterest back office
*    36.13.17 Style Instagram back office
*    36.13.18 Style Linkedin back office
*    36.13.19 Style Whatsapp back office
*    36.13.20 Style Calendar back office
*    36.13.21 Style Clock back office
*    36.13.22 Style Location back office
*	 36.13.23 Style Diagram back office
*	 36.13.24 Style Disque Pour Liste Ordonnée back office
*   36.14 BLOC IMAGE BACK OFFICE
*	  36.14.1 Style Circle back office
*	  36.14.2 Style Filter Grayscale back office
*     36.14.3 Style Card Image back office
*	  36.14.4 Style Hover Zoom back office
*   36.15 BLOC GALERIE BACK OFFICE
*     36.15.1 Galerie Native WordPress style justifié back office
*	  36.15.2 style Galerie Border Radius back office
*	  36.15.3 style Galerie Hover Zoom back office
*     36.15.4 Style Card Image Gallery back office
*   36.16 BLOC Bouton BACK OFFICE
*	  36.16.1 Style Plein back office
*	  36.16.2 Style Contour back office
*     36.16.3 Style Contour avec icône flêche droite au survol back office
*     36.16.4 Style Download back office
*     36.16.5 Style Pour l'Icône Dashicon Ajouté au bloc bouton back office 
*	36.17 BLOC PARENT COLONNES BACK OFFICE
*	  36.17.1 Régles générales Bloc Parent & bloc colonne back office 
*	  36.17.2 Style responsive three columns back office
*	  36.17.3 Style Column reverse back office 
*	  36.17.4 Suite Régles générales Bloc Parent & bloc colonne back office
*     36.17.5 Style Variation Pricing Table back office
*	36.18 BLOC MEDIA/TEXTE BACK OFFICE
*	  36.18.1 style Half Background back office
*	36.17 BLOC SEPARATOR BACK OFFICE
*	  36.17.1 Largeur Bloc Separator back office
*   36.19 BLOC TABLEAU BACK OFFICE
*     36.19.1 style ECCP Stripes back office
*   36.20 BLOC TITRE BACK OFFICE
*     36.20.1 Style Admin Menu back office
*     36.20.2 Style Post Formats back office
*     36.20.3 Style Block Editor back office
*	  36.20.4 Style TinyMCE back office
*     36.20.5 Style Posts Screen back office
*     36.20.6 Style Sorting back office
*	  36.20.7 Style Social back office
*	  36.20.8 Style WordPress back office
*	  36.20.9 Style Buddicons back office
*	  36.20.10 Style Products back office
*     36.20.11 Style Widgets back office
*	  36.20.12 Style Notifications back office
*	  36.20.13 Style Miscellaneous back office
*   36.21 BLOC DERNIERS ARTICLES BACK OFFICE
*	  36.21.1 Style Card Derniers Articles en mode grille back office
*   36.22 BLOC BOUCLE DE REQUÊTE BACK OFFICE
*	  36.22.1 Style Card Boucle De Requête en mode grille back office
*	  36.22.2 Style d'un avatar personnalisé en back office
*   36.23 BLOC ESPACEMENT BACK OFFICE
*	36.24 BLOC ICONES SOCIALES BACK OFFICE
*   36.25 ICÔNE TOOLBAR 
*	  36.25.1 ICÔNE TOOLBAR PARAGRAPHE
*	  36.25.2 ICÔNE TOOLBAR LISTE
*   36.26 SURLIGNEMENT TEXTE BACK OFFICE
*   36.27 FORMAT LIENS EXTERNE BACK OFFICE
*   36.28 RESPONSIVE BLOC GUTENBERG BACK OFFICE
*     36.28.1 Hauteur du bloc couverture sur mobile en Back Office
*
*  37. STYLE FRONT END BLOCS EDITEUR GUTENBERG
*	37.1 ALIGNEMENT LARGE & PLEINE LARGEUR POUR L 'EDITEUR DE BLOCS RÉGLES FRONT END
*   37.2 EMBEDS RESPONSIVES LARGEUR MAX VIDÉOS INTÉGRÉES FRONT END
*	37.3 BLOC RÉUTILISABLE BLOCKQUOTE FRONT END
*	37.4 BLOC RÉUTILISABLE METTRE EN ÉVIDENCE FRONT END
*	37.5  STYLE BOX SHADOW FRONT END
*    37.5.1 Style box shadow(page d'options du plugin) front end
*    37.5.2 Style box shadow(React JS) front end
*   37.6 BLOC PARAGRAPHE FRONT END
*	 37.6.1 Style Card front end
*	 37.6.2 Style Notice: Question front end
*	 37.6.3 Style Notice: Info front end
*	 37.6.4 Style Notice: Advice front end
*	 37.6.5 Style Notice: Warning front end
*	 37.6.7 Style Notice: Alert front end
*	 37.6.8 Style Click to Tweet Front End  
*	 37.6.9 Style Evidence Front End
*	 37.6.10 Style pour le format Tooltip Front End 
*	 37.6.11 Largeur Paragraphe Front End
*	 37.6.12 Style Contour Pour l'Icône Dashicon Ajouté au bloc paragraphe front end 
*   37.7 BLOC GROUP FRONT END
* 	 37.7.1 Largeur Bloc Group Front End
*    37.7.2 Border Radius
*    37.7.3 Alignement Left & Right & Center Front End
*    37.7.4 Style Variation InfoBox Front End
*    37.7.5 Style Variation Countdown Timer Front End
*	 37.7.6 Style Table Of Contents Front End
*    37.7.7 Formes de séparation Front End
*    	37.7.7.1 Forme Inclinée(tilt) Front End
*	 	37.7.7.2 Forme Inclinée avec opacité(tilt opacity) Front End
*	 	37.7.7.3 Forme Flèche(Arrow) Front End
*		37.7.7.4 Forme Incurvée(incurved) Front End
*		37.7.7.5 Forme Incurvée assymétrique(curve asymmetrical) Front End
*		37.7.7.6 Triangle (Triangle) Front End
*		37.7.7.7 Triangle Assymétrique(Triangle Asymmetrical) Front End
*		37.7.7.8 Forme Vagues(waves) Front End
*		37.7.7.9 Forme Vagues avec opacité(waves opacity) Front End
*		37.7.7.10 Forme Diviser(Split) Front End
*		37.7.7.11 Forme Livre(Book) Front End
*		37.7.7.12 Forme Ventilateur(Fan) Front End
*		37.7.7.13 Régles Mobiles & tablettes Front End
*   37.8 BLOC DÉTAILS FRONT END
*	 37.8.1 Largeur Bloc Détails Front End
*	 37.8.2 Icône Dashicons Arrow Front End
*   37.9 BLOC LISTE FRONT END
*	 37.9.1 Largeur Bloc Liste Front End
*	 37.9.2 style Disc front end(style par défaut)
*	 37.9.3 Style Square front end
*    37.9.4 Style Check front end
*    37.9.5 Style Check circle fill front end
*    37.9.6 Style Add front end
*    37.8.7 Style Add circle fill front end
*    37.9.8 Style Push Spin front end 
*    37.9.9 Style Circle Duotone front end 
*	 37.9.10 Style Clear front end
*	 37.9.11 Style Site front end
*	 37.9.12 Style E-Mail front end
*	 37.9.13 Style Phone front end
*	 37.9.14 Style Facebook front end
*	 37.9.15 Style YouTube front end
*	 37.9.16 Style Twiter front end
*	 37.9.17 Style Pinterest front end
*	 37.9.18 Style Instagram front end
*	 37.9.19 Style Linkedin front end
*	 37.9.20 Style Whastapp front end
*	 37.9.21 Style Calendar front end
*	 37.9.22 Style Clock front end
*	 37.9.23 Style Location front end
*	 37.9.24 Style Diagram front end
*	 37.9.25 Style Disque Pour Liste Ordonnée front end
*	 37.9.26 Style Accordion front end
*    37.10 BLOC IMAGE FRONT END
*	  37.10.1 Style Circle front end
*	  37.10.2 Style Filter Grayscale front end
*	  37.10.3 Style Card Image front end 
*	  37.10.4 style Hover Zoom front end
*   37.11 BLOC GALERIE FRONT END
*     37.11.1 Galerie Native WordPress style justifié front end
*	  37.11.2 Galerie Native WordPress Disposition sur une Colonne En Mobile
*	  37.11.3 style Galerie Border Radius front end
*	  37.11.4 style Galerie Hover Zoom front end
*     37.11.5 Style Card Image Gallery front end
*	  37.11.6 Slider Swiper pour le bloc Galerie
*     37.11.7 Comparaison images Avant/aprés pour le bloc Galerie
*   37.12 BLOC Bouton FRONT END
*	  37.12.1 Style Plein front end
*	  37.12.2 Style Contour front end
*	  37.12.3 Style Contour avec icône flêche droite au survol front end
*     37.12.4 Style Download front end
*     37.12.5 Style par défaut(modif pour CPT The Events Calendar)
*	  37.12.6 Style Pour l'Icône Dashicon Ajouté au bloc bouton front end 
*	37.13 BLOC PARENT COLONNES FRONT END
*	  37.13.1 Régles générales Bloc Parent & bloc colonne front end
*	  37.13.2 Style responsive three columns front end 
*	  37.13.3 Style Column reverse front end
*	  37.13.4 Suite Régles générales Bloc Parent & bloc colonne front end
*     37.13.5 Style Variation Pricing Table front end
*     37.13.6 Style Variation Flip Box front end
*	37.14 BLOC MEDIA/TEXTE FRONT END
*	  37.14.1 style Half Background front end
*	37.15 BLOC SEPARATOR FRONT END
*	  37.15.1 Largeur Bloc Separator Front End
*   37.16 BLOC TABLEAU FRONT END
*     37.16.1 style ECCP Stripes front end
*     37.16.2 Largeur Tableau Front End
*     37.16.3 Table responsive Front End
*   37.17 BLOC TITRE FRONT END
*     37.17.1 Style Admin Menu front end
*     37.17.2 Style Post Formats front end
*     37.17.3 Style Block Editor front end
*	  37.17.4 Style TinyMCE front end
*     37.17.5 Style Posts Screen front end
*     37.17.6 Style Sorting front end
*	  37.17.7 Style Social front end
*	  37.17.8 Style WordPress front end
*	  37.17.9 Style Buddicons front end
*	  37.17.10 Style Products front end
*     37.17.11 Style Widgets front end
*	  37.17.12 Style Notifications front end
*	  37.17.13 Style Miscellaneous front end
*   37.18 BLOC DERNIERS ARTICLES FRONT END
*	  37.18.1 Style Card Derniers Articles en mode grille front end
*     37.18.2 Style Hover Zoom pour le bloc Derniers articles front end
*   37.19 BLOC BOUCLE DE REQUÊTE FRONT END
*	  37.19.1 Style Card Boucle De Requête en mode grille front end
*	  37.19.2 Style d'un avatar personnalisé en front end
*     37.19.3 Style Hover Zoom pour le Boucle De Requête front end
*   37.20 BLOC ESPACEMENT FRONT END
*   37.21 BLOC READ MORE(balise lire la suite)
*   37.22 BLOC ICONES SOCIALES FRONT END
*   37.23 BLOC FAQ YOAST SEO TRANSFORMÉ EN ACCORDEON
*	37.24 SURLIGNEMENT TEXTE FRONT END
*   37.25 FORMAT LIENS EXTERNE FRONT END
*   37.26 RESPONSIVE BLOC GUTENBERG FRONT END
*     37.26.1 Afficher/Masquer un bloc sur Mobile,Tablette ou PC
*     37.26.2 Alignement du texte sur mobile
*     37.26.3 Hauteur du bloc couverture sur mobile en Front End
*	
*
*
*  38. FONCTION CONVERSION HEXDEC COLOR TO RGBA
*  39. FONCTION CONVERSION RGBA TO HEXDEC COLOR 
*  40. RÉCUPÉRATION SLUG DES TYPES DE PUBLICATIONS PERSONNALISÉES 
*  41. FONCTION IS_BLOG()
* 
*************************************************************************************************************/

/*----------------------------------------------------------------------------*
 *                    DÉFINITION DES CONSTANTES
 *----------------------------------------------------------------------------*/

//on définit la dernière version du plugin
define('ECCP_PLUGIN_VERSION', '3.1.9');

/* Empêche l'utilisateur public d'accéder directement aux fichiers .php via l'URL
et garantit que les fichiers du plugin seront exécutés uniquement dans l'environnement WordPress.*/
defined( 'ABSPATH' ) || die();

// plugin_dir_url( __FILE__ ) donne par ex:
// http://localhost/wp-chef-ocean/wp-content/plugins/editor-custom-color-palette/
define( 'EDITOR_CUSTOM_COLOR_PALETTE_URL', plugin_dir_url( __FILE__ ) );

// plugin_basename( __FILE__ ) donne le chemin relatif du fichier principal du plugin 
// par rapport au répertoire plugins de WordPress et sans le  slash de début et de fin soit:
// editor-custom-color-palette/editor-custom-color-palette.php
define( 'ECCP_PLUGIN_PATH_NAME', plugin_basename( __FILE__ ) );


/*----------------------------------------------------------------------------*
 *           1. On charge le fichier de traduction
 *----------------------------------------------------------------------------*/

add_action( 'init', 'eccp_settings_load_textdomain' );

/* On charge le fichier de traduction .mo,  ECCP_PLUGIN_PATH_NAME ==> editor-custom-color-palette/editor-custom-color-palette.php
   dirname( ECCP_PLUGIN_PATH_NAME ) ==> editor-custom-color-palette soit le dossier du plugin
   Paramètres:  le domaine , Obsolète par défaut false,a partir du réperoire plugins de WordPress Chemin relatif vers le répertoire de langue où réside le fichier .mo : editor-custom-color-palette/languages */
function eccp_settings_load_textdomain() {
    load_plugin_textdomain( 'editor-custom-color-palette', FALSE, dirname( ECCP_PLUGIN_PATH_NAME ) . '/languages' );
}


// Forcer la traduction française en local à la place de celui du fichier de WordPress.org
// mis dans le dossier wpcontent/languages/plugins
// $mofile: chemin relatif du fichier de traduction a partir du dossier wpcontent
// soit: wpcontent/plugins/editor-custom-color-palette/editor-custom-color-palette-fr_FR.mo
// WP_PLUGIN_DIR chemin relatif du dossier plugins a partir du dossier wpcontent soit: wpcontent/plugins
// dirname( ECCP_PLUGIN_PATH_NAME ) ==> editor-custom-color-palette soit le dossier du plugin
// get_locale() permet de récupérer les paramètres régionaux en l'occurence: fr_FR
if(get_locale() == 'fr_FR') {
	add_filter( 'load_textdomain_mofile', 'eccp_load_custom_plugin_translation_file', 10, 2 );
}

function eccp_load_custom_plugin_translation_file( $mofile, $domain ) {
	
  if ( 'editor-custom-color-palette' === $domain ) {
    $mofile = WP_PLUGIN_DIR.'/' . dirname( ECCP_PLUGIN_PATH_NAME ) . '/languages/'.$domain.'-'. get_locale().'.mo';
  }
  
  return $mofile;
  
}

/*----------------------------------------------------------------------------*
 *     2. On inclut les fichiers relatif a la page de réglages du plugin
 *----------------------------------------------------------------------------*/

include 'inc/eccp-admin-menu.php';
include 'inc/eccp-multiple-settings.php';

/*---------------------------------------------------------------------------------------------------*
 *           3. Actions a réaliser si l'utilisateur choisi d'initialiser les paramètres du plugin
 *--------------------------------------------------------------------------------------------------*/

/* dans la table wp_options pour le champ:
   option_name = ecpp_multiple_setting  sont définit les réglages par défaut du plugin sous forme d'un tableau 
*/

add_action("admin_init", function () {
	
	// On récupère les paramètres général pour tous les onglets de réglages du plugin
	$default_settings = get_option( 'eccp_settings_default_settings' );
	$settings  = get_option( 'eccp_multiple_setting' );
	$editor_text_size_settings = get_option( 'eccp_setting_editor_text_size' );
	$custom_gutenberg_editor_settings = get_option( 'eccp_settings_custom_gutenberg_editor' );
	$custom_gutenberg_blocks_settings = get_option( 'eccp_settings_custom_gutenberg_block' );
	$reusable_blocks_settings = get_option( 'eccp_settings_reusable_blocks' );
	$elementor_settings = get_option( 'eccp_settings_elementor' );
	$divi_settings = get_option( 'eccp_settings_divi_theme' );
	$custom_back_office_settings = get_option( 'eccp_settings_custom_back_office' );
	$custom_front_end_settings = get_option( 'eccp_settings_custom_front_end' );
	
	
	/* 
	 On récupère les réglages généraux du plugin sous forme de tableaux avec pour index:
	 
	 //----------------------------------  PARAMÈTRES PAR DÉFAUT  ----------------------------------------------------------
	 eccp_default_setting_radio_field: choix d'initialiser le plugin aux paramètres généraux par défaut
	 eccp_delete_data_uninstallation_radio_field: choix de supprimer les données lors de la désinstallation
	
	 //----------------------------------  EDITOR COLOR PALETTE ----------------------------------------------------------
	 eccp_settings_activate_customizing_color_palette_checkbox_field: activer la personnalisation de la palette de couleurs
	 eccp_settings_number_colors_select_field: choix du nombre de couleurs de la palette
	 // ------- COLOR 1 --------- 
	 eccp_settings_color_one_text_field: couleur N°1
	 eccp_settings_opacity_color_one_text_field: opacité de la couleur N°1
	 eccp_settings_name_color_one_text_field: nom de la couleur N°1
	 eccp_settings_slug_color_one_text_field: slug de la couleur N°1
	 eccp_settings_color_one: valeur de la couleur après application de l'opacité sélectionné par l'utilisateur
	 // ------- COLOR 2 --------- 
	 eccp_settings_color_two_text_field: couleur N°2
	 eccp_settings_opacity_color_two_text_field: opacité de la couleur N°2
	 eccp_settings_name_color_two_text_field: nom de la couleur N°2
	 eccp_settings_slug_color_two_text_field: slug de la couleur N°2
	 eccp_settings_color_two: valeur de la couleur après application de l'opacité sélectionné par l'utilisateur
	 //...........COLOR 3.........................
	 //.......... COLOR 4........................
	 //...........COLOR 5.........................
	 //...........COLOR 6.........................
	 //...........COLOR 7.........................
	 //...........COLOR 8.........................
	 //...........COLOR 9.........................
	 //...........COLOR 10.........................
	 //...........COLOR 11.........................
	 // ------- COLOR 12 --------- 
	 eccp_settings_color_twelve_text_field: couleur N°12
	 eccp_settings_opacity_color_twelve_text_field: opacité de la couleur N°12
	 eccp_settings_name_color_twelve_text_field: nom de la couleur N°12
	 eccp_settings_slug_color_twelve_text_field: slug de la couleur N°12
	 eccp_settings_color_twelve: valeur de la couleur après application de l'opacité sélectionné par l'utilisateur
	 
	 eccp_settings_disabling_custom_colors_checkbox_field: désactiver les couleurs personnalisées
	 eccp_settings_disabling_custom_gradients_checkbox_field: désactiver les dégradés personnalisés
	 
	 //----------------------------------  EDITOR TEXT SIZE PALETTE ----------------------------------------------------------
     eccp_settings_activate_editor_text_size_checkbox_field: Activer le réglage des tailles de texte
	 eccp_settings_small_font_size_text_field: renseigner en pixel la taille de police small
	 eccp_settings_regular_font_size_text_field: renseigner en pixel la taille de police regular
	 eccp_settings_large_font_size_text_field: renseigner en pixel la taille de police large
	 eccp_settings_huge_font_size_text_field: renseigner en pixel la taille de police larger
	 eccp_settings_enable_default_gutenberg_editor_font_size_checkbox_field: activer la taille de police par défaut pour l'editeur Gutenberg
	 eccp_settings_default_gutenberg_editor_font_size_text_field: taille de texte par défaut de l'editeur Gutenberg
	 eccp_settings_disable_custom_font_size_checkbox_field: désactiver la taille de police personnalisée
	 
	 //----------------------------------  CUSTOM GUTENBERG EDITOR ----------------------------------------------------------
	 eccp_settings_disable_fullscreen_gutenberg_editor_checkbox_field : désactiver le mode plein écran de Gutenberg
	 eccp_settings_activate_default_style_sheet_on_front_end_checkbox_field: activer la feuille de style par défaut des 
	 blocs Gutenberg en Front End
	 eccp_settings_activate_align_wide_block_editor_checkbox_field: active l'alignement large 
	 ou pleine largeur pour l'editeur de blocs
	 eccp_settings_activate_responsive_embeds_checkbox_field: activer les embeds responsive(ex: intégration vidéos YouTube)
	 eccp_settings_post_embed_max_width_text_field: largeur max des vidéos intégrées pour les articles ex: YouTube
	 eccp_settings_page_embed_max_width_text_field: largeur max des vidéos intégrées pour les pages ex: YouTube
	 eccp_settings_cpt_embed_max_width_text_field: largeur max des vidéos intégrées pour les CPT ex: YouTube
	 eccp_corrective_according_to_theme_radio_field: corriger selon les thèmes le problème de marge interne haute et alignement centré des vidéos en Front End
	 eccp_settings_activate_editor_width_checkbox_field: activer le réglage de la largeur de l'editeur
	 eccp_settings_small_template_editor_text_field: largeur de l'editeur: petit modèle
	 eccp_settings_large_template_editor_text_field: largeur de l'editeur: grand modèle
	 eccp_settings_post_template_editor_select_field: choix du modèle de largeur de l'editeur pour les articles
	 eccp_settings_page_template_editor_select_field: choix du modèle de largeur de l'editeur pour les pages
	 eccp_settings_cpt_template_editor_select_field: choix du modèle de largeur de l'editeur pour les Custom Post Type
	 eccp_settings_page_title_alignment_select_field: alignement des titres des pages & articles sous l'editeur Gutenberg

     eccp_settings_activate_support_margin_padding_checkbox_field: Activer la prise en charge des nouveaux paramètres de bloc: Marge externe & Marge interne
     eccp_settings_activate_support_border_checkbox_field: Activer la prise en charge du nouveau paramètre de bloc: Bordure
	
	 eccp_settings_disable_webp_image_generation_checkbox_field: Désactiver pour une image JPEG la génération d'image WebP par défaut pour les miniatures introduit par WordPress 6.1
	 eccp_settings_disable_downloading_and_image_generation_webp_checkbox_field: Désactiver le téléchargement & la génération d'image au format WebP

	 eccp_settings_disable_openverse_category_from_media_tab_checkbox_field: Désactiver le catégorie openverse pour l'onglet Média de l'inséreuse de blocs
	 eccp_settings_disable_settings_styles_tabs_for_sidebar_checkbox_field: Désactiver les onglets Paramètres & styles pour la barre latérale onglet bloc
	 eccp_settings_enable_editor_background_color_checkbox_field: activer la couleur d'arrière plan de l'editeur
	 eccp_settings_editor_background_color_text_field: couleur arrière plan editeur

	 //----------------------------------  CUSTOM GUTENBERG BLOCKS ----------------------------------------------------------
	 
	 //Configuré dans l'editeur Gutenberg a partir de la version 2.8
	 eccp_settings_activate_box_shadow_paragraph_block_radio_field: activer l'ombre de boite pour le bloc paragraphe
     eccp_settings_box_shadow_color_text_field: couleur pour l'ombre de boite     
     eccp_settings_box_shadow_opacity_text_field: opacité pour l'ombre de boite    
     eccp_settings_box_shadow_x_text_field:paramètre X pour l'ombre de boite
     eccp_settings_box_shadow_y_text_field:paramètre y pour l'ombre de boite 

     eccp_settings_box_shadow_blur_text_field:paramètre blur(flou) pour l'ombre de boite  
     eccp_settings_box_shadow_spread_text_field:paramètre spread(diffuser) pour l'ombre de boite 
	 eccp_settings_activate_style_card_paragraph_radio_field: activer le style card pour le bloc paragraphe
	 eccp_settings_activate_style_notice_question_radio_field: activer le style Notice: Question pour le bloc paragraphe
	 eccp_settings_icon_color_style_notice_question_text_field: couleur de l'icône pour le style notice question
	 eccp_settings_activate_style_notice_info_radio_field: activer le style Notice: Info pour le bloc paragraphe
	 eccp_settings_icon_color_style_notice_info_text_field: couleur de l'icône pour le style notice info
	 eccp_settings_activate_style_notice_advice_radio_field: activer le style Notice: Advice pour le bloc paragraphe
	 eccp_settings_icon_color_style_notice_advice_text_field: couleur de l'icône pour le style notice advice
	 eccp_settings_activate_style_notice_warning_radio_field: activer le style Notice: Warning pour le bloc paragraphe
	 eccp_settings_icon_color_style_notice_warning_text_field: couleur de l'icône pour le style notice warning
	 eccp_settings_activate_style_notice_alert_radio_field: activer le style Notice: Alert pour le bloc paragraphe
	 eccp_settings_icon_color_style_notice_alert_text_field: couleur de l'icône pour le style notice alert
	 eccp_settings_activate_style_click_to_tweet_radio_field: activer le style Click to Tweet pour le bloc paragraphe 
	 eccp_settings_tooltip_text_color_text_field: renseigner la couleur du texte pour l'info-bulle
	 eccp_settings_tooltip_background_color_text_field: renseigner la couleur d'arrière plan pour l'info-bulle
	 eccp_settings_text_double_underline_color_text_field: renseigner la couleur double soulignement du texte marqueur présence info-bulle
	 
	 eccp_settings_bulleted_list_color_text_field: couleur de la liste à puces
	 eccp_settings_bulleted_list_size_text_field: taille des puces pour le bloc liste
	 eccp_settings_activate_styles_bullet_list_radio_field: activer les styles de liste à puces
	 eccp_settings_name_table_of_contents_text_field: renseigner le nom de la table des matières
	 eccp_settings_title_color_table_of_contents_text_field: couleur du titre de la table des matières
	 eccp_settings_offset_navigation_anchors_text_field: décalage pour les ancres de navigation avec un en-tête fixe
	 eccp_settings_activate_underline_table_of_contents_links_on_hover_radio_field: activer le soulignement des liens de la table des matières au survol
	 
	 eccp_settings_activate_rectangle_shape_style_radio_field: activer le style Forme Rectangle pour le bloc Icônes de réseaux sociaux
	 
	 eccp_settings_caption_font_size_text_field: taille de la police pour la légende du bloc image
	 eccp_settings_caption_padding_text_field: marge interne pour la légende du bloc image
	 eccp_settings_caption_color_text_field: couleur du texte de la légende
	 eccp_settings_caption_background_color_text_field: couleur d'arrière plan de la légende
	 eccp_settings_activate_style_image_circle_radio_field: activer le style Image Circle
	 eccp_settings_activate_style_image_filter_grayscale_radio_field: activer le style Image Filter Grayscale
	 eccp_settings_activate_style_image_card_radio_field:activer le style Image Carte
	 eccp_settings_enable_image_size_setting_radio_field: activer la définition d'une taille d'image aux paramètres dubloc
	 eccp_settings_custom_image_width_parameter_text_field: largeur personnalisé de l'image aux paramètres du bloc
	 eccp_settings_custom_image_height_parameter_text_field: hauteur personnalisé de l'image aux paramètres du bloc
	 eccp_settings_name_new_image_size_text_field: Nom de cette nouvelle taille d'image aux paramètres du bloc
	 eccp_settings_slug_new_image_size_text_field: slug de cette nouvelle taille d'image aux paramètres du bloc
	 eccp_settings_image_default_link_type_select_field: définir le type de lien par défaut lors d'un ajout d'image
	 eccp_settings_image_default_size_select_field: définir la taille par défaut lors d'un ajout d'image
	 
	 eccp_settings_activate_button_styles_hover_radio_field: activer les styles des boutons au survol
	
	 //Configuré dans l'editeur Gutenberg a partir de la version 2.6
	 eccp_settings_hover_fill_style_background_color_text_field: couleur d'arrière plan au survol pour le style "Plein" du bouton 
	 eccp_settings_hover_fill_style_backgound_color_opacity_text_field: opacité de la couleur d'arrière plan au survol pour le style "Plein" du bouton 
	 eccp_settings_hover_fill_style_border_color_text_field: couleur de bordure du bouton au survol pour le style "Plein"
	 eccp_settings_hover_fill_style_text_color_text_field: couleur du texte pour le bouton au survol pour le style "Plein"
	 
	 //Configuré dans l'editeur Gutenberg a partir de la version 2.6
	 eccp_settings_hover_outline_style_background_color_text_field: couleur d'arrière plan au survol pour le style "Contour" du bouton 
	 eccp_settings_hover_outline_style_backgound_color_opacity_text_field: opacité de la couleur d'arrière plan au survol pour le style "Contour" du bouton 
	 eccp_settings_hover_outline_style_border_color_text_field: couleur de bordure du bouton au survol pour le style "Contour"
	 eccp_settings_hover_outline_style_text_color_text_field: couleur du texte pour le bouton au survol pour le style "Contour"
	 
	 eccp_settings_activate_columns_block_styles_radio_field: Activer les styles pour le bloc parent colonnes
	 
	 eccp_settings_activate_media_text_block_styles_radio_field: Activer les styles pour le bloc Média & Texte
	 
	 
	 eccp_settings_activate_block_styles_read_more_radio_field: Activer les styles pour le bloc Lire La Suite
	 eccp_settings_link_text_read_more_text_field: texte du lien pour la balise Lire La Suite
	 
	 eccp_settings_block_read_more_background_color_text_field: couleur d'arrière plan au survol pour le style du bloc Lire La Suite 
	 eccp_settings_block_read_more_backgound_color_opacity_text_field: opacité de la couleur d'arrière plan pour le style du bloc Lire La Suite
	 eccp_settings_block_read_more_border_color_text_field: couleur de bordure pour le style du bloc Lire La Suite
	 eccp_settings_block_read_more_text_color_text_field: couleur du texte pour le style du bloc Lire La Suite
	 
	 eccp_settings_block_read_more_hover_background_color_text_field: couleur d'arrière plan pour le style du bloc Lire La Suite au survol  
	 eccp_settings_block_read_more_hover_backgound_color_opacity_text_field: opacité de la couleur d'arrière plan pour le style du bloc Lire La Suite au survol 
	 eccp_settings_block_read_more_hover_border_color_text_field: couleur de bordure pour le style du bloc Lire La Suite au survol
	 eccp_settings_block_read_more_hover_text_color_text_field: couleur du texte pour le style du bloc Lire La Suite au survol
	 
	 eccp_settings_activate_block_styles_table_radio_field: activer les styles pour le bloc table
	 eccp_settings_activate_reponsive_tables_radio_field: activer les tables responsives
	 
	 eccp_settings_activate_card_style_latest_posts_block_radio_field: activer le style Carte pour le bloc Derniers Articles
	 eccp_settings_activate_hover_zoom_style_latest_posts_block_radio_field: activer le style zoom 5% au survol pour le bloc Derniers Articles
	 
	 eccp_settings_activate_card_style_query_loop_block_radio_field: activer le style Carte pour le bloc Boucle De Requête
	 eccp_settings_activate_custom_avatar_radio_field: activer un gravatar personnalisé
	 eccp_settings_custom_avatar_url_text_field: URL pour le gravatar personnalisé du bloc Boucle De Requête
	 eccp_settings_custom_avatar_size_text_field: taille de l'avatar personnalisé en pixel
	 eccp_settings_activate_hover_zoom_style_query_loop_block_radio_field: activer le style Zoom de 5% au survol du bloc boucle de requête
	 
	 eccp_settings_turn_yoast_faq_block_an_accordion_radio_field: Transformer le bloc FAQ YOAST SEO en accordéon
	 eccp_settings_width_block_faq_yoast_text_field: Largeur du block FAQ YOAST
	 
	 eccp_settings_enable_script_js_css_swiper_radio_field: activer script JS & CSS de la librairie swiper 
	 
	 eccp_settings_activate_script_reactjs_radio_field: Activer le script basé sur ReactJS pour plus de personnalisation des blocs
	 
	 //----------------------------------  ADDONS REUSABLE BLOCKS ----------------------------------------------------------
	 eccp_activate_reusable_blocks_menu_checkbox_field: activer le menu blocs réutilisables en back office
	 
	 eccp_activate_reusable_blocks_shortcode_checkbox_field : activer l'affichage de blocs réutilisables par shortcode
	 
	 eccp_settings_insert_block_before_post_select_field : sélection block réutilisable a inséré avant le contenu des articles
	 eccp_settings_insert_block_after_post_select_field : sélection block réutilisable a inséré aprés le contenu des articles
	 eccp_settings_insert_block_before_page_select_field : sélection block réutilisable a inséré avant le contenu d'une page
	 eccp_settings_insert_block_after_page_select_field : sélection block réutilisable a inséré aprés le contenu d'une page
	 eccp_settings_insert_block_before_cpt_select_field : sélection block réutilisable a inséré avant le contenu d'un CPT
	 eccp_settings_insert_block_after_cpt_select_field : sélection block réutilisable a inséré aprés le contenu d'un CPT
	 
	 eccp_settings_quotation_marks_color_text_field:  couleur des guillemets   
	 eccp_settings_quotation_marks_opacity_text_field: opacité des guillemets
	 eccp_settings_font_weight_blockquote_select_field: graisse de la police pour le blockquote ( plus utilisé a partir de la version 2.3)
	 eccp_settings_font_size_blockquote_text_field: taille de la police pour le blockquote ( plus utilisé a partir de la version 2.3)
	 eccp_settings_width_blockquote_post_back_office_text_field: largeur du blockquote en back office pour les articles
	 eccp_settings_width_blockquote_post_front_end_text_field: largeur du blockquote en front end pour les articles
	 eccp_settings_width_blockquote_page_back_office_text_field: largeur du blockquote en back office pour les pages
	 eccp_settings_width_blockquote_page_front_end_text_field: largeur du blockquote en front end pour les pages
	 eccp_settings_width_blockquote_cpt_back_office_text_field: largeur du blockquote en back office pour les Custom Post Type
	 eccp_settings_width_blockquote_cpt_front_end_text_field: largeur du blockquote en front end pour les Custom Post Type
	 eccp_settings_custom_paragraph_border_color_text_field: couleur de la bordure pour le bloc Mettre en évidence
	 eccp_settings_opacity_custom_paragraph_border_color_text_field: opacité couleur de la bordure pour le bloc Mettre en évidence
	 eccp_settings_custom_paragraph_border_color: valeur de la couleur de bordure après application de l'opacité sélectionné par l'utilisateur
	 eccp_settings_custom_paragraph_width_post_back_office_text_field: largeur du bloc Mettre En Évidence en back office pour les articles
	 eccp_settings_custom_paragraph_width_post_front_end_text_field: largeur du bloc Mettre En Évidence en front end pour les articles
	 eccp_settings_custom_paragraph_width_page_back_office_text_field: largeur du bloc Mettre En Évidence en back office pour les pages
	 eccp_settings_custom_paragraph_width_page_front_end_text_field: largeur du bloc Mettre En Évidence en front end pour les pages
	 eccp_settings_custom_paragraph_width_cpt_back_office_text_field: largeur du bloc Mettre En Évidence en back office pour les Custom Post Type
	 eccp_settings_custom_paragraph_width_cpt_front_end_text_field: largeur du bloc Mettre En Évidence en front end pour les les Custom Post Type
	 
	 //----------------------------------  ELEMENTOR COLOR PALETTE ----------------------------------------------------------
	 eccp_activate_synchronization_color_palette_radio_field: activer la synchronisation de la palette de couleurs Elementor avec celle de Gutenberg
	 
	 //----------------------------------  DIVI COLOR PALETTE ----------------------------------------------------------
	 eccp_activate_synchronization_divi_color_palette_radio_field: activer la synchronisation de la palette de couleurs DIVI 
	 eccp_choose_synchronization_radio_field: choix du mode de synchronization,Gutenberg vers Divi ou Divi Vers Gutenberg
	 
	  
	 //----------------------------------  CUSTOM BACK OFFICE ----------------------------------------------------------
	 eccp_settings_activate_post_featured_image_column_checkbox_field: activer une colonne & afficher l'image en avant pour les articles & CPT
	 eccp_settings_activate_page_featured_image_column_checkbox_field: activer une colonne & afficher l'image en avant pour les pages
	 eccp_settings_width_thumbnail_featured_image_text_field: lageur de la vignette pour l'image en avant
	 eccp_settings_activate_author_filter_checkbox_field: activer le filtre par auteur pour tous les types de publication
	 eccp_settings_activate_taxonomy_filter_cpt_checkbox_field: activer le filtre par catégories pour les CPT
	 eccp_settings_enable_post_cpt_date_range_filter_checkbox_field: activer le filtre par plage de date pour les articles & cPT
	 eccp_settings_enable_post_filter_publication_status_checkbox_field: activer pour les articles le filtre par statuts de publication 
	 eccp_settings_activate_publication_status_bulk actions_posts_checkbox_field: activer les options status de publication pour les actions groupé des articles
	 
	 
	 eccp_settings_activate_library_id_dimensions_size_file_column_checkbox_field: activer pour la médiathèque les colonnes ID & Dimensions & Taille du fichier
	 eccp_settings_enable_filter_dates_range_media_library_checkbox_field: activer le filtre par plage de dates pour la médiathèque en vue liste
	 eccp_settings_activate_mime_types_media_checkbox_field: autoriser le téléchargement de tous types de médias dans la médiathèque
     eccp_settings_image_alt_text_by_title_checkbox_field: définir le texte alternatif de l'image selon son titre assaini lors du téléchargement
	 eccp_settings_image_caption_according_title_checkbox_field: définir la légende de l'image selon son titre assaini lors du téléchargement
	 
	 eccp_settings_activate_users_last_login_column_checkbox_field: activer une colonne sur tous les comptes pour afficher la date de dernière connexion
	 eccp_settings_activate_users_registration_date_column_checkbox_field: activer une colonne sur tous les comptes pour afficher la date d'enregistrement utilisateurs
	 eccp_settings_allow_contributors_upload_media_checkbox_field: autoriser les contributeurs a télécharger des médias
	 
	 
	 eccp_settings_disable_language_selector_checkbox_field: Désactiver le sélecteur de langue pour le formulaire de connexion
	 eccp_error_login_custom_message_textarea_field = message personnalisé d'erreur de connexion
	 eccp_settings_disable_admin_email_request_checkbox_field: Désactiver la demande de vérification de l'adresse e-mail administrateur
	 eccp_settings_activate_custom_logo_checkbox_field: Activer la personnalisation du logo
	 eccp_settings_custom_logo_url_text_field: URL du logo personnalisé pour le formulaire de connexion
	 eccp_settings_custom_logo_width_text_field: largeur du logo personnalisé pour le formulaire de connexion
	 eccp_settings_custom_logo_height_text_field: hauteur du logo personnalisé pour le formulaire de connexion
	 eccp_settings_activate_custom_login_form_radio_field: Activer la personnalisation du formulaire de connexion
	 eccp_settings_page_login_form_background_color_text_field: couleur de fond de la page du formulaire de connexion
	 eccp_settings_page_login_form_footer_text_color_text_field: couleur du texte en pied de la page de connexion
	 eccp_settings_login_form_background_color_text_field: couleur de fond du formulaire de connexion
	 eccp_settings_login_form_text_color_text_field: couleur de texte du formulaire de connexion
	 eccp_settings_button_login_form_background_color_text_field: couleur de fond des boutons de la page de connexion
	 eccp_settings_button_login_form_border_color_text_field: couleur de la bordure des boutons de la page de connexion
	 eccp_settings_button_login_form_text_color_text_field: couleur de texte des boutons de la page de connexion
	 eccp_settings_hover_button_login_form_background_color_text_field: couleur de fond des boutons de la page de connexion au survol
	 eccp_settings_hover_button_login_form_border_color_text_field: couleur de la bordure des boutons de la page de connexion au survol
	 eccp_settings_hover_button_login_form_text_color_text_field: couleur de texte des boutons de la page de connexion au survol
	 eccp_settings_info_notice_login_form_border_color_text_field: couleur de fond pour la notice info de la page de connexion
	 eccp_settings_info_notice_login_form_background_color_text_field: couleur de la bordure gauche pour la notice info de la page de connexion
	 eccp_settings_info_notice_login_form_text_color_text_field: couleur de texte pour la notice info de la page de connexion
	 eccp_settings_error_notice_login_form_background_color_text_field: couleur de fond pour la notice d'erreur de la page de connexion
	 eccp_settings_error_notice_login_form_border_color_text_field: couleur de la bordure gauche pour la notice d'erreur de la page de connexion
	 eccp_settings_error_notice_login_form_text_color_text_field: couleur de texte pour la notice d'erreur de la page de connexion
	 eccp_settings_activate_image_background_login_page_radio_field: activer une image de fond pour la page de connexion
	 eccp_settings_custom_image_background_url_text_field: image de fond pour la page de connexion
	 eccp_settings_enable_login_page_fixed_background_image_checkbox_field: activer une image de fond fixe pour la page de connexion
	 
	 eccp_settings_enable_change_email_sender_default_checkbox_field: Activer la modification du nom de l'expéditeur et de l'adresse E-mail WordPress par défaut
	 eccp_settings_email_sender_address_text_field: Adresse email expéditeur par défaut de WordPress 
	 eccp_settings_email_sender_name_text_field: Nom Expéditeur de l'E-mail par défaut de WordPress 
     eccp_settings_enable_return_adress_correspond_from_adress_checkbox_field: activer «addresse de retour» correspond à «adresse de»
	 
	 eccp_settings_disable_default_wordpress_sitemap_checkbox_field: Désactiver le sitemap de WordPress par défaut
	 eccp_settings_activate_local_site_admin_login_loginout_link_checkbox_field: activer pour un site en local un item de menu pour une connexion/déconnexion a l'admin de WordPress
	 eccp_settings_activate_online_site_admin_login_loginout_link_checkbox_field: activer pour un site en ligne un item de menu pour une connexion/déconnexion a l'admin de WordPress
	 eccp_settings_slug_admin_login_url_text_field: slug de l'url de connexion a l'admin de WordPress pour un site en ligne
	 
	 eccp_settings_enable_back_to_top_button_checkbox_field: activer un bouton retour en haut
	 eccp_settings_margin_x_text_field: marge droite pour le positionnement du bouton retour en haut
	 eccp_settings_margin_y_text_field: marge verticale pour le positionnement du bouton retour en haut
	 eccp_settings_back_top_button_opacity_text_field: opacité du bouton retour en haut
	 eccp_settings_back_top_button_opacity_on_hover_text_field: opacité du bouton retour en haut au survol
	 eccp_settings_back_top_button_color_text_field: couleur du bouton retour en haut
	 eccp_settings_color_icon_back_to_top_button_text_field: couleur de l'icône pour le bouton retour en haut
	 eccp_settings_back_to_top_button_border_radius_text_field: rayon de bordure du bouton retour en haut
	 
     eccp_settings_enable_author_info_box_checkbox_field: activer une boite d'info auteur a la fin des articles
	 eccp_settings_border_radius_avatar_author_info_box_text_field: rayon de bordure avatar boite d'info auteur
	 eccp_settings_title_author_info_box_text_field: couleur du titre de la boite d'info
	 eccp_settings_text_author_info_box_text_field: couleur du texte de la boite d'info
	 eccp_settings_link_author_info_box_text_field: couleur des liens de la boite d'info
	 eccp_settings_background_author_info_box_text_field: couleur d'arrière plan de la boite d'info
	 eccp_settings_enable_lightbox_checkbox_field: activer la lightbox pour les articles & pages & CPT
	 
	 */
	
	// L'utilisateur a choisi sur la page de réglages général d'initialiser les valeurs 
	// de réglages par défaut du plugin
	if ($default_settings['eccp_default_setting_radio_field'] == 'yes') {
	
		//----------------------------------  PARAMÈTRES PAR DÉFAUT  ----------------------------------------------------------
		// Attention! le champ radio ne prend pas de valeur avec majuscule ni d'espace
		$default_settings['eccp_default_setting_radio_field'] = 'no';
		$default_settings['eccp_delete_data_uninstallation_radio_field'] = 'no';
		
		//----------------------------------  EDITOR COLOR PALETTE ----------------------------------------------------------
		$settings['eccp_settings_activate_customizing_color_palette_checkbox_field'] = true;
		$settings['eccp_settings_number_colors_select_field'] = '12';
		
		// Couleur N° 1
		$settings['eccp_settings_color_one_text_field'] = '#F37020';
		$settings['eccp_settings_opacity_color_one_text_field'] = '100';
		$settings['eccp_settings_name_color_one_text_field'] = 'Primary';
		$settings['eccp_settings_slug_color_one_text_field'] = 'primary';
		$settings['eccp_settings_color_one'] = '#F37020';
		// Couleur N° 2
		$settings['eccp_settings_color_two_text_field'] = '#B84331';
		$settings['eccp_settings_opacity_color_two_text_field'] = '100';
		$settings['eccp_settings_name_color_two_text_field'] = 'Secondary';
		$settings['eccp_settings_slug_color_two_text_field'] = 'secondary';
		$settings['eccp_settings_color_two'] = '#B84331';
		// Couleur N° 3
		$settings['eccp_settings_color_three_text_field'] = '#666666';
		$settings['eccp_settings_opacity_color_three_text_field'] = '100';
		$settings['eccp_settings_name_color_three_text_field'] = 'Text';
		$settings['eccp_settings_slug_color_three_text_field'] = 'text';
		$settings['eccp_settings_color_three'] = '#666666';
		// Couleur N° 4
		$settings['eccp_settings_color_four_text_field'] = '#0E6487';
		$settings['eccp_settings_opacity_color_four_text_field'] = '100';
		$settings['eccp_settings_name_color_four_text_field'] = 'Accent';
		$settings['eccp_settings_slug_color_four_text_field'] = 'accent';
		$settings['eccp_settings_color_four'] = '#0E6487';
		// Couleur N° 5
		$settings['eccp_settings_color_five_text_field'] = '#333333';
		$settings['eccp_settings_opacity_color_five_text_field'] = '100';
		$settings['eccp_settings_name_color_five_text_field'] = 'title color';
		$settings['eccp_settings_slug_color_five_text_field'] = 'title-color';
		$settings['eccp_settings_color_five'] = '#333333';
		// Couleur N° 6
		$settings['eccp_settings_color_six_text_field'] = '#F0F2F6';
		$settings['eccp_settings_opacity_color_six_text_field'] = '100';
		$settings['eccp_settings_name_color_six_text_field'] = 'light off-white';
		$settings['eccp_settings_slug_color_six_text_field'] = 'light-off-white';
		$settings['eccp_settings_color_six'] = '#F0F2F6';
		// Couleur N° 7
		$settings['eccp_settings_color_seven_text_field'] = '#E6E8ED';
		$settings['eccp_settings_opacity_color_seven_text_field'] = '100';
		$settings['eccp_settings_name_color_seven_text_field'] = 'dark off-white';
		$settings['eccp_settings_slug_color_seven_text_field'] = 'dark-off-white';
		$settings['eccp_settings_color_seven'] = '#E6E8ED';
		// Couleur N° 8
		$settings['eccp_settings_color_eight_text_field'] = '#FFFFFF';
		$settings['eccp_settings_opacity_color_eight_text_field'] = '100';
		$settings['eccp_settings_name_color_eight_text_field'] = 'white';
		$settings['eccp_settings_slug_color_eight_text_field'] = 'white';
		$settings['eccp_settings_color_eight'] = '#FFFFFF';
		// Couleur N° 9
		$settings['eccp_settings_color_nine_text_field'] = '#8FB63F';
		$settings['eccp_settings_opacity_color_nine_text_field'] = '100';
		$settings['eccp_settings_name_color_nine_text_field'] = 'green';
		$settings['eccp_settings_slug_color_nine_text_field'] = 'green';
		$settings['eccp_settings_color_nine'] = '#8FB63F';
		// Couleur N° 10
		$settings['eccp_settings_color_ten_text_field'] = '#8FB63F';
		$settings['eccp_settings_opacity_color_ten_text_field'] = '51';
		$settings['eccp_settings_name_color_ten_text_field'] = 'light green';
		$settings['eccp_settings_slug_color_ten_text_field'] = 'light-green';
		$settings['eccp_settings_color_ten'] = 'rgba(143,182,63,0.51)';
		// Couleur N° 11
		$settings['eccp_settings_color_eleven_text_field'] = '#FF0000';
		$settings['eccp_settings_opacity_color_eleven_text_field'] = '100';
		$settings['eccp_settings_name_color_eleven_text_field'] = 'red';
		$settings['eccp_settings_slug_color_eleven_text_field'] = 'red';
		$settings['eccp_settings_color_eleven'] = '#FF0000';
		// Couleur N° 12
		$settings['eccp_settings_color_twelve_text_field'] = '#F3E672';
		$settings['eccp_settings_opacity_color_twelve_text_field'] = '70';
		$settings['eccp_settings_name_color_twelve_text_field'] = 'light yellow';
		$settings['eccp_settings_slug_color_twelve_text_field'] = 'light-yellow';
		$settings['eccp_settings_color_twelve'] = 'rgba(243,230,114,0.70)';
		
		$settings['eccp_settings_disabling_custom_colors_checkbox_field'] = false;
		$settings['eccp_settings_disabling_custom_gradients_checkbox_field'] = false;
		
		//----------------------------------  EDITOR TEXT SIZE PALETTE  ----------------------------------------------------------
	    $editor_text_size_settings['eccp_settings_activate_editor_text_size_checkbox_field'] = true;
		$editor_text_size_settings['eccp_settings_small_font_size_text_field'] = '18';
		$editor_text_size_settings['eccp_settings_regular_font_size_text_field'] = '20';
		$editor_text_size_settings['eccp_settings_large_font_size_text_field'] = '24';
		$editor_text_size_settings['eccp_settings_huge_font_size_text_field'] = '30';
		$editor_text_size_settings['eccp_settings_enable_default_gutenberg_editor_font_size_checkbox_field'] = false; 
		$editor_text_size_settings['eccp_settings_default_gutenberg_editor_font_size_text_field'] = 18;
		$editor_text_size_settings['eccp_settings_disable_custom_font_size_checkbox_field'] = false;
		
		//----------------------------------  CUSTOM GUTENBERG EDITOR  ----------------------------------------------------------
	    $custom_gutenberg_editor_settings['eccp_settings_disable_fullscreen_gutenberg_editor_checkbox_field'] = false;
		$custom_gutenberg_editor_settings['eccp_settings_activate_default_style_sheet_on_front_end_checkbox_field'] = false;
		$custom_gutenberg_editor_settings['eccp_settings_activate_align_wide_block_editor_checkbox_field'] = false;
		$custom_gutenberg_editor_settings['eccp_settings_activate_responsive_embeds_checkbox_field'] = false;
		$custom_gutenberg_editor_settings['eccp_settings_post_embed_max_width_text_field'] = 640;
		$custom_gutenberg_editor_settings['eccp_settings_page_embed_max_width_text_field'] = 960;
		$custom_gutenberg_editor_settings['eccp_settings_cpt_embed_max_width_text_field'] = 640;
		$custom_gutenberg_editor_settings['eccp_corrective_according_to_theme_radio_field'] = 'no';
		$custom_gutenberg_editor_settings['eccp_settings_activate_editor_width_checkbox_field'] = false;
		$custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field'] = 696;
		$custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field'] = 1100;
		$custom_gutenberg_editor_settings['eccp_settings_post_template_editor_select_field'] = 'small';
		$custom_gutenberg_editor_settings['eccp_settings_page_template_editor_select_field'] = 'large';
		$custom_gutenberg_editor_settings['eccp_settings_cpt_template_editor_select_field'] = 'large';
		$custom_gutenberg_editor_settings['eccp_settings_page_title_alignment_select_field'] = 'center';
		
		$custom_gutenberg_editor_settings['eccp_settings_activate_support_margin_padding_checkbox_field'] = false;
		$custom_gutenberg_editor_settings['eccp_settings_activate_support_border_checkbox_field'] = false;
		
		$custom_gutenberg_editor_settings['eccp_settings_disable_webp_image_generation_checkbox_field'] = false;
		$custom_gutenberg_editor_settings['eccp_settings_disable_downloading_and_image_generation_webp_checkbox_field']= false;
		
		$custom_gutenberg_editor_settings['eccp_settings_disable_openverse_category_from_media_tab_checkbox_field'] = false;
		$custom_gutenberg_editor_settings['eccp_settings_disable_settings_styles_tabs_for_sidebar_checkbox_field'] = false;
		$custom_gutenberg_editor_settings['eccp_settings_enable_editor_background_color_checkbox_field'] = false;
		$custom_gutenberg_editor_settings['eccp_settings_editor_background_color_text_field'] = '#FFFFFF';
		
		//----------------------------------  CUSTOM GUTENBERG BLOCKS  ----------------------------------------------------------
		
		// Paramètres renseignés dans l'editeur Gutenberg a partir de la version 2.8
		//$custom_gutenberg_blocks_settings['eccp_settings_activate_box_shadow_paragraph_block_radio_field'] = 'no';
		//$custom_gutenberg_blocks_settings['eccp_settings_box_shadow_color_text_field'] ='#000000';
		//$custom_gutenberg_blocks_settings['eccp_settings_box_shadow_opacity_text_field'] = '70';
		//$custom_gutenberg_blocks_settings['eccp_settings_box_shadow_x_text_field']= 0;
		//$custom_gutenberg_blocks_settings['eccp_settings_box_shadow_y_text_field'] = 4;
		//$custom_gutenberg_blocks_settings['eccp_settings_box_shadow_blur_text_field'] = 12; 
		//$custom_gutenberg_blocks_settings['eccp_settings_box_shadow_spread_text_field'] = -8;
		
		$custom_gutenberg_blocks_settings['eccp_settings_activate_style_card_paragraph_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_question_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_icon_color_style_notice_question_text_field'] ='#666666';
		$custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_info_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_icon_color_style_notice_info_text_field'] ='#FFFFFF';
		$custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_advice_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_icon_color_style_notice_advice_text_field'] ='#FFFFFF';
		$custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_warning_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_icon_color_style_notice_warning_text_field'] ='#FFFFFF';
		$custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_alert_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_icon_color_style_notice_alert_text_field'] ='#FFFFFF';
		$custom_gutenberg_blocks_settings['eccp_settings_activate_style_click_to_tweet_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_tooltip_text_color_text_field'] = '#FFFFFF';
		$custom_gutenberg_blocks_settings['eccp_settings_tooltip_background_color_text_field'] = '#1E5A99';
		$custom_gutenberg_blocks_settings['eccp_settings_text_double_underline_color_text_field'] = '#1E5A99';
		
		
		// Paramètres renseignés dans l'editeur Gutenberg a partir de la version 2.5
		//$custom_gutenberg_blocks_settings['eccp_settings_bulleted_list_color_text_field'] = '#F37020';
		//$custom_gutenberg_blocks_settings['eccp_settings_bulleted_list_size_text_field'] = '20';
		$custom_gutenberg_blocks_settings['eccp_settings_activate_styles_bullet_list_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_name_table_of_contents_text_field'] = 'Table des matières';
		$custom_gutenberg_blocks_settings['eccp_settings_title_color_table_of_contents_text_field']='#333333';
		$custom_gutenberg_blocks_settings['eccp_settings_offset_navigation_anchors_text_field'] = 30;
		$custom_gutenberg_blocks_settings['eccp_settings_activate_underline_table_of_contents_links_on_hover_radio_field'] = 'no';
		
		$custom_gutenberg_blocks_settings['eccp_settings_activate_rectangle_shape_style_radio_field'] = 'no';
		
		$custom_gutenberg_blocks_settings['eccp_settings_caption_font_size_text_field'] = '15';
		$custom_gutenberg_blocks_settings['eccp_settings_caption_padding_text_field'] = '5';
		$custom_gutenberg_blocks_settings['eccp_settings_caption_color_text_field'] = '#FFFFFF';
		$custom_gutenberg_blocks_settings['eccp_settings_caption_background_color_text_field'] = '#D5590B';
		$custom_gutenberg_blocks_settings['eccp_settings_activate_style_image_circle_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_activate_style_image_filter_grayscale_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_activate_style_image_card_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_enable_image_size_setting_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_custom_image_width_parameter_text_field'] =720;
		$custom_gutenberg_blocks_settings['eccp_settings_custom_image_height_parameter_text_field'] = 405;
		$custom_gutenberg_blocks_settings['eccp_settings_name_new_image_size_text_field'] ='Custom';
		$custom_gutenberg_blocks_settings['eccp_settings_slug_new_image_size_text_field'] ='custom';
		$custom_gutenberg_blocks_settings['eccp_settings_image_default_link_type_select_field'] ='none';
		$custom_gutenberg_blocks_settings['eccp_settings_image_default_size_select_field'] ='medium';
		
		
		$custom_gutenberg_blocks_settings['eccp_settings_activate_button_styles_hover_radio_field'] = 'no';
		
		//Configuré dans l'editeur Gutenberg a partir de la version 2.6
		//$custom_gutenberg_blocks_settings['eccp_settings_hover_fill_style_background_color_text_field'] ='#000000';
		//$custom_gutenberg_blocks_settings['eccp_settings_hover_fill_style_backgound_color_opacity_text_field'] = '0';
		//$custom_gutenberg_blocks_settings['eccp_settings_hover_fill_style_border_color_text_field'] ='#D5590B';
		//$custom_gutenberg_blocks_settings['eccp_settings_hover_fill_style_text_color_text_field'] ='#D5590B';
		
		//Configuré dans l'editeur Gutenberg a partir de la version 2.6
		//$custom_gutenberg_blocks_settings['eccp_settings_hover_outline_style_background_color_text_field'] ='#D5590B';
		//$custom_gutenberg_blocks_settings['eccp_settings_hover_outline_style_backgound_color_opacity_text_field'] = '100';
		//$custom_gutenberg_blocks_settings['eccp_settings_hover_outline_style_border_color_text_field'] ='#D5590B';
		//$custom_gutenberg_blocks_settings['eccp_settings_hover_outline_style_text_color_text_field'] ='#FFFFFF';
		
		$custom_gutenberg_blocks_settings['eccp_settings_activate_columns_block_styles_radio_field'] = 'no';
		
		$custom_gutenberg_blocks_settings['eccp_settings_activate_media_text_block_styles_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_link_text_read_more_text_field'] = 'Read more';
		
		$custom_gutenberg_blocks_settings['eccp_settings_activate_block_styles_read_more_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_block_read_more_background_color_text_field'] ='#F37020';
		$custom_gutenberg_blocks_settings['eccp_settings_block_read_more_backgound_color_opacity_text_field'] = '100';
		$custom_gutenberg_blocks_settings['eccp_settings_block_read_more_border_color_text_field'] ='#F37020';
		$custom_gutenberg_blocks_settings['eccp_settings_block_read_more_text_color_text_field'] ='#FFFFFF';
		
		$custom_gutenberg_blocks_settings['eccp_settings_block_read_more_hover_background_color_text_field'] ='#000000';
		$custom_gutenberg_blocks_settings['eccp_settings_block_read_more_hover_backgound_color_opacity_text_field'] = '0';
		$custom_gutenberg_blocks_settings['eccp_settings_block_read_more_hover_border_color_text_field'] ='#D5590B';
		$custom_gutenberg_blocks_settings['eccp_settings_block_read_more_hover_text_color_text_field'] ='#D5590B';
		
		$custom_gutenberg_blocks_settings['eccp_settings_activate_block_styles_table_radio_field']= 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_activate_reponsive_tables_radio_field']= 'no';
		
		$custom_gutenberg_blocks_settings['eccp_settings_activate_card_style_latest_posts_block_radio_field']= 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_activate_hover_zoom_style_latest_posts_block_radio_field']= 'no';
		
		$custom_gutenberg_blocks_settings['eccp_settings_activate_card_style_query_loop_block_radio_field']= 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_activate_custom_avatar_radio_field']= 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_custom_avatar_url_text_field'] ='';
		$custom_gutenberg_blocks_settings['eccp_settings_custom_avatar_size_text_field'] =48;
		$custom_gutenberg_blocks_settings['eccp_settings_activate_hover_zoom_style_query_loop_block_radio_field']= 'no';

		$custom_gutenberg_blocks_settings['eccp_settings_turn_yoast_faq_block_an_accordion_radio_field']= 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_width_block_faq_yoast_text_field'] =100;

		$custom_gutenberg_blocks_settings['eccp_settings_enable_script_js_css_swiper_radio_field']= 'no';

		$custom_gutenberg_blocks_settings['eccp_settings_activate_script_reactjs_radio_field']= 'no';
		//----------------------------------  ADDONS REUSABLE BLOCKS  ----------------------------------------------------------
		$reusable_blocks_settings['eccp_activate_reusable_blocks_menu_checkbox_field'] = false;
		
		$reusable_blocks_settings['eccp_activate_reusable_blocks_shortcode_checkbox_field'] = false;
		
		$reusable_blocks_settings['eccp_settings_insert_block_before_post_select_field']= '';
		$reusable_blocks_settings['eccp_settings_insert_block_after_post_select_field']= '';
		$reusable_blocks_settings['eccp_settings_insert_block_before_page_select_field']= '';
		$reusable_blocks_settings['eccp_settings_insert_block_after_page_select_field']= '';
		$reusable_blocks_settings['eccp_settings_insert_block_before_cpt_select_field']= '';
		$reusable_blocks_settings['eccp_settings_insert_block_after_cpt_select_field']= '';
		
		$reusable_blocks_settings['eccp_settings_quotation_marks_color_text_field'] ='#F37020';   
		$reusable_blocks_settings['eccp_settings_quotation_marks_opacity_text_field'] = '60';
		//$reusable_blocks_settings['eccp_settings_font_weight_blockquote_select_field'] = '700';
		//$reusable_blocks_settings['eccp_settings_font_size_blockquote_text_field'] = '20';
		$reusable_blocks_settings['eccp_settings_width_blockquote_post_back_office_text_field'] = '74';
		$reusable_blocks_settings['eccp_settings_width_blockquote_post_front_end_text_field'] = '70';
		$reusable_blocks_settings['eccp_settings_width_blockquote_page_back_office_text_field'] = '60';
		$reusable_blocks_settings['eccp_settings_width_blockquote_page_front_end_text_field'] = '62';
		$reusable_blocks_settings['eccp_settings_width_blockquote_cpt_back_office_text_field'] = '60';
		$reusable_blocks_settings['eccp_settings_width_blockquote_cpt_front_end_text_field'] = '61';
		$reusable_blocks_settings['eccp_settings_custom_paragraph_border_color_text_field'] = '#F37020';
		$reusable_blocks_settings['eccp_settings_opacity_custom_paragraph_border_color_text_field'] = '70';
		$reusable_blocks_settings['eccp_settings_custom_paragraph_border_color'] = 'rgba(243,112,32,0.7)';
		$reusable_blocks_settings['eccp_settings_custom_paragraph_width_post_back_office_text_field'] = '95';
		$reusable_blocks_settings['eccp_settings_custom_paragraph_width_post_front_end_text_field'] = '100';
		$reusable_blocks_settings['eccp_settings_custom_paragraph_width_page_back_office_text_field'] = '60';
		$reusable_blocks_settings['eccp_settings_custom_paragraph_width_page_front_end_text_field'] = '62';
		$reusable_blocks_settings['eccp_settings_custom_paragraph_width_cpt_back_office_text_field'] = '55';
		$reusable_blocks_settings['eccp_settings_custom_paragraph_width_cpt_front_end_text_field'] = '62';
		
		//----------------------------------  ELEMENTOR COLOR PALETTE  ----------------------------------------------------------
		$elementor_settings['eccp_activate_synchronization_color_palette_radio_field'] = 'no';
		
		//----------------------------------  DIVI COLOR PALETTE ----------------------------------------------------------
		$divi_settings['eccp_activate_synchronization_divi_color_palette_radio_field'] = 'no';
		$divi_settings['eccp_choose_synchronization_radio_field'] = 'synchro-gutenberg-to-divi';
		
		//----------------------------------  CUSTOM BACK OFFICE ----------------------------------------------------------
		$custom_back_office_settings['eccp_settings_activate_post_featured_image_column_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_activate_page_featured_image_column_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_width_thumbnail_featured_image_text_field']= 160;
		$custom_back_office_settings['eccp_settings_activate_author_filter_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_activate_taxonomy_filter_cpt_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_enable_post_cpt_date_range_filter_checkbox_field'] = false;
		$custom_back_office_settings['eccp_settings_enable_post_filter_publication_status_checkbox_field'] = false;
		$custom_back_office_settings['eccp_settings_activate_publication_status_bulk_actions_posts_checkbox_field'] = false;
		
		$custom_back_office_settings['eccp_settings_activate_library_id_dimensions_size_file_column_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_enable_filter_dates_range_media_library_checkbox_field'] = false;
		$custom_back_office_settings['eccp_settings_activate_mime_types_media_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_image_alt_text_by_title_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_image_caption_according_title_checkbox_field']= false;
		
		$custom_back_office_settings['eccp_settings_activate_users_last_login_column_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_activate_users_registration_date_column_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_allow_contributors_upload_media_checkbox_field']= false;
		
		
		$custom_back_office_settings['eccp_settings_disable_language_selector_checkbox_field']= false;
		$custom_back_office_settings['eccp_error_login_custom_message_textarea_field'] = 'Vous avez saisi un nom d\'utilisateur ou un mot de passe non valide!';
		$custom_back_office_settings['eccp_settings_disable_admin_email_request_checkbox_field'] = false;
		$custom_back_office_settings['eccp_settings_activate_custom_logo_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_custom_logo_url_text_field']='';
		$custom_back_office_settings['eccp_settings_custom_logo_width_text_field'] = 318;
		$custom_back_office_settings['eccp_settings_custom_logo_height_text_field'] = 96;
		$custom_back_office_settings['eccp_settings_activate_custom_login_form_radio_field']= 'no';
		$custom_back_office_settings['eccp_settings_page_login_form_background_color_text_field'] = '#F0F0F1';
		$custom_back_office_settings['eccp_settings_page_login_form_footer_text_color_text_field'] = '#333333';
		$custom_back_office_settings['eccp_settings_login_form_background_color_text_field'] = '#EAE672';
		$custom_back_office_settings['eccp_settings_login_form_text_color_text_field'] = '#333333';
		$custom_back_office_settings['eccp_settings_button_login_form_background_color_text_field'] ='#F0AD4E';
		$custom_back_office_settings['eccp_settings_button_login_form_border_color_text_field'] ='#F0AD4E';
		$custom_back_office_settings['eccp_settings_button_login_form_text_color_text_field'] ='#FFFFFF';
		$custom_back_office_settings['eccp_settings_hover_button_login_form_background_color_text_field'] ='#EC971F';
		$custom_back_office_settings['eccp_settings_hover_button_login_form_border_color_text_field'] ='#EC971F';
		$custom_back_office_settings['eccp_settings_hover_button_login_form_text_color_text_field'] ='#FFFFFF';
		$custom_back_office_settings['eccp_settings_info_notice_login_form_background_color_text_field'] = '#B0E0E6';
		$custom_back_office_settings['eccp_settings_info_notice_login_form_border_color_text_field'] = '#00A0D2';
		$custom_back_office_settings['eccp_settings_info_notice_login_form_text_color_text_field'] = '#333333';
		$custom_back_office_settings['eccp_settings_error_notice_login_form_background_color_text_field'] = '#FA8072';
		$custom_back_office_settings['eccp_settings_error_notice_login_form_border_color_text_field'] = '#F23C3C';
		$custom_back_office_settings['eccp_settings_error_notice_login_form_text_color_text_field'] = '#333333';
		$custom_back_office_settings['eccp_settings_activate_image_background_login_page_radio_field']= 'no';
		$custom_back_office_settings['eccp_settings_custom_image_background_url_text_field']='';
		$custom_back_office_settings['eccp_settings_enable_login_page_fixed_background_image_checkbox_field']= false;
		
		$custom_back_office_settings['eccp_settings_enable_change_email_sender_default_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_email_sender_address_text_field'] = 'contact@les-paniers-bio.fr';
		$custom_back_office_settings['eccp_settings_email_sender_name_text_field'] = 'LES PANIERS BIO';
		$custom_back_office_settings['eccp_settings_enable_return_adress_correspond_from_adress_checkbox_field']= false;
		
		
		$custom_back_office_settings['eccp_settings_disable_default_wordpress_sitemap_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_activate_local_site_admin_login_loginout_link_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_activate_online_site_admin_login_loginout_link_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_slug_admin_login_url_text_field']='wp-admin';
		
		$custom_front_end_settings['eccp_settings_enable_back_to_top_button_checkbox_field']= false;
		$custom_front_end_settings ['eccp_settings_margin_x_text_field'] = 20;
		$custom_front_end_settings ['eccp_settings_margin_y_text_field'] = 20;
		$custom_front_end_settings ['eccp_settings_back_top_button_opacity_text_field'] = 50;
		$custom_front_end_settings ['eccp_settings_back_top_button_opacity_on_hover_text_field'] = 70;
		$custom_front_end_settings['eccp_settings_back_top_button_color_text_field'] = '#2271B1';
		$custom_front_end_settings['eccp_settings_color_icon_back_to_top_button_text_field'] = '#FFFFFF';
		$custom_front_end_settings['eccp_settings_back_to_top_button_border_radius_text_field']= 4;
		
		$custom_front_end_settings['eccp_settings_enable_author_info_box_checkbox_field']= false;
		$custom_front_end_settings['eccp_settings_border_radius_avatar_author_info_box_text_field']= 0;
		$custom_front_end_settings['eccp_settings_title_author_info_box_text_field'] = '#222222';
		$custom_front_end_settings['eccp_settings_text_author_info_box_text_field'] = '#666666';
		$custom_front_end_settings['eccp_settings_link_author_info_box_text_field'] = '#0E6487';
		$custom_front_end_settings['eccp_settings_background_author_info_box_text_field'] = '#F5F5F5';
		$custom_front_end_settings['eccp_settings_enable_lightbox_checkbox_field']= false;
		
		//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
		update_option( 'eccp_settings_default_settings', $default_settings, '', 'yes' );
		update_option( 'eccp_multiple_setting', $settings, '', 'yes' );
		update_option( 'eccp_setting_editor_text_size', $editor_text_size_settings, '', 'yes' );
		update_option( 'eccp_settings_custom_gutenberg_editor', $custom_gutenberg_editor_settings, '', 'yes' );
		update_option( 'eccp_settings_custom_gutenberg_block', $custom_gutenberg_blocks_settings, '', 'yes' );
		update_option( 'eccp_settings_reusable_blocks', $reusable_blocks_settings, '', 'yes' );
		update_option( 'eccp_settings_elementor', $elementor_settings, '', 'yes' );
		update_option( 'eccp_settings_divi_theme', $divi_settings, '', 'yes' );
		update_option( 'eccp_settings_custom_back_office',  $custom_back_office_settings, '', 'yes' );
	
	}
	

});

 
/*----------------------------------------------------------------------------*
 *           4. Actions a réaliser à l'activation du Plugin
 *----------------------------------------------------------------------------*/
 

/* A l'activation du plugin on ajoute dans la table wp_options pour les champs:
   option_name = ecpp_multiple_setting  les réglages par défaut du plugin sous forme d'un tableau 
*/
function eccp_editor_custom_color_palette_activate() {
	
   // On récupère les paramètres général de réglages du plugin
   $settings  = get_option( 'ecpp_multiple_setting' );
  
   // on n'initialise pas le plugin aux valeurs de réglages par défaut 
   // si l'utilisateur a déjà paramétré le plugin
   // cas ou l'utilisateur a désactivé puis réactivé le plugin
   if ( empty( $settings ) ) {
	   
		//----------------------------------  PARAMÈTRES PAR DÉFAUT  ----------------------------------------------------------
		// Attention! le champ radio ne prend pas de valeur avec majuscule ni d'espace
		$default_settings['eccp_default_setting_radio_field'] = 'no';
		$default_settings['eccp_delete_data_uninstallation_radio_field'] = 'no';
	    
		//----------------------------------  EDITOR COLOR PALETTE ----------------------------------------------------------
	    $settings['eccp_settings_activate_customizing_color_palette_checkbox_field'] = true;
		$settings['eccp_settings_number_colors_select_field'] = '12';
		
		// Couleur N° 1
		$settings['eccp_settings_color_one_text_field'] = '#F37020';
		$settings['eccp_settings_opacity_color_one_text_field'] = '100';
		$settings['eccp_settings_name_color_one_text_field'] = 'Primary';
		$settings['eccp_settings_slug_color_one_text_field'] = 'primary';
		$settings['eccp_settings_color_one'] = '#F37020';
	    // Couleur N° 2
		$settings['eccp_settings_color_two_text_field'] = '#B84331';
		$settings['eccp_settings_opacity_color_two_text_field'] = '100';
		$settings['eccp_settings_name_color_two_text_field'] = 'Secondary';
		$settings['eccp_settings_slug_color_two_text_field'] = 'secondary';
		$settings['eccp_settings_color_two'] = '#B84331';
				// Couleur N° 3
		$settings['eccp_settings_color_three_text_field'] = '#666666';
		$settings['eccp_settings_opacity_color_three_text_field'] = '100';
		$settings['eccp_settings_name_color_three_text_field'] = 'Text';
		$settings['eccp_settings_slug_color_three_text_field'] = 'text';
		$settings['eccp_settings_color_three'] = '#666666';
		// Couleur N° 4
		$settings['eccp_settings_color_four_text_field'] = '#0E6487';
		$settings['eccp_settings_opacity_color_four_text_field'] = '100';
		$settings['eccp_settings_name_color_four_text_field'] = 'Accent';
		$settings['eccp_settings_slug_color_four_text_field'] = 'accent';
		$settings['eccp_settings_color_four'] = '#0E6487';
		// Couleur N° 5
		$settings['eccp_settings_color_five_text_field'] = '#333333';
		$settings['eccp_settings_opacity_color_five_text_field'] = '100';
		$settings['eccp_settings_name_color_five_text_field'] = 'title color';
		$settings['eccp_settings_slug_color_five_text_field'] = 'title-color';
		$settings['eccp_settings_color_five'] = '#333333';
		// Couleur N° 6
		$settings['eccp_settings_color_six_text_field'] = '#F0F2F6';
		$settings['eccp_settings_opacity_color_six_text_field'] = '100';
		$settings['eccp_settings_name_color_six_text_field'] = 'light off-white';
		$settings['eccp_settings_slug_color_six_text_field'] = 'light-off-white';
		$settings['eccp_settings_color_six'] = '#F0F2F6';
		// Couleur N° 7
		$settings['eccp_settings_color_seven_text_field'] = '#E6E8ED';
		$settings['eccp_settings_opacity_color_seven_text_field'] = '100';
		$settings['eccp_settings_name_color_seven_text_field'] = 'dark off-white';
		$settings['eccp_settings_slug_color_seven_text_field'] = 'dark-off-white';
		$settings['eccp_settings_color_seven'] = '#E6E8ED';
		// Couleur N° 8
		$settings['eccp_settings_color_eight_text_field'] = '#FFFFFF';
		$settings['eccp_settings_opacity_color_eight_text_field'] = '100';
		$settings['eccp_settings_name_color_eight_text_field'] = 'white';
		$settings['eccp_settings_slug_color_eight_text_field'] = 'white';
		$settings['eccp_settings_color_eight'] = '#FFFFFF';
		// Couleur N° 9
		$settings['eccp_settings_color_nine_text_field'] = '#8FB63F';
		$settings['eccp_settings_opacity_color_nine_text_field'] = '100';
		$settings['eccp_settings_name_color_nine_text_field'] = 'green';
		$settings['eccp_settings_slug_color_nine_text_field'] = 'green';
		$settings['eccp_settings_color_nine'] = '#8FB63F';
		// Couleur N° 10
		$settings['eccp_settings_color_ten_text_field'] = '#8FB63F';
		$settings['eccp_settings_opacity_color_ten_text_field'] = '51';
		$settings['eccp_settings_name_color_ten_text_field'] = 'light green';
		$settings['eccp_settings_slug_color_ten_text_field'] = 'light-green';
		$settings['eccp_settings_color_ten'] = 'rgba(143,182,63,0.51)';
		// Couleur N° 11
		$settings['eccp_settings_color_eleven_text_field'] = '#FF0000';
		$settings['eccp_settings_opacity_color_eleven_text_field'] = '100';
		$settings['eccp_settings_name_color_eleven_text_field'] = 'red';
		$settings['eccp_settings_slug_color_eleven_text_field'] = 'red';
		$settings['eccp_settings_color_eleven'] = '#FF0000';
		// Couleur N° 12
		$settings['eccp_settings_color_twelve_text_field'] = '#F3E672';
		$settings['eccp_settings_opacity_color_twelve_text_field'] = '70';
		$settings['eccp_settings_name_color_twelve_text_field'] = 'light yellow';
		$settings['eccp_settings_slug_color_twelve_text_field'] = 'light-yellow';
		$settings['eccp_settings_color_twelve'] = 'rgba(243,230,114,0.70)';
		
		$settings['eccp_settings_disabling_custom_colors_checkbox_field'] = false;
		$settings['eccp_settings_disabling_custom_gradients_checkbox_field'] = false;
		
		//----------------------------------  EDITOR TEXT SIZE PALETTE ----------------------------------------------------------
		$editor_text_size_settings['eccp_settings_activate_editor_text_size_checkbox_field'] = true;
		$editor_text_size_settings['eccp_settings_small_font_size_text_field'] = '18';
		$editor_text_size_settings['eccp_settings_regular_font_size_text_field'] = '20';
		$editor_text_size_settings['eccp_settings_large_font_size_text_field'] = '24';
		$editor_text_size_settings['eccp_settings_huge_font_size_text_field'] = '30';
		$editor_text_size_settings['eccp_settings_enable_default_gutenberg_editor_font_size_checkbox_field'] = false;
		$editor_text_size_settings['eccp_settings_default_gutenberg_editor_font_size_text_field'] = 18;
		$editor_text_size_settings['eccp_settings_disable_custom_font_size_checkbox_field'] = false;
	   
	    //----------------------------------  CUSTOM GUTENBERG EDITOR  ----------------------------------------------------------
	    $custom_gutenberg_editor_settings['eccp_settings_disable_fullscreen_gutenberg_editor_checkbox_field'] = false;
		$custom_gutenberg_editor_settings['eccp_settings_activate_default_style_sheet_on_front_end_checkbox_field'] = false;
		$custom_gutenberg_editor_settings['eccp_settings_activate_align_wide_block_editor_checkbox_field'] = false;
		$custom_gutenberg_editor_settings['eccp_settings_activate_responsive_embeds_checkbox_field'] = false;
		$custom_gutenberg_editor_settings['eccp_settings_post_embed_max_width_text_field'] = 640;
		$custom_gutenberg_editor_settings['eccp_settings_page_embed_max_width_text_field'] = 960;
		$custom_gutenberg_editor_settings['eccp_settings_cpt_embed_max_width_text_field'] = 640;
		$custom_gutenberg_editor_settings['eccp_corrective_according_to_theme_radio_field'] = 'no';
		$custom_gutenberg_editor_settings['eccp_settings_activate_editor_width_checkbox_field'] = false;
		$custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field'] = 696;
		$custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field'] = 1100;
		$custom_gutenberg_editor_settings['eccp_settings_post_template_editor_select_field'] = 'small';
		$custom_gutenberg_editor_settings['eccp_settings_page_template_editor_select_field'] = 'large';
		$custom_gutenberg_editor_settings['eccp_settings_cpt_template_editor_select_field'] = 'large';
		$custom_gutenberg_editor_settings['eccp_settings_page_title_alignment_select_field'] = 'center';
		
		$custom_gutenberg_editor_settings['eccp_settings_activate_support_margin_padding_checkbox_field'] = false;
		$custom_gutenberg_editor_settings['eccp_settings_activate_support_border_checkbox_field'] = false;
		
		$custom_gutenberg_editor_settings['eccp_settings_disable_webp_image_generation_checkbox_field'] = false;
		$custom_gutenberg_editor_settings['eccp_settings_disable_downloading_and_image_generation_webp_checkbox_field']= false;
		
		$custom_gutenberg_editor_settings['eccp_settings_disable_openverse_category_from_media_tab_checkbox_field'] = false;
		$custom_gutenberg_editor_settings['eccp_settings_disable_settings_styles_tabs_for_sidebar_checkbox_field'] = false;
		$custom_gutenberg_editor_settings['eccp_settings_enable_editor_background_color_checkbox_field'] = false;
		$custom_gutenberg_editor_settings['eccp_settings_editor_background_color_text_field'] = '#FFFFFF';
		
		//----------------------------------  CUSTOM GUTENBERG BLOCKS  ----------------------------------------------------------
		
		// Paramètres renseignés dans l'editeur Gutenberg a partir de la version 2.8
		//$custom_gutenberg_blocks_settings['eccp_settings_activate_box_shadow_paragraph_block_radio_field'] = 'no';
		//$custom_gutenberg_blocks_settings['eccp_settings_box_shadow_color_text_field'] ='#000000';
		//$custom_gutenberg_blocks_settings['eccp_settings_box_shadow_opacity_text_field'] = '70';
		//$custom_gutenberg_blocks_settings['eccp_settings_box_shadow_x_text_field']= 0;
		//$custom_gutenberg_blocks_settings['eccp_settings_box_shadow_y_text_field'] = 4;
		//$custom_gutenberg_blocks_settings['eccp_settings_box_shadow_blur_text_field'] = 12; 
		//$custom_gutenberg_blocks_settings['eccp_settings_box_shadow_spread_text_field'] = -8;
		
		$custom_gutenberg_blocks_settings['eccp_settings_activate_style_card_paragraph_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_question_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_icon_color_style_notice_question_text_field'] ='#666666';
		$custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_info_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_icon_color_style_notice_info_text_field'] ='#FFFFFF';
		$custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_advice_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_icon_color_style_notice_advice_text_field'] ='#FFFFFF';
		$custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_warning_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_icon_color_style_notice_warning_text_field'] ='#FFFFFF';
		$custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_alert_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_icon_color_style_notice_alert_text_field'] ='#FFFFFF';
		$custom_gutenberg_blocks_settings['eccp_settings_activate_style_click_to_tweet_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_tooltip_text_color_text_field'] ='#FFFFFF';
		$custom_gutenberg_blocks_settings['eccp_settings_tooltip_background_color_text_field'] = '#1E5A99';
		$custom_gutenberg_blocks_settings['eccp_settings_text_double_underline_color_text_field'] = '#1E5A99';
		
		// Paramètres renseignés dans l'editeur Gutenberg a partir de la version 2.5
		//$custom_gutenberg_blocks_settings['eccp_settings_bulleted_list_color_text_field'] = '#F37020';
		//$custom_gutenberg_blocks_settings['eccp_settings_bulleted_list_size_text_field'] = '20';
		$custom_gutenberg_blocks_settings['eccp_settings_activate_styles_bullet_list_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_name_table_of_contents_text_field'] = 'Table des matières';
		$custom_gutenberg_blocks_settings['eccp_settings_title_color_table_of_contents_text_field']='#333333';
		$custom_gutenberg_blocks_settings['eccp_settings_offset_navigation_anchors_text_field'] = 20;
		$custom_gutenberg_blocks_settings['eccp_settings_activate_underline_table_of_contents_links_on_hover_radio_field'] = 'no';
		
		$custom_gutenberg_blocks_settings['eccp_settings_activate_rectangle_shape_style_radio_field'] = 'no';
		
		$custom_gutenberg_blocks_settings['eccp_settings_caption_font_size_text_field'] = '15';
		$custom_gutenberg_blocks_settings['eccp_settings_caption_padding_text_field'] = '5';
		$custom_gutenberg_blocks_settings['eccp_settings_caption_color_text_field'] = '#FFFFFF';
		$custom_gutenberg_blocks_settings['eccp_settings_caption_background_color_text_field'] = '#D5590B';
		$custom_gutenberg_blocks_settings['eccp_settings_activate_style_image_circle_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_activate_style_image_filter_grayscale_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_activate_style_image_card_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_enable_image_size_setting_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_custom_image_width_parameter_text_field'] =720;
		$custom_gutenberg_blocks_settings['eccp_settings_custom_image_height_parameter_text_field'] = 405;
		$custom_gutenberg_blocks_settings['eccp_settings_name_new_image_size_text_field'] ='Custom';
		$custom_gutenberg_blocks_settings['eccp_settings_slug_new_image_size_text_field'] ='custom';
		$custom_gutenberg_blocks_settings['eccp_settings_image_default_link_type_select_field'] ='none';
		$custom_gutenberg_blocks_settings['eccp_settings_image_default_size_select_field'] ='medium';
		
		$custom_gutenberg_blocks_settings['eccp_settings_activate_button_styles_hover_radio_field'] = 'no';
		
		//Configuré dans l'editeur Gutenberg a partir de la version 2.6
		//$custom_gutenberg_blocks_settings['eccp_settings_hover_fill_style_background_color_text_field'] ='#000000';
		//$custom_gutenberg_blocks_settings['eccp_settings_hover_fill_style_backgound_color_opacity_text_field'] = '0';
		//$custom_gutenberg_blocks_settings['eccp_settings_hover_fill_style_border_color_text_field'] ='#D5590B';
		//$custom_gutenberg_blocks_settings['eccp_settings_hover_fill_style_text_color_text_field'] ='#D5590B';
		
		//Configuré dans l'editeur Gutenberg a partir de la version 2.6
		//$custom_gutenberg_blocks_settings['eccp_settings_hover_outline_style_background_color_text_field'] ='#D5590B';
		//$custom_gutenberg_blocks_settings['eccp_settings_hover_outline_style_backgound_color_opacity_text_field'] = '100';
		//$custom_gutenberg_blocks_settings['eccp_settings_hover_outline_style_border_color_text_field'] ='#D5590B';
		//$custom_gutenberg_blocks_settings['eccp_settings_hover_outline_style_text_color_text_field'] ='#FFFFFF';
		
		$custom_gutenberg_blocks_settings['eccp_settings_activate_columns_block_styles_radio_field'] = 'no';
		
		$custom_gutenberg_blocks_settings['eccp_settings_activate_media_text_block_styles_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_link_text_read_more_text_field'] = 'Read more';
		
		$custom_gutenberg_blocks_settings['eccp_settings_activate_block_styles_read_more_radio_field'] = 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_block_read_more_background_color_text_field'] ='#F37020';
		$custom_gutenberg_blocks_settings['eccp_settings_block_read_more_backgound_color_opacity_text_field'] = '100';
		$custom_gutenberg_blocks_settings['eccp_settings_block_read_more_border_color_text_field'] ='#F37020';
		$custom_gutenberg_blocks_settings['eccp_settings_block_read_more_text_color_text_field'] ='#FFFFFF';
		
		$custom_gutenberg_blocks_settings['eccp_settings_block_read_more_hover_background_color_text_field'] ='#000000';
		$custom_gutenberg_blocks_settings['eccp_settings_block_read_more_hover_backgound_color_opacity_text_field'] = '0';
		$custom_gutenberg_blocks_settings['eccp_settings_block_read_more_hover_border_color_text_field'] ='#D5590B';
		$custom_gutenberg_blocks_settings['eccp_settings_block_read_more_hover_text_color_text_field'] ='#D5590B';
		
		$custom_gutenberg_blocks_settings['eccp_settings_activate_block_styles_table_radio_field']= 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_activate_reponsive_tables_radio_field']= 'no';
		
		$custom_gutenberg_blocks_settings['eccp_settings_activate_card_style_latest_posts_block_radio_field']= 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_activate_hover_zoom_style_latest_posts_block_radio_field']= 'no';
		
		$custom_gutenberg_blocks_settings['eccp_settings_activate_card_style_query_loop_block_radio_field']= 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_activate_custom_avatar_radio_field']= 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_custom_avatar_url_text_field'] ='';
		$custom_gutenberg_blocks_settings['eccp_settings_custom_avatar_size_text_field'] =48;
		$custom_gutenberg_blocks_settings['eccp_settings_activate_hover_zoom_style_query_loop_block_radio_field']= 'no';
		
		$custom_gutenberg_blocks_settings['eccp_settings_turn_yoast_faq_block_an_accordion_radio_field']= 'no';
		$custom_gutenberg_blocks_settings['eccp_settings_width_block_faq_yoast_text_field'] =100;
		
		$custom_gutenberg_blocks_settings['eccp_settings_enable_script_js_css_swiper_radio_field']= 'no';
		
		$custom_gutenberg_blocks_settings['eccp_settings_activate_script_reactjs_radio_field']= 'no';
		//----------------------------------  ADDONS REUSABLE BLOCKS  ----------------------------------------------------------
		$reusable_blocks_settings['eccp_activate_reusable_blocks_menu_checkbox_field'] = false;
		
		$reusable_blocks_settings['eccp_activate_reusable_blocks_shortcode_checkbox_field'] = false;
		
		$reusable_blocks_settings['eccp_settings_insert_block_before_post_select_field']= '';
		$reusable_blocks_settings['eccp_settings_insert_block_after_post_select_field']= '';
		$reusable_blocks_settings['eccp_settings_insert_block_before_page_select_field']= '';
		$reusable_blocks_settings['eccp_settings_insert_block_after_page_select_field']= '';
		$reusable_blocks_settings['eccp_settings_insert_block_before_cpt_select_field']= '';
		$reusable_blocks_settings['eccp_settings_insert_block_after_cpt_select_field']= '';
		
		$reusable_blocks_settings['eccp_settings_quotation_marks_color_text_field'] ='#F37020';   
		$reusable_blocks_settings['eccp_settings_quotation_marks_opacity_text_field'] = '60';
		//$reusable_blocks_settings['eccp_settings_font_weight_blockquote_select_field'] = '700';
		//$reusable_blocks_settings['eccp_settings_font_size_blockquote_text_field'] = '20';
		$reusable_blocks_settings['eccp_settings_width_blockquote_post_back_office_text_field'] = '74';
		$reusable_blocks_settings['eccp_settings_width_blockquote_post_front_end_text_field'] = '70';
		$reusable_blocks_settings['eccp_settings_width_blockquote_page_back_office_text_field'] = '60';
		$reusable_blocks_settings['eccp_settings_width_blockquote_page_front_end_text_field'] = '62';
		$reusable_blocks_settings['eccp_settings_width_blockquote_cpt_back_office_text_field'] = '60';
		$reusable_blocks_settings['eccp_settings_width_blockquote_cpt_front_end_text_field'] = '61';
		$reusable_blocks_settings['eccp_settings_custom_paragraph_border_color_text_field'] = '#F37020';
		$reusable_blocks_settings['eccp_settings_opacity_custom_paragraph_border_color_text_field'] = '70';
		$reusable_blocks_settings['eccp_settings_custom_paragraph_border_color'] = 'rgba(243,112,32,0.7)';
		$reusable_blocks_settings['eccp_settings_custom_paragraph_width_post_back_office_text_field'] = '95';
		$reusable_blocks_settings['eccp_settings_custom_paragraph_width_post_front_end_text_field'] = '100';
		$reusable_blocks_settings['eccp_settings_custom_paragraph_width_page_back_office_text_field'] = '60';
		$reusable_blocks_settings['eccp_settings_custom_paragraph_width_page_front_end_text_field'] = '62';
		$reusable_blocks_settings['eccp_settings_custom_paragraph_width_cpt_back_office_text_field'] = '55';
		$reusable_blocks_settings['eccp_settings_custom_paragraph_width_cpt_front_end_text_field'] = '62';
		
		//----------------------------------  ELEMENTOR COLOR PALETTE  ----------------------------------------------------------
		$elementor_settings['eccp_activate_synchronization_color_palette_radio_field'] = 'no';
		
		//----------------------------------  DIVI COLOR PALETTE ----------------------------------------------------------
		$divi_settings['eccp_activate_synchronization_divi_color_palette_radio_field'] = 'no';
		$divi_settings['eccp_choose_synchronization_radio_field'] = 'synchro-gutenberg-to-divi';
		
		//----------------------------------  CUSTOM BACK OFFICE ----------------------------------------------------------
		$custom_back_office_settings['eccp_settings_activate_post_featured_image_column_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_activate_page_featured_image_column_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_width_thumbnail_featured_image_text_field']= 160;
		$custom_back_office_settings['eccp_settings_activate_author_filter_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_activate_taxonomy_filter_cpt_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_enable_post_cpt_date_range_filter_checkbox_field'] = false;
		$custom_back_office_settings['eccp_settings_enable_post_filter_publication_status_checkbox_field'] = false;
		$custom_back_office_settings['eccp_settings_activate_publication_status_bulk_actions_posts_checkbox_field'] = false;
		
		$custom_back_office_settings['eccp_settings_activate_library_id_dimensions_size_file_column_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_enable_filter_dates_range_media_library_checkbox_field'] = false;
	    $custom_back_office_settings['eccp_settings_activate_mime_types_media_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_image_alt_text_by_title_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_image_caption_according_title_checkbox_field']= false;
		
		$custom_back_office_settings['eccp_settings_activate_users_last_login_column_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_activate_users_registration_date_column_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_allow_contributors_upload_media_checkbox_field']= false;
		
		
		$custom_back_office_settings['eccp_settings_disable_language_selector_checkbox_field']= false;
		$custom_back_office_settings['eccp_error_login_custom_message_textarea_field'] = 'Vous avez saisi un nom d\'utilisateur ou un mot de passe non valide!';
		$custom_back_office_settings['eccp_settings_disable_admin_email_request_checkbox_field'] = false;
		$custom_back_office_settings['eccp_settings_activate_custom_logo_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_custom_logo_url_text_field']='';
		$custom_back_office_settings['eccp_settings_custom_logo_width_text_field'] = 318;
		$custom_back_office_settings['eccp_settings_custom_logo_height_text_field'] = 96;
		$custom_back_office_settings['eccp_settings_activate_custom_login_form_radio_field']= 'no';
		$custom_back_office_settings['eccp_settings_page_login_form_background_color_text_field'] = '#F0F0F1';
		$custom_back_office_settings['eccp_settings_page_login_form_footer_text_color_text_field'] = '#333333';
		$custom_back_office_settings['eccp_settings_login_form_background_color_text_field'] = '#EAE672';
		$custom_back_office_settings['eccp_settings_login_form_text_color_text_field'] = '#333333';
		$custom_back_office_settings['eccp_settings_button_login_form_background_color_text_field'] ='#F0AD4E';
		$custom_back_office_settings['eccp_settings_button_login_form_border_color_text_field'] ='#F0AD4E';
		$custom_back_office_settings['eccp_settings_button_login_form_text_color_text_field'] ='#FFFFFF';
		$custom_back_office_settings['eccp_settings_hover_button_login_form_background_color_text_field'] ='#EC971F';
		$custom_back_office_settings['eccp_settings_hover_button_login_form_border_color_text_field'] ='#EC971F';
		$custom_back_office_settings['eccp_settings_hover_button_login_form_text_color_text_field'] ='#FFFFFF';
		$custom_back_office_settings['eccp_settings_info_notice_login_form_background_color_text_field'] = '#B0E0E6';
		$custom_back_office_settings['eccp_settings_info_notice_login_form_border_color_text_field'] = '#00A0D2';
		$custom_back_office_settings['eccp_settings_info_notice_login_form_text_color_text_field'] = '#333333';
		$custom_back_office_settings['eccp_settings_error_notice_login_form_background_color_text_field'] = '#FA8072';
		$custom_back_office_settings['eccp_settings_error_notice_login_form_border_color_text_field'] = '#F23C3C';
		$custom_back_office_settings['eccp_settings_error_notice_login_form_text_color_text_field'] = '#333333';
		$custom_back_office_settings['eccp_settings_activate_image_background_login_page_radio_field']= 'no';
		$custom_back_office_settings['eccp_settings_custom_image_background_url_text_field']='';
		$custom_back_office_settings['eccp_settings_enable_login_page_fixed_background_image_checkbox_field']= false;
	   
		$custom_back_office_settings['eccp_settings_enable_change_email_sender_default_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_email_sender_address_text_field'] = 'contact@les-paniers-bio.fr';
		$custom_back_office_settings['eccp_settings_email_sender_name_text_field'] = 'LES PANIERS BIO';
		$custom_back_office_settings['eccp_settings_enable_return_adress_correspond_from_adress_checkbox_field']= false;
		
		$custom_back_office_settings['eccp_settings_disable_default_wordpress_sitemap_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_activate_local_site_admin_login_loginout_link_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_activate_online_site_admin_login_loginout_link_checkbox_field']= false;
		$custom_back_office_settings['eccp_settings_slug_admin_login_url_text_field']='wp-admin';
	   
		$custom_front_end_settings['eccp_settings_enable_back_to_top_button_checkbox_field']= false;
		$custom_front_end_settings ['eccp_settings_margin_x_text_field'] = 20;
		$custom_front_end_settings ['eccp_settings_margin_y_text_field'] = 20;
		$custom_front_end_settings ['eccp_settings_back_top_button_opacity_text_field'] = 50;
		$custom_front_end_settings ['eccp_settings_back_top_button_opacity_on_hover_text_field'] = 70;
		$custom_front_end_settings['eccp_settings_back_top_button_color_text_field'] = '#2271B1';
		$custom_front_end_settings['eccp_settings_color_icon_back_to_top_button_text_field'] = '#FFFFFF';
		$custom_front_end_settings['eccp_settings_back_to_top_button_border_radius_text_field']= 4;
		
		$custom_front_end_settings['eccp_settings_enable_author_info_box_checkbox_field']= false;
		$custom_front_end_settings['eccp_settings_border_radius_avatar_author_info_box_text_field']= 0;
		$custom_front_end_settings['eccp_settings_title_author_info_box_text_field'] = '#222222';
		$custom_front_end_settings['eccp_settings_text_author_info_box_text_field'] = '#666666';
		$custom_front_end_settings['eccp_settings_link_author_info_box_text_field'] = '#0E6487';
		$custom_front_end_settings['eccp_settings_background_author_info_box_text_field'] = '#F5F5F5';
		$custom_front_end_settings['eccp_settings_enable_lightbox_checkbox_field']= false;
	   
	   //Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
	   add_option( 'eccp_settings_default_settings', $default_settings, '', 'yes' );
	   add_option( 'eccp_multiple_setting', $settings, '', 'yes' );
	   add_option( 'eccp_setting_editor_text_size', $editor_text_size_settings, '', 'yes' );
	   add_option( 'eccp_settings_custom_gutenberg_editor', $custom_gutenberg_editor_settings, '', 'yes' );
	   add_option( 'eccp_settings_custom_gutenberg_block', $custom_gutenberg_blocks_settings, '', 'yes' );
	   add_option( 'eccp_settings_reusable_blocks', $reusable_blocks_settings, '', 'yes' );
	   add_option( 'eccp_settings_elementor', $elementor_settings, '', 'yes' );
	   add_option( 'eccp_settings_divi_theme', $divi_settings, '', 'yes' );
	   add_option( 'eccp_settings_custom_back_office', $custom_back_office_settings, '', 'yes' );
	   add_option( 'eccp_settings_custom_front_end', $custom_front_end_settings, '', 'yes' );
   
   }
    
}

register_activation_hook( __FILE__, 'eccp_editor_custom_color_palette_activate' ); 


/*----------------------------------------------------------------------------*
 *          4.1  Actions a réaliser aprés la mise à jour du plugin
 *----------------------------------------------------------------------------*/
 
 
// On effectue la mise à niveau de la base de données
// si la version active du plugin est différente
// de la dernière version du plugin: ECCP_PLUGIN_VERSION
// on utilise le hook plugin_loaded
// une fois que le plugin a été activé et chargé le hook plugin_loaded
// se déclenche à la fois sur les écrans d'administration et publics.
add_action('plugin_loaded', 'eccp_updated_plugin');

function eccp_updated_plugin()	{
	
	// On récupère les paramètres pour tous les onglets de réglages du plugin
	$default_settings = get_option( 'eccp_settings_default_settings' );
	$settings = get_option( 'eccp_multiple_setting' );
	$editor_text_size_settings = get_option( 'eccp_setting_editor_text_size' );
	$custom_gutenberg_editor_settings = get_option( 'eccp_settings_custom_gutenberg_editor' );
	$custom_gutenberg_blocks_settings = get_option( 'eccp_settings_custom_gutenberg_block' );
	$reusable_blocks_settings = get_option( 'eccp_settings_reusable_blocks' );
	$elementor_settings = get_option( 'eccp_settings_elementor' );
	$divi_settings = get_option( 'eccp_settings_divi_theme' );
	$custom_back_office_settings = get_option( 'eccp_settings_custom_back_office' );
	$custom_front_end_settings = get_option( 'eccp_settings_custom_front_end' );
	
	// on récupère la version logicielle active du plugin
	$settings_version  = get_option('active_plugin_version');
	
	// il n'y a qu'a partir de la version 1.9 du plugin que l'on va gérer correctement
	// la version logicielle & l'update du plugin.
	// donc get_option('active_plugin_version') ne retourne rien
	if ( !empty( $settings_version) ) {
		$active_version = $settings_version;
	}else{
		
		// code pour la 1ère installation du plugin ou aucune version active
		// du plugin n'est renseigné en base de données
		add_option( 'active_plugin_version',ECCP_PLUGIN_VERSION , '', 'yes' );
		
		return;
		
	}
	
	if ($active_version == ECCP_PLUGIN_VERSION) {
			return;
	}
		
		
	while ($active_version != ECCP_PLUGIN_VERSION) {
		 
		// Mise à jour selon la version logicielle du plugin
		switch ($active_version) {
			
			case '1.0':
		
			//------------------------ MISE A JOUR POUR LA VERSION 1.1 -----------------------------------*/
			
			// seulement mise a jour version logicielle pour la base de données	
			$active_version ='1.1';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
		
		
			case '1.1':
			
			//------------------------ MISE A JOUR POUR LA VERSION 1.2 -----------------------------------*/
			
			// seulement mise a jour version logicielle pour la base de données	
			$active_version ='1.2';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '1.2':
			
			//------------------------ MISE A JOUR POUR LA VERSION 1.3 -----------------------------------*/
			
			//----------------------------------  EDITOR COLOR PALETTE ----------------------------------------------------------
			$settings['eccp_settings_color_ten'] = 'rgba(143,182,63,0.51)';
			$settings['eccp_settings_color_twelve_text_field'] = '#F3E672';
			$settings['eccp_settings_opacity_color_twelve_text_field'] = '70';
			$settings['eccp_settings_color_twelve'] = 'rgba(243,230,114,0.70)';
			
			//----------------------------------  CUSTOM GUTENBERG EDITOR  ----------------------------------------------------------
			$settings['eccp_settings_activate_editor_width_checkbox_field'] = false;
			$settings['eccp_settings_small_template_editor_text_field'] = 696;
			$settings['eccp_settings_large_template_editor_text_field'] = 1100;
			$settings['eccp_settings_post_template_editor_select_field'] = 'small';
			$settings['eccp_settings_page_template_editor_select_field'] = 'large';
			$settings['eccp_settings_activate_box_shadow_paragraph_block_radio_field'] = 'no';
			$settings['eccp_settings_bulleted_list_color_text_field'] = '#F37020';
			$settings['eccp_settings_bulleted_list_size_text_field'] = '20';
			$settings['eccp_settings_caption_font_size_text_field'] = '15';
			$settings['eccp_settings_caption_padding_text_field'] = '5';
			$settings['eccp_settings_caption_color_text_field'] = '#FFFFFF';
			$settings['eccp_settings_caption_background_color_text_field'] = '#D5590B';
			$settings['eccp_settings_page_title_alignment_select_field'] = 'center';
			
			//----------------------------------  ADDONS REUSABLE BLOCKS  ----------------------------------------------------------
			//$settings['eccp_settings_font_weight_blockquote_select_field'] = '700';
			//$settings['eccp_settings_font_size_blockquote_text_field'] = '20';
			$settings['eccp_settings_width_blockquote_post_back_office_text_field'] = '60';
			$settings['eccp_settings_width_blockquote_post_front_end_text_field'] = '70';
			$settings['eccp_settings_width_blockquote_page_back_office_text_field'] = '60';
			$settings['eccp_settings_width_blockquote_page_front_end_text_field'] = '80';
			$settings['eccp_settings_custom_paragraph_border_color_text_field'] = '#F37020';
			$settings['eccp_settings_opacity_custom_paragraph_border_color_text_field'] = '70';
			$settings['eccp_settings_custom_paragraph_border_color'] = 'rgba(243,112,32,0.7)';
			$settings['eccp_settings_custom_paragraph_width_post_back_office_text_field'] = '76';
			$settings['eccp_settings_custom_paragraph_width_post_front_end_text_field'] = '100';
			$settings['eccp_settings_custom_paragraph_width_page_back_office_text_field'] = '100';
			$settings['eccp_settings_custom_paragraph_width_page_front_end_text_field'] = '100';
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_multiple_setting', $settings, '', 'yes' );
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='1.3';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '1.3':
			
			//------------------------ MISE A JOUR POUR LA VERSION 1.4 -----------------------------------*/
			
			// seulement mise a jour version logicielle pour la base de données	
			$active_version ='1.4';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '1.4':
			
			//------------------------ MISE A JOUR POUR LA VERSION 1.5 -----------------------------------*/
			
			//----------------------------------  CUSTOM GUTENBERG EDITOR  ----------------------------------------------------------
			$settings['eccp_settings_post_embed_max_width_text_field'] = 640;
			$settings['eccp_settings_page_embed_max_width_text_field'] = 960;
			$settings['eccp_corrective_according_to_theme_radio_field'] = 'no';
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_multiple_setting', $settings, '', 'yes' );
			
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='1.5';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			case '1.5':
			
			//------------------------ MISE A JOUR POUR LA VERSION 1.6 -----------------------------------*/
			// seulement une mise à jour pour corriger bugs sans nouvelle entrées en base de données
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='1.6';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '1.6':
			
			//------------------------ MISE A JOUR POUR LA VERSION 1.7 -----------------------------------*/
			
			//----------------------------------  ADDONS REUSABLE BLOCKS  ----------------------------------------------------------
			$settings['eccp_settings_quotation_marks_color_text_field'] ='#F37020';   
			$settings['eccp_settings_quotation_marks_opacity_text_field'] = '60';
			
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_multiple_setting', $settings, '', 'yes' );
		
			// mise a jour version logicielle pour la base de données	
			$active_version ='1.7';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
		
		
			case '1.7':
			
			//------------------------ MISE A JOUR POUR LA VERSION 1.8 -----------------------------------*/
			
			//----------------------------------  CUSTOM GUTENBERG EDITOR  ----------------------------------------------------------
			$settings['eccp_settings_box_shadow_color_text_field'] ='#000000';
			$settings['eccp_settings_box_shadow_opacity_text_field'] = '50';
			$settings['eccp_settings_box_shadow_x_text_field']= '8';
			$settings['eccp_settings_box_shadow_y_text_field'] = '8';
			$settings['eccp_settings_box_shadow_blur_text_field'] = '12'; 
			$settings['eccp_settings_box_shadow_spread_text_field'] = '-8';
			
			//----------------------------------  ADDONS REUSABLE BLOCKS  ----------------------------------------------------------
			$settings['eccp_activate_reusable_blocks_menu_checkbox_field'] = false;
			
			//----------------------------------  ELEMENTOR COLOR PALETTE  ----------------------------------------------------------
			$settings['eccp_activate_synchronization_color_palette_radio_field'] = 'no';
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_multiple_setting', $settings, '', 'yes' );
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='1.8';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			case '1.8':
			//------------------------ MISE A JOUR POUR LA VERSION 1.9 -----------------------------------*/
				
			//----------------------------------  CUSTOM GUTENBERG EDITOR  ----------------------------------------------------------
			$settings['eccp_settings_cpt_template_editor_select_field'] = 'large';
			$settings['eccp_settings_cpt_embed_max_width_text_field'] = 640;
			
			//----------------------------------  ADDONS REUSABLE BLOCKS  ----------------------------------------------------------
			$settings['eccp_settings_width_blockquote_cpt_back_office_text_field'] = '60';
			$settings['eccp_settings_width_blockquote_cpt_front_end_text_field'] = '61';
			//$settings['eccp_settings_custom_paragraph_width_cpt_back_office_text_field'] = '50';
			//$settings['eccp_settings_custom_paragraph_width_cpt_front_end_text_field'] = '62';
			
			//----------------------------------  DIVI COLOR PALETTE ----------------------------------------------------------
			$settings['eccp_activate_synchronization_divi_color_palette_radio_field'] = 'no';
			$settings['eccp_choose_synchronization_radio_field'] = 'synchro-gutenberg-to-divi';
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_multiple_setting', $settings, '', 'yes' );
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='1.9';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '1.9':
			
			//------------------------ MISE A JOUR POUR LA VERSION 2.0 -----------------------------------*/
				
			//----------------------------------  PARAMÈTRES PAR DÉFAUT  ----------------------------------------------------------
			
			$default_settings['eccp_default_setting_radio_field'] = 'no';
			$default_settings['eccp_delete_data_uninstallation_radio_field'] = 'no';
			
			//----------------------------------  EDITOR TEXT SIZE PALETTE ----------------------------------------------------------
			$editor_text_size_settings['eccp_settings_activate_editor_text_size_checkbox_field'] = true;
			$editor_text_size_settings['eccp_settings_small_font_size_text_field'] = '18';
			$editor_text_size_settings['eccp_settings_regular_font_size_text_field'] = '20';
			$editor_text_size_settings['eccp_settings_large_font_size_text_field'] = '24';
			$editor_text_size_settings['eccp_settings_huge_font_size_text_field'] = '30';
			$editor_text_size_settings['eccp_settings_enable_default_gutenberg_editor_font_size_checkbox_field'] = false;
			$editor_text_size_settings['eccp_settings_disable_custom_font_size_checkbox_field'] = false;
		   
			//----------------------------------  CUSTOM GUTENBERG EDITOR  ----------------------------------------------------------
			$custom_gutenberg_editor_settings['eccp_settings_disable_fullscreen_gutenberg_editor_checkbox_field'] = false;
			$custom_gutenberg_editor_settings['eccp_settings_activate_default_style_sheet_on_front_end_checkbox_field'] = false;
			$custom_gutenberg_editor_settings['eccp_settings_activate_align_wide_block_editor_checkbox_field'] = false;
			$custom_gutenberg_editor_settings['eccp_settings_activate_responsive_embeds_checkbox_field'] = false;
			$custom_gutenberg_editor_settings['eccp_settings_post_embed_max_width_text_field'] = 640;
			$custom_gutenberg_editor_settings['eccp_settings_page_embed_max_width_text_field'] = 960;
			$custom_gutenberg_editor_settings['eccp_settings_cpt_embed_max_width_text_field'] = 640;
			$custom_gutenberg_editor_settings['eccp_corrective_according_to_theme_radio_field'] = 'no';
			$custom_gutenberg_editor_settings['eccp_settings_activate_editor_width_checkbox_field'] = false;
			$custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field'] = 696;
			$custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field'] = 1100;
			$custom_gutenberg_editor_settings['eccp_settings_post_template_editor_select_field'] = 'small';
			$custom_gutenberg_editor_settings['eccp_settings_page_template_editor_select_field'] = 'large';
			$custom_gutenberg_editor_settings['eccp_settings_cpt_template_editor_select_field'] = 'large';
			$custom_gutenberg_editor_settings['eccp_settings_page_title_alignment_select_field'] = 'center';
			
			//----------------------------------  CUSTOM GUTENBERG BLOCKS  ----------------------------------------------------------
			$custom_gutenberg_blocks_settings['eccp_settings_activate_box_shadow_paragraph_block_radio_field'] = 'no';
			$custom_gutenberg_blocks_settings['eccp_settings_box_shadow_color_text_field'] ='#000000';
			$custom_gutenberg_blocks_settings['eccp_settings_box_shadow_opacity_text_field'] = '50';
			$custom_gutenberg_blocks_settings['eccp_settings_box_shadow_x_text_field']= 8;
			$custom_gutenberg_blocks_settings['eccp_settings_box_shadow_y_text_field'] = 8;
			$custom_gutenberg_blocks_settings['eccp_settings_box_shadow_blur_text_field'] = 12; 
			$custom_gutenberg_blocks_settings['eccp_settings_box_shadow_spread_text_field'] = -8;
			
			$custom_gutenberg_blocks_settings['eccp_settings_bulleted_list_color_text_field'] = '#F37020';
			$custom_gutenberg_blocks_settings['eccp_settings_bulleted_list_size_text_field'] = '20';
			
			$custom_gutenberg_blocks_settings['eccp_settings_caption_font_size_text_field'] = '15';
			$custom_gutenberg_blocks_settings['eccp_settings_caption_padding_text_field'] = '5';
			$custom_gutenberg_blocks_settings['eccp_settings_caption_color_text_field'] = '#FFFFFF';
			$custom_gutenberg_blocks_settings['eccp_settings_caption_background_color_text_field'] = '#D5590B';
			$custom_gutenberg_blocks_settings['eccp_settings_activate_style_image_circle_radio_field'] = 'no';
			$custom_gutenberg_blocks_settings['eccp_settings_activate_style_image_filter_grayscale_radio_field'] = 'no';
			
			
			$custom_gutenberg_blocks_settings['eccp_settings_hover_fill_style_background_color_text_field'] ='#000000';
			$custom_gutenberg_blocks_settings['eccp_settings_hover_fill_style_backgound_color_opacity_text_field'] = '0';
			
			//----------------------------------  ADDONS REUSABLE BLOCKS  ----------------------------------------------------------
			$reusable_blocks_settings['eccp_activate_reusable_blocks_menu_checkbox_field'] = false;
			$reusable_blocks_settings['eccp_settings_quotation_marks_color_text_field'] ='#F37020';   
			$reusable_blocks_settings['eccp_settings_quotation_marks_opacity_text_field'] = '60';
			//$reusable_blocks_settings['eccp_settings_font_weight_blockquote_select_field'] = '700';
			//$reusable_blocks_settings['eccp_settings_font_size_blockquote_text_field'] = '20';
			$reusable_blocks_settings['eccp_settings_width_blockquote_post_back_office_text_field'] = '74';
			$reusable_blocks_settings['eccp_settings_width_blockquote_post_front_end_text_field'] = '70';
			$reusable_blocks_settings['eccp_settings_width_blockquote_page_back_office_text_field'] = '60';
			$reusable_blocks_settings['eccp_settings_width_blockquote_page_front_end_text_field'] = '62';
			$reusable_blocks_settings['eccp_settings_width_blockquote_cpt_back_office_text_field'] = '60';
			$reusable_blocks_settings['eccp_settings_width_blockquote_cpt_front_end_text_field'] = '61';
			$reusable_blocks_settings['eccp_settings_custom_paragraph_border_color_text_field'] = '#F37020';
			$reusable_blocks_settings['eccp_settings_opacity_custom_paragraph_border_color_text_field'] = '70';
			$reusable_blocks_settings['eccp_settings_custom_paragraph_border_color'] = 'rgba(243,112,32,0.7)';
			$reusable_blocks_settings['eccp_settings_custom_paragraph_width_post_back_office_text_field'] = '95';
			$reusable_blocks_settings['eccp_settings_custom_paragraph_width_post_front_end_text_field'] = '100';
			$reusable_blocks_settings['eccp_settings_custom_paragraph_width_page_back_office_text_field'] = '60';
			$reusable_blocks_settings['eccp_settings_custom_paragraph_width_page_front_end_text_field'] = '62';
			$reusable_blocks_settings['eccp_settings_custom_paragraph_width_cpt_back_office_text_field'] = '55';
			$reusable_blocks_settings['eccp_settings_custom_paragraph_width_cpt_front_end_text_field'] = '62';
			
			//----------------------------------  ELEMENTOR COLOR PALETTE  ----------------------------------------------------------
			$elementor_settings['eccp_activate_synchronization_color_palette_radio_field'] = 'no';
			
			//----------------------------------  DIVI COLOR PALETTE ----------------------------------------------------------
			$divi_settings['eccp_activate_synchronization_divi_color_palette_radio_field'] = 'no';
			$divi_settings['eccp_choose_synchronization_radio_field'] = 'synchro-gutenberg-to-divi';
			
			// suite a l'introduction d'onglets dans la page de réglages du plugin
			// On ajoute les nouveaux groupes de réglages dans la table option 
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			add_option( 'eccp_settings_default_settings', $default_settings, '', 'yes' );
		    add_option( 'eccp_setting_editor_text_size', $editor_text_size_settings, '', 'yes' );
		    add_option( 'eccp_settings_custom_gutenberg_editor', $custom_gutenberg_editor_settings, '', 'yes' );
		    add_option( 'eccp_settings_custom_gutenberg_block', $custom_gutenberg_blocks_settings, '', 'yes' );
		    add_option( 'eccp_settings_reusable_blocks', $reusable_blocks_settings, '', 'yes' );
		    add_option( 'eccp_settings_elementor', $elementor_settings, '', 'yes' );
		    add_option( 'eccp_settings_divi_theme', $divi_settings, '', 'yes' );
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.0';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '2.0':
			
			//------------------------ MISE A JOUR POUR LA VERSION 2.1 -----------------------------------*/
				
			//----------------------------------  CUSTOM GUTENBERG BLOCKS  ----------------------------------------------------------
			$custom_gutenberg_blocks_settings['eccp_settings_activate_style_card_paragraph_radio_field'] = 'no';
			$custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_question_radio_field'] = 'no';
			$custom_gutenberg_blocks_settings['eccp_settings_icon_color_style_notice_question_text_field'] ='#666666';
			$custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_info_radio_field'] = 'no';
			$custom_gutenberg_blocks_settings['eccp_settings_icon_color_style_notice_info_text_field'] ='#FFFFFF';
			$custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_advice_radio_field'] = 'no';
			$custom_gutenberg_blocks_settings['eccp_settings_icon_color_style_notice_advice_text_field'] ='#FFFFFF';
			$custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_warning_radio_field'] = 'no';
			$custom_gutenberg_blocks_settings['eccp_settings_icon_color_style_notice_warning_text_field'] ='#FFFFFF';
			$custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_alert_radio_field'] = 'no';
			$custom_gutenberg_blocks_settings['eccp_settings_icon_color_style_notice_alert_text_field'] ='#FFFFFF';
			
			$custom_gutenberg_blocks_settings['eccp_settings_activate_styles_bullet_list_radio_field'] = 'no';
			
			$custom_gutenberg_blocks_settings['eccp_settings_activate_style_image_circle_radio_field'] = 'no';
			$custom_gutenberg_blocks_settings['eccp_settings_activate_style_image_filter_grayscale_radio_field'] = 'no';
			
			$custom_gutenberg_blocks_settings['eccp_settings_activate_button_styles_hover_radio_field'] = 'no';
			$custom_gutenberg_blocks_settings['eccp_settings_hover_fill_style_background_color_text_field'] ='#000000';
			$custom_gutenberg_blocks_settings['eccp_settings_hover_fill_style_backgound_color_opacity_text_field'] = '0';
			$custom_gutenberg_blocks_settings['eccp_settings_hover_fill_style_border_color_text_field'] ='#D5590B';
			$custom_gutenberg_blocks_settings['eccp_settings_hover_fill_style_text_color_text_field'] ='#D5590B';
			
			$custom_gutenberg_blocks_settings['eccp_settings_hover_outline_style_background_color_text_field'] ='#D5590B';
			$custom_gutenberg_blocks_settings['eccp_settings_hover_outline_style_backgound_color_opacity_text_field'] = '100';
			$custom_gutenberg_blocks_settings['eccp_settings_hover_outline_style_border_color_text_field'] ='#D5590B';
			$custom_gutenberg_blocks_settings['eccp_settings_hover_outline_style_text_color_text_field'] ='#FFFFFF';
			
			$custom_gutenberg_blocks_settings['eccp_settings_activate_columns_block_styles_radio_field'] = 'no';
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_gutenberg_block', $custom_gutenberg_blocks_settings, '', 'yes' );
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.1';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			case '2.1':
			
			//------------------------ MISE A JOUR POUR LA VERSION 2.2 -----------------------------------*/
				
			//----------------------------------  CUSTOM GUTENBERG BLOCKS  ----------------------------------------------------------
			$custom_gutenberg_blocks_settings['eccp_settings_activate_media_text_block_styles_radio_field'] = 'no';
			
			$custom_gutenberg_blocks_settings['eccp_settings_activate_block_styles_read_more_radio_field'] = 'no';
			$custom_gutenberg_blocks_settings['eccp_settings_link_text_read_more_text_field'] = 'Read more';
			
			$custom_gutenberg_blocks_settings['eccp_settings_block_read_more_background_color_text_field'] ='#F37020';
			$custom_gutenberg_blocks_settings['eccp_settings_block_read_more_backgound_color_opacity_text_field'] = '100';
			$custom_gutenberg_blocks_settings['eccp_settings_block_read_more_border_color_text_field'] ='#F37020';
			$custom_gutenberg_blocks_settings['eccp_settings_block_read_more_text_color_text_field'] ='#FFFFFF';
			
			$custom_gutenberg_blocks_settings['eccp_settings_block_read_more_hover_background_color_text_field'] ='#000000';
			$custom_gutenberg_blocks_settings['eccp_settings_block_read_more_hover_backgound_color_opacity_text_field'] = '0';
			$custom_gutenberg_blocks_settings['eccp_settings_block_read_more_hover_border_color_text_field'] ='#D5590B';
			$custom_gutenberg_blocks_settings['eccp_settings_block_read_more_hover_text_color_text_field'] ='#D5590B';
					
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_gutenberg_block', $custom_gutenberg_blocks_settings, '', 'yes' );
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.2';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '2.2':
			
			//------------------------ MISE A JOUR POUR LA VERSION 2.3 -----------------------------------*/
				
			//----------------------------------  CUSTOM GUTENBERG BLOCKS  ----------------------------------------------------------
			
			$custom_gutenberg_blocks_settings['eccp_settings_activate_script_reactjs_radio_field']= 'no';
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_gutenberg_block', $custom_gutenberg_blocks_settings, '', 'yes' );
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.3';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '2.3':
			
			//------------------------ MISE A JOUR POUR LA VERSION 2.3.1 -----------------------------------*/
				
			//----------------------------------  CUSTOM GUTENBERG BLOCKS  ----------------------------------------------------------
			
			// Aucun nouveau paramètre de réglage,simplement ajout d'un point de rupture à 768px
			// pour le réglage de la largeur du bloc Paragraphe
						
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.3.1';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '2.3.1':
			
			//------------------------ MISE A JOUR POUR LA VERSION 2.4 -----------------------------------*/
				
			//----------------------------------  CUSTOM GUTENBERG BLOCKS  ----------------------------------------------------------
			
			// Aucun nouveau paramètre de réglage pour cette version 2.4
			// essentiellement mise à jour du script react JS: eccp-custom-blocks.js		
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.4';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			case '2.4':
			
			//------------------------ MISE A JOUR POUR LA VERSION 2.5 -----------------------------------*/
				
			//----------------------------------  CUSTOM GUTENBERG BLOCKS  ----------------------------------------------------------
			
			// Aucun nouveau paramètre de réglage pour cette version 2.5
			// essentiellement mise à jour du script react JS: eccp-custom-blocks.js		
			
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.5';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			case '2.5':
			
			//------------------------ MISE A JOUR POUR LA VERSION 2.6 -----------------------------------*/
				
			//----------------------------------  CUSTOM GUTENBERG BLOCKS  ----------------------------------------------------------
			
			
			$custom_gutenberg_blocks_settings['eccp_settings_activate_block_styles_table_radio_field']= 'no';
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_gutenberg_block', $custom_gutenberg_blocks_settings, '', 'yes' );
			
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.6';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '2.6':
			
			//------------------------ MISE A JOUR POUR LA VERSION 2.7 -----------------------------------*/
				
			// Aucun nouveau paramètre de réglage pour cette version 2.7
			// essentiellement mise à jour du script react JS: eccp-custom-blocks.js
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.7';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '2.7':
			
			//------------------------ MISE A JOUR POUR LA VERSION 2.8 -----------------------------------*/
				
			// Aucun nouveau paramètre de réglage pour cette version 2.8
			// essentiellement mise à jour du script react JS: eccp-custom-blocks.js
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.8';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '2.8':
			
			//------------------------ MISE A JOUR POUR LA VERSION 2.8.1 -----------------------------------*/
				
			//----------------------------------  CUSTOM GUTENBERG EDITOR  ----------------------------------------------------------
			$custom_gutenberg_editor_settings['eccp_settings_activate_support_margin_padding_checkbox_field'] = false;
			$custom_gutenberg_editor_settings['eccp_settings_activate_support_border_checkbox_field'] = false;
		
			
			// suite a l'introduction d'onglets dans la page de réglages du plugin
			// On ajoute les nouveaux groupes de réglages dans la table option 
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
		    add_option( 'eccp_settings_custom_gutenberg_editor', $custom_gutenberg_editor_settings, '', 'yes' );
		    
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.8.1';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '2.8.1':
			
			//------------------------ MISE A JOUR POUR LA VERSION 2.8.2 -----------------------------------*/
				
			// Aucun nouveau paramètre de réglage pour cette version 2.8.2
			// essentiellement mise à jour du script react JS: eccp-custom-blocks.js
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.8.2';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '2.8.2':
			//------------------------ MISE A JOUR POUR LA VERSION 2.8.3 -----------------------------------*/
				
			// Aucun nouveau paramètre de réglage pour cette version 2.8.3
			// essentiellement mise à jour du script react JS: eccp-custom-blocks.js
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.8.3';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '2.8.3':
			//------------------------ MISE A JOUR POUR LA VERSION 2.8.4 -----------------------------------*/
				
			//----------------------------------  CUSTOM GUTENBERG BLOCK  ----------------------------------------------------------
			$custom_gutenberg_blocks_settings['eccp_settings_activate_style_click_to_tweet_radio_field'] = 'no';
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_gutenberg_block', $custom_gutenberg_blocks_settings, '', 'yes' );
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.8.4';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			case '2.8.4':
			//------------------------ MISE A JOUR POUR LA VERSION 2.8.5 -----------------------------------*/
				
			// Aucun nouveau paramètre de réglage pour cette version 2.8.5
			// essentiellement mise à jour du script react JS: eccp-custom-blocks.js
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.8.5';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '2.8.5':
			//------------------------ MISE A JOUR POUR LA VERSION 2.8.6 -----------------------------------*/
				
			//----------------------------------  CUSTOM GUTENBERG BLOCK  ----------------------------------------------------------
			$custom_gutenberg_blocks_settings['eccp_settings_activate_style_image_card_radio_field'] = 'no';
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_gutenberg_block', $custom_gutenberg_blocks_settings, '', 'yes' );
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.8.6';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '2.8.6':
			//------------------------ MISE A JOUR POUR LA VERSION 2.8.7 -----------------------------------*/
				
			//----------------------------------  CUSTOM GUTENBERG BLOCK  ----------------------------------------------------------
			$custom_gutenberg_blocks_settings['eccp_settings_activate_card_style_latest_posts_block_radio_field']= 'no';
			$custom_gutenberg_blocks_settings['eccp_settings_activate_card_style_query_loop_block_radio_field']= 'no';
			$custom_gutenberg_blocks_settings['eccp_settings_activate_custom_avatar_radio_field']= 'no';
			$custom_gutenberg_blocks_settings['eccp_settings_custom_avatar_url_text_field'] ='';
			$custom_gutenberg_blocks_settings['eccp_settings_custom_avatar_size_text_field'] =48;
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_gutenberg_block', $custom_gutenberg_blocks_settings, '', 'yes' );
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.8.7';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '2.8.7':
			//------------------------ MISE A JOUR POUR LA VERSION 2.8.8 -----------------------------------*/
				
			// Aucun nouveau paramètre de réglage pour cette version 2.8.8
			// essentiellement mise à jour du script react JS: eccp-custom-blocks.js
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.8.8';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '2.8.8':
			//------------------------ MISE A JOUR POUR LA VERSION 2.8.9 -----------------------------------*/
				
			//----------------------------------  CUSTOM GUTENBERG BLOCK  ----------------------------------------------------------
			$custom_gutenberg_blocks_settings['eccp_settings_turn_yoast_faq_block_an_accordion_radio_field']= 'no';
			$custom_gutenberg_blocks_settings['eccp_settings_width_block_faq_yoast_text_field'] =100;
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_gutenberg_block', $custom_gutenberg_blocks_settings, '', 'yes' );
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.8.9';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '2.8.9':
			//------------------------ MISE A JOUR POUR LA VERSION 2.9 -----------------------------------*/
				
			//----------------------------------  REUSABLE BLOCKS  ----------------------------------------------------------
			$reusable_blocks_settings['eccp_activate_reusable_blocks_shortcode_checkbox_field'] = false;
			
			//----------------------------------  CUSTOM EDITOR  ----------------------------------------------------------
			$custom_gutenberg_editor_settings['eccp_settings_disable_webp_image_generation_checkbox_field'] = false;
			$custom_gutenberg_editor_settings['eccp_settings_disable_downloading_and_image_generation_webp_checkbox_field']= false;
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_reusable_blocks', $reusable_blocks_settings, '', 'yes' );
			update_option( 'eccp_settings_custom_gutenberg_editor', $custom_gutenberg_editor_settings, '', 'yes' );
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.9';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '2.9':
			//------------------------ MISE A JOUR POUR LA VERSION 2.9.1 -----------------------------------*/
				
			//----------------------------------  CUSTOM GUTENBERG BLOCK  ----------------------------------------------------------
			$custom_gutenberg_blocks_settings['eccp_settings_enable_image_size_setting_radio_field'] = 'no';
			$custom_gutenberg_blocks_settings['eccp_settings_custom_image_width_parameter_text_field'] = 720;
			$custom_gutenberg_blocks_settings['eccp_settings_custom_image_height_parameter_text_field'] = 405;
			$custom_gutenberg_blocks_settings['eccp_settings_name_new_image_size_text_field'] ='Custom';
			$custom_gutenberg_blocks_settings['eccp_settings_slug_new_image_size_text_field'] ='custom';
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_gutenberg_block', $custom_gutenberg_blocks_settings, '', 'yes' );
				
				
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.9.1';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '2.9.1':
			//------------------------ MISE A JOUR POUR LA VERSION 2.9.2 -----------------------------------*/
			
			//----------------------------------  CUSTOM GUTENBERG BLOCK  ----------------------------------------------------------			
			$custom_gutenberg_blocks_settings['eccp_settings_activate_rectangle_shape_style_radio_field'] = 'no';	
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_gutenberg_block', $custom_gutenberg_blocks_settings, '', 'yes' );
				
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.9.2';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '2.9.2':
			//------------------------ MISE A JOUR POUR LA VERSION 2.9.3 -----------------------------------*/
			
			// Aucun nouveau paramètre de réglage pour cette version 2.9.3
				
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.9.3';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '2.9.3':
			//------------------------ MISE A JOUR POUR LA VERSION 2.9.4 -----------------------------------*/
			
			// Aucun nouveau paramètre de réglage pour cette version 2.9.4
			// essentiellement mise à jour du script react JS: eccp-custom-blocks.js
				
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.9.4';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '2.9.4':
			//------------------------ MISE A JOUR POUR LA VERSION 2.9.5 -----------------------------------*/
			
			// Aucun nouveau paramètre de réglage pour cette version 2.9.5
			
				
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.9.5';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '2.9.5':
			//------------------------ MISE A JOUR POUR LA VERSION 2.9.6 -----------------------------------*/
			
			// Aucun nouveau paramètre de réglage pour cette version 2.9.6
			
				
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.9.6';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '2.9.6':
			//------------------------ MISE A JOUR POUR LA VERSION 2.9.7 -----------------------------------*/
			
			// Aucun nouveau paramètre de réglage pour cette version 2.9.7
			
				
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.9.7';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '2.9.7':
			//------------------------ MISE A JOUR POUR LA VERSION 2.9.8 -----------------------------------*/
			
			//----------------------------------  CUSTOM GUTENBERG BLOCK  ----------------------------------------------------------
			$custom_gutenberg_blocks_settings['eccp_settings_activate_hover_zoom_style_latest_posts_block_radio_field']= 'no';
			$custom_gutenberg_blocks_settings['eccp_settings_activate_hover_zoom_style_query_loop_block_radio_field']= 'no';
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_gutenberg_block', $custom_gutenberg_blocks_settings, '', 'yes' );
			
				
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.9.8';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '2.9.8':
			//------------------------ MISE A JOUR POUR LA VERSION 2.9.9 -----------------------------------*/
			
			//----------------------------------  CUSTOM BACK OFFICE ----------------------------------------------------------
			$custom_back_office_settings['eccp_settings_activate_post_featured_image_column_checkbox_field']= false;
			$custom_back_office_settings['eccp_settings_activate_page_featured_image_column_checkbox_field']= false;
			$custom_back_office_settings['eccp_settings_width_thumbnail_featured_image_text_field']= 160;
			$custom_back_office_settings['eccp_settings_activate_library_id_dimensions_size_file_column_checkbox_field']= false;
			$custom_back_office_settings['eccp_settings_activate_mime_types_media_checkbox_field']= false;
			$custom_back_office_settings['eccp_settings_activate_users_last_login_column_checkbox_field']= false;
			$custom_back_office_settings['eccp_settings_disable_language_selector_checkbox_field']= false;
			$custom_back_office_settings['eccp_error_login_custom_message_textarea_field'] = 'Vous avez saisi un nom d\'utilisateur ou un mot de passe non valide!';
			$custom_back_office_settings['eccp_settings_disable_admin_email_request_checkbox_field'] = false;
			$custom_back_office_settings['eccp_settings_activate_custom_logo_checkbox_field']= false;
			$custom_back_office_settings['eccp_settings_custom_logo_url_text_field']='';
			$custom_back_office_settings['eccp_settings_custom_logo_width_text_field'] = 318;
			$custom_back_office_settings['eccp_settings_custom_logo_height_text_field'] = 96;
			$custom_back_office_settings['eccp_settings_activate_custom_login_form_radio_field']= 'no';
			$custom_back_office_settings['eccp_settings_page_login_form_background_color_text_field'] = '#F0F0F1';
			$custom_back_office_settings['eccp_settings_page_login_form_footer_text_color_text_field'] = '#333333';
			$custom_back_office_settings['eccp_settings_login_form_background_color_text_field'] = '#EAE672';
			$custom_back_office_settings['eccp_settings_login_form_text_color_text_field'] = '#333333';
			$custom_back_office_settings['eccp_settings_button_login_form_background_color_text_field'] ='#F0AD4E';
			$custom_back_office_settings['eccp_settings_button_login_form_border_color_text_field'] ='#F0AD4E';
			$custom_back_office_settings['eccp_settings_button_login_form_text_color_text_field'] ='#FFFFFF';
			$custom_back_office_settings['eccp_settings_hover_button_login_form_background_color_text_field'] ='#EC971F';
			$custom_back_office_settings['eccp_settings_hover_button_login_form_border_color_text_field'] ='#EC971F';
			$custom_back_office_settings['eccp_settings_hover_button_login_form_text_color_text_field'] ='#FFFFFF';
			$custom_back_office_settings['eccp_settings_info_notice_login_form_background_color_text_field'] = '#B0E0E6';
			$custom_back_office_settings['eccp_settings_info_notice_login_form_border_color_text_field'] = '#00A0D2';
			$custom_back_office_settings['eccp_settings_info_notice_login_form_text_color_text_field'] = '#333333';
			$custom_back_office_settings['eccp_settings_error_notice_login_form_background_color_text_field'] = '#FA8072';
			$custom_back_office_settings['eccp_settings_error_notice_login_form_border_color_text_field'] = '#F23C3C';
			$custom_back_office_settings['eccp_settings_error_notice_login_form_text_color_text_field'] = '#333333';
			
			
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_back_office', $custom_back_office_settings, '', 'yes' );
			
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='2.9.9';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '2.9.9':
			//------------------------ MISE A JOUR POUR LA VERSION 3.0 -----------------------------------*/
			
			//----------------------------------  CUSTOM BACK OFFICE ----------------------------------------------------------
			$custom_back_office_settings['eccp_settings_disable_default_wordpress_sitemap_checkbox_field']= false;
			
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_back_office', $custom_back_office_settings, '', 'yes' );
			
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='3.0';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '3.0':
			//------------------------ MISE A JOUR POUR LA VERSION 3.0.1 -----------------------------------*/
			
			//----------------------------------  CUSTOM BACK OFFICE ----------------------------------------------------------
			$custom_back_office_settings['eccp_settings_activate_local_site_admin_login_loginout_link_checkbox_field']= false;
			$custom_back_office_settings['eccp_settings_activate_online_site_admin_login_loginout_link_checkbox_field']= false;
			$custom_back_office_settings['eccp_settings_slug_admin_login_url_text_field']='wp-admin';
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_back_office', $custom_back_office_settings, '', 'yes' );
			
			
			//----------------------------------  CUSTOM GUTENBERG BLOCK ----------------------------------------------------------
			$custom_gutenberg_blocks_settings['eccp_settings_image_default_link_type_select_field'] ='none';
			$custom_gutenberg_blocks_settings['eccp_settings_image_default_size_select_field'] ='medium';
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_gutenberg_block', $custom_gutenberg_blocks_settings, '', 'yes' );
			
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='3.0.1';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '3.0.1':
			//------------------------ MISE A JOUR POUR LA VERSION 3.0.2 -----------------------------------*/
			
			//----------------------------------  CUSTOM BACK OFFICE ----------------------------------------------------------
			$custom_back_office_settings['eccp_settings_image_alt_text_by_title_checkbox_field']= false;
			$custom_back_office_settings['eccp_settings_image_caption_according_title_checkbox_field']= false;
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_back_office', $custom_back_office_settings, '', 'yes' );
			
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='3.0.2';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '3.0.2':
			//------------------------ MISE A JOUR POUR LA VERSION 3.0.3 -----------------------------------*/
			
			//----------------------------------  CUSTOM REUSABLE BLOCK ----------------------------------------------------------
			$reusable_blocks_settings['eccp_settings_insert_block_before_post_select_field']= '';
			$reusable_blocks_settings['eccp_settings_insert_block_after_post_select_field']= '';
			$reusable_blocks_settings['eccp_settings_insert_block_before_page_select_field']= '';
			$reusable_blocks_settings['eccp_settings_insert_block_after_page_select_field']= '';
			$reusable_blocks_settings['eccp_settings_insert_block_before_cpt_select_field']= '';
			$reusable_blocks_settings['eccp_settings_insert_block_after_cpt_select_field']= '';
				
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_reusable_blocks', $reusable_blocks_settings, '', 'yes' );
			
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='3.0.3';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '3.0.3':
			//------------------------ MISE A JOUR POUR LA VERSION 3.0.4 -----------------------------------*/
			
			//----------------------------------  CUSTOM BACK OFFICE ----------------------------------------------------------
			$custom_back_office_settings['eccp_settings_activate_users_registration_date_column_checkbox_field']= false;
			$custom_back_office_settings['eccp_settings_activate_author_filter_checkbox_field']= false;
			$custom_back_office_settings['eccp_settings_activate_taxonomy_filter_cpt_checkbox_field']= false;
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_back_office', $custom_back_office_settings, '', 'yes' );
			
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='3.0.4';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '3.0.4':
			//------------------------ MISE A JOUR POUR LA VERSION 3.0.5 -----------------------------------*/
			
			//----------------------------------  CUSTOM GUTENBERG BLOCK ----------------------------------------------------------
			$custom_gutenberg_blocks_settings['eccp_settings_name_table_of_contents_text_field'] = 'Table des matières';
			$custom_gutenberg_blocks_settings['eccp_settings_title_color_table_of_contents_text_field']='#333333';
			$custom_gutenberg_blocks_settings['eccp_settings_offset_navigation_anchors_text_field'] = 20;
			$custom_gutenberg_blocks_settings['eccp_settings_activate_underline_table_of_contents_links_on_hover_radio_field'] = 'no';
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_gutenberg_block', $custom_gutenberg_blocks_settings, '', 'yes' );
			
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='3.0.5';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '3.0.5':
			//------------------------ MISE A JOUR POUR LA VERSION 3.0.6 -----------------------------------*/
			
			//----------------------------------  CUSTOM BACK OFFICE ----------------------------------------------------------
			$custom_back_office_settings['eccp_settings_enable_change_email_sender_default_checkbox_field']= false;
			$custom_back_office_settings['eccp_settings_email_sender_address_text_field'] = 'contact@les-paniers-bio.fr';
			$custom_back_office_settings['eccp_settings_email_sender_name_text_field'] = 'LES PANIERS BIO';
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_back_office', $custom_back_office_settings, '', 'yes' );
			
			//----------------------------------  CUSTOM FRONT END ----------------------------------------------------------
			$custom_front_end_settings['eccp_settings_enable_back_to_top_button_checkbox_field']= false;
			$custom_front_end_settings ['eccp_settings_margin_x_text_field'] = 20;
			$custom_front_end_settings ['eccp_settings_margin_y_text_field'] = 20;
			$custom_front_end_settings ['eccp_settings_back_top_button_opacity_text_field'] = 50;
			$custom_front_end_settings ['eccp_settings_back_top_button_opacity_on_hover_text_field'] = 70;
			$custom_front_end_settings['eccp_settings_back_top_button_color_text_field'] = '#2271B1';
			$custom_front_end_settings['eccp_settings_color_icon_back_to_top_button_text_field'] = '#FFFFFF';
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_front_end', $custom_front_end_settings, '', 'yes' );
			
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='3.0.6';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '3.0.6':
			//------------------------ MISE A JOUR POUR LA VERSION 3.0.7 -----------------------------------*/
			
			
			//----------------------------------  CUSTOM FRONT END ----------------------------------------------------------
			$custom_front_end_settings['eccp_settings_back_to_top_button_border_radius_text_field']= 4;
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_front_end', $custom_front_end_settings, '', 'yes' );
			
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='3.0.7';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '3.0.7':
			//------------------------ MISE A JOUR POUR LA VERSION 3.0.8 -----------------------------------*/
			
			//----------------------------------  CUSTOM BACK OFFICE ----------------------------------------------------------
			$custom_back_office_settings['eccp_settings_enable_post_cpt_date_range_filter_checkbox_field'] = false;
			$custom_back_office_settings['eccp_settings_enable_post_filter_publication_status_checkbox_field'] = false;
			$custom_back_office_settings['eccp_settings_enable_filter_dates_range_media_library_checkbox_field'] = false;
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_back_office', $custom_back_office_settings, '', 'yes' );
			
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='3.0.8';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			
			case '3.0.8':
			//------------------------ MISE A JOUR POUR LA VERSION 3.0.9 -----------------------------------*/
			
			//----------------------------------  CUSTOM GUTENBERG BLOCK ----------------------------------------------------------
			$custom_gutenberg_blocks_settings['eccp_settings_tooltip_text_color_text_field'] = '#FFFFFF';
			$custom_gutenberg_blocks_settings['eccp_settings_tooltip_background_color_text_field'] = '#1E5A99';
			$custom_gutenberg_blocks_settings['eccp_settings_text_double_underline_color_text_field'] = '#1E5A99';
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_gutenberg_block', $custom_gutenberg_blocks_settings, '', 'yes' );
			
			
			//----------------------------------  CUSTOM BACK OFFICE ----------------------------------------------------------
			$custom_back_office_settings['eccp_settings_enable_return_adress_correspond_from_adress_checkbox_field']= false;
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_back_office', $custom_back_office_settings, '', 'yes' );
			
			
			//----------------------------------  EDITOR TEXT SIZE PALETTE ----------------------------------------------------------
			$editor_text_size_settings['eccp_settings_enable_default_gutenberg_editor_font_size_checkbox_field'] = false;
			$editor_text_size_settings['eccp_settings_default_gutenberg_editor_font_size_text_field'] = 18;
			
			// suite a l'introduction d'onglets dans la page de réglages du plugin
			// On ajoute les nouveaux groupes de réglages dans la table option 
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
		    add_option( 'eccp_setting_editor_text_size', $editor_text_size_settings, '', 'yes' );
			
			
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='3.0.9';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '3.0.9':
			//------------------------ MISE A JOUR POUR LA VERSION 3.1 -----------------------------------*/
			
			//----------------------------------  CUSTOM BACK OFFICE ----------------------------------------------------------
			$custom_back_office_settings['eccp_settings_allow_contributors_upload_media_checkbox_field']= false;
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_back_office', $custom_back_office_settings, '', 'yes' );
			
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='3.1';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			
			case '3.1':
			//------------------------ MISE A JOUR POUR LA VERSION 3.1.1 -----------------------------------*/
			
			//----------------------------------  CUSTOM EDITOR  ----------------------------------------------------------
			$custom_gutenberg_editor_settings['eccp_settings_disable_openverse_category_from_media_tab_checkbox_field'] = false;
			$custom_gutenberg_editor_settings['eccp_settings_disable_settings_styles_tabs_for_sidebar_checkbox_field'] = false;
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_gutenberg_editor', $custom_gutenberg_editor_settings, '', 'yes' );
			
			
			//----------------------------------  CUSTOM BACK OFFICE ----------------------------------------------------------
			$custom_back_office_settings['eccp_settings_activate_image_background_login_page_radio_field']= 'no';
			$custom_back_office_settings['eccp_settings_custom_image_background_url_text_field']='';
			$custom_back_office_settings['eccp_settings_enable_login_page_fixed_background_image_checkbox_field']= false;
			$custom_back_office_settings['eccp_settings_activate_publication_status_bulk_actions_posts_checkbox_field'] = false;
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_back_office', $custom_back_office_settings, '', 'yes' );
			
			
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='3.1.1';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '3.1.1':
			//------------------------ MISE A JOUR POUR LA VERSION 3.1.2 -----------------------------------*/
			
			
			//----------------------------------  CUSTOM BACK OFFICE ----------------------------------------------------------
			
			
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='3.1.2';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '3.1.2':
			//------------------------ MISE A JOUR POUR LA VERSION 3.1.3 -----------------------------------*/
			
			
			//----------------------------------  CUSTOM FRONT END ----------------------------------------------------------
			$custom_front_end_settings['eccp_settings_enable_author_info_box_checkbox_field']= false;
			$custom_front_end_settings['eccp_settings_border_radius_avatar_author_info_box_text_field']= 0;
			$custom_front_end_settings['eccp_settings_title_author_info_box_text_field'] = '#222222';
			$custom_front_end_settings['eccp_settings_text_author_info_box_text_field'] = '#666666';
			$custom_front_end_settings['eccp_settings_link_author_info_box_text_field'] = '#0E6487';
			$custom_front_end_settings['eccp_settings_background_author_info_box_text_field'] = '#F5F5F5';
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_front_end', $custom_front_end_settings, '', 'yes' );
			
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='3.1.3';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '3.1.3':
			//------------------------ MISE A JOUR POUR LA VERSION 3.1.4 -----------------------------------*/
			
			
			//----------------------------------  CUSTOM FRONT END ----------------------------------------------------------
			$custom_front_end_settings['eccp_settings_enable_lightbox_checkbox_field']= false;
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_front_end', $custom_front_end_settings, '', 'yes' );
			
			
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='3.1.4';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '3.1.4':
			//------------------------ MISE A JOUR POUR LA VERSION 3.1.5 -----------------------------------*/
			
			//----------------------------------  CUSTOM GUTENBERG BLOCK ----------------------------------------------------------
			$custom_gutenberg_blocks_settings['eccp_settings_enable_script_js_css_swiper_radio_field']= 'no';
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_gutenberg_block', $custom_gutenberg_blocks_settings, '', 'yes' );
			
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='3.1.5';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			case '3.1.5':
			//------------------------ MISE A JOUR POUR LA VERSION 3.1.6 -----------------------------------*/
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='3.1.6';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '3.1.6':
			//------------------------ MISE A JOUR POUR LA VERSION 3.1.7 -----------------------------------*/
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='3.1.7';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '3.1.7':
			//------------------------ MISE A JOUR POUR LA VERSION 3.1.8 -----------------------------------*/
			
			//----------------------------------  CUSTOM EDITOR  ----------------------------------------------------------
			$custom_gutenberg_editor_settings['eccp_settings_enable_editor_background_color_checkbox_field'] = false;
			$custom_gutenberg_editor_settings['eccp_settings_editor_background_color_text_field'] = '#FFFFFF';
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_gutenberg_editor', $custom_gutenberg_editor_settings, '', 'yes' );
			
			
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='3.1.8';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			case '3.1.8':
			//------------------------ MISE A JOUR POUR LA VERSION 3.1.9 -----------------------------------*/
			
			//----------------------------------  CUSTOM GUTENBERG BLOCK ----------------------------------------------------------
			$custom_gutenberg_blocks_settings['eccp_settings_activate_reponsive_tables_radio_field']= 'no';
			
			// On met a jour la table option avec notamment ces nouveaux réglages
			//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
			update_option( 'eccp_settings_custom_gutenberg_block', $custom_gutenberg_blocks_settings, '', 'yes' );
			
			
			// mise a jour version logicielle pour la base de données	
			$active_version ='3.1.9';
			// Sanitize text 
            $active_version = sanitize_text_field($active_version);
			update_option( 'active_plugin_version', $active_version, '', 'yes' );
			break;
			
			
			
			
			default:
			// pour sortir de la boucle While
            $active_version = ECCP_PLUGIN_VERSION;
		
		
			
		} // end switch ($active_version)
		
	}// end while ($active_version != ECCP_PLUGIN_VERSION)

}


/*----------------------------------------------------------------------------*
 *                      5. Uninstall Plugin
 *----------------------------------------------------------------------------*/
 
 
 
// a la désinstallation du plugin on supprime les réglages du plugin dans la table wp_options
function eccp_editor_custom_color_palette_uninstall() {
	
   delete_option( 'eccp_settings_default_settings' );
   delete_option( 'eccp_multiple_setting' );
   delete_option( 'eccp_setting_editor_text_size' );
   delete_option( 'eccp_settings_custom_gutenberg_editor' );
   delete_option( 'eccp_settings_custom_gutenberg_block' );
   delete_option( 'eccp_settings_reusable_blocks' );
   delete_option( 'eccp_settings_elementor' );
   delete_option( 'eccp_settings_divi_theme' );
   delete_option( 'eccp_settings_custom_back_office' );
   delete_option( 'eccp_settings_custom_front_end' );
   delete_option( 'active_plugin_version' );
   
}

// on récupère les paramètres de réglages renseignés par l'utilisateur
$default_settings  = get_option( 'eccp_settings_default_settings' );

// si on a paramétré la suppression des données de la base
if ($default_settings['eccp_delete_data_uninstallation_radio_field'] == 'yes') {
	register_uninstall_hook( __FILE__, 'eccp_editor_custom_color_palette_uninstall' );
}


/*----------------------------------------------------------------------------------------
		        RÉCUPÉRATION DES PARAMÉTRES DU PLUGIN DÉFINIT PAR L'UTILISATEUR
/*---------------------------------------------------------------------------------------*/

// On récupère les paramètres pour tous les onglets de réglages du plugin
$default_settings = get_option( 'eccp_settings_default_settings' );
$settings = get_option( 'eccp_multiple_setting' );
$editor_text_size_settings = get_option( 'eccp_setting_editor_text_size' );
$custom_gutenberg_editor_settings = get_option( 'eccp_settings_custom_gutenberg_editor' );
$custom_gutenberg_blocks_settings = get_option( 'eccp_settings_custom_gutenberg_block' );
$reusable_blocks_settings = get_option( 'eccp_settings_reusable_blocks' );
$elementor_settings = get_option( 'eccp_settings_elementor' );
$divi_settings = get_option( 'eccp_settings_divi_theme' );
$custom_back_office_settings = get_option( 'eccp_settings_custom_back_office' );
$custom_front_end_settings = get_option( 'eccp_settings_custom_front_end' );
	
if ( empty( $default_settings ) || empty( $settings ) || empty( $editor_text_size_settings ) || empty( $custom_gutenberg_editor_settings )
     || empty( $custom_gutenberg_blocks_settings ) || empty( $reusable_blocks_settings ) || empty( $elementor_settings ) || empty( $divi_settings )
	 || empty( $custom_back_office_settings ) || empty( $custom_front_end_settings ) 	) {
	return;
}


/*---------------------------------------------------------------------------------------*
 *                  6. chargement feuilles de style du plugin
 *--------------------------------------------------------------------------------------*/

// On charge les feuille de style pour la partie back office du plugin concernant
// l'éditeur Gutenberg
// pour bien déclarer le style uniquemment pour l'éditeur en back office on utilise 
// le hook: enqueue_block_editor_assets
// le tableau array() indique les dépendances autrement dit indiquer à 
// WordPress que notre style devrait absolument être chargé après les styles indiqués en dépendances 
// soit wp-edit-blocks pour les styles dans l'éditeur
// le numéro de version est important car il va permettre d’invalider le cache du navigateur 
// lorsqu'on fera évoluer le style.
// par défaut le dernier paramètre est à false et le style est chargé dans le head

if ( !function_exists('eccp_chargement_style_back_office') ) {
	
	function eccp_chargement_style_back_office() {
		
		// Style back office de l'éditeur Gutenberg
		wp_enqueue_style( 
			'eccp_chargement_style_back_office', 
			EDITOR_CUSTOM_COLOR_PALETTE_URL . 'css/eccp-editor-gutenberg-back-office.php',
			array('wp-edit-blocks'), 
			ECCP_PLUGIN_VERSION
		);
		
		
	}
	
}
//add_action( 'enqueue_block_editor_assets', 'eccp_chargement_style_back_office','15' );



// chargement feuille de style pour les pages de réglages du plugin en back office
function eccp_custom_admin_styling() {
		
		wp_enqueue_style( 
			'eccp-admin-style', 
			esc_url(EDITOR_CUSTOM_COLOR_PALETTE_URL) . 'css/eccp-admin-style.css',
			array(), 
			ECCP_PLUGIN_VERSION
		);
		
}

add_action( 'admin_enqueue_scripts', 'eccp_custom_admin_styling','11' );


// Ajout feuille de style des Icônes Dashicons pour WordPress en Front-end
function eccp_load_dashicons_front_end() {
  wp_enqueue_style( 'dashicons' );
}

add_action( 'wp_enqueue_scripts', 'eccp_load_dashicons_front_end' );


/*---------------------------------------------------------------------------------------*
 *                  chargement scripts du plugin
 *--------------------------------------------------------------------------------------*/

/*------------------- Chargement script pour le Color Picker ----------------*/

// Mettre en file d'attente le script et le style wp-color-picker 
// le fichier javascript dans lequel on écrit ces lignes se trouve dans le sous-dossier js du plugin
// On utilise donc pour l'URL du script: EDITOR_CUSTOM_COLOR_PALETTE_URL . 'js/eccp-script.js' => plugin_dir_url( __FILE__ ) . 'js/eccp-script.js'  
// car cette fonction de chargement de script est dans le fichier principal du plugin
// si cette fonction était dans un sous dossier du plugin l'URL du script aurait été:
// plugins_url('js/eccp-script.js', dirname(__FILE__) )
// Mon plugin a maintenant un eccp-script.js fichier qui a été déclaré en tant que dépendance de wp-color-picker
add_action( 'admin_enqueue_scripts', 'eccp_enqueue_color_picker' );

function eccp_enqueue_color_picker( $hook_suffix ) {
    
	/*---- Chargement style & script pour le color picker -----*/
    wp_enqueue_style( 'wp-color-picker' );
	wp_enqueue_script( 'wp-color-picker' );// modif version 1.8
	// paramètre: handle,URL script, dépendance, Version , True: script inséré dans le footer
    wp_enqueue_script( 'my-script-handle', esc_url(EDITOR_CUSTOM_COLOR_PALETTE_URL) . 'js/eccp-color-picker.js', array( 'wp-color-picker' ), false, true );

}

/*------------------- Chargement script pour la personnalisation des blocs Gutenberg ----------------*/

// si on a activé le chargement du script basé sur ReactJS
if( $custom_gutenberg_blocks_settings['eccp_settings_activate_script_reactjs_radio_field'] == 'yes' ) {

// le hook 'enqueue_block_editor_assets' Se déclenche après la mise en file d'attente 
// des actifs de bloc pour l'interface d'édition.
add_action( 'enqueue_block_editor_assets', 'eccp_enqueue_custom_block',10);

}																												

function eccp_enqueue_custom_block(  ) {
	
	// paramètre: handle,URL script, dépendance, Version , True: script inséré dans le footer
	// dépendance: wp-blocks pour le bloc lui-même, le reste conforme a la doc WordPress pour les blocs etc...
	// Dépendance: 'wp-plugins','wp-data','wp-components' pour la barre latérale Document personnalisé
	wp_enqueue_script( 'eccp-custom-blocks', esc_url(EDITOR_CUSTOM_COLOR_PALETTE_URL . 'js/eccp-custom-blocks.js'), array( 'wp-blocks', 'wp-dom', 'wp-dom-ready', 'wp-edit-post','wp-element','wp-i18n','wp-plugins','wp-data','wp-components'), ECCP_PLUGIN_VERSION, true );

	// Activation des traductions avec wp_set_script_translations
	// Définit les chaînes traduites pour un script js.
	// paramètre: handle ,text domain ,Le chemin d'accès complet au répertoire contenant les fichiers de traduction.
	// le handle:eccp-custom-blocks doit être le même que pour le script eccp-custom-blocks.js des blocs 
	wp_set_script_translations ( 
		'eccp-custom-blocks', 
		'editor-custom-color-palette',
		plugin_dir_path( __FILE__ ) . 'languages' 
	);

}


/*---- Chargement script pour le bouton Upload Media -----*/

add_action('admin_enqueue_scripts', 'eccp_enqueue_upload_media');

function eccp_enqueue_upload_media() {
	
	/* autre manière de tester l'écran d'administration
	$screen = get_current_screen();
	if ( $screen->id == 'eccp_settings_page' ) {
	}
	*/
	
	// chargement script seulement sur la page de réglages du plugin
    if (isset($_GET['page']) && $_GET['page'] == 'eccp_settings_page') {
		
		//Met en file d'attente tous les scripts, styles, paramètres et modèles nécessaires 
		// pour utiliser toutes les API JS multimédias.
        wp_enqueue_media();
		
		// wp_enqueue_script : met en file d'attente notre script
		// paramètre: handle,URL script, dépendance, Version , True: script inséré dans le footer
		wp_enqueue_script( 'eccp-upload-media-js', esc_url(EDITOR_CUSTOM_COLOR_PALETTE_URL) . 'js/eccp-upload-media.js', array( 'jquery' ), false, true );
    }
	
}


/*------------------- Chargement script pour l'upload Image en Avant sur l'écran Modification Rapide  ----------------*/

if ($custom_back_office_settings['eccp_settings_activate_post_featured_image_column_checkbox_field'] ||
	$custom_back_office_settings['eccp_settings_activate_page_featured_image_column_checkbox_field']) {
		add_action( 'admin_enqueue_scripts', 'eccp_enqueue_quick_edit_screen',10);
}

function eccp_enqueue_quick_edit_screen(  ) {
	
	//Met en file d'attente tous les scripts, styles, paramètres et modèles nécessaires 
	// pour utiliser toutes les API JS multimédias.
	wp_enqueue_media();
	
	// paramètre: handle,URL script, dépendance, Version , True: script inséré dans le footer
	// dépendance: jquery
	wp_enqueue_script( 'eccp-quick_edit_screen', esc_url(EDITOR_CUSTOM_COLOR_PALETTE_URL . 'js/eccp-upload-featured-image.js'), array( 'jquery' ), false, true  );

}


/*---- Chargement script pour la mise a jour des métas de publication sur l'écran Modification Rapide -----*/

// script pour mettre a jour les champs checkbox de l'edition rapide
// en fonction de la valeur des métas de publication:
// remove_blocks_before_content & remove_blocks_after_content
// affiché dans les lignes de publications
add_action('admin_enqueue_scripts', 'eccp_remove_blocks_before_after_content');

function eccp_remove_blocks_before_after_content() {
	
		// wp_enqueue_script : met en file d'attente notre script
		// paramètre: handle,URL script, dépendance, Version , True: script inséré dans le footer
		wp_enqueue_script( 'eccp-remove-blocks-before-after-content', esc_url(EDITOR_CUSTOM_COLOR_PALETTE_URL) . 'js/eccp-remove-before-after-content-quick-edit.js', array('jquery'), false, true );
	
}


/*---- Chargement script pour Transformer le Bloc FAQ de Yoast en accordéon basculable -----*/

// si on activé la personnalisation du bloc FAQ Yoast SEO
if( $custom_gutenberg_blocks_settings['eccp_settings_turn_yoast_faq_block_an_accordion_radio_field'] == 'yes' ) {
	add_action('wp_enqueue_scripts', 'eccp_enqueue_faq_yoast');
}

function eccp_enqueue_faq_yoast() {
		
	// wp_enqueue_script : met en file d'attente notre script
	// paramètre: handle,URL script, dépendance, Version , True: script inséré dans le footer
	wp_enqueue_script( 'eccp-yoast-faq', esc_url(EDITOR_CUSTOM_COLOR_PALETTE_URL) . 'js/eccp-yoast-faq-block.js', array( 'jquery' ), false, true );

}


/*---- Chargement script pour Transformer le Bloc LISTE en accordéon basculable -----*/

// si on a activé les styles de liste à puces
if( $custom_gutenberg_blocks_settings['eccp_settings_activate_styles_bullet_list_radio_field'] == 'yes' ) {
	add_action('wp_enqueue_scripts', 'eccp_enqueue_accordion_list_block');
}

function eccp_enqueue_accordion_list_block() {
		
	// wp_enqueue_script : met en file d'attente notre script
	// paramètre: handle,URL script, dépendance, Version , True: script inséré dans le footer
	wp_enqueue_script( 'eccp-accordion-list-block', esc_url(EDITOR_CUSTOM_COLOR_PALETTE_URL) . 'js/eccp-accordion-list-block.js', array( 'jquery' ), false, true );

}


/*---- Chargement script pour ajout d'une fonctionnalité de clic au lien des blocs -----*/


add_action('wp_enqueue_scripts', 'eccp_enqueue_link_blocks');


function eccp_enqueue_link_blocks() {
		
	// wp_enqueue_script : met en file d'attente notre script
	// paramètre: handle,URL script, dépendance, Version , True: script inséré dans le footer
	wp_enqueue_script( 'eccp-link-blocks', esc_url(EDITOR_CUSTOM_COLOR_PALETTE_URL) . 'js/eccp-link-blocks.js', array( 'jquery' ), false, true );

}


/*---- Chargement script pour le bouton retour vers le haut en admin -----*/

// cache le bouton retour vers le haut en position haute < 1000
// apparition du bouton retour vers le haut avec un fading pour une position > 1000
// permet un défilement fluide vers le haut

add_action('wp_enqueue_scripts', 'eccp_enqueue_scroll_to_top');

function eccp_enqueue_scroll_to_top() {
	
	// chargement script seulement sur la page de réglages du plugin
    if (isset($_GET['page']) && $_GET['page'] == 'eccp_settings_page') {
	
		// wp_enqueue_script : met en file d'attente notre script
		// paramètre: handle,URL script, dépendance, Version , True: script inséré dans le footer
		wp_enqueue_script( 'eccp-scroll-to-top', esc_url(EDITOR_CUSTOM_COLOR_PALETTE_URL) . 'js/eccp-scroll-to-top.js', array('jquery'), false, true );
	
	}
}

/*---- Chargement script pour le bouton retour vers le haut en Front End -----*/

if ($custom_front_end_settings['eccp_settings_enable_back_to_top_button_checkbox_field']) {
	add_action('wp_enqueue_scripts', 'eccp_enqueue_scroll_to_top_front_end');
}

function eccp_enqueue_scroll_to_top_front_end() {
	
	// wp_enqueue_script : met en file d'attente notre script
	// paramètre: handle,URL script, dépendance, Version , True: script inséré dans le footer
	wp_enqueue_script( 'eccp-scroll-to-top', esc_url(EDITOR_CUSTOM_COLOR_PALETTE_URL) . 'js/eccp-scroll-to-top.js', array('jquery'), false, true );

}


/*---- Chargement scripts pour la lightbox en Front End -----*/

function eccp_enqueue_lightbox_front_end() {
	
	// Pour les Pages & Articles & CPT 
	if ( (is_single() || is_page()) ) {
		
		// wp_enqueue_script : met en file d'attente notre script
		// paramètre: handle,URL script, dépendance, Version , True: script inséré dans le footer
		wp_enqueue_script( 'eccp-lightbox', esc_url(EDITOR_CUSTOM_COLOR_PALETTE_URL) . 'js/eccp-lightbox.js', array('jquery'), false, true );

	}
}

if ($custom_front_end_settings['eccp_settings_enable_lightbox_checkbox_field']) {
	add_action('wp_enqueue_scripts', 'eccp_enqueue_lightbox_front_end');
}



// chargement des scripts JS & CSS de la Fancybox via un CDN
// necessaire pour la Lightbox en Front End
function eccp_load_fancy_box_script() {
	
	// Pour les Pages & Articles & CPT
	if ( is_single() || is_page() ) {
		
		?>
		<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.umd.js"></script>


		<link
		  rel="stylesheet"
		  type="text/css"
		  href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.css"
		/>
		<?php 
		
	}
}

if ($custom_front_end_settings['eccp_settings_enable_lightbox_checkbox_field']) {
	add_action('wp_head','eccp_load_fancy_box_script');
}


/*---- Chargement scripts pour le Slider Swiper en Front End -----*/

// chargement script configuration du slider 
function eccp_enqueue_slider_swipe() {
	
	// Pour les Pages & Articles & CPT 
	if ( (is_single() || is_page()) ) {
		
		// wp_enqueue_script : met en file d'attente notre script
		// paramètre: handle,URL script, dépendance, Version , True: script inséré dans le footer
		wp_enqueue_script( 'eccp-slider-swipe', esc_url(EDITOR_CUSTOM_COLOR_PALETTE_URL) . 'js/eccp-slider-swiper.js', array('jquery'), false, true );

	}
}

if ($custom_gutenberg_blocks_settings['eccp_settings_enable_script_js_css_swiper_radio_field'] == 'yes') {
	add_action('wp_enqueue_scripts', 'eccp_enqueue_slider_swipe');
}



// chargement des scripts JS & CSS de la librairie Swiper via un CDN
// necessaire pour le slider en Front End
function eccp_load_slider_swipe_script() {
	
	// Pour les Pages & Articles & CPT
	if ( is_single() || is_page() ) {
		
		?>
		<script src="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.js"></script>


		<link
			rel="stylesheet"
			href="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.css"
		/>
		<?php 
	
	}
	
}

if ($custom_gutenberg_blocks_settings['eccp_settings_enable_script_js_css_swiper_radio_field'] == 'yes') {
	add_action('wp_head','eccp_load_slider_swipe_script');
}



/*---- Chargement script pour le bloc icônes sociales flottant a droite -----*/

// script pour le bloc Icônes sociales de classe is-style-eccp-social-icons-floating-right
// ou de classe is-style-eccp-social-icons-floating-left
// cache le bloc pour une position haute < 1000
// apparition du bloc avec un fading pour une position haute > 1000

if($custom_gutenberg_blocks_settings['eccp_settings_activate_rectangle_shape_style_radio_field'] == 'yes') {
	add_action('wp_enqueue_scripts', 'eccp_fadeout_to_top_floating_social_icons');
}

function eccp_fadeout_to_top_floating_social_icons() {
	
		// wp_enqueue_script : met en file d'attente notre script
		// paramètre: handle,URL script, dépendance, Version , True: script inséré dans le footer
		wp_enqueue_script( 'eccp-fadeout-to-top-floating-social-icons', esc_url(EDITOR_CUSTOM_COLOR_PALETTE_URL) . 'js/eccp-fadeout-to-top-floating-social-icons.js', array('jquery'), false, true );
	
}


/*---- Chargement script pour le bloc icônes sociales avec liens de partage -----*/

if($custom_gutenberg_blocks_settings['eccp_settings_activate_rectangle_shape_style_radio_field'] == 'yes') {
	// script pour le bloc Icônes sociales de classe is-style-eccp-social-sharing-link
	add_action('wp_enqueue_scripts', 'eccp_social_link_sharing');
}

function eccp_social_link_sharing() {
	
		// wp_enqueue_script : met en file d'attente notre script
		// paramètre: handle,URL script, dépendance, Version , True: script inséré dans le footer
		wp_enqueue_script( 'eccp-social-link-sharing', esc_url(EDITOR_CUSTOM_COLOR_PALETTE_URL) . 'js/eccp-social-link-sharing.js', array('jquery'), false, true );
	
}


/*---- Chargement script pour le compte a rebours -----*/

// script pour la variante de bloc countdowntimer
add_action('wp_enqueue_scripts', 'eccp_countdown_timer');

function eccp_countdown_timer() {
	
		// wp_enqueue_script : met en file d'attente notre script
		// paramètre: handle,URL script, dépendance, Version , True: script inséré dans le footer
		wp_enqueue_script( 'eccp-countdown-timer', esc_url(EDITOR_CUSTOM_COLOR_PALETTE_URL) . 'js/eccp-countdown-timer.js', array('jquery'), false, true );
	
}


/*---- Chargement script pour une table responsive -----*/

if( $custom_gutenberg_blocks_settings['eccp_settings_activate_reponsive_tables_radio_field'] == 'yes' ) {
	// script pour des tables responsives
	add_action('wp_enqueue_scripts', 'eccp_responsive_tables');
}

function eccp_responsive_tables() {
	
		// wp_enqueue_script : met en file d'attente notre script
		// paramètre: handle,URL script, dépendance, Version , True: script inséré dans le footer
		wp_enqueue_script( 'eccp-responsive-tables', esc_url(EDITOR_CUSTOM_COLOR_PALETTE_URL) . 'js/eccp-responsive-tables.js', array('jquery'), false, true );
	
}

/*---------------------------------------------------------------------------------------*
 *        Lien Paramètres pour le plugin sur le panneau de la page des extensions 
 *--------------------------------------------------------------------------------------*/
 
function eccp_plugin_settings_link( $links ) : array {
	
    $label_settings = esc_html__( 'Settings', 'editor-custom-color-palette' );
	$label_demo = esc_html__('Demo');
    $slug  = esc_html__('eccp_settings_page');

	// on utilise la fonction array_unshift() pour mettre les liens Settings & Demo
	// avant celui de Désactiver
    array_unshift( $links, 
	               "<a href='options-general.php?page=$slug'>$label_settings</a> |
				    <a href='https://rouerguecreation.fr/demo-editor-custom-color-palette/' target='_blank'>$label_demo</a>" 
				 );

    return $links;
	
}

// le hook de base est plugin_action_links actif pour tous les plugins installés
// pour éviter une vérification conditionnelle du plugin
// on ajoute simplement le chemin relatif du plugin au hook.
// soit: plugin_action_links_editor-custom-color-palette/editor-custom-color-palette.php
add_action( 'plugin_action_links_' . ECCP_PLUGIN_PATH_NAME, 'eccp_plugin_settings_link', 10 );



/*----------------------------------------------------------------------------------------
		        CONVERSION DES COULEURS DE LA PALETTE HEXADECIMAL EN RGBA
/*---------------------------------------------------------------------------------------*/

// Couleur N°1
// si l'opacité est différente de 100 on fait la conversion en RGBA
if ( $settings['eccp_settings_opacity_color_one_text_field'] <> '100' ) {
	
$settings['eccp_settings_color_one'] = eccp_hex2rgba( $settings['eccp_settings_color_one_text_field'], 
intval($settings['eccp_settings_opacity_color_one_text_field'])/100 );

// sinon on retourne la valeur Hexadécimale
}else{
	$settings['eccp_settings_color_one'] = $settings['eccp_settings_color_one_text_field'];
}

// Couleur N°2
if ( $settings['eccp_settings_opacity_color_two_text_field'] <> '100' ) {
	
$settings['eccp_settings_color_two'] = eccp_hex2rgba( $settings['eccp_settings_color_two_text_field'], 
intval($settings['eccp_settings_opacity_color_two_text_field'])/100 );

}else{
	$settings['eccp_settings_color_two'] = $settings['eccp_settings_color_two_text_field'];
}

// Couleur N°3
if ( $settings['eccp_settings_opacity_color_three_text_field'] <> '100' ) {
	
$settings['eccp_settings_color_three'] = eccp_hex2rgba( $settings['eccp_settings_color_three_text_field'], 
intval($settings['eccp_settings_opacity_color_three_text_field'])/100 );

}else{
	$settings['eccp_settings_color_three'] = $settings['eccp_settings_color_three_text_field'];
}

// Couleur N°4
if ( $settings['eccp_settings_opacity_color_four_text_field'] <> '100' ) {
	
$settings['eccp_settings_color_four'] = eccp_hex2rgba( $settings['eccp_settings_color_four_text_field'], 
intval($settings['eccp_settings_opacity_color_four_text_field'])/100 );

}else{
	$settings['eccp_settings_color_four'] = $settings['eccp_settings_color_four_text_field'];
}

// Couleur N°5
if ( $settings['eccp_settings_opacity_color_five_text_field'] <> '100' ) {
	
$settings['eccp_settings_color_five'] = eccp_hex2rgba( $settings['eccp_settings_color_five_text_field'], 
intval($settings['eccp_settings_opacity_color_five_text_field'])/100 );

}else{
	$settings['eccp_settings_color_five'] = $settings['eccp_settings_color_five_text_field'];
}

// Couleur N°6
if ( $settings['eccp_settings_opacity_color_six_text_field'] <> '100' ) {
	
$settings['eccp_settings_color_six'] = eccp_hex2rgba( $settings['eccp_settings_color_six_text_field'], 
intval($settings['eccp_settings_opacity_color_six_text_field'])/100 );

}else{
	$settings['eccp_settings_color_six'] = $settings['eccp_settings_color_six_text_field'];
}

// Couleur N°7
if ( $settings['eccp_settings_opacity_color_seven_text_field'] <> '100' ) {
	
$settings['eccp_settings_color_seven'] = eccp_hex2rgba( $settings['eccp_settings_color_seven_text_field'], 
intval($settings['eccp_settings_opacity_color_seven_text_field'])/100 );

}else{
	$settings['eccp_settings_color_seven'] = $settings['eccp_settings_color_seven_text_field'];
}

// Couleur N°8
if ( $settings['eccp_settings_opacity_color_eight_text_field'] <> '100' ) {
	
$settings['eccp_settings_color_eight'] = eccp_hex2rgba( $settings['eccp_settings_color_eight_text_field'], 
intval($settings['eccp_settings_opacity_color_eight_text_field'])/100 );

}else{
	$settings['eccp_settings_color_eight'] = $settings['eccp_settings_color_eight_text_field'];
}

// Couleur N°9
if ( $settings['eccp_settings_opacity_color_nine_text_field'] <> '100' ) {
	
$settings['eccp_settings_color_nine'] = eccp_hex2rgba( $settings['eccp_settings_color_nine_text_field'], 
intval($settings['eccp_settings_opacity_color_nine_text_field'])/100 );

}else{
	$settings['eccp_settings_color_nine'] = $settings['eccp_settings_color_nine_text_field'];
}

// Couleur N°10
if ( $settings['eccp_settings_opacity_color_ten_text_field'] <> '100' ) {
	
$settings['eccp_settings_color_ten'] = eccp_hex2rgba( $settings['eccp_settings_color_ten_text_field'], 
intval($settings['eccp_settings_opacity_color_ten_text_field'])/100 );

}else{
	$settings['eccp_settings_color_ten'] = $settings['eccp_settings_color_ten_text_field'];
}

// Couleur N°11
if ( $settings['eccp_settings_opacity_color_eleven_text_field'] <> '100' ) {
	
$settings['eccp_settings_color_eleven'] = eccp_hex2rgba( $settings['eccp_settings_color_eleven_text_field'], 
intval($settings['eccp_settings_opacity_color_eleven_text_field'])/100 );

}else{
	$settings['eccp_settings_color_eleven'] = $settings['eccp_settings_color_eleven_text_field'];
}

// Couleur N°12
if ( $settings['eccp_settings_opacity_color_twelve_text_field'] <> '100' ) {
	
$settings['eccp_settings_color_twelve'] = eccp_hex2rgba( $settings['eccp_settings_color_twelve_text_field'], 
intval($settings['eccp_settings_opacity_color_twelve_text_field'])/100 );

}else{
	$settings['eccp_settings_color_twelve'] = $settings['eccp_settings_color_twelve_text_field'];
}


// Couleur de bordure pour le bloc réutilisable Mettre En Évidence
if ( $reusable_blocks_settings['eccp_settings_opacity_custom_paragraph_border_color_text_field'] <> '100' ) {
	
$reusable_blocks_settings['eccp_settings_custom_paragraph_border_color'] = eccp_hex2rgba( $reusable_blocks_settings['eccp_settings_custom_paragraph_border_color_text_field'], 
intval($reusable_blocks_settings['eccp_settings_opacity_custom_paragraph_border_color_text_field'])/100 );

}else{
	$reusable_blocks_settings['eccp_settings_custom_paragraph_border_color'] = $settings['eccp_settings_custom_paragraph_border_color_text_field'];
}


// On met a jour la table option avec notamment ces nouveaux réglages pour la palette de couleurs & les blocs réutilisables
//Paramètres :  option_name , option_value , Description (plus utilisé) , Autoload(charger l'option au démarrage de WordPress)
update_option( 'eccp_multiple_setting', $settings, '', 'yes' );
update_option( 'eccp_settings_reusable_blocks', $reusable_blocks_settings, '', 'yes' );


/***********************************************************************************************
                              MODIFIER PALETTE DE COULEUR EDITEUR GUTENBERG            
***********************************************************************************************/

/*  
	Pour définir une palette de couleurs personnalisée dans l'éditeur Gutenberg, 
	nous allons utiliser le hook 'editor-color-palette' avec la fonction add_theme_support().
	Cette fonction accepte un tableau de couleurs. 
	Pour chaque couleurs, nous allons définir :

	Le nom : affiché dans l'info-bulle qui apparaît au survol
	Le slug : Un identifiant unique pour la couleur. Utilisé pour générer les classes CSS  et styliser le frontend.
	La couleur :  en notation hexadécimale ou RGBA pour spécifier la couleur

	La traduction des noms pour les couleurs de police n'est pas prise en compte avec le crochet d'action 
	'after_setup_theme' alors on utilise le le hook init: initialisation de WordPress.

	Cela marche dans l'éditeur Gutenberg mais,
	les couleurs ne sont pas générées sur l'interface publique, 
	c’est simplement une classe correspondant au slug de la couleur qui sera ajoutée au bloc.
	exemple pour une couleur noire
	.has-noir-background-color{background-color:#333333;} pour la couleur de fond
	.has-noir-color{color:#333333;} pour la couleur de texte
	.has-strong-noir-color{color:#333333;} pour la couleur de texte en gras
	
	On va donc en front-end générer les couleurs par du CSS Dynamique:
	CSS DYNAMIQUE PALETTE DE COULEURS GUTENBERG (Front End)
	
	Par Ailleurs dans l'editeur Gutenberg, si on fait une sélection du texte 
	et que l'on veut modifier la couleur via la barre d'outils du bloc,
	avec la palette de couleur qui apparait en fenêtre modale,
	cela n'est pas pris en compte en back office, 
	mais ok en Front end. Pour régler le problème, 
	on va donc aussi en BACK OFFICE générer les couleurs par du CSS Dynamique:
	CSS DYNAMIQUE PALETTE DE COULEURS GUTENBERG (Back office)
	
*/

function eccp_color_palette_gutenberg($slug) {

	// On récupère les paramètres général de réglages du plugin
	$settings = get_option( 'eccp_multiple_setting' );

	add_theme_support( 'editor-color-palette', 
		array(
			array(
				'name' => __( $settings['eccp_settings_name_color_one_text_field'],'editor-custom-color-palette' ),
				'slug' => $settings['eccp_settings_slug_color_one_text_field'],
				'color' => $settings['eccp_settings_color_one'] ,
			),
			array(
				'name' => __( $settings['eccp_settings_name_color_two_text_field'],'editor-custom-color-palette' ),
				'slug' => $settings['eccp_settings_slug_color_two_text_field'],
				'color' => $settings['eccp_settings_color_two'] ,
			),
			array(
				'name' => __( $settings['eccp_settings_name_color_three_text_field'],'editor-custom-color-palette' ),
				'slug' => $settings['eccp_settings_slug_color_three_text_field'],
				'color' => $settings['eccp_settings_color_three'] ,
			),
			array(
				'name' => __( $settings['eccp_settings_name_color_four_text_field'],'editor-custom-color-palette' ),
				'slug' => $settings['eccp_settings_slug_color_four_text_field'],
				'color' => $settings['eccp_settings_color_four'] ,
			),
			array(
				'name' => __( $settings['eccp_settings_name_color_five_text_field'],'editor-custom-color-palette' ),
				'slug' => $settings['eccp_settings_slug_color_five_text_field'],
				'color' => $settings['eccp_settings_color_five'] ,
			),
			array(
				'name' => __( $settings['eccp_settings_name_color_six_text_field'],'editor-custom-color-palette' ),
				'slug' => $settings['eccp_settings_slug_color_six_text_field'],
				'color' => $settings['eccp_settings_color_six'] ,
			),
			array(
				'name' => __( $settings['eccp_settings_name_color_seven_text_field'],'editor-custom-color-palette' ),
				'slug' => $settings['eccp_settings_slug_color_seven_text_field'],
				'color' => $settings['eccp_settings_color_seven'] ,
			),
			array(
				'name' => __( $settings['eccp_settings_name_color_eight_text_field'],'editor-custom-color-palette' ),
				'slug' => $settings['eccp_settings_slug_color_eight_text_field'],
				'color' => $settings['eccp_settings_color_eight'] ,
			),
			array(
				'name' => __( $settings['eccp_settings_name_color_nine_text_field'],'editor-custom-color-palette' ),
				'slug' => $settings['eccp_settings_slug_color_nine_text_field'],
				'color' => $settings['eccp_settings_color_nine'] ,
			),
			array(
				'name' => __( $settings['eccp_settings_name_color_ten_text_field'],'editor-custom-color-palette' ),
				'slug' => $settings['eccp_settings_slug_color_ten_text_field'],
				'color' => $settings['eccp_settings_color_ten'] ,
			),
			array(
				'name' => __( $settings['eccp_settings_name_color_eleven_text_field'],'editor-custom-color-palette' ),
				'slug' => $settings['eccp_settings_slug_color_eleven_text_field'],
				'color' => $settings['eccp_settings_color_eleven'] ,
			),
			array(
				'name' => __( $settings['eccp_settings_name_color_twelve_text_field'],'editor-custom-color-palette' ),
				'slug' => $settings['eccp_settings_slug_color_twelve_text_field'],
				'color' => $settings['eccp_settings_color_twelve'] ,
			),
			
		) 
	);


}

// si on a activé la personnalisation de la palette de couleurs Gutenberg
if( $settings['eccp_settings_activate_customizing_color_palette_checkbox_field'] == true ) {
	add_action( 'init', 'eccp_color_palette_gutenberg',10,1 );
}


/***********************************************************************************************
       MODIFIER PALETTE DE COULEUR EDITEUR GUTENBERG INTITULEE THEME POUR UN THEME JSON             
***********************************************************************************************/
	
	/*
	Pour définir une palette de couleurs personnalisée dans Gutenberg, 
	nous allons utiliser le hook 'wp_theme_json_data_theme' introduit par WordPress 6.1
	qui permet de filtrer les paramétres de theme.json.
	la fonction utilisé avec le hook retourne la méthode update_with( $new_data )
	avec $new_data ayant une structure de type valide theme.json
	 
	On commence par déclarer quelle version de theme.json on utilise depuis WordPress 5.9
	c'est la version V2
	Ensuite on a le tableau settings qui comprend le tableau color
	ou l'on va renseigner dans le tableau palette notre palette de couleurs personnalisées
	
	Le nom : affiché dans l'info-bulle qui apparaît au survol
	Le slug : Un identifiant unique pour la couleur. Utilisé pour générer les classes CSS  et styliser le frontend.
	La couleur :  en notation hexadécimale ou RGBA pour spécifier la couleur

	Cela marche dans l'éditeur Gutenberg mais,
	les couleurs ne sont pas générées sur l'interface publique, 
	c’est simplement une classe correspondant au slug de la couleur qui sera ajoutée au bloc.
	exemple pour une couleur noire
	.has-noir-background-color{background-color:#333333;} pour la couleur de fond
	.has-noir-color{color:#333333;} pour la couleur de texte
	.has-strong-noir-color{color:#333333;} pour la couleur de texte en gras
	
	On va donc en front-end générer les couleurs par du CSS Dynamique:
	CSS DYNAMIQUE PALETTE DE COULEURS GUTENBERG (Front End)
	
	Par Ailleurs dans l'editeur Gutenberg, si on fait une sélection du texte 
	et que l'on veut modifier la couleur via la barre d'outils du bloc,
	avec la palette de couleur qui apparait en fenêtre modale,
	cela n'est pas pris en compte en back office, 
	mais ok en Front end. Pour régler le problème, 
	on va donc aussi en BACK OFFICE générer les couleurs par du CSS Dynamique:
	CSS DYNAMIQUE PALETTE DE COULEURS GUTENBERG (Back office)
	
	*/

function eccp_color_palette_theme_json( $theme_json ){
	
	// On récupère les paramètres général de réglages du plugin
	$settings = get_option( 'eccp_multiple_setting' );
	
    $new_data = array(
	
        'version'  => 2,
		
        'settings' => array(
		
            'color' => array(
			
                'palette' => array( 
				
                    array(
						'name' => __( $settings['eccp_settings_name_color_one_text_field'],'editor-custom-color-palette' ),
						'slug' => $settings['eccp_settings_slug_color_one_text_field'],
						'color' => $settings['eccp_settings_color_one'] ,
					),
					array(
						'name' => __( $settings['eccp_settings_name_color_two_text_field'],'editor-custom-color-palette' ),
						'slug' => $settings['eccp_settings_slug_color_two_text_field'],
						'color' => $settings['eccp_settings_color_two'] ,
					),
					array(
						'name' => __( $settings['eccp_settings_name_color_three_text_field'],'editor-custom-color-palette' ),
						'slug' => $settings['eccp_settings_slug_color_three_text_field'],
						'color' => $settings['eccp_settings_color_three'] ,
					),
					array(
						'name' => __( $settings['eccp_settings_name_color_four_text_field'],'editor-custom-color-palette' ),
						'slug' => $settings['eccp_settings_slug_color_four_text_field'],
						'color' => $settings['eccp_settings_color_four'] ,
					),
					array(
						'name' => __( $settings['eccp_settings_name_color_five_text_field'],'editor-custom-color-palette' ),
						'slug' => $settings['eccp_settings_slug_color_five_text_field'],
						'color' => $settings['eccp_settings_color_five'] ,
					),
					array(
						'name' => __( $settings['eccp_settings_name_color_six_text_field'],'editor-custom-color-palette' ),
						'slug' => $settings['eccp_settings_slug_color_six_text_field'],
						'color' => $settings['eccp_settings_color_six'] ,
					),
					array(
						'name' => __( $settings['eccp_settings_name_color_seven_text_field'],'editor-custom-color-palette' ),
						'slug' => $settings['eccp_settings_slug_color_seven_text_field'],
						'color' => $settings['eccp_settings_color_seven'] ,
					),
					array(
						'name' => __( $settings['eccp_settings_name_color_eight_text_field'],'editor-custom-color-palette' ),
						'slug' => $settings['eccp_settings_slug_color_eight_text_field'],
						'color' => $settings['eccp_settings_color_eight'] ,
					),
					array(
						'name' => __( $settings['eccp_settings_name_color_nine_text_field'],'editor-custom-color-palette' ),
						'slug' => $settings['eccp_settings_slug_color_nine_text_field'],
						'color' => $settings['eccp_settings_color_nine'] ,
					),
					array(
						'name' => __( $settings['eccp_settings_name_color_ten_text_field'],'editor-custom-color-palette' ),
						'slug' => $settings['eccp_settings_slug_color_ten_text_field'],
						'color' => $settings['eccp_settings_color_ten'] ,
					),
					array(
						'name' => __( $settings['eccp_settings_name_color_eleven_text_field'],'editor-custom-color-palette' ),
						'slug' => $settings['eccp_settings_slug_color_eleven_text_field'],
						'color' => $settings['eccp_settings_color_eleven'] ,
					),
					array(
						'name' => __( $settings['eccp_settings_name_color_twelve_text_field'],'editor-custom-color-palette' ),
						'slug' => $settings['eccp_settings_slug_color_twelve_text_field'],
						'color' => $settings['eccp_settings_color_twelve'] ,
					),
					
                ),
				
            ),
        ),
    );

    return $theme_json->update_with( $new_data );
}

// si on a activé la personnalisation de la palette de couleurs Gutenberg
if( $settings['eccp_settings_activate_customizing_color_palette_checkbox_field'] == true )  {
	add_filter( 'wp_theme_json_data_theme', 'eccp_color_palette_theme_json', 10, 1 );
}

/***********************************************************************************************
      MODIFIER PALETTE DE COULEUR EDITEUR GUTENBERG INTITULEE PAR DEFAUT POUR LE THEME ASTRA            
***********************************************************************************************/
// PLUS NECESSAIRE A PARTIR DE LA VERSION WORDPRESS 6.1, CAR ON FILTRE LES PARAMÉTRES THEME.JSON
// Pour les théme ASTRA la palette de couleur est établi par le theme.json
// theme.json est prioritaire a la fonction add_theme_support() introduit par le hook: after_setup_theme ou init
// qui permet de modifier la palette de couleur.  
// Pour y palier on va aussi afficher dans guttenberg une palette par défaut
// en dessous de la palette du thème via le hook: block_editor_settings_all
// Mais il reste un problème:
// si on fait une sélection du texte et que l'on veut modifier la couleur via la barre d'outils du bloc,
// avec la palette de couleur qui apparait en fenêtre modale, ce sera toujours la palette de thème et non
// la palette de couleur par défaut.
	
// on récupère le thème actif
$my_theme = wp_get_theme();


function eccp_default_color_palette_gutenberg( $editor_settings ) {

	// On récupère les paramètres général de réglages du plugin
	$settings = get_option( 'eccp_multiple_setting' );
	
	
	// on active la palette de couleur par défaut qui sera placé en dessous de celle du thème		
	$editor_settings["__experimentalFeatures"]["color"]["defaultPalette"] = true;
	
	
	// Palette de couleurs par défaut
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][0]["name"] = __( $settings['eccp_settings_name_color_one_text_field'],'editor-custom-color-palette' );
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][0]["slug"] = $settings['eccp_settings_slug_color_one_text_field'];
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][0]["color"] = $settings['eccp_settings_color_one'];
	
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][1]["name"] = __( $settings['eccp_settings_name_color_two_text_field'],'editor-custom-color-palette' );
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][1]["slug"] = $settings['eccp_settings_slug_color_two_text_field'];
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][1]["color"] = $settings['eccp_settings_color_two'];
	
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][2]["name"] = __( $settings['eccp_settings_name_color_three_text_field'],'editor-custom-color-palette' );
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][2]["slug"] = $settings['eccp_settings_slug_color_three_text_field'];
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][2]["color"] = $settings['eccp_settings_color_three'];
	
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][3]["name"] = __( $settings['eccp_settings_name_color_four_text_field'],'editor-custom-color-palette' );
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][3]["slug"] = $settings['eccp_settings_slug_color_four_text_field'];
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][3]["color"] = $settings['eccp_settings_color_four'];
	
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][4]["name"] = __( $settings['eccp_settings_name_color_five_text_field'],'editor-custom-color-palette' );
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][4]["slug"] = $settings['eccp_settings_slug_color_five_text_field'];
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][4]["color"] = $settings['eccp_settings_color_five'];
	
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][5]["name"] = __( $settings['eccp_settings_name_color_six_text_field'],'editor-custom-color-palette' );
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][5]["slug"] = $settings['eccp_settings_slug_color_six_text_field'];
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][5]["color"] = $settings['eccp_settings_color_six'];
	
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][6]["name"] = __( $settings['eccp_settings_name_color_seven_text_field'],'editor-custom-color-palette' );
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][6]["slug"] = $settings['eccp_settings_slug_color_seven_text_field'];
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][6]["color"] = $settings['eccp_settings_color_seven'];
	
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][7]["name"] = __( $settings['eccp_settings_name_color_eight_text_field'],'editor-custom-color-palette' );
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][7]["slug"] = $settings['eccp_settings_slug_color_eight_text_field'];
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][7]["color"] = $settings['eccp_settings_color_eight'];
	
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][8]["name"] = __( $settings['eccp_settings_name_color_nine_text_field'],'editor-custom-color-palette' );
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][8]["slug"] = $settings['eccp_settings_slug_color_nine_text_field'];
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][8]["color"] = $settings['eccp_settings_color_nine'];
	
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][9]["name"] = __( $settings['eccp_settings_name_color_ten_text_field'],'editor-custom-color-palette' );
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][9]["slug"] = $settings['eccp_settings_slug_color_ten_text_field'];
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][9]["color"] = $settings['eccp_settings_color_ten'];
	
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][10]["name"] = __( $settings['eccp_settings_name_color_eleven_text_field'],'editor-custom-color-palette' );
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][10]["slug"] = $settings['eccp_settings_slug_color_eleven_text_field'];
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][10]["color"] = $settings['eccp_settings_color_eleven'];
	
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][11]["name"] = __( $settings['eccp_settings_name_color_twelve_text_field'],'editor-custom-color-palette' );
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][11]["slug"] = $settings['eccp_settings_slug_color_twelve_text_field'];
	$editor_settings["__experimentalFeatures"]["color"]["palette"]["default"][11]["color"] = $settings['eccp_settings_color_twelve'];


	
	/* Palette de couleurs thème ( ne fonctionne pas car theme.json est prioritaire)
    $editor_settings["colors"][0]["name"] = __( $settings['eccp_settings_name_color_one_text_field'],'editor-custom-color-palette' );
	$editor_settings["colors"][0]["slug"] = $settings['eccp_settings_slug_color_one_text_field'];
	$editor_settings["colors"][0]["color"] = $settings['eccp_settings_color_one'];
	
	$editor_settings["colors"][1]["name"] = __( $settings['eccp_settings_name_color_two_text_field'],'editor-custom-color-palette' );
	$editor_settings["colors"][1]["slug"] = $settings['eccp_settings_slug_color_two_text_field'];
	$editor_settings["colors"][1]["color"] = $settings['eccp_settings_color_two'];
	
	$editor_settings["colors"][2]["name"] = __( $settings['eccp_settings_name_color_three_text_field'],'editor-custom-color-palette' );
	$editor_settings["colors"][2]["slug"] = $settings['eccp_settings_slug_color_three_text_field'];
	$editor_settings["colors"][2]["color"] = $settings['eccp_settings_color_three'];
	
	$editor_settings["colors"][3]["name"] = __( $settings['eccp_settings_name_color_four_text_field'],'editor-custom-color-palette' );
	$editor_settings["colors"][3]["slug"] = $settings['eccp_settings_slug_color_four_text_field'];
	$editor_settings["colors"][3]["color"] = $settings['eccp_settings_color_four'];
	
	$editor_settings["colors"][4]["name"] = __( $settings['eccp_settings_name_color_five_text_field'],'editor-custom-color-palette' );
	$editor_settings["colors"][4]["slug"] = $settings['eccp_settings_slug_color_five_text_field'];
	$editor_settings["colors"][4]["color"] = $settings['eccp_settings_color_five'];
	
	$editor_settings["colors"][5]["name"] = __( $settings['eccp_settings_name_color_six_text_field'],'editor-custom-color-palette' );
	$editor_settings["colors"][5]["slug"] = $settings['eccp_settings_slug_color_six_text_field'];
	$editor_settings["colors"][5]["color"] = $settings['eccp_settings_color_six'];
	
	$editor_settings["colors"][6]["name"] = __( $settings['eccp_settings_name_color_seven_text_field'],'editor-custom-color-palette' );
	$editor_settings["colors"][6]["slug"] = $settings['eccp_settings_slug_color_seven_text_field'];
	$editor_settings["colors"][6]["color"] = $settings['eccp_settings_color_seven'];
	
	$editor_settings["colors"][7]["name"] = __( $settings['eccp_settings_name_color_eight_text_field'],'editor-custom-color-palette' );
	$editor_settings["colors"][7]["slug"] = $settings['eccp_settings_slug_color_eight_text_field'];
	$editor_settings["colors"][7]["color"] = $settings['eccp_settings_color_eight'];
	
	$editor_settings["colors"][8]["name"] = __( $settings['eccp_settings_name_color_nine_text_field'],'editor-custom-color-palette' );
	$editor_settings["colors"][8]["slug"] = $settings['eccp_settings_slug_color_nine_text_field'];
	$editor_settings["colors"][8]["color"] = $settings['eccp_settings_color_nine'];
	
	$editor_settings["colors"][9]["name"] = __( $settings['eccp_settings_name_color_ten_text_field'],'editor-custom-color-palette' );
	$editor_settings["colors"][9]["slug"] = $settings['eccp_settings_slug_color_ten_text_field'];
	$editor_settings["colors"][9]["color"] = $settings['eccp_settings_color_ten'];
	
	$editor_settings["colors"][10]["name"] = __( $settings['eccp_settings_name_color_eleven_text_field'],'editor-custom-color-palette' );
	$editor_settings["colors"][10]["slug"] = $settings['eccp_settings_slug_color_eleven_text_field'];
	$editor_settings["colors"][10]["color"] = $settings['eccp_settings_color_eleven'];
	
	$editor_settings["colors"][11]["name"] = __( $settings['eccp_settings_name_color_twelve_text_field'],'editor-custom-color-palette' );
	$editor_settings["colors"][11]["slug"] = $settings['eccp_settings_slug_color_twelve_text_field'];
	$editor_settings["colors"][11]["color"] = $settings['eccp_settings_color_twelve'];
	*/

	return $editor_settings;
	
}

 // si on a activé la personnalisation de la palette de couleurs Gutenberg
 // et le theme actif est astra
if( ($settings['eccp_settings_activate_customizing_color_palette_checkbox_field'] == true) &&
(stristr($my_theme, 'astra')) )   {
	//add_filter( 'block_editor_settings_all', 'eccp_default_color_palette_gutenberg', 10, 1 );
}


/***********************************************************************************************
   REMPLACER LA PALETTE DE HUIT COULEURS PAR DÉDAUT DANS LE COLOR PICKER DU PERSONNALISEUR        
***********************************************************************************************/

 // si on a activé la personnalisation de la palette de couleurs Gutenberg
 // et le theme actif est OceanWP
if ( $settings['eccp_settings_activate_customizing_color_palette_checkbox_field'] == true ) {
	add_filter( 'ocean_default_color_palettes', 'override_customizer_color_palette' );
}

// Pour le theme actif Astra(ne fonctionne plus car palette de couleurs globales)
if ( $settings['eccp_settings_activate_customizing_color_palette_checkbox_field'] == true ) {
	//add_filter( 'astra_color_palettes', 'override_customizer_color_palette' );
}

// Pour le theme actif GeneratePress(ne fonctionne plus car palette de couleurs globales)
if ( $settings['eccp_settings_activate_customizing_color_palette_checkbox_field'] == true ) {
	//add_filter( 'generate_default_color_palettes', 'override_customizer_color_palette' );
}


// Remplacer la palette de couleurs par défaut dans le color picker du personnaliseur
// par notre palette de couleurs personnalisées
function override_customizer_color_palette( $palettes ) {
 
	// On récupère les paramètres général de réglages du plugin
	$settings = get_option( 'eccp_multiple_setting' );
 
    $palettes = array(
		$settings['eccp_settings_color_one'],
		$settings['eccp_settings_color_two'],
		$settings['eccp_settings_color_three'],
		$settings['eccp_settings_color_four'],
		$settings['eccp_settings_color_five'],
		$settings['eccp_settings_color_six'],
		$settings['eccp_settings_color_seven'],
		$settings['eccp_settings_color_eight'],
	);

	return $palettes;
    
}




/***********************************************************************************************
                           DÉSACTIVER LES COULEURS & DÉGRADÉS PERSONNALISÉES            
***********************************************************************************************/

// Si on a choisi de désactivé les couleurs personnalisés
if( $settings['eccp_settings_disabling_custom_colors_checkbox_field'] == true ) {
	add_theme_support( 'disable-custom-colors' );
}

// Si on a choisi de désactivé les dégradés personnalisés
if( $settings['eccp_settings_disabling_custom_gradients_checkbox_field'] == true ) {
	add_theme_support( 'editor-gradient-presets', [] );
	add_theme_support( 'disable-custom-gradients' );
}


/***********************************************************************************************
             DÉSACTIVER LES COULEURS & DÉGRADÉS PERSONNALISÉES POUR UN THEME JSON            
***********************************************************************************************/


// Si on a choisi de désactivé les couleurs personnalisés
if ( $settings['eccp_settings_disabling_custom_colors_checkbox_field'] == true )  {
	add_filter( 'wp_theme_json_data_theme', 'eccp_disable_custom_color_theme_json', 10, 1 );
}

function eccp_disable_custom_color_theme_json( $theme_json ){
	
    $new_data = array(
	
        'version'  => 2,
		
        'settings' => array(
		
            'color' => array(
				'custom' => false,
            ),
        ),
    );

    return $theme_json->update_with( $new_data );
}


// Si on a choisi de désactivé les dégradés personnalisés
if( $settings['eccp_settings_disabling_custom_gradients_checkbox_field'] == true )  {
	add_filter( 'wp_theme_json_data_theme', 'eccp_disable_gradient_color_theme_json', 10, 1 );
}

function eccp_disable_gradient_color_theme_json( $theme_json ){
	
    $new_data = array(
	
        'version'  => 2,
		
        'settings' => array(
		
            'color' => array(
				'customGradient' => false,
            ),
			
        ),
    );

    return $theme_json->update_with( $new_data );
}



/***********************************************************************************************
   TRANSPOSER LA PALETTE DE COULEURS EN VARIABLE CSS, APLIQUER LE STYLE EN ADMIN & FRONT END           
***********************************************************************************************/

/* on transpose la palette de couleurs en variable CSS
  on aplique le style de la palette en admin & front end. 
  Cela permettra d'appliquer des styles avancés
  pour les blocs de l'editeur en utilisant les variables CSS par ex 
  dans une bordure ou dans un pseudo:before 
  
  Remarque: comme on applique quelque soit le theme la palette de couleur
  avec la fonction add_theme_support() cela permet de récupérer avec la fonction get_theme_support()
  la même palette de couleurs appliquée pour un theme.json via le hook: theme_json_theme.
  Le mieux aurait été de déclarer comme le fait le thème Astra des variable css 
  directement dans theme.json 
*/
  
  
  
add_action( 'wp_head', 'eccp_var_css_gutenberg_palette',1 );
add_action( 'admin_head', 'eccp_var_css_gutenberg_palette',8 );

function eccp_var_css_gutenberg_palette() {

	// On récupère les paramètres pour la palette de couleurs
	$settings = get_option( 'eccp_multiple_setting' );
  
	// si on a activé la personnalisation de la palette de couleurs
	if( $settings['eccp_settings_activate_customizing_color_palette_checkbox_field'] == true ) {
	
		add_action( 'wp_head', 'eccp_my_output_gutenberg_palette' );
		add_action( 'admin_head', 'eccp_my_output_gutenberg_palette' );

		function eccp_my_output_gutenberg_palette() {
			
		  // si on est en Admin mais pas dans l'éditeur Gutenberg, alors on sort
		  if( is_admin() ) {
			global $current_screen;
			$in_editor = method_exists($current_screen, 'is_block_editor') && $current_screen->is_block_editor();
			if( !$in_editor ) { return; }
		  }

		  // la fonction get_theme_support() permet d'obtenir la palette de couleurs 
		  // enregistrée dans le support de thème, elle retourne un tableau
		  /* Array ( [0] => Array ( 
							  [0] => Array ( 
											[name] => couleur primaire 
											[slug] => couleur-primaire 
											[color] => #F37020 
											) 
							  [1] => Array ( [name] => couleur secondaire 
											 [slug] => couleur-secondaire 
											 [color] => #B84331 
										    )
			                   etc......
											
							)
	
		  */
		  $palette = get_theme_support( 'editor-color-palette' );
		  if( !$palette ) { return; } // s'il n'y a pas de palette de couleurs on sort
		   
		  // Format Des Styles
		  // modif version 2.9.5 régles: !important pour la couleur de texte
		  // car on ne pourrait modifier la couleur des titres inposé par certains thèmes 
		  // :root est une pseudo-classe CSS utilisée afin de contenir différentes déclarations de variables CSS
		  $styles = ":root .has-background { background-color: var(--eccp-bgColor)!important; }
		  :root .has-text-color { color: var(--eccp-textColor)!important; }
		  :root .has-border-color { color: var(--eccp-borderColor)!important; }";

		  // pour chaque couleur de la palette
		  foreach( $palette[0] as $key => $value ) {
			  
			$slug = $value['slug'];
			$color = $value['color'];

			// couleur du fond avec variable CSS
			$styles .= ".has-{$slug}-background-color { --eccp-bgColor: {$color}; } ";
			
			// couleur du texte
			/*si on fait une sélection du texte 
			et que l'on veut modifier la couleur via la barre d'outils du bloc,
			avec la palette de couleur qui apparait en fenêtre modale,
			cela n'est pas pris en compte en back office & Front end 
			Pour palier au problème on surchage la régle pour la couleur de texte avec variable CSS
			avec cette régle sans variable CSS
			*/
			$styles .= ".has-{$slug}-color { color: {$color}; } ";
			
			// couleur du texte avec variable CSS
			$styles .= ".has-{$slug}-color { --eccp-textColor: {$color}!important; } ";
			
			// couleur de la bordure avec variable CSS
			// un bug persiste si on applique une couleur a la bordure
			// le texte ayant la couleur du thème par défaut prend alors la même couleur 
			// que la bordure,si bien qu'il faut aussi appliquer une couleur au texte
			$styles .= ".has-{$slug}-border-color { --eccp-borderColor: {$color}; } ";
			
			
		  }

		  // on applique les régles CSS
		  echo '<style id="editor_custom_color_palette_css">'.$styles.'</style>';
		  
		}
	  
	}// si on a activé la personnalisation de la palette de couleurs
  
}

/* Voila le résultat appliqué en Admin & Front End
:root .has-background { background-color: var(--eccp-bgColor); }
:root .has-text-color { color: var(--eccp-textColor); } 
.has-couleur-primaire-background-color { --bgColor: #F37020; } 
.has-couleur-primaire-color { color: #F37020; } 
.has-couleur-primaire-color { --eccp-textColor: #F37020; } 
.has-couleur-secondaire-background-color { --bgColor: #B84331; } 
.has-couleur-secondaire-color { color: #B84331; } 
.has-couleur-secondaire-color { --eccp-textColor: #B84331; } 
etc...
*/

/***********************************************************************************************
                           MODIFIER PALETTE DE COULEUR ELEMENTOR            
***********************************************************************************************/

/*
Remarque importante!
La syntaxe du slug d'une couleur elementor pour l'application du style en Front-End est:
--e-global-color-blanc_casse_clair:#F0F2F6
c'est donc --e-global-color-  suivit du nom de la couleur, si bien que le slug du nom de la
couleur ne doit impérativement ne pas contenir de tiret.
on doit ecrire: blanc_casse_clair et non blanc-casse-clair
*/

/*------------------------ ELEMENTOR: SYSTEM COLOR  -----------------------------------*/

function eccp_elementor_system_color_palette( $system_colors = array() ) {
	
	// On récupère les paramètres de la palette de couleurs
	$settings  = get_option( 'eccp_multiple_setting' );
	
	/* compatibilité avec version antérieure du plugin, on remplace dans le slug Gutenberg
	le tiret par un trait de soulignement car incompatible avec le slug Elementor */
	$settings['eccp_settings_slug_color_one_text_field'] = str_replace("-", "_", $settings['eccp_settings_slug_color_one_text_field']);
	$settings['eccp_settings_slug_color_two_text_field'] = str_replace("-", "_", $settings['eccp_settings_slug_color_two_text_field']);
	$settings['eccp_settings_slug_color_three_text_field'] = str_replace("-", "_", $settings['eccp_settings_slug_color_three_text_field']);
	$settings['eccp_settings_slug_color_four_text_field'] = str_replace("-", "_", $settings['eccp_settings_slug_color_four_text_field']);
	
	$system_colors = [
		[
			'_id' => __( $settings['eccp_settings_slug_color_one_text_field'],'editor-custom-color-palette' ),
			'title' => __( $settings['eccp_settings_name_color_one_text_field'],'editor-custom-color-palette' ),
			'color' => $settings['eccp_settings_color_one'],
		],
		[
			'_id' => __( $settings['eccp_settings_slug_color_two_text_field'],'editor-custom-color-palette' ),
			'title' => __( $settings['eccp_settings_name_color_two_text_field'],'editor-custom-color-palette' ),
			'color' => $settings['eccp_settings_color_two'],
		],
		[
			'_id' => __( $settings['eccp_settings_slug_color_three_text_field'],'editor-custom-color-palette' ),
			'title' => __( $settings['eccp_settings_name_color_three_text_field'],'editor-custom-color-palette' ),
			'color' => $settings['eccp_settings_color_three'],
		],
		[
			'_id' => __( $settings['eccp_settings_slug_color_four_text_field'],'editor-custom-color-palette' ),
			'title' => __( $settings['eccp_settings_name_color_four_text_field'],'editor-custom-color-palette' ),
			'color' => $settings['eccp_settings_color_four'],
		]
	];
	
	return $system_colors;
}


function eccp_update_elementor_system_color_palette() {
	
	//option_value: l'identifiant du kit(couleurs globales) est dans la table wp_option avec option_name = elementor_active_kit
	$id_elementor_active_kit = get_option( 'elementor_active_kit', $default = false );
	
	// s'il y a un identifiant de Kit alors elementor est installé
	if ( $id_elementor_active_kit ) {
		
		// on récupère le tableau de couleurs dans la table wp_postmeta, 
		// pour post_id = l'identifiant du kit &  méta_key = _elementor_page_settings
		// $single = true ==> renvoi la valeur du champ meta au lieu d'un tableau de valeurs
		$active_kit_settings = get_post_meta( $id_elementor_active_kit, '_elementor_page_settings', $single = true );
	
		if ( ! $active_kit_settings ) {
			$active_kit_settings = [];
		}

		//on affecte notre palette de couleurs systeme
		$system_colors = eccp_elementor_system_color_palette();
		
		
		// si notre palette est définie
		if ( $system_colors ) {
			
			// supprimer les couleurs existantes et les remplacer
			// par les 4 premières couleurs de la palette  Gutenberg
			// system_color: ce sont les 4 couleurs définit par défaut
			// par elementor : Principal Secondaire Texte Accentué
			unset( $active_kit_settings[ 'system_colors' ] );
			
			
			// On affecte notre palette de couleurs personnalisés systeme
			$active_kit_settings[ 'system_colors' ] = $system_colors;
			
			// on met à jour la table wp_postmeta avec notre palette de couleurs systeme
			update_post_meta( $id_elementor_active_kit, '_elementor_page_settings', $active_kit_settings );
			
		}
		
	}// fin si elementor est installé
}

/* si on a activé la synchronisation de la palette de couleurs Elementor avec celle de Gutenberg
if( $elementor_settings['eccp_activate_synchronization_color_palette_radio_field'] == 'yes' ) {
	add_action( 'init', 'eccp_update_elementor_system_color_palette' );
}*/

$value_synchro  = isset( $elementor_settings['eccp_activate_synchronization_color_palette_radio_field'] ) ?  $elementor_settings['eccp_activate_synchronization_color_palette_radio_field'] : 'no';
// si on a activé la synchronisation de la palette de couleurs Elementor avec celle de Gutenberg
if( $value_synchro == 'yes' ) {
	add_action( 'init', 'eccp_update_elementor_system_color_palette' );
}

/*------------------------ ELEMENTOR: CUSTOM COLOR -----------------------------------*/

function eccp_elementor_custom_color_palette( $custom_colors = array() ) {
	
	// On récupère les paramètres de la palette de couleurs
	$settings  = get_option( 'eccp_multiple_setting' );
	
	/* compatibilité avec version antérieure du plugin, on remplace dans le slug gutenberg
	le tiret par un trait de soulignement car incompatible avec le slug Elementor */
	$settings['eccp_settings_slug_color_five_text_field'] = str_replace("-", "_", $settings['eccp_settings_slug_color_five_text_field']);
	$settings['eccp_settings_slug_color_six_text_field'] = str_replace("-", "_", $settings['eccp_settings_slug_color_six_text_field']);
	$settings['eccp_settings_slug_color_seven_text_field'] = str_replace("-", "_", $settings['eccp_settings_slug_color_seven_text_field']);
	$settings['eccp_settings_slug_color_eight_text_field'] = str_replace("-", "_", $settings['eccp_settings_slug_color_eight_text_field']);
	$settings['eccp_settings_slug_color_nine_text_field'] = str_replace("-", "_", $settings['eccp_settings_slug_color_nine_text_field']);
	$settings['eccp_settings_slug_color_ten_text_field'] = str_replace("-", "_", $settings['eccp_settings_slug_color_ten_text_field']);
	$settings['eccp_settings_slug_color_eleven_text_field'] = str_replace("-", "_", $settings['eccp_settings_slug_color_eleven_text_field']);
	$settings['eccp_settings_slug_color_twelve_text_field'] = str_replace("-", "_", $settings['eccp_settings_slug_color_twelve_text_field']);
	
	// on calcule le nombre de couleurs personnalisée
	// nbr couleurs personnalisées = nbr couleur sélectionné pour la palette gutenberg - nbr couleur systeme elementor
	$nbr_custom_color = strval($settings['eccp_settings_number_colors_select_field']) - 4 ;
	
	// on établi la configuration complete des couleurs personnalisé d'elementor(8 couleurs)
	// qui correspondent aux couleurs 5 à 12 de la palette Gutenberg
	// le 4 premières étant réservées aux couleurs système
	$colors = [
		[
			'_id' => __( $settings['eccp_settings_slug_color_five_text_field'],'editor-custom-color-palette' ),
			'title' => __( $settings['eccp_settings_name_color_five_text_field'],'editor-custom-color-palette' ),
			'color' => $settings['eccp_settings_color_five']
		],
		[
			'_id' => __( $settings['eccp_settings_slug_color_six_text_field'],'editor-custom-color-palette' ),
			'title' => __( $settings['eccp_settings_name_color_six_text_field'],'editor-custom-color-palette' ),
			'color' => $settings['eccp_settings_color_six']
		],
		[
			'_id' => __( $settings['eccp_settings_slug_color_seven_text_field'],'editor-custom-color-palette' ),
			'title' => __( $settings['eccp_settings_name_color_seven_text_field'],'editor-custom-color-palette' ),
			'color' => $settings['eccp_settings_color_seven']
		],
		[
			'_id' => __( $settings['eccp_settings_slug_color_eight_text_field'],'editor-custom-color-palette' ),
			'title' => __( $settings['eccp_settings_name_color_eight_text_field'],'editor-custom-color-palette' ),
			'color' => $settings['eccp_settings_color_eight']
		],
		
		[
			'_id' => __( $settings['eccp_settings_slug_color_nine_text_field'],'editor-custom-color-palette' ),
			'title' => __( $settings['eccp_settings_name_color_nine_text_field'],'editor-custom-color-palette' ),
			'color' => $settings['eccp_settings_color_nine']
		],
		[
			'_id' => __( $settings['eccp_settings_slug_color_ten_text_field'],'editor-custom-color-palette' ),
			'title' => __( $settings['eccp_settings_name_color_ten_text_field'],'editor-custom-color-palette' ),
			'color' => $settings['eccp_settings_color_ten']
		],
		[
			'_id' => __( $settings['eccp_settings_slug_color_eleven_text_field'],'editor-custom-color-palette' ),
			'title' => __( $settings['eccp_settings_name_color_eleven_text_field'],'editor-custom-color-palette' ),
			'color' => $settings['eccp_settings_color_eleven']
		],
		
		[
			'_id' => __( $settings['eccp_settings_slug_color_twelve_text_field'],'editor-custom-color-palette' ),
			'title' => __( $settings['eccp_settings_name_color_twelve_text_field'],'editor-custom-color-palette' ),
			'color' => $settings['eccp_settings_color_twelve']
		]
	];
	
	$i = 0; 
	
	// On établi la configuration réelle des couleurs personnalisé d'elementor
	// en fonction du nbr de couleurs sélectionné pour la palette Gutenberg
	foreach ( $colors as $key => $array ) {
		
		$custom_colors[$key] = $array;
		
		$i++; 
	 
		if( $i == $nbr_custom_color ){
		  break;
		}
	
	}
	
		
	return $custom_colors;
	
}

function eccp_update_elementor_custom_color_palette() {
	
	//option_value: l'identifiant du kit(couleurs globales) est dans la table wp_option avec option_name = elementor_active_kit
	$id_elementor_active_kit = get_option( 'elementor_active_kit', $default = false );
	
	// s'il y a un identifiant de Kit alors elementor est installé
	if ( $id_elementor_active_kit ) {
		
		// on récupère le tableau de couleurs dans la table wp_postmeta, 
		// pour post_id = l'identifiant du kit &  méta_key = _elementor_page_settings
		// le kit est ecrit dans un fichier de style dossier upload/elementor/css de WordPress,
		// avec pour nom post-post_id.css
		$active_kit_settings = get_post_meta( $id_elementor_active_kit, '_elementor_page_settings', $single = true );
		
		if ( ! $active_kit_settings ) {
			$active_kit_settings = [];
		}

		//on affecte notre palette de couleurs personnalisées 
		$custom_colors = eccp_elementor_custom_color_palette();
		
		//var_dump($custom_colors);

		// si notre palette de couleurs personnalisées est définie
		if ( $custom_colors ) {
			
			// On supprime les couleurs personnalisés et on les 
			// remplace par les couleurs 5 à 12
			// de la palette de couleurs Gutenberg
			unset( $active_kit_settings[ 'custom_colors' ] );
			
			// On affecte notre palette de couleurs personnalisées 
			$active_kit_settings[ 'custom_colors' ] = $custom_colors;
			
			// on met à jour la table wp_postmeta avec notre palette de couleurs personnalisée 
			update_post_meta( $id_elementor_active_kit, '_elementor_page_settings', $active_kit_settings );
			
		}
		
	}// fin si elementor est installé
}

/* si on a activé la synchronisation de la palette de couleurs Elementor avec celle de Gutenberg
if( $elementor_settings['eccp_activate_synchronization_color_palette_radio_field'] == 'yes' ) {
	add_action( 'init', 'eccp_update_elementor_custom_color_palette' );
}*/

$value_synchro  = isset( $elementor_settings['eccp_activate_synchronization_color_palette_radio_field'] ) ?  $elementor_settings['eccp_activate_synchronization_color_palette_radio_field'] : 'no';
// si on a activé la synchronisation de la palette de couleurs Elementor avec celle de Gutenberg
if( $value_synchro == 'yes' ) {
	add_action( 'init', 'eccp_update_elementor_custom_color_palette' );
}

/***********************************************************************************************
                           MODIFIER PALETTE DE COULEUR DIVI            
***********************************************************************************************/

/*------------------------ SYNCHRO PALETTE DIVI A PARTIR DE LA PALETTE GUTENBERG -----------------------------------*/

function eccp_gutenberg_color_palette( ) {
	
	// On récupère les paramètres de la palette de couleurs
	$settings  = get_option( 'eccp_multiple_setting' );
	
	$colors_gutenberg = $settings['eccp_settings_color_one'].'|'.$settings['eccp_settings_color_two'].'|'.
						$settings['eccp_settings_color_three'].'|'.$settings['eccp_settings_color_four'].'|'.
						$settings['eccp_settings_color_five'].'|'.$settings['eccp_settings_color_six'].'|'.
						$settings['eccp_settings_color_seven'].'|'.$settings['eccp_settings_color_eight'];
		
	return $colors_gutenberg;
	
}


function eccp_update_divi_color_palette() {
	
	// Dans la table wp_option avec option_name = et_divi,le champ option_value  
	// renvoi un tableau a une dimmension.
	// la palette de couleur DIVI composée de 8 couleurs est donnée pour 
	// l'index divi_color_palette du tableau qui renvoi une chaine de 63 caractères.
	//ex  ["divi_color_palette"]=> string(63) "#000000|#ffffff|#e02b20|#e09900|#6D908E|#7cda24|#e02b20|#e02b20"
	$theme_divi_option = get_option( 'et_divi', $default = false );
	
	// s'il y a des options pour le theme DIVI,alors DIVI est installé
	if ( $theme_divi_option ) {
		
		//var_dump($theme_divi_option);
		
		//on récupère les 8 premières couleurs de notre palette de couleurs Gutenberg
		$colors_gutenberg = eccp_gutenberg_color_palette();
		
		// si notre palette est définie
		if ( $colors_gutenberg ) {
			
			//var_dump($colors_gutenberg);
			
			// on met a jour la palette de couleurs DIVI avec celle de Gutenberg
			$theme_divi_option['divi_color_palette'] = $colors_gutenberg;
			
			// on met à jour les options du theme divi dans la table table wp_option 
			// avec la palette de couleurs Gutenberg 
			update_option( 'et_divi', $theme_divi_option, '', 'yes' );
			
		}
		
	}// fin si DIVI est installé
}

// si on a activé la synchronisation de la palette de couleurs & mode synchro Gutenberg vers Divi 
/*
if( $divi_settings['eccp_activate_synchronization_divi_color_palette_radio_field'] == 'yes'  &&  
    $divi_settings['eccp_choose_synchronization_radio_field'] == 'synchro-gutenberg-to-divi') {
	add_action( 'init', 'eccp_update_divi_color_palette' );
}
*/

$value_synchro_divi = isset( $divi_settings['eccp_activate_synchronization_divi_color_palette_radio_field'] ) ?  $divi_settings['eccp_activate_synchronization_divi_color_palette_radio_field'] : 'no';
$value_synchro_mode = isset( $divi_settings['eccp_choose_synchronization_radio_field'] ) ?  $divi_settings['eccp_choose_synchronization_radio_field'] : 'synchro-gutenberg-to-divi';
// si on a activé la synchronisation de la palette de couleurs & mode synchro Gutenberg vers Divi 
if( $value_synchro_divi == 'yes'  &&  $value_synchro_mode == 'synchro-gutenberg-to-divi') {
	add_action( 'init', 'eccp_update_divi_color_palette' );
}


/*------------------------ SYNCHRO PALETTE GUTENBERG A PARTIR DE LA PALETTE DIVI -----------------------------------*/


function eccp_update_gutenberg_color_palette() {
	
	// Dans la table wp_option avec option_name = et_divi,le champ option_value  
	// renvoi un tableau a une dimmension.
	// la palette de couleur DIVI composée de 8 couleurs est donnée pour 
	// l'index divi_color_palette du tableau qui renvoi une chaine de 63 caractères.
	//ex  ["divi_color_palette"]=> string(63) "#000000|#ffffff|#e02b20|#e09900|#6D908E|#7cda24|#e02b20|#e02b20"
	$theme_divi_option = get_option( 'et_divi', $default = false );
	
	// s'il y a des options pour le theme DIVI,alors DIVI est installé
	if ( $theme_divi_option ) {
		
		$colors_divi = explode("|", $theme_divi_option['divi_color_palette']);
		
		// si notre palette est définie
		if ( $colors_divi ) {
			
			//var_dump($colors_divi);
			
			// On récupère les paramètres de la palette ce couleurs
			$settings  = get_option( 'eccp_multiple_setting' );
			
			//var_dump($settings);
		
			/*---- on affecte les options de réglages de la palette de couleurs Gutenberg
			 eccp_rgba_to_hex($rgba) 
			 si la couleur passé en paramètre est une valeur hexadécimale
			 on n'effectue pas la conversion RGBA --> Hexadécimal
			 on retourne un tableau
			 $color_hex['hex'] ==> la valeur hexadécimale passé en paramètre
			 $color_hex['opacity'] = '100'
			 sinon on effectue la conversion d'une couleur RGBA en hexadécimal 
			 et on retourne un tableau:
			 $color_hex['hex'] ==> la valeur RGBA de la couleur converti en hexadécimal 
			 $color_hex['opacity'] ==> la valeur de l'opacité * 100
			  -----*/
			
			// Couleur N°1
			$colors_hex = eccp_rgba_to_hex($colors_divi[0]);	
			$settings['eccp_settings_color_one_text_field'] = $colors_hex['hex'];
			$settings['eccp_settings_opacity_color_one_text_field'] = $colors_hex['opacity'];
			
			// Couleur N°2
			$colors_hex = eccp_rgba_to_hex($colors_divi[1]);	
			$settings['eccp_settings_color_two_text_field'] = $colors_hex['hex'];
			$settings['eccp_settings_opacity_color_two_text_field'] = $colors_hex['opacity'];
			
			// Couleur N°3
			$colors_hex = eccp_rgba_to_hex($colors_divi[2]);	
			$settings['eccp_settings_color_three_text_field'] = $colors_hex['hex'];
			$settings['eccp_settings_opacity_color_three_text_field'] = $colors_hex['opacity'];
			
			// Couleur N°4
			$colors_hex = eccp_rgba_to_hex($colors_divi[3]);	
			$settings['eccp_settings_color_four_text_field'] = $colors_hex['hex'];
			$settings['eccp_settings_opacity_color_four_text_field'] = $colors_hex['opacity'];
			
			// Couleur N°5
			$colors_hex = eccp_rgba_to_hex($colors_divi[4]);	
			$settings['eccp_settings_color_five_text_field'] = $colors_hex['hex'];
			$settings['eccp_settings_opacity_color_five_text_field'] = $colors_hex['opacity'];
			
			// Couleur N°6
			$colors_hex = eccp_rgba_to_hex($colors_divi[5]);	
			$settings['eccp_settings_color_six_text_field'] = $colors_hex['hex'];
			$settings['eccp_settings_opacity_color_six_text_field'] = $colors_hex['opacity'];
			
			// Couleur N°7
			$colors_hex = eccp_rgba_to_hex($colors_divi[6]);	
			$settings['eccp_settings_color_seven_text_field'] = $colors_hex['hex'];
			$settings['eccp_settings_opacity_color_seven_text_field'] = $colors_hex['opacity'];
			
			// Couleur N°8
			$colors_hex = eccp_rgba_to_hex($colors_divi[7]);	
			$settings['eccp_settings_color_eight_text_field'] = $colors_hex['hex'];
			$settings['eccp_settings_opacity_color_eight_text_field'] = $colors_hex['opacity'];
			
			// on met à jour la palette Gutenberg avec les couleurs de la palette DIVI
		    update_option( 'eccp_multiple_setting', $settings, '', 'yes' );
			
		}
		
	}// fin si DIVI est installé
}


// si on a activé la synchronisation de la palette de couleurs & mode synchro Gutenberg vers Divi 
/*
if( $divi_settings['eccp_activate_synchronization_divi_color_palette_radio_field'] == 'yes'  &&  
    $divi_settings['eccp_choose_synchronization_radio_field'] == 'synchro-divi-to-gutenberg') {
	add_action( 'init', 'eccp_update_divi_color_palette' );
}
*/


$value_synchro_divi = isset( $divi_settings['eccp_activate_synchronization_divi_color_palette_radio_field'] ) ?  $divi_settings['eccp_activate_synchronization_divi_color_palette_radio_field'] : 'no';
$value_synchro_mode = isset( $divi_settings['eccp_choose_synchronization_radio_field'] ) ?  $divi_settings['eccp_choose_synchronization_radio_field'] : 'synchro-gutenberg-to-divi';
// si on a activé la synchronisation de la palette de couleurs & mode synchro Divi vers Gutenberg 
if( $value_synchro_divi  == 'yes'  &&  $value_synchro_mode == 'synchro-divi-to-gutenberg') {
	add_action( 'init', 'eccp_update_gutenberg_color_palette' );
}


/***********************************************************************************************
            SYNCHRONISER LA PALETTE DE COULEUR DE L'ÉDITEUR GUTENBERG ET D'ACF             
***********************************************************************************************/


//add_action('acf/input/admin_footer', 'eccp_synchro_acf_color_picker_from_theme_palette');

function eccp_synchro_acf_color_picker_from_theme_palette() {

    $colors = '';
	
    // Obtenir la palette de couleurs enregistrée dans le support de thème
	$color_palette = get_theme_support( 'editor-color-palette' );
	
	//
    if ( !empty( $color_palette ) ) {
		
		// Obtenir chaque valeur de la palette de couleur (code hexadécimal)
		// il faut mettre ces couleurs dans un format utilisable
		// l'intégration javascript d'ACF ressemble à quelque chose comme ça :
		// ['#F37020', '#B84331', '#666666']
        // on utilise la fonction array_column pour créer le balisage ci-dessus.
		$colors = array_column( $color_palette[ 0 ], 'color' );
		
		
		foreach ($colors as $key => $value) {
		
			// la palette de couleurs ACF par défaut ne comporte que 11 couleurs
			if ($key <= 10) {
			$colors_acf[$key] = $value;
			
			}
		
		}
		
    }

	
    if ( !empty( $colors_acf ) ) {
		
		// color_picker_args: Ce filtre ACF permet de personnaliser les paramètres du sélecteur 
		// de couleurs (wpColorPicker) pour chaque champ de sélecteur de couleurs.  
		// Ce filtre est appelé avant la création de l'instance wpColorPicker
		?>
		
		<script type="text/javascript">
		
			acf.add_filter('color_picker_args', function( args, field ){
				
				// do something to args
				args.palettes = <?php echo json_encode( $colors_acf ); ?>
			   
				// return
				return args;
			});
			
		</script>
		
		<?php
		
	}

}





/***********************************************************************************************
                           MODIFIER TAILLES POLICE EDITEUR GUTENBERG             
***********************************************************************************************/
	
	/*	
	
	Pour définir une taille de police personnalisée dans les paramètres de typographie Gutenberg, 
	nous allons utiliser le hook 'editor-font-sizes' avec la fonction add_theme_support().
	Cette fonction accepte un tableau de tailles de police. 
	Pour chaque taille de police, nous allons définir :
	
	Le nom : affiché dans l'interface.
	La taille en pixels : Utilisée pour styliser l'éditeur.
	Le slug : Un identifiant unique pour la taille. Utilisé pour styliser le frontend.
	
	Pour éviter un conflit avec les styles par défaut de WordPress on va précéder le slug
	avec les initiales du plugin: eccp 
	
	La traduction des noms pour les tailles de police n'est pas prise en compte avec le crochet d'action 
	'after_setup_theme' alors on utilise le le hook init: initialisation de WordPress.
	
	les classes pour appliquer la taille de la police en front-end seront:
	.has-eccp-small-font-size
	.has-eccp-large-font-size
	.has-eccp-large-font-size
	.has-eccp-huge-font-size 
	
	On va donc en front-end générer les tailles de police par du CSS Dynamique:
	CSS DYNAMIQUE TAILLES POLICE EDITEUR GUTENBERG (Front End)
	
	*/


function eccp_custom_font_size_editor() {
	
	// On récupère les paramètres de taille de texte pour l'éditeur
	$editor_text_size_settings = get_option( 'eccp_setting_editor_text_size' );
	
	add_theme_support( 'editor-font-sizes', array(

			// font-size: small
			array(
				'name' => __( 'Small', 'editor-custom-color-palette' ),
				'size' => intval($editor_text_size_settings['eccp_settings_small_font_size_text_field']),
				'slug' => 'eccp-small'
			),
			
			// font-size: regular
			array(
				'name' => __( 'Regular', 'editor-custom-color-palette' ),
				'size' => intval($editor_text_size_settings['eccp_settings_regular_font_size_text_field']),
				'slug' => 'eccp-regular'
			),
			
			// font-size: large
			array(
				'name' => __( 'Large', 'editor-custom-color-palette' ),
				'size' => intval($editor_text_size_settings['eccp_settings_large_font_size_text_field']),
				'slug' => 'eccp-large'
			),
			
			// font-size: huge (extra-large)
			array(
				'name' => __( 'Huge', 'editor-custom-color-palette' ),
				'size' => intval($editor_text_size_settings['eccp_settings_huge_font_size_text_field']),
				'slug' => 'eccp-huge'
			)
		) 
	);

} 

// si on à activé la personnalisation de la taille de la police
if ( $editor_text_size_settings['eccp_settings_activate_editor_text_size_checkbox_field'] ==  true ) {
	add_action( 'init', 'eccp_custom_font_size_editor',10,1 );
}


// autre façon de modifier les tailles de texte en filtrant les paramètres
// de l'editeur avec le hook: block_editor_settings_all
function wp_docs_block_editor_settings( $editor_settings, $editor_context ) {
   
	$editor_settings["__experimentalFeatures"]["typography"]["fontSizes"]["default"] = 
										array (
											array("name"=>"Small","slug"=>"small","size"=>"18px"),
											array("name"=>"Medium","slug"=>"medium","size"=>"20px"),
											array("name"=>"Large","slug"=>"large","size"=>"24px"),
											array("name"=>"Extra Large","x-large"=>"medium","size"=>"30px")
										);			 
									
    return $editor_settings;
	
}
 
//add_filter( 'block_editor_settings_all', 'wp_docs_block_editor_settings', 10, 2 );



/***********************************************************************************************
                  MODIFIER TAILLES POLICE EDITEUR GUTENBERG POUR UN THEME JSON           
***********************************************************************************************/
	
	/*
	Pour définir une taille de police personnalisée dans les paramètres de typographie Gutenberg, 
	nous allons utiliser le hook 'wp_theme_json_data_theme' introduit par WordPress 6.1
	qui permet de filtrer les paramétres de theme.json.
	la fonction utilisé avec le hook retourne la méthode update_with( $new_data )
	avec $new_data ayant une structure de type valide theme.json
	 
	On commence par déclarer quelle version de theme.json on utilise depuis WordPress 5.9
	c'est la version V2
	Ensuite on a le tableau settings qui comprend le tableau typography
	ou l'on va renseigner dans le tableau fontSizes nos tailles personnalisé
	
	Le nom : affiché dans l'interface.
	La taille en pixels : Utilisée pour styliser l'éditeur.
	Le slug : Un identifiant unique pour la taille. Utilisé pour styliser le frontend.
	
	Pour éviter un conflit avec les styles par défaut de WordPress on va précéder le slug
	avec les initiales du plugin: eccp 
		
	les classes pour appliquer la taille de la police en front-end seront:
	.has-eccp-small-font-size
	.has-eccp-large-font-size
	.has-eccp-large-font-size
	.has-eccp-huge-font-size 
	
	On va donc en front-end générer les tailles de police par du CSS Dynamique:
	CSS DYNAMIQUE TAILLES POLICE EDITEUR GUTENBERG (Front End)
	
	*/

function eccp_font_size_theme_json( $theme_json ){
	
	// On récupère les paramètres de taille de texte pour l'éditeur
	$editor_text_size_settings = get_option( 'eccp_setting_editor_text_size' );
	
    $new_data = array(
	
        'version'  => 2,
		
        'settings' => array(
		
            'typography' => array(
			
                'fontSizes' => array( 
				
                    // font-size: small
					array(
						'name' => __( 'Small', 'editor-custom-color-palette' ),
						'size' => $editor_text_size_settings['eccp_settings_small_font_size_text_field']."px",
						'slug' => 'eccp-small'
					),
					
					// font-size: regular
					array(
						'name' => __( 'Regular', 'editor-custom-color-palette' ),
						'size' => $editor_text_size_settings['eccp_settings_regular_font_size_text_field']."px",
						'slug' => 'eccp-regular'
					),
					
					// font-size: large
					array(
						'name' => __( 'Large', 'editor-custom-color-palette' ),
						'size' => $editor_text_size_settings['eccp_settings_large_font_size_text_field']."px",
						'slug' => 'eccp-large'
					),
					
					// font-size: huge (extra-large)
					array(
						'name' => __( 'Huge', 'editor-custom-color-palette' ),
						'size' => $editor_text_size_settings['eccp_settings_huge_font_size_text_field']."px",
						'slug' => 'eccp-huge'
					)
					
                ),
				
            ),
        ),
    );

    return $theme_json->update_with( $new_data );
}

// si on a activé la personnalisation des taille de police
if ( $editor_text_size_settings['eccp_settings_activate_editor_text_size_checkbox_field'] ==  true ) {
	add_filter( 'wp_theme_json_data_theme', 'eccp_font_size_theme_json', 10, 1 );
}


/***********************************************************************************************
                  TAILLE POLICE EDITEUR GUTENBERG PAR DEFAUT           
***********************************************************************************************/

// pour bien déclarer le style uniquemment pour l'éditeur en back office on utilise 
// le hook: enqueue_block_editor_assets
if ( $editor_text_size_settings['eccp_settings_enable_default_gutenberg_editor_font_size_checkbox_field'] ) {
	add_action('enqueue_block_editor_assets', 'ecpp_default_gutenberg_editor_font_size');
}

function ecpp_default_gutenberg_editor_font_size() {
	
	add_action( 'admin_head', function() {
	
		// Si on est en back office & si l'objet d'écran est l'éditeur Gutenberg,
		// alors on peut charger notre style sinon on sort
		if (!is_admin() and !get_current_screen()->is_block_editor() ) {
			return;
		}
		
		// On récupère les paramètres de taille de texte pour l'éditeur
		$editor_text_size_settings = get_option( 'eccp_setting_editor_text_size' );
		
		
		echo '<style id="editor-custom-color-palette" type="text/css">';
		
			echo'.editor-styles-wrapper .wp-block {';
				echo'font-size:'.$editor_text_size_settings['eccp_settings_default_gutenberg_editor_font_size_text_field'].'px;';
			echo'}';
			
		echo '</style>';
		
	});

}


/***********************************************************************************************
                          DÉSACTIVER LA TAILLE DE POLICE PERSONNALISÉE             
***********************************************************************************************/

// si on a coché l'option pour désactiver la taille de police personnalisée
if ( $editor_text_size_settings['eccp_settings_disable_custom_font_size_checkbox_field'] == true ) {
	
	add_theme_support('disable-custom-font-sizes');
	
}


/***********************************************************************************************
             DÉSACTIVER LA TAILLE DE POLICE PERSONNALISÉE POUR UN THEME JSON            
***********************************************************************************************/

function eccp_disable_custom_font_size_theme_json( $theme_json ){
	
    $new_data = array(
	
        'version'  => 2,
		
        'settings' => array(
		
            'typography' => array(
                'customFontSize' => false,
            ),
			
        ),
    );

    return $theme_json->update_with( $new_data );
}

// si on a coché l'option pour désactiver la taille de police personnalisée
if( $editor_text_size_settings['eccp_settings_disable_custom_font_size_checkbox_field'] == true ) {
	add_filter( 'wp_theme_json_data_theme', 'eccp_disable_custom_font_size_theme_json', 10, 1 );
}


/***********************************************************************************************
                                       PERSONNALISER EDITEUR GUTENBERG            
***********************************************************************************************/

/*-------------------------- DESACTIVER LE MODE PLEIN ECRAN DE GUTENBERG -------------------------*/
 //Ce code vérifie d’abord si un utilisateur affiche une page de zone d’administration de WordPress 
// et si on à choisi de désactiver le mode plein écran
//Si oui, il vérifie le statut de l’éditeur plein écran.
//Si l’éditeur plein écran est activé, il le désactive simplement. 
                
if (is_admin() && $custom_gutenberg_editor_settings['eccp_settings_disable_fullscreen_gutenberg_editor_checkbox_field'] == true ) {
	
    function eccp_disable_editor_fullscreen_by_default() {
		$script = "jQuery( window ).load(function() { 
		const isFullscreenMode = wp.data.select( 'core/edit-post' ).isFeatureActive( 'fullscreenMode' ); 
		if ( isFullscreenMode ) { wp.data.dispatch( 'core/edit-post' ).toggleFeature( 'fullscreenMode' ); } });";
		wp_add_inline_script( 'wp-blocks', $script );
    }
	
add_action( 'enqueue_block_editor_assets', 'eccp_disable_editor_fullscreen_by_default' );

}


/*------------ ACTIVER LA FEUILLE DE STYLE PAR DÉFAUT -------------------------*/

// si on à choisi d'activer la feuille de style par défauts de blocs Guteneberg en Front End
if( $custom_gutenberg_editor_settings['eccp_settings_activate_default_style_sheet_on_front_end_checkbox_field'] == true ) {
	add_theme_support( 'wp-block-styles' );
}

/*---------------- ALIGNEMENT LARGE & PLEINE LARGEUR POUR L 'EDITEUR DE BLOCS -------------------------*/
// Certains blocs tels que le bloc image ont la possibilité de définir 
// un alignement «pleine largeur» ou «grande largeur»
// Ajout dans l’éditeur de nouvelles options d’alignement : pleine largeur et grande largeur 
// n'est pas pris en charge par tous les thèmes.
function eccp_option_align_wide() {
	
	add_theme_support( 'align-wide' );
}

// si on à activé l'alignement large pour l'éditeur de blocs
if( $custom_gutenberg_editor_settings['eccp_settings_activate_align_wide_block_editor_checkbox_field'] == true ) {
	add_action( 'after_setup_theme', 'eccp_option_align_wide' );
}


/*------------ EMBEDS RESPONSIVE (EX: Intégration Vidéos YouTUbe) -------------------------*/

// Si on à activé les embeds responsive
if( $custom_gutenberg_editor_settings['eccp_settings_activate_responsive_embeds_checkbox_field'] == true ) {
	add_theme_support( 'responsive-embeds' );
}

// pour cetrains thème l'activation Embeds Responsive est mal supporté
// et induit une marge interne haute, alors on désactive cette fonctionnalité
if( $custom_gutenberg_editor_settings['eccp_corrective_according_to_theme_radio_field'] == 'yes' ) {
	remove_theme_support( 'responsive-embeds' );
}


/*------------ Activer la prise en charge des nouveaux paramètres de blocs Introduit depuis WordPress 6.0 ---------*/

function eccp_enable_support_new_block_settings( $editor_settings ) {

	// récupération des paramètres du plugin pour personnaliser l'editeur
	$custom_gutenberg_editor_settings = get_option( 'eccp_settings_custom_gutenberg_editor' );

	/*------------ Activer la prise en charge de Padding et Margin --------------*/
	// Marge Interne: Groupe, Colonne, Cover, Bouton
	// Marge Externe: Titre,colonnes
	// Gap ou espacement des blocs: Colonnes
	if ($custom_gutenberg_editor_settings['eccp_settings_activate_support_margin_padding_checkbox_field']){
		
		$editor_settings["enableCustomSpacing"] = true;
		$editor_settings["__experimentalFeatures"]["spacing"]["margin"] = true;
		// espacement des blocs normalement activé avec WordPress 6.1
		$editor_settings["__experimentalFeatures"]["spacing"]["blockGap"] = true;
		
	}
	
	/*------------ Activer la prise en charge de la Bordure(Rayon Epaisseur,Couleur,Style) --*/
	// Bloc Colonnes,Groupe,Image
	if($custom_gutenberg_editor_settings['eccp_settings_activate_support_border_checkbox_field']){
	
		$editor_settings["__experimentalFeatures"]["border"]["color"] = true;
		$editor_settings["__experimentalFeatures"]["border"]["radius"] = true;
		$editor_settings["__experimentalFeatures"]["border"]["style"] = true;
		$editor_settings["__experimentalFeatures"]["border"]["width"] = true;
    
	}
	
	/*------------ activation de la hauteur de ligne en particulier pour le thème OceanWP --*/
	// activé par défaut pour le thème Astra
	$editor_settings["__experimentalFeatures"]["typography"]["lineHeight"] = true;
	
	
	/*------------ Désactiver la catégorie Openverse pour l'onglet média de l'inséreuse de blocs --*/
	if($custom_gutenberg_editor_settings['eccp_settings_disable_openverse_category_from_media_tab_checkbox_field']){
		$editor_settings['enableOpenverseMediaCategory'] = false;
	} 
	
	/*------------ Désactiver les onglets Paramètres & Styles pour la barre latérale onglet bloc --*/
	if($custom_gutenberg_editor_settings['eccp_settings_disable_settings_styles_tabs_for_sidebar_checkbox_field']){
		$editor_settings['blockInspectorTabs']['default'] = false;
	} 
	
	
	return $editor_settings;
	
}
  
add_filter( 'block_editor_settings_all', 'eccp_enable_support_new_block_settings', 10, 1 );


/*------------ Couleur d'arrière plan de l'éditeur ---------*/

// pour bien déclarer le style uniquemment pour l'éditeur en back office on utilise 
// le hook: enqueue_block_editor_assets
if ( $custom_gutenberg_editor_settings['eccp_settings_enable_editor_background_color_checkbox_field'] ) {
	add_action('enqueue_block_editor_assets', 'ecpp_default_gutenberg_editor_background');
}

function ecpp_default_gutenberg_editor_background() {
	
	add_action( 'admin_head', function() {
	
		// Si on est en back office & si l'objet d'écran est l'éditeur Gutenberg,
		// alors on peut charger notre style sinon on sort
		if (!is_admin() and !get_current_screen()->is_block_editor() ) {
			return;
		}
		
		// récupération des paramètres du plugin pour personnaliser l'editeur
	    $custom_gutenberg_editor_settings = get_option( 'eccp_settings_custom_gutenberg_editor' );

		
		echo '<style id="editor-custom-color-palette" type="text/css">';
		
			echo'body.wp-admin .editor-styles-wrapper.block-editor-writing-flow{';
				echo'background-color:'.$custom_gutenberg_editor_settings['eccp_settings_editor_background_color_text_field'].';';
			echo'}';

		echo '</style>';
		
	});

}



/*------------ Désactiver pour une image JPEG la génération d'image WebP par défaut pour les miniatures introduit depuis WordPress 6.1 ---------*/

// Si on a désactivé la génération d'image WebP
// On utilise le hook wp_upload_image_mime_transforms qui permet de 
// filtrer les types mime utilisés uniquement pour la génération des miniatures JPEG. 
// N'empêche pas la génération de l'image d'origine au format WebP car c'est le format de sortie
// par défaut à partir de WordPress 6.1.
// si on désactive les miniatures WebP 
// alors c'est l'image JPEG qui est présenté dans la médiathèque et en Front End
// car il est précisé Par défaut, lorsqu'un type n'est pas mappé dans le tableau fournit en paramètre 
// de la fonction wp_upload_image_mime_transforms, la sortie est dans le type mime de l'image téléchargée
if($custom_gutenberg_editor_settings['eccp_settings_disable_webp_image_generation_checkbox_field']){
	add_filter( 'wp_upload_image_mime_transforms', '__return_empty_array' );
}


/*------------ Désactiver le téléchargement des images WebP & pour le format JPEG la  génération d'image WebP pour les miniatures  ---------*/

// Remarque: le format de sortie pour la balise image étant le WebP a partir de WordPress 6.1
// même si on interdit le type mime WebP, l'image d'origine au format JPEG sera quand même 
// généré en WebP

// supprime le type mime:WebP
function my_custom_mime_types( $mimes ) {
     
    // supprimer le type mime WebP
    unset( $mimes['webp'] );
 
    return $mimes;
}
 
if($custom_gutenberg_editor_settings['eccp_settings_disable_downloading_and_image_generation_webp_checkbox_field']){
	add_filter( 'upload_mimes', 'my_custom_mime_types' );
}


/***********************************************************************************************
                             ADMINISTRATION WORDPRESS          
***********************************************************************************************/

/*------------  AJOUT ET AFFICHAGE DU CONTENU DE NOUVELLES COLONNES DANS LE BACK OFFICE DE WORDPRESS --------------*/

/*-------------- Ajout colonne Image En Avant & ID dans le back Office de wordpress pour les Pages & Articles & CPT ---------------*/

/* Fonction Ajout de la colonne Image En Avant & ID */ 
function eccp_post_screen_add_columns($columns){
	
	 $columns ['featured_image']  = __( 'Featured Image', 'editor-custom-color-palette' );
	 $columns ['page_post_id']  = __( 'ID', 'editor-custom-color-palette' );
	 
	 return  $columns;
	 
}

if ( $custom_back_office_settings['eccp_settings_activate_post_featured_image_column_checkbox_field'] ==  true ) {
	//Ajout des colonnes & ID pour les articles
	add_filter('manage_posts_columns', 'eccp_post_screen_add_columns');
}

if ( $custom_back_office_settings['eccp_settings_activate_page_featured_image_column_checkbox_field'] ==  true ) {
	//Ajout des colonnes & ID pour les Pages
	add_filter('manage_pages_columns', 'eccp_post_screen_add_columns');
}

/*-------------- Afficher l'image en avant & ID pour les Pages & Articles & CPT dans le back office de wordpress ---------------*/

function eccp_post_screen_value_columns( $column_name, $post_id ) {
   
    switch ( $column_name ) {
					
		// Ajout de l'image mise en avant pour l'article ou page ou CPT seulement si elle existe	
		case 'featured_image':
			if( has_post_thumbnail($post_id) ) {
				echo the_post_thumbnail( 'admin-post-featured-image' );
			}
			break;

		// Ajout de l'id de publication
		case 'page_post_id':
			echo  $post_id;
			break;
			
    }
	
}


if ( $custom_back_office_settings['eccp_settings_activate_post_featured_image_column_checkbox_field'] ==  true ) {
// Ajout du contenu des colonnes Image En Avant pour les Articles & CPT
// pour le hook : manage_posts_custom_column on fait appel 
// a la fonction eccp_post_screen_value_columns avec une priorité 10
// elle comprend deux arguments: $column_name & $id
add_action('manage_posts_custom_column', 'eccp_post_screen_value_columns', 10, 2);
}

if ( $custom_back_office_settings['eccp_settings_activate_page_featured_image_column_checkbox_field'] ==  true ) {
	add_action('manage_pages_custom_column', 'eccp_post_screen_value_columns', 10, 2);
}

/*-------------- On organise les différentes colonnes de l'admin pour les articles & pages: Image En Avant,titre,ID,Catégories ... ---------------*/

// array_slice(array , position, longueur, ne pas réordonner les indices)
// si longeur est null ou omis alors on retourne tout les éléments depuis 
// la position offset jusqu'à la fin du tableau.
function organize_post_screen_admin_columns( $columns ) {

	// on affiche 1 élément a partir de la position 0
	// soit la case a cocher 
    $columns = array_slice( $columns, 0, 1, true ) 
	+ array(
	         'featured_image' => __( 'Featured Image', 'editor-custom-color-palette' ), // Ajout de la colonne image en avant en position 1
      ) 
	// on affiche le restant du tableau a partir de la position 1 avec pour commencer le Titre
	+ array_slice( $columns, 1, NULL, true );

    return $columns;
}

if ( $custom_back_office_settings['eccp_settings_activate_post_featured_image_column_checkbox_field'] ==  true ) {
	// on utilise le hook: manage_post_type_posts_columns  
	// post-type est a remplacer par le slug du type de publication personnalisé
	// dans notre cas post pour les articles & page pour les pages
	add_filter('manage_post_posts_columns', 'organize_post_screen_admin_columns');
}

if ( $custom_back_office_settings['eccp_settings_activate_page_featured_image_column_checkbox_field'] ==  true ) {
	add_filter('manage_page_posts_columns', 'organize_post_screen_admin_columns');
}


/*-------------- On organise les différentes colonnes de l'admin pour les CPT: Image En Avant ,titre,ID,Catégories ... ---------------*/

// on récupère les slug des CPT et on
// On organise les différentes colonnes de l'écran des CPT
function eccp_get_custom_post_type() {
	
	/*
	Array(
		[0] => cours-rock4temps
		[1] => tribe_events
	)
	*/
	// On récupère les slugs des CPT sous forme d'un tableau qui est indexé de façon numérique
	$all_slug_cpt = eccp_get_slug_all_custom_post_type(); 
	
	
	/* pour debug 
		echo'<pre>';
		print_r($all_cpt);
		echo'</pre>';
	*/	
					
	// s'il y a des Custom Post Type
	if ( !empty( $all_slug_cpt ) ) {
	
	
		foreach ( $all_slug_cpt as $value) {
					
			// on utilise le hook: manage_post_type_posts_columns  
			// post-type est a remplacer par le slug du type de publication personnalisé
			// dans le cas du site Rock4Temps $value = cours-rock4temps
			add_filter('manage_'.$value.'_posts_columns', 'eccp_organize_admin_columns_cpt');
		
		}
		
	}
	
}

if ( $custom_back_office_settings['eccp_settings_activate_post_featured_image_column_checkbox_field'] ==  true ) {
	// certain CPT sont créées au sein de plugins WordPress comme CPT UI, 
	// on va retarder un peu le processus global, et attendre qu’ils soient tous chargés 
	// pour exécuter notre fonction.
    // Le hook « plugins_Loaded » semble un peu tardif, 
	// on va utiliser le hook « init »
	add_action('admin_init','eccp_get_custom_post_type');
}

// array_slice(array , position, longueur, ne pas réordonner les indices)
// si longeur est null ou omis alors on retourne tout les éléments depuis 
// la position offset jusqu'à la fin du tableau.
function eccp_organize_admin_columns_cpt( $columns ) {
	
	// on supprime les colonnes catégories & étiquettes
	// qui sont pour les articles
	//unset($columns['categories']);
	//unset($columns['tags']);

	// on affiche 1 élément a partir de la position 0
	// soit la case a cocher 
	$columns = array_slice( $columns, 0, 1, true ) 
	
	+ array(
			 'featured_image' => __( 'Featured Image', 'editor-custom-color-palette' ), // Ajout de la colonne image en avant en position 1
		)
	
	// on affiche le restant du tableau a partir de la position 1 avec pour commencer le Titre
	+ array_slice( $columns, 1, NULL, true );
		
    return $columns;
	
}

/*-------------- Enregistre la colonne taxonomy-slug-catégorie du CPT comme triable ---------------*/

function eccp_modified_taxonomy_columns_cpt_sortable($columns) {
	
	// on récupère le type de publication
	$post_type = get_current_screen()->post_type;
	

	/* pour debug 	
	echo'type de publication: '.$post_type.'<br>';
	*/	
	
	
	// Récupération des taxonomies liées au Custom Post Type courant
	// get_object_taxonomies retourne un tableau des taxonomies
	// pour le slug du CPT passé en paramètre
	$taxonomies = get_object_taxonomies( $post_type );
	
	/* pour debug 	
	echo'<pre>';
		echo 'taxonomies: '.'<br>';
		 print_r($taxonomies);
		 echo'<br>';
	echo'</pre>';
	*/
	
	
	// Pour chaque taxonomies $slug_taxonomy nous donne le slug
	// Ajout de l’ID de la colonne taxonomie au tableau des colonnes triables
	foreach( $taxonomies as $slug_taxonomy ){
		
		// on récupère un objet de taxonomie pour le slug: $slug_taxonomy donné en paramètre
		$taxonomy_object = get_taxonomy( $slug_taxonomy );
		
		
		/* pour debug 
		echo'<pre>';
			print_r($taxonomy_object);
			echo'<br>';
		echo'</pre>';
		*/
		
		// Ajout de l’ID de la colonne taxonomie au tableau des colonnes triables
		// ID = taxonomy-slug-taxonomy
		// $taxonomy_object->label donne le nom de la Taxonomie 
		// qui est l'en tête de la colonne taxonomie
		$columns[ 'taxonomy-'.$slug_taxonomy ] = $taxonomy_object->label ;
		
		
	}
	
	
	return $columns;
	
}

// On boucle sur tous les CPT pour rendre la colonne Taxonomie
// triable excepté pour le plugin The Events Calendar
function eccp_loop_through_custom_post_type() {
	
	/*
	Array(
		[0] => cours-rock4temps
		[1] => tribe_events
	)
	*/
	// On récupère les slugs des CPT sous forme d'un tableau qui est indexé de façon numérique
	$all_slug_cpt = eccp_get_slug_all_custom_post_type(); 
	
	
	/* pour debug  
		echo'<pre>';
		print_r($all_slug_cpt);
		echo'</pre>';
	*/
	
					
	// s'il y a des Custom Post Type
	if ( !empty( $all_slug_cpt ) ) {
	
		
		foreach ( $all_slug_cpt as $value) {
			
			// la colonne Taxonomie est déja rendu triable par le plugin
			// The Events Calendar
			if ( $value !== 'tribe_event' ) {
					
				// on utilise le hook: manage_edit-post_type_sortable_columns pour un CPT 
				// post_type est a remplacer par le slug du type de publication personnalisé
				// dans le cas du site Rock4Temps $value = cours-rock4temps
				add_filter('manage_edit-'.$value.'_sortable_columns', 'eccp_modified_taxonomy_columns_cpt_sortable');
		
			}
		
		}
		
	}
	
}


// Puisque certaines taxonomies personnalisées sont créées au sein de plugins WordPress comme CPT UI, 
// on va retarder un peu le processus global, et attendre qu’ils soient tous chargés 
// pour exécuter notre fonction.
// Le hook « plugins_Loaded » semble un peu tardif, 
// on va utiliser le hook « init »
add_action('admin_init','eccp_loop_through_custom_post_type');




/******** Ajouter des champs d'édition rapide en HTML pour l'Image Mise En Avant ***************************/

/*
On utilise le hook: quick_edit_custom_box
On regroupe le champ input qui contient l'image en avant dans une balise <fieldset>
avec la structure ci-dessous.
Les classes inline-edit-col-left,inline-edit-col,title sont native a WordPress
la classe upload-img & remove-img sont utilisé par le script Jquery pour respectivement:
- le bouton: sélectionner image
- le lien situé en dessous image pour la suppression image
Lorsque l'image est supprimée le bouton sélectionner image apparait & vice versa
Nécessite le script Jquery :eccp-upload-featured-image.js pour fonctionner
ce script est dans le dossier JS du plugin
Les champs HTML sont ajouté uniquement si on a activé une colonne featured_image
pour les écrans de publication article ou page ou CPT
*/
add_action( 'quick_edit_custom_box',  'eccp_featured_image_quick_edit', 10, 2 );
function eccp_featured_image_quick_edit( $column_name, $post_type ) {

	// ajout des champs uniquement si nous avons une colonne d'images en avant
	if( 'featured_image' !== $column_name ){
		return;
	}
	?>
		<fieldset id="featured_image" class="inline-edit-col-left">
			<div class="inline-edit-col">
				<span class="title">Image En Avant</span>
				<div>
					<a href="#" class="button upload-img">Select Image</a>
					<input type="hidden" name="_thumbnail_id" value="" />
				</div>
				<a href="#" class="remove-img">Supprimer Image</a>
			</div>
		</fieldset>
	
	<?php
		
}


/*-------------- Filtrer les publications par auteur ---------------*/

// Ajoute un filtre pour tous les type de publication afin de lister les articles , pages etc..
// selon l'auteur sélectionné

/*
On utilise le hook  restrict_manage_posts
Le bouton Filtrer permet de trier par date et/ou catégorie sur le tableau de la liste des Articles, 
et de trier par date sur le tableau de la liste des Pages.
le hook restrict_manage_posts se déclenche avant le bouton Filtrer

Pour afficher la liste des auteurs on utilise la fonction wp_dropdown_users()
avec un tableau d'argument:
•role__in: Un tableau de noms de rôle. Les utilisateurs correspondants doivent 
avoir au moins un de ces rôles. Tableau vide par défaut.
• name: Attribut de nom de l'élément sélectionné. Par défaut 'user'
• show_option_all: Texte à afficher comme liste déroulante par défaut (tous)
• show: Données utilisateur à afficher. Accepte n'importe quel champ utilisateur
'ID' or 'user_login' etc.. 
chaine vide ou par défaut:display_name c'est alors le nom a afficher publiquement qui est listé 
display_name_with_login: c'est alors le nom a afficher publiquement avec user_login entre parenthèses.
exemple Rock 4 Temps(wpadmin)
• echo: faire écho ou retourner la liste déroulante. 
Accepte 1|true(écho) ou 0|false(retour). Par défaut 1|true
• id (chaîne): Attribut ID de l'élément sélectionné. La valeur par défaut est la valeur de $name.
• selected(int): id de l'option sélectionné. 0 par défaut
*/
if ( $custom_back_office_settings['eccp_settings_activate_author_filter_checkbox_field'] ==  true ) {
	add_action( 'restrict_manage_posts', 'eccp_filter_by_the_author' );
}

function eccp_filter_by_the_author( $post_type ) {
	
	// vous pouvez ajouter une condition pour un type de publication spécifique
	// if( 'my_type' !== $post_type ) {
	// 	return;
	// }
	
	
	// style pour le champ de sélection autheur
	echo '<style>
		select[name="author"]{
			margin: 0 6px 0 0;
		}
	</style>';

	// On récupère l'id de l'auteur sélectionné via les paramètres d'URL et l'attribut author=1 par ex
	$selected = isset( $_GET[ 'author' ] ) && $_GET[ 'author' ] ? $_GET[ 'author' ] : '';
 
	wp_dropdown_users(
		array(
			'role__in' => array( 
				'administrator', 
				'editor', 
				'author',
				'contributor'
			),
			'name' => 'author',
			'show_option_all' => __('All authors','editor-custom-color-palette'),
			'show' => 'display_name', // vide ou par défaut:display_name ==> c'est le nom a afficher publiquement qui est listé 
			'selected' => $selected
		)
	); 
}

/*-------------- Filtrer les publications personnalisées par catégories ---------------*/

// Ajoute un filtre pour tous les type de publication personnalisé afin de lister les 
// taxonomies liées au Custom Post Type courant

/*
On utilise le hook  restrict_manage_posts
Le bouton Filtrer permet de trier par date les CPT, 
le hook restrict_manage_posts se déclenche avant le bouton Filtrer

Pour afficher la liste des catégories on utilise la fonction wp_dropdown_categories()
avec un tableau d'argument:
• show_option_all: Texte à afficher pour afficher toutes les catégories.
• taxonomy: Nom de la taxonomie ou des taxonomies à récupérer. Par défaut 'category'.
• name: nom de l'attribut name de la zone déroulante. Par défaut 'cat'
• oderby: classer les catégories,Par défaut 'id'  mais aussi: name/ slug / count / term_order etc
• value_field (chaîne): Champ de terme qui doit être utilisé pour renseigner l'attribut 'value' des éléments d'option. 
Accepte tout champ de terme valide : 'term_id', 'name', 'slug', 'term_group', 'term_taxonomy_id', 'taxonomy', 'description', 'parent', 'count'. Default 'term_id'.
• hierarchical (booléen): indique si on prend en compte une taxonomie hiérachisé
• echo: faire écho ou retourner la liste déroulante. 
Accepte 1|true(écho) ou 0|false(retour). Par défaut 1|true
• id (chaîne): Attribut ID de l'élément sélectionné. La valeur par défaut est la valeur de $name.
• show_count: si on compte ou non le nbr de catégorie. Default  'false'
• selected(int): id de l'option sélectionné. 0 par défaut
• hide_if_empty (booléen): créer une zone déroulante même si aucune catégorie n'est trouvée
*/

if ( $custom_back_office_settings['eccp_settings_activate_taxonomy_filter_cpt_checkbox_field'] ==  true ) {
	add_action( 'restrict_manage_posts', 'eccp_cpt_taxonomy_filter' );
}

function eccp_cpt_taxonomy_filter( $post_type ){
	
	/*
	Array(
		[0] => cours-rock4temps
		[1] => tribe_events
	)
	*/
	// On récupère les slugs des CPT sous forme d'un tableau qui est indexé de façon numérique
	$all_cpt = eccp_get_slug_all_custom_post_type(); 
	
	
	/* pour debug 
		echo'<pre>';
		print_r($all_cpt);
		echo'</pre>';
	*/
	
	
	// On filtre $post_type pour être sur que ce soit bien un CPT définit par l'utilisateur 
	// sinon on ne fait rien on sort
	if( !in_array( $post_type, $all_cpt ) )
	{
		return;
	}

	// Récupération des taxonomies liées au Custom Post Type courant
	// get_object_taxonomies retourne un tableau des taxonomies
	// pour le slug du CPT passé en paramètre
	$taxonomies = get_object_taxonomies( $post_type );
	
	/* pour debug 	
	echo'<pre>';
		print_r($taxonomies);
	echo'</pre>';
	*/
	
	
	// Pour chaque taxonomies $slug_taxonomy nous donne le slug
	// on affiche une zone déroulante avec la liste des catégories
	// il persiste un problème dans le cas du plugin The Events Calendar
	// pour le slug post_tag des étiquettes
	// en effet s'il n'ya pas d'étiquette une zone déroulente étroite vide
	// est affichée pour sélectionner les étiquettes
	foreach( $taxonomies as $slug_taxonomy ){
		
		
		// on récupère un objet de taxonomie pour le slug: $slug_taxonomy donné en paramètre
		$taxonomy_object = get_taxonomy( $slug_taxonomy );
		
		
		//$taxonomy_object->labels->all_items
		// nous donne: Tous les + le nom de la catégorie
		// soit par ex: Tous les Catégories cours Rock 4 Temps
		
		/* pour debug 
		echo'<pre>';
		print_r($taxonomy_object);
		echo'</pre>';
		*/
		
		// soit par exemple $slug_taxonomy = categories_cours
		// alors l'attribut name de la zone déroulante vaut ==> name = categories_cours
		// lorsqu'on clique sur une option de la zone déroulante,on récupère l'id de la taxonomie sélectionné 
		// alors via les paramètres d'URL on passe en paramètre de requête 
		// valeur attribut name = slug taxonomie
		// soit par exemple categories_cours = debutant (debutant étant le slug d'une option de la zone déroulante)
		$selected = isset( $_GET[ $slug_taxonomy ] ) ? $_GET[ $slug_taxonomy ] : '';
		
		wp_dropdown_categories( 
			array(
				'show_option_all' =>  $taxonomy_object->labels->all_items,
				'taxonomy'        =>  $slug_taxonomy,
				'name'            =>  $slug_taxonomy,
				'orderby'         =>  'name', //  name: nom de la taxonomie ,on peut aussi utiliser: slug / count / term_order etc
				'value_field'     =>  'slug',
				'show_count'      => true,
				'selected'        =>  $selected,
				'hierarchical'    =>  true,
				'hide_if_empty'   =>  false,
			)
		);
		
		// style pour la colonne de la taxonomie du CPT
		echo '<style id="taxonomy-column-cpt" type="text/css">';
			echo 'th#taxonomy-'.$slug_taxonomy.'{width:140px;}';
		echo '</style>';
		
	}
	
	
}


/*-------------- Filtrer les publications & Médiathèque par plage de dates ---------------*/

// Ajoute un filtre pour tous les articles &  types de publication personnalisé 
// afin de lister les publications par plage de dates
// fait de même pour la médiathèque seulement en vue liste

/* 
Les crochets dont nous a besoin:
• admin_enqueue_scripts
• restrict_manage_posts
• pre_get_posts

admin_enqueue_scripts nous sert à inclure le script jquery-ui-datepicker 
car la bibliothèque est déjà enregistrée par Wordpress, 
il ne nous reste plus qu'a l'inclure dans la zone d'administration.
restrict_manage_posts pour créer le champ de filtrage. 
pre_get_posts nous sert à filtrer les messages, 

fichiers Jquery: https://jqueryui.com/themeroller/  
dans l'onglet gallery télécharger le thème smoothness
et ne garder que le fichier de style jquery-ui.min.css
pour mettre en file d'attente la feuille de style css 
a partir du dossier css de l'extension.
version actuelle 1.13.2 pour Jquery 1.8+

*/


add_action( 'admin_enqueue_scripts', 'eccp_jqueryui' );

/*
 * Ajout de jQuery UI CSS et le script datepicker
 * Tout le reste est déjà inclus dans /wp-admin/ comme jquery, jquery-ui-core etc
 */
function eccp_jqueryui(){
		
		// Charger jQuery UI Datepicker 
		//(bibliothèque déjà enregistrée par Wordpress, rien d'autre n'est nécessaire)
		wp_enqueue_script( 'jquery-ui-datepicker' );
		
		// le tableau array() indique les dépendances autrement dit indiquer à 
		// WordPress que notre style devrait absolument être chargé après les styles indiqués en dépendances 
		// le numéro de version est important car il va permettre d’invalider le cache du navigateur 
		// lorsqu'on fera évoluer le style.
		// par défaut le dernier paramètre est à false et le style est chargé dans le head
		/*
		wp_enqueue_style( 
			'jquery-ui-style', 
			EDITOR_CUSTOM_COLOR_PALETTE_URL.'css/jquery-ui.min.css', 
			array( 'jquery-ui-core', 'jquery-ui-datepicker' ), 
			ECCP_PLUGIN_VERSION 
		);
		*/
		
		// Enregistrez la feuille de style en ligne pour le Date Picker
		wp_enqueue_style( 'jquery-ui', '//code.jquery.com/ui/1.13.2/themes/smoothness/jquery-ui.min.css' );
		
}


add_action( 'restrict_manage_posts', 'eccp_date_publication_form' );

/*
 * fonction pour afficher 
 * Deux champs de saisie pour les dates avec régles CSS & script JS
 */
function eccp_date_publication_form($post_type){
	
	// on récupère les paramètres de réglages de l'extension
	$custom_back_office_settings = get_option( 'eccp_settings_custom_back_office' );
	
	global $pagenow;
	
	// déclaration d'un tableau pour les écrans admin autorisés
	$publish_screen_allowed = array();
	
	
	// si on a activé l'option filtre par plage de date
	// pour les articles & CPT & la médiathèque
	// alors l'écran admin qui liste ces publications est edit.php
	// pour la médiathèque c'est upload.php
	if($custom_back_office_settings['eccp_settings_enable_post_cpt_date_range_filter_checkbox_field']
	   && $custom_back_office_settings['eccp_settings_enable_filter_dates_range_media_library_checkbox_field']){
	
		$publish_screen_allowed = array('edit.php','upload.php');
	
	// sinon si on a activé l'option filtre par plage de date
	// pour les articles & CPT
	}else if($custom_back_office_settings['eccp_settings_enable_post_cpt_date_range_filter_checkbox_field']){
		$publish_screen_allowed = array('edit.php');
	}else if($custom_back_office_settings['eccp_settings_enable_filter_dates_range_media_library_checkbox_field']){
		$publish_screen_allowed = array('upload.php');
	}
	
	// Si la publication en cours est une page
	// ou si l'écran admin en cours ne fait pas partie des écrans autorisé 
	// ou si le tableau qui gère les écrans admin autorisé est vide
	// alors on n'active pas de filtre par plage de date, on sort
	if( $post_type == 'page' || !in_array($pagenow,$publish_screen_allowed) 
		 || empty($publish_screen_allowed)  ) {
	 	return;
	}
		
	// récupération de la plage de date
	$from = ( isset( $_GET['eccpDateFrom'] ) && $_GET['eccpDateFrom'] ) ? $_GET['eccpDateFrom'] : '';
	$to = ( isset( $_GET['eccpDateTo'] ) && $_GET['eccpDateTo'] ) ? $_GET['eccpDateTo'] : '';
	
	// style pour les champs de date
	echo '<style>
		input[name="eccpDateFrom"], input[name="eccpDateTo"]{
			line-height: 28px;
			height: 28px;
			margin: 0 6px 0 0;
			width:125px;
		}
	</style>';
	
	
	// affichage des champs de date
	echo'<input type="text" name="eccpDateFrom" placeholder="'.esc_html__('Date From','editor-custom-color-palette').'" value="' . esc_attr( $from ) . '" />';
	echo'<input type="text" name="eccpDateTo" placeholder="'.esc_html__('Date To','editor-custom-color-palette').'" value="' . esc_attr( $to ) . '" />';


	// scrit JS pour les champs de date
	echo'<script>
	
		jQuery( function($) {
			
			var from = $(\'input[name="eccpDateFrom"]\'),
				to = $(\'input[name="eccpDateTo"]\');

			$( \'input[name="eccpDateFrom"], input[name="eccpDateTo"]\' ).datepicker( {dateFormat : "dd-mm-yy"} );
			// Par défaut, les dates ressemblent à ceci " 3 Avril, 2023"
			// datepicker({dateFormat : "dd-mm-yy"}) permet d\'établir le format 03-04-2023 ;
	
			// la partie restante du script empêche de choisir un intervalle de date incorrect
			from.on( \'change\', function() {
				to.datepicker( \'option\', \'minDate\', from.val() );
			});
				
			to.on( \'change\', function() {
				from.datepicker( \'option\', \'maxDate\', to.val() );
			});
			
		});
	
	</script>';
		
}


add_action( 'pre_get_posts', 'eccp_date_publication_query_filter' );

/*
 * La fonction principale qui filtre réellement les messages
 * 
 */
function eccp_date_publication_query_filter( $admin_query ){
	
	// on récupère les paramètres de réglages de l'extension
	$custom_back_office_settings = get_option( 'eccp_settings_custom_back_office' );
	
	// on récupère le type de publication par les paramètres d'URL
	// pour une page en admin: wp-admin/edit.php?post_type=page
	$post_type = (isset($_GET['post_type'])) ? $_GET['post_type'] : '';
	
	global $pagenow;
	
	// déclaration d'un tableau pour les écrans admin autorisés
	$publish_screen_allowed = array();
	
	// si on a activé l'option filtre par plage de date
	// pour les articles & CPT & la médiathèque
	// alors l'écran admin qui liste ces publications est edit.php
	// pour la médiathèque c'est upload.php
	if($custom_back_office_settings['eccp_settings_enable_post_cpt_date_range_filter_checkbox_field']
	   && $custom_back_office_settings['eccp_settings_enable_filter_dates_range_media_library_checkbox_field']){
	
		$publish_screen_allowed = array('edit.php','upload.php');
	
	// sinon si on a activé l'option filtre par plage de date
	// pour les articles & CPT
	}else if($custom_back_office_settings['eccp_settings_enable_post_cpt_date_range_filter_checkbox_field']){
		$publish_screen_allowed = array('edit.php');
	}else if($custom_back_office_settings['eccp_settings_enable_filter_dates_range_media_library_checkbox_field']){
		$publish_screen_allowed = array('upload.php');
	}
	
	// Si la publication en cours est une page
	// ou si l'écran admin en cours ne fait pas partie des écrans autorisé 
	// ou si le tableau qui gère les écrans admin autorisé est vide
	// alors on n'établit pas la requête par plage de date, on sort
	if( $post_type == 'page' || !in_array($pagenow,$publish_screen_allowed) 
		 || empty($publish_screen_allowed)  ) {
	 	return;
	}
	
	
	if (
		is_admin()
		&& $admin_query->is_main_query()
		&& in_array( $pagenow, $publish_screen_allowed )
		&& ( ! empty( $_GET['eccpDateFrom'] ) || ! empty( $_GET['eccpDateTo'] ) )
	) {
		// on établit la requête
		$admin_query->set(
			'date_query', 
			array(
				// la date est converti par strtotime() pour établir le requête donc devient dd-mm-yy 00:00:00
				'after' => sanitize_text_field( $_GET['eccpDateFrom'] ),
				 // on ajoute 23:59:59 avant la conversion par strtotime()   
				 // pour être sur d'avoir la journée entière prise en compte
				'before' => sanitize_text_field( $_GET['eccpDateTo'] )? sanitize_text_field($_GET['eccpDateTo'] . ' 23:59:59') : '',
				'inclusive' => true, // inclure également les jours sélectionnés
				'column'    => 'post_date' // 'post_modified', 'post_date_gmt', 'post_modified_gmt'
			)
		);
		
	}
	
	return $admin_query;

}


/*-------------- Filtrer les Articles par status de publication ---------------*/

/* 
Les crochets dont nous a besoin:
• restrict_manage_posts
• pre_get_posts

restrict_manage_posts pour créer le champ de filtrage. 
pre_get_posts nous sert à filtrer les messages, 
*/

add_action( 'restrict_manage_posts', 'eccp_publication_status_form' );

/*
 * fonction pour afficher un champ select
 *
 */
function eccp_publication_status_form($post_type){
	
	// on récupère les paramètres de réglages de l'extension
	$custom_back_office_settings = get_option( 'eccp_settings_custom_back_office' );
	
	global $pagenow;
	
	// déclaration d'un tableau pour les écrans admin autorisés
	$publish_screen_allowed = array();
	
	// si on a activé l'option filtre par satuts de publication pour les articles
	// alors l'écran admin qui liste les aticles est edit.php
	if($custom_back_office_settings['eccp_settings_enable_post_filter_publication_status_checkbox_field']){
		$publish_screen_allowed = array('edit.php');
	}
	
	// Si la publication en cours n'est pas un article
	// ou si l'écran admin en cours ne fait pas partie des écrans autorisé 
	// ou si le tableau qui gère les écrans admin autorisé est vide
	// alors on n'active pas de filtre par statuts de publication
	if( 'post' !== $post_type || !in_array($pagenow,$publish_screen_allowed) 
		 || empty($publish_screen_allowed)  ) {
	 	return;
	}
	
	
	// on récupère par l'URL le statut de publication sélectionné dans la zone déroulante du filtre de publication
	$current_status = ( isset( $_GET['eccp_status'] ) && $_GET['eccp_status'] ) ? $_GET['eccp_status'] : '';
	
	// get_post_statuses() renvoi tous les status actuellement enregistrés pour le site Web. 
	$statuses = get_post_statuses();
	
	?>

		<select name="eccp_status">
		
			<option value=""><?= esc_html__('All statuses', 'editor-custom-color-palette'); ?></option>

			<?php

			// On ajoute les status en tant qu'options à un champ de sélection.
			foreach ($statuses as $key => $status) {
				printf(
					'<option value="%s"%s>%s</option>',
					$key,
					$key == $current_status ? 'selected="selected"' : '',
					$status
				);
			}
			
			?>
			
		</select>

	<?php
	
}


add_action( 'pre_get_posts', 'eccp_status_publication_query_filter' );

/*
 * La fonction principale qui filtre réellement les status
 * 
 */
function eccp_status_publication_query_filter( $admin_query ){
	
	// on récupère les paramètres de réglages de l'extension
	$custom_back_office_settings = get_option( 'eccp_settings_custom_back_office' );
	
	// on récupère le type de publication par les paramètres d'URL
	// pour un article en admin: wp-admin/edit.php?post_type=post
	$post_type = (isset($_GET['post_type'])) ? $_GET['post_type'] : '';
	
	global $pagenow;
	
	// déclaration d'un tableau pour les écrans admin autorisés
	$publish_screen_allowed = array();
	
	// si on a activé l'option filtre par satuts de publication pour les articles
	// alors l'écran admin qui liste les aticles est edit.php
	if($custom_back_office_settings['eccp_settings_enable_post_filter_publication_status_checkbox_field']){
		$publish_screen_allowed = array('edit.php');
	}
	
	// Si la publication en cours n'est pas un article
	// ou si l'écran admin en cours ne fait pas partie des écrans autorisé 
	// ou si le tableau qui gère les écrans admin autorisé est vide
	// alors on ne modifie pas la requête statuts de publication
	if( 'post' !== $post_type || !in_array($pagenow,$publish_screen_allowed) 
		 || empty($publish_screen_allowed)  ) {
	 	return;
	}
	
	
	if (
		is_admin()
		&& $admin_query->is_main_query()
		&& $pagenow == 'edit.php'
		&& ( isset( $_GET['eccp_status'] ) && !empty( $_GET['eccp_status'] ) )
	) {
		// on établit la requête
		$admin_query->set('post_status', $_GET['eccp_status'] );
	}
	
	return $admin_query;

}


/*-------------- Ajout d'options status de publication pour les actions groupés des articles  ---------------*/



if($custom_back_office_settings['eccp_settings_activate_publication_status_bulk_actions_posts_checkbox_field'] ) {
	add_filter( 'bulk_actions-edit-post', 'eccp_bulk_actions_posts' );
}


/*
bulk_actions-{screen id}– permet de supprimer les options d'action groupée par défaut 
et d'ajouter des options personnalisée dans la liste déroulante
via le tableau associatif: $bulk_actions.
screen id peut être vu sur chaque page d'administration WordPress 
en utilisant get_current_screen()
*/
function eccp_bulk_actions_posts( $bulk_actions ) {

	$bulk_actions[ 'eccp_make_draft' ] = __( 'Make draft' , 'editor-custom-color-palette' );
	$bulk_actions[ 'eccp_make_pending' ] = __( 'Make pending' , 'editor-custom-color-palette' );
	$bulk_actions[ 'eccp_make_private' ] = __( 'Make private' , 'editor-custom-color-palette' );
	$bulk_actions[ 'eccp_make_publish' ] = __( 'Make publish' , 'editor-custom-color-palette' );

	return $bulk_actions;

}



if($custom_back_office_settings['eccp_settings_activate_publication_status_bulk_actions_posts_checkbox_field'] ) {
	add_filter( 'handle_bulk_actions-edit-post', 'eccp_bulk_action_handler_posts', 10, 3 );
}

/*
Afin de déclencher quelque chose lors du choix de nos options nouvellement ajoutées 
dans la liste déroulante, on utilise le hook de filtre handle_bulk_actions-{screen id}
• $redirect_url:  URL vers laquelle WordPress doit rediriger après avoir terminé 
notre action groupée
• $action:  le nom de l'action qui a été choisie dans la liste déroulante
• $post_ids: tableau de tous les ID d'articles qui ont été sélectionnés pour l'action en bloc. 

*/
function eccp_bulk_action_handler_posts( $redirect_url, $action, $post_ids ) {

	// supprimons d'abord les arguments de requête
	$redirect_url = remove_query_arg(
		array( 'eccp_make_draft','eccp_make_pending', 'eccp_make_private','eccp_make_publish' ),
		$redirect_url
	);
	
	
	// Rappel des options personnalisés ajouter a la liste des actions groupées
	$options_actions[ 'eccp_make_draft' ] = 'draft';
	$options_actions[ 'eccp_make_pending' ] = 'pending';
	$options_actions[ 'eccp_make_private' ] = 'private';
	$options_actions[ 'eccp_make_publish' ] = 'publish';

	
	foreach ( $options_actions as $key => $value ) {
		
		// faire quelque chose pour l'action groupée $action
		// si $key === $action
		if ( $key === $action ) {
			
			// on met a jour le statut des articles sélectionnés
			foreach ( $post_ids as $post_id ) {
				wp_update_post(
					array(
						'ID' => $post_id,
						'post_status' => $value
					)
				);
			}

			// Nous ajoutons un argument personnalisé à l'URL de redirection fournie. 
			// Ceci est facultatif mais nécessaire si nous voulons afficher un avis d'administration
			$redirect_url = add_query_arg(
				$key, 
				count( $post_ids ), 
				$redirect_url
			);
			
		
		}	
		
	}
	

	/* 
	exemple ancien code
	faire quelque chose pour l'action groupée "Statut brouillon"
	if ( 'eccp_make_draft' === $action ) {

		foreach ( $post_ids as $post_id ) {
			wp_update_post(
				array(
					'ID' => $post_id,
					'post_status' => 'draft' 
				)
			);
		}

		// Nous ajoutons un argument personnalisé à l'URL de redirection fournie. 
		// Ceci est facultatif mais nécessaire si nous voulons afficher un avis d'administration
		$redirect_url = add_query_arg(
			'bulk_make_draft', 
			count( $post_ids ), 
			$redirect_url
		);

	}
	*/
	

	return $redirect_url;

}



if($custom_back_office_settings['eccp_settings_activate_publication_status_bulk_actions_posts_checkbox_field'] ) {
	add_action( 'admin_notices', 'eccp_bulk_action_notices_posts' );
}

// Afficher message de mise à jour du status des articles sélectionnés
function eccp_bulk_action_notices_posts() {
	
	if( !empty( $_REQUEST[ 'bulk_make_publish' ] ) ||
		! empty( $_REQUEST[ 'bulk_make_draft' ] ) || 
		! empty( $_REQUEST[ 'bulk_make_private' ] ) ) {
		?>
			<div class="updated notice is-dismissible">
				<p><?php echo esc_html__( 'Status posts updated' , 'editor-custom-color-palette' )?> </p>
			</div>
		<?php
	}

}


/*-------------- AJouter des colonnes dans la médiathèque pour l'identifiant du Média & Dimensions (L,H) & Taille  ---------------*/

// Ajout de colonnes dans la médiathéque : ID & Dimensions (L,H)
function eccp_add_columns_media($columns){
	
	$columns ['mediaID']  = __('ID','editor-custom-color-palette');
	$columns ['mediaDimensions']  = __('Dimensions (W,H)', 'editor-custom-color-palette');
	$columns ['fileSize']  = __('File Size','editor-custom-color-palette');
	 
	return  $columns;
	
}

if ( $custom_back_office_settings['eccp_settings_activate_library_id_dimensions_size_file_column_checkbox_field'] ==  true ) {
	add_filter( 'manage_media_columns', 'eccp_add_columns_media' );
}

/*-------------- Enregistre les nouvelles colonnes Média comme triable ---------------*/

function eccp_modified_column_media_register_sortable( $columns ) {
	
	$columns ['mediaID']  = __('ID','editor-custom-color-palette');
	$columns ['mediaDimensions']  = __('Dimensions (W,H)', 'editor-custom-color-palette');
	$columns ['fileSize']  = __('File Size','editor-custom-color-palette');
			
    return $columns;
}

if ( $custom_back_office_settings['eccp_settings_activate_library_id_dimensions_size_file_column_checkbox_field'] ==  true ) {
	add_filter( 'manage_upload_sortable_columns', 'eccp_modified_column_media_register_sortable' , 10, 1 );
}

/*-------------- Affichage du contenu des colonnes Média: ID & Dimensions (L,H) & Taille ---------------*/

function eccp_value_columns_media( $column_name, $id ) {
   
   switch ( $column_name ) {
		
		// On récupère l'id du média
		case 'mediaID':
			echo $id;
			break;
			
		// On récupère les dimensions du média	
		case 'mediaDimensions':
			$meta = wp_get_attachment_metadata($id);
			if(isset($meta['width']))echo $meta['width'].' x '.$meta['height'];
			break;	
			
		// On récupère la taille des fichiers média	
		case 'fileSize':
			$filesize = filesize( get_attached_file($id) );
			$filesize = size_format($filesize, 2);
			echo $filesize;
			break;
    }
}

if ( $custom_back_office_settings['eccp_settings_activate_library_id_dimensions_size_file_column_checkbox_field'] ==  true ) {
	add_action( 'manage_media_custom_column', 'eccp_value_columns_media', 10, 2 );
}

/*-------------- Autoriser l'upload de tous types de format dans la bibliothèque médias ---------------*/

/* Autoriser l'upload de tous types de format dans les médias 
   https://www.freeformatter.com/mime-types-list.html#mime-types-list */


/*
on ajoute les extensions de fichier à la liste des types MIME autorisés. 
Cela garantit que WordPress reconnaît ces types de fichiers comme 
des téléchargements valides.
*/
if ( $custom_back_office_settings['eccp_settings_activate_mime_types_media_checkbox_field'] ==  true ) {
	add_filter('upload_mimes', 'eccp_myme_types', 1, 1);
}

function eccp_myme_types( $mimes = array() ){
    
	$mimes['svg'] = 'image/svg+xml';
    /*$mimes['mon autre extension'] = 'mon autre Mime Type';*/
	
    return $mimes;
}


// Contrôle de l'import d'un SVG avec le hook wp_check_filetype_and_ext
// c'est ce hook qui autorise réellement l'import du SVG
// https://capitainewp.io/autoriser-svg-webp-wordpress/
// $file: chemin d'accès complet au fichier
// $filename: nom complet du fichier avec l'extension
// $mimes: mimes autorisés
// $types: tableau avec l'extension autorisé (svg) & le type de mime(image/svg+xml)
if ( $custom_back_office_settings['eccp_settings_activate_mime_types_media_checkbox_field'] ==  true ) {
	add_filter( 'wp_check_filetype_and_ext', 'eccp_allow_upload_file_types', 10, 4 );
}
function eccp_allow_upload_file_types( $types, $file, $filename, $mimes ) {
	
	if ( false !== strpos( $filename, '.svg' ) ) {
    	$types['ext'] = 'svg';
   		$types['type'] = 'image/svg+xml';
	}
	
	return $types;
}


/*
 On ajoute le type de fichier svg à la liste 
 des types de fichiers pour le filtre 
 de la médiathèque:
 images,son,vidéos,document etc..
 */
function eccp_display_filter_svg_in_library( $post_mime_types ) {
    
	// Ajout svg a la liste des types de fichiers 
	// pour le filtre de la médiathèque
    $new_types['image/svg+xml'][0] = 'svg';
	
	// On renseigne ici à quelle position notre type personnalisée svg 
	// doit apparaître sachant que l'index du tableau des mime/types
	// commence a 0 notre type SVG apparaitra en 3ème position
	$position = 2;
	
	// array_slice(array , position, longueur, ne pas réordonner les indices)
	// si longueur est null ou omis alors on retourne tout les éléments depuis 
	// la position offset jusqu'à la fin du tableau.
	$post_mime_types = array_slice( $post_mime_types, 0, $position, true ) + $new_types + array_slice( $post_mime_types, $position, null, true );

   return $post_mime_types;
   
}

if ( $custom_back_office_settings['eccp_settings_activate_mime_types_media_checkbox_field'] ==  true ) {
	add_filter( 'post_mime_types', 'eccp_display_filter_svg_in_library' );
}


/*-----Définir automatiquement le titre, le texte alternatif et la légende de l'image lors du téléchargement----*/

// si on a activé la définition du texte alternatif ou de la légende selon le titre de l'image 
if ($custom_back_office_settings['eccp_settings_image_alt_text_by_title_checkbox_field'] ||
    $custom_back_office_settings['eccp_settings_image_caption_according_title_checkbox_field']) {

	// Définir automatiquement le titre, le texte alternatif, la légende et éventuellement 
	// la description de l'image lors du téléchargement
	add_action( 'add_attachment', 'eccp_set_image_meta_on_image_upload' );

}

function eccp_set_image_meta_on_image_upload( $post_ID ) {

	// on récupère les paramètres de réglage du plugin
	$custom_back_office_settings = get_option( 'eccp_settings_custom_back_office' );

	// On vérifie si le fichier téléchargé est une image, sinon on ne fait rien
	if ( wp_attachment_is_image( $post_ID ) ) {

			$image_title = get_post( $post_ID )->post_title;

			// assainissement du titre avec une expression singulière: 
			// On supprime les traits d'union,les traits de soulignement et les espaces supplémentaires:
			$image_title = preg_replace( '%\s*[-_\s]+\s*%', ' ',  $image_title );

			// assainissement du titre:  mettre en majuscule la première lettre du titre
			// les autres lettres en minuscules (strtolower : Renvoie une chaîne en minuscules )
			// ucfirst met le 1er caractère en Majuscule, pour les 1ère lettre de chaque mot c'est la fonction ucwords
			$image_title = ucfirst( strtolower( $image_title ) );

			// si on a activé la définition de la légende selon le titre de l'image 
			if ($custom_back_office_settings['eccp_settings_image_caption_according_title_checkbox_field']) {
			
				// Tableau avec la méta de l'image (Titre, Légende, Description) 
				// Note: commentez les lignes post_excerpt/Légende ou post_content/Description si elles ne sont pas nécessaires
				$image_meta = array(
					'ID'        => $post_ID,            // on précise l'image (ID) à mettre à jour
					'post_title'    => $image_title,     // Définir le titre de l'image avec le titre assaini 
					'post_excerpt'  => $image_title,     // Définir la légende de l'image (excerpt) avec le titre assaini
					//'post_content'  => $image_title,     // Définir la description de l'image (content) avec le titre assaini 
				);
				
			}else {
				
				$image_meta = array(
					'ID'        => $post_ID,            // Spécifiez l'image (ID) à mettre à jour
					'post_title'    => $image_title,     // Définir le titre de l'image avec la sanitization du titre 
					//'post_excerpt'  => $image_title,     // Définir la légende de l'image (excerpt) avec la sanitization du titre 
					//'post_content'  => $image_title,     // Définir la description de l'image (content) avec la sanitization du titre 
				);
				
			}

			// Si on a activé la définition du texte alternatif selon le titre assaini de l'image
			if ($custom_back_office_settings['eccp_settings_image_alt_text_by_title_checkbox_field']) {
				// Définit le texte alternatif de l'image
				update_post_meta( $post_ID, '_wp_attachment_image_alt', $image_title );
			}
			
			// Définit la méta de l'image (par exemple, titre, description, légende)
			wp_update_post( $image_meta );

	} 
	
}


/*------------------  COMPTES UTILISATEURS -------------------*/


/*------------------ Ajout d'une colonne pour afficher la date d'enregistrement utilisateur -------------------*/

//Étape 1. Ajouter une colonne sur la page Tous les comptes

if ( $custom_back_office_settings['eccp_settings_activate_users_registration_date_column_checkbox_field'] ==  true ) {
	add_filter( 'manage_users_columns', 'eccp_add_registration_date_column' );
}

function eccp_add_registration_date_column( $columns ) {

	$columns['registration_date'] = __('Registration Date','editor-custom-color-palette'); // ID de la colonne ==> Titre de la colonne
	return $columns;
	
}


//Étape 2. Afficher la date d'enregistrement sur la page Tous les comptes

if ( $custom_back_office_settings['eccp_settings_activate_users_registration_date_column_checkbox_field'] ==  true ) {
	add_action( 'manage_users_custom_column', 'eccp_add_registration_date_users', 10, 3 );
}

function eccp_add_registration_date_users( $output, $column_id, $user_id ){

	if( $column_id == 'registration_date' ) {

		// date au format Français
		$date_format = 'd/m/Y H:i';
		
		// get_the_author_meta() récupère les données de l'utilisateur
		// 1er argument: paramètre a récupérer: user_registered date d'enregistrement
		// 2ème argument: id de l'utilisateur	  
		// la dat rencvoyé est une chaine au format 2020-05-03 13:42:39
		// strtotime convertit la chaine au format timestamp utilisable b par la fonction date()
		$output = date( $date_format, strtotime( get_the_author_meta( 'user_registered', $user_id ) ) );
 
	}

	return $output;
	
}


//Étape 3. Enregistre la colonne Registration Date comme triable 

function eccp_modified_column_users_registration_date_sortable( $columns ) {
	
	$columns['registration_date'] = __('Registration Date','editor-custom-color-palette');
			
    return $columns;
}

if ( $custom_back_office_settings['eccp_settings_activate_users_registration_date_column_checkbox_field'] ==  true ) {
	add_filter( 'manage_users_sortable_columns', 'eccp_modified_column_users_registration_date_sortable' , 10, 1 );
}




/*------------------ Ajout d'une colonne pour afficher la date de dernière connexion -------------------*/

//Étape 1. Stockez l'horodatage de la dernière connexion dans la méta de l'utilisateur

if ( $custom_back_office_settings['eccp_settings_activate_users_last_login_column_checkbox_field'] ==  true ) {
	add_action( 'wp_login', 'eccpt_collect_login_timestamp', 20, 2 );
}

function eccpt_collect_login_timestamp( $user_login, $user ) {

	update_user_meta( $user->ID, 'last_login', time() );

}



//Étape 2. Ajouter une colonne sur la page Tous les comptes

if ( $custom_back_office_settings['eccp_settings_activate_users_last_login_column_checkbox_field'] ==  true ) {
	add_filter( 'manage_users_columns', 'eccp_add_last_login_column' );
}

function eccp_add_last_login_column( $columns ) {

	$columns['last_login'] = __('Last Login','editor-custom-color-palette'); // ID de la colonne ==> Titre de la colonne
	return $columns;
	
}

//Étape 3. Afficher la date de dernière connexion sur la page Tous les comptes

if ( $custom_back_office_settings['eccp_settings_activate_users_last_login_column_checkbox_field'] ==  true ) {
	add_action( 'manage_users_custom_column', 'eccp_add_last_login_users', 10, 3 );
}

function eccp_add_last_login_users( $output, $column_id, $user_id ){

	if( $column_id == 'last_login' ) {

		$last_login = get_user_meta( $user_id, 'last_login', true );
		
		// date au format Français
		$date_format = 'd/m/Y H:i';
		
		// ancien code
		//$output =  $last_login ? date($date_format, $last_login): '-';
		
		// s'il y a une date de dernière connexion alors on affiche dans une div:
		// la date de dernière connexion au format français		  
		// Au survol grace a l'attribut title de la div 
		// Le temps écoulé depuis la date actuelle par rapport à la date de dernière connexion
		// ce temps est calculé avec la fonction WordPress human_time_diff()
		// Sinon on affiche un tiret: '-'
		$output = $last_login ? '<div title="'.__('Last Login','editor-custom-color-palette').': '.human_time_diff( $last_login ).'">'.date( $date_format, $last_login ).'</div>' : '-';
 
		
	}

	return $output;
	
}


//Étape 4. Enregistre la colonne Last Login comme triable 

function eccp_modified_column_users_register_sortable( $columns ) {
	
	$columns['last_login'] = __('Last Login','editor-custom-color-palette');
			
    return $columns;
}

if ( $custom_back_office_settings['eccp_settings_activate_users_last_login_column_checkbox_field'] ==  true ) {
	add_filter( 'manage_users_sortable_columns', 'eccp_modified_column_users_register_sortable' , 10, 1 );
}

/*------------------ Autoriser les contributeurs a télécharger des médias dans la médiathèque -------------------*/

/*
Un contributeur peut uniquement ajouter, éditer et supprimer ses propres articles 
qui seront soumis à la validation d’un administrateur ou d’un éditeur. 
De plus, il lui est impossible de télécharger des médias.
c'est handicapant car les images offrent une plus value aux articles

Avant d’exécuter la fonction qui ajoutera la capacité de téléchargement
a tous les contributeurs,on vérifie si le membre a le rôle de contributeur 
et s’il n’a pas le droit de télécharger des médias.

Le contributeur aura alors le droit de télécharger les images y compris
l'image en avant. il pourra supprimer ses images téléchargées
mais pas celle d'autres utilisateurs qui ne pourra que simplement
consulter.
*/

/*
la fonction utilisé current_user_can() génére une erreur:
Call to undefined function wp_get_current_user()
cela se produit parce que le fichier /wp-includes/pluggable 
qui contient la fonction n'est chargé qu'après le chargement des plugins.
Pour y palier ajout du code ci-dessous
*/
if(!function_exists('wp_get_current_user')) {
    include_once(ABSPATH . 'wp-includes/pluggable.php');
}


// si on autorisé le téléchargement de médias pour les contributeurs
// et si l'utilisateur actuel est un contributeur et qu'il n'a pas la capabilité:upload_files
if ( current_user_can('contributor') && !current_user_can('upload_files')
     && $custom_back_office_settings['eccp_settings_allow_contributors_upload_media_checkbox_field']){

	add_action('admin_init', 'eccp_allow_contributor_uploads');

// sinon si l'utilisateur actuel est un contributeur
// et qu'on n'a pas autorisé le téléchargement de médias pour les contributeurs 	
}else if(current_user_can('contributor') && !$custom_back_office_settings['eccp_settings_allow_contributors_upload_media_checkbox_field'] ){

	add_action('admin_init', 'eccp_remove_contributor_uploads');
}

function eccp_allow_contributor_uploads() {
	$contributor = get_role('contributor');
	$contributor->add_cap('upload_files');
}

function eccp_remove_contributor_uploads() {
	$contributor = get_role('contributor');
	$contributor->remove_cap('upload_files');
}
	

/*------------------  MODIFICATION DE LA PAGE CONNEXION WORDPRESS: LOGO & LIEN & MESSAGE D'ERREUR & SÉLECTEUR DE LANGUE -------------------*/

/* Désactiver le sélecteur de langues */
if ( $custom_back_office_settings['eccp_settings_disable_language_selector_checkbox_field'] ==  true ) {
	add_filter('login_display_language_dropdown', '__return_false');
}

/* Afficher un message d'erreur personnalisé à vos utilisateurs */ 

 // lorsque les utilisateurs saisissent des informations d'identification incorrectes 
 // Si on ne désactive pas les erreurs que WordPress affiche sur notre page de connexion, 
 // on sait d'aprés le message d'erreur si notre login ou mot de passe est erronée.
 // cela permet aux pirate de renifler les noms d'utilisateur qui sont utilisés sur le site Web. 
 // Ils peuvent ensuite utiliser ces informations pour forcer brutalement les mots de passe.

function eccp_custom_login_error_message(){
	
	// récupération des paramètres du plugin
	$custom_back_office_settings = get_option( 'eccp_settings_custom_back_office' );
	
	$msg = $custom_back_office_settings['eccp_error_login_custom_message_textarea_field'];
	return $msg;
}

 if ( !empty($custom_back_office_settings['eccp_error_login_custom_message_textarea_field']) ) {
	add_filter( 'login_errors', 'eccp_custom_login_error_message' );
 }
 
 
 /* Désactiver la demande de vérification de l’adresse e-mail administrateur */ 
 
// Une fois ce code ajouté, il désactivera complètement la page de demande de vérification 
// de l’adresse e-mail lors de la connexion à /wp-admin.

if ( $custom_back_office_settings['eccp_settings_disable_admin_email_request_checkbox_field'] ==  true ) {
	add_filter( 'admin_email_check_interval', '__return_false' );
}


// Changer l'URL du logo de la page de connexion afin qu'elle pointe vers la page d'accueil du site
function eccp_my_login_logo_url() {
	return home_url();
}
add_filter( 'login_headerurl', 'eccp_my_login_logo_url' );


// Texte a afficher lors du survol du Logo
function eccp_my_login_logo_url_title($login_header_text) {
	$login_header_text = 'Rock 4 Temps';
	return $login_header_text;
}
//add_filter( 'login_headertext', 'eccp_my_login_logo_url_title' );

/* Personnalisation Style Formulaire de connexion  */
function eccp_wpm_login_style() { 

$custom_back_office_settings = get_option( 'eccp_settings_custom_back_office' );

	?>
    <style id="editor-custom-color-palette" type="text/css">
	<?php
	
		// Si on activé la personnalisation du Logo
		if ( $custom_back_office_settings['eccp_settings_activate_custom_logo_checkbox_field'] ==  true ) {
			
			/*-------- Logo personnalisé du formulaire de connexion -------------*/
			
			// si le champ URL n'est pas vide et si ce n'est pas l'URL de l'image par défaut "L'Homme Mystère"
			// et si c'est une URL d'une image contenu dans le dossier uploads de WordPress
			if ( (!empty($custom_back_office_settings['eccp_settings_custom_logo_url_text_field']) ) &&
			    ( $custom_back_office_settings['eccp_settings_custom_logo_url_text_field'] !==  EDITOR_CUSTOM_COLOR_PALETTE_URL.'img/custom-gutenberg-block/eccp-mystery-gravatar.jpg') &&
				(false !== strpos( $custom_back_office_settings['eccp_settings_custom_logo_url_text_field'], site_url().'/wp-content/uploads/' )) ) {
				
				
				echo'#login h1 a, .login h1 a {';
					echo'background-image: url('.esc_url($custom_back_office_settings['eccp_settings_custom_logo_url_text_field']).' )!important;';
					echo'background-size:'.$custom_back_office_settings['eccp_settings_custom_logo_width_text_field'].'px!important;';
					echo'height:'.$custom_back_office_settings['eccp_settings_custom_logo_height_text_field'].'px!important;';
					echo'width:'.$custom_back_office_settings['eccp_settings_custom_logo_width_text_field'].'px!important;';
				echo'}';
			
			}
			
		}
	
		/*-------- Personnalisation formulaire de connexion -------------*/
		
		// Si on activé la personnalisation du formulaire de connexion
		if ( $custom_back_office_settings['eccp_settings_activate_custom_login_form_radio_field'] ==  'yes' ) {
			
			/* couleur d'arrière plan de la page du formulaire de connexion */
			echo'body.login {';
				echo'background:'.$custom_back_office_settings['eccp_settings_page_login_form_background_color_text_field'].';';
			echo'}';
			
			/* couleur du texte en pied de la page du formulaire de connexion */
			echo'body.login #backtoblog a, body.login #nav a,
				 .login  a.privacy-policy-link {';
				echo'color:'.$custom_back_office_settings['eccp_settings_page_login_form_footer_text_color_text_field'].'!important;';
				echo'font-weight:500;';
			echo'}';
			
			/* formulaire de connexion */
			echo'.login #loginform {';
				echo'border-radius : 20px;';
				echo'box-shadow: 0px 0px 4px 1px rgba(0,0,0,0.2);';
				echo'-webkit-box-shadow: 0px 0px 4px 1px rgba(0,0,0,0.2);';
				echo'background:'.$custom_back_office_settings['eccp_settings_login_form_background_color_text_field'].';';
			echo'}';
			
			/* couleur des textes dans le formulaire */
			echo'.login h1 a, #login label {';
				echo'color:'.$custom_back_office_settings['eccp_settings_login_form_text_color_text_field'].'!important;';
			echo'}';
				
			/* Bouton de soumission du formulaire */
			echo'body.login #loginform input[type="submit"] {';
				echo'background:'.$custom_back_office_settings['eccp_settings_button_login_form_background_color_text_field'].';';
				echo'border-color:'.$custom_back_office_settings['eccp_settings_button_login_form_border_color_text_field'].';';
				echo'border-width:2px;';
				echo'border-radius: 6px;';
				echo'text-transform:uppercase;';
				echo'color:'.$custom_back_office_settings['eccp_settings_button_login_form_text_color_text_field'].';';			
				echo'font-weight: 500;';
			echo'}';
			
			/* Bouton de soumission du formulaire au survol */
			echo'body.login #loginform input[type="submit"]:hover {'; 
				echo'background:'.$custom_back_office_settings['eccp_settings_hover_button_login_form_background_color_text_field'].';';
				echo'border-color:'.$custom_back_office_settings['eccp_settings_hover_button_login_form_border_color_text_field'].'!important;';
				echo'border-width:2px;';
				echo'color:'.$custom_back_office_settings['eccp_settings_hover_button_login_form_text_color_text_field'].';';	
				echo'font-weight: 500;';
				echo'padding:0 12px!important;';
				echo'outline:none;';
			echo'}';
			
			/* Bouton de soumission du formulaire actif */
			echo'body.login #loginform input[type="submit"]:focus {'; 
				/* on supprime un contour bleu ammené par une régle box-shadow 
				   lorsque le bouton est actif */
				echo'box-shadow: none;';
			echo'}';
			
			/* oeil visibilité password
			   de la même couleur que celle des boutons 
			   pour garder la cohérence du style original du formulaire*/
			echo'body.login #loginform button.wp-hide-pw span:before{';
				echo'color:'.$custom_back_office_settings['eccp_settings_button_login_form_border_color_text_field'].';';
			echo'}';
			
			/* champ texte login & Password & checkbox
			   bordure de la même couleur que celle des boutons 
			   pour garder la cohérence du style original du formulaire*/
			echo'body.login #loginform input[type="text"],
			     body.login #loginform input[type="password"],
				 body.login #loginform input[type="checkbox"]{';
				echo'border: 1px solid '.$custom_back_office_settings['eccp_settings_button_login_form_border_color_text_field'].';';
			echo'}';
			
			/* champ texte login & Password & checkbox qui ont le focus
			   bordure de la même couleur que celle des boutons 
			   et épaisseur de la bordure doublé
			   pour garder la cohérence du style original du formulaire*/
			echo'body.login #loginform input[type="text"]:focus,
			     body.login #loginform input[type="password"]:focus ,
				 body.login #loginform input[type="checkbox"]:focus{';
				 
				echo'border: 2px solid '.$custom_back_office_settings['eccp_settings_button_login_form_border_color_text_field'].';';
				/* on supprime un contour bleu ammené par une régle box-shadow 
				   lorsque le champ input est actif */
				echo'box-shadow: none;';
				
			echo'}';
			
			
			/* Messsage & message de succés */
			echo'body.login .message, body.login .success {';
				echo'background:'.$custom_back_office_settings['eccp_settings_info_notice_login_form_background_color_text_field'].'!important;';
				echo'border-left: 4px solid '.$custom_back_office_settings['eccp_settings_info_notice_login_form_border_color_text_field'].'!important;';
				echo'color:'.$custom_back_office_settings['eccp_settings_info_notice_login_form_text_color_text_field'].'!important;';
				echo'font-weight: 500;';
			echo'}';
			
			
			/* Messsage erreur */ 
			echo'body.login #login_error {';
				echo'background:'.$custom_back_office_settings['eccp_settings_error_notice_login_form_background_color_text_field'].'!important;';
				echo'border-left: 4px solid '.$custom_back_office_settings['eccp_settings_error_notice_login_form_border_color_text_field'].'!important;';
				echo'color:'.$custom_back_office_settings['eccp_settings_error_notice_login_form_text_color_text_field'].'!important;';
				echo'font-weight: 500;';
			echo'}';
				
			
			/* ajout d'un fond pour les textes hors du formulaires 
			.login #backtoblog a, .login #nav a{
			background-color:#EAE672;
			padding: 3px 8px;
			border-radius:5px;
			}*/
			
			
			/* Aligner les textes hors du formulaires 
			.login #nav, .login #backtoblog {text-align: center;}*/
			
		}
		
		
		// Si on activé une image de fond
		if (  $custom_back_office_settings['eccp_settings_activate_image_background_login_page_radio_field'] ==  'yes' ) {
			
			/*-------- Image de fond Personnalisé pour la page de connexion -------------*/
			
			// si le champ URL n'est pas vide et si ce n'est pas l'URL de l'image par défaut "L'Homme Mystère"
			// et si c'est une URL d'une image contenu dans le dossier uploads de WordPress
			if ( (!empty($custom_back_office_settings['eccp_settings_custom_image_background_url_text_field']) ) &&
			    ( $custom_back_office_settings['eccp_settings_custom_image_background_url_text_field'] !==  EDITOR_CUSTOM_COLOR_PALETTE_URL.'img/custom-gutenberg-block/eccp-mystery-gravatar.jpg') &&
				(false !== strpos( $custom_back_office_settings['eccp_settings_custom_image_background_url_text_field'], site_url().'/wp-content/uploads/' )) ) {
				
				echo'body.login {';
					echo'background-image: url('.esc_url($custom_back_office_settings['eccp_settings_custom_image_background_url_text_field']).' )!important;';
					echo'background-size: cover;';
					echo'background-repeat: no-repeat;';
					echo'background-position: center center;';
				echo'}';
				
				// si on a activé une image de fond fixe
				if ($custom_back_office_settings['eccp_settings_custom_image_background_url_text_field']){
					echo'body.login {';
						echo'background-attachment: fixed;';
					echo'}';
					
				}
				
			}
			
		}
				
    ?>
	</style>
	<?php
	
}
add_action( 'login_enqueue_scripts', 'eccp_wpm_login_style' );


/*------------------  EMAIL WORDPRESS PAR DÉFAUT  -------------------*/

      
/* Modification du nom de l'expéditeur et de l'adresse e-mail WordPress Par défaut */

/*
Généralement, WordPress envoie tous les e-mails en utilisant "WordPress" 
comme nom d'expéditeur et "wordpress@nomdedomaine.fr comme adresse d'expéditeur, 
ce qui convient parfaitement aux notifications d'administration, 
mais pas à tous les types d'e-mails destinés à vos utilisateurs.
Par ailleurs modifier l'adresse e-mail Wordpress par défaut évitera que 
des filtres anti-spam bloquent vos e-mails WordPress les considérant comme indésirables.
*/

if ( $custom_back_office_settings['eccp_settings_enable_change_email_sender_default_checkbox_field'] ) {

	// ADRESSE DE L'EXPÉDITEUR DE L'EMAIL
	function eccp_change_default_sender_email($original_email_address) {
		
		// on récupère les paramètres de réglages de l'extension
		$custom_back_office_settings = get_option( 'eccp_settings_custom_back_office' );
		
		return $custom_back_office_settings['eccp_settings_email_sender_address_text_field'];
	}
	add_filter('wp_mail_from', 'eccp_change_default_sender_email');


	//NOM DE L'EXPÉDITEUR DE L'E-MAIL
	function eccp_change_default_sender_name($original_email_from) {
		
		// on récupère les paramètres de réglages de l'extension
		$custom_back_office_settings = get_option( 'eccp_settings_custom_back_office' );
		
		return $custom_back_office_settings['eccp_settings_email_sender_name_text_field'];
	}
	add_filter('wp_mail_from_name', 'eccp_change_default_sender_name');

}


/* Eviter que les mails de notification WordPress soit considéré comme des spams */


/* 
WordPress utilise la fonction wp_mail()de PHP pour l'envoi d'E-mail sans préciser d'en tête.
On utilise le hook 'phpmailer_init' pour que «l'expéditeur» (chemin de retour) soit le même que l'adresse «De»
c'est a dire : contact@rock-4-temps.fr.
Le chemin de retour indique où les accusés de non-remise - ou les messages refusés - doivent être envoyé
*/
if ( $custom_back_office_settings['eccp_settings_enable_return_adress_correspond_from_adress_checkbox_field'] ) {
	add_action( 'phpmailer_init', 'eccp_fix_my_email_return_path' );
}
 
function eccp_fix_my_email_return_path( $phpmailer ) {
	// $phpmailer->From donne l'adresse de l'expéditeur
	// $phpmailer->Sender adresse de retour 
    $phpmailer->Sender = $phpmailer->From;
}


/*------------------  TABLEAU DE BORD -------------------*/

/*------- Ajout dans le widget "d'un coup d'oeil" du tableau de bord du nombre de block réutilisable------ */

// Ajout dans le widget "d'un coup d'oeil" du tableau de bord
// du nombre de bloc réutilisable sous forme de lien vers
// l'écran qui liste les bloc réutilisables 
function eccp_add_reusables_number_to_dashboard( $items = array() ) {
 
	$num_posts = wp_count_posts( 'wp_block' );
	
	if( $num_posts ) {
	   
			// nombre de bloc réutilisable avec le statut publié
			$number_reusable_block = intval( $num_posts->publish );
			
			// on récupère l'objet des blocs réutilisables le CPT: wp_block
			//dont le nom au singulier est: Bloc réutilisable
			//le nom au pluriel est: Bloc réutilisables		
			$post_type = get_post_type_object( 'wp_block' );
			
			// _n() Traduit et récupère la forme singulière ou plurielle en fonction du nombre fourni.
			$label_link = _n( '%s ' . $post_type->labels->singular_name, '%s ' . $post_type->labels->name, $number_reusable_block );
			$label_link = sprintf( $label_link, number_format_i18n( $number_reusable_block ) );
					 
			// on donne l'accès a l'écran des blocs réutilisables
			// qu'aux utilisateurs qui ont la capacité d'édition
			if ( current_user_can( $post_type->cap->edit_posts ) ) {
					$items[] = sprintf( '<a class="wp_block-count" href="edit.php?post_type=wp_block">%s</a>', $label_link ) . "\n";
			} else {
					$items[] = sprintf( '<span class="wp_block-count">%s</span>', $label_link ) . "\n";
			}
	}
	
	return $items;
}

add_filter( 'dashboard_glance_items', 'eccp_add_reusables_number_to_dashboard', 10, 1 );



/*------ Ajout dans le widget "d'un coup d'oeil" du tableau de bord du nombre d'utilisateur-------- */

// Ajout dans le widget "d'un coup doeil" du tableau de bord
// du nombre d'utilisateur sous forme de liens vers
// l'écran qui liste les comptes utilisateurs 
/*
On utilise la fonction WordPress  count_users() qui retourne
un tableau a deux dimensions avec les clés:
total_users: Nombre total d'utilisateurs sur le site (int)
avail_roles[]: tableau d'entier avec role utilisateur & nbr par rôle

Array
(
    [total_users] => 1
    [avail_roles] => Array
        (
            [administrator] => 1
            [none] => 0
        )

)

*/


/*------ Ajout dans le widget "d'un coup d'oeil" du tableau de bord du nombre d'utilisateur -------- */

function eccp_add_user_count_to_dashboard( $items = array() ) {
 
	$user_count = count_users();
	
	// Nombre d'utilisateur
	$users_number = $user_count["total_users"];
	
	global $current_user;
	
	// on récupère le rôle de l'utilisateur connecté
    $current_user_role = array_shift($current_user->roles);
	
	
	if( $users_number ) {
	   
			$label_link = _n( '%s ' . 'Utilisateur', '%s ' . 'Utilisateurs', $users_number );
			$label_link = sprintf( $label_link, number_format_i18n( $users_number) );
					 
			// on donne l'accès a l'écran des comptes utilisateurs
			// qu'aux utilisateurs qui ont la capacité d'édition
			if ( ( $current_user_role == 'administrator') || ( $current_user_role == 'editor') ) {
					$items[] = sprintf( '<a class="user-count" href="users.php">%s</a>', $label_link ) . "\n";
			} else {
					$items[] = sprintf( '<span class="user-count">%s</span>', $label_link ) . "\n";
			}
	}
	
	return $items;
}

add_filter( 'dashboard_glance_items', 'eccp_add_user_count_to_dashboard', 10, 1 );



/*------ Ajout dans le widget "d'un coup d'oeil" du tableau de bord du nombre pour les différents CPT -------- */

function eccp_add_custom_post_type_number_to_dashboard( $items = array() ) {
	
	// post type ayant un slug, publicly_queryable, mais qui ne sont pas des CPT utilisateurs
	$exclude_post_type = array('elementor_library','seedprod',
								'e-landing-page','/boutique',
								'product','produit','elementor-hf',
								'oceanwp_library','nf_sub',
							   );
							   
	/*On passe en argument:
	• le paramètre _builtin du post-type qui doit être vide (false), 
	ce qui est le cas pour un type de publication personnalisée contrairement au 
	type de publication par défaut page pour lequel [_builtin] => 1  
	• de même il faut que l'argument publicly_queryable vaut true c'est a dire 
	qu'on autorise la publication du CPT en Front End. 
	En effet certains CPT comme:
	[tribe_organizer] => organisateur , 
	[tribe_venue] => lieu du plugin The Events Calendar
	n'ont pas d'affichage en Front End, et ne sont que des CPT crée pour l'admin du site, 
	cela permet donc de filtrer.*/						   
    $args = array(
        'publicly_queryable' => true,
        '_builtin' => false
    );
	
    $output = 'objects';
    $operator = 'and';
	
	// on récupère le type de publications personnalisées
    $post_types = get_post_types($args , $output , $operator);
	
	
	if( !empty($post_types) ) {
	
		foreach($post_types as $post_type) {
			
			//pour debug
			//echo 'Nom Post_type: '.$post_type->name.'<br>';
			
			// nombre du type de publication personnalisé
			// on récupère un objet 
			// le nombre de CPT publié est donné par $num_posts->publish
			$num_posts = wp_count_posts($post_type->name);
			
			
			// si c'est un type de publication personnalisé autorisé
			if ( !in_array($post_type->name,$exclude_post_type) ){
				
				// pour le type de publication personnalisé ayant le statut publié
				// converti le nombre pour la langue en cours
				$cpt_number = number_format_i18n($num_posts->publish);
				
				// Traduit et récupère la forme singulière ou plurielle du type de publication personnalisé
				// en fonction du nombre fourni par intval($num_posts->publish)
				$label_link = _n('%s ' . $post_type->labels->name, '%s ' . $post_type->labels->name , intval($num_posts->publish));
				
				$label_link = sprintf( $label_link, $cpt_number );
				
				// slug du CPT
				$cpt_name = $post_type->name;
			
				// on donne l'accès a l'écran des CPT
				// qu'aux utilisateurs qui ont la capacité d'édition
				if (current_user_can('edit_posts')) {
					$items[] = sprintf( '<a class="'.$cpt_name.'" href="edit.php?post_type='.$cpt_name.'">%s</a>', $label_link ) . "\n";
				} else {
					$items[] = sprintf( '<span class="'.$cpt_name.'">%s</span>', $label_link ) . "\n";
				}
			
			}
			
		}
	
	}
	
	return $items;
	
}

add_action('dashboard_glance_items', 'eccp_add_custom_post_type_number_to_dashboard');




/*------------------  AUTRES PERSONNALISATION DE L'ADMIN WORDPRESS -------------------*/


/* Désactiver le sitemap de WordPress par défaut */

// l'url du sitemap WordPress est http://monsite/wp-sitemap.xml

if ( $custom_back_office_settings['eccp_settings_disable_default_wordpress_sitemap_checkbox_field'] ==  true ) {
	add_filter( 'wp_sitemaps_enabled', '__return_false' );
}



/*  Activer Lien Connexion/déconnexion Admin WordPress en Local ou en Ligne */

add_filter('wp_nav_menu_items', 'eccp_add_login_logout_link', 10, 2);

// on utilise le hook wp_nav_menu_items qui permet de filtrer la liste
// des items de menu
// Les paramètres de la fonction eccp_add_login_logout_link associé au hooks sont:
// $items: le contenu de la liste HTML pour les items de menu
// $args:  un objet contenant les arguments de wp_nav_menu()
// par exemple $args->menu->term_id donne 2  pour un menu d'ID = 2

// la structure d'une liste HTML pour un item de menu étant
// <li>
//		<a> href="http://localhost/rouerguecreation/contact/" 
//      <span>Contact</span>
//      </a>
// </li>

// Ajout de la classe eccp-loginout aux liens de Connexion/Déconnexion pour notamment
// modifier via css l'offset vers le Haut des icônes Dashicon qu'engendre 
// la classe dashicons
// .eccp-loginout span.dashicons{line-height:inherit!important;}
function eccp_add_login_logout_link($items, $args){
	
	//On récupère les paramètres du plugin
	$custom_back_office_settings = get_option( 'eccp_settings_custom_back_office' );
	
	// On récupère le slug de l'URL de connexion a l'admin
	$slug = $custom_back_office_settings['eccp_settings_slug_admin_login_url_text_field'];
	
	//adresse ipv4 local host = 127.0.01 , adresse ipv6 local host = ::1
	$is_localhost = ($_SERVER['REMOTE_ADDR'] == "127.0.0.1" or $_SERVER['REMOTE_ADDR'] == "::1");
  
	// on affecte la liste HTML des items de menu
	$newitems = $items;

	/*Pour debug 
	echo'<pre>';
		print_r($args);
	echo'</pre>';
	*/
	
	$location = array();
	
	/* On récupère tous les emplacements de menu de navigation enregistrés
	   et les ID de menu qui leur sont attribués.
	   le résultat est un tableau associatif avec pour clé l'emplacement
	   de menu de navigation donné aussi par $args->theme_location
	   Exemple de retour de la fonction get_nav_menu_locations()
		Array(
			[main_menu] => 2
			[footer_menu] => 36
		)
	*/
	$location = get_nav_menu_locations();
	
	/* Pour debug 
	echo'<pre>';
		print_r($location);
	echo'</pre>';
	*/
	
	If ( !empty($location) ){
		
		// on considère que la 1ère clé enregistrée 
		// correspond a l'emplacement du menu principal pour l'en-tête
		$theme_location = array_key_first($location);
	
	// sinon on initialise le tableau a une chaine vide
	// pour traiter le cas du thème Blocksy
	// qui n'a pas d'enregistrement pour l'emplacement de menu
	}else {
		$theme_location ='';
	}
	
     // ancien code
    //$theme_location = array("", "primary", "main_menu", "primary-menu");	
	//if ( in_array($args->theme_location,$theme_location) ) {
	
	// on ajoute le lien de Connexion/déconnexion 
	// que pour le menu principal de navigation dans l'en-tête
	// theme_location est une clé du tableau $args
	// theme_location == 'primary' pour Astra & GeneratePress
	// theme_location == 'primary-menu' pour Divi
	// theme_location == 'main_menu' pour oceanWp
	// theme_location == '' pour Blocksy
	// si on veut aussi le pied de page: theme_location == 'footer' 
	// ou theme_location == 'footer_menu' ou theme_location == 'footer-menu'
	if ( $args->theme_location == $theme_location ) {
  
		// Vérifie si le visiteur actuel est un utilisateur connecté
		if (!empty(is_user_logged_in()) ) {

			// si on est en Local et que l'on a activé l'option item de menu Connexion/Déconnexion en local 
			// ou
			// si on est en Ligne et que l'on a activé l'option item de menu Connexion/Déconnexion en ligne
			if ( ($is_localhost && $custom_back_office_settings['eccp_settings_activate_local_site_admin_login_loginout_link_checkbox_field']) ||
				 (!$is_localhost && $custom_back_office_settings['eccp_settings_activate_online_site_admin_login_loginout_link_checkbox_field'])) {
				// on concaténe le lien de déconnexion avec la liste HTML des items de menu
				// on se déconnecte avec la fonction WordPress wp_logout_url en restant sur 
				// la page en cours dont l'URL est donnée par la fonction get_permalink()
				// pour la balise <span> de l'élément de menu on remplace l'item de menu
				// par une icône dashicon migrate
				$newitems .= '<li>
									<a class="eccp-loginout" title="'.esc_html__( 'Logout', 'editor-custom-color-palette' ).'" href="'. esc_url(wp_logout_url(get_permalink())) .'">
										<span  class="dashicons dashicons-migrate"></span>
									</a>
							  </li>';
			
			}
		
		// sinon l'utilisateur n'est pas connecté
		}else{
		  
			// si on est en Local et que l'on a activé l'option item de menu Connexion/Déconnexion en local
			if ($is_localhost && $custom_back_office_settings['eccp_settings_activate_local_site_admin_login_loginout_link_checkbox_field']) {
			
				// on concaténe le lien de déconnexion avec la liste HTML des items de menu 
				// dont l'URL est donnée  par la fonction wp_login_url() qui renvoi: http://monsite.fr/wp-login.php
				// au lieu d'un texte pour la balise <span> de l'élément de menu on a 
				// un icône dashicon Users
				$newitems .= '<li>
									<a class="eccp-loginout" title="'.esc_html__( 'Login', 'editor-custom-color-palette' ).'" href="'. esc_url(wp_login_url()) .'">
										<span class="dashicons dashicons-admin-users"></span>
									</a>
							  </li>';
			
			}
			
			// si on est en Ligne et que l'on a activé l'option item de menu Connexion/Déconnexion en ligne
			if (!$is_localhost && $custom_back_office_settings['eccp_settings_activate_online_site_admin_login_loginout_link_checkbox_field']) {
		
				// pour une URL de connexion en ligne avec un slug qui peut être changé par exemple
				// avec une extension comme Itheme Security:
				// on fournit a la fonction home_url() un paramètre de chemin relatif qui est :/slug ajouté
				// a l'URL de la page d'accueil: https://your-domain
				// au lieu d'un texte pour la balise <span> de l'élément de menu on a 
				// un icône dashicon admin-users
				$newitems .= '<li>
									<a class="eccp-loginout" title="'.esc_html__( 'Login', 'editor-custom-color-palette' ).'" href="'. esc_url(home_url('/'.$slug)) .'">
										<span class="dashicons dashicons-admin-users"></span>
									</a>
							  </li>';
			
			}
			
		}
		
	}	

	return $newitems;
  
}
	
	
add_action( 'wp_head','ecpp_style_login_logout_link',1 );

// style pour l'icone Dashicon du lien de connexion/déconnexion
// a l'admin de WordPress
function ecpp_style_login_logout_link() {
	
	// on récupère le thème actif
	$my_theme = wp_get_theme();
	
	echo '<style type="text/css" id="login-logout-link">';
		
		echo' .eccp-loginout span.dashicons{';
			echo'line-height:inherit!important;';
			echo'margin-right:1em;';
		echo'}';
		
		// pour le thème Astra on corrige la position de l'icône
		if(stristr($my_theme, 'astra')) {
			
			echo' .eccp-loginout span.dashicons{';
				echo'position: relative;';
				echo'top: 18px;';
			echo'}';
		
		}
	
	echo '</style>';
	
}


/*----------------------------------------------------------------------------------------
		CSS DYNAMIQUE POUR PERSONNALISER LES ÉCRANS D'ADMINISTRATION DE WORDPRESS
/*---------------------------------------------------------------------------------------*/

function eccp_custom_screen_admin_styling() {
	
// récupération des paramètres du plugin
$custom_back_office_settings = get_option( 'eccp_settings_custom_back_office' );
	

echo '<style id="editor-custom-color-palette" type="text/css">';

	
	/* -------- Écran de publication page & articles & CPT: colonne image en avant --------*/
	
	// Largeur de la colonne image mise en avant
	echo 'body.wp-admin th#featured_image{';
		echo'width:'.$custom_back_office_settings['eccp_settings_width_thumbnail_featured_image_text_field'].'px;';
		echo'height: auto;';
	echo'}';
	
	// taille de l'image mise en avant
	echo 'td.featured_image.column-featured_image img{';
		echo'width:'.$custom_back_office_settings['eccp_settings_width_thumbnail_featured_image_text_field'].'px;';
		echo'height: auto;';
	echo'}';
	
	
	/* ----- Style Modification Rapide Articles & Pages & CPT pour l'édition de l'image mise en avant ---*/
	
	// taille de l'image en avant
	echo'#wpbody-content #featured_image .upload-img img{';
		echo'width:'.$custom_back_office_settings['eccp_settings_width_thumbnail_featured_image_text_field'].'px;';
		echo'height: auto;';
	echo'}';
	
	
	/* ----- Suppression Notification Sur La Page De Réglage Du Plugin ---*/
    if (isset($_GET['page']) && $_GET['page'] == 'eccp_settings_page') {
		echo'.e-notice{display:none};';
	}
	
echo '</style>';

}
add_action('admin_head', 'eccp_custom_screen_admin_styling');


/***********************************************************************************************
                           PERSONNALISER INTERFACE PUBLIQUE          
***********************************************************************************************/

/*------------ Bouton Retour Vers Le Haut interface publique  ---------*/

// Le script JS pour animer le défilemment vers le haut
// est le même que celui utiliser pour l'admin soit: eccp-scroll-to-top.js
// cache le bouton retour vers le haut en position haute < 1500
// apparition du bouton retour vers le haut avec un fading pour une position > 1500
// permet un défilement fluide vers le haut

if ( $custom_front_end_settings['eccp_settings_enable_back_to_top_button_checkbox_field'] ) {
	//Création du lien pour le bouton retour en haut
	add_action( 'wp_footer', 'eccp_back_to_top' );
}

function eccp_back_to_top() {
	echo'<a href="#top" class="scroll-top"></a>';
}


/*-------------- Ajouter une boîte d'informations sur l'auteur a la fin des articles  ---------------*/


function eccp_author_info_box( $content ) {
 
	global $post;
	
	
	// Détecter s'il s'agit d'un article unique avec un auteur d'article
	if ( (is_singular('post')) && isset( $post->post_author ) ) {
	 
		// Obtenir le nom d'affichage de l'auteur
		$display_name = get_the_author_meta( 'display_name', $post->post_author );
		 
		// Si le nom d'affichage n'est pas disponible, utilisez le surnom comme nom d'affichage
		if ( empty( $display_name ) )
		$display_name = get_the_author_meta( 'nickname', $post->post_author );
		 
		// Obtenir les informations biographiques ou la description de l'auteur
		$user_description = get_the_author_meta( 'user_description', $post->post_author );
		 
		// Récupération des liens pour l'auteur de l'article 
		// les clés du tableau corespondent au suffixe de la classe
		// de l'icône dashicon
		$social_icon_link = array(
								//URL du site Web de l'auteur
                                'admin-site-alt3' => get_the_author_meta('user_url',$post->post_author),
                                // liens sociaux
								'facebook-alt'   => get_the_author_meta('facebook',$post->post_author),
	                            'instagram' => get_the_author_meta('instagram',$post->post_author),
	                            'linkedin'   => get_the_author_meta('linkedin',$post->post_author),
	                            'pinterest'    => get_the_author_meta('pinterest',$post->post_author),
                                'twitter'  => get_the_author_meta('twitter',$post->post_author),
								'youtube'  => get_the_author_meta('youtube',$post->post_author),
	                        );
		
		// Obtenir le lien vers la page d'archives de l'auteur
		// exemple lien: http://localhost/wp-chef-ocean/author/wpadmin
		//$user_posts = get_author_posts_url( get_the_author_meta( 'ID' , $post->post_author));
	 
		// s'il y a une description de l'auteur
		if ( ! empty( $user_description ) ) {
			
			$title = '<p class="eccp-author-bio-title">'. esc_html__('About the Author','editor-custom-color-palette').'</p>';
			
			$avatar = get_avatar( get_the_author_meta('user_email', $post->post_author) , 80 );
			
			$author_details =  nl2br( $user_description );
			
			// Ajout des liens sociaux
			$social_link='<p class="eccp-author-links">';
			//$social_link .= '<a href="'. $user_posts .'">' . esc_html__('View all posts by ','editor-custom-color-palette'). $display_name . '</a> | ';
	
			foreach ( $social_icon_link as $key => $value ) {
				
				if ( ! empty( $value ) ) {
					$social_link .= '<a href="' . esc_url( $value ) .'" target="_blank" rel="nofollow noopener noreferrer"><i class="dashicons dashicons-' . esc_attr( $key ) . '"></i></a>';                    
				}   
				
			}
			
			// on ferme la balise p des liens sociaux
			$author_details .='</p>';
			
			// Transmission de toutes ces informations pour publier du contenu
			// on gére les données structurées avec itemscope qui
			// fonctionne généralement avec l'attribut itemtype = "http://schema.org/Person"
			// pour préciser de quel type de contenu en l'occurence une personne
			// on ajoute donc itemprop="author"  itemprop = "name" & itemprop="description"
			$content = $content . 
						'<section class="eccp-author-bio" itemprop="author" itemscope="" itemtype="http://schema.org/Person" >' 
						
						. $title .
						
							'<div class="eccp-author-bio-inner">'.
							
								'<div class="eccp-author-bio-avatar">'
								 . $avatar .
								'</div>'.
								
								'<div class="eccp-author-bio-content ">'.
								
								'<h4 class="eccp-author-name" itemprop = "name" >'. $display_name. '</h4>'.
								
									'<div class="eccp-author-bio-description" itemprop="description">'
									. $author_details .
									'</div>'
									
								. $social_link .
								
								'</div>'.
								
							'</div>'.
							
						'</section>';
	 
		}
	
	}
	
	return $content;
	
}
 
// si on a activé la boite d'info auteur
if ($custom_front_end_settings['eccp_settings_enable_author_info_box_checkbox_field']) {
 
	// Ajouter de notre fonction au filtre de publication du contenu
	add_action( 'the_content', 'eccp_author_info_box',9999 );
	 
	// Autoriser le HTML en Admin pour le profil du compte 
	// dans les Renseignements biographiques de l'auteur
	remove_filter('pre_user_description', 'wp_filter_kses');

}

/*-------------- Filtrer l’affichage des extraits d'articles automatique  ---------------*/

/* 
On filtre la balise de fin de l'extrait automatique
généralement […] mais certains thèmes comme generate press
ont la balise … alors on impose la balise […]
Ceci afin que la fonction suivante eccp_custom_post_excerpt()
fonctionne correctement pour la modification qui consiste à effectuer
un retour a la ligne aprés le signe de ponctuation
d'une fin de phrase c'est à dire le point.
*/
function eccp_change_excerpt_more( $more ) {
	if ( is_admin() ) {
		return $more;
	}

	return '[…]';
 }

add_filter( 'excerpt_more', 'eccp_change_excerpt_more', 999 );


/*
WordPress a une fonction appelée the_excerpt()qui affiche l'extrait d'un article.
cela fonctionne intelligemment: 
il vérifie d'abord s'il y a un extrait et si ce n'est pas le cas, 
il extrait automatiquement les premiers mots du contenu en enlevant toutes
les balises HTML. 
Par défaut, cela prend 55 mots,et en toute fin ajoute: [...]

Dans le cas d'un extrait d'article automatique, il réside un problème
du à l'extension ECCP, en effet des libellés sont insérés
en début de l'extrait et sont du au bloc icônes sociales de WordPress
inséré automatiquement en début d'articles, via un bloc réutilisable
du bloc icones sociales transformé en liens de partage par l'extension ECCP

Pour modifier l'extrait de l'article on utilise le filtre get_the_excerpt 
qui transmet une chaîne qui correspond au contenu complet de l'extrait.

*/

function eccp_custom_post_excerpt( $excerpt ) {
	
	if ( is_admin() ) {
		return $excerpt;
	}
	
	// on supprime les libellés du au bloc icônes sociales de WordPress
	// inséré automatiquement en début d'articles
	// et l'avertissement qu'on a activé le mode debug
	$excerpt = str_replace( 
							array('Tweetez', 
								  'Enregistrez', 
								  'Partagez',
								  'Mail',
								  'LinkedIn',
								  'WhatsApp',
								  'You see the following because',
								  'WP_DEBUG and WP_DEBUG_DISPLAY',
								  'WP_DEBUG',
								  'are enabled on this',
								  'are enabled on this site.',
								  'Please disabled these to prevent the display of',
								  "Please disabled these to prevent the display of these developers' debug messages.",
								 ), 
							'', 
							$excerpt	  
						);
	
	// on insère un retour a la ligne aprés un point
	$excerpt = str_replace( '.', '.<br>', $excerpt );
	
	return $excerpt;
}


add_filter( 'get_the_excerpt', 'eccp_custom_post_excerpt', 999 );


/*----------------------------------------------------------------------------------------
		   CSS DYNAMIQUE POUR PERSONNALISER L'INTERFACE PUBLIQUE
/*---------------------------------------------------------------------------------------*/



add_action( 'wp_head', 'eccp_dynamic_css_public_interface' );

 function eccp_dynamic_css_public_interface() {
	 
	// récupération des paramètres du plugin
	$custom_front_end_settings = get_option( 'eccp_settings_custom_front_end' );
	$reusable_blocks_settings = get_option( 'eccp_settings_reusable_blocks' );

	// On récupère l'ID des blocs réutilisables sélectionnés pour les articles dans l'onglet
	// Blocs réutilisable de la page d'option du plugin
	$existing_post_before_reusable_block_id = intval( $reusable_blocks_settings['eccp_settings_insert_block_before_post_select_field'] );
	$existing_post_after_reusable_block_id = intval( $reusable_blocks_settings['eccp_settings_insert_block_after_post_select_field'] );

	
	// récupération du thème actif
	$my_theme = wp_get_theme();
	 
	echo '<style type="text/css">';
	
		if ( $custom_front_end_settings['eccp_settings_enable_back_to_top_button_checkbox_field'] ) {
			
			/*------------ CSS Pour Bouton Retour Vers Le Haut  ---------*/
			echo'.scroll-top {';

			  echo'background-color:'.$custom_front_end_settings['eccp_settings_back_top_button_color_text_field'].';';/* couleur par défaut bouton WordPress */
			  echo'width: 40px;';
			  echo'height: 40px;';
			  echo'text-align: center;';
			  echo'text-decoration: none;'; /* évite le soulignement bouton actif */
			  echo'border-radius:'.$custom_front_end_settings['eccp_settings_back_to_top_button_border_radius_text_field'].'px;';
			  echo'position: fixed;';/*La position fixe permet toujours à notre bouton de rester au même endroit lorsque nous faisons défiler la page*/
			  echo'bottom:'.$custom_front_end_settings['eccp_settings_margin_y_text_field'].'px;';
			  echo'right:'.$custom_front_end_settings['eccp_settings_margin_x_text_field'].'px;';
			  echo'z-index: 1000;';/*z-index d'un nombre très élevé fait en sorte que le bouton chevauche toujours d'autres éléments du site*/
			  echo'opacity: calc('.$custom_front_end_settings['eccp_settings_back_top_button_opacity_text_field'].'/100);';
			   
			echo'}';

			echo'.scroll-top:hover {';
			  echo'cursor: pointer;';
			  echo'opacity: calc('.$custom_front_end_settings ['eccp_settings_back_top_button_opacity_on_hover_text_field'].'/100);';
			echo'}';

			echo'.scroll-top:active {';
			  echo'opacity:1;';
			echo'}';


			echo'.scroll-top:after {';
			  echo'content: "\f343";';
			  echo'font-family:"dashicons";';
			  echo'font-weight: normal;';
			  echo'font-style: normal;';
			  echo'font-size: 2em;';
			  echo'line-height: 40px;';/* on ajuste la hauteur de la ligne a celle du container pour un centrage vertical de l'icône */
			  echo'color:'.$custom_front_end_settings['eccp_settings_color_icon_back_to_top_button_text_field'].';';
			echo'}';
				
	 
			/* Régles du bouton sur mobile */
			echo'@media(max-width: 480px){';
			
				echo'.scroll-top {';
					echo'right: 10px;';
					echo'bottom: 10px;';
					echo'width: 26px;';
					echo'height: 26px;';
				echo'}';
				
				echo'.scroll-top:after {';
				  echo'font-size: 1em;';
				  echo'line-height: 26px;';
				echo'}';
				
			echo'}';
			
		}// Fin si activation bouton retour en Haut
		
		
		/* ----- Boite d'informations sur l'auteur ---*/
	
		if ($custom_front_end_settings['eccp_settings_enable_author_info_box_checkbox_field']) {
		
			// Container principal boite d'info auteur
			echo'body.single .eccp-author-bio{';
				echo'background-color:' . $custom_front_end_settings['eccp_settings_background_author_info_box_text_field'] . ';';
				echo'padding:30px 15px 10px 15px;';
				echo'box-shadow: 5px 5px 5px #888888;';
				echo'margin-bottom:15px;';
				echo'margin-top: 50px;';
			echo'}';
			 
			 
			// texte intro: À PROPOS DE L'AUTEUR
			echo'body.single .eccp-author-bio-title{';
				echo'text-align:center;';
				echo'color:' . $custom_front_end_settings['eccp_settings_text_author_info_box_text_field'] . ';';
				echo'text-transform: uppercase;';
				echo'font-size:22px;';
			echo'}';

			// balise <h4> pour le nom de l'auteur
			echo'body.single .eccp-author-name{';
				echo'font-size:22px;';
				echo'font-weight: bold;';
				echo'color:' . $custom_front_end_settings['eccp_settings_title_author_info_box_text_field'] . ';';
			echo'}';


			// container liens sociaux
			echo'body.single .eccp-author-links{';
				echo'padding:10px 0px;';
				echo'margin: 0;';
			echo'}';
				
			// pour les icônes de réseaux sociaux
			echo'body.single .eccp-author-links a{';
				echo'padding:5px;';
				echo'text-decoration:none!important;';
				echo'color:' . $custom_front_end_settings['eccp_settings_link_author_info_box_text_field'] . ';';
			echo'}';
			
			// on supprime au clic l'encadrement des icônes liens sociaux 
			echo'body.single .eccp-author-links a{';
				echo'outline:none!important;';
			echo'}';

			echo'body.single .eccp-author-links i.dashicons{';
				echo'vertical-align:middle;';
			echo'}';

			// container div avatar & div descrition biographique auteur
			echo'body.single .eccp-author-bio-inner{';
				echo'display:flex;';
			echo'}';

			// container avatar
			echo'body.single .eccp-author-bio-avatar{';
				echo'min-width:80px;';
				echo'margin-right:30px;';
			echo'}';

			echo'body.single .eccp-author-bio-avatar img{';
				echo'border-radius:'.$custom_front_end_settings['eccp_settings_border_radius_avatar_author_info_box_text_field'].'px;';
				echo'border:none;';
			echo'}';

			// description biographique auteur
			echo'body.single .author-bio-content {';
				echo'position:relative;';
			echo'}';
			
			// couleur texte pour la description biographique auteur
			echo'body.single .eccp-author-bio-description {';
				echo'color:' . $custom_front_end_settings['eccp_settings_text_author_info_box_text_field'] . ';';
				echo'font-size:18px;';
			echo'}';
			
			// couleur lien pour la description biographique auteur
			echo'body.single .eccp-author-bio-description a {';
				echo'font-size:18px;';
				echo'text-decoration:none!important;';
				echo'color:' . $custom_front_end_settings['eccp_settings_link_author_info_box_text_field'] . ';';
			echo'}';


			/* Régles pour mobile */
			echo'@media(max-width:480px){';
			
				echo'body.single .eccp-author-bio-inner {';
					echo'flex-direction:column;';
				echo'}';
				
				echo'body.single .eccp-author-bio-avatar img{';
					echo'display:block;';
					echo'margin:auto;';
				echo'}';
				
				echo'body.single .eccp-author-name {';
					echo'text-align: center;';
					echo'margin-top: 20px;';
				echo'}';
				
			echo'}';


			/* l'activation des blocs réutilisables avant & aprés le contenu
			   duplique 2 fois la bio de l'auteur
			   on cible tous les éléments impairs   */
			if ( $existing_post_before_reusable_block_id || $existing_post_after_reusable_block_id ) {
				
				echo'section.eccp-author-bio:nth-of-type(2n+1){';
					echo'display:none;';
				echo'}';
				
			}

			/* on supprime la bio de oceanWP */
			if(stristr($my_theme, 'oceanwp')) {
				
				echo'#author-bio{';
					echo'display:none!important;';
				echo'}';
			
			}
			
		}
		
		/* ----- Lightbox Fancybox pour les publications ---*/
	
		if ($custom_front_end_settings['eccp_settings_enable_lightbox_checkbox_field']) {
		
			/* régle pour que la barre d'outils apparaisse au premier plan
			lorsque la lightbox n'est plus en plein écran */
			echo'body.single .fancybox__container,
			body.page .fancybox__container{';
				echo'z-index: 100000;';
			echo'}';

			/* Légende */
			echo'.fancybox__caption{';
				echo'text-align:center;';
				echo'font-weight:600;';
			echo'}';
			
			/* pour les mobiles la librairie Fancybox
			   fonctionne correctement qu'en mode plein écran
			   et le bouton masquer les vignettes est inactif
			   Alors on masque les boutons toogle:
			   mode plein écran,afficher/masquer vignettes,
			   ainsi qe les vignettes */
			echo'@media(max-width:900px){
				 button[title="Toggle full-screen mode"],
				 button[title="Toggle thumbnails"],
				 .fancybox__thumbs{';
					echo'display:none;';
				echo'}';
			echo'}';
		
		}
		
	echo '</style>';
	
 }


/***********************************************************************************************
                                       PERSONNALISER BLOCS GUTENBERG            
***********************************************************************************************/

/*------------ Ajouter une nouvelle taille aux paramètres du bloc image  ---------*/

// si on a activé une nouvelle taille d'image aux paramètres du bloc
// et si on a donné un nom acette nouvelle taille d'image
if( ($custom_gutenberg_blocks_settings['eccp_settings_enable_image_size_setting_radio_field'] == 'yes') &&
  (!empty($custom_gutenberg_blocks_settings['eccp_settings_name_new_image_size_text_field'])) ) {


	// Création de la taille au format 16/9 ème utilisée dans le site
	// add_image_size( libellé, hauteur , largeur, image recadré)
	function eccp_setup_init_images() {
		// récupération des paramètres
		$custom_gutenberg_blocks_settings = get_option( 'eccp_settings_custom_gutenberg_block' );
		
		add_image_size( $custom_gutenberg_blocks_settings['eccp_settings_slug_new_image_size_text_field'], 720, 405, false );
	}

	add_action( 'after_setup_theme', 'eccp_setup_init_images' );


	// Ajout de la taille: custom aux paramètres du bloc image,
	// pour cela on utilise le hook: image_size_names_choose. 
	// la fontion php array_merge permet de fusionner en fin de tableau
	// la taille custom avec celles existantes:
	// thumbnail (miniature: 150*150) medium (moyenne: 300px de large max ) large (1024px) 
	// post-thumbnail (taille originale).
	// il existe une taille medium_large (moyenne-large: max 768px de large) utilisée pour le responsive
	// affichée uniquement dans le HTML de l'image avec l'attribut srcset.
	// pour que la taille custom apparaisse dans le menu déroulant Taille de l'image des paramètres du bloc,
	// il faut au préalable régénérer les miniatures avec l'extension Regenerate Thumbnails.
	function eccp_custom_sizes_images( $sizes ) {
		
		// récupèration des paramètres
		$custom_gutenberg_blocks_settings = get_option( 'eccp_settings_custom_gutenberg_block' );
		
		// par défaut
		// $new_sizes = array('custom' => __('Custom', 'editor-custom-color-palette')
		$new_sizes = array($custom_gutenberg_blocks_settings['eccp_settings_slug_new_image_size_text_field'] => __($custom_gutenberg_blocks_settings['eccp_settings_name_new_image_size_text_field'], 'editor-custom-color-palette')) ;
		return array_merge( $sizes,$new_sizes); 					
	}

	add_filter( 'image_size_names_choose', 'eccp_custom_sizes_images' );

}

/*------------ Modifier les paramètres d'ajout de média par défaut  ---------*/

function eccp_image_display_settings() {
	
	// récupèration des paramètres
	$custom_gutenberg_blocks_settings = get_option( 'eccp_settings_custom_gutenberg_block' );

	// l'alignement ne fonctionne pas
	//update_option( 'image_default_align', 'center' ); // left, center, right, none
	update_option( 'image_default_link_type', $custom_gutenberg_blocks_settings['eccp_settings_image_default_link_type_select_field'] );//  none , file 
	update_option( 'image_default_size', $custom_gutenberg_blocks_settings['eccp_settings_image_default_size_select_field'] ); // thumbnail, medium, large, full

}
add_action( 'after_setup_theme', 'eccp_image_display_settings',10 );


/*------------ Ajout en Front End d'attribut URL Pour les bloc Groupe & Colonne  ---------*/

/**
  * Ajout d'un lien aux données du bloc.
  * 
  * @param	string	$block_content ==> le contenu du bloc
  * @param	array	$block ==> les données du bloc complet, y compris le nom et les attributs
  * @return	string ==> Le contenu du bloc mis à jour
  * @throws	\DOMexception
  */
 function eccp_add_linkable_block_data( string $block_content, array $block ): string {
	
	// les attributs link,withLinkBlock, target
	// ont été définit en React JS pour les blocs Groupe & Colonne
	// wp_parse_args permet de fusionner un tableau d'arguments $block['attrs'] 
	// et un tableau de valeurs par défaut
 	$args = wp_parse_args(
	
 		$block['attrs'],
 		[
 			'link' => '',
 			'withLinkBlock' => false,
 			'target' => '',
 		]
 	);

 	// signifie que les erreurs dans la bibliothèque libxml ne sont pas générées 
	// et que l'on doit s'en occuper via libxml_get_errors()
	libxml_use_internal_errors( true );

 	// on initialise la classe DOMDocument
	// avec DOMDocument() on a la possibilité d'effectuer des opérations similaires 
	// a javascript sur le Document Object Model (DOM) de n'importe quel code HTML
	// de nombreuses méthodes ont été DOMDocumentnommées de manière identique 
	// à leur équivalent JavaScript, par ex getElementById()
	$dom = new DOMDocument();
	
	// on charge le contenu HTML($block_content) et on l'encadre de balise html
	// car nécessaire pour pouvoir le traiter avec la classe DOMDocument
	// loadHTML fonctionne avec ISO-8859-1 par défaut,donc on utilise la fonction
	// mb_convert_encoding pour encoder en UTF8
	// LIBXML_HTML_NOIMPLIED:désactive l'ajout automatique d'éléments html/body... implicites.
	// LIBXML_HTML_NODEFDTD: empêche l'ajout d'un doctype par défaut lorsqu'il n'en trouve pas.
 	$dom->loadHTML(
 		mb_convert_encoding(
 			'<html>' . $block_content . '</html>',
 			'HTML-ENTITIES',
 			'UTF-8'
 		),
 		LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD
 	);

 	// pour tous les éléments qui sont des divs 
 	foreach ( $dom->getElementsByTagName( 'div' ) as $element ) {
		
 		// Si on activé le lien pour les blocs
		if ( $args['withLinkBlock'] ) {
			
			// si le lien renseigné en backoffice dans les paramètres 
			// du bloc Groupe ou colonne est bien une URL
			// on attribue la classe is-linkable-block en la concaténant avec les classes
			// existante du bloc Groupe ou Colonne
			// attention! l'espace est important devant la classe is-linkable-block
			// on ajoute dans le html du bloc l'attribut data-link
			// avec la valeur de l'attribut link pour renseigner l'URL
			// on ajoute dans le html du bloc l'attribut data-target
			// avec la valeur de l'attribut target pour renseigner
			// si on ouvre le lien dans l'onglet courant ou un nouvel onglet
			if (!filter_var( $args['link'], FILTER_VALIDATE_URL) === false) {
				
				$element->setAttribute( 'class', $element->getAttribute( 'class' ) . ' is-linkable-block' );
				$element->setAttribute( 'data-link', $block['attrs']['link'] );
				$element->setAttribute( 'data-target', $args['target'] );
				
			}
			
		}


 	}

 	// on affecte le contenu HTML du bloc modifié
	$block_content = $dom->saveHTML( $dom->documentElement );

	// on active la gestion d'erreur libxml
 	libxml_use_internal_errors( false );

 	// on nettoie le code HTML et on remplace 
	// toutes les balise <html> & </html>
	// par une chaine vide dans $block_content
	// valeur de retour de la fonction
	return str_replace(
 		[
 			'<html>',
 			'</html>',
 		],
 		[
 			'',
 			'',
 		],
 		$block_content
 	);
	
 }

 // On utilise le hook render_block_name block  qui permet de filtrer le contenu
 // du bloc avant son rendu HTML sur le Front END
 add_action( 'render_block_core/column', 'eccp_add_linkable_block_data', 10, 2 );
 add_action( 'render_block_core/group', 'eccp_add_linkable_block_data', 10, 2 );




// on marque les blocs comme des liens
// en spécifiant le curseur de la souris comme pointer
function ecpp_style_link_block() {
	
	
	echo '<style type="text/css" id="eccp-link-block">';
		
		
		echo'.is-linkable-block{';
			echo'cursor: pointer;';
		echo'}';
		
	echo '</style>';
	
}

add_action( 'wp_head','ecpp_style_link_block',1 );




/* AJOUT EN FRONT END DE LA VARIATION DU BLOCK GROUPE COMPTE A REBOURS */

/*
Une post meta:countdown_timer_date_events a été déclaré par la fonction
PHP eccp_register_post_meta().
Le fichier sidebarControlsCountDown.js établi en ReactJS ajoute dans les
paramètres du bloc un panneau ECCP Countdown Timer qui comporte un DatePicker.
La date sélectionnée est affectée a un attribut dateEvents qui met a jour
la post meta:countdown_timer_date_events pour la publication en cours
réciproquement la post meta:countdown_timer_date_events est récupéré
en ReactJS pour initialiser le DatePicker.  
Le hook render_block est utilisé par la fonction eccp_countdown() pour modifier 
en Front End le balisage de fin du block groupe de classe is-style-eccp-countdown 
pour incorporer le code HTML de notre compte a rebours contitué par une liste a puce 
non ordonnée.
la date de l'évènement pour le compte à rebours a été affiché dans une div caché 
par la fonction php: eccp_get_countdown_timer_date_events().
le script JS: eccp-countdown-timer.js va récupérer la date d'èvènement dans cette
balise <div> caché et actualiser l'affichage du compte a rebours toutes les secondes.
*/

function eccp_countdown( $block_content, $block ) {

		// les attributs dateEvents ,withCountdownBlock, 
		// ont été définit en React JS pour le bloc Groupe 
		// wp_parse_args permet de fusionner un tableau d'arguments $block['attrs'] 
		// et un tableau de valeurs par défaut
		$args = wp_parse_args(
		
			$block['attrs'],
			[
				'dateEvents' => '',
				'withCoundownBlock' => false,
			]
		);
		
	// si c'est le bloc groupe avec une classe is-style-eccp-countdown
	if( 'core/group' === $block['blockName'] && $args['withCoundownBlock'] &&
	    !empty( $block['attrs']['className'] ) && 'is-style-eccp-countdown' === $block['attrs']['className'] ) {
		
		/* Pour debug 
			print_r ($args['withCoundownBlock']);
				echo'<br>';
			print_r ($args['dateEvents']);
				echo'<br>';
		*/
		
		// balise HTML de fermeture du bloc groupe
		$original_closing_tag = '</div>';

		// nouveau balisage en fermeture du bloc groupe
		// pour notre style compte à rebours
		$new_closing_tag = '<ul id="countdown">';
			$new_closing_tag .= '<li>'; 
				$new_closing_tag .= '<p class="timeRefDays">'.__( 'Days','editor-custom-color-palette').'</p>'; 
				$new_closing_tag .= "<span class='days'> </span>"; 
			$new_closing_tag .= '</li>'; 
			$new_closing_tag .= '<li>';
				$new_closing_tag .= '<p class="timeRefHours">'.__( 'Hours','editor-custom-color-palette').'</p>';
				$new_closing_tag .= "<span class='hours'> </span>";
			$new_closing_tag .= '</li>'; 
			$new_closing_tag .= '<li>';
				$new_closing_tag .= '<p class="timeRefMinutes">'.__( 'Minutes','editor-custom-color-palette').'</p>';
				$new_closing_tag .= "<span class='minutes'> </span>";
			$new_closing_tag .= '</li>'; 
			$new_closing_tag .= '<li>';
				$new_closing_tag .= '<p class="timeRefSeconds">'.__( 'Seconds','editor-custom-color-palette').'</p>';
				$new_closing_tag .= "<span class='seconds'> </span>";
			$new_closing_tag .= '</li>'; 
		$new_closing_tag .= '</ul>'; 
		
		$new_closing_tag .= $original_closing_tag;
		
		// on remplace dans le contenu du bloc la balise de fermeture originale 
		// par la nouvelle qui contient le Compte A Rebours
		$block_content = str_replace( $original_closing_tag, $new_closing_tag, $block_content );
		
	}
	
	return $block_content;
}

add_filter( 'render_block', 'eccp_countdown', 10, 2 );


// Passage de la date d'évènement du compte à rebours au script JS
// qui actualise le compte à rebours
// on va utiliser DOM pour passer la variable PHP à JavaScript
// en concret on utilise un div caché pour afficher notre variable sur la page HTML
// pour la récupérer ensuite par javascript avec le script: eccp-countdown-timer.js */  
 function eccp_get_countdown_timer_date_events(){ 

	$date = get_post_meta( get_the_ID(), 'countdown_timer_date_events', true );
	
	// pour la date du 31/01/2023 la date retourné par le DatePicker
	// a l'attribut dateEvents est: 2023-01-31T13:34:51
	// la date doit être au format anglais pour la conversion au format timestamp
	// on  va éliminer l'heure et ne conserver que la date
	// pour une bonne conversion au format timestamp
	$date_events = substr($date, 0, stripos($date, 'T') );
	
	/* ancien code pour conserver l'heure mais supprimer le caractère 'T'
		$date_events = substr($date, 0, stripos($date, 'T') );
		$date_events .=' ';
		$date_events .= substr($date, stripos($date, 'T') + 1 );
	*/
	
	?>
	<div id="data-date-events" style="display:none;" >
		<?php
			echo esc_html($date_events); 
		?>
	</div>
	<?php
	
 }
 
add_action( 'wp_head','eccp_get_countdown_timer_date_events',100 );




/* Ancien code pour la variation du bloc groupe Countdown Timer qui ne
nécessite pas de script JS mais affiche un compte a rebours avec seulement
le nombre de semaines et jours restant */
function eccp_countdown_old( $block_content, $block ) {

		// les attributs dateEvents ,withCountdownBlock, 
		// ont été définit en React JS pour le bloc Groupe 
		// wp_parse_args permet de fusionner un tableau d'arguments $block['attrs'] 
		// et un tableau de valeurs par défaut
		$args = wp_parse_args(
		
			$block['attrs'],
			[
				'dateEvents' => '',
				'withCoundownBlock' => false,
			]
		);
		
	// si c'est le bloc groupe avec une classe is-style-eccp-countdown
	if( 'core/group' === $block['blockName'] && $args['withCoundownBlock'] &&
	    !empty( $block['attrs']['className'] ) && 'is-style-eccp-countdown' === $block['attrs']['className'] ) {
		
		/* Pour debug
			print_r ($args['withCoundownBlock']);
				echo'<br>';
			print_r ($args['dateEvents']);
				echo'<br>';
		*/
		
		// pour la date du 31/01/2023 la date retourné par le DatePicker
        // a l'attribut dateEvents est: 2023-01-31T13:34:51
		// la date doit être au format anglais pour la conversion au format timestamp
		// on ne va récupèrer que seulement la date sinon cela 
		// fausse la conversion au format timestamp
		$date = substr($args['dateEvents'], 0, stripos($args['dateEvents'], 'T') );
		
		
		// pour la conversion en timestamp par la fonction strtotime
		// on convertit la date en un format timestamp c'est à dire le nbr de seconde
		// depuis le 1er janvier 1970
		// time retourne l'heure courante, mesurée en secondes depuis le 1er janvier 1970 
		// on en déduit par rapport a l'heure actuelle le temps a décompter en seconde
		$time_remaining = strtotime($date) - time();
	  
		echo'Ecart de temps: '.$time_remaining;
		 
		if ($time_remaining < 0) {
			$time_remaining = 0;
		}

		// nbr total de jour que représente de décompte
		// ceil arrondi a l'entier supérieur
		// 60s * 60' * 24H = 86400s en une journée 
		$total_days_remaining = ceil($time_remaining / (60 * 60 * 24));
		
		if ($total_days_remaining >= 7) {
		 
			// Nombre de semaine restante dans le décompte
			// floor arrondi a l'entier inférieur
			// format d'affichage de sprintf: %02D 
			// en lisant de droite a gauche on renvoit un nombre entier(d) au format de deux chiffres
			// et on complète par un zéro si on a qu'un chiffre pour le nbr de semaine 
			$weeks_remaining = sprintf("%02d", floor($total_days_remaining / 7));
			
		
			// on met a jour le décompte en enlevant le nbr de semaine converti
			// en seconde
			$time_remaining  -= $weeks_remaining * 7 * 60 * 60 * 24;
		
			// Nombre de jours restant dans le décompte
			$days_remaining = sprintf("%02d", ceil($time_remaining / (60 * 60 * 24) ));
	  
		} else {
		
			$weeks_remaining = sprintf("%02d", 0);
			$days_remaining = sprintf("%02d", $total_days_remaining);
		
		}
		  
		  
		// on récupère le contenu du bloc groupe
		// explode scinde le contenu délimité par le séparateur:<div>
		// en sous chaine retourné dans un tableau
		//$content = explode( '<div>', $block_content );
		
		// on récupère le contenu du bloc groupe 
		// wp_strip_all_tags permet de supprimer toutes les balise HTML du contenu
		//$text = rawurlencode( wp_strip_all_tags( $content[0]) );
		
		// balise HTML de fermeture du bloc groupe
		$original_closing_tag = '</div>';

		// nouveau balisage en fermeture du bloc groupe
		// pour notre style compte à rebours
		$new_closing_tag = '<ul id="countdown">';
			$new_closing_tag .= '<li>';
				$new_closing_tag .= '<p class="timeRefWeeks">'.__( 'Weeks','editor-custom-color-palette').'</p>';
				$new_closing_tag .= "<span class='weeks'>$weeks_remaining</span>";
			$new_closing_tag .= '</li>'; 
			$new_closing_tag .= '<li>'; 
				$new_closing_tag .= '<p class="timeRefDays">'.__( 'Days','editor-custom-color-palette').'</p>'; 
				$new_closing_tag .= "<span class='days'>$days_remaining</span>"; 
			$new_closing_tag .= '</li>'; 
		$new_closing_tag .= '</ul>'; 
		
		$new_closing_tag .= $original_closing_tag;
		
		// on remplace dans le contenu du bloc la balise de fermeture originale 
		// par la nouvelle qui contient le Compte A Rebours
		$block_content = str_replace( $original_closing_tag, $new_closing_tag, $block_content );
		
	}
	
	return $block_content;
}
//add_filter( 'render_block', 'eccp_countdown_old', 10, 2 );



/* Bloc Groupe: AJOUT EN FRONT END DU STYLE TABLE OF CONTENTS */

/*

********* structure balisage liste ordonnée WordPress *********

<ol class="is-style-eccp-table-of-contents-bullet-list">

	<li class="heading-level-2">
    		<a href="#introduction">Titre H2</a>
				<ol>
						<li class="heading-level-3">
							<a href="#a-propos">Titre H3</a>
						</li>
						
						<li class="heading-level-3">
							<a href="#deuxième-titre-h3">deuxième titre H3</a>
						
								<ol>
									<li class="heading-level-4">
										<a href="#le-concours">Titre H4</a>

											<ol>
												<li class="heading-level-5">
													<a href="#le-concours">Titre H5</a>
												</li>
											
											</ol>
									</li>
								</ol>
						</li>
				</ol>
	</li>

	<li class="heading-level-2">
		<a href="#suivez-rock-4-you">Titre H2</a>
	</li>
	
</ol>

• Lorsque deux titres de même niveau hièrarchique se suivent on ferme la balise </li>
du 1er titre. 

• On laisse la balise <li> ouverte et on ajoute une balise <ol> pour une liste
ordonnée imbriqué lorsque le titre qui suit baisse dans la hièrarchie, 
afin d'identer la liste.

• lorsque le titre qui suit augmente dans la hièrarchie, on ferme les balises </ol>
ce qui ferme automatiquement les balises </li> et permet de supprimer l'identation.


******* Structure HTML de la table des matières ********

A partir du panneau avancé du bloc groupe on change la balise
<div> par défaut du bloc groupe en <article> sinon la table
des matières est répétée pour chaque bloc groupe!!
Un bloc code est ajouté en back office au block groupe pour
mettre en évidence que c'est le bloc Table des matières.
Ce bloc code est masqué en Front End.
On utilise un bloc code pour éviter que l'intitulé Table des matières soit repris
dans le résumé apparaissant dans le bloc boucle de requête
ou Derniers Articles.
On utilise la balise <détails> qui permet de révéler ou non
son contenu suivant repectivement la valeur d'un attribut
open afin de créer un effet accordéon.
par défaut la balise <détails> est fermé et il n' y a pas d'attribut
l'attribut open ou rien varie automatiquement suivant le clic sur la balise <détails>.
Pour avoir le contenu de la balise <détails> affiché par défaut on ajoute l'attribut open
le contenu de la balise <détails> sera une liste ordonnée imbriquée selon le niveau des titres.
la 1ère balise enfant de <détails> est summary pour fournir
un intitulé au contenu, cette balise bien que contenu
dans la balise <détails> est toujours visible.
il n'existe aucun moyen intégré d'animer la transition 
entre l'ouverture et la fermeture.

<article class="wp-block-group is-style-eccp-toc">
	<pre class="wp-block-code">
		<code>TABLE DES MATIÈRES</code>
	</pre>
	<div class="eccp-toc">
		<details open>
			<summary>
			Table des matières
			</summary>
			<nav aria-label="table of contents">
				<ol class=is-style-eccp-table-of-contents-bullet-list>
					<!--items ici de la table des matières-->
				</ol>
			</nav>
		</details>
	</div>
</article>


*/
function eccp_table_of_contents_group_block( $block_content, $block ) {

	
	global $post;

	$headings = [];
	
	// correction pour Bug avec la page qui liste les évènements 
	// de l'extension The Events Calendar 
	if(empty($post->post_content)){
		return '';
	}
	
	// s'il y a des blocs on récupère un tableau de tous
	// les blocs du contenu de la publication
	if ( has_blocks( $post->post_content ) ) {
		$blocks = parse_blocks($post->post_content);
	}else{
		return $block_content;
	}
	
	/* Pour Debug
	echo'<pre'>
		print_r($blocks);
	echo'</pre>';
	*/
	
	// on parcours les blocs
	// on récupère les titres et leur niveau 
	foreach ($blocks as $block) {
		
		
		if ($block['blockName'] === 'core/heading') {
			
			// s'il n'y a pas de niveau alors c'est un titre H2, on lui attribue le niveau 2
			// En effet par défaut la fonction parse_blocks() de WordPress 
			// ne retourne pas de niveau pour le titre H2
			$level = (isset($block['attrs']['level'])) ? $block['attrs']['level'] : 2;  
			
			// wp_strip_all_tags permet de supprimer toutes les balises HTML du contenu
			$title = wp_strip_all_tags($block['innerHTML']);
			
			$headings[] = ['title' => $title , 'level' => $level];
			
			//$search  = array('(',')',"'",'"','&amp;','€',);
			//$replace = array(' ',' '," ",' ',' ');' '

			// On supprime des caractères spéciaux comme la parenthèse du titre 
			// pour l'item de liste du sommaire par un espacement blanc. 
			// En effet l'assinissement du titre par la fonction WordPress sanitize_tittle 
			// remplace la parenthèse par rien contrairement a un espace blanc
			// qui est remplacé par un tiret,ceci afin de correspondre a une autre manière d'assainir
			// le titre de la publication  par la fonction eccp_add_anchor_title_tag($matches)
			//$title = str_replace($search, $replace, $title );	
			//echo  $title.'<br>';
			
			// on ajoute l'ancre id=slug-titre a la balise d'ouverture <h> du titre
			//$block_content = str_replace('>'.$title, ' id="'.eccp_sanitize_heading($title).'"'.'>'.$title, $block_content);
		
		}
	
	}
	
	
	/* Pour debug 
	echo'<pre>';
		echo 'nombre de titre: '.count($headings).'<br>';
		print_r($headings);
	echo'</pre>';
	*/
	
	
	// S'il n'y a pas de titre on sort
	if (empty($headings)) {  
		return $block_content;
	}
	
	
	/*
	 Ajouter les ancres sur les différentes titres, 
	 on ajoute un filtre sur le contenu des publications qui va rechercher 
	 les balises h2,h3,h4,h5 et h6 et placer des id sur ces balises.
	 pour cela on utilise la fonction preg_replace_callback()de PHP 
	 qui permet de faire des modifications sur des éléments 
	 que notre regex($pattern) va isoler dans la chaîne
	 Notre regex /<h([2-6])(.*?)>(.*?)</h([2-6])>/ recherche tout ce qui correspond 
	 à des balise <h2>,<h3> <h4> etc.., peut importe leur attribut ou leur contenu.
	*/
	 $pattern = "/<h([2-6])(.*?)>(.*?)<\/h([2-6])>/i";
	 $block_content = preg_replace_callback($pattern, 'eccp_add_anchor_title_tag', $block_content);
	

	// on retourne la balise de fermeture </div> modifié	
	// du bloc groupe
	foreach ($blocks as $block) {

		// si c'est le bloc groupe avec une classe is-style-eccp-toc
		if( 'core/group' === $block['blockName'] && !empty( $block['attrs']['className'] ) 
			&& 'is-style-eccp-toc' === $block['attrs']['className'] ) {
		
			// On récupère les paramètres de l'extension pour la personnalisation des blocs Gutenberg
			$custom_gutenberg_blocks_settings = get_option( 'eccp_settings_custom_gutenberg_block' );
			
			// titre de la table des matières
			$title_toc = $custom_gutenberg_blocks_settings['eccp_settings_name_table_of_contents_text_field'];
		
			// balise HTML originale de fermeture du bloc Groupe
			$original_closing_tag = '</article>';
			
			// on initialise la nouvelle balise de fermeture
			$new_closing_tag = '<div class="eccp-toc">
									<details open>
										<summary>'.
										$title_toc.
										'</summary>
										<nav aria-label="table of contents">
											<ol class="is-style-eccp-table-of-contents-bullet-list">';
			$i = 0;
			$balise_ol_ouverte = 0;
			
			// Nouveau balisage en fermeture du bloc groupe
			// pour notre style Table Of Contents en incorporant les ancres
			foreach ($headings as $heading) {
				
				// pour le caratère & on prend son code HTML: &amp;
				$search  = array('(',')',"'",'"','&amp;');
				$replace = array(' ',' '," ",' ',' ');

				// On supprime des caractères spéciaux comme la parenthèse du titre 
				// pour l'item de liste du sommaire par un espacement blanc. 
				// En effet l'assainissement du titre par la fonction WordPress sanitize_tittle 
				// remplace la parenthèse par rien contrairement a un espace blanc
				// qui est remplacé par un tiret,ceci afin de correspondre a l'assainissement
				// du titre de la publication  par la fonction eccp_add_anchor_title_tag($matches)
				$title = str_replace($search, $replace, $heading['title']);	 
				 
				// on initialise le 1er élément de la table des matières qui doit être de niveau H2 
				// ou H3(si le titre de l'article est en H2)
				if ($i == 0) {
					
					// c'est le seul & unique titre de la publication on ferme la balise '</li>' 
					if ($i == count($headings)-1){
						$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li>';	
				
					// sinon si le titre suivant est de même niveau on ferme la balise '</li>'
					}else if ( isset($headings[$i+1]['level']) && ( $headings[$i+1]['level'] == $headings[$i]['level'] ) ){
						$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li>';
					
					// sinon le titre suivant est de niveau inférieur 
					// on laisse la balise '<li>' ouverte pour pouvoir ensuite identer
					}else {
						$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a>';
					}
					
				}
				
				if ($i > 0) {
					
					
					
					/*----------------------------------------------------------*/
					// si le titre précédent est supérieur hiérarchiquement alors on idente la liste 
					if ( $headings[$i]['level'] > $headings[$i-1]['level'] ){
						
						$balise_ol_ouverte++;
					
						// si le titre suivant est de même niveau 
						// on laisse la balise '<ol>' de l'identation ouverte & on ferme la balise '</li>'
						if (isset($headings[$i+1]['level']) && ( $headings[$i+1]['level'] == $headings[$i]['level'] ) ){
							$new_closing_tag .= '<ol><li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li>';
						
						// sinon le titre suivant est de niveau inférieur 
						// on laisse la balise '<ol>' de l'identation & la balise '<li>' ouverte
						// pour pouvoir identer a nouveau
						}else if ( isset($headings[$i+1]['level']) && ( $headings[$i+1]['level'] > $headings[$i]['level'] )  ){
							$new_closing_tag .= '<ol><li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a>';
						
						// sinon le titre suivant est de niveau hiérachique supérieur 
						}else {
							
							// si le niveau du titre suivant est le plus élevé de l'article
							// on ouvre la balise <ol> pour pouvoir identer
							// on ferme toutes les balises '</ol>' ce qui va fermer automatiquement les balises '</li>'
							// fermetures maximun de balises '</ol>':
							// si le 1er titre de l'article est un H2 alors
							// 1 fermeture balise ol pour le titre H3, 2 pour H4,3 pour H5,4 pour H6
							// si le 1er titre de l'article est un H3 alors
							// 1 fermeture balise ol pour le titre H4, 2 pour H5,3 pour H6
							if ( isset($headings[$i+1]['level']) &&  ( $headings[$i+1]['level'] == $headings[0]['level'] )  ){
							
								// selon le nombre de balise ol ouverte
								// on ferme le nombre de balise ol requise
								switch ($balise_ol_ouverte) {
								
									case 1:
										$new_closing_tag .= '<ol><li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li></ol>';
										  break;
										  
									case 2:
										$new_closing_tag .= '<ol><li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li></ol></ol>';
										  break;
										  
									case 3:
										$new_closing_tag .= '<ol><li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li></ol></ol></ol>';
										  break;
										  
									case 4:
										$new_closing_tag .= '<ol><li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li></ol></ol></ol></ol>';
										  break;
										  
								}
								
								$balise_ol_ouverte = 0;
							
							// Sinon le titre suivant est supérieur mais de niveau H5 , H4 ou H3						
							}else{
								
								if ( isset($headings[$i+1]['level']) ) {
								
									// selon (le niveau du titre en cours - le niveau du titre suivant)
									// on ouvre la balise <ol> pour pouvoir identer
									// on ferme le nombre de balise </ol> requise pour les identations précédentes
									switch ($headings[$i]['level'] - $headings[$i+1]['level']) {
									
										case 1:
											$new_closing_tag .= '<ol><li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li></ol>';
											$balise_ol_ouverte = $balise_ol_ouverte - 1; 
											  break;
											  
										case 2:
											$new_closing_tag .= '<ol><li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li></ol></ol>';
											$balise_ol_ouverte = $balise_ol_ouverte - 2;  
											  break;
											  
										case 3:
											$new_closing_tag .= '<ol><li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li></ol></ol></ol>';
											$balise_ol_ouverte = $balise_ol_ouverte - 3;  
											  break;
											  
											  
									}
								
								}
								
							}
						
						}
			
			
					/*----------------------------------------------------------*/
					// sinon si le titre précédent est de même niveau hiérachique
					}else if ( $headings[$i]['level'] == $headings[$i-1]['level'] ){
						
						// si c'est le dernier titre de la publication on ferme la balise '</li>' 
						if ($i == count($headings)-1){
							$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li>';	
						}
						
						// si le titre suivant est de même niveau 
						// on ferme la balise '</li>'
						if ( isset($headings[$i+1]['level']) && ( $headings[$i+1]['level'] == $headings[$i]['level'] ) ){
						
							$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li>';
						
						// sinon le titre suivant est de niveau inférieur 
						// on laisse la balise '<li>' ouverte pour pouvoir identer
						}else if ( isset($headings[$i+1]['level']) && ( $headings[$i+1]['level'] > $headings[$i]['level'] )  ){
							$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a>';
						
						// sinon le titre suivant est de niveau hiérachique supérieur
						}else{
							
							// si le niveau du titre suivant est le plus élevé de l'article
							// on ferme toutes les balises '</ol>' ce qui va fermer automatiquement les balises '</li>'
							// fermetures maximun de balises '</ol>':
							// si le 1er titre de l'article est un H2 alors
							// 1 fermeture balise ol pour le titre H3, 2 pour H4,3 pour H5,4 pour H6
							// si le 1er titre de l'article est un H3 alors
							// 1 fermeture balise ol pour le titre H4, 2 pour H5,3 pour H6
							if ( isset($headings[$i+1]['level']) &&  ( $headings[$i+1]['level'] == $headings[0]['level'] )  ){
							
								// selon le nombre de balise ol ouverte
								// on ferme le nombre de balise ol requise
								switch ($balise_ol_ouverte) {
								
									case 1:
										$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li></ol>';
										  break;
										  
									case 2:
										$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li></ol></ol>';
										  break;
										  
									case 3:
										$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li></ol></ol></ol>';
										  break;
										  
									case 4:
										$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li></ol></ol></ol></ol>';
										  break;
										  
								}
								
								$balise_ol_ouverte = 0;
							
							// Sinon le titre suivant est supérieur mais de niveau H5 , H4 ou H3						
							}else{
								
								if( isset($headings[$i+1]['level']) ){
								
									// selon le niveau du titre en cours - le niveau du titre suivant
									// on ferme le nombre de balise ol requise
									switch ($headings[$i]['level'] - $headings[$i+1]['level']) {
									
										case 1:
											$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li></ol>';
											$balise_ol_ouverte = $balise_ol_ouverte - 1;
											  break;
											  
										case 2:
											$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li></ol></ol>';
											$balise_ol_ouverte = $balise_ol_ouverte - 2;  
											  break;
											  
										case 3:
											$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li></ol></ol></ol>';
											$balise_ol_ouverte = $balise_ol_ouverte - 3;  
											  break;
											  
											  
									}
								
								}
								
							}
							
						}
					
					/*----------------------------------------------------------*/					
					// sinon si le titre précédent est d'un niveau hiérarchique inférieur
					}else{
						
						
						// si c'est le dernier titre de la publication 
						if ($i == (count($headings)-1) ){
							
							// si le niveau de titre en cours est le plus élevé de la publication
							if ( $headings[$i]['level'] == $headings[0]['level'] ){
							
								// On ferme seulement la balise </li> car les balises
								// </ol> ont été fermées précédement par le titre de niveau inférieur
								$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li>';
							
							// Sinon le titre en cours est supérieur mais de niveau H5 , H4 ou H3						
							}else{
								
								// selon (le niveau du titre précédent - le niveau du titre en cours)
								// on ferme le nombre de balise ol requise pour les identations précédentes
								switch ($headings[$i-1]['level'] - $headings[$i]['level']) {
								
									case 1:
										$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li></ol>';
										$balise_ol_ouverte = $balise_ol_ouverte - 1 ;
										  break;
										  
									case 2:
										$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li></ol></ol>';
										$balise_ol_ouverte = $balise_ol_ouverte - 2;  
										  break;
										  
									case 3:
										$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li></ol></ol></ol>';
										$balise_ol_ouverte = $balise_ol_ouverte - 3;  
										  break;
										  
										  
								}
								
							}	
						
						// si le titre en cours est le plus élevé de la publication
						}else if ( $headings[$i]['level'] == $headings[0]['level'] ){
						
							//$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li>';
						
							// si le titre suivant est de même niveau
							// on ferme seulement la balise </li> car les balises
							// </ol> ont été fermées précédement par le titre de niveau inférieur
							if( isset($headings[$i+1]['level']) && ( $headings[$i+1]['level'] == $headings[$i]['level'] ) ) {
								$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li>';
							
							// alors le titre suivant est obligatoirement d'un niveau inférieur
							// on laisse la balise <li> ouverte pour pouvoir identer
							// pas besoin d'ouvrir la balise <ol> car cela a été fait par le 
							// 1er titre hièrarchiquement le plus élevé de la publication
							}else {
								$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a>';
							}
							
						// Sinon le titre en cours est de niveau H5,H4 ou H3
						// si le titre suivant est d'un niveau hiérachique inférieur					
						}else if( isset($headings[$i+1]['level']) && ( $headings[$i+1]['level'] > $headings[$i]['level'] ) ) {
							
							// selon (le niveau du titre précédent - le niveau du titre en cours)
							// on ouvre une balise <ol> 
							// et on laisse la balise <li> ouverte pour pouvoir identer le titre suivant
							// on ferme le nombre de balise </ol> requise pour les identations précédentes
							switch ($headings[$i-1]['level'] - $headings[$i]['level']) {
							
								case 1:
									$new_closing_tag .= '<ol><li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></ol>';
									$balise_ol_ouverte = $balise_ol_ouverte - 1 ;
									  break;
									  
								case 2:
									$new_closing_tag .= '<ol><li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></ol></ol>';
									$balise_ol_ouverte = $balise_ol_ouverte - 2;  
									  break;
									  
								case 3:
									$new_closing_tag .= '<ol><li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></ol></ol></ol>';
									$balise_ol_ouverte = $balise_ol_ouverte - 3;  
									  break;
									  
									  
							}
							
						// Sinon le titre en cours est de niveau H5,H4 ou H3
						// et le titre suivant est de même niveau						
						}else if( isset($headings[$i+1]['level']) && ( $headings[$i+1]['level'] == $headings[$i]['level'] ) ) {
							
							// on ferme la balise </li> 
							$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li>';
							
						// Sinon le titre en cours est de niveau H5,H4 ou H3
						// et le titre suivant est d'un niveau hiérachique supérieur		
						}else{
							
							
							// si le titre suivant est hièrarchiquement le plus élevé 
							// de la publication 
							if ( isset($headings[$i+1]['level']) && ( $headings[$i+1]['level'] == $headings[0]['level'] ) ){
						
								// selon le nombre de balise ol ouverte
								// on ferme le nombre de balise ol requise
								switch ($balise_ol_ouverte) {
								
									case 1:
										$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li></ol>';
										  break;
										  
									case 2:
										$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li></ol></ol>';
										  break;
										  
									case 3:
										$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li></ol></ol></ol>';
										  break;
										  
									case 4:
										$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li></ol></ol></ol></ol>';
										  break;
										  
								}
							
								$balise_ol_ouverte = 0;
							
							}else{
								
								// selon (le niveau du titre précédent - le niveau du titre en cours)
								// on ferme le nombre de balise ol requise pour les identations précédentes
								// et on ferme la balise </li> 
								switch ($headings[$i-1]['level'] - $headings[$i]['level']) {
								
									case 1:
										$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li></ol> ';
										$balise_ol_ouverte = $balise_ol_ouverte - 1 ;
										  break;
										  
									case 2:
										$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li></ol></ol>';
										$balise_ol_ouverte = $balise_ol_ouverte - 2;  
										  break;
										  
									case 3:
										$new_closing_tag .= '<li class="heading-level-' . $heading['level'] . '">'.'<a href="#'.sanitize_title($title) . '">' . $heading['title'] . '</a></li></ol></ol></ol>';
										$balise_ol_ouverte = $balise_ol_ouverte - 3;  
										  break;
										  
										  
								}
							
							}
							
							
						}
						
							
					}
			
				}
				
				$i++;
			
			}
			
			$new_closing_tag .= '</nav></details></div>'.$original_closing_tag;
			
			// on remplace dans le contenu du bloc la balise de fermeture originale 
			// par la nouvelle qui contient la table des matières
			$block_content = str_replace( $original_closing_tag, $new_closing_tag, $block_content );
			
			
		
		}
	
	}

	return $block_content;

}

add_filter( 'render_block', 'eccp_table_of_contents_group_block',10, 2 );


// Autre manière pour ajouter l'ancre dans la balise du titre 
// au format <h2 id="slug-titre">
// $matches[1] & $matches[4] = level du titre
// $matches[2]= attribut du titre
// $matches[3] = libellé du titre
function eccp_add_anchor_title_tag($matches){
  return '<h'.$matches[1].$matches[2].' id="'.eccp_sanitize_heading($matches[3]).'">'.$matches[3].'</h'.$matches[4].'>';
}


// Fonction pour palier aux manques de la fonction WordPress sanitize_title():
// de manière aléatoire sanitize_title() ne convertie pas un carractère accentué
// ou remplace la parenthèse '(' par rien ou un tiret
// On nettoie les titres pour les faires correspondre a des slug
// avant de pouvoir les utiliser comme référence pour les ancres
function eccp_sanitize_heading($string) {
	
	// pour le caratère & on prend son code HTML: &amp;
	$search  = array('(',')',"'",'"','′','‘','“','”','&amp;',);
	$replace = array(' ',' '," ",' ',"'","'",'"','"',' ',);

	// On supprime des caractères spéciaux comme la parenthèse du titre 
	// pour l'item de liste du sommaire par un espacement blanc. 
	// En effet l'assinissement du titre par la fonction WordPress sanitize_tittle 
	// remplace la parenthèse par rien contrairement a un espace blanc
	// qui est remplacé par un tiret,ceci afin de correspondre a une autre manière d'assainir
	// le titre de la publication  par la fonction eccp_add_anchor_title_tag($matches)
	$string = str_replace($search, $replace,$string );	
	
	$search  = array('À', 'Á', 'Â', 'Ã', 'Ä', 'Å', 'Ç', 'È', 'É', 'Ê', 'Ë', 'Ì', 'Í', 'Î', 'Ï', 'Ò', 'Ó', 'Ô', 'Õ', 'Ö', 'Ù', 'Ú', 'Û', 'Ü', 'Ý', 'à', 'á', 'â', 'ã', 'ä', 'å', 'ç', 'è', 'é', 'ê', 'ë', 'ì', 'í', 'î', 'ï', 'ð', 'ò', 'ó', 'ô', 'õ', 'ö', 'ù', 'ú', 'û', 'ü', 'ý', 'ÿ',);

	$replace = array('a', 'a', 'a', 'a', 'a', 'a', 'c', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u', 'y', 'a', 'a', 'a', 'a', 'a', 'a', 'c', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i', 'o', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u', 'y', 'y',);

	// on retourne une chaine avec les caractères accentués
	// converti en minuscule sans accent 
	// on utilise la fonction str_replace qui ne pose pas de problème en utf-8 
	// contrairement à strtr
    //	Remarque: la fonction sanitize_title() fait la même chose
	//  mais bizarement parfois elle ne converti pas un caractère accentué.
	$string = str_replace($search, $replace, $string);	
	
	// on converti les majuscules initialement non accentués restantes en minuscule 
	// seulement maintenant car  la fonction strtolower ne gère pas les accents
    //$string = strtolower($string);
	
	$string = sanitize_title($string);

    //Rendre alphanumérique (supprime tous les autres caractères)
    //$string = preg_replace("/[^a-z0-9_\s-]/", "", $string);
	
    //Nettoyer plusieurs tirets ou espaces blancs
    //$string = preg_replace("/[\s-]+/", " ", $string);
	
    //Convertir les espaces blancs et le trait de soulignement en tiret
    //$string = preg_replace("/[\s_]/", "-", $string);
	
	// Je supprime tous les tirets en début ou en fin de chaine
	// au cas ou il y aurait eu un caractère spécial en début ou fin de chaine
	$string= trim($string, '-');

    return $string;
	
}


/* Transformer le bloc Galerie de WordPress en un slider utilisant la bibliothèque Swiper */

/*
Pour Transformer le bloc Galerie de WordPress en un slider 
utilisant la bibliothèque Swiper on doit: 
• Modifier en Front End le balisage du bloc Galerie pour 
correspondre au balisage HTML  requis par Swiper
• Ajouter des styles CSS personnalisés 
• Initialiser le slider avec des paramètres spécifiques via un script JS
• charger les fichiers js & css de la librairie Swiper via un CDN


On Transforme le bloc galerie de WordPress en slider en utilisant le hook 
render_block pour modifier le balisage en front end du bloc galerie 
pour qu'il corresponde au balisage HTML de Swiper.

- Le hook render_block s'applique a la fonction eccp_render_slideshow()
- On exécute les instructions de cette fonction:
• si c'est le bloc galerie
• si on a activé le slider dans les paramètres du bloc via le 
toogle bouton ayant l'attribut withSlider
• s'il comporte des bloc d'images interne
- On parcours les blocs d'image internes aux galeries et on extrait les ID d'image, 
avec lequel on récupère les attributs: URL, width, heigth, alt
- Dans le container Principal de classe .swiper on ajoute dans le balisage HTML
différents attributs qui sont affectés avec les valeurs des attributs 
du bloc galerie pour définir:
• le délai pour la lecture automatique
• la largeur du slider
• l'alignement centré
• la navigation par points
• la navigation par flêches
• la navigation par barre de défilement
- On construit le nouveau balisage en accord avec Swiper en incorporant
des diapositives avec les éléments <div class="swiper-slide"> container
d'une balise <img> avec tous les attributs du bloc image interne du bloc galerie. 
- On termine le balisage de Swipe avec la pagination par points, 
Navigation par flêches,Barre de défilement.


La fonction eccp_enqueue_slider_swipe() ajoute du JavaScript  
via le script:eccp-slider-swiper.js pour initialiser le slider Swiper. 
• Elle définit les paramètres du slider, tels que la direction, 
la pagination, la navigation, les effets de transition, etc.
Récupère les attributs définits lors du balisage HTML du slider pour:
• Appliquer des régles CSS pour la largeur du slider, l'alignement centré ou pas
• Activer la lecture automatique ou pas

La fonction eccp_load_slider_swipe_script() est utilisée pour charger dans le head  
les scripts JavaScript et les fichiers CSS de la bibliothèque Swiper depuis un CDN.

La fonction ecpp_block_style_front_end() 
ajoute des styles CSS personnalisés pour le slider Swiper 

*/

function eccp_render_slideshow($block_content, $block) {
	
	
	// les attributs withSliderSwipe,sliderWidth, withSliderAlignCenter,
	// withSliderDots,withSliderArrows,withSliderScrollbar,
	// withSliderAutoplay,sliderAutoplayDelay
	// ont été définit en React JS pour le bloc galerie
	// wp_parse_args permet de fusionner un tableau d'arguments $block['attrs'] 
	// et un tableau de valeurs par défaut
 	$args = wp_parse_args(
	
 		$block['attrs'],
 		[
 			'withSliderSwipe' => false,
			'sliderWidth' => 720,
 			'withSliderAlignCenter' => false,
			'withSliderDots' => true,
			'withSliderArrows' => true,
			'withSliderScrollbar' => false,
 			'withSliderAutoplay' => false,
			'sliderAutoplayDelay' => 3500,
 		]
 	);
	
    // si c'est le bloc galerie
	if( 'core/gallery' === $block['blockName'] 
	// le slider est activé via l'attribut withSliderSwipe
	&& $args['withSliderSwipe']
    // La galerie contient des blocs images.
	&& !empty( $inner_blocks = $block[ 'innerBlocks' ]) ) {  
      
		// valeur par défaut pour la taille des images
		$image_size = 'full';
		
		if (array_key_exists('sizeSlug', $block['attrs'])) {
			$image_size = $block['attrs']['sizeSlug'];
		}
		
		$image_ids = array();
	
		// Parcourir les blocs d'image internes et extraire les ID d'image.
		foreach ($inner_blocks as $inner_block) {
			
			if ($inner_block['blockName'] != 'core/image') {
				// ... on ne fait rien
			} elseif (($image_id = intval($inner_block['attrs']['id'])) <= 0) {
				// ... on ne fait rien
			} else {
				$image_ids[] = $image_id;
			}
			
		}
		
		
		// Construire le nouveau balisage pour le slider avec Swiper
		
		// container du slider avec la classe swiper
		// pour	personnaliser le slider via script js
		// on ajoute différents attributs dont slider-autoplay-delay
		// si on a activé la lecture automatique du slider
		if($args['withSliderAutoplay']) {
			$block_content = '<div class="swiper" slider-autoplay-delay="' . esc_attr( $args['sliderAutoplayDelay'] ) .'"'  
			.' slider-width="' . esc_attr( $args['sliderWidth'] ) .'"' 
			.' slider-align-center="' . esc_attr( $args['withSliderAlignCenter'] ) . '"'
            .' slider-with-arrows="' . esc_attr( $args['withSliderArrows'] ) . '">';
		}else{
			$block_content = '<div class="swiper" slider-width="' . esc_attr( $args['sliderWidth'] ) .'"' 
			.' slider-align-center="' . esc_attr( $args['withSliderAlignCenter'] ).'"' .' slider-width-scrollbar="'. esc_attr( $args['withSliderScrollbar'] ) .'">';
		}
				// Additional required wrapper
				$block_content .= '<div class="swiper-wrapper">';

					// Parcourir les images du bloc galerie et les ajouter 
					// en tant que slide (diapositives)
					foreach ( $image_ids as $image_id ) { 
					
						// on récupère les attributs des images
						$image_src = wp_get_attachment_image_src ( $image_id, $image_size ) ; 
						$image_url = $image_src[0] ;
						$image_width = $image_src[1] ;
						$image_height = $image_src[2] ;
						$image_alt = get_post_meta ( $image_id, '_wp_attachment_image_alt' , true ) ; 
						
						// Chaque diapositive est une image contenu dans un élément div
						// ayant pour classe swiper-slide
						$block_content .= '<div class="swiper-slide">';
							// balisage pour agrandir l'image par geste de pincement 
							// et ou par zoom avant/arrière en appuyant deux fois
							$block_content .=	'<div class="swiper-zoom-container">';
								$block_content .= '<img src="' . esc_url($image_url) . '" width="' . esc_attr($image_width) . '" height="' . esc_attr($image_height) . '" alt="' . esc_attr($image_alt) . '">';
							$block_content .= '</div>';
						$block_content .= '</div>';
						
					}
			
				$block_content .= '</div>';// fin div wrapper
				
				// si on a activé la navigation par points
				if($args['withSliderDots']) {
					// balisage HTML pour la navigation par points 
					//en bas du slide
					$block_content .= '<div class="swiper-pagination"></div>';
				}
				
				// si on a activé la navigation par flêches
				if($args['withSliderArrows']) {
					// balisage HTML pour la navigation par flêches
					$block_content .= '<div class="swiper-button-prev"></div>';
					$block_content .= '<div class="swiper-button-next"></div>';
				}

				// si on a activé la lecture automatique 
				// et pas la navigation par flêches
				// on fait quand même le balisage pour la navigation par flêches 
				// car sinon le clic d'une flêche de navigation
				// sur un simple slider stoppe la lecture automatique de l'autre slider.
				// Le fait d'affficher les flêches de navigation par défaut sur le slider
				// a lecture automatique permet de palier au problème,
				// alors on les masquera ensuite par régles CSS dans le fichier:
				// eccp-slider-swiper.js.
				if($args['withSliderAutoplay'] && !$args['withSliderArrows']) {
					// balisage HTML pour la navigation par flêches
					$block_content .= '<div class="swiper-button-prev"></div>';
					$block_content .= '<div class="swiper-button-next"></div>';
				}

				// si on a activé la navigation par barre de défilement
				if($args['withSliderScrollbar']) {
					// balisage HTML pour la scrollbar
					$block_content .= '<div class="swiper-scrollbar"></div>';
				}
	
			$block_content .= '</div>'; // fin div container swipe

        // Retourner le nouveau balisage HTML
        return $block_content;
		
    }

    // Retourner le contenu inchangé pour les autres blocs
    return $block_content;
}

// si on a activé les scripts JS & CSS de la librairie Swiper
if ($custom_gutenberg_blocks_settings['eccp_settings_enable_script_js_css_swiper_radio_field'] == 'yes') {
	add_filter('render_block', 'eccp_render_slideshow', 10, 2);
}



/* Bloc Icônes Sociales: transformer Liens Profil en Liens de Partage */

// Comme on a  besoin d'une variable PHP après que l'utilisateur 
// ait effectué l' action de cliquer sur un bouton de partage social
// on va utiliser DOM pour passer la variable PHP à JavaScript
// en concret on utilise un div caché pour afficher notre variable sur la page HTML
// pour la récupérer ensuite par javascript avec le script: eccp-social-link-sharing.js */  
 function eccp_get_featured_image_url(){  
 
	// on réitinialise la boucle de requête WordPress
	// a la boucle de requête principale avant d'utiliser $post
	wp_reset_postdata();
 
    // la variable globale $post va nous permettre
	// d'accèder en dehors de la boucle de requête principale de WordPress
	// a l'id de la publication en cours
	global $post;
	
	// Récupérer l'image à la une pour article ou CPT
	if(is_single()) {
		
		// le deuxième argument est full pour récupèrer la taille d'origine de l'image en avant
		$featured_img_url = get_the_post_thumbnail_url($post->ID, 'full'); 
	
		?>
		<div id="data-featured-image-url" style="display:none;" >
			<?php
				echo $featured_img_url; 
			?>
		</div>
		<?php
		
	}
	
 }
 
add_action( 'wp_head','eccp_get_featured_image_url',100 );


/*----------------------------------------------------------------------------------------
		                         ADDONS REUSABLE BLOCKS BACK OFFICE
/*---------------------------------------------------------------------------------------*/


/* --------------------------- Menu Bloc réutilisable en back office ----------------------------------------------*/

function reusable_blocks_menu() {
	
    add_menu_page(
		__( 'Reusable Blocks', 'editor-custom-color-palette' ),// Page title , Text Domain(pour la traduction)
		__( 'Reusable Blocks', 'editor-custom-color-palette' ), // Menu title, Text Domain(pour la traduction)
		'edit_posts', // Capabilities (Capacités)
		'edit.php?post_type=wp_block',// URL relative
		'', // Display callback (fonction permettant l'affichage du contenu de la page de réglages)
		'dashicons-table-col-after', // Icon
		22 // Priority/position. Just after 'Page'
	);
}

/* Si on à activé le menu Blocs Réutilisables
if( $reusable_blocks_settings['eccp_activate_reusable_blocks_menu_checkbox_field'] == true ) {
	add_action('admin_menu', 'reusable_blocks_menu');
}*/

$value_menu = isset( $reusable_blocks_settings['eccp_activate_reusable_blocks_menu_checkbox_field'] ) ?  $reusable_blocks_settings['eccp_activate_reusable_blocks_menu_checkbox_field'] : false;
// Si on à activé le menu Blocs Réutilisables
if( $value_menu == true ) {
	add_action('admin_menu', 'reusable_blocks_menu');
}


/* INSERTION AUTOMATIQUE DE BLOC RÉUTILISABLE AVANT ET/OU APRÉS ARTICLES,PAGES,CPT */

/*

hook template_include:
Ce hook de filtre est exécuté immédiatement avant que WordPress n'inclue le fichier de modèle 
prédéterminé (single.php singular.php etc..)

hook the_content:
Ce filtre est utilisé pour filtrer le contenu d'un article après qu'il ait été extrait 
de la base de données et avant qu'il ne soit affiché à l'écran.
avec ce hook on doit aussi vérifier si on filtre le contenu de la requête principale 
avec les conditions is_main_query() et in_the_loop().
La requête de publication principale peut être considérée comme la boucle de publication principale 
qui affiche le contenu principal d'une publication, d'une page ou d'une archive. 
sans ces conditions, on pourrait involontairement filtrer le contenu des boucles personnalisées 
dans les barres latérales, les pieds de page ou ailleurs.

*/


function eccp_insert_content_into_posts( $template ) {

	// On récupère les paramètres de réglages de l'extension
	$reusable_blocks_settings = get_option( 'eccp_settings_reusable_blocks' );
	
	// On récupère le nom de la publication en cours
	// post: article , page, slug du CPT
	$current_post_type = get_post_type();
	
	
	/* Pour Debug 
	 echo 'Publication: '.$current_post_type;
	*/ 
	
	/*
	  Un panneau: Contenu avant/aprés publication a été crée en React JS
	  dans la barre latérale Document de l'éditeur.
      Ce panneau contient deux options pour inhiber l'insertion de blocs avant et/ou aprés
      le contenu. la valeur boolèenne des options est attribuée respectivement 
	  aux métas de publication: remove_blocks_before_content & remove_blocks_after_content
	  déclaré par la fontion PHP eccp_register_post_meta()
	  on récupère ces métas de publications avec la fonction get_post_meta
      get_post_meta( int  $post_id , string  $meta  =  '' , bool  $single  =  false  )	
      dernier argument $single = true pour indiquer qu'il faut renvoyer une valeur unique
	*/
	$remove_blocks_before_content = get_post_meta( get_the_ID(), 'remove_blocks_before_content', true );
	$remove_blocks_after_content = get_post_meta( get_the_ID(), 'remove_blocks_after_content', true );	
	
	/* Pour Debug
	echo 'Type de publication: '. $current_post_type . '<br>';
	echo 'Supprimer bloc avant contenu: '. $remove_blocks_before_content . '<br>';
	echo 'Supprimer bloc aprés contenu: '. $remove_blocks_after_content . '<br>';
	*/
	
	$existing_before_reusable_block_id = 0;
	$existing_after_reusable_block_id = 0;
	
	// On récupère l'ID des blocs réutilisables sélectionnés pour les articles dans l'onglet
	// Blocs réutilisable de la page d'option du plugin
	if ( $current_post_type == 'post'){
		$existing_before_reusable_block_id = intval( $reusable_blocks_settings['eccp_settings_insert_block_before_post_select_field'] );
		$existing_after_reusable_block_id = intval( $reusable_blocks_settings['eccp_settings_insert_block_after_post_select_field'] );
	
	// ID blocs réutilisable pour les pages
	}else if ( $current_post_type == 'page'){
		$existing_before_reusable_block_id  = intval( $reusable_blocks_settings['eccp_settings_insert_block_before_page_select_field'] );
		$existing_after_reusable_block_id = intval( $reusable_blocks_settings['eccp_settings_insert_block_after_page_select_field'] );
	
	// ID blocs réutilisable pour les CPT
	}else{
		$existing_before_reusable_block_id  = intval( $reusable_blocks_settings['eccp_settings_insert_block_before_cpt_select_field'] );
		$existing_after_reusable_block_id = intval( $reusable_blocks_settings['eccp_settings_insert_block_after_cpt_select_field'] );
	}
	
	// is_singular: Détermine si la requête concerne une publication unique existante 
	// de n'importe quel type de publication (publication, pièce jointe, page, types de publication personnalisés).
	if ( is_single() || is_singular() ) {
		
		
		// Si on a sélectionné un bloc réutilisable pour l'insérer avant le contenu 
		// et qu'on a pas supprimé cette action pour la publication en cours
		if ( ! empty( $existing_before_reusable_block_id ) && 0 !== ( $existing_before_reusable_block_id ) && !$remove_blocks_before_content ) {
			
			// on récupère un objet de publication correspondant a notre bloc réutilisable
			$before_content = get_post($existing_before_reusable_block_id);
			// on récupère le contenu de notre bloc réutilisable
			$before_content = apply_filters('the_content', $before_content->post_content ) ;

			// On filtre le contenu de la publication pour insérer au début notre bloc réutilisable
			add_filter( 'the_content', function( $content ) use ( $before_content ){ 
					
				if ( ( is_single() && in_the_loop() && is_main_query() ) || ( is_singular() && in_the_loop() && is_main_query() ) ) {

					$content = $before_content . $content;
					
				}
				
				return $content ;
				
			});
			
		}
		
		
		
		// Si on a sélectionné un bloc réutilisable pour l'insérer aprés le contenu 
		// et qu'on a pas supprimé cette action pour la publication en cours
		if ( ! empty( $existing_after_reusable_block_id ) && 0 !== ( $existing_after_reusable_block_id ) && !$remove_blocks_after_content ) {
			
			$after_content = get_post($existing_after_reusable_block_id);
			$after_content = apply_filters('the_content', $after_content->post_content ) ;
		
			// On filtre le contenu de la publication pour insérer a la fin notre bloc réutilisable
			add_filter( 'the_content', function( $content ) use ( $after_content ){ 

				if ( ( is_single() && in_the_loop() && is_main_query() ) || ( is_singular() && in_the_loop() && is_main_query() ) ) {

					$content = $content . $after_content ;
				}
				 return $content ;
			});
		
		}

	}
	
	return $template;
}

add_filter( 'template_include', 'eccp_insert_content_into_posts' );


/*--------------------- Déclaration de Métas de publication ------------------------- */

// Métas pour supprimer l'insertion de bloc Avant et/ou aprés le contenu d'une publication
// les métas de publications seront mises a jour par des options(toogle control) du panneau
// Contenu avant/aprés publication de la sidebar document 

// Métas pour sauvegarder la date d'évènement pour un compte a rebours
// établi par la variante du bloc groupe Contdown Timer.
// Cette méta est affectée par un DatePicker du panneau ECCP Countdown Timer
// des paramètes du bloc.

/*
register_post_meta( string $post_type, string $meta_key, array $args ): bool

$post_type : type de publication pour lequel enregistrer une clé méta. 
peut être 'post','page','slug CPT', 'comment', 'term', 'user'
Passez une chaîne vide pour enregistrer la clé méta sur tous 
les types de publication existants.

$meta_key : la méta clé a enregistrer

$args:tableau de paramètres pour décrire la clé méta lors de son enregistrement
single: 
Indique si la clé méta a une valeur unique:true ou un tableau de valeurs:false
show_in_rest => true  cette méta est accessible dans l'éditeur et l'API REST 
auth_callback:Une fonction à appeler lors de l'exécution des vérifications de capacité
'auth_callback' => '__return_true' évite que la méta soit visible dans les champs 
personnalisés de l'editeur, on a exactement la même chose en préfixant la méta
avec un underscore: _remove_blocks_before_content
avec une capacité d'editeur cela donne: 
'auth_callback' => function() {
			return current_user_can('edit_posts');
}
Lorsque le type de publication personnalisé(CPT) est défini pour
l'enregistrement de la méta de publication , 
le tableau de supports valeurs du CPT doit inclure custom-fields. 
par exemple
'supports' => array( 'title', 'editor', 'custom-fields' ),
Si custom-fields n'est pas inclus, la méta de publication ne fonctionnera pas
et provoquera une erreur du plugin eccp-plugin-sidebar-document définit en React JS
pour mettre a jour nos métas de publication.

*/
function eccp_register_post_meta() {
    
	register_post_meta( 
		'', 
		'remove_blocks_before_content', 
		[
			'auth_callback' => '__return_true',
			'default'       => false,
			'show_in_rest' => true,
			'single' => true,
			'type' => 'boolean',
		]
	);
	
	
	register_post_meta( 
		'', 
		'remove_blocks_after_content',
		[
			'auth_callback' => '__return_true',
			'default'       => false,
			'show_in_rest' => true,
			'single' => true,
			'type' => 'boolean',
		] 
	);
	
	register_post_meta( 
		'', 
		'countdown_timer_date_events', 
		[
			'auth_callback' => '__return_true',
			'default'       => '',
			'show_in_rest' => true,
			'single' => true,
			'type' => 'string',
		]
	);
	
}
add_action( 'init', 'eccp_register_post_meta' );



/*------ Ajout des Métas de publication dans des colonnes pour les écrans qui listent les publications -------*/


// Étape 1. Ajouter les colonnes pour les métas de publication

// On récupère les paramètres de réglages de l'extension
$reusable_blocks_settings = get_option( 'eccp_settings_reusable_blocks' );


$existing_post_before_reusable_block_id = intval( $reusable_blocks_settings['eccp_settings_insert_block_before_post_select_field'] );
$existing_post_after_reusable_block_id = intval( $reusable_blocks_settings['eccp_settings_insert_block_after_post_select_field'] );

$existing_page_before_reusable_block_id  = intval( $reusable_blocks_settings['eccp_settings_insert_block_before_page_select_field'] );
$existing_page_after_reusable_block_id = intval( $reusable_blocks_settings['eccp_settings_insert_block_after_page_select_field'] );

$existing_cpt_before_reusable_block_id  = intval( $reusable_blocks_settings['eccp_settings_insert_block_before_cpt_select_field'] );
$existing_cpt_after_reusable_block_id = intval( $reusable_blocks_settings['eccp_settings_insert_block_after_cpt_select_field'] );

	


// On boucle sur tous les CPT pour afficher les colonnes des métas de publication
// excepté pour le plugin The Events Calendar
function eccp_loop_through_custom_post_type_to_add_meta_columns() {
	
	/*
	Array(
		[0] => cours-rock4temps
		[1] => tribe_events
	)
	*/
	// On récupère les slugs des CPT sous forme d'un tableau qui est indexé de façon numérique
	$all_slug_cpt = eccp_get_slug_all_custom_post_type(); 
	
	
	/* pour debug 
		echo'<pre>';
		print_r($all_slug_cpt);
		echo'</pre>';
	*/ 
	
					
	// s'il y a des Custom Post Type
	if ( !empty( $all_slug_cpt ) ) {
	
		
		foreach ( $all_slug_cpt as $value) {
			
			// Pour le plugin The Events Calendar
			// on ne gère pas l'insertion automatique de blocs réutilisables
			// avant et/ou aprés le contenu
			if ( $value !== 'tribe_event' ) {
					
				// on utilise le hook: manage_edit-post_type_sortable_columns pour un CPT 
				// post_type est a remplacer par le slug du type de publication personnalisé
				// dans le cas du site Rock4Temps $value = cours-rock4temps
				add_filter('manage_'.$value.'_posts_columns', 'eccp_add_remove_blocks_before_and_after_content_column');
				add_action( 'manage_'.$value.'_custom_column', 'eccp_add_before_and_after_content_value',10,2 );
		
			}
		
		}
		
	}
	
}

// Pour Les Custom Post Type
// on va retarder un peu le processus global, et attendre que les plugins soient tous chargés 
// pour exécuter notre fonction.
// Le hook « plugins_Loaded » semble un peu tardif, 
// on va utiliser le hook « init »
if ( $existing_cpt_before_reusable_block_id || $existing_cpt_after_reusable_block_id   ) {
	add_action('admin_init','eccp_loop_through_custom_post_type_to_add_meta_columns');
}

// Pour les articles
if ( $existing_post_before_reusable_block_id || $existing_post_after_reusable_block_id   ) {
	add_filter( 'manage_post_posts_columns', 'eccp_add_remove_blocks_before_and_after_content_column' );
}

// Pour les pages
if ( $existing_page_before_reusable_block_id || $existing_page_after_reusable_block_id   ) {
	add_filter( 'manage_page_posts_columns', 'eccp_add_remove_blocks_before_and_after_content_column' );
}


function eccp_add_remove_blocks_before_and_after_content_column( $columns ) {

	$columns['remove_blocks_before_content'] = __('Remove blocks before content','editor-custom-color-palette'); // ID de la colonne ==> Titre de la colonne
	$columns['remove_blocks_after_content'] = __('Remove blocks after content','editor-custom-color-palette'); 
	
	return $columns;
	
}


//Étape 2. Afficher les métas de publications

// Pour les articles
add_action( 'manage_posts_custom_column', 'eccp_add_before_and_after_content_value',10,2 );

// Pour les pages
add_action( 'manage_pages_custom_column', 'eccp_add_before_and_after_content_value',10,2 );

function eccp_add_before_and_after_content_value( $column_id, $post_id ){

	
	switch( $column_id ) {
		
		case 'remove_blocks_before_content': 
			$remove_blocks_before_content = get_post_meta( $post_id,'remove_blocks_before_content',true );
			echo $remove_blocks_before_content ? __('yes','editor-custom-color-palette') : __('no','editor-custom-color-palette');
			break;
		
		case 'remove_blocks_after_content': 
			$remove_blocks_after_content = get_post_meta( $post_id,'remove_blocks_after_content',true );
			echo $remove_blocks_after_content ? __('yes','editor-custom-color-palette') : __('no','editor-custom-color-palette');			
			break;
		
		
	}

}


/*------ Ajouter des champs d'édition rapide en HTML pour les Métas de publication -------*/


// Étape 1. Ajouter des champs checkbox en HTML dans l'édition rapide

// le hook quick_edit_custom_box permet d'ajouter du HTML dans Quick Edit(edition rapide)
add_action( 'quick_edit_custom_box','eccp_quick_edit_before_after_content_fields',1,2 );

/*
Cette Fonction permet d'ajouter des champs checkbox dans l'edition rapide
Pour supprimer l'affichage des bloc réutilisables Avant Et/Ou Aprés le contenu

Pour regrouper tous les champs dans une seule balise  <fieldset>
j'ai ajouté une <fieldset> balise d'ouverture lors de l'affichage du premier champ checkbox 
et une balise de fermeture </fieldset> lors de l'affichage du dernier champ checkbox .

Les classes inline-edit-col-left,inline-edit-col,title sont native a WordPress
Nécessite le script Jquery :eccp-remove_before-after-content-quick-edit.js pour fonctionner
ce script est dans le dossier JS du plugin
Les champs HTML sont ajouté uniquement si on a activé les colonnes remove_blocks_before_content
& remove_blocks_after_content pour les écrans de publication article ou page ou CPT

*/
function eccp_quick_edit_before_after_content_fields( $column_id, $post_type ) {

	
	switch( $column_id ) {
		
		case 'remove_blocks_before_content': {
			?>
				<fieldset id="before_after_content" class="inline-edit-col-left">
				
					<span class="title">Contenu avant/aprés publication</span>
					
					<div class="inline-edit-col">
						<label>
							<input type="checkbox" id="remove-blocks-before-content" name="remove-blocks-before-content"> 
							<?php esc_html_e('Remove blocks before content','editor-custom-color-palette')?>
						</label>
					</div>
				
			<?php
			break;
		}
		
		case 'remove_blocks_after_content': {
			?>
					<div class="inline-edit-col">
						<label>
							<input id="remove-blocks-after-content" type="checkbox" name="remove-blocks-after-content"> 
							<?php esc_html_e('Remove blocks after content','editor-custom-color-palette')?>
						</label>
					</div>
					
				</fieldset>
			<?php
			break;
		}
		
	}
	
}



// Étape 2. Remplir les champs checkbox de l'edition rapide en utilisant les données des colonnes 

// on ne peut pas utiliser par exemple get_post_meta( get_the_ID(),'remove_blocks_before_content',true );
// directement a l'ETAPE 1 via le hook: quick_edit_custom_box dans l'edition rapide pour mettre a jour 
// un champ checkbox car l'ID retourné sera toujours celui du dernier message
// en effet la variable globale  $post auxquel se réfère la fonction get_the_ID()
// renvoie uniquement l'ID du dernier message car les entrées d'édition rapide ne sont créées 
// qu'une seule fois et clonées au besoin lors de l'édition rapide d'une colonne
//
// la mise a jour des champ checkbox  devra se faire avec un fichier JS
// en utilisant le hook inlineEditPost.edit qui permet de définir les valeurs d'entrée 
// le fichier JS utilisé est: eccp-remove-before-after-content-quick-edit.js
// il se trouve dans le Dossier js de l'extension



// Étape 3. Enregistrer les champs d'édition rapide 

// Enregistrer les champs pour les métas de publication après la modification rapide
add_action( 'save_post', 'eccp_remove_before_after_content_quick_edit_save' );

function eccp_remove_before_after_content_quick_edit_save( $post_id ){

	// Vérifier nonce pour inline edit
    //	Ajout isset($_POST['_inline_edit']) pour gestion erreur: undefined array key "_inline_edit"  
	if ( isset($_POST['_inline_edit']) ){
		if(!wp_verify_nonce( $_POST[ '_inline_edit' ], 'inlineeditnonce' )){
			return ;
		}  
	} 
	
	
	// on autorise la modification des métas de publication 
	// que pour les utilisateurs qui ont la capacité d' édition
	if ( !current_user_can( 'edit_post', $post_id ) ) {
        return;
    }

	// Mise a jour Métas de publication
	$remove_blocks_before_content = isset( $_POST[ 'remove-blocks-before-content' ] ) ? true : false;
	update_post_meta( $post_id, 'remove_blocks_before_content', $remove_blocks_before_content );
	
	$remove_blocks_after_content =  isset( $_POST[ 'remove-blocks-after-content' ] ) ? true : false;
	update_post_meta( $post_id, 'remove_blocks_after_content', $remove_blocks_after_content );

}


/*------ Ajouter des champs d'édition groupé en HTML pour les Métas de publication -------*/


// Étape 1.  établir l'ajout de colonne pour chaque champ de méta dans les publications
// ce qui a été fait dans la section ci-dessous:
// Cela permet d'avoir un visuel de la valeur des métas pour chaque publication
// mais n'est pas obligatoire pour l'edition groupé contrairement a l'edition rapide.

// • Ajout des Métas de publication dans des colonnes pour les écrans qui listent les publications



// Étape 2. Utilisation du hook  bulk_edit_custom_box pour faire apparaître les champs dans l'édition en bloc

// le hook quick_edit_custom_box permet d'ajouter du HTML dans l'edition groupé
add_action( 'bulk_edit_custom_box','eccp_bulk_edit_before_after_content_fields',1,2 );

/*
Cette Fonction permet d'ajouter des champs checkbox dans l'edition groupé
Pour supprimer l'affichage des bloc réutilisables Avant Et/Ou Aprés le contenu

Pour regrouper tous les champs dans une seule balise  <fieldset>
j'ai ajouté une <fieldset> balise d'ouverture lors de l'affichage du premier champ checkbox 
et une balise de fermeture </fieldset> lors de l'affichage du dernier champ checkbox .

Les classes inline-edit-col-left,inline-edit-col,title sont native a WordPress
Nécessite le script Jquery :eccp-remove_before-after-content-quick-edit.js pour fonctionner
ce script est dans le dossier JS du plugin
Les champs HTML sont ajouté uniquement si on a activé les colonnes remove_blocks_before_content
& remove_blocks_after_content pour les écrans de publication article ou page ou CPT

*/
function eccp_bulk_edit_before_after_content_fields( $column_id, $post_type ) {

	
	switch( $column_id ) {
		
		case 'remove_blocks_before_content': {
			?>
				<fieldset id="before_after_content" class="inline-edit-col-left">
				
					<span class="title">Contenu avant/aprés publication</span>
					
					<div class="inline-edit-col">
						<label>
							<input type="checkbox" id="remove-blocks-before-content" name="remove-blocks-before-content"> 
							<?php esc_html_e('Remove blocks before content','editor-custom-color-palette')?>
						</label>
					</div>
				
			<?php
			break;
		}
		
		case 'remove_blocks_after_content': {
			?>
					<div class="inline-edit-col">
						<label>
							<input id="remove-blocks-after-content" type="checkbox" name="remove-blocks-after-content"> 
							<?php esc_html_e('Remove blocks after content','editor-custom-color-palette')?>
						</label>
					</div>
					
				</fieldset>
			<?php
			break;
		}
		
	}
	
}


// Étape 3. Enregistrer les champs d'édition groupé

// Enregistrer les champs pour les métas de publication après la modification groupé
// on va obtenir les données des cases a cocher avec $_REQUEST, et non $_POST
add_action( 'save_post', 'eccp_remove_before_after_content_bulk_edit_save' );

function eccp_remove_before_after_content_bulk_edit_save( $post_id ){

	// Vérifier nonce de l'edition groupé pour les articles & CPT par bulk-posts  
	// bulk-pages pour les pages
	//	Ajout isset($_REQUEST['_wpnonce']) pour gestion erreur: undefined array key "_wpnonce" 	
	if ( isset($_REQUEST['_wpnonce']) ){
		if( !wp_verify_nonce( $_REQUEST[ '_wpnonce' ], 'bulk-posts' ) ){
			return ;
		}  
	} 
	
	// on autorise la modification des métas de publication 
	// que pour les utilisateurs qui ont la capacité d' édition
	if ( !current_user_can( 'edit_post', $post_id ) ) {
        return;
    }
	
	// Mise a jour Métas de publication
	$remove_blocks_before_content = isset( $_REQUEST[ 'remove-blocks-before-content' ] ) ? true : false;
	update_post_meta( $post_id, 'remove_blocks_before_content', $remove_blocks_before_content );
	
	$remove_blocks_after_content =  isset( $_REQUEST[ 'remove-blocks-after-content' ] ) ? true : false;
	update_post_meta( $post_id, 'remove_blocks_after_content', $remove_blocks_after_content );

}

/* -------------- AFFICHER PAR SHORTCODE UN BLOC RÉUTILISABLE SELON SON ID -------------------*/

/* Les blocs réutilisables sont des types de publication appropriés
   qui ont pour nom: wp_block
   On a juste juste besoin de connaître l'ID du bloc réutilisable
   Pour les afficher en dehors du contexte d'une publication/page.
   l'ID se trouve dans l'URL de l'écran d'édition du bloc réutilisable
*/

// exemple d'utilisation du shortcode: [reusable_block id="8370"]

// la fonction shortcode_atts() permet de combiner l'attribut 'id'
// avec l'ID fourni par l'utilisateur dans la balise shortcode[]  
// l'ID utilisateur étant retourné par $atts 
// les noms d'attribut doivent être en minuscule
// extract permet de créer une variable a partir d'un tableau
// extract retourne $id


$reusable_blocks_shortcode = isset( $reusable_blocks_settings['eccp_activate_reusable_blocks_shortcode_checkbox_field'] ) ?  $reusable_blocks_settings['eccp_activate_reusable_blocks_shortcode_checkbox_field'] : false;


function eccp_reusable_blocks_shortcode( $atts ) {
	
	extract( shortcode_atts( array(
		'id' => '',
	), $atts ) );
	// fonction eccp_reusable_block définit ci_dessous
    // FONCTION POUR AFFICHER DANS LE THEME UN BLOC RÉUTILISABLE SELON SON ID	
	$content = eccp_reusable_block( $id );
	return $content;
	
}

// si on a activé les shortcodes pour les blocs réutilisables
if( $reusable_blocks_shortcode == true ) {
	add_shortcode( 'reusable_block', 'eccp_reusable_blocks_shortcode' );
}

/*-------- FONCTION POUR AFFICHER DANS LE THEME UN BLOC RÉUTILISABLE SELON SON ID -------*/

/* Nous pouvons appeler cette fonction n'importe où dans notre thème, 
  pour afficher nos blocs réutilisables simplement en fournissant leur ID
  ex: echo eccp_reusable_block(8370);
  On utilise le filtre the_content pour formater correctement le contenu avant 
  d'afficher le bloc réutilisable.
*/
function eccp_reusable_block( $id ) {
	
	$content_post = get_post( $id );
	$content = apply_filters('the_content',$content_post->post_content);
   
    return $content;
	
}


/*------ Ajout de la colonne Intégration dans la page d'administration des blocs réutilisables ---------*/

/* Fonction Ajout de la colonne Intégration et Réorganisation des colonnes */ 
function eccp_reusable_screen_add_columns($columns){
	
    $custom_col_order = array(
        'cb' => $columns['cb'],
        'title' => $columns['title'],
        'reusable-block-display' => esc_html__ ( 'Integration' , 'editor-custom-color-palette' ),
        'date' => $columns['date']
    );
	
    return $custom_col_order;
}

// si on a activé les shortcodes pour les blocs réutilisables
// on utilise le hook: manage_post_type_posts_columns  
// post-type est a remplacer par le slug du type de publication personnalisé
// dans note cas wp_block
if( $reusable_blocks_shortcode == true ) {
 add_filter('manage_wp_block_posts_columns', 'eccp_reusable_screen_add_columns');
}


/*--- Afficher les shortcodes dans la colonne Intégration pour la page d'adminitration des blocs réutilisables ---*/

// Pour afficher les shortcodes et fonction PHP dans la colonne Intégration
// on utilise les balises <p> et <code> dont le style
// est déja géré en admin par WordPress

function eccp_reusable_screen_column_value( $column_name, $id ) {
   

   switch ( $column_name ) {
		
		// On récupère l''id d'un bloc réutilisable
		case 'reusable-block-display':
			echo '<p>'.esc_html__ ( 'Shortcode' , 'editor-custom-color-palette' ). ':<code>[reusable_block id=\''.$id.'\']</code></p>';
			echo '<p>'.esc_html__ ( 'PHP Function' , 'editor-custom-color-palette' ). ':<code>eccp_reusable_block('.$id.')</code></p>';
			//eccp_display_modal($id);
			
			break;
			
		default :
			break;
			
    }
}

// si on a activé les shortcodes pour les blocs réutilisables
if( $reusable_blocks_shortcode == true ) {
	
	// pour personnaliser la page d'administration des blocs réutilisables 
	// on utilise le  hook : manage_wp_block_posts_custom_column   
	add_action('manage_wp_block_posts_custom_column', 'eccp_reusable_screen_column_value',1000, 2);

}

/*-------------- AFFICHER UNE FENÊTRE MODALE----------------*/

/*

1er) Utiliser la fonction de WP add_thickbox() pour charger
le script js et le style css intégrés au core pour la librairie
modifié thickbox de Jquery.
ceci est fait dans la rubrique: chargement scripts du plugin

2ème) Ajout d'un bouton avec la classe="thickbox" 
l'url associé a href est une ancre: #TB_inline
avec passage des paramètres suivant:
width, height, pour la résolution de la fenêtre en pixel
le paramètre inlineId permet de lier le bouton 
au container <div> de la fenêtre modale dont l'id a la même valeur.
title permet de donner un titre a la fenêtre modale

3ème)Le contenu qui va dans notre fenêtre modale sera mis 
dans une balise div avec un id de même valeur que le paramètre inlineId 
et la régle style="display:none ;" 
c'est le click sur le bouton qui fera apparaitre le contenu

Remarque: le bloc réutilisable est bien affiché mais sans le style
a part pour certains blocs de Kadence Block dont le style est enregistré
dans le HTML du block
En définitive il faut pouvoir charger les styles appliqués aux blocs Gutenberg,
aux plugins ainsi que le style du thème courant dans la fenêtre modale.
donc l'API Tickbox ne convient pas, il faut utiliser Jquery UI dialog 
avec une iframe dont le contenu est chargé par Java Script, avec une structure
HTML équivalente a une page:
<iframe>
	<html>
		<head>
			<style>
			</style>
		</head>
		<body>
		....Contenu
		</body>
	</html>
</iframe>

Le contenu de l'iframe sera chargé par ces lignes JS

var doc = document.getElementById( current_iframe_id ).contentWindow.document;
doc.open();
doc.write( iframe_content );
doc.close();		

*/


function eccp_display_modal($id) {
	 
?>

	<div id="content-modal-<?php echo $id; ?>" style="display:none;" >
		
			<?php //echo do_shortcode('[reusable_block id=.\''.$id.'\']'); ?>
			<?php  echo eccp_reusable_block($id); ?>
		
	</div>

	<a  class=" thickbox button button-secondary button-small eccp-button-preview"  href="#TB_inline?&width=800&height=550&inlineId=content-modal-<?php echo $id; ?>" 
	    title="<?php echo esc_html__ ( 'Reusable Block preview: ', 'editor-custom-color-palette' ) . esc_html__ ( get_the_title( $id ) ); ?>">
		
		<?php esc_html_e( 'Preview', 'editor-custom-color-palette' ); ?>
	
	</a>	

<?php

}


/*----------------------------------------------------------------------------------------
		  Créer une catégorie de bloc personnalisée dans WordPress Block Inserter
/*---------------------------------------------------------------------------------------*/

/* ANCIEN CODE OU ON VIENT SIMPLMENT ENTRER LA NOUVELLE CATÉGORIES
   EN FIN DES CATÉGORIES
function eccp_plugin_block_categories( $block_categories,$block_editor_context ) {
	
	// Vérifie le contexte de ce filtre, renvoie la valeur par défaut 
	// s'il n'est pas dans l'éditeur de bloc.
	if ( ! ( $block_editor_context instanceof WP_Block_Editor_Context ) ) {
        return $block_categories;
    }
		
    return array_merge(
        $block_categories,
        [
            [
                'slug'  => 'eccp-blocks',
                'title' => __( 'ECCP Custom Blocks', 'editor-custom-color-palette' ),
            ],
        ]
    );
	
}
*/

function eccp_plugin_block_categories( $block_categories,$block_editor_context ) {
	
	// Vérifie le contexte de ce filtre, renvoie la valeur par défaut 
	// s'il n'est pas dans l'éditeur de bloc.
	if ( ! ( $block_editor_context instanceof WP_Block_Editor_Context ) ) {
        return $block_categories;
    }

	// créer un nouvel élément de tableau avec n'importe quoi comme index
	$new_categorie = array(
		'eccpindex' => array(
			'slug'  => 'eccp-blocks',
			'title' => __( 'ECCP Custom Blocks', 'editor-custom-color-palette' ),
		)
	);

	// On rensigne ici à quelle position notre catégorie personnalisée doit apparaître
	// sachant que l'index du tableau des catégories de bloc commence a 0
	$position = 2; // 2: Après Text et Media, donc techniquement c'est une 3ème position

	
	// array_slice(array , position, longueur, ne pas réordonner les indices)
	// si longueur est null ou omis alors on retourne tout les éléments depuis 
	// la position offset jusqu'à la fin du tableau.
	$block_categories= array_slice( $block_categories, 0, $position, true ) + $new_categorie + array_slice( $block_categories, $position, null, true );

	// array_values permet de réindexer numériquement le tableau
	$block_categories = array_values( $block_categories );

	return $block_categories;

}


// ce hook nécessite wordpress > 5.8 
// il filtre le tableau de catégories par défaut pour les types de bloc
// et vient inésérer la nouvelle catégorie en troisième position
// $block_editor_context permet aussi de filtrer en fonction du contenu de l'editeur Page, Article etc..
add_action( 'block_categories_all', 'eccp_plugin_block_categories', 10, 2 );


/*----------------------------------------------------------------------------------------
		  AJOUT AUX PARAMÉTRES DU BLOC PARAGRAPHE DE STYLES PERSONNALISÉS
/*---------------------------------------------------------------------------------------*/


add_action( 'after_setup_theme', 'eccp_register_block_paragraph_styles' );

function eccp_register_block_paragraph_styles(){
	
	// on récupère les paramètres pour la personnalisation des blocs Gutenberg
	$custom_gutenberg_blocks_settings = get_option( 'eccp_settings_custom_gutenberg_block' );
	
	
	/* ----------------------------- Add Style Box Shadow(bloc paragraphe & bloc grouper & bloc colonne) ---------------------------------------*/
	
	// modif version 2.8 , le style box shadows est directement appliqué 
	// dans les paramètres du bloc
	
	/*
	Ajout d'un style Box Shadow(Ombre de boite)au bloc paragraphe & bloc grouper & bloc colonne
	La register_block_style fonction reçoit le nom du bloc comme premier argument 
	et un tableau décrivant les propriétés du style comme deuxième argument.
	name: L'identifiant ou slug du style utilisé pour la classe CSS du bloc
	label: etiquette pour identifier le nouveau style dans les paramètres du bloc
	Le nom de classe de style  pour le bloc est automatiquement créé en utilisant le format suivant :
	is-style-name avec name: identifiant ou slug du style déclaré
	le nom de la classe pour appliquer le nouveau style au bloc paragraphe est donc is-style-eccp-box-shadow 
	Il est également possible de définir la propriété 'is_default' => true, pour définir 
	ce style comme  le style par défaut pour le bloc
	*/
	
	/* si on a activé l'effet Box Shadow pour le bloc paragraphe
	if( $custom_gutenberg_blocks_settings['eccp_settings_activate_box_shadow_paragraph_block_radio_field'] == 'yes' ) {
	
		register_block_style(
			'core/paragraph',
			array(
				'name'  => 'eccp-box-shadow',
				'label' => __( 'Box Shadow', 'editor-custom-color-palette' ),
			)
		);
		
		register_block_style(
			'core/group',
			array(
				'name'  => 'eccp-box-shadow',
				'label' => __( 'Box Shadow', 'editor-custom-color-palette' ),
			)
		);
		
		register_block_style(
			'core/column',
			array(
				'name'  => 'eccp-box-shadow',
				'label' => __( 'Box Shadow', 'editor-custom-color-palette' ),
			)
		);
	
	}
   
	*/
   
	/* ----------------------------- Add Style Card ---------------------------------------*/
	
	if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_card_paragraph_radio_field'] == 'yes' ) {
		
		register_block_style(
			'core/paragraph',
			array(
				'name'  => 'eccp-card',
				'label' => __( 'Card', 'editor-custom-color-palette' ),
			)
		);
		
	}
   
   /* ----------------------------- Add Style Notice: Question ---------------------------------------*/
	
	if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_question_radio_field'] == 'yes' ) {
		
		register_block_style(
			'core/paragraph',
			array(
				'name'  => 'eccp-notice-question',
				'label' => __( 'Notice: Question', 'editor-custom-color-palette' ),
			)
		);
		
		register_block_style(
			'core/group',
			array(
				'name'  => 'eccp-notice-question',
				'label' => __( 'Notice: Question', 'editor-custom-color-palette' ),
			)
		);
		
		
	}
	
	/* ----------------------------- Add Style Notice: Info ---------------------------------------*/
	
	if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_info_radio_field'] == 'yes' ) {
		
		register_block_style(
			'core/paragraph',
			array(
				'name'  => 'eccp-notice-info',
				'label' => __( 'Notice: Info', 'editor-custom-color-palette' ),
			)
		);
		
		register_block_style(
			'core/group',
			array(
				'name'  => 'eccp-notice-info',
				'label' => __( 'Notice: Info', 'editor-custom-color-palette' ),
			)
		);
		
	}
	
	/* ----------------------------- Add Style Notice: Advice ---------------------------------------*/
	
	if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_advice_radio_field'] == 'yes' ) {
		
		register_block_style(
			'core/paragraph',
			array(
				'name'  => 'eccp-notice-advice',
				'label' => __( 'Notice: Advice', 'editor-custom-color-palette' ),
			)
		);
		
		register_block_style(
			'core/group',
			array(
				'name'  => 'eccp-notice-advice',
				'label' => __( 'Notice: Advice', 'editor-custom-color-palette' ),
			)
		);
		
	}
	
	/* ----------------------------- Add Style Notice: Warning ---------------------------------------*/
	
	if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_warning_radio_field'] == 'yes' ) {
		
		register_block_style(
			'core/paragraph',
			array(
				'name'  => 'eccp-notice-warning',
				'label' => __( 'Notice: Warning', 'editor-custom-color-palette' ),
			)
		);
		
		register_block_style(
			'core/group',
			array(
				'name'  => 'eccp-notice-warning',
				'label' => __( 'Notice: Warning', 'editor-custom-color-palette' ),
			)
		);
		
	}
	
	/* ----------------------------- Add Style Notice: Alert ---------------------------------------*/
	
	if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_alert_radio_field'] == 'yes' ) {
		
		register_block_style(
			'core/paragraph',
			array(
				'name'  => 'eccp-notice-alert',
				'label' => __( 'Notice: Alert', 'editor-custom-color-palette' ),
			)
		);
		
		register_block_style(
			'core/group',
			array(
				'name'  => 'eccp-notice-alert',
				'label' => __( 'Notice: Alert', 'editor-custom-color-palette' ),
			)
		);
		
	}
   
   
	/* ----------------------------- Add Style Click to Tweet ---------------------------------------*/
	
	if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_click_to_tweet_radio_field'] == 'yes' ) {
		
		register_block_style(
			'core/paragraph',
			array(
				'name'  => 'eccp-tweet',
				'label' => __( 'Click to Tweet', 'editor-custom-color-palette' ),
			)
		);
		
	}
	
	
	/* ----------------------------- Add Style Evidence ---------------------------------------*/

		
		register_block_style(
			'core/paragraph',
			array(
				'name'  => 'eccp-evidence',
				'label' => __( 'Evidence', 'editor-custom-color-palette' ),
			)
		);
		
}

/*----------------------------------------------------------------------------------------
		  AJOUT AUX PARAMÉTRES DU BLOC LISTE DE STYLES PERSONNALISÉS
/*---------------------------------------------------------------------------------------*/


if( $custom_gutenberg_blocks_settings['eccp_settings_activate_styles_bullet_list_radio_field'] == 'yes' ) {
	add_action( 'after_setup_theme', 'eccp_register_block_liste_styles' );
}

function eccp_register_block_liste_styles(){
	
	// on récupère les paramètres pour la personnalisation des blocs Gutenberg
	$custom_gutenberg_blocks_settings = get_option( 'eccp_settings_custom_gutenberg_block' );
	
	
	/* ----------------------------- Add Style Square  ---------------------------------------*/
	
	/*
	Ajout d'un style Square au bloc Liste 
	La register_block_style fonction reçoit le nom du bloc comme premier argument 
	et un tableau décrivant les propriétés du style comme deuxième argument.
	name: L'identifiant ou slug du style utilisé pour la classe CSS du bloc
	label: etiquette pour identifier le nouveau style dans les paramètres du bloc
	Le nom de classe de style  pour le bloc est automatiquement créé en utilisant le format suivant :
	is-style-name avec name: identifiant ou slug du style déclaré
	le nom de la classe pour appliquer le nouveau style au bloc Liste est donc is-style-eccp-square-bullet-list 
	Il est également possible de définir la propriété 'is_default' => true, pour définir 
	ce style comme  le style par défaut pour le bloc
	*/
		
	register_block_style(
		'core/list',
		array(
			'name'  => 'eccp-square-bullet-list',
			'label' => __( 'Square', 'editor-custom-color-palette' ),
		)
	);
		
	/* ----------------------------- Add Style Check  ---------------------------------------*/
	
	register_block_style(
		'core/list',
		array(
			'name'  => 'eccp-check-bullet-list',
			'label' => __( 'Check', 'editor-custom-color-palette' ),
		)
	);
	
	/* ----------------------------- Add Style Check circle fill  ---------------------------*/
	
	register_block_style(
		'core/list',
		array(
			'name'  => 'eccp-check-circle-fill-bullet-list',
			'label' => __( 'Check circle fill', 'editor-custom-color-palette' ),
		)
	);
	
	
	/* ----------------------------- Add Style Add  ---------------------------------------*/
	
	register_block_style(
		'core/list',
		array(
			'name'  => 'eccp-add-bullet-list',
			'label' => __( 'Add', 'editor-custom-color-palette' ),
		)
	);
	
	
	/* ----------------------------- Add Style Add circle fill  ---------------------------------------*/
	
	register_block_style(
		'core/list',
		array(
			'name'  => 'eccp-add-circle-fill-bullet-list',
			'label' => __( 'Add circle fill', 'editor-custom-color-palette' ),
		)
	);
	
	
	/* ----------------------------- Add Style Push spin  ---------------------------------------*/
	
	register_block_style(
		'core/list',
		array(
			'name'  => 'eccp-push-spin-bullet-list',
			'label' => __( 'Push spin', 'editor-custom-color-palette' ),
		)
	);
	
	
	/* ----------------------------- Add Style Circle Duotone  ---------------------------------------*/
	
	register_block_style(
		'core/list',
		array(
			'name'  => 'eccp-circle-duotone-bullet-list',
			'label' => __( 'Circle duotone', 'editor-custom-color-palette' ),
		)
	);
	
	
	/* ----------------------------- Add Style Clear  ---------------------------------------*/
	
	register_block_style(
		'core/list',
		array(
			'name'  => 'eccp-clear-bullet-list',
			'label' => __( 'No', 'editor-custom-color-palette' ),
		)
	);
	
	/* ----------------------------- Add Style Clear  ---------------------------------------*/
	
	register_block_style(
		'core/list',
		array(
			'name'  => 'eccp-clear-bullet-list',
			'label' => __( 'No', 'editor-custom-color-palette' ),
		)
	);
	
	
	/* ----------------------------- Add Style Site  ---------------------------------------*/
	
	register_block_style(
		'core/list',
		array(
			'name'  => 'eccp-site-bullet-list',
			'label' => __( 'Site', 'editor-custom-color-palette' ),
		)
	);
	
	
	/* ----------------------------- Add Style E-Mail  ---------------------------------------*/
	
	register_block_style(
		'core/list',
		array(
			'name'  => 'eccp-mail-bullet-list',
			'label' => __( 'E-Mail', 'editor-custom-color-palette' ),
		)
	);
	
	
	/* ----------------------------- Add Style Phone  ---------------------------------------*/
	
	register_block_style(
		'core/list',
		array(
			'name'  => 'eccp-phone-bullet-list',
			'label' => __( 'Phone', 'editor-custom-color-palette' ),
		)
	);
	
	
	/* ----------------------------- Add Style Facebook  ---------------------------------------*/
	
	register_block_style(
		'core/list',
		array(
			'name'  => 'eccp-facebook-bullet-list',
			'label' => __( 'Facebook', 'editor-custom-color-palette' ),
		)
	);
	
	/* ----------------------------- Add Style YouTube  ---------------------------------------*/
	
	register_block_style(
		'core/list',
		array(
			'name'  => 'eccp-youtube-bullet-list',
			'label' => __( 'YouTube', 'editor-custom-color-palette' ),
		)
	);
		
	/* ----------------------------- Add Style Twiter  ---------------------------------------*/
	
	register_block_style(
		'core/list',
		array(
			'name'  => 'eccp-twiter-bullet-list',
			'label' => __( 'Twiter', 'editor-custom-color-palette' ),
		)
	);
	
	/* ----------------------------- Add Style Pinterest  ---------------------------------------*/
	
	register_block_style(
		'core/list',
		array(
			'name'  => 'eccp-pinterest-bullet-list',
			'label' => __( 'Pinterest', 'editor-custom-color-palette' ),
		)
	);

	/* ----------------------------- Add Style Instagram  ---------------------------------------*/
	
	register_block_style(
		'core/list',
		array(
			'name'  => 'eccp-instagram-bullet-list',
			'label' => __( 'Instagram', 'editor-custom-color-palette' ),
		)
	);

	/* ----------------------------- Add Style LinkedIn  ---------------------------------------*/
	
	register_block_style(
		'core/list',
		array(
			'name'  => 'eccp-linkedin-bullet-list',
			'label' => __( 'LinkedIn', 'editor-custom-color-palette' ),
		)
	);
	
	/* ----------------------------- Add Style Whatsapp  ---------------------------------------*/
	
	register_block_style(
		'core/list',
		array(
			'name'  => 'eccp-whatsapp-bullet-list',
			'label' => __( 'Whatsapp', 'editor-custom-color-palette' ),
		)
	);
	
	/* ----------------------------- Add Style Calendar  ---------------------------------------*/
	
	register_block_style(
		'core/list',
		array(
			'name'  => 'eccp-calendar-bullet-list',
			'label' => __( 'Calendar', 'editor-custom-color-palette' ),
		)
	);
	
	/* ----------------------------- Add Style Clock  ---------------------------------------*/
	
	register_block_style(
		'core/list',
		array(
			'name'  => 'eccp-clock-bullet-list',
			'label' => __( 'Clock', 'editor-custom-color-palette' ),
		)
	);
	
	/* ----------------------------- Add Style Location  ---------------------------------------*/
	
	register_block_style(
		'core/list',
		array(
			'name'  => 'eccp-location-bullet-list',
			'label' => __( 'Location', 'editor-custom-color-palette' ),
		)
	);
	
	/* ----------------------------- Add Style Diagram  ---------------------------------------*/
	
	register_block_style(
		'core/list',
		array(
			'name'  => 'eccp-tree-bullet-list',
			'label' => __( 'Diagram', 'editor-custom-color-palette' ),
		)
	);
	
	/* ----------------------------- Add ordonned disk-style(Liste ordonnée de style Disque)  ---------------------------------------*/
	
	register_block_style(
		'core/list',
		array(
			'name'  => 'eccp-ordonned-disk-bullet-list',
			'label' => __( 'Ordonned disk', 'editor-custom-color-palette' ),
		)
	);
	
	
	/* ----------------------------- Add Style Accordion  ---------------------------------------*/
	register_block_style(
		'core/list',
		array(
			'name'  => 'eccp-accordion-bullet-list',
			'label' => __( 'Accordion', 'editor-custom-color-palette' ),
		)
	);
	
	/* ----------------------------- Add Style Table Of Contents  ---------------------------------------*/
	register_block_style(
		'core/list',
		array(
			'name'  => 'eccp-table-of-contents-bullet-list',
			'label' => __( 'Table Of Contents', 'editor-custom-color-palette' ),
		)
	);
	
	
}

/*----------------------------------------------------------------------------------------
		  AJOUT AUX PARAMÉTRES DU BLOC GROUPE DE STYLES PERSONNALISÉS
/*---------------------------------------------------------------------------------------*/

add_action( 'after_setup_theme', 'eccp_register_block_group_styles' );

function eccp_register_block_group_styles(){
	
	// on récupère les paramètres pour la personnalisation des blocs Gutenberg
	$custom_gutenberg_blocks_settings = get_option( 'eccp_settings_custom_gutenberg_block' );
	
	
	/* ----------------------------- Add Style Table Of Contents  ---------------------------------------*/
	
	/*
	Ajout d'un style Table Of Contents au bloc Groupe 
	La register_block_style fonction reçoit le nom du bloc comme premier argument 
	et un tableau décrivant les propriétés du style comme deuxième argument.
	name: L'identifiant ou slug du style utilisé pour la classe CSS du bloc
	label: etiquette pour identifier le nouveau style dans les paramètres du bloc
	Le nom de classe de style  pour le bloc est automatiquement créé en utilisant le format suivant :
	is-style-name avec name: identifiant ou slug du style déclaré
	le nom de la classe pour appliquer le nouveau style au bloc groupe est donc is-style-eccp-toc 
	Il est également possible de définir la propriété 'is_default' => true, pour définir 
	ce style comme le style par défaut pour le bloc
	*/
	
	register_block_style(
		'core/group',
		array(
			'name'  => 'eccp-toc',
			'label' => __( 'Table Of Contents', 'editor-custom-color-palette' ),
		)
	);
   
	

}

/*----------------------------------------------------------------------------------------
		  AJOUT AUX PARAMÉTRES DU BLOC IMAGE DE STYLES PERSONNALISÉS
/*---------------------------------------------------------------------------------------*/


add_action( 'after_setup_theme', 'eccp_register_block_image_styles' );

function eccp_register_block_image_styles(){
	
	// on récupère les paramètres pour la personnalisation des blocs Gutenberg
	$custom_gutenberg_blocks_settings = get_option( 'eccp_settings_custom_gutenberg_block' );
	
	
	/* ----------------------------- Add Style Circle  ---------------------------------------*/
	
	/*
	Ajout d'un style Circle au bloc paragraphe 
	La register_block_style fonction reçoit le nom du bloc comme premier argument 
	et un tableau décrivant les propriétés du style comme deuxième argument.
	name: L'identifiant ou slug du style utilisé pour la classe CSS du bloc
	label: etiquette pour identifier le nouveau style dans les paramètres du bloc
	Le nom de classe de style  pour le bloc est automatiquement créé en utilisant le format suivant :
	is-style-name avec name: identifiant ou slug du style déclaré
	le nom de la classe pour appliquer le nouveau style au bloc image est donc is-style-eccp-image-circle-4-3 
	Il est également possible de définir la propriété 'is_default' => true, pour définir 
	ce style comme  le style par défaut pour le bloc
	Remarque: WordPress a déja une classe prédéfini pour appliquer un masque circulaire: is-style-circle-mask
	*/
	
	// si on a activé le style Circle pour le bloc Image
	if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_image_circle_radio_field'] == 'yes' ) {
	
		register_block_style(
			'core/image',
			array(
				'name'  => 'eccp-image-circle-4-3',
				'label' => __( 'Circle img 4/3', 'editor-custom-color-palette' ),
			)
		);
		
		
		register_block_style(
			'core/image',
			array(
				'name'  => 'eccp-image-circle-16-9',
				'label' => __( 'Circle img 16/9', 'editor-custom-color-palette' ),
			)
		);
		
	}
	
	
	/* ----------------------------- Add Style Filter Grayscale ---------------------------------------*/
	
	if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_image_filter_grayscale_radio_field'] == 'yes' ) {
		
		register_block_style(
			'core/image',
			array(
				'name'  => 'eccp-filter-grayscale',
				'label' => __( 'Filter: Grayscale', 'editor-custom-color-palette' ),
			)
		);
		
	}
	
	/* ----------------------------- Add Style Image Card ---------------------------------------*/
	
	if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_image_card_radio_field'] == 'yes' ) {
		
		register_block_style(
			'core/image',
			array(
				'name'  => 'eccp-card-image',
				'label' => __( 'Card', 'editor-custom-color-palette' ),
			)
		);
		
	}
   
	

}


/*----------------------------------------------------------------------------------------
		  AJOUT AUX PARAMÉTRES DU BLOC BOUTON DE STYLES PERSONNALISÉS
/*---------------------------------------------------------------------------------------*/

add_action( 'after_setup_theme', 'eccp_register_block_buttons_styles' );

function eccp_register_block_buttons_styles(){
	
	// on récupère les paramètres pour la personnalisation des blocs Gutenberg
	$custom_gutenberg_blocks_settings = get_option( 'eccp_settings_custom_gutenberg_block' );
	
	
	// si on a activé les styles pour le bloc boutons
	if( $custom_gutenberg_blocks_settings['eccp_settings_activate_button_styles_hover_radio_field'] == 'yes' ) {
	
		/* ----------------------------- Add style Outline hover arrow  ---------------------------------------*/
		
		/*
		Ajout d'un style Outline hover arrow au bloc bouton 
		La register_block_style fonction reçoit le nom du bloc comme premier argument 
		et un tableau décrivant les propriétés du style comme deuxième argument.
		name: L'identifiant ou slug du style utilisé pour la classe CSS du bloc
		label: etiquette pour identifier le nouveau style dans les paramètres du bloc
		Le nom de classe de style  pour le bloc est automatiquement créé en utilisant le format suivant :
		is-style-name avec name: identifiant ou slug du style déclaré
		le nom de la classe pour appliquer le nouveau style au bloc bouton est donc is-style-eccp-outlinehover-arrow 
		Il est également possible de définir la propriété 'is_default' => true, pour définir 
		ce style comme  le style par défaut pour le bloc
		*/
	
		register_block_style(
			'core/button',
			array(
				'name'  => 'eccp-outline-hover-arrow',
				'label' => __( 'Outline hover arrow', 'editor-custom-color-palette' ),
			)
		);
	
		/* ----------------------------- Add style Download  ---------------------------------------*/
	
		register_block_style(
			'core/button',
			array(
				'name'  => 'eccp-download',
				'label' => __( 'Download', 'editor-custom-color-palette' ),
			)
		);
	
		
	}
	
}




/*----------------------------------------------------------------------------------------
		  AJOUT AUX PARAMÉTRES DU BLOC PARENT COLONNES DE STYLES PERSONNALISÉS
/*---------------------------------------------------------------------------------------*/


add_action( 'after_setup_theme', 'eccp_register_block_columns_styles' );

function eccp_register_block_columns_styles(){
	
	// on récupère les paramètres pour la personnalisation des blocs Gutenberg
	$custom_gutenberg_blocks_settings = get_option( 'eccp_settings_custom_gutenberg_block' );
	
	
	// si on a activé les styles pour le bloc parent colonnes
	if( $custom_gutenberg_blocks_settings['eccp_settings_activate_columns_block_styles_radio_field'] == 'yes' ) {
	
		/* ----------------------------- Add Style Column reverse  ---------------------------------------*/
		
		/*
		Ajout d'un style Column reverse au bloc parent colonnes 
		La register_block_style fonction reçoit le nom du bloc comme premier argument 
		et un tableau décrivant les propriétés du style comme deuxième argument.
		name: L'identifiant ou slug du style utilisé pour la classe CSS du bloc
		label: etiquette pour identifier le nouveau style dans les paramètres du bloc
		Le nom de classe de style  pour le bloc est automatiquement créé en utilisant le format suivant :
		is-style-name avec name: identifiant ou slug du style déclaré
		le nom de la classe pour appliquer le nouveau style au bloc image est donc is-style-eccp-column-reverse 
		Il est également possible de définir la propriété 'is_default' => true, pour définir 
		ce style comme  le style par défaut pour le bloc
		*/
	
		register_block_style(
			'core/columns',
			array(
				'name'  => 'eccp-column-reverse',
				'label' => __( 'Columns reverse mobile', 'editor-custom-color-palette' ),
			)
		);
		
		/* ----------------------------- Add Style Responsive three columns  ---------------------------------------*/
		
		register_block_style(
			'core/columns',
			array(
				'name'  => 'eccp-responsive-three-columns',
				'label' => __( 'Responsive three columns', 'editor-custom-color-palette' ),
			)
		);
		
		
	}
	
}

/*----------------------------------------------------------------------------------------
		  AJOUT AUX PARAMÉTRES DU BLOC MÉDIA & TEXTE DE STYLES PERSONNALISÉS
/*---------------------------------------------------------------------------------------*/

add_action( 'after_setup_theme', 'eccp_register_block_media_texte_styles' );

function eccp_register_block_media_texte_styles(){
	
	// on récupère les paramètres pour la personnalisation des blocs Gutenberg
	$custom_gutenberg_blocks_settings = get_option( 'eccp_settings_custom_gutenberg_block' );
	
	
	// si on a activé les styles pour le bloc Média & Texte
	if( $custom_gutenberg_blocks_settings['eccp_settings_activate_media_text_block_styles_radio_field'] == 'yes' ) {
	
		/* ----------------------------- Add Style Half Background  ---------------------------------------*/
		
		/*
		Ajout d'un style Half Background au bloc pmédia & texte 
		La register_block_style fonction reçoit le nom du bloc comme premier argument 
		et un tableau décrivant les propriétés du style comme deuxième argument.
		name: L'identifiant ou slug du style utilisé pour la classe CSS du bloc
		label: etiquette pour identifier le nouveau style dans les paramètres du bloc
		Le nom de classe de style  pour le bloc est automatiquement créé en utilisant le format suivant :
		is-style-name avec name: identifiant ou slug du style déclaré
		le nom de la classe pour appliquer le nouveau style au bloc image est donc is-style-eccp-half-background 
		Il est également possible de définir la propriété 'is_default' => true, pour définir 
		ce style comme  le style par défaut pour le bloc
		*/
	
		register_block_style(
			'core/media-text',
			array(
				'name'  => 'eccp-half-background',
				'label' => __( 'Half background', 'editor-custom-color-palette' ),
			)
		);
		
		
	}
	
}

/*----------------------------------------------------------------------------------------
		  AJOUT AUX PARAMÉTRES DU BLOC READ MORE DE STYLES PERSONNALISÉS
/*---------------------------------------------------------------------------------------*/


/**************************************************************************************************
    remplacer l'intitulé de la balise Read More: continuer la lecture de par: Lire la suite.
   customiser la balise read more avec une classe CSS.
   On supprime la référence à l’ancre #more-000 par l’URL de l’article et
   on insére un attribut title reprenant le titre de l’article.
   On customise le lien sous forme de bouton avec la classe eccp-read-more 
   on encadre le bouton dans un div avec la classe display:block pour imposer 
   un retour a la ligne du bouton.
   On utilise la classe dashicons dashicons-arrow-right-alt2  pour un icône en forme de fléche vers la droite
   le hook: the_content_more_link permet de filtrer le lien de la balise Read More pour empêcher lorsqu'on clique
   sur cette balise de faire défiler vers la section juste en dessous la balise Read More contenant l'ancre nommée: #more-000
   href="' . get_permalink() . '" donne le lien de l'article en cours donc un clic sur la balise read more amène en début d'article
/*************************************************************************************************/

// si on a activé les styles pour le bloc READ MORE
if( $custom_gutenberg_blocks_settings['eccp_settings_activate_block_styles_read_more_radio_field'] == 'yes' ) {
	add_filter( 'the_content_more_link', 'eccp_custom_read_more_block',999 );
}

function eccp_custom_read_more_block() {
	
 // on récupère les paramètres de réglage de la section Personnaliser blocs Gutenberg
 $custom_gutenberg_blocks_settings = get_option( 'eccp_settings_custom_gutenberg_block' );
 
 $link_text = __($custom_gutenberg_blocks_settings['eccp_settings_link_text_read_more_text_field'], 'editor-custom-color-palette' );
	
 return '<div style="display:block;">
			<a class="eccp-read-more" href="' . get_permalink() . '" title="Lire la suite - ' 
			. get_the_title() . '">'.esc_html($link_text).'<span class="dashicons dashicons-arrow-right-alt2"></span> </a>
			
		 </div>';
		 
}


/*----------------------------------------------------------------------------------------
		  AJOUT AUX PARAMÉTRES DU BLOC TABLE DE STYLES PERSONNALISÉS
/*---------------------------------------------------------------------------------------*/

add_action( 'after_setup_theme', 'eccp_register_block_table_styles' );

function eccp_register_block_table_styles(){
	
	// on récupère les paramètres pour la personnalisation des blocs Gutenberg
	$custom_gutenberg_blocks_settings = get_option( 'eccp_settings_custom_gutenberg_block' );
	
	
	// si on a activé les styles pour le bloc Table
	if( $custom_gutenberg_blocks_settings['eccp_settings_activate_block_styles_table_radio_field'] == 'yes' ) {
	
		/* ----------------------------- Add Style Stripes  ---------------------------------------*/
		
		/*
		Ajout d'un style Stripes(rayures)au bloc média & texte 
		La register_block_style fonction reçoit le nom du bloc comme premier argument 
		et un tableau décrivant les propriétés du style comme deuxième argument.
		name: L'identifiant ou slug du style utilisé pour la classe CSS du bloc
		label: etiquette pour identifier le nouveau style dans les paramètres du bloc
		Le nom de classe de style  pour le bloc est automatiquement créé en utilisant le format suivant :
		is-style-name avec name: identifiant ou slug du style déclaré
		le nom de la classe pour appliquer le nouveau style au bloc image est donc is-style-eccp-stripes 
		Il est également possible de définir la propriété 'is_default' => true, pour définir 
		ce style comme  le style par défaut pour le bloc
		*/
	
		register_block_style(
			'core/table',
			array(
				'name'  => 'eccp-stripes',
				'label' => __( 'ECCP Stripes', 'editor-custom-color-palette' ),
			)
		);
		
		
	}
	
}


/*----------------------------------------------------------------------------------------
		  AJOUT AUX PARAMÉTRES DU BLOC SOCIAL LINKS DE STYLES PERSONNALISÉS
/*---------------------------------------------------------------------------------------*/

add_action( 'after_setup_theme', 'eccp_register_block_social_links_styles' );

function eccp_register_block_social_links_styles(){
	
	// on récupère les paramètres pour la personnalisation des blocs Gutenberg
	$custom_gutenberg_blocks_settings = get_option( 'eccp_settings_custom_gutenberg_block' );
	
	
	// si on a activé les styles pour le bloc social links
	if( $custom_gutenberg_blocks_settings['eccp_settings_activate_rectangle_shape_style_radio_field'] == 'yes' ) {
	
		/* ----------------------------- Add Style rectangular shape(forme rectangle)  ---------------------------------------*/
		
		/*
		Ajout d'un style rectangular shape au bloc social links
		La register_block_style fonction reçoit le nom du bloc comme premier argument 
		et un tableau décrivant les propriétés du style comme deuxième argument.
		name: L'identifiant ou slug du style utilisé pour la classe CSS du bloc
		label: etiquette pour identifier le nouveau style dans les paramètres du bloc
		Le nom de classe de style  pour le bloc est automatiquement créé en utilisant le format suivant :
		is-style-name avec name: identifiant ou slug du style déclaré
		le nom de la classe pour appliquer le nouveau style au bloc image est donc is-style-eccp-rectangular-shape 
		Il est également possible de définir la propriété 'is_default' => true, pour définir 
		ce style comme  le style par défaut pour le bloc
		*/
	
		register_block_style(
			'core/social-links',
			array(
				'name'  => 'eccp-rectangular-shape',
				'label' => __( 'Rectangular Shape', 'editor-custom-color-palette' ),
			)
		);
		
		
		/* ----------------------------- Add Style Float Right(forme rectangle flottant a droite )  ---------------------------------------*/
		
		register_block_style(
			'core/social-links',
			array(
				'name'  => 'eccp-social-icons-floating-right',
				'label' => __( 'Float Right', 'editor-custom-color-palette' ),
			)
		);
		
		
		/* ----------------------------- Add Style Float Left(forme rectangle flottant a gauche )  ---------------------------------------*/
		
		register_block_style(
			'core/social-links',
			array(
				'name'  => 'eccp-social-icons-floating-left',
				'label' => __( 'Float Left', 'editor-custom-color-palette' ),
			)
		);
		
		
	}
	
}


/* AJOUT EN FRONT END DU BOUTON CLICK TO TWEET POUR LE STYLE TWEET DU BLOC PARAGRAPHE */

function eccp_tweet_button( $block_content, $block ) {
	
	// si c'est le bloc paragraphe avec une classe is-style-eccp-tweet
	if( 'core/paragraph' === $block['blockName'] && !empty( $block['attrs']['className'] ) && 'is-style-eccp-tweet' === $block['attrs']['className'] ) {

		// on récupère le contenu du bloc paragraphe
		// explode scinde le contenu délimité par le séparateur:<p>
		// en sous chaine retourné dans un tableau
		$content = explode( '<p>', $block_content );
		
		// on récupère le texte du bloc paragraphe de style ECCP Tweet
		// wp_strip_all_tags permet de supprimer toutes les balise HTML du contenu
		$text = rawurlencode( wp_strip_all_tags( $content[0]) );
		
		//rawurlencode: fonction qui évite que les caractères spéciaux soient interprétés 
		//comme des délimiteurs, en les remplaçant par %xy avec x & y deux chiffres héxadécimaux		
		//et permet aussi de protéger les URL lors du transfert 
		$url_post = rawurlencode(get_permalink());
		
		$url_twiter = 'https://twitter.com/intent/tweet?url='. $url_post .'&text=' . $text;
		
		// on récupère le lien Twiter renseigné dans les paramètres de l'extension Yoast SEO
		$seo_data = get_option( 'wpseo_social' );
		
		if( !empty( $seo_data['twitter_site'] ) ){
			$url_twiter .= '&via=' . esc_attr( $seo_data['twitter_site'] );
		}
		
		// balise HTML de fermeture du bloc paragraphe
		$original_closing_tag = '</p>';
		
		// nouvelle balise de fermeture du bloc paragraphe 
		// on incorpore le bouton Click to Tweet avec une icône Dashicon
		// il a pour style la classe d'un bouton par défaut de Gutenberg: is-style-default
		// et on ajoute notre classe:eccp-tweet-button
		$new_closing_tag = '<span style="display:block; margin-top:0.5em; margin-bottom:2.2em;">';
		$new_closing_tag .= '<a class="is-style-default eccp-tweet-button" href="' . esc_url_raw( $url_twiter ) . '" target="_blank" rel="noopener noreferer">';
		$new_closing_tag.= 'Click to Tweet <span class="dashicons dashicons-twitter"></span></a>'; 
		$new_closing_tag .= '</span>';
		$new_closing_tag.= $original_closing_tag;
		
		
		// on remplace dans le contenu du bloc la balise de fermeture originale 
		// par la nouvelle qui contient le bouton Click to Tweet
		$block_content = str_replace( $original_closing_tag, $new_closing_tag, $block_content );
		
	}
	
	return $block_content;
}

add_filter( 'render_block', 'eccp_tweet_button', 10, 2 );


/****************************************************************************************************
                              MODIFIER L'AVATAR PAR DEFAUT
****************************************************************************************************/

//adresse ipv4 local host = 127.0.01 , adresse ipv6 local host = ::1
$is_localhost = ($_SERVER['REMOTE_ADDR'] == "127.0.0.1" or $_SERVER['REMOTE_ADDR'] == "::1");

// si on a activé un avatar personnalisé
if( $custom_gutenberg_blocks_settings['eccp_settings_activate_custom_avatar_radio_field'] == 'yes' ) {


	// si on est en local
	if ($is_localhost){
		
		
		// changement de tous les avatars en utilisant le hook de Wordpress: get_avatar
		// $id_or_email( mixte ) (Obligatoire) Le Gravatar à récupérer. 
		// Accepte un user_id,un e-mail d'utilisateur etc..
		// $size: Hauteur et largeur du fichier image de l'avatar en pixels.Valeur par défaut : 96
		// $default: (facultatif) URL de l'image par défaut
		// $alt: texte alternatif de l'image
		// $args: (facultatif) Arguments supplémentaires pour récupérer l'avatar

		// Remarque: lorsqu'on active la section des commentaires,il est possible d'avoir une erreur
		// car $id_or_email contient en fait un objet et non une chaîne
		// on peut contourner le problème en remplaçant $id_or_email par $id_or_email->comment_author_email
		// ce qui permet de récupérer une chaîne de courrier électronique à partir de l'objet $id_or_email

		add_filter( 'get_avatar', 'eccp_get_default_avatar', 10, 5);

		function eccp_get_default_avatar(  $id_or_email,$avatar = '', $size = 60, $alt = '' ) {
			
		   // on récupère les paramètres pour la personnalisation des blocs Gutenberg
		   $custom_gutenberg_blocks_settings = get_option( 'eccp_settings_custom_gutenberg_block' );
		   $url_avatar   = !empty( $custom_gutenberg_blocks_settings['eccp_settings_custom_avatar_url_text_field'] ) ? esc_url($custom_gutenberg_blocks_settings['eccp_settings_custom_avatar_url_text_field']) : esc_url(EDITOR_CUSTOM_COLOR_PALETTE_URL).'img/custom-gutenberg-block/eccp-mystery-gravatar.jpg';
			
		   // On remplace $avatar par notre propre image carrée de 150 * 150px 
		   // dont on spécifie l'URL en local
		   $avatar = "<img alt='$alt' src='$url_avatar' class='avatar avatar-{$size} photo' height='$size' width='$size' />";
		   
		return $avatar;

		}

	// sinon c'est le serveur en ligne	
	}else{
		
		// ne fonctionne qu'en ligne
		// on télécharge une image carrée de 150 * 150px pour
		// notre gravatar personnalisé
		// on spécifie l'URL en ligne pour la variable $myavatar
		// menu Réglages/commentaire sélectionner Custom Gravatar
		
		add_filter( 'avatar_defaults', 'eccp_new_default_avatar' );
		
		function eccp_new_default_avatar($avatar_defaults) {
			
			// on récupère les paramètres pour la personnalisation des blocs Gutenberg
		    $custom_gutenberg_blocks_settings = get_option( 'eccp_settings_custom_gutenberg_block' );
		    $url_avatar  = !empty( $custom_gutenberg_blocks_settings['eccp_settings_custom_avatar_url_text_field'] ) ? esc_url($custom_gutenberg_blocks_settings['eccp_settings_custom_avatar_url_text_field']) : esc_url(EDITOR_CUSTOM_COLOR_PALETTE_URL).'img/custom-gutenberg-block/eccp-mystery-gravatar.jpg';
			
			$avatar_defaults[$url_avatar] = __( 'Custom Avatar', 'editor-custom-color-palette' );
			return $avatar_defaults;
			
		}
		
	}

} // Fin si on activé un avatar personnalisé

/*----------------------------------------------------------------------------------------
		                         CSS DYNAMIQUE 
/*---------------------------------------------------------------------------------------*/


	
add_action( 'wp_head','eccp_css_dynamique',2 );
	

function eccp_css_dynamique() {			

	// On récupère les paramètres pour la palette de couleurs
	$settings = get_option( 'eccp_multiple_setting' );
	// On récupère les paramètres pour les tailles de texte de l'éditeur
	$editor_text_size_settings = get_option( 'eccp_setting_editor_text_size' );
	
						
	echo'<style type="text/css">';
	
		/*----------------------------------------------------------------------------------------
		                            CSS DYNAMIQUE PALETTE DE COULEURS GUTENBERG (Front End)(OLD)
		/*---------------------------------------------------------------------------------------*/
		
		// si on a activé la personnalisation de la palette de couleurs
		//if( $settings['eccp_settings_activate_customizing_color_palette_checkbox_field'] == true ) {
		
			/* ---------- Couleur N°1 ---------
			// couleur de fond
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_one_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_one']).'!important;';
			echo'}';
			// couleur de fond en gras
			echo'has-strong-'.esc_html($settings['eccp_settings_slug_color_one_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_one']).'!important;';
			echo'}';
			// couleur de texte
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_one_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_one']).'!important;';
			echo'}';
			// couleur texte en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_one_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_one']).'!important;';
			echo'}';
			*/
			
			
			/* ---------- Couleur N°2 ---------
			// couleur de fond
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_two_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_two']).'!important;';
			echo'}';
			// couleur de fond en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_two_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_two']).'!important;';
			echo'}';
			// couleur de texte
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_two_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_two']).'!important;';
			echo'}';
			// couleur texte en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_two_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_two']).'!important;';
			echo'}';
			*/
			
			/* ---------- Couleur N°3 ---------
			// couleur de fond
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_three_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_three']).'!important;';
			echo'}';
			// couleur de fond en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_three_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_three']).'!important;';
			echo'}';
			// couleur de texte
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_three_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_three']).'!important;';
			echo'}';
			// couleur texte en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_three_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_three']).'!important;';
			echo'}';
			*/
			
			/* ---------- Couleur N°4 ---------
			// couleur de fond
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_four_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_four']).'!important;';
			echo'}';
			// couleur de fond en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_four_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_four']).'!important;';
			echo'}';
			// couleur de texte
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_four_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_four']).'!important;';
			echo'}';
			// couleur texte en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_four_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_four']).'!important;';
			echo'}';
			*/
			
			/* ---------- Couleur N°5 ---------
			// couleur de fond
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_five_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_five']).'!important;';
			echo'}';
			// couleur de fond en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_five_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_five']).'!important;';
			echo'}';
			// couleur de texte
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_five_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_five']).'!important;';
			echo'}';
			// couleur texte en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_five_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_five']).'!important;';
			echo'}';
			*/
			
			/* ---------- Couleur N°6 ---------
			// couleur de fond
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_six_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_six']).'!important;';
			echo'}';
			// couleur de fond en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_six_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_six']).'!important;';
			echo'}';
			// couleur de texte
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_six_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_six']).'!important;';
			echo'}';
			// couleur texte en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_six_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_six']).'!important;';
			echo'}';
			*/
			
			/* ---------- Couleur N°7 ---------
			// couleur de fond
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_seven_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_seven']).'!important;';
			echo'}';
			// couleur de fond en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_seven_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_seven']).'!important;';
			echo'}';
			// couleur de texte
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_seven_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_seven']).'!important;';
			echo'}';
			// couleur texte en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_seven_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_seven']).'!important;';
			echo'}';
			*/
			
			/* ---------- Couleur N°8 ---------
			// couleur de fond
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_eight_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_eight']).'!important;';
			echo'}';
			// couleur de fond en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_eight_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_eight']).'!important;';
			echo'}';
			// couleur de texte
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_eight_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_eight']).'!important;';
			echo'}';
			// couleur texte en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_eight_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_eight']).'!important;';
			echo'}';
			*/
			
			/* ---------- Couleur N°9 ---------
			// couleur de fond
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_nine_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_nine']).'!important;';
			echo'}';
			// couleur de fond en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_nine_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_nine']).'!important;';
			echo'}';
			// couleur de texte
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_nine_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_nine']).'!important;';
			echo'}';
			// couleur texte en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_nine_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_nine']).'!important;';
			echo'}';
			*/
			
			
			/* ---------- Couleur N°10 ---------
			// couleur de fond
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_ten_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_ten']).'!important;';
			echo'}';
			// couleur de fond en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_ten_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_ten']).'!important;';
			echo'}';
			// couleur de texte
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_ten_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_ten']).'!important;';
			echo'}';
			// couleur texte en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_ten_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_ten']).'!important;';
			echo'}';
			*/
			
			/* ---------- Couleur N°11 ---------
			// couleur de fond
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_eleven_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_eleven']).'!important;';
			echo'}';
			// couleur de fond en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_eleven_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_eleven']).'!important;';
			echo'}';
			// couleur de texte
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_eleven_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_eleven']).'!important;';
			echo'}';
			// couleur texte en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_eleven_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_eleven']).'!important;';
			echo'}';
			*/
			
			/* ---------- Couleur N°12 ---------
			// couleur de fond
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_twelve_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_twelve']).'!important;';
			echo'}';
			// couleur de fond en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_twelve_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_twelve']).'!important;';
			echo'}';
			// couleur de texte
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_twelve_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_twelve']).'!important;';
			echo'}';
			// couleur texte en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_twelve_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_twelve']).'!important;';
			echo'}';
			*/
			
		//}
		
		/*----------------------------------------------------------------------------------------
		                            CSS DYNAMIQUE TAILLES POLICE EDITEUR GUTENBERG (Front End)
		/*---------------------------------------------------------------------------------------*/

		
		// font size: small
		echo'.has-eccp-small-font-size {';

			echo'font-size:'.esc_html($editor_text_size_settings['eccp_settings_small_font_size_text_field']).'px!important;';
			//echo'line-height:1.3em;';
			
		echo'}';
		
		// font size: regular
		echo'.has-eccp-regular-font-size {';

			echo'font-size:'.esc_html($editor_text_size_settings['eccp_settings_regular_font_size_text_field']).'px!important;';
			//echo'line-height:1.3em;';
			
		echo'}';
		
		//font size: large
		echo'.has-eccp-large-font-size {';

			echo'font-size:'.esc_html($editor_text_size_settings['eccp_settings_large_font_size_text_field']).'px!important;';
			//echo'line-height:1.3em;';
			
		echo'}';
		
		//font size: huge (extra large)
		echo'.has-eccp-huge-font-size {';

			echo'font-size:'.esc_html($editor_text_size_settings['eccp_settings_huge_font_size_text_field']).'px!important;';
			//echo'line-height: 1.3em;';
			
		echo'}';
	
	   
	
	echo'</style>';
	

}


/*----------------------------------------------------------------------------------------
		        CSS DYNAMIQUE PALETTE DE COULEURS GUTENBERG (Back office)(OLD)
/*---------------------------------------------------------------------------------------*/

//add_action('admin_head',  'eccp_css_dynamique_back_office',8);
//add_action('admin_print_styles',  'eccp_css_dynamique_back_office', 21);

function eccp_css_dynamique_back_office() {

	// Si on est en back office & si l'objet d'écran est l'éditeur Gutenberg,
	// alors on peut charger notre style sinon on sort
	if (!is_admin() and !get_current_screen()->is_block_editor() ) {
		return;
	}

	// On récupère les paramètres général de réglages du plugin
	$settings = get_option( 'eccp_multiple_setting' );
						
	echo'<style id="editor_custom_color_palette_css" type="text/css">';
	
		/*----------------------------------------------------------------------------------------
		                            CSS DYNAMIQUE PALETTE DE COULEURS GUTENBERG (Back office)
		/*---------------------------------------------------------------------------------------*/
		
		// si on a activé la personnalisation de la palette de couleurs
		if( $settings['eccp_settings_activate_customizing_color_palette_checkbox_field'] == true ) {
		
			/* ---------- Couleur N°1 ---------*/
			// couleur de fond
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_one_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_one']).';';
			echo'}';
			// couleur de fond en gras
			echo'has-strong-'.esc_html($settings['eccp_settings_slug_color_one_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_one']).';';
			echo'}';
			// couleur de texte
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_one_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_one']).';';
			echo'}';
			// couleur texte en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_one_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_one']).';';
			echo'}';
			
			/* ---------- Couleur N°2 ---------*/
			// couleur de fond
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_two_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_two']).';';
			echo'}';
			// couleur de fond en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_two_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_two']).';';
			echo'}';
			// couleur de texte
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_two_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_two']).';';
			echo'}';
			// couleur texte en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_two_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_two']).';';
			echo'}';
			
			/* ---------- Couleur N°3 ---------*/
			// couleur de fond
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_three_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_three']).';';
			echo'}';
			// couleur de fond en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_three_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_three']).';';
			echo'}';
			// couleur de texte
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_three_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_three']).';';
			echo'}';
			// couleur texte en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_three_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_three']).';';
			echo'}';
			
			/* ---------- Couleur N°4 ---------*/
			// couleur de fond
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_four_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_four']).';';
			echo'}';
			// couleur de fond en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_four_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_four']).';';
			echo'}';
			// couleur de texte
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_four_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_four']).';';
			echo'}';
			// couleur texte en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_four_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_four']).';';
			echo'}';
			
			/* ---------- Couleur N°5 ---------*/
			// couleur de fond
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_five_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_five']).';';
			echo'}';
			// couleur de fond en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_five_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_five']).';';
			echo'}';
			// couleur de texte
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_five_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_five']).';';
			echo'}';
			// couleur texte en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_five_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_five']).';';
			echo'}';
			
			/* ---------- Couleur N°6 ---------*/
			// couleur de fond
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_six_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_six']).';';
			echo'}';
			// couleur de fond en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_six_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_six']).';';
			echo'}';
			// couleur de texte
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_six_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_six']).';';
			echo'}';
			// couleur texte en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_six_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_six']).';';
			echo'}';
			
			/* ---------- Couleur N°7 ---------*/
			// couleur de fond
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_seven_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_seven']).';';
			echo'}';
			// couleur de fond en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_seven_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_seven']).';';
			echo'}';
			// couleur de texte
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_seven_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_seven']).';';
			echo'}';
			// couleur texte en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_seven_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_seven']).';';
			echo'}';
			
			/* ---------- Couleur N°8 ---------*/
			// couleur de fond
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_eight_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_eight']).';';
			echo'}';
			// couleur de fond en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_eight_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_eight']).';';
			echo'}';
			// couleur de texte
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_eight_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_eight']).';';
			echo'}';
			// couleur texte en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_eight_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_eight']).';';
			echo'}';
			
			/* ---------- Couleur N°9 ---------*/
			// couleur de fond
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_nine_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_nine']).';';
			echo'}';
			// couleur de fond en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_nine_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_nine']).';';
			echo'}';
			// couleur de texte
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_nine_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_nine']).';';
			echo'}';
			// couleur texte en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_nine_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_nine']).';';
			echo'}';
			
			/* ---------- Couleur N°10 ---------*/
			// couleur de fond
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_ten_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_ten']).';';
			echo'}';
			// couleur de fond en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_ten_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_ten']).';';
			echo'}';
			// couleur de texte
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_ten_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_ten']).';';
			echo'}';
			// couleur texte en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_ten_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_ten']).';';
			echo'}';
			
			/* ---------- Couleur N°11 ---------*/
			// couleur de fond
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_eleven_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_eleven']).';';
			echo'}';
			// couleur de fond en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_eleven_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_eleven']).';';
			echo'}';
			// couleur de texte
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_eleven_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_eleven']).';';
			echo'}';
			// couleur texte en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_eleven_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_eleven']).';';
			echo'}';
			
			/* ---------- Couleur N°12 ---------*/
			// couleur de fond
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_twelve_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_twelve']).';';
			echo'}';
			// couleur de fond en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_twelve_text_field']).'-background-color{';
			echo'background-color:'.esc_html($settings['eccp_settings_color_twelve']).';';
			echo'}';
			// couleur de texte
			echo'.has-'.esc_html($settings['eccp_settings_slug_color_twelve_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_twelve']).';';
			echo'}';
			// couleur texte en gras
			echo'.has-strong-'.esc_html($settings['eccp_settings_slug_color_twelve_text_field']).'-color{';
			echo'color:'.esc_html($settings['eccp_settings_color_twelve']).';';
			echo'}';
	
		}
		
	echo'</style>';
	

}



/*----------------------------------------------------------------------------------------
		                STYLE BACK OFFICE PALETTE DE COULEURS
/*---------------------------------------------------------------------------------------*/


function ecpp_custom_styling_color_palette() {
	
	// Si on est en back office & si l'objet d'écran est l'éditeur Gutenberg,
	// alors on peut charger notre style sinon on sort
	if (!is_admin() and !get_current_screen()->is_block_editor() ) {
		return;
	}
	
	// On récupère les paramètres pour la palette de couleurs
	$settings = get_option( 'eccp_multiple_setting' );
	
	
	// Style Palette de couleurs en back office
	echo '<style type="text/css">';
	
	
	
		switch ($settings['eccp_settings_number_colors_select_field']) {
			
			case '7':
			
			/* Pour la palette de couleurs dans le panneau latéral droit onglet Bloc */
			echo'.block-editor-panel-color-gradient-settings .components-circular-option-picker__option-wrapper:nth-child(0n+8),
				.block-editor-panel-color-gradient-settings .components-circular-option-picker__option-wrapper:nth-child(0n+9),
				.block-editor-panel-color-gradient-settings .components-circular-option-picker__option-wrapper:nth-child(0n+10),
				.block-editor-panel-color-gradient-settings .components-circular-option-picker__option-wrapper:nth-child(0n+11),
				.block-editor-panel-color-gradient-settings .components-circular-option-picker__option-wrapper:nth-child(0n+12){
		
				display:none!important;
			
			}';
			
			/* Pour la palette de couleurs qui apparait en fenêtre modale pour un
			   changement de couleurs du texte directement a partir de la barre d'outils du bloc */
			echo'.components-popover__content .components-circular-option-picker__option-wrapper:nth-child(0n+8),
				.components-popover__content .components-circular-option-picker__option-wrapper:nth-child(0n+9),
				.components-popover__content .components-circular-option-picker__option-wrapper:nth-child(0n+10),
				.components-popover__content .components-circular-option-picker__option-wrapper:nth-child(0n+11),
				.components-popover__content .components-circular-option-picker__option-wrapper:nth-child(0n+12){
		
				display:none!important;
			
			}';
			
			break;
			
			
			case '8':
			
			/* Pour la palette de couleurs dans le panneau latéral droit onglet Bloc */
			echo'.block-editor-panel-color-gradient-settings .components-circular-option-picker__option-wrapper:nth-child(0n+9),
				.block-editor-panel-color-gradient-settings .components-circular-option-picker__option-wrapper:nth-child(0n+10),
				.block-editor-panel-color-gradient-settings .components-circular-option-picker__option-wrapper:nth-child(0n+11),
				.block-editor-panel-color-gradient-settings .components-circular-option-picker__option-wrapper:nth-child(0n+12){
		
				display:none!important;
			
			}';
			
			/* Pour la palette de couleurs qui apparait en fenêtre modale pour un
			   changement de couleurs du texte directement a partir de la barre d'outils du bloc */
			echo'.components-popover__content .components-circular-option-picker__option-wrapper:nth-child(0n+9),
				.components-popover__content .components-circular-option-picker__option-wrapper:nth-child(0n+10),
				.components-popover__content .components-circular-option-picker__option-wrapper:nth-child(0n+11),
				.components-popover__content .components-circular-option-picker__option-wrapper:nth-child(0n+12){
		
				display:none!important;
			
			}';
			
			break;
			
			
			case '9':
			
			/* Pour la palette de couleurs dans le panneau latéral droit onglet Bloc */
			echo'.block-editor-panel-color-gradient-settings .components-circular-option-picker__option-wrapper:nth-child(0n+10),
				.block-editor-panel-color-gradient-settings .components-circular-option-picker__option-wrapper:nth-child(0n+11),
				.block-editor-panel-color-gradient-settings .components-circular-option-picker__option-wrapper:nth-child(0n+12){
		
				display:none!important;
			
			}';
			
			/* Pour la palette de couleurs qui apparait en fenêtre modale pour un
			   changement de couleurs du texte directement a partir de la barre d'outils du bloc */
			echo'.components-popover__content .components-circular-option-picker__option-wrapper:nth-child(0n+10),
				.components-popover__content .components-circular-option-picker__option-wrapper:nth-child(0n+11),
				.components-popover__content .components-circular-option-picker__option-wrapper:nth-child(0n+12){
		
				display:none!important;
			
			}';
			
			break;
			
			case '10':
			
			/* Pour la palette de couleurs dans le panneau latéral droit onglet Bloc */
			echo'.block-editor-panel-color-gradient-settings .components-circular-option-picker__option-wrapper:nth-child(0n+11),
				.block-editor-panel-color-gradient-settings .components-circular-option-picker__option-wrapper:nth-child(0n+12){
		
				display:none!important;
			
			}';
			
			/* Pour la palette de couleurs qui apparait en fenêtre modale pour un
			   changement de couleurs du texte directement a partir de la barre d'outils du bloc */
			echo'.components-popover__content .components-circular-option-picker__option-wrapper:nth-child(0n+11),
				.components-popover__content .components-circular-option-picker__option-wrapper:nth-child(0n+12){
		
				display:none!important;
			
			}';
			
			break;
			
			case '11':
			
			/* Pour la palette de couleurs dans le panneau latéral droit onglet Bloc */
			echo'.block-editor-panel-color-gradient-settings .components-circular-option-picker__option-wrapper:nth-child(0n+12){
		
				display:none!important;
			
			}';
			
			/* Pour la palette de couleurs qui apparait en fenêtre modale pour un
			   changement de couleurs du texte directement a partir de la barre d'outils du bloc */
			echo'.components-popover__content .components-circular-option-picker__option-wrapper:nth-child(0n+12){
		
				display:none!important;
			
			}';
			
			break;
			
		}
	

	echo '</style>';

}

add_action('admin_head', 'ecpp_custom_styling_color_palette');

/*----------------------------------------------------------------------------------------
		                STYLE BACK OFFICE BLOCS EDITEUR GUTENBERG
/*---------------------------------------------------------------------------------------*/

// pour bien déclarer le style uniquemment pour l'éditeur en back office on utilise 
// le hook: enqueue_block_editor_assets
add_action('enqueue_block_editor_assets', 'ecpp_block_style_back_office');

function ecpp_block_style_back_office() {
	
	
	add_action( 'admin_head', function() {
		
		// On récupère les paramètres pour personnaliser l'éditeur
		$custom_gutenberg_editor_settings = get_option( 'eccp_settings_custom_gutenberg_editor' );
		// On récupère les paramètres pour les blocs réutilisables
		$reusable_blocks_settings = get_option( 'eccp_settings_reusable_blocks' );
		// On récupère les paramètres pour personnaliser les blocs Gutenberg
		$custom_gutenberg_blocks_settings = get_option( 'eccp_settings_custom_gutenberg_block' );
		// On récupère les paramètres pour personnaliser les Tailles de texte
	    $editor_text_size_settings = get_option( 'eccp_setting_editor_text_size' );
		
		// post type ayant un slug, publicly_queryable, mais qui ne sont pas des CPT utilisateurs
		$slug_no_cpt = array('e-landing-page','seedprod' ,'product','produit',
							'/boutique','elementor-hf','nf_sub','/produit');
		
		/*-------------- CORRECTION BUG DU AU PLUGIN ---------------*/
		// Si on est en back office & si l'objet d'écran est l'éditeur Gutenberg,
		// alors on peut charger notre style
		// sinon problème avec les métabox du panneau latéral de WordPress
		if (is_admin() and get_current_screen()->is_block_editor() ) {
		   
			// Style des blocs en back office
			echo '<style type="text/css">';
			
				/*------------------- RÈGLES GÉNÉRALES EDITEUR GUTENBERG --------------------------*/
				
				// On impose le centrage des blocks, cette régle étant invalidé uniquement 
				//	   pour les liste à puces par: 
				//	   .editor-styles-wrapper .block-editor-block-list__layout ul {
				//			margin: 15px 0 15px 0;
				//		}  	
				
				echo'.block-editor-block-list__layout .wp-block {
					margin-left: auto!important;
					margin-right: auto!important;
				}'; 
				
				// régles pour le block FAQ YOAST SEO
				echo'.wp-block-yoast-faq-block {
					margin-left: auto!important;
					margin-right: auto!important;
				}'; 
				
				/*------------------- ALIGNEMENT LARGE & PLEINE LARGEUR POUR L 'EDITEUR DE BLOCS RÉGLES BACK OFFICE ----------------------*/
				
				// si on à activé l'alignement large pour l'éditeur de blocs
				if( $custom_gutenberg_editor_settings['eccp_settings_activate_align_wide_block_editor_checkbox_field'] == true ) {
					
					//.block-editor-block-list__layout
					// régles pour un alignement large pour les pages
					// on fait correspondre le bloc a la largeur de l'editeur
					echo'body.post-type-page .wp-block[data-align="wide"] {
						
						width: 100%!important;
						
					}';
					
					
					// régles pour un alignement pleine largeur uniquement pour les pages
					// je ne gère pas les articles car généralement il y a une sidebar
					// et il est difficile de tester si présence ou non d'une sidebar
					echo'body.post-type-page .wp-block[data-align="full"] {
						
						max-width: none!important;
						margin-left:unset!important;
						margin-right:unset!important;
					
					}';
					
					
					// Règles alignement pour les articles si on activé le réglage de largeur de l'editeur.
					// On aurait pu faire comme pour les pages mais le thème Astra a une règle max-width: 1260px
					// pour tous les alignements qu'il faut pouvoir surchargé.
					if( $custom_gutenberg_editor_settings['eccp_settings_activate_editor_width_checkbox_field'] == true ){
					
					
						// Selon Largeur editeur pour les articles
						switch ($custom_gutenberg_editor_settings['eccp_settings_post_template_editor_select_field']) {
						
							// petit modèle pour les articles
							case 'small':
							
							echo' body.post-type-post .wp-block[data-align="left"], 
								  body.post-type-post .wp-block[data-align="right"], 
								  body.post-type-post .wp-block[data-align="center"], 
								  body.post-type-post .wp-block[data-align="full"], 
								  body.post-type-post .wp-block[data-align="wide"]{';
							 
								echo'max-width:'.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px;';
							
							echo'}';
							
							break;
							
							// large modèle pour les articles
							case 'large':
							
							echo' body.post-type-post .wp-block[data-align="left"], 
								  body.post-type-post .wp-block[data-align="right"], 
								  body.post-type-post .wp-block[data-align="center"], 
								  body.post-type-post .wp-block[data-align="full"], 
								  body.post-type-post .wp-block[data-align="wide"]{';
							 
								echo'max-width:'.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px;';
							
							echo'}';
							
							break;
							
							// pleine largeur pour les articles
							case 'fullwidth':
							
							echo' body.post-type-post .wp-block[data-align="left"], 
								  body.post-type-post .wp-block[data-align="right"], 
								  body.post-type-post .wp-block[data-align="center"], 
								  body.post-type-post .wp-block[data-align="full"], 
								  body.post-type-post .wp-block[data-align="wide"]{';
							 
								echo'max-width: none;';
							
							echo'}';
							
							break;
						
						}
						
					
					}
					
					// s'il y a des Customm Post Type
					if ( !empty($slug_cpt = eccp_get_registered_post_types()) ) {
						
						foreach ($slug_cpt as $key => $value) {
							
							// on récupère pour les CPT un tableau associatif : $slug_cpt
							// dont la clé donne le nom de nos CPT et la valeur le slug du CPT
							// récupère aussi a quelques exception prés des slug de post type 
							// qui ne sont pas des CPT, ex: e-landing-page que l'on écarte en les définissant dans $slug_no_cpt
							// si le slug est bien un slug de CPT alors on peut appliquer les régles CSS
							if  ( !in_array($value, $slug_no_cpt) )  {
						
								// régles pour un alignement large pour les Custom Post Type
								// on fait correspondre le bloc a la largeur de l'editeur
								echo'body.post-type-'.$value.' .wp-block[data-align="wide"] {
								
								width: 100%!important;
								
								}';
							
							
								// régles pour un alignement pleine largeur 
								echo'body.post-type-'.$value.' .wp-block[data-align="full"] {
									
									max-width: none!important;
									margin-left:unset!important;
									margin-right:unset!important;
								
								}';
								
								
								// Régles pour le plugin The Events Calendar(Mise à jour version 2.0)
								// ce n'est pas le slug mais le nom du post type qui est pris comme référence
								// par The Events Calendar pour appliquer des régles CSS.
								if ($key == 'tribe_events') {
									
									// régles pour un alignement large pour les événements
									// on fait correspondre le bloc a la largeur de l'editeur
									echo'body.post-type-'.$key.' .wp-block[data-align="wide"] {
									
									width: 100%!important;
									
									}';
								
								
									// régles pour un alignement pleine largeur 
									echo'body.post-type-'.$key.' .wp-block[data-align="full"] {
										
										max-width: none!important;
										margin-left:unset!important;
										margin-right:unset!important;
									
									}';
									
									
								}
							
							}
						
						}
					
						
					} // s'il ya des Customm Post Type
					
					
				} // fin si on a activé l'alignement pleine largeur
				
				
				/*------------------- EMBEDS RESPONSIVES LARGEUR MAX VIDÉOS INTÉGRÉES EN BACK OFFICE --------------------------*/
				
				// Si on à activé les embeds responsive			
				if( $custom_gutenberg_editor_settings['eccp_settings_activate_responsive_embeds_checkbox_field'] == true ) {
					
					// régles pour les articles
					echo'body.post-type-post .wp-block[data-align=left]>.wp-block-embed,
						 body.post-type-post .wp-block[data-align=center]>.wp-block-embed,
						 body.post-type-post .wp-block[data-align=right]>.wp-block-embed {'; 
					
							echo'max-width:'.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_post_embed_max_width_text_field']) ).'px!important;';
					
					echo'}';
					
					
					// régles pour les pages
					echo'body.post-type-page .wp-block[data-align=left]>.wp-block-embed,
						 body.post-type-page .wp-block[data-align=center]>.wp-block-embed,
						 body.post-type-page .wp-block[data-align=right]>.wp-block-embed {'; 
					
							echo'max-width:'.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_page_embed_max_width_text_field']) ).'px!important;';
					
					echo'}';
					
					
					// on récupère le thème actif
					$my_theme = wp_get_theme();
			
					// Modif pour le thème DIVI 
					if(stristr($my_theme, 'divi')) {
					
						// modif afin que la taille de la vidéo configurée dans la  
						// page d'option du plugin soit prise en compte
						echo'.editor-styles-wrapper .block-editor-block-list__layout.is-root-container > [data-align="left"],
							 .editor-styles-wrapper .block-editor-block-list__layout.is-root-container > [data-align="right"]{';
							
							echo'float:unset!important';
						
						echo'}';
					
					}
					
					
					// s'il ya des Custom Post Type
					if ( !empty($slug_cpt = eccp_get_registered_post_types()) ) {
						
						foreach ($slug_cpt as $key => $value) {
							
							// on récupère pour les CPT un tableau associatif : $slug_cpt
							// dont la clé donne le nom de nos CPT et la valeur le slug du CPT
							// récupère aussi a quelques exception prés des slug de post type 
							// qui ne sont pas des CPT, ex: e-landing-page que l'on écarte en les définissant dans $slug_no_cpt
							// si le slug est bien un slug de CPT alors on peut appliquer les régles CSS
							if  ( !in_array($value, $slug_no_cpt) )  {
								
								// régles pour les CPT
								echo'body.post-type-'.$value.' .wp-block[data-align=left]>.wp-block-embed,'.
									'body.post-type-'.$value.' .wp-block[data-align=center]>.wp-block-embed,'.
									'body.post-type-'.$value.' .wp-block[data-align=right]>.wp-block-embed {'; 
								
										echo'max-width:'.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_cpt_embed_max_width_text_field']) ).'px!important;';
								
								echo'}';
								
								// Régle pour les CPT
								// Mise à jour version 2.0: correction pour un alignement gauche & droite du bloc embed
								// pour un embed max-width de 960px 
								//@media (min-width:960px) {  margin-right:calc(109% - 960px);   }
						
								echo'@media (min-width: '.$custom_gutenberg_editor_settings['eccp_settings_cpt_embed_max_width_text_field'].'px) {';
						
									echo 'body.post-type-'.$value.' .wp-block[data-align=left]>.wp-block-embed {';
							
										echo'margin-right: calc(109% - '. esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_cpt_embed_max_width_text_field']) ).'px)!important;';
					
									echo'}';
							
									echo 'body.post-type-'.$value.' .wp-block[data-align=right]>.wp-block-embed {';
							
										echo'margin-left: calc(109% - '. esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_cpt_embed_max_width_text_field']) ).'px)!important;';
					
									echo'}';

								echo'}'; 
								
								
								// Régles pour le plugin The Events Calendar(Mise à jour version 2.0)
								// ce n'est pas le slug mais le nom du post type qui est pris comme référence
								// par The Events Calendar pour appliquer des régles CSS.(Mise à jour version 2.0)
								if ($key == 'tribe_events') {
									
									// régles pour les CPT évènements
									echo'body.post-type-'.$key.' .wp-block[data-align=left]>.wp-block-embed,'.
										'body.post-type-'.$key.' .wp-block[data-align=center]>.wp-block-embed,'.
										'body.post-type-'.$key.' .wp-block[data-align=right]>.wp-block-embed {'; 
									
											echo'max-width:'.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_cpt_embed_max_width_text_field']) ).'px!important;';
									
									echo'}';
									
									// Régle pour les CPT évènements
									// Mise à jour version 2.0: correction pour un alignement gauche & droite du bloc embed
									// pour un embed max-width de 960px 
									//@media (min-width:960px) {  margin-right:calc(109% - 960px);   }
							
									echo'@media (min-width: '.$custom_gutenberg_editor_settings['eccp_settings_cpt_embed_max_width_text_field'].'px) {';
							
										echo 'body.post-type-'.$key.' .wp-block[data-align=left]>.wp-block-embed {';
								
											echo'margin-right: calc(109% - '. esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_cpt_embed_max_width_text_field']) ).'px)!important;';
						
										echo'}';
								
										echo 'body.post-type-'.$key.' .wp-block[data-align=right]>.wp-block-embed {';
								
											echo'margin-left: calc(109% - '. esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_cpt_embed_max_width_text_field']) ).'px)!important;';
						
										echo'}';

									echo'}'; 
					
									
								}
								
						
							}
						
						}
					
						
					}
					
					
					// Régle pour les Articles
					// Mise à jour version 1.7: correction pour un alignement gauche & droite du bloc embed
					// pour un embed max-width de 960px 
					//@media (min-width:960px) {  margin-right:calc(109% - 960px);   }
			
					echo'@media (min-width: '.$custom_gutenberg_editor_settings['eccp_settings_post_embed_max_width_text_field'].'px) {';
			
						echo 'body.post-type-post .wp-block[data-align=left]>.wp-block-embed {';
				
							echo'margin-right: calc(109% - '. esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_post_embed_max_width_text_field']) ).'px)!important;';
		
						echo'}';
				
						echo 'body.post-type-post .wp-block[data-align=right]>.wp-block-embed {';
				
							echo'margin-left: calc(109% - '. esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_post_embed_max_width_text_field']) ).'px)!important;';
		
						echo'}'; 
					
					echo'}';

			
					// Régle pour les Pages
					// Mise à jour version 1.7 & 1.8: correction pour un alignement gauche & droite du bloc embed
					// pour un embed max-width de 960px 
					//@media (min-width:960px) {  margin-right:calc(109% - 960px);   }
			
					echo'@media (min-width: '.$custom_gutenberg_editor_settings['eccp_settings_page_embed_max_width_text_field'].'px) {';
			
						echo 'body.post-type-page .wp-block[data-align=left]>.wp-block-embed {';
				
							echo'margin-right: calc(109% - '. esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_page_embed_max_width_text_field']-100) ).'px)!important;';
		
						echo'}';

						echo 'body.post-type-page .wp-block[data-align=right]>.wp-block-embed {';
				
							echo'margin-left: calc(109% - '. esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_page_embed_max_width_text_field']-100) ).'px)!important;';
		
						echo'}';
					
					echo'}';
					
					
					// régle pour centrer la vidéo pour un alignement centré
					echo'.wp-block[data-align=center]>.wp-block-embed {'; 
					
							echo'margin:0 auto!important;';
					
					echo'}';
					
					
					$my_theme = wp_get_theme();
			
					// pour un alignement centré correction pour le thème Astra 
					if(stristr($my_theme, 'astra')) {
					
						echo'.ast-plain-container .wp-block[data-align="center"] {';
						
							echo'max-width:'.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_post_embed_max_width_text_field']) ).'px!important;';
							
						echo'}';
					
					}
					
				}
				 
				
				
				/*------------------- FAIRE CORRESPONDRE LA LARGEUR DE L'EDITEUR & BLOC PARAGRAPHE & BLOC GROUP & BLOC TABLEAU & BLOC YOAST & BLOC LISTE & BLOC DÉTAILS A CELLE DU SITE RÉGLES BACK OFFICE --------------------------*/
				
				if( $custom_gutenberg_editor_settings['eccp_settings_activate_editor_width_checkbox_field'] == true ){
				
					
					// Largeur editeur pour les articles
					switch ($custom_gutenberg_editor_settings['eccp_settings_post_template_editor_select_field']) {
					
						//----------- petit modèle pour les articles -----------
						case 'small':
						
						echo'body.post-type-post .wp-block {'; 
					
							echo'max-width:'.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px!important;';
					
						echo'}';
						
						
						// largeur block paragraphe	& block group & bloc tableau & bloc Liste & bloc détails					
						echo'body.post-type-post p.is-style-eccp-size-very-small,
							 body.post-type-post [data-type="core/group"].is-style-eccp-size-very-small,
							 body.post-type-post [data-type="core/table"].is-style-eccp-size-very-small,
							 body.post-type-post [data-type="core/list"].is-style-eccp-size-very-small,
							 body.post-type-post [data-type="core/details"].is-style-eccp-size-very-small{';
								
							echo'width: calc(0.5 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px)!important;';
					
						echo'}';
						
						 					
						echo'body.post-type-post p.is-style-eccp-size-small,
							 body.post-type-post [data-type="core/group"].is-style-eccp-size-small,
							 body.post-type-post [data-type="core/table"].is-style-eccp-size-small,
							 body.post-type-post [data-type="core/list"].is-style-eccp-size-small,
							 body.post-type-post [data-type="core/details"].is-style-eccp-size-small{';
								
							echo'width: calc(0.6 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px)!important;';
					
						echo'}';
						
						echo'body.post-type-post p.is-style-eccp-size-regular,
						     body.post-type-post [data-type="core/group"].is-style-eccp-size-regular,
							 body.post-type-post [data-type="core/table"].is-style-eccp-size-regular,
							 body.post-type-post [data-type="core/list"].is-style-eccp-size-regular,
							 body.post-type-post [data-type="core/details"].is-style-eccp-size-regular{';
										
							echo'width: calc(0.7 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px)!important;';
					
						echo'}';
						
						echo'body.post-type-post p.is-style-eccp-size-large,
						     body.post-type-post [data-type="core/group"].is-style-eccp-size-large,
							 body.post-type-post [data-type="core/table"].is-style-eccp-size-large,
							 body.post-type-post [data-type="core/list"].is-style-eccp-size-large,
							 body.post-type-post [data-type="core/details"].is-style-eccp-size-large{';
										
							echo'width: calc(0.8 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px)!important;';
					
						echo'}';
						
						echo'body.post-type-post p.is-style-eccp-size-larger,
							 body.post-type-post [data-type="core/group"].is-style-eccp-size-larger,
							 body.post-type-post [data-type="core/table"].is-style-eccp-size-larger,
							 body.post-type-post [data-type="core/list"].is-style-eccp-size-larger,
							 body.post-type-post [data-type="core/details"].is-style-eccp-size-larger{';
										
							echo'width: calc(0.9 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px)!important;';
					
						echo'}';
						
						// largeur block FAQ YOAST SEO
						echo'body.post-type-post div.wp-block-yoast-faq-block{';
										
							echo'width: calc('.esc_html(strval($custom_gutenberg_blocks_settings['eccp_settings_width_block_faq_yoast_text_field']))/100 * esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px)!important;';
					
						echo'}';
						
						
						break;
						
						
						//----------- large modèle pour les articles -----------
						case 'large':
						
						echo'body.post-type-post .wp-block {'; 
					
							echo'max-width:'.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px!important;';
					
						echo'}';
						
						
						// largeur block paragraphe	& block group & block tableau & bloc liste & bloc détails					
						echo'body.post-type-post p.is-style-eccp-size-very-small,
							 body.post-type-post [data-type="core/group"].is-style-eccp-size-very-small,
							 body.post-type-post [data-type="core/table"].is-style-eccp-size-very-small,
							 body.post-type-post [data-type="core/list"].is-style-eccp-size-very-small,
							 body.post-type-post [data-type="core/details"].is-style-eccp-size-very-small{';
								
							echo'width: calc(0.5 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px)!important;';
					
						echo'}';
											
						echo'body.post-type-post p.is-style-eccp-size-small,
							 body.post-type-post [data-type="core/group"].is-style-eccp-size-small,
							 body.post-type-post [data-type="core/table"].is-style-eccp-size-small,
							 body.post-type-post [data-type="core/list"].is-style-eccp-size-small,
							 body.post-type-post [data-type="core/details"].is-style-eccp-size-small{';
								
							echo'width: calc(0.6 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px)!important;';
					
						echo'}';
						
						echo'body.post-type-post p.is-style-eccp-size-regular,
						     body.post-type-post [data-type="core/group"].is-style-eccp-size-regular,
							 body.post-type-post [data-type="core/table"].is-style-eccp-size-regular,
							 body.post-type-post [data-type="core/list"].is-style-eccp-size-regular,
							 body.post-type-post [data-type="core/details"].is-style-eccp-size-regular{';
							 
							echo'width: calc(0.7 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px)!important;';
					
						echo'}';
						
						echo'body.post-type-post p.is-style-eccp-size-large,
						     body.post-type-post [data-type="core/group"].is-style-eccp-size-large,
							 body.post-type-post [data-type="core/table"].is-style-eccp-size-large,
							 body.post-type-post [data-type="core/list"].is-style-eccp-size-large,
							 body.post-type-post [data-type="core/details"].is-style-eccp-size-large{';
										
							echo'width: calc(0.8 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px)!important;';
					
						echo'}';
						
						echo'body.post-type-post p.is-style-eccp-size-larger,
							 body.post-type-post [data-type="core/group"].is-style-eccp-size-larger,
							 body.post-type-post [data-type="core/table"].is-style-eccp-size-larger,
							 body.post-type-post [data-type="core/list"].is-style-eccp-size-larger,
							 body.post-type-post [data-type="core/details"].is-style-eccp-size-larger{';
										
							echo'width: calc(0.9 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px)!important;';
					
						echo'}';
						
						// largeur block FAQ YOAST SEO
						echo'body.post-type-post div.wp-block-yoast-faq-block{';
										
							echo'width: calc('.esc_html(strval($custom_gutenberg_blocks_settings['eccp_settings_width_block_faq_yoast_text_field']))/100 * esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px)!important;';
					
						echo'}';
						
						
						break;
						
						
						//----------- pleine largeur pour les articles -----------
						//----------- ne fonctionne pas avec le thème Astra, -----------
						//-----------  même avec l'extension kadence Block -----------
						case 'fullwidth':
						
						echo'body.post-type-post .wp-block{
							max-width: none!important;
						}';
						
						// largeur block paragraphe	& block group & block tableau & block liste & block détails					
						echo'body.post-type-post p.is-style-eccp-size-very-small,
							 body.post-type-post [data-type="core/group"].is-style-eccp-size-very-small,
							 body.post-type-post [data-type="core/table"].is-style-eccp-size-very-small,
							 body.post-type-post [data-type="core/list"].is-style-eccp-size-very-small,
							 body.post-type-post [data-type="core/details"].is-style-eccp-size-very-small{';
								
							echo'width: 50%!important;';
					
						echo'}';
										
						echo'body.post-type-post p.is-style-eccp-size-small,
							 body.post-type-post [data-type="core/group"].is-style-eccp-size-small,
							 body.post-type-post [data-type="core/table"].is-style-eccp-size-small,
							 body.post-type-post [data-type="core/list"].is-style-eccp-size-small,
							 body.post-type-post [data-type="core/details"].is-style-eccp-size-small{';
								
							echo'width: 60%!important;';
					
						echo'}';
						
						echo'body.post-type-post p.is-style-eccp-size-regular,
						     body.post-type-post [data-type="core/group"].is-style-eccp-size-regular,
							 body.post-type-post [data-type="core/table"].is-style-eccp-size-regular,
							 body.post-type-post [data-type="core/list"].is-style-eccp-size-regular,
							 body.post-type-post [data-type="core/details"].is-style-eccp-size-regular{';
										
							echo'width: 70%!important;';
					
						echo'}';
						
						echo'body.post-type-post p.is-style-eccp-size-large,
						     body.post-type-post [data-type="core/group"].is-style-eccp-size-large,
							 body.post-type-post [data-type="core/table"].is-style-eccp-size-large,
							 body.post-type-post [data-type="core/list"].is-style-eccp-size-large,
							 body.post-type-post [data-type="core/details"].is-style-eccp-size-large{';
										
							echo'width: 80%!important;';
					
						echo'}';
						
						echo'body.post-type-post p.is-style-eccp-size-larger,
							 body.post-type-post [data-type="core/group"].is-style-eccp-size-larger,
							 body.post-type-post [data-type="core/table"].is-style-eccp-size-larger,
							 body.post-type-post [data-type="core/list"].is-style-eccp-size-larger,
							 body.post-type-post [data-type="core/details"].is-style-eccp-size-larger{';
										
							echo'width: 90%!important;';
					
						echo'}';
						
						// largeur block FAQ YOAST SEO
						echo'body.post-type-post div.wp-block-yoast-faq-block{';
										
							echo'width:' .esc_html($custom_gutenberg_blocks_settings['eccp_settings_width_block_faq_yoast_text_field']).'%!important;';
					
						echo'}';
						
						
						break;
					
					}
					
					// Largeur editeur pour les pages
					switch ($custom_gutenberg_editor_settings['eccp_settings_page_template_editor_select_field']) {
					
						//----------- petit modèle pour les pages -----------
						case 'small':
						
						echo'body.post-type-page .wp-block {';
						
							echo'max-width:'.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px!important;';
					
						echo'}';
						
						
						// largeur block paragraphe & block group & block tableau & bloc liste & bloc détails						
						echo'body.post-type-page p.is-style-eccp-size-very-small,
							 body.post-type-page [data-type="core/group"].is-style-eccp-size-very-small,
							 body.post-type-page [data-type="core/table"].is-style-eccp-size-very-small,
							 body.post-type-page [data-type="core/list"].is-style-eccp-size-very-small,
							 body.post-type-page [data-type="core/details"].is-style-eccp-size-very-small{';
								
							echo'width: calc(0.5 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px)!important;';
					
						echo'}';
											
						echo'body.post-type-page p.is-style-eccp-size-small,
							 body.post-type-page [data-type="core/group"].is-style-eccp-size-small,
							 body.post-type-page [data-type="core/table"].is-style-eccp-size-small,
							 body.post-type-page [data-type="core/list"].is-style-eccp-size-small,
							 body.post-type-page [data-type="core/details"].is-style-eccp-size-small{';
								
							echo'width: calc(0.6 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px)!important;';
					
						echo'}';
						
						echo'body.post-type-page p.is-style-eccp-size-regular,
						     body.post-type-page [data-type="core/group"].is-style-eccp-size-regular,
							 body.post-type-page [data-type="core/table"].is-style-eccp-size-regular,
							 body.post-type-page [data-type="core/list"].is-style-eccp-size-regular,
							 body.post-type-page [data-type="core/details"].is-style-eccp-size-regular{';
										
							echo'width: calc(0.7 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px)!important;';
					
						echo'}';
						
						echo'body.post-type-page p.is-style-eccp-size-large,
						     body.post-type-page [data-type="core/group"].is-style-eccp-size-large,
							 body.post-type-page [data-type="core/table"].is-style-eccp-size-large,
							 body.post-type-page [data-type="core/list"].is-style-eccp-size-large,
							 body.post-type-page [data-type="core/details"].is-style-eccp-size-large{';
										
							echo'width: calc(0.8 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px)!important;';
					
						echo'}';
						
						echo'body.post-type-page p.is-style-eccp-size-larger,
							 body.post-type-page [data-type="core/group"].is-style-eccp-size-larger,
							 body.post-type-page [data-type="core/table"].is-style-eccp-size-larger,
							 body.post-type-page [data-type="core/list"].is-style-eccp-size-larger,
							 body.post-type-page [data-type="core/details"].is-style-eccp-size-larger{';
										
							echo'width: calc(0.9 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px)!important;';
					
						echo'}';
						
						
						// largeur block FAQ YOAST SEO
						echo'body.post-type-page div.wp-block-yoast-faq-block{';
										
							echo'width: calc('.esc_html(strval($custom_gutenberg_blocks_settings['eccp_settings_width_block_faq_yoast_text_field']))/100 * esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px)!important;';
					
						echo'}';
						
						
						
						break;
						
						
						//----------- large modèle pour les pages -----------
						case 'large':
						
						echo'body.post-type-page .wp-block {';
						
							echo'max-width:'.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px!important;';
					
						echo'}';
						
						
						// largeur block paragraphe	& block group & bloc table & bloc liste	& bloc détails				
						echo'body.post-type-page p.is-style-eccp-size-very-small,
							 body.post-type-page [data-type="core/group"].is-style-eccp-size-very-small,
							 body.post-type-page [data-type="core/table"].is-style-eccp-size-very-small,
							 body.post-type-page [data-type="core/list"].is-style-eccp-size-very-small,
							 body.post-type-page [data-type="core/details"].is-style-eccp-size-very-small{';
								
							echo'width: calc(0.5 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px)!important;';
					
						echo'}';
											
						echo'body.post-type-page p.is-style-eccp-size-small,
							 body.post-type-page [data-type="core/group"].is-style-eccp-size-small,
							 body.post-type-page [data-type="core/table"].is-style-eccp-size-small,
							 body.post-type-page [data-type="core/list"].is-style-eccp-size-small,
							 body.post-type-page [data-type="core/details"].is-style-eccp-size-small{';
								
							echo'width: calc(0.6 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px)!important;';
					
						echo'}';
						
						echo'body.post-type-page p.is-style-eccp-size-regular,
						     body.post-type-page [data-type="core/group"].is-style-eccp-size-regular,
							 body.post-type-page [data-type="core/table"].is-style-eccp-size-regular,
							 body.post-type-page [data-type="core/list"].is-style-eccp-size-regular,
							 body.post-type-page [data-type="core/details"].is-style-eccp-size-regular{';
										
							echo'width: calc(0.7 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px)!important;';
					
						echo'}';
						
						echo'body.post-type-page p.is-style-eccp-size-large,
						     body.post-type-page [data-type="core/group"].is-style-eccp-size-large,
							 body.post-type-page [data-type="core/table"].is-style-eccp-size-large,
							 body.post-type-page [data-type="core/list"].is-style-eccp-size-large,
							 body.post-type-page [data-type="core/details"].is-style-eccp-size-large{';
										
							echo'width: calc(0.8 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px)!important;';
					
						echo'}';
						
						echo'body.post-type-page p.is-style-eccp-size-larger,
							 body.post-type-page [data-type="core/group"].is-style-eccp-size-larger,
							 body.post-type-page [data-type="core/table"].is-style-eccp-size-larger,
							 body.post-type-page [data-type="core/table"].is-style-eccp-size-larger,
							 body.post-type-page [data-type="core/details"].is-style-eccp-size-larger{';
										
							echo'width: calc(0.9 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px)!important;';
					
						echo'}';
						
						
						// largeur block FAQ YOAST SEO
						echo'body.post-type-page div.wp-block-yoast-faq-block{';
										
							echo'width: calc('.esc_html(strval($custom_gutenberg_blocks_settings['eccp_settings_width_block_faq_yoast_text_field']))/100 * esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px)!important;';
					
						echo'}';
						
						
						
						break;
						
						
						//----------- pleine largeur pour les pages -----------
						//----------- ne fonctionne pas avec le thème Astra, -----------
						//----------- même avec l'extension kadence Block -----------
						case 'fullwidth':
						
						echo'body.post-type-page .wp-block{
							max-width: none!important;
						}';
						
						
						// largeur block paragraphe & block group & block table	& bloc liste & bloc détails					
						echo'body.post-type-page p.is-style-eccp-size-very-small,
							 body.post-type-page [data-type="core/group"].is-style-eccp-size-very-small,
							 body.post-type-page [data-type="core/table"].is-style-eccp-size-very-small,
							 body.post-type-page [data-type="core/list"].is-style-eccp-size-very-small,
							 body.post-type-page [data-type="core/details"].is-style-eccp-size-very-small{';
								
							echo'width: 50%!important;';
					
						echo'}';
											
						echo'body.post-type-page p.is-style-eccp-size-small,
							 body.post-type-page [data-type="core/group"].is-style-eccp-size-small,
							 body.post-type-page [data-type="core/table"].is-style-eccp-size-small,
							 body.post-type-page [data-type="core/list"].is-style-eccp-size-small,
							 body.post-type-page [data-type="core/details"].is-style-eccp-size-small{';
								
							echo'width: 60%!important;';
					
						echo'}';
						
						echo'body.post-type-page p.is-style-eccp-size-regular,
						     body.post-type-page [data-type="core/group"].is-style-eccp-size-regular,
							 body.post-type-page [data-type="core/table"].is-style-eccp-size-regular,
							 body.post-type-page [data-type="core/list"].is-style-eccp-size-regular,
							 body.post-type-page [data-type="core/details"].is-style-eccp-size-regular{';
							echo'width: 70%!important;';
					
						echo'}';
						
						echo'body.post-type-page p.is-style-eccp-size-large,
						     body.post-type-page [data-type="core/group"].is-style-eccp-size-large,
							 body.post-type-page [data-type="core/table"].is-style-eccp-size-large,
							 body.post-type-page [data-type="core/list"].is-style-eccp-size-large,
							 body.post-type-page [data-type="core/details"].is-style-eccp-size-large{';
										
							echo'width: 80%!important;';
					
						echo'}';
						
						echo'body.post-type-page p.is-style-eccp-size-larger,
							 body.post-type-page [data-type="core/group"].is-style-eccp-size-larger,
							 body.post-type-page [data-type="core/table"].is-style-eccp-size-larger,
							 body.post-type-page [data-type="core/list"].is-style-eccp-size-larger,
							 body.post-type-page [data-type="core/details"].is-style-eccp-size-larger{';
										
							echo'width: 90%!important;';
					
						echo'}';
						
						
						// largeur block FAQ YOAST SEO
						echo'body.post-type-page div.wp-block-yoast-faq-block{';
										
							echo'width:' .esc_html($custom_gutenberg_blocks_settings['eccp_settings_width_block_faq_yoast_text_field']).'%!important;';
					
						echo'}';
						
						
						
						break;
					
					}
					
					
					// Largeur editeur pour les Custom Post Type
					
					// s'il ya des Custom Post Type
					if ( !empty($slug_cpt = eccp_get_registered_post_types()) ) {
						
						switch ($custom_gutenberg_editor_settings['eccp_settings_cpt_template_editor_select_field']) {
						
							//----------- petit modèle pour les CPT -----------
							case 'small':
							
							foreach ($slug_cpt as $key => $value) {
								
								// on récupère pour les CPT un tableau associatif : $slug_cpt
								// dont la clé donne le nom de nos CPT et la valeur le slug du CPT
								// récupère aussi a quelques exception prés des slug de post type 
								// qui ne sont pas des CPT, ex: e-landing-page que l'on écarte en les définissant dans $slug_no_cpt
								// si le slug est bien un slug de CPT alors on peut appliquer les régles CSS
								if  ( !in_array($value, $slug_no_cpt) )  {
								
									echo'body.post-type-'.$value.' .wp-block {'; 
							
									echo'max-width:'.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px!important;';
							
									echo'}';
									
									
									// largeur block paragraphe	& block group & block table & bloc liste & bloc détails
									echo'body.post-type-'.$value.' p.is-style-eccp-size-very-small,
										 body.post-type-'.$value.' [data-type="core/group"].is-style-eccp-size-very-small,
										 body.post-type-'.$value.' [data-type="core/table"].is-style-eccp-size-very-small,
										 body.post-type-'.$value.' [data-type="core/list"].is-style-eccp-size-very-small,
										 body.post-type-'.$value.' [data-type="core/details"].is-style-eccp-size-very-small{';
																				
										echo'width: calc(0.5 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px)!important;';
								
									echo'}';
									
									echo'body.post-type-'.$value.' p.is-style-eccp-size-small,
										 body.post-type-'.$value.' [data-type="core/group"].is-style-eccp-size-small,
										 body.post-type-'.$value.' [data-type="core/table"].is-style-eccp-size-small,
										 body.post-type-'.$value.' [data-type="core/list"].is-style-eccp-size-small,
										 body.post-type-'.$value.' [data-type="core/details"].is-style-eccp-size-small{';
																				
										echo'width: calc(0.6 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px)!important;';
								
									echo'}';
									
									echo'body.post-type-'.$value.' p.is-style-eccp-size-regular,
										 body.post-type-'.$value.' [data-type="core/group"].is-style-eccp-size-regular,
										 body.post-type-'.$value.' [data-type="core/table"].is-style-eccp-size-regular,
										 body.post-type-'.$value.' [data-type="core/list"].is-style-eccp-size-regular,
										 body.post-type-'.$value.' [data-type="core/details"].is-style-eccp-size-regular{';
																						
										echo'width: calc(0.7 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px)!important;';
								
									echo'}';
									
									echo'body.post-type-'.$value.' p.is-style-eccp-size-large,
										 body.post-type-'.$value.' [data-type="core/group"].is-style-eccp-size-large,
										 body.post-type-'.$value.' [data-type="core/table"].is-style-eccp-size-large,
										 body.post-type-'.$value.' [data-type="core/list"].is-style-eccp-size-large,
										 body.post-type-'.$value.' [data-type="core/details"].is-style-eccp-size-large{';
																						
										echo'width: calc(0.8 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px)!important;';
								
									echo'}';
									
									echo'body.post-type-'.$value.' p.is-style-eccp-size-larger,
										 body.post-type-'.$value.' [data-type="core/group"].is-style-eccp-size-larger,
										 body.post-type-'.$value.' [data-type="core/table"].is-style-eccp-size-larger,
										 body.post-type-'.$value.' [data-type="core/list"].is-style-eccp-size-larger,
										 body.post-type-'.$value.' [data-type="core/details"].is-style-eccp-size-larger{';
																						
										echo'width: calc(0.9 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px)!important;';
								
									echo'}';
									
									
									// largeur block FAQ YOAST SEO
									echo'body.post-type-'.$value.' div.wp-block-yoast-faq-block{';
													
										echo'width: calc('.esc_html(strval($custom_gutenberg_blocks_settings['eccp_settings_width_block_faq_yoast_text_field']))/100 * esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px)!important;';
								
									echo'}';
									
								
								}
								
								
								// Régles pour le plugin The Events Calendar(Mise à jour version 2.0)
								// ce n'est pas le slug mais le nom du post type qui est pris comme référence
								// par The Events Calendar pour appliquer des régles CSS.
								if ($key == 'tribe_events') {
									
									echo'body.post-type-'.$key.' .wp-block {'; 
							
									echo'max-width:'.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px!important;';
							
									echo'}';
									
									// largeur block paragraphe	& block group & block table & bloc liste & bloc tétails
									echo'body.post-type-'.$key.' p.is-style-eccp-size-very-small,
										 body.post-type-'.$key.' [data-type="core/group"].is-style-eccp-size-very-small,
										 body.post-type-'.$key.' [data-type="core/table"].is-style-eccp-size-very-small,
										 body.post-type-'.$key.' [data-type="core/list"].is-style-eccp-size-very-small,
										 body.post-type-'.$key.' [data-type="core/details"].is-style-eccp-size-very-small{';
																				
										echo'width: calc(0.5 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px)!important;';
								
									echo'}';
									
									
									// largeur block paragraphe	& block group & block tableau & bloc liste & bloc détails
									echo'body.post-type-'.$key.' p.is-style-eccp-size-small,
										 body.post-type-'.$key.' [data-type="core/group"].is-style-eccp-size-small,
										 body.post-type-'.$key.' [data-type="core/table"].is-style-eccp-size-small,
										 body.post-type-'.$key.' [data-type="core/list"].is-style-eccp-size-small,
										 body.post-type-'.$key.' [data-type="core/details"].is-style-eccp-size-small{';
																				
										echo'width: calc(0.6 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px)!important;';
								
									echo'}';
									
									echo'body.post-type-'.$key.' p.is-style-eccp-size-regular,
										 body.post-type-'.$key.' [data-type="core/group"].is-style-eccp-size-regular,
										 body.post-type-'.$key.' [data-type="core/table"].is-style-eccp-size-regular,
										 body.post-type-'.$key.' [data-type="core/list"].is-style-eccp-size-regular,
										 body.post-type-'.$key.' [data-type="core/details"].is-style-eccp-size-regular{';
																						
										echo'width: calc(0.7 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px)!important;';
								
									echo'}';
									
									echo'body.post-type-'.$key.' p.is-style-eccp-size-large,
										 body.post-type-'.$key.' [data-type="core/group"].is-style-eccp-size-large,
										 body.post-type-'.$key.' [data-type="core/table"].is-style-eccp-size-large,
										 body.post-type-'.$key.' [data-type="core/list"].is-style-eccp-size-large,
										 body.post-type-'.$key.' [data-type="core/details"].is-style-eccp-size-large{';
													
										echo'width: calc(0.8 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px)!important;';
								
									echo'}';
									
									echo'body.post-type-'.$key.' p.is-style-eccp-size-larger,
										 body.post-type-'.$key.' [data-type="core/group"].is-style-eccp-size-larger,
										 body.post-type-'.$key.' [data-type="core/table"].is-style-eccp-size-larger,
										 body.post-type-'.$key.' [data-type="core/list"].is-style-eccp-size-larger,
										 body.post-type-'.$key.' [data-type="core/details"].is-style-eccp-size-larger{';
													
										echo'width: calc(0.9 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field']) ).'px)!important;';
								
									echo'}';
									
								}
								
			
							}
							
							
							break;
							
							//----------- large modèle pour les CPT -----------
							case 'large':
							
							foreach ($slug_cpt as $key => $value) {
								
								// si le slug est bien un slug de CPT
								if  ( !in_array($value, $slug_no_cpt) )  {
								
									echo'body.post-type-'.$value.' .wp-block {'; 
							
									echo'max-width:'.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px!important;';
							
									echo'}';
									
									// largeur block paragraphe & block group & bloc table & bloc liste	& bloc détails					
									echo'body.post-type-'.$value.' p.is-style-eccp-size-very-small,
										 body.post-type-'.$value.' [data-type="core/group"].is-style-eccp-size-very-small,
										 body.post-type-'.$value.' [data-type="core/table"].is-style-eccp-size-very-small,
										 body.post-type-'.$value.' [data-type="core/list"].is-style-eccp-size-very-small,
										 body.post-type-'.$value.' [data-type="core/details"].is-style-eccp-size-very-small{';
											
										echo'width: calc(0.5 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px)!important;';
								
									echo'}';
															
									echo'body.post-type-'.$value.' p.is-style-eccp-size-small,
										 body.post-type-'.$value.' [data-type="core/group"].is-style-eccp-size-small,
										 body.post-type-'.$value.' [data-type="core/table"].is-style-eccp-size-small,
										 body.post-type-'.$value.' [data-type="core/list"].is-style-eccp-size-small,
										 body.post-type-'.$value.' [data-type="core/details"].is-style-eccp-size-small{';
											
										echo'width: calc(0.6 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px)!important;';
								
									echo'}';
									
									echo'body.post-type-'.$value.' p.is-style-eccp-size-regular,
										 body.post-type-'.$value.' [data-type="core/group"].is-style-eccp-size-regular,
										 body.post-type-'.$value.' [data-type="core/table"].is-style-eccp-size-regular,
										 body.post-type-'.$value.' [data-type="core/list"].is-style-eccp-size-regular,
										 body.post-type-'.$value.' [data-type="core/details"].is-style-eccp-size-regular{';
													
										echo'width: calc(0.7 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px)!important;';
								
									echo'}';
									
									echo'body.post-type-'.$value.' p.is-style-eccp-size-large,
										 body.post-type-'.$value.' [data-type="core/group"].is-style-eccp-size-large,
										 body.post-type-'.$value.' [data-type="core/table"].is-style-eccp-size-large,
										 body.post-type-'.$value.' [data-type="core/list"].is-style-eccp-size-large,
										 body.post-type-'.$value.' [data-type="core/details"].is-style-eccp-size-large{';
													
										echo'width: calc(0.8 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px)!important;';
								
									echo'}';
									
									echo'body.post-type-'.$value.' p.is-style-eccp-size-larger,
										 body.post-type-'.$value.' [data-type="core/group"].is-style-eccp-size-larger,
										 body.post-type-'.$value.' [data-type="core/table"].is-style-eccp-size-larger,
										 body.post-type-'.$value.' [data-type="core/list"].is-style-eccp-size-larger,
										 body.post-type-'.$value.' [data-type="core/details"].is-style-eccp-size-larger{';
													
										echo'width: calc(0.9 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px)!important;';
								
									echo'}';
									
									// largeur block FAQ YOAST SEO
									echo'body.post-type-'.$value.' div.wp-block-yoast-faq-block{';
													
										echo'width: calc('.esc_html(strval($custom_gutenberg_blocks_settings['eccp_settings_width_block_faq_yoast_text_field']))/100 * esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px)!important;';
								
									echo'}';
								
								}
								
								// Régles pour le plugin The Events Calendar(Mise à jour version 2.0)
								// ce n'est pas le slug mais le nom du post type qui est pris comme référence
								// par The Events Calendar pour appliquer des régles CSS.
								if ($key == 'tribe_events') {
									
									echo'body.post-type-'.$key.' .wp-block {'; 
							
									echo'max-width:'.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px!important;';
							
									echo'}';
									
									
									// largeur block paragraphe	& block group & block table & bloc liste & bloc détails					
									echo'body.post-type-'.$key.' p.is-style-eccp-size-very-small,
										 body.post-type-'.$key.' [data-type="core/group"].is-style-eccp-size-very-small,
										 body.post-type-'.$key.' [data-type="core/table"].is-style-eccp-size-very-small,
										 body.post-type-'.$key.' [data-type="core/list"].is-style-eccp-size-very-small,
										 body.post-type-'.$key.' [data-type="core/details"].is-style-eccp-size-very-small{';
											
										echo'width: calc(0.5 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px)!important;';
								
									echo'}';
														
									echo'body.post-type-'.$key.' p.is-style-eccp-size-small,
										 body.post-type-'.$key.' [data-type="core/group"].is-style-eccp-size-small,
										 body.post-type-'.$key.' [data-type="core/table"].is-style-eccp-size-small,
										 body.post-type-'.$key.' [data-type="core/list"].is-style-eccp-size-small,
										 body.post-type-'.$key.' [data-type="core/details"].is-style-eccp-size-small{';
											
										echo'width: calc(0.6 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px)!important;';
								
									echo'}';
									
									echo'body.post-type-'.$key.' p.is-style-eccp-size-regular,
										 body.post-type-'.$key.' [data-type="core/group"].is-style-eccp-size-regular,
										 body.post-type-'.$key.' [data-type="core/table"].is-style-eccp-size-regular,
										 body.post-type-'.$key.' [data-type="core/list"].is-style-eccp-size-regular,
										 body.post-type-'.$key.' [data-type="core/details"].is-style-eccp-size-regular{';
													
										echo'width: calc(0.7 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px)!important;';
								
									echo'}';
									
									echo'body.post-type-'.$key.' p.is-style-eccp-size-large,
										 body.post-type-'.$key.' [data-type="core/group"].is-style-eccp-size-large,
										 body.post-type-'.$key.' [data-type="core/table"].is-style-eccp-size-large,
										 body.post-type-'.$key.' [data-type="core/list"].is-style-eccp-size-large,
										 body.post-type-'.$key.' [data-type="core/details"].is-style-eccp-size-large{';
													
										echo'width: calc(0.8 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px)!important;';
								
									echo'}';
									
									echo'body.post-type-'.$key.' p.is-style-eccp-size-larger,
										 body.post-type-'.$key.' [data-type="core/group"].is-style-eccp-size-larger,
										 body.post-type-'.$key.' [data-type="core/table"].is-style-eccp-size-larger,
										 body.post-type-'.$key.' [data-type="core/list"].is-style-eccp-size-larger,
										 ody.post-type-'.$key.' [data-type="core/details"].is-style-eccp-size-larger{';
													
										echo'width: calc(0.9 * '.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field']) ).'px)!important;';
								
									echo'}';
									
								}
			
							}
							
							break;
							
							//----------- pleine largeur pour les CPT -----------
							case 'fullwidth':
							
							foreach ($slug_cpt as $key => $value) {
								
								// si le slug est bien un slug de CPT
								if  ( !in_array($value, $slug_no_cpt) )  {
							
									echo'body.post-type-'.$value.' .wp-block{
										max-width: none!important;
									}';
									
									
									// largeur block paragraphe	& block group & block table & bloc liste & bloc détails					
									echo'body.post-type-'.$value.' p.is-style-eccp-size-very-small,
										 body.post-type-'.$value.' [data-type="core/group"].is-style-eccp-size-very-small,
										 body.post-type-'.$value.' [data-type="core/table"].is-style-eccp-size-very-small,
										 body.post-type-'.$value.' [data-type="core/list"].is-style-eccp-size-very-small,
										 body.post-type-'.$value.' [data-type="core/details"].is-style-eccp-size-very-small{';
											
										echo'width: 50%!important;';
								
									echo'}';
													
									echo'body.post-type-'.$value.' p.is-style-eccp-size-small,
										 body.post-type-'.$value.' [data-type="core/group"].is-style-eccp-size-small,
										 body.post-type-'.$value.' [data-type="core/table"].is-style-eccp-size-small,
										 body.post-type-'.$value.' [data-type="core/list"].is-style-eccp-size-small,
										 body.post-type-'.$value.' [data-type="core/details"].is-style-eccp-size-small{';
											
										echo'width: 60%!important;';
								
									echo'}';
									
									echo'body.post-type-'.$value.' p.is-style-eccp-size-regular,
										 body.post-type-'.$value.' [data-type="core/group"].is-style-eccp-size-regular,
										 body.post-type-'.$value.' [data-type="core/table"].is-style-eccp-size-regular,
										 body.post-type-'.$value.' [data-type="core/list"].is-style-eccp-size-regular,
										 body.post-type-'.$value.' [data-type="core/details"].is-style-eccp-size-regular{';
													
										echo'width: 70%!important;';
								
									echo'}';
									
									echo'body.post-type-'.$value.' p.is-style-eccp-size-large,
										 body.post-type-'.$value.' [data-type="core/group"].is-style-eccp-size-large,
										 body.post-type-'.$value.' [data-type="core/table"].is-style-eccp-size-large,
										 body.post-type-'.$value.' [data-type="core/list"].is-style-eccp-size-large,
										 body.post-type-'.$value.' [data-type="core/details"].is-style-eccp-size-large{';
													
										echo'width: 80%!important;';
								
									echo'}';
									
									echo'body.post-type-'.$value.' p.is-style-eccp-size-larger,
										 body.post-type-'.$value.' [data-type="core/group"].is-style-eccp-size-larger,
										 body.post-type-'.$value.' [data-type="core/table"].is-style-eccp-size-larger,
										 body.post-type-'.$value.' [data-type="core/list"].is-style-eccp-size-larger,
										 body.post-type-'.$value.' [data-type="core/details"].is-style-eccp-size-larger{';
													
										echo'width: 90%!important;';
								
									echo'}';
									
									// largeur block FAQ YOAST SEO
									echo'body.post-type-'.$value.' div.wp-block-yoast-faq-block{';
													
										echo'width:' .esc_html($custom_gutenberg_blocks_settings['eccp_settings_width_block_faq_yoast_text_field']).'%!important;';
								
									echo'}';
									
								}
								
								// Régles pour le plugin The Events Calendar(Mise à jour version 2.0)
								// ce n'est pas le slug mais le nom du post type qui est pris comme référence
								// par The Events Calendar pour appliquer des régles CSS.
								if ($key == 'tribe_events') {
									
									echo'body.post-type-'.$key.' .wp-block {'; 
							
										echo'max-width: none!important;';
							
									echo'}';
									
									
									// largeur block paragraphe	& block group & block table & bloc liste & bloc détails					
									echo'body.post-type-'.$key.' p.is-style-eccp-size-very-small,
										 body.post-type-'.$key.' [data-type="core/group"].is-style-eccp-size-very-small,
										 body.post-type-'.$key.' [data-type="core/table"].is-style-eccp-size-very-small,
										 body.post-type-'.$key.' [data-type="core/liste"].is-style-eccp-size-very-small,
										 body.post-type-'.$key.' [data-type="core/details"].is-style-eccp-size-very-small{';
											
										echo'width: 50%!important;';
								
									echo'}';
														
									echo'body.post-type-'.$key.' p.is-style-eccp-size-small,
										 body.post-type-'.$key.' [data-type="core/group"].is-style-eccp-size-small,
										 body.post-type-'.$key.' [data-type="core/table"].is-style-eccp-size-small,
										 body.post-type-'.$key.' [data-type="core/list"].is-style-eccp-size-small,
										 body.post-type-'.$key.' [data-type="core/details"].is-style-eccp-size-small{';
											
										echo'width: 60%!important;';
								
									echo'}';
									
									echo'body.post-type-'.$key.' p.is-style-eccp-size-regular,
										 body.post-type-'.$key.' [data-type="core/group"].is-style-eccp-size-regular,
										 body.post-type-'.$key.' [data-type="core/table"].is-style-eccp-size-regular,
										 body.post-type-'.$key.' [data-type="core/list"].is-style-eccp-size-regular,
										 body.post-type-'.$key.' [data-type="core/details"].is-style-eccp-size-regular{';
													
										echo'width: 70%!important;';
								
									echo'}';
									
									echo'body.post-type-'.$key.' p.is-style-eccp-size-large,
										 body.post-type-'.$key.' [data-type="core/group"].is-style-eccp-size-large,
										 body.post-type-'.$key.' [data-type="core/table"].is-style-eccp-size-large,
										 body.post-type-'.$key.' [data-type="core/list"].is-style-eccp-size-large,
										 body.post-type-'.$key.' [data-type="core/details"].is-style-eccp-size-large{';
													
										echo'width: 80%!important;';
								
									echo'}';
									
									echo'body.post-type-'.$key.' p.is-style-eccp-size-larger,
										 body.post-type-'.$key.' [data-type="core/group"].is-style-eccp-size-larger,
										 body.post-type-'.$key.' [data-type="core/table"].is-style-eccp-size-larger,
										 body.post-type-'.$key.' [data-type="core/list"].is-style-eccp-size-larger,
										 body.post-type-'.$key.' [data-type="core/details"].is-style-eccp-size-larger{';
													
										echo'width: 90%!important;';
								
									echo'}';
									
								}
							
							}
							
							break;
						
						}
					
					} // Fin  s'il ya des Custom Post Type
					

				}
				
				
				/*------------------- TITRE PAGE & ARTICLE & CPT BACK OFFICE --------------------------*/
				
				// Alignement du titre de l'article ou page ou CPT
				echo'.editor-post-title__input{';
					
					echo'text-align:'.$custom_gutenberg_editor_settings['eccp_settings_page_title_alignment_select_field'].';';
					
				echo'}';
				
			
				/*-------------------BLOC RÉUTILISABLE BLOCKQUOTE BACK OFFICE --------------------------
			
				/* On régle la largeur automatique du bloc en fonction de son contenu
				avec les régles position: absolute ou float:left mais cela pose un problème.
				j'ai donc pris une position relative et limiter la largeur à width:50% 
				par rapport à l'interface publique mofification de la régle: border:none!important 
				et ajout de la règle: padding-left:0px!important	 
				par rapport a l'interface publique on laisse les marges left et right à auto 
				width valeur différente de l'interface publique pour un même rendu */
				
				echo'.block-quote{
					position: relative;
					font-style: italic;
					border:none!important;
					margin-top:40px!important;
					margin-bottom:40px!important;
					padding-left:0px!important;';
				echo'}';
				  
				/* Modif version 2.3: la graisse & taille de texte sont désormais des réglages
				   du bloc natif Bloc Quote de WordPress
				echo'.block-quote p {';
				  
				echo'font-size:'.esc_html($reusable_blocks_settings['eccp_settings_font_size_blockquote_text_field']).'px!important;';
				echo'font-weight:'.esc_html($reusable_blocks_settings['eccp_settings_font_weight_blockquote_select_field']).'!important;';
				
				echo'}';
				 */ 
				
				/* 
				   Modif Version 1.7
				   Blockquote de gauche,j'ai reformaté l'image SVG 
				   en URL data(https://websemantics.uk/tools/svg-to-background-image-conversion/) 
				   pour l'utiliser comme images d'arrière-plan, au lieu de l'URL relative 
				   par rapport au répertoire du plugin: 
				   echo'background: url('.EDITOR_CUSTOM_COLOR_PALETTE_URL.'/img/editeur-gutenberg/rc-blockquote.svg'.');';	
				   Ceci afin de modifier la couleur de fond($blocquote_color) 
				   et l'opacité($blocquote_opacity)directement dans l'URL data 
				*/ 
				
				// on met en forme la couleur des guillemets et l'opacité pour l'URL data 
				// qui charge l'image SVG des guillemets
				// substr retourne une sous chaine de la position:1 jusqu'a la fin				
				$blocquote_color = substr($reusable_blocks_settings['eccp_settings_quotation_marks_color_text_field'],1);
				// strval renvoi une variable au format chaine
				$blocquote_opacity = strval( intval($reusable_blocks_settings['eccp_settings_quotation_marks_opacity_text_field'])/100 );
				
				echo'.block-quote:before {
					position: absolute;
					content: "";
					top: -19px;
					left: -67px;
					height: 55px;
					width: 53px;';
				echo'background-image: url("data:image/svg+xml;charset=utf8,%3C?xml version=\'1.0\' encoding=\'UTF-8\' standalone=\'no\'?%3E%3Csvg xmlns:dc=\'http://purl.org/dc/elements/1.1/\' xmlns:cc=\'http://creativecommons.org/ns%23\' xmlns:rdf=\'http://www.w3.org/1999/02/22-rdf-syntax-ns%23\' xmlns:svg=\'http://www.w3.org/2000/svg\' xmlns=\'http://www.w3.org/2000/svg\' xmlns:sodipodi=\'http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\' xmlns:inkscape=\'http://www.inkscape.org/namespaces/inkscape\' width=\'53\' height=\'55\' version=\'1.1\' id=\'svg8\' sodipodi:docname=\'rc-blockquote.svg\' inkscape:version=\'1.0 (4035a4fb49, 2020-05-01)\'%3E%3Cmetadata id=\'metadata14\'%3E%3Crdf:RDF%3E%3Ccc:Work rdf:about=\'\'%3E%3Cdc:format%3Eimage/svg+xml%3C/dc:format%3E%3Cdc:type rdf:resource=\'http://purl.org/dc/dcmitype/StillImage\' /%3E%3Cdc:title /%3E%3C/cc:Work%3E%3C/rdf:RDF%3E%3C/metadata%3E%3Cdefs id=\'defs12\'%3E%3Cfilter height=\'1.0000094\' y=\'-4.7127273e-06\' width=\'1.0000216\' x=\'-1.08e-05\' id=\'filter842\' style=\'color-interpolation-filters:sRGB\' inkscape:collect=\'always\'%3E%3CfeGaussianBlur id=\'feGaussianBlur844\' stdDeviation=\'0.000108\' inkscape:collect=\'always\' /%3E%3C/filter%3E%3Cfilter height=\'1.0000094\' y=\'-4.7127273e-06\' width=\'1.0000216\' x=\'-1.08e-05\' id=\'filter846\' style=\'color-interpolation-filters:sRGB\' inkscape:collect=\'always\'%3E%3CfeGaussianBlur id=\'feGaussianBlur848\' stdDeviation=\'0.000108\' inkscape:collect=\'always\' /%3E%3C/filter%3E%3C/defs%3E%3Csodipodi:namedview inkscape:document-rotation=\'0\' pagecolor=\'%23ffffff\' bordercolor=\'%23666666\' borderopacity=\'1\' objecttolerance=\'10\' gridtolerance=\'10\' guidetolerance=\'10\' inkscape:pageopacity=\'0\' inkscape:pageshadow=\'2\' inkscape:window-width=\'1366\' inkscape:window-height=\'705\' id=\'namedview10\' showgrid=\'false\' inkscape:zoom=\'8.6\' inkscape:cx=\'29.175176\' inkscape:cy=\'27.5\' inkscape:window-x=\'-8\' inkscape:window-y=\'-8\' inkscape:window-maximized=\'1\' inkscape:current-layer=\'svg8\' /%3E%3Cg id=\'g840\'%3E%3Cpath id=\'‘\' d=\'m 24,0 v 7.178 c -3.11,0.905 -5.441,3.185 -6.996,6.839 -1.555,3.654 -2.332,8.681 -2.332,15.084 v 2.037 H 24 V 55 H 0 V 34.242 C 0,23.7 1.992,15.569 5.976,9.846 9.96,4.123 15.968,0.84 24,0 Z\' style=\'display:inline;opacity:'.$blocquote_opacity.';fill:%23'.$blocquote_color.';fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1;filter:url(%23filter842)\' /%3E%3Cpath id=\'‘-copy\' d=\'m 53,0 v 7.178 c -3.11,0.905 -5.441,3.185 -6.996,6.839 -1.555,3.654 -2.332,8.681 -2.332,15.084 v 2.037 H 53 V 55 H 29 V 34.242 C 29,23.701 30.992,15.569 34.976,9.846 38.96,4.123 44.968,0.84 53,0 Z\' style=\'display:inline;opacity:'.$blocquote_opacity.';fill:%23'.$blocquote_color.';fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1;filter:url(%23filter846)\' inkscape:highlight-color=\'4294967295\' /%3E%3C/g%3E%3C/svg%3E");';	
				
				echo'}';
				
				
				// Blockquote de droite par rapport a l'interface publique on ajoute les régles 
				 // margin-left: auto & margin-top:auto  
				  
				echo'.block-quote:after {
					position: absolute;
					content: "";
					right: -67px!important;
					height: 55px;
					width: 53px;
					margin-top:auto;
					margin-left:auto;
					-webkit-transform: rotate(180deg);
					transform: rotate(180deg);';
				echo'background-image: url("data:image/svg+xml;charset=utf8,%3C?xml version=\'1.0\' encoding=\'UTF-8\' standalone=\'no\'?%3E%3Csvg xmlns:dc=\'http://purl.org/dc/elements/1.1/\' xmlns:cc=\'http://creativecommons.org/ns%23\' xmlns:rdf=\'http://www.w3.org/1999/02/22-rdf-syntax-ns%23\' xmlns:svg=\'http://www.w3.org/2000/svg\' xmlns=\'http://www.w3.org/2000/svg\' xmlns:sodipodi=\'http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\' xmlns:inkscape=\'http://www.inkscape.org/namespaces/inkscape\' width=\'53\' height=\'55\' version=\'1.1\' id=\'svg8\' sodipodi:docname=\'rc-blockquote.svg\' inkscape:version=\'1.0 (4035a4fb49, 2020-05-01)\'%3E%3Cmetadata id=\'metadata14\'%3E%3Crdf:RDF%3E%3Ccc:Work rdf:about=\'\'%3E%3Cdc:format%3Eimage/svg+xml%3C/dc:format%3E%3Cdc:type rdf:resource=\'http://purl.org/dc/dcmitype/StillImage\' /%3E%3Cdc:title /%3E%3C/cc:Work%3E%3C/rdf:RDF%3E%3C/metadata%3E%3Cdefs id=\'defs12\'%3E%3Cfilter height=\'1.0000094\' y=\'-4.7127273e-06\' width=\'1.0000216\' x=\'-1.08e-05\' id=\'filter842\' style=\'color-interpolation-filters:sRGB\' inkscape:collect=\'always\'%3E%3CfeGaussianBlur id=\'feGaussianBlur844\' stdDeviation=\'0.000108\' inkscape:collect=\'always\' /%3E%3C/filter%3E%3Cfilter height=\'1.0000094\' y=\'-4.7127273e-06\' width=\'1.0000216\' x=\'-1.08e-05\' id=\'filter846\' style=\'color-interpolation-filters:sRGB\' inkscape:collect=\'always\'%3E%3CfeGaussianBlur id=\'feGaussianBlur848\' stdDeviation=\'0.000108\' inkscape:collect=\'always\' /%3E%3C/filter%3E%3C/defs%3E%3Csodipodi:namedview inkscape:document-rotation=\'0\' pagecolor=\'%23ffffff\' bordercolor=\'%23666666\' borderopacity=\'1\' objecttolerance=\'10\' gridtolerance=\'10\' guidetolerance=\'10\' inkscape:pageopacity=\'0\' inkscape:pageshadow=\'2\' inkscape:window-width=\'1366\' inkscape:window-height=\'705\' id=\'namedview10\' showgrid=\'false\' inkscape:zoom=\'8.6\' inkscape:cx=\'29.175176\' inkscape:cy=\'27.5\' inkscape:window-x=\'-8\' inkscape:window-y=\'-8\' inkscape:window-maximized=\'1\' inkscape:current-layer=\'svg8\' /%3E%3Cg id=\'g840\'%3E%3Cpath id=\'‘\' d=\'m 24,0 v 7.178 c -3.11,0.905 -5.441,3.185 -6.996,6.839 -1.555,3.654 -2.332,8.681 -2.332,15.084 v 2.037 H 24 V 55 H 0 V 34.242 C 0,23.7 1.992,15.569 5.976,9.846 9.96,4.123 15.968,0.84 24,0 Z\' style=\'display:inline;opacity:'.$blocquote_opacity.';fill:%23'.$blocquote_color.';fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1;filter:url(%23filter842)\' /%3E%3Cpath id=\'‘-copy\' d=\'m 53,0 v 7.178 c -3.11,0.905 -5.441,3.185 -6.996,6.839 -1.555,3.654 -2.332,8.681 -2.332,15.084 v 2.037 H 53 V 55 H 29 V 34.242 C 29,23.701 30.992,15.569 34.976,9.846 38.96,4.123 44.968,0.84 53,0 Z\' style=\'display:inline;opacity:'.$blocquote_opacity.';fill:%23'.$blocquote_color.';fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1;filter:url(%23filter846)\' inkscape:highlight-color=\'4294967295\' /%3E%3C/g%3E%3C/svg%3E");';
				
				echo'}';
				
				// Pour les Articles on définit pour le blockquote une largeur fixe en pixel pour petit & large ecran
				// afin d'avoir la même largeur du blockquote mode plein écran activé ou pas
				switch ($custom_gutenberg_editor_settings['eccp_settings_post_template_editor_select_field']) {
						
					// petit modèle pour les Articles
					case 'small':
					
					 $width_blockquote_post = intval( ( $custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field'] * intval($reusable_blocks_settings['eccp_settings_width_blockquote_post_back_office_text_field'])/100 ) ) ;
					 $width_blockquote_post = strval($width_blockquote_post).'px';
					
					break;
					
					// large modèle pour les Articles
					case 'large':
					
					 $width_blockquote_post = intval( ( $custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field'] * intval($reusable_blocks_settings['eccp_settings_width_blockquote_post_back_office_text_field'])/100 ) ) ;
					 $width_blockquote_post = strval($width_blockquote_post).'px';
					
					break;
					
					// pleine largeur pour les Articles
					case 'fullwidth':
					
					$width_blockquote_post = $reusable_blocks_settings['eccp_settings_width_blockquote_post_back_office_text_field'].'%';
					
					break;

				}
				
				
				
				// largeur blockquote pour les articles en back office
				echo'body.post-type-post .block-quote{';
				
					echo'width:'.esc_html($width_blockquote_post).';';
				
				echo'}';
				
				
				// Pour les Pages on définit pour le blockquote une largeur fixe en pixel pour petit & large ecran
				// afin d'avoir la même largeur du blockquote mode plein écran activé ou pas
				switch ($custom_gutenberg_editor_settings['eccp_settings_page_template_editor_select_field']) {
						
					// petit modèle pour les Pages
					case 'small':
					
					 $width_blockquote_page = intval( ( $custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field'] * intval($reusable_blocks_settings['eccp_settings_width_blockquote_page_back_office_text_field'])/100 ) ) ;
					 $width_blockquote_page = strval($width_blockquote_page).'px';
					
					break;
					
					// large modèle pour les Pages
					case 'large':
					
					 $width_blockquote_page = intval( ( $custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field'] * intval($reusable_blocks_settings['eccp_settings_width_blockquote_page_back_office_text_field'])/100 ) ) ;
					 $width_blockquote_page = strval($width_blockquote_page).'px';
					
					break;
					
					// pleine largeur pour les Pages
					case 'fullwidth':
					
					$width_blockquote_page = $reusable_blocks_settings['eccp_settings_width_blockquote_page_back_office_text_field'].'%';
					
					break;

				}
				
				// largeur blockquote pour les pages en back office
				echo'body.post-type-page .block-quote{';
				
					echo'width:'.esc_html($width_blockquote_page).';';
				
				echo'}'; 
				
				
				// largeur blockquote pour les CPT en back office
				
				// s'il ya des Custom Post Type
				if ( !empty($slug_cpt = eccp_get_registered_post_types()) ) {
					
					// Pour les CPT on définit pour le Blockquote une largeur fixe en pixel pour petit & large ecran
					// afin d'avoir la même largeur du blockquote mode plein écran activé ou pas
					switch ($custom_gutenberg_editor_settings['eccp_settings_cpt_template_editor_select_field']) {
							
						// petit modèle pour les CPT
						case 'small':
						
						 $width_blockquote_cpt = intval( ( $custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field'] * intval($reusable_blocks_settings['eccp_settings_width_blockquote_cpt_back_office_text_field'])/100 ) ) ;
						 $width_blockquote_cpt = strval($width_blockquote_cpt).'px';
						
						break;
						
						// large modèle pour les CPT
						case 'large':
						
						 $width_blockquote_cpt = intval( ( $custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field'] * intval($reusable_blocks_settings['eccp_settings_width_blockquote_cpt_back_office_text_field'])/100 ) ) ;
						 $width_blockquote_cpt = strval($width_blockquote_cpt).'px';
						
						break;
						
						// pleine largeur pour les CPT
						case 'fullwidth':
						
						$width_blockquote_cpt = $reusable_blocks_settings['eccp_settings_width_blockquote_cpt_back_office_text_field'].'%';
						
						break;

					}
					
					foreach ($slug_cpt as $key => $value) {
						
						
						// on récupère pour les CPT un tableau associatif : $slug_cpt
						// dont la clé donne le nom de nos CPT et la valeur le slug du CPT
						// récupère aussi a quelques exception prés des slug de post type 
						// qui ne sont pas des CPT, ex: e-landing-page que l'on écarte en les définissant dans $slug_no_cpt
						// si le slug est bien un slug de CPT alors on peut appliquer les régles CSS
						if  ( !in_array($value, $slug_no_cpt) )  {
					
							// largeur blockquote pour les CPT en back office
							echo'body.post-type-'.$value.' .block-quote{';
							
								echo'width:'.esc_html($width_blockquote_cpt).';';
							
							echo'}'; 
					
						}
						
						// Régles pour le plugin The Events Calendar(Mise à jour version 2.0)
						// ce n'est pas le slug mais le nom du post type qui est pris comme référence
						// par The Events Calendar pour appliquer des régles CSS.
						if ($key == 'tribe_events') {

							 
							// largeur blockquote pour les CPT évènements en back office
							echo'body.post-type-'.$key.' .block-quote{';
							
								echo'width:'.esc_html($width_blockquote_cpt).';';
							
							echo'}';
							
						}
						
					
					}
				
					
				} // Fin s'il ya des Customm Post Type
				
				/*-------------------BLOC RÉUTILISABLE METTRE EN ÉVIDENCE BACK OFFICE --------------------------*/
				
				// bordure colorée orange #F37020 avec une transparence 
				echo'.mise-en-evidence {';
				
				echo'border-left: 5px solid '.esc_html($reusable_blocks_settings['eccp_settings_custom_paragraph_border_color']).';';
				
				echo' border-radius:4px;
					  padding:1.1em!important;
					  margin:1.1em!important;
					  font-size: 20px;';
					  
				echo'}';
				
				// Pour les Articles on définit pour le bloc mettre en évidence une largeur fixe en pixel 
				// pour petit & large ecran, afin d'avoir la même largeur 
				// mode plein écran activé ou pas 
				switch ($custom_gutenberg_editor_settings['eccp_settings_post_template_editor_select_field']) {
						
					// petit modèle pour les Articles
					case 'small':
					
					 $width = intval( ( $custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field'] * intval($reusable_blocks_settings['eccp_settings_custom_paragraph_width_post_back_office_text_field'])/100 ) ) ;
					 $width = strval($width).'px';
					
					break;
					
					// large modèle pour les Articles
					case 'large':
					
					 $width = intval( ( $custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field'] * intval($reusable_blocks_settings['eccp_settings_custom_paragraph_width_post_back_office_text_field'])/100 ) ) ;
					 $width = strval($width).'px';
					
					break;
					
					// pleine largeur pour les Articles
					case 'fullwidth':
					
					$width = $reusable_blocks_settings['eccp_settings_custom_paragraph_width_post_back_office_text_field'].'%';
					
					break;

				}
				
				// largeur bloc Mettre en Évidence pour les articles en back office
				echo'body.post-type-post .mise-en-evidence{';
				
					echo'width:'.esc_html($width).';';
				
				echo'}';
				
				
				//  Pour les Pages on définit pour le bloc mettre en évidence une largeur fixe en pixel 
				// pour petit & large ecran, afin d'avoir la même largeur 
				// mode plein écran activé ou pas 
				switch ($custom_gutenberg_editor_settings['eccp_settings_page_template_editor_select_field']) {
						
					// petit modèle pour les Pages
					case 'small':
					
					 $width = intval( ( $custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field'] * intval($reusable_blocks_settings['eccp_settings_custom_paragraph_width_page_back_office_text_field'])/100 ) ) ;
					 $width = strval($width).'px';
					
					break;
					
					// large modèle pour les Pages
					case 'large':
					
					 $width = intval( ( $custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field'] * intval($reusable_blocks_settings['eccp_settings_custom_paragraph_width_page_back_office_text_field'])/100 ) ) ;
					 $width = strval($width).'px';
					
					break;
					
					// pleine largeur pour les Pages
					case 'fullwidth':
					
					$width = $reusable_blocks_settings['eccp_settings_custom_paragraph_width_page_back_office_text_field'].'%';
					
					break;

				}
				
				
				// largeur  bloc Mettre en Évidence pour les pages en back office
				echo'body.post-type-page .mise-en-evidence{';
				
					echo'width:'.esc_html($width).';';
				
				echo'}'; 
				 
				 
				// largeur  bloc Mettre en Évidence pour les Custom Post Type 
				
				// s'il ya des Customm Post Type
				if ( !empty($slug_cpt = eccp_get_registered_post_types()) ) {
					
					// Pour les CPT on définit pour le bloc mettre en évidence une largeur fixe en pixel 
					// pour petit & large ecran, afin d'avoir la même largeur 
					// mode plein écran activé ou pas 
					switch ($custom_gutenberg_editor_settings['eccp_settings_cpt_template_editor_select_field']) {
							
						// petit modèle pour les CPT
						case 'small':
						
						 $width = intval( ( $custom_gutenberg_editor_settings['eccp_settings_small_template_editor_text_field'] * intval($reusable_blocks_settings['eccp_settings_custom_paragraph_width_cpt_back_office_text_field'])/100 ) ) ;
						 $width = strval($width).'px';
						
						break;
						
						// large modèle pour les CPT
						case 'large':
						
						 $width = intval( ( $custom_gutenberg_editor_settings['eccp_settings_large_template_editor_text_field'] * intval($reusable_blocks_settings['eccp_settings_custom_paragraph_width_cpt_back_office_text_field'])/100 ) ) ;
						 $width = strval($width).'px';
						
						break;
						
						// pleine largeur pour les CPT
						case 'fullwidth':
						
						$width = $reusable_blocks_settings['eccp_settings_custom_paragraph_width_cpt_back_office_text_field'].'%';
						
						break;

					}
					
					foreach ($slug_cpt as $key => $value) {
						
						// on récupère pour les CPT un tableau associatif : $slug_cpt
						// dont la clé donne le nom de nos CPT et la valeur le slug du CPT
						// récupère aussi a quelques exception prés des slug de post type 
						// qui ne sont pas des CPT, ex: e-landing-page que l'on écarte en les définissant dans $slug_no_cpt
						// si le slug est bien un slug de CPT alors on peut appliquer les régles CSS
						if  ( !in_array($value, $slug_no_cpt) )  {
							
							// largeur bloc Mettre en évidence pour les CPT
							echo'body.post-type-'.$value.' .mise-en-evidence{';
				
								echo'width:'.esc_html($width).';';
				
							echo'}'; 
					
						}
						
						// Régles pour le plugin The Events Calendar(Mise à jour version 2.0)
						// ce n'est pas le slug mais le nom du post type qui est pris comme référence
						// par The Events Calendar pour appliquer des régles CSS.
						if ($key == 'tribe_events') {
							
							// largeur bloc Mettre en évidence pour les CPT évènements
							echo'body.post-type-'.$key.' .mise-en-evidence{';
							
								echo'width:'.esc_html($width).';';
							
							echo'}';
							
						}
					
					}
				
					
				}
				
				
				/*----------------------------STYLE BOX SHADOW BACK OFFICE------------------------------*/
				
				/*------------- Style box shadow(page d'options du plugin) back office ---------------------*/
				// a partir de la version 2.8 le réglage Box Shadow est dans les paramètres du bloc 
				
				
				/*if( $custom_gutenberg_blocks_settings['eccp_settings_activate_box_shadow_paragraph_block_radio_field'] == 'yes' ) {
					
					// on fait la conversion en RGBA, la fonction retourne une chaine
					// soit pour une couleur #000000 avec opacité 0.5 ==> rgba(0,0,0,0.5)
					$rgba = eccp_hex2rgba( $custom_gutenberg_blocks_settings['eccp_settings_box_shadow_color_text_field'], 
                            intval($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_opacity_text_field'])/100 );
					
					
					
					// on corrige le bug avant d'appliquer l'effet Box Shadow : 
					// une valeur de 0 enregistré en base de données donne une chaine vide
					if ( empty($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_x_text_field']) ){
						$custom_gutenberg_blocks_settings['eccp_settings_box_shadow_x_text_field'] = '0';
					}
					
					if ( empty($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_y_text_field']) ){
						$custom_gutenberg_blocks_settings['eccp_settings_box_shadow_y_text_field'] = '0';
					}
					
					if ( empty($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_blur_text_field']) ){
						$custom_gutenberg_blocks_settings['eccp_settings_box_shadow_blur_text_field'] = '0';
					}
					
					if ( empty($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_spread_text_field']) ){
						$custom_gutenberg_blocks_settings['eccp_settings_box_shadow_spread_text_field'] = '0';
					}
					
					
					// Pour un bloc groupé avec un fond effet ombre de boite par défaut: 
					// box-shadow: 8px 8px 12px -8px rgba(0,0,0,0.5);
					// padding editeur gutenberg: 20px 30px pour un bloc groupé correspond 
					// a celles de l'interface publique
					// régle: padding: 1.25em 2.375em; ajouté pour thème Astra
				
					echo'body.wp-admin .wp-block-group.is-style-eccp-box-shadow{';
					   
						echo'box-shadow: '.esc_html(strval($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_x_text_field'])).'px '
										 .esc_html(strval($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_y_text_field'])).'px '
										 .esc_html(strval($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_blur_text_field'])).'px '
										 .esc_html(strval($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_spread_text_field'])).'px '
										 .esc_html($rgba).';';
						
						echo'padding: 1.25em 2.375em;';
						
					echo'}';
			
					// correction thème Generate press pour un bloc de paragraphes groupés
					echo'body.wp-admin .wp-block-group__inner-container{';
					
						echo'padding:0px!important;';
					
					echo'}';
			
					//Pour un  BLOC UN SEUL PARAGRAPHE AVEC UN FOND
					// ombre de boite par défaut: box-shadow: 8px 8px 12px -8px rgba(0,0,0,0.5); 
					// afin de correspondre à l'interface publique
					// régle: padding: 1.25em 2.375em; ajouté pour thème Astra
					echo'body.wp-admin p.is-style-eccp-box-shadow{';
						
						echo'box-shadow: '.esc_html(strval($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_x_text_field'])).'px '
										  .esc_html(strval($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_y_text_field'])).'px '
										  .esc_html(strval($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_blur_text_field'])).'px '
										  .esc_html(strval($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_spread_text_field'])).'px '
										  .esc_html($rgba).';';
						
						echo'background: #F0F2F6;';
						echo'padding: 1.25em 2.375em;';

					echo'}';
					
					
					//Pour un Boc Colonne
					echo'body.wp-admin .wp-block-column.is-style-eccp-box-shadow{';
						
						echo'box-shadow: '.esc_html(strval($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_x_text_field'])).'px '
										  .esc_html(strval($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_y_text_field'])).'px '
										  .esc_html(strval($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_blur_text_field'])).'px '
										  .esc_html(strval($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_spread_text_field'])).'px '
										  .esc_html($rgba).';';
					
					echo'}';
					
				 
				}*/
				
				/*---------------------- Style box shadow(React JS) back office-------------------------*/
				
				// Pour un BLOC GROUPE avec un effet ombre de boite 
				// les régles pour un effet box shadow sont appliqués 
				// directement en React Js
				// régle: padding: 1.25em 2.375em; ajouté pour thème Astra
			
				// la même régle est appliqué directement au bloc Group
				/*echo'body.wp-admin .wp-block-group.is-style-eccp-box-shadow{';
				   
					echo'padding: 1.25em 2.375em;';
					
				echo'}';*/
		
		
				// correction thème Generate press pour un bloc de paragraphes groupés
				echo'body.wp-admin .wp-block-group__inner-container{';
				
					echo'padding:0px!important;';
				
				echo'}';
		
				// Pour un BLOC PARAGRAPHE 
				// régle: padding: 1.25em 2.375em; ajouté pour thème Astra
				// les régles pour un effet box shadow sont appliqués 
				// directement en React Js
				echo'body.wp-admin p.eccp-box-shadow{';
					
					echo'padding: 1.25em 2.375em;';

				echo'}';
				
				
				// Pour Le Bloc image
				// on cible l'image du bloc,qu'on ne peut faire en React JS 
				// pour apliquer le style box shadow avec les variables
				// css déclarées et affectées par le script en React JS
				echo'body.wp-admin .wp-block-image.eccp-box-shadow img {';
			
				echo'box-shadow: calc(var(--eccp-horizontalBoxShadow, 0) * 1px) '.
								 'calc(var(--eccp-verticalBoxShadow, 0) * 1px) '.
								 'calc(var(--eccp-blurBoxShadow, 4) * 1px) '.
								 'calc(var(--eccp-spreadBoxShadow, 1) * 1px) '.
								 'var(--eccp-colorBoxShadow, rgba(0,0,0,0.2));';
				 
				echo'}';
				
				
				// Pour Le Bloc Média Texte
				// on cible l'image du bloc,qu'on ne peut faire en React JS 
				// pour apliquer le style box shadow avec les variables
				// css déclarées et affectées par le script en React JS
				echo'body.wp-admin .wp-block-media-text.eccp-box-shadow .wp-block-media-text__media img {';
			
				echo'box-shadow: calc(var(--eccp-horizontalBoxShadow, 20) * 1px) '.
								 'calc(var(--eccp-verticalBoxShadow, 20) * 1px) '.
								 'calc(var(--eccp-blurBoxShadow, 0) * 1px) '.
								 'calc(var(--eccp-spreadBoxShadow, 0) * 1px) '.
								 'var(--eccp-colorBoxShadow,#0E6487);';
				 
				echo'}';
				
				
				// Pour Le Bloc Bouton
				// On cible le lien du bouton qui a la classe: wp-block-button__link,
				// qu'on ne peut faire en React JS. 
				// On applique le style box shadow avec les variables
				// css déclarées et affectées par le script en React JS
				echo'body.wp-admin .wp-block-button.eccp-box-shadow .wp-block-button__link {';
			
				echo'box-shadow: calc(var(--eccp-horizontalBoxShadow, 0) * 1px) '.
								 'calc(var(--eccp-verticalBoxShadow, 0) * 1px) '.
								 'calc(var(--eccp-blurBoxShadow, 4) * 1px) '.
								 'calc(var(--eccp-spreadBoxShadow, 1) * 1px) '.
								 'var(--eccp-colorBoxShadow, rgba(0,0,0,0.2));';
				 
				echo'}';
				
				
				
				/*------------------- BLOC PARAGRAPHE BACK OFFICE --------------------------*/
				
				/*----------------------------Style Card back office------------------------------*/
				
				if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_card_paragraph_radio_field'] == 'yes' ) {
				
					echo'body.wp-admin p.is-style-eccp-card{';
							
							echo'box-shadow: 0 2px 1px -1px rgba(0,0,0,.2), 0 1px 1px 0 rgba(0,0,0,.14), 0 1px 3px 0 rgba(0,0,0,.12);';
							echo'border-radius: 4px;';
							echo'background: #F0F2F6;';
							echo'padding: 16px 16px 16px 16px;';

					echo'}';
					
					echo'body.wp-admin p.is-style-eccp-card.has-background{';
					
					
						echo'padding: 16px 16px 16px 16px!important;';

					
					echo'}';
					
				}

				/*----------------------------Style Notice: Question back office------------------------------*/
				
				// substr retourne une sous chaine de la position:1 jusqu'a la fin				
				$icone_color_notice_question = substr($custom_gutenberg_blocks_settings['eccp_settings_icon_color_style_notice_question_text_field'],1);
				
				
				if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_question_radio_field'] == 'yes' ) {
				
					// Version 2.7 modif pour le block Group
					echo'body.wp-admin p.is-style-eccp-notice-question,
					     body.wp-admin [data-type="core/group"].is-style-eccp-notice-question{';
					
							echo'background: #e6e0f7 url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'24px\' viewBox=\'0 0 24 24\' width=\'24px\' fill=\'%23'.esc_html($icone_color_notice_question).'\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M11 18h2v-2h-2v2zm1-16C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm0-14c-2.21 0-4 1.79-4 4h2c0-1.1.9-2 2-2s2 .9 2 2c0 2-3 1.75-3 5h2c0-2.25 3-2.5 3-5 0-2.21-1.79-4-4-4z\'/%3E%3C/svg%3E") no-repeat;';
							echo'background-size: 50px;';
							echo'min-height: 60px;';
							echo'background-position: top 20px left 10px;';
							echo'border-left: 4px solid rgba(0, 0, 0, 0.1);';
							echo'border-radius: 5px;';
							echo'padding: 16px 16px 16px 75px!important;';// Version 2.7 modif pour le block Group

					echo'}';
					
					// Version 2.7 modif pour le block Group
					echo'body.wp-admin [data-type="core/group"].is-style-eccp-notice-question p,
						 body.wp-admin [data-type="core/group"].is-style-eccp-notice-question h3,
						 body.wp-admin [data-type="core/group"].is-style-eccp-notice-question h4{';
					
						echo'margin:0;';
					
					echo'}';
					
					
					echo'body.wp-admin p.is-style-eccp-notice-question.has-background{';
					
					
						echo'padding: 16px 16px 16px 75px!important;';

					
					echo'}';
					
				}
				
				/*----------------------------Style Notice: Info back office------------------------------*/
				
				// substr retourne une sous chaine de la position:1 jusqu'a la fin				
				$icone_color_notice_info = substr($custom_gutenberg_blocks_settings['eccp_settings_icon_color_style_notice_info_text_field'],1);
				
				
				if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_info_radio_field'] == 'yes' ) {
				
					// Version 2.7 modif pour le block Group
					echo'body.wp-admin p.is-style-eccp-notice-info,
						 body.wp-admin [data-type="core/group"].is-style-eccp-notice-info{';
							
						echo'background: #48ADD8 url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'24px\' viewBox=\'0 0 24 24\' width=\'24px\' fill=\'%23'.esc_html($icone_color_notice_info).'\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M11 7h2v2h-2zm0 4h2v6h-2zm1-9C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z\'/%3E%3C/svg%3E") no-repeat;';
						echo'color: #FFFFFF;';
						echo'background-size: 50px;';
						echo'min-height: 60px;';
						echo'background-position: top 20px left 10px;';
						echo'border-left: 4px solid rgba(0, 0, 0, 0.1);';
						echo'border-radius: 5px;';
						echo'padding: 16px 16px 16px 75px!important;';// Version 2.7 modif pour le block Group

					echo'}';
					
					// Version 2.7 modif pour le block Group
					echo'body.wp-admin [data-type="core/group"].is-style-eccp-notice-info p,
						 body.wp-admin [data-type="core/group"].is-style-eccp-notice-info h3,
						 body.wp-admin [data-type="core/group"].is-style-eccp-notice-info h4{';
						 
						echo'margin:0;';
					
					echo'}';
					
						
					echo'body.wp-admin p.is-style-eccp-notice-info.has-background{';
						
						
						echo'padding: 16px 16px 16px 75px!important;';

						
					echo'}';
					

				}
				
				/*----------------------------Style Notice: Advice back office------------------------------*/
				
				// substr retourne une sous chaine de la position:1 jusqu'a la fin				
				$icone_color_notice_advice = substr($custom_gutenberg_blocks_settings['eccp_settings_icon_color_style_notice_advice_text_field'],1);
				
				
				if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_advice_radio_field'] == 'yes' ) {
				
					// Version 2.7 modif pour le block Group
					echo'body.wp-admin p.is-style-eccp-notice-advice,
					     body.wp-admin [data-type="core/group"].is-style-eccp-notice-advice{';
							
						echo'background: #83BD71 url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'24px\' viewBox=\'0 0 24 24\' width=\'24px\' fill=\'%23'.esc_html($icone_color_notice_advice).'\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\' opacity=\'.87\'/%3E%3Cpath d=\'M21 8h-6.31l.95-4.57.03-.32c0-.41-.17-.79-.44-1.06L14.17 1 7.59 7.59C7.22 7.95 7 8.45 7 9v10c0 1.1.9 2 2 2h9c.83 0 1.54-.5 1.84-1.22l3.02-7.05c.09-.23.14-.47.14-.73v-2c0-1.1-.9-2-2-2zm0 4l-3 7H9V9l4.34-4.34L12.23 10H21v2zM1 9h4v12H1z\'/%3E%3C/svg%3E") no-repeat;';
						echo'color: #FFFFFF;';
						echo'background-size: 50px;';
						echo'min-height: 60px;';
						echo'background-position: top 20px left 10px;';
						echo'border-left: 4px solid rgba(0, 0, 0, 0.1);';
						echo'border-radius: 5px;';
						echo'padding: 16px 16px 16px 75px!important;';// Version 2.7 modif pour le block Group

					echo'}';
					
					
					// Version 2.7 modif pour le block Group
					echo'body.wp-admin [data-type="core/group"].is-style-eccp-notice-advice p,
						 body.wp-admin [data-type="core/group"].is-style-eccp-notice-advice h3,
						 body.wp-admin [data-type="core/group"].is-style-eccp-notice-advice h4{';
						 
						echo'margin:0;';
					
					echo'}';
					
						
					echo'body.wp-admin p.is-style-eccp-notice-advice.has-background{';
						
						
						echo'padding: 16px 16px 16px 75px!important;';

						
					echo'}';
					
				}
				
				/*----------------------------Style Notice: Warning back office------------------------------*/
				
				// substr retourne une sous chaine de la position:1 jusqu'a la fin				
				$icone_color_notice_warning = substr($custom_gutenberg_blocks_settings['eccp_settings_icon_color_style_notice_warning_text_field'],1);
				
				
				if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_warning_radio_field'] == 'yes' ) {
				
					// Version 2.7 modif pour le block Group
					echo'body.wp-admin p.is-style-eccp-notice-warning,
					     body.wp-admin [data-type="core/group"].is-style-eccp-notice-warning{';
				
						echo'background: #FFC334 url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'24px\' viewBox=\'0 0 24 24\' width=\'24px\' fill=\'%23'.esc_html($icone_color_notice_warning).'\'%3E%3Cpath d=\'M12 5.99L19.53 19H4.47L12 5.99M12 2L1 21h22L12 2zm1 14h-2v2h2v-2zm0-6h-2v4h2v-4z\'/%3E%3C/svg%3E") no-repeat;';
						echo'color: #FFFFFF;';
						echo'background-size: 50px;';
						echo'min-height: 60px;';
						echo'background-position: top 20px left 10px;';
						echo'border-left: 4px solid rgba(0, 0, 0, 0.1);';
						echo'border-radius: 5px;';
						echo'padding: 16px 16px 16px 75px!important;';// Version 2.7 modif pour le block Group

					echo'}';
					
					
					// Version 2.7 modif pour le block Group
					echo'body.wp-admin [data-type="core/group"].is-style-eccp-notice-warning p,
						 body.wp-admin [data-type="core/group"].is-style-eccp-notice-warning h3,
						 body.wp-admin [data-type="core/group"].is-style-eccp-notice-warning h4{';
					
						echo'margin:0;';
					
					echo'}';
					
						
					echo'body.wp-admin p.is-style-eccp-notice-warning.has-background{';
						
						
						echo'padding: 16px 16px 16px 75px!important;';

						
					echo'}';
					
				}
				
				/*----------------------------Style Notice: Alert back office------------------------------*/
				
				// substr retourne une sous chaine de la position:1 jusqu'a la fin				
				$icone_color_notice_alert = substr($custom_gutenberg_blocks_settings['eccp_settings_icon_color_style_notice_alert_text_field'],1);
				
				
				if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_alert_radio_field'] == 'yes' ) {
				
					// Version 2.7 modif pour le block Group
					echo'body.wp-admin p.is-style-eccp-notice-alert,
					     body.wp-admin [data-type="core/group"].is-style-eccp-notice-alert{';
				
						echo'background: #B54D4D url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'24px\' viewBox=\'0 0 24 24\' width=\'24px\' fill=\'%23'.esc_html($icone_color_notice_alert).'\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M15.73 3H8.27L3 8.27v7.46L8.27 21h7.46L21 15.73V8.27L15.73 3zM19 14.9L14.9 19H9.1L5 14.9V9.1L9.1 5h5.8L19 9.1v5.8z\'/%3E%3Ccircle cx=\'12\' cy=\'16\' r=\'1\'/%3E%3Cpath d=\'M11 7h2v7h-2z\'/%3E%3C/svg%3E") no-repeat;';
						echo'color: #FFFFFF;';
						echo'background-size: 50px;';
						echo'min-height: 60px;';
						echo'background-position: top 20px left 10px;';
						echo'border-left: 4px solid rgba(0, 0, 0, 0.1);';
						echo'border-radius: 5px;';
						echo'padding: 16px 16px 16px 75px!important;';// Version 2.7 modif pour le block Group

					echo'}';
						
						
					// Version 2.7 modif pour le block Group
					echo'body.wp-admin [data-type="core/group"].is-style-eccp-notice-alert p,
						 body.wp-admin [data-type="core/group"].is-style-eccp-notice-alert h3,
						 body.wp-admin [data-type="core/group"].is-style-eccp-notice-alert h4{';
					
						echo'margin:0;';
					
					echo'}';
					
						
					echo'body.wp-admin p.is-style-eccp-notice-alert.has-background{';
						
						
						echo'padding: 16px 16px 16px 75px!important;';

						
					echo'}';
					
				}
				
				
				/*--------------------- Style Click to Tweet Back Office ---------------------------*/


				if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_click_to_tweet_radio_field'] == 'yes' ) {

					// Bloc paragraphe de style ECCP Tweet
					echo'body.wp-admin p.is-style-eccp-tweet {';
					
						echo'font-size: 25px;';
						echo'line-height:1.5em;';
						echo'border: 1px solid #dde2e9;';
						echo'box-shadow: 0 2px 4px 2px rgb(0 0 0 / 10%);';
						echo'padding: 2rem 2rem;';
						echo'margin-bottom: 1.5em;';
						echo'margin-top: 1.5em;';
						echo'border-radius: 4px;';
						
					echo'}';

				
				}
				
				
				/*--------------------- Style Evidence Back Office ---------------------------*/		

				// Bloc paragraphe de style Evidence
				// la couleur de la bordure est la même
				// que le bloc réutilisable mettre en évidence
				echo'body.wp-admin p.is-style-eccp-evidence {';
				
					/* bordure colorée orange #F37020 avec une transparence */
					echo'border-left: 5px solid '.esc_html($reusable_blocks_settings['eccp_settings_custom_paragraph_border_color']).';';
					/* couleur de fond jaune pale */
					echo'background:rgba(243,230,114,0.7);';
					echo'border-radius:4px;';
					echo'box-shadow: 8px 8px 12px -8px rgba(0,0,0,0.5);';
					echo' padding:1.1em!important;';
					echo' margin:1.1em;';
					echo' font-size: 20px;';
					
				echo'}';
				
				
				/*--------------------- Style pour le format Tooltip Back Office ---------------------------*/		
				
				/*
				Régles pour la balise <span> de classe eccp-tooltip qui 
				a l'attribut data-tooltip qui contient le message pour 
				l'info-bulle
				*/
				echo'.eccp-tooltip {';
					echo'position: relative;';
				  /* dotted ou double */
					echo'text-decoration: underline double 2px '.$custom_gutenberg_blocks_settings['eccp_settings_text_double_underline_color_text_field'].';';
				echo'}';

				/*
				container du message de l'info bulle 

				On affiche le message par la règle
				content et l'attribut data-tooltip de la balise
				<span> qui contient le message pour l'info-bulle.
				on affiche l'info-bulle au dessus et au mileu
				de la balise <span> grace a la translation
				sur l'axe X de -50%
				On calcule la position appropriée en soustrayant 
				à la largeur totale de l'élément de message (100%), 
				10 pixels supplémentaires. 
				C'est à cette distance que le message 
				est éloigné de la balise <span>
				*/
				echo'.eccp-tooltip:hover::after {';
				  echo'background-color:'.$custom_gutenberg_blocks_settings['eccp_settings_tooltip_background_color_text_field'].';';
				  echo'border-radius: 8px;';
				  echo'color:'.$custom_gutenberg_blocks_settings['eccp_settings_tooltip_text_color_text_field'].';';
				  echo'padding: 6px 6px;';
				  echo'position: absolute;';
				  echo'text-align: center;';
				  echo'z-index: 999;';
				  echo'width:200px;';
				  echo'font-size:14px;';
				  echo'font-weight:normal;';
				  echo'line-height:1.5;';
				  
				  echo'content:""attr(data-tooltip)"";';
				  echo'top: 0;';
				  echo'left: 50%;';
				  echo'transform: translate(-50%, calc(-100% - 10px));';
				echo'}';


				/*
				afficher une petite flèche vers le parent balise <span> 
				depuis la boîte de message info-bulle 

				Fondamentalement,ce sera un simple carré qui sera tourné de 45 degrés, 
				puis la moitié du carré sera masquée par la boîte de message réelle 
				créant une flèche. 
				De plus, on doit positionner correctement la flèche, 
				pour cela on doit prendre en considération que la moitié du carré 
				doit être couverte afin de créer la flèche, 
				pour cela on change le 10px décalage ci-dessus en seulement5px
				*/
				echo'.eccp-tooltip:hover::before {';
				  echo'background-color:'.$custom_gutenberg_blocks_settings['eccp_settings_tooltip_background_color_text_field'].';';
				  echo'content:"";';
				  echo'position: absolute;';
				  echo'width: 15px;';
				  echo'height: 15px;';
				  echo'z-index: 999;';
				  
				  echo'top: 0;';
				  echo'left: 50%;';
				  echo'transform: translate(-50%, calc(-100% - 5px)) rotate(45deg);';
				echo'}';


				/*---------- Style Contour Pour l'Icône Dashicon Ajouté au bloc paragraphe back office ----------------*/
		
				echo'.editor-styles-wrapper p .eccp-dashicon.icon-outline:before {';
					
					echo'outline-style: solid;';
					echo'outline-offset: 0.45rem;';
					echo'outline-color: inherit;';
					echo'outline-width: 4px;';
					echo'border-radius: 50%;';
					
				echo'}';
				

				/*-------------------BLOC GROUP BACK OFFICE --------------------------*/
		
				/* version 2.4 correction pour thème astra
				   padding réglage natif a partir de WordPress 6.0
				echo'.wp-block-group {';
					echo'padding: 1.25em 2.375em!important;';
				echo'}';
				*/
		
				/*---------------------------- Border Radius ------------------------------*/
			
			    /* appliqué directement par une régle style
				   enregistré dans le HTML du bloc a partir de la version 2.5 
				echo'.is-style-eccp-border-radius{';
					echo'border-radius: 8px;';
				echo'}';
				*/
		
				/*---------------------------- Alignement Left & Right Back Office ------------------------------*/
		
				echo'@media (min-width:1025px) {';
				
					echo'.wp-block[data-align="left"] .wp-block-group.is-style-eccp-size-larger,
					     .wp-block-group.alignleft.is-style-eccp-size-larger {';
						/* le block groupe a une largeur de 90% paramètré
					       dans le panneau ECCP Style des paramètres du bloc
					       si on met une marge droite de 10% au  block qui a un style flottant a gauche
					       on est sur que le block suivant ne va pas remonter
						*/
						echo'margin-right: 10%!important;';
						echo'margin-bottom: 1.5em!important;';
					echo'}';

					echo'.wp-block[data-align="left"] .wp-block-group.is-style-eccp-size-large,
 					     .wp-block-group.alignleft.is-style-eccp-size-large {';
						echo'margin-right: 20%!important;';
						echo'margin-bottom: 1.5em!important;';
					echo'}';

					echo'.wp-block[data-align="left"] .wp-block-group.is-style-eccp-size-regular,
					     .wp-block-group.alignleft.is-style-eccp-size-regular{';
						echo'margin-right: 30%!important;';
						echo'margin-bottom: 1.5em!important;';
					echo'}';

					echo'.wp-block[data-align="left"] .wp-block-group.is-style-eccp-size-small,
              			 .wp-block-group.alignleft.is-style-eccp-size-small {';
						echo'margin-right: 40%!important;';
						echo'margin-bottom: 1.5em!important;';
					echo'}';
					
					echo'.wp-block[data-align="left"] .wp-block-group.is-style-eccp-size-very-small,
              			 .wp-block-group.alignleft.is-style-eccp-size-very-small {';
						echo'margin-right: 50%!important;';
						echo'margin-bottom: 1.5em!important;';
					echo'}';
					
					
					
					echo'.wp-block[data-align="right"] .wp-block-group.is-style-eccp-size-larger,
        				 .wp-block-group.alignright.is-style-eccp-size-larger {';
						echo'margin-left: 10%!important;';
						echo'margin-bottom: 1.5em!important;';
					echo'}';

					echo'.wp-block[data-align="right"] .wp-block-group.is-style-eccp-size-large,
                         .wp-block-group.alignright.is-style-eccp-size-large {';
						echo'margin-left: 20%!important;';
						echo'margin-bottom: 1.5em!important;';
					echo'}';

					echo'.wp-block[data-align="right"] .wp-block-group.is-style-eccp-size-regular,
                         .wp-block-group.alignright.is-style-eccp-size-regular {';
						echo'margin-left: 30%!important;';
						echo'margin-bottom: 1.5em!important;';
					echo'}';

					echo'.wp-block[data-align="right"] .wp-block-group.is-style-eccp-size-small,
              			 .wp-block-group.alignright.is-style-eccp-size-small {';
						echo'margin-left: 40%!important;';
						echo'margin-bottom: 1.5em!important;';
					echo'}';
					
					echo'.wp-block[data-align="right"] .wp-block-group.is-style-eccp-size-very-small,
              			 .wp-block-group.alignright.is-style-eccp-size-very-small {';
						echo'margin-left: 50%!important;';
						echo'margin-bottom: 1.5em!important;';
					echo'}';
					
							
				echo'}';
		
		
				/*---------------------------- Style Variation InfoBox back office ------------------------------*/
				
				
				echo'.is-style-eccp-infobox.wp-block-group {';
					echo'padding: 1.25em!important;';
					echo'background: #F0F2F6;';
					echo'margin-bottom: 1.1em;';
				echo'}';


				echo'.is-style-eccp-infobox .wp-block-columns {';
					echo'margin-bottom: 0em!important;';
				echo'}';


				echo'.is-style-eccp-infobox .wp-block-buttons {';
				   echo'margin-bottom: 0em!important;';
				echo'}';
				
				
				echo'.is-style-eccp-infobox h2,.is-style-eccp-infobox h3,
					 .is-style-eccp-infobox h4,.is-style-eccp-infobox h5 {';
						echo'margin-top: 0em!important;';
				echo'}';


				echo'@media screen and (max-width: 599px) {';
				
					echo'.is-style-eccp-infobox p {';
						echo'text-align: center!important;';
					echo'}';
					
				echo'}';
				
				
				echo'@media screen and (max-width: 781px) {';
					
					echo'.is-style-eccp-infobox .wp-block-column {';
						echo'margin-bottom: 0em!important;';
					echo'}';
					
					echo'.is-style-eccp-infobox h2,.is-style-eccp-infobox h3,
						 .is-style-eccp-infobox h4,.is-style-eccp-infobox h5 {';
						echo'margin: 0em!important;';
					echo'}';
					
				echo'}';
				
				
				/*----------------------- Style Variation Countdown Timer back office --------------------------*/
				
				// Variation Bloc Groupe pour un compte a rebours
				echo'.wp-block-group.is-style-eccp-countdown{';
				
					echo'box-shadow:0px 0px 4px 1px rgba(0,0,0,0.2);';
					echo'padding:1em 1em;';
					
				echo'}';
		
		
				/*----------------------- Style Table Of Contents back office --------------------------*/
				
				echo'body.wp-admin .wp-block-group.is-style-eccp-toc {';
					echo'padding-top: 0.5em;';
					echo'padding-bottom: 0.5em;';
				echo'}';
				
				/* 
				bordure gris léger dans le cas ou il n'y a pas d'arrière plan
				ou un arrière plan en gris léger
				*/
				echo'body.wp-admin .wp-block-group.is-style-eccp-toc:not(.has-background),
				     body.wp-admin .wp-block-group.is-style-eccp-toc.has-light-green-background-color {';
					echo'border: 1px solid lightgray';
				echo'}';
				
				// on récupère le thème actif
				$my_theme = wp_get_theme();
				
				
				if(stristr($my_theme, 'generatepress')) {
					
					echo'body.wp-admin .wp-block-group.is-style-eccp-toc pre.wp-block-code code{';
						echo'margin-left:15px!important;';
						echo'margin-right:15px!important;';
					echo'}';
					
				}
		
				// on utilise un bloc code pour éviter que l'intitulé soit repris
				// dans le résumé apparaissant dans le bloc boucle de requête
				// ou Derniers Articles
				echo'body.wp-admin .wp-block-group.is-style-eccp-toc pre.wp-block-code {';
					echo'margin:0!important;';
					echo'padding:5px 0px!important;';
					echo'background:transparent!important;';
					echo'border:none!important;';
				echo'}';
				
				echo'body.wp-admin .wp-block-group.is-style-eccp-toc pre.wp-block-code code {';
					echo'color:#333333!important;';
					echo'font-size:20px!important;';
				echo'}';
				
				echo'body.wp-admin .wp-block-group.is-style-eccp-toc pre.wp-block-code code::after {';
					echo'content: "\f347";';
					echo'font-family: "dashicons";';
					echo'float:right;';
				echo'}';
				
				
				/*----------------------- Formes de séparation back office --------------------------*/
				
				/*
				 En ajoutant l'attribut préservationAspectRatio="none"
				 dans les proriétés du SVG, 
				 on peut définir une hauteur personnalisée.
				 Ce qui signifie aussi que la forme sera « déformée » 
				 pour garder la même hauteur.
				 grâce a la propriété css: -webkit-mask-image,
				 on va pouvoir appliquer une couleur d'arrière plan aux SVG.
				 Cette couleur d'arrière plan du SVG correspondra à la couleur
				 d'arrière plan de la publication excepté pour les styles:
				 • vagues avec opacité(waves opacity) 
				 • Inclinée avec opacité(Tilt Opacity) 
				 ces styles prennent la couleur d'arrière plan du bloc groupe.
				*/

				/* Le bloc groupe auquel on applique
				une forme de séparation a reçu en ReactJS la classe:
				.is-style-eccp-shape-divider */
				echo'.is-style-eccp-shape-divider {';
					echo'position: relative;';
				echo'}';
				
				/* ------------ Forme Inclinée(tilt) Back Office -----------------------*/

				/* réglage de l'angle par la hauteur de 0 à 500px 
				inversion: transform: rotateY(180deg)
				la couleur de la forme doit être celui de l'arrière plan de la publication
				remarque width fait aussi varier l'angle*/
				echo'.is-style-eccp-shape-divider.style-shape-top-tilt::before {';
					echo'content:"";';
					echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M1200 120L0 16.48 0 0 1200 0 1200 120z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M1200 120L0 16.48 0 0 1200 0 1200 120z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'position: absolute;';
					echo'top: 0;';
					echo'left: 0;';
					echo'width: calc(var(--eccp-topShapeWidth,100)*1%);';
					echo'height: calc(var(--eccp-topShapeHeight,50)*1px);';
					echo'background-color: var(--eccp-topShapeBackgroundColor,#E6E8ED);';
					echo'z-index:1;';
				echo'}';
				
				// retournement horizontal 
				echo'.is-style-eccp-shape-divider.top-shape-flip-horizontally.style-shape-top-tilt::before {';
					echo'transform: rotateY(180deg);';
					echo'left: -1px;';
				echo'}';


				/* inversion: transform: rotateX(180deg) 
				 la couleur de la forme doit être celui de l'arrière plan de la publication*/
				echo'.is-style-eccp-shape-divider.style-shape-bottom-tilt::after {';
					echo'content: "";';
					echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M1200 120L0 16.48 0 0 1200 0 1200 120z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M1200 120L0 16.48 0 0 1200 0 1200 120z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'position: absolute;';
					echo'bottom: 0;';
					echo'left: -1px;';
					echo'width: calc(var(--eccp-bottomShapeWidth,100)*1%);';
					echo'height: calc(var(--eccp-bottomShapeHeight,50)*1px);';
					echo'background-color: var(--eccp-bottomShapeBackgroundColor,#E6E8ED);';
					echo'transform: rotate(180deg);';
					echo'z-index:1;';
				echo'}';
				
				// retournement horizontal 
				echo'.is-style-eccp-shape-divider.bottom-shape-flip-horizontally.style-shape-bottom-tilt::after {';
					echo'transform: rotateX(180deg);';
				echo'}';

				/* ------------ Forme Inclinée avec opacité(tilt opacity) Back Office -----------------------*/

				/* séparation Forme Inclinée avec opacité partie supérieure
				réglage dimmensions avec les propriétés height & top
				la couleur de la forme doit être celui de l'arrière plan de la publication
				inversion: transform: rotateX(180deg);';*/


				 echo'.is-style-eccp-shape-divider.style-shape-top-tilt-opacity::before {';
					echo'content: "";';
					echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 2600 131.1\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M0 0L2600 0 2600 69.1 0 0z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.5\' d=\'M0 0L2600 0 2600 69.1 0 69.1z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.25\' d=\'M2600 0L0 0 0 130.1 2600 69.1z\'%3E%3C/path%3E%3C/svg%3E");';
					echo'mask-image: url("data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 2600 131.1\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M0 0L2600 0 2600 69.1 0 0z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.5\' d=\'M0 0L2600 0 2600 69.1 0 69.1z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.25\' d=\'M2600 0L0 0 0 130.1 2600 69.1z\'%3E%3C/path%3E%3C/svg%3E");';
					echo'position: absolute;';
					echo'top: calc(var(--eccp-topShapeHeight,50)*-1px);';
					echo'left: 0;';
					echo'width: 100%;';
					echo'height: calc(var(--eccp-topShapeHeight,50)*1px);';
					echo'background-color: var(--eccp-topShapeBackgroundColor,#E6E8ED);';
					echo'transform: rotate(180deg);';
					echo'z-index:1;';
				echo'}';

				// retournement horizontal 
				echo'.is-style-eccp-shape-divider.top-shape-flip-horizontally.style-shape-top-tilt-opacity::before {';
					echo'transform: rotateX(180deg);';
				echo'}';

				/* séparation Forme Inclinée avec opacité partie inférieure
				réglage dimmensions avec les propriétés height & bottom
				inversion: transform: rotateY(180deg)*/
				echo'.is-style-eccp-shape-divider.style-shape-bottom-tilt-opacity::after {';
					echo'content: "";';
					echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 2600 131.1\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M0 0L2600 0 2600 69.1 0 0z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.5\' d=\'M0 0L2600 0 2600 69.1 0 69.1z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.25\' d=\'M2600 0L0 0 0 130.1 2600 69.1z\'%3E%3C/path%3E%3C/svg%3E");';
					echo'mask-image: url("data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 2600 131.1\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M0 0L2600 0 2600 69.1 0 0z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.5\' d=\'M0 0L2600 0 2600 69.1 0 69.1z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.25\' d=\'M2600 0L0 0 0 130.1 2600 69.1z\'%3E%3C/path%3E%3C/svg%3E");';
					echo'position: absolute;';
					echo'bottom:calc(var(--eccp-bottomShapeHeight,50)*-1px);';
					echo'left: 0;';
					echo'width: 100%;';
					echo'height: calc(var(--eccp-bottomShapeHeight,50)*1px);';
					echo'background-color: var(--eccp-bottomShapeBackgroundColor,#E6E8ED);';
					echo'z-index:1;';
				echo'}';

				// retournement horizontal 
				echo'.is-style-eccp-shape-divider.bottom-shape-flip-horizontally.style-shape-bottom-tilt-opacity::after {';
					echo'transform: rotateY(180deg);';
				echo'}';

				/* ------------ Forme Flèche(Arrow) Back Office -----------------------*/

				/* séparation Flèche partie supérieure
				réglage avec la propriété height 
				width permet d'excentrer la flêche vers la droite
				transform: translateX(-50%) de -10% a +50% permet de déplacer la fleche
				de gauche à droite
				la couleur de la forme doit être celui de l'arrière plan de la publication*/

				echo'.is-style-eccp-shape-divider.style-shape-top-arrow::before {';
					echo'content: "";';
					echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M649.97 0L550.03 0 599.91 54.12 649.97 0z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M649.97 0L550.03 0 599.91 54.12 649.97 0z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'position: absolute;';
					echo'top: 0;';
					echo'left: 0;';
					echo'width: calc(var(--eccp-topShapeWidth,100)*1%);';
					echo'height: calc(var(--eccp-topShapeHeight,50)*1px);';
					echo'background-color: var(--eccp-topShapeBackgroundColor,#E6E8ED);';
					echo'z-index:1;';
				echo'}';


				/* séparation Flèche partie inférieure
				réglage avec les propriétées transform, bottom , height
				pour la partie inférieure
				width permet d'excentrer la flêche vers la droite
				la couleur de la forme doit être celui de l'arrière plan de la publication*/ 
				echo'.is-style-eccp-shape-divider.style-shape-bottom-arrow::after {';
					echo'content: "";';
					echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M649.97 0L550.03 0 599.91 54.12 649.97 0z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M649.97 0L550.03 0 599.91 54.12 649.97 0z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'position: absolute;';
					echo'bottom: calc(var(--eccp-bottomShapeHeight,50)*-1px);';
					echo'left: 0;';
					echo'width: calc(var(--eccp-bottomShapeWidth,100)*1%);';
					echo'height: calc(var(--eccp-bottomShapeHeight,50)*1px);';
					echo'background-color: var(--eccp-bottomShapeBackgroundColor,#E6E8ED);';
					echo'transform: rotate(180deg) translateY(100%);';
					echo'z-index:1;';
				echo'}';

				/* ------------ Forme Incurvée(incurved) Back Office -----------------------*/

				/* séparation incurvée partie supérieure
				réglage dimmensions avec la propriété height
				width permet d'aplanir la courbe 
				la couleur de la forme doit être celui de l'arrière plan de la publication*/
				echo'.is-style-eccp-shape-divider.style-shape-top-curve::before {';
					echo'content: "";';
					echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M600,112.77C268.63,112.77,0,65.52,0,7.23V120H1200V7.23C1200,65.52,931.37,112.77,600,112.77Z\' class=\'shape-fill\'%3E%3C/path%3E%3C/svg%3E");';
					echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M600,112.77C268.63,112.77,0,65.52,0,7.23V120H1200V7.23C1200,65.52,931.37,112.77,600,112.77Z\' class=\'shape-fill\'%3E%3C/path%3E%3C/svg%3E");';
					echo'position: absolute;';
					echo'top: 0;';
					echo'left: -1px;';
					echo'width: calc(var(--eccp-topShapeWidth,100)*1%);';
					echo'height: calc(var(--eccp-topShapeHeight,50)*1px);';
					echo'background-color: var(--eccp-topShapeBackgroundColor,#E6E8ED);';
					echo'transform: rotate(180deg);';
					echo'z-index:1;';
				echo'}';


				/* séparation incurvée partie inférieure
				réglage dimmensions avec la propriété height 
				la couleur de la forme doit être celui de l'arrière plan de la publication*/
				echo'.is-style-eccp-shape-divider.style-shape-bottom-curve::after {';
					echo'content: "";';
					echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M600,112.77C268.63,112.77,0,65.52,0,7.23V120H1200V7.23C1200,65.52,931.37,112.77,600,112.77Z\' class=\'shape-fill\'%3E%3C/path%3E%3C/svg%3E");';
					echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M600,112.77C268.63,112.77,0,65.52,0,7.23V120H1200V7.23C1200,65.52,931.37,112.77,600,112.77Z\' class=\'shape-fill\'%3E%3C/path%3E%3C/svg%3E");';
					echo'position: absolute;';
					echo'bottom: 0;';
					echo'left: -1px;';
					echo'width: calc(var(--eccp-bottomShapeWidth,100)*1%);';
					echo'height: calc(var(--eccp-bottomShapeHeight,50)*1px);';
					echo'background-color: var(--eccp-bottomShapeBackgroundColor,#E6E8ED);';
					echo'z-index:1;';
				echo'}';

				/* ------------ Forme Incurvée assymétrique(curve asymmetrical) Back Office -----------------------*/

				/* séparation incurvée assymétrique partie supérieure
				réglage dimmensions avec la propriété height
				width permet d'aplanir la courbe
				la couleur de la forme doit être celui de l'arrière plan de la publication
				retournement horizontal: transform: rotateX(180deg);'; */
				echo'.is-style-eccp-shape-divider.style-shape-top-curve-asymmetrical::before {';
					echo'content: "";';
					echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M741,116.23C291,117.43,0,27.57,0,6V120H1200V6C1200,27.93,1186.4,119.83,741,116.23Z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M741,116.23C291,117.43,0,27.57,0,6V120H1200V6C1200,27.93,1186.4,119.83,741,116.23Z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'position: absolute;';
					echo'top: 0;';
					echo'left: -1px;';
					echo'width: calc((var(--eccp-topShapeWidth,100) + 1) *1%);';
					echo'height: calc(var(--eccp-topShapeHeight,50)*1px);';
					echo'background-color: var(--eccp-topShapeBackgroundColor,#E6E8ED);';
					echo'transform: rotate(180deg);';
					echo'z-index:1;';
				echo'}';

				// retournement horizontal 
				echo'.is-style-eccp-shape-divider.top-shape-flip-horizontally.style-shape-top-curve-asymmetrical::before {';
					echo'transform: rotateX(180deg);';
				echo'}';


				/* séparation incurvée assymétrique partie inférieure
				réglage dimmensions avec la propriété height
				la couleur de la forme doit être celui de l'arrière plan de la publication 
				retournement horizontal: transform: rotateY(180deg)*/
				echo'.is-style-eccp-shape-divider.style-shape-bottom-curve-asymmetrical::after {';
					echo'content: "";';
					echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M741,116.23C291,117.43,0,27.57,0,6V120H1200V6C1200,27.93,1186.4,119.83,741,116.23Z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M741,116.23C291,117.43,0,27.57,0,6V120H1200V6C1200,27.93,1186.4,119.83,741,116.23Z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'position: absolute;';
					echo'bottom: 0;';
					echo'left: 0;';
					echo'width: calc((var(--eccp-bottomShapeWidth,100) + 1) *1%);';
					echo'height: calc(var(--eccp-bottomShapeHeight,50)*1px);';
					echo'background-color: var(--eccp-bottomShapeBackgroundColor,#E6E8ED);';
					echo'z-index:1;';
				echo'}';

				// retournement horizontal 
				echo'.is-style-eccp-shape-divider.bottom-shape-flip-horizontally.style-shape-bottom-curve-asymmetrical::after {';
					echo'transform: rotateY(180deg);';
					echo'left: -1px;';
				echo'}';
			

				/* ------------ Triangle (Triangle) Back Office -----------------------*/
				 
				 /* séparation Triangle partie supérieure
				réglage dimmensions avec la propriétés height
				la couleur de la forme doit être celui de l'arrière plan de la publication
				on peut aussi jouer avec width*/

				 echo'.is-style-eccp-shape-divider.style-shape-top-triangle::before {';
					echo'content: "";';
					echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M598.97 114.72L0 0 0 120 1200 120 1200 0 598.97 114.72z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M598.97 114.72L0 0 0 120 1200 120 1200 0 598.97 114.72z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'position: absolute;';
					echo'top: 0;';
					echo'left: 0;';
					echo'width:100%;';
					echo'height: calc(var(--eccp-topShapeHeight,50)*1px);';
					echo'background-color: var(--eccp-topShapeBackgroundColor,#E6E8ED);';
					echo'transform: rotate(180deg);';
					echo'z-index:1;';
				echo'}';


				/* séparation Triangle partie inférieure
				réglage dimmensions avec la propriété height
				la couleur de la forme doit être celui de l'arrière plan de la publication
				on peut aussi jouer avec width*/

				echo'.is-style-eccp-shape-divider.style-shape-bottom-triangle::after {';
					echo'content: "";';
					echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M598.97 114.72L0 0 0 120 1200 120 1200 0 598.97 114.72z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M598.97 114.72L0 0 0 120 1200 120 1200 0 598.97 114.72z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'position: absolute;';
					echo'bottom:0;';
					echo'left: 0;';
					echo'width:100%;';
					echo'height: calc(var(--eccp-bottomShapeHeight,50)*1px);';
					echo'background-color: var(--eccp-bottomShapeBackgroundColor,#E6E8ED);';
					echo'z-index:1;';
				echo'}';


				/* ------------ Triangle Assymétrique(Triangle Asymmetrical) Back Office -----------------------*/
				 
				 /* séparation Triangle Assymétrique partie supérieure
				réglage dimmensions avec la propriétés height
				la couleur de la forme doit être celui de l'arrière plan de la publication
				retournement horizontal: transform: rotateY(180deg);';
				on peut aussi jouer avec width*/

				 echo'.is-style-eccp-shape-divider.style-shape-top-triangle-asymmetrical::before {';
					echo'content: "";';
					echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M1200 0L0 0 892.25 114.72 1200 0z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M1200 0L0 0 892.25 114.72 1200 0z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'position: absolute;';
					echo'top: 0;';
					echo'left: 0;';
					echo'width: calc(var(--eccp-topShapeWidth,100)*1%);';
					echo'height: calc(var(--eccp-topShapeHeight,50)*1px);';
					echo'background-color: var(--eccp-topShapeBackgroundColor,#E6E8ED);';
					echo'z-index:1;';
				echo'}';

				// retournement horizontal 
				echo'.is-style-eccp-shape-divider.top-shape-flip-horizontally.style-shape-top-triangle-asymmetrical::before {';
					echo'transform: rotateY(180deg);';
				echo'}';

				/* séparation Triangle Assymétrique partie inférieure
				réglage dimmensions avec la propriété height
				on peut aussi jouer avec width
				la couleur de la forme doit être celui de l'arrière plan de la publication
				retournement horizontal: transform: rotateX(180deg);';*/
				echo'.is-style-eccp-shape-divider.style-shape-bottom-triangle-asymmetrical::after {';
					echo'content: "";';
					echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M1200 0L0 0 892.25 114.72 1200 0z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M1200 0L0 0 892.25 114.72 1200 0z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'position: absolute;';
					echo'bottom:0;';
					echo'left: 0;';
					echo'width: calc(var(--eccp-bottomShapeWidth,100)*1%);';
					echo'height: calc(var(--eccp-bottomShapeHeight,50)*1px);';
					echo'background-color: var(--eccp-bottomShapeBackgroundColor,#E6E8ED);';
					echo'transform: rotate(180deg);';
					echo'z-index:1;';
				echo'}';

				// retournement horizontal 
				echo'.is-style-eccp-shape-divider.bottom-shape-flip-horizontally.style-shape-bottom-triangle-asymmetrical::after {';
					echo'transform: rotateX(180deg);';
				echo'}';

				/* ------------ Forme Vagues(waves) Back Office -----------------------*/

				/* séparation vagues partie supérieure
				réglage dimmensions avec la propriété height
				la couleur de la forme doit être celui de l'arrière plan de la publication
				inversion: transform: rotateX(180deg);';
				on peut aussi varier avec width*/
				 echo'.is-style-eccp-shape-divider.style-shape-top-waves::before {';
					echo'content: "";';
					echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M985.66,92.83C906.67,72,823.78,31,743.84,14.19c-82.26-17.34-168.06-16.33-250.45.39-57.84,11.73-114,31.07-172,41.86A600.21,600.21,0,0,1,0,27.35V120H1200V95.8C1132.19,118.92,1055.71,111.31,985.66,92.83Z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M985.66,92.83C906.67,72,823.78,31,743.84,14.19c-82.26-17.34-168.06-16.33-250.45.39-57.84,11.73-114,31.07-172,41.86A600.21,600.21,0,0,1,0,27.35V120H1200V95.8C1132.19,118.92,1055.71,111.31,985.66,92.83Z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'position: absolute;';
					echo'top: 0;';
					echo'left: -1px;';
					echo'width: calc(var(--eccp-topShapeWidth,100)*1%);';
					echo'height: calc(var(--eccp-topShapeHeight,50)*1px);';
					echo'background-color: var(--eccp-topShapeBackgroundColor,#E6E8ED);';
					echo'transform: rotate(180deg);';
					echo'z-index:1;';
				echo'}';

				// retournement horizontal 
				echo'.is-style-eccp-shape-divider.top-shape-flip-horizontally.style-shape-top-waves::before {';
					echo'transform: rotateX(180deg);';
				echo'}';


				/* séparation vagues  partie inférieure
				réglage dimmensions avec la propriété height
				la couleur de la forme doit être celui de l'arrière plan de la publication
				inversion: transform: rotateY(180deg)*/
				echo'.is-style-eccp-shape-divider.style-shape-bottom-waves::after {';
					echo'content: "";';
					echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M985.66,92.83C906.67,72,823.78,31,743.84,14.19c-82.26-17.34-168.06-16.33-250.45.39-57.84,11.73-114,31.07-172,41.86A600.21,600.21,0,0,1,0,27.35V120H1200V95.8C1132.19,118.92,1055.71,111.31,985.66,92.83Z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M985.66,92.83C906.67,72,823.78,31,743.84,14.19c-82.26-17.34-168.06-16.33-250.45.39-57.84,11.73-114,31.07-172,41.86A600.21,600.21,0,0,1,0,27.35V120H1200V95.8C1132.19,118.92,1055.71,111.31,985.66,92.83Z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'position: absolute;';
					echo'bottom:0;';
					echo'left:0;';
					echo'width: calc(var(--eccp-bottomShapeWidth,100)*1%);';
					echo'height: calc(var(--eccp-bottomShapeHeight,50)*1px);';
					echo'background-color: var(--eccp-bottomShapeBackgroundColor,#E6E8ED);';
					echo'z-index:1;';
				echo'}';

				// retournement horizontal 
				echo'.is-style-eccp-shape-divider.bottom-shape-flip-horizontally.style-shape-bottom-waves::after {';
					echo'transform: rotateY(180deg);';
					echo'left: -1px;';
				echo'}';
				


				/* ------------ Forme Vagues avec opacité(waves opacity) Back Office -----------------------*/
				 
				 /* séparation vagues avec opacité partie supérieure
				réglage dimmensions avec les propriétés top & height
				inversion: transform: rotateX(180deg);';*/
				 echo'.is-style-eccp-shape-divider.style-shape-top-waves-opacity::before {';
					echo'content: "";';
					echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M0,0V46.29c47.79,22.2,103.59,32.17,158,28,70.36-5.37,136.33-33.31,206.8-37.5C438.64,32.43,512.34,53.67,583,72.05c69.27,18,138.3,24.88,209.4,13.08,36.15-6,69.85-17.84,104.45-29.34C989.49,25,1113-14.29,1200,52.47V0Z\' opacity=\'.25\' class=\'shape-fill\'%3E%3C/path%3E%3Cpath d=\'M0,0V15.81C13,36.92,27.64,56.86,47.69,72.05,99.41,111.27,165,111,224.58,91.58c31.15-10.15,60.09-26.07,89.67-39.8,40.92-19,84.73-46,130.83-49.67,36.26-2.85,70.9,9.42,98.6,31.56,31.77,25.39,62.32,62,103.63,73,40.44,10.79,81.35-6.69,119.13-24.28s75.16-39,116.92-43.05c59.73-5.85,113.28,22.88,168.9,38.84,30.2,8.66,59,6.17,87.09-7.5,22.43-10.89,48-26.93,60.65-49.24V0Z\' opacity=\'.5\' %3E%3C/path%3E%3Cpath d=\'M0,0V5.63C149.93,59,314.09,71.32,475.83,42.57c43-7.64,84.23-20.12,127.61-26.46,59-8.63,112.48,12.24,165.56,35.4C827.93,77.22,886,95.24,951.2,90c86.53-7,172.46-45.71,248.8-84.81V0Z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M0,0V46.29c47.79,22.2,103.59,32.17,158,28,70.36-5.37,136.33-33.31,206.8-37.5C438.64,32.43,512.34,53.67,583,72.05c69.27,18,138.3,24.88,209.4,13.08,36.15-6,69.85-17.84,104.45-29.34C989.49,25,1113-14.29,1200,52.47V0Z\' opacity=\'.25\' class=\'shape-fill\'%3E%3C/path%3E%3Cpath d=\'M0,0V15.81C13,36.92,27.64,56.86,47.69,72.05,99.41,111.27,165,111,224.58,91.58c31.15-10.15,60.09-26.07,89.67-39.8,40.92-19,84.73-46,130.83-49.67,36.26-2.85,70.9,9.42,98.6,31.56,31.77,25.39,62.32,62,103.63,73,40.44,10.79,81.35-6.69,119.13-24.28s75.16-39,116.92-43.05c59.73-5.85,113.28,22.88,168.9,38.84,30.2,8.66,59,6.17,87.09-7.5,22.43-10.89,48-26.93,60.65-49.24V0Z\' opacity=\'.5\' %3E%3C/path%3E%3Cpath d=\'M0,0V5.63C149.93,59,314.09,71.32,475.83,42.57c43-7.64,84.23-20.12,127.61-26.46,59-8.63,112.48,12.24,165.56,35.4C827.93,77.22,886,95.24,951.2,90c86.53-7,172.46-45.71,248.8-84.81V0Z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'position: absolute;';
					echo'top: calc(var(--eccp-topShapeHeight,50)*-1px);';
					echo'left: 0;';
					echo'width: 100%;';
					echo'height: calc(var(--eccp-topShapeHeight,50)*1px);';
					echo'background-color: var(--eccp-topShapeBackgroundColor,#E6E8ED);';
					echo'transform: rotate(180deg);';
					echo'z-index:1;';
				echo'}';

				// retournement horizontal 
				echo'.is-style-eccp-shape-divider.top-shape-flip-horizontally.style-shape-top-waves-opacity::before {';
					echo'transform: rotateX(180deg);';
				echo'}';

				/* séparation vagues avec opacité partie inférieure
				réglage dimmensions avec les propriétés bottom & height
				inversion: transform: rotateY(180deg);';*/
				echo'.is-style-eccp-shape-divider.style-shape-bottom-waves-opacity::after {';
					echo'content: "";';
					echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M0,0V46.29c47.79,22.2,103.59,32.17,158,28,70.36-5.37,136.33-33.31,206.8-37.5C438.64,32.43,512.34,53.67,583,72.05c69.27,18,138.3,24.88,209.4,13.08,36.15-6,69.85-17.84,104.45-29.34C989.49,25,1113-14.29,1200,52.47V0Z\' opacity=\'.25\' class=\'shape-fill\'%3E%3C/path%3E%3Cpath d=\'M0,0V15.81C13,36.92,27.64,56.86,47.69,72.05,99.41,111.27,165,111,224.58,91.58c31.15-10.15,60.09-26.07,89.67-39.8,40.92-19,84.73-46,130.83-49.67,36.26-2.85,70.9,9.42,98.6,31.56,31.77,25.39,62.32,62,103.63,73,40.44,10.79,81.35-6.69,119.13-24.28s75.16-39,116.92-43.05c59.73-5.85,113.28,22.88,168.9,38.84,30.2,8.66,59,6.17,87.09-7.5,22.43-10.89,48-26.93,60.65-49.24V0Z\' opacity=\'.5\' %3E%3C/path%3E%3Cpath d=\'M0,0V5.63C149.93,59,314.09,71.32,475.83,42.57c43-7.64,84.23-20.12,127.61-26.46,59-8.63,112.48,12.24,165.56,35.4C827.93,77.22,886,95.24,951.2,90c86.53-7,172.46-45.71,248.8-84.81V0Z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M0,0V46.29c47.79,22.2,103.59,32.17,158,28,70.36-5.37,136.33-33.31,206.8-37.5C438.64,32.43,512.34,53.67,583,72.05c69.27,18,138.3,24.88,209.4,13.08,36.15-6,69.85-17.84,104.45-29.34C989.49,25,1113-14.29,1200,52.47V0Z\' opacity=\'.25\' class=\'shape-fill\'%3E%3C/path%3E%3Cpath d=\'M0,0V15.81C13,36.92,27.64,56.86,47.69,72.05,99.41,111.27,165,111,224.58,91.58c31.15-10.15,60.09-26.07,89.67-39.8,40.92-19,84.73-46,130.83-49.67,36.26-2.85,70.9,9.42,98.6,31.56,31.77,25.39,62.32,62,103.63,73,40.44,10.79,81.35-6.69,119.13-24.28s75.16-39,116.92-43.05c59.73-5.85,113.28,22.88,168.9,38.84,30.2,8.66,59,6.17,87.09-7.5,22.43-10.89,48-26.93,60.65-49.24V0Z\' opacity=\'.5\' %3E%3C/path%3E%3Cpath d=\'M0,0V5.63C149.93,59,314.09,71.32,475.83,42.57c43-7.64,84.23-20.12,127.61-26.46,59-8.63,112.48,12.24,165.56,35.4C827.93,77.22,886,95.24,951.2,90c86.53-7,172.46-45.71,248.8-84.81V0Z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'position: absolute;';
					echo'bottom: calc(var(--eccp-bottomShapeHeight,50)*-1px);';
					echo'left: 0;';
					echo'width: 100%;';
					echo'height: calc(var(--eccp-bottomShapeHeight,50)*1px);';
					echo'background-color: var(--eccp-bottomShapeBackgroundColor,#E6E8ED);';
					echo'z-index:1;';
				echo'}';

				// retournement horizontal 
				echo'.is-style-eccp-shape-divider.bottom-shape-flip-horizontally.style-shape-bottom-waves-opacity::after {';
					echo'transform: rotateY(180deg);';
				echo'}';

				/* ------------ Forme Diviser(Split) Back Office -----------------------*/
				 
				 /* séparation Diviser partie supérieure
				réglage dimmensions avec la propriété height
				la couleur de la forme doit être celui de l'arrière plan de la publication*/

				echo'.is-style-eccp-shape-divider.style-shape-top-split::before {';
					echo'content: "";';
					echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Crect x=\'1200\' height=\'3.6\'%3E%3C/rect%3E%3Crect height=\'3.6\'%3E%3C/rect%3E%3Cpath d=\'M0,0V3.6H580.08c11,0,19.92,5.09,19.92,13.2,0-8.14,8.88-13.2,19.92-13.2H1200V0Z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Crect x=\'1200\' height=\'3.6\'%3E%3C/rect%3E%3Crect height=\'3.6\'%3E%3C/rect%3E%3Cpath d=\'M0,0V3.6H580.08c11,0,19.92,5.09,19.92,13.2,0-8.14,8.88-13.2,19.92-13.2H1200V0Z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'position: absolute;';
					echo'top: 0px;';
					echo'left: 0;';
					echo'width: 100%;';
					echo'height: calc(var(--eccp-topShapeHeight,50)*1px);';
					echo'background-color: var(--eccp-topShapeBackgroundColor,#E6E8ED);';
					echo'z-index:1;';
				echo'}';


				/* séparation Diviser partie inférieure
				réglage dimmensions avec la propriété height
				la couleur de la forme doit être celui de l'arrière plan de la publication*/
				echo'.is-style-eccp-shape-divider.style-shape-bottom-split::after {';
					echo'content: "";';
					echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Crect x=\'1200\' height=\'3.6\'%3E%3C/rect%3E%3Crect height=\'3.6\'%3E%3C/rect%3E%3Cpath d=\'M0,0V3.6H580.08c11,0,19.92,5.09,19.92,13.2,0-8.14,8.88-13.2,19.92-13.2H1200V0Z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Crect x=\'1200\' height=\'3.6\'%3E%3C/rect%3E%3Crect height=\'3.6\'%3E%3C/rect%3E%3Cpath d=\'M0,0V3.6H580.08c11,0,19.92,5.09,19.92,13.2,0-8.14,8.88-13.2,19.92-13.2H1200V0Z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'position: absolute;';
					echo'bottom: 0;';
					echo'left: 0;';
					echo'width: 100%;';
					echo'height: calc(var(--eccp-bottomShapeHeight,50)*1px);';
					echo'background-color: var(--eccp-bottomShapeBackgroundColor,#E6E8ED);';
					echo'transform: rotate(180deg);';
					echo'z-index:1;';
				echo'}';


				/* ------------ Forme Livre(Book) Back Office -----------------------*/
				 
				 /* séparation Livre partie supérieure
				réglage dimmensions avec la propriétés height
				la couleur de la forme doit être celui de l'arrière plan de la publication*/

				echo'.is-style-eccp-shape-divider.style-shape-top-book::before {';
					echo'content: "";';
					echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M602.45,3.86h0S572.9,116.24,281.94,120H923C632,116.24,602.45,3.86,602.45,3.86Z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M602.45,3.86h0S572.9,116.24,281.94,120H923C632,116.24,602.45,3.86,602.45,3.86Z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'position: absolute;';
					echo'top: 0;';
					echo'left: 0;';
					echo'width: 100%;';
					echo'height: calc(var(--eccp-topShapeHeight,50)*1px);';
					echo'background-color: var(--eccp-topShapeBackgroundColor,#E6E8ED);';
					echo'transform: rotate(180deg);';
					echo'z-index:1;';
				echo'}';


				/* séparation Livre partie inférieure
				réglage dimmensions avec la propriété height
				la couleur de la forme doit être celui de l'arrière plan de la publication*/
				echo'.is-style-eccp-shape-divider.style-shape-bottom-book::after {';
					echo'content: "";';
					echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M602.45,3.86h0S572.9,116.24,281.94,120H923C632,116.24,602.45,3.86,602.45,3.86Z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M602.45,3.86h0S572.9,116.24,281.94,120H923C632,116.24,602.45,3.86,602.45,3.86Z\' %3E%3C/path%3E%3C/svg%3E");';
					echo'position: absolute;';
					echo'bottom:0;';
					echo'left: 0;';
					echo'width: 100%;';
					echo'height: calc(var(--eccp-bottomShapeHeight,50)*1px);';
					echo'background-color: var(--eccp-bottomShapeBackgroundColor,#E6E8ED);';
					echo'z-index:1;';
				echo'}';


				/* ------------ Forme Ventilateur(Fan) Back Office -----------------------*/
				 
				 /* séparation Ventilateur partie supérieure
				réglage dimmensions avec la propriétés height
				la couleur de la forme doit être celui de l'arrière plan de la publication
				on peut faire varier width pour rendre le ventilateur assymétrique*/

				 echo'.is-style-eccp-shape-divider.style-shape-top-fan::before {';
					echo'content: "";';
					echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 283.5 19.6\' preserveAspectRatio=\'none\'%3E%3Cpath style=\'opacity:0.33\' d=\'M0 0L0 18.8 141.8 4.1 283.5 18.8 283.5 0z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.33\' d=\'M0 0L0 12.6 141.8 4 283.5 12.6 283.5 0z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.33\' d=\'M0 0L0 6.4 141.8 4 283.5 6.4 283.5 0z\'%3E%3C/path%3E%3Cpath d=\'M0 0L0 1.2 141.8 4 283.5 1.2 283.5 0z\'%3E%3C/path%3E%3C/svg%3E");';
					echo'mask-image: url("data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 283.5 19.6\' preserveAspectRatio=\'none\'%3E%3Cpath style=\'opacity:0.33\' d=\'M0 0L0 18.8 141.8 4.1 283.5 18.8 283.5 0z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.33\' d=\'M0 0L0 12.6 141.8 4 283.5 12.6 283.5 0z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.33\' d=\'M0 0L0 6.4 141.8 4 283.5 6.4 283.5 0z\'%3E%3C/path%3E%3Cpath d=\'M0 0L0 1.2 141.8 4 283.5 1.2 283.5 0z\'%3E%3C/path%3E%3C/svg%3E");';
					echo'position: absolute;';
					echo'top: 0;';
					echo'left: 0;';
					echo'width: 100%;';
					echo'height: calc(var(--eccp-topShapeHeight,50)*1px);';
					echo'background-color: var(--eccp-topShapeBackgroundColor,#E6E8ED);';
					echo'z-index:1;';
				echo'}';


				/* séparation Ventilateur partie inférieure
				réglage dimmensions avec la propriété height
				la couleur de la forme doit être celui de l'arrière plan de la publication
				on peut faire varier width pour rendre le ventilateur assymétrique*/
				echo'.is-style-eccp-shape-divider.style-shape-bottom-fan::after {';
					echo'content: "";';
					echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 283.5 19.6\' preserveAspectRatio=\'none\'%3E%3Cpath style=\'opacity:0.33\' d=\'M0 0L0 18.8 141.8 4.1 283.5 18.8 283.5 0z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.33\' d=\'M0 0L0 12.6 141.8 4 283.5 12.6 283.5 0z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.33\' d=\'M0 0L0 6.4 141.8 4 283.5 6.4 283.5 0z\'%3E%3C/path%3E%3Cpath d=\'M0 0L0 1.2 141.8 4 283.5 1.2 283.5 0z\'%3E%3C/path%3E%3C/svg%3E");';
					echo'mask-image: url("data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 283.5 19.6\' preserveAspectRatio=\'none\'%3E%3Cpath style=\'opacity:0.33\' d=\'M0 0L0 18.8 141.8 4.1 283.5 18.8 283.5 0z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.33\' d=\'M0 0L0 12.6 141.8 4 283.5 12.6 283.5 0z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.33\' d=\'M0 0L0 6.4 141.8 4 283.5 6.4 283.5 0z\'%3E%3C/path%3E%3Cpath d=\'M0 0L0 1.2 141.8 4 283.5 1.2 283.5 0z\'%3E%3C/path%3E%3C/svg%3E");';
					echo'position: absolute;';
					echo'bottom:0;';
					echo'left: 0;';
					echo'width: 100%;';
					echo'height: calc(var(--eccp-bottomShapeHeight,50)*1px);';
					echo'background-color: var(--eccp-bottomShapeBackgroundColor,#E6E8ED);';
					echo'transform: rotate(180deg);';
					echo'z-index:1;';
				echo'}';
				
				/*--------------- Régles Mobiles & tablettes Back Office --------------- */

				echo'@media(max-width:767px){';

					
					/* ------------ Forme Inclinée(tilt) -----------------------*/

					/* Forme supérieure */
					echo'.is-style-eccp-shape-divider.style-shape-top-tilt::before {';
						echo'height: calc(var(--eccp-mobileTopShapeHeight,50)*1px);';
					echo'}';
					
					/* Forme inférieure */ 
					echo'.is-style-eccp-shape-divider.style-shape-bottom-tilt::after {';
						echo'height: calc(var(--eccp-mobileBottomShapeHeight,50)*1px);';
					echo'}';
					
					/* ------------ Forme Inclinée avec opacité(tilt opacity)-----------------------*/

					/* Forme  supérieure */
					echo'.is-style-eccp-shape-divider.style-shape-top-tilt-opacity::before {';
						echo'top:calc(var(--eccp-mobileTopShapeHeight,50)*-1px);';
						echo'height: calc(var(--eccp-mobileTopShapeHeight,50)*1px);';
					echo'}';

					/* séparation Forme Inclinée avec opacité partie inférieure */
					echo'.is-style-eccp-shape-divider.style-shape-bottom-tilt-opacity::after {';
						echo'bottom:calc(var(--eccp-mobileBottomShapeHeight,50)*-1px);';
						echo'height: calc(var(--eccp-mobileBottomShapeHeight,50)*1px);';
					echo'}';
					
					/* ------------ Forme Flèche(Arrow) -----------------------*/

					/* Forme supérieure */
					echo'.is-style-eccp-shape-divider.style-shape-top-arrow::before {';
						echo'height: calc(var(--eccp-mobileTopShapeHeight,50)*1px);';
					echo'}';

					/* Forme inférieure */
					echo'.is-style-eccp-shape-divider.style-shape-bottom-arrow::after {';
						echo'bottom: calc(var(--eccp-mobileBottomShapeHeight,50)*-1px);';
						echo'height: calc(var(--eccp-mobileBottomShapeHeight,50)*1px);';
					echo'}';
					

					/* ------------ Forme Incurvée(incurved) -----------------------*/

					
					/* Forme supérieure */
					echo'.is-style-eccp-shape-divider.style-shape-top-curve::before {';
						echo'height: calc(var(--eccp-mobileTopShapeHeight,50)*1px);';
					echo'}';
					

					/* Forme inférieure */
					echo'.is-style-eccp-shape-divider.style-shape-bottom-curve::after {';
						echo'left:-1px;';
						echo'height: calc(var(--eccp-mobileBottomShapeHeight,50)*1px);';
					echo'}';
					

					/* ------------ Forme Incurvée assymétrique(curve asymmetrical) -----------------------*/

					/* Forme supérieure */ 
					echo'.is-style-eccp-shape-divider.style-shape-top-curve-asymmetrical::before {';
						echo'height: calc(var(--eccp-mobileTopShapeHeight,50)*1px);';
						echo'left:-1px;';
					echo'}';
					

					/* Forme inférieure */
					echo'.is-style-eccp-shape-divider.style-shape-bottom-curve-asymmetrical::after {';
						echo'height: calc(var(--eccp-mobileBottomShapeHeight,50)*1px);';
						echo'left:-1px;';
					echo'}';
					

					/* ------------ Triangle (Triangle) -----------------------*/
					 
					/* Forme supérieure */
					echo'.is-style-eccp-shape-divider.style-shape-top-triangle::before {';
						echo'height: calc(var(--eccp-mobileTopShapeHeight,50)*1px);';
					echo'}';
					

					/* Forme inférieure */
					echo'.is-style-eccp-shape-divider.style-shape-bottom-triangle::after {';
						echo'height: calc(var(--eccp-mobileBottomShapeHeight,50)*1px);';
					echo'}';
					

					/* ------------ Triangle Assymétrique(Triangle Asymmetrical) -----------------------*/
					 
					 /* Forme supérieure */
					echo'.is-style-eccp-shape-divider.style-shape-top-triangle-asymmetrical::before {';
						echo'height: calc(var(--eccp-mobileTopShapeHeight,50)*1px);';
					echo'}';

					/* Forme inférieure */
					echo'.is-style-eccp-shape-divider.style-shape-bottom-triangle-asymmetrical::after {';
						echo'height: calc(var(--eccp-mobileBottomShapeHeight,50)*1px);';
					echo'}';
					
					/* ------------ Forme Vagues(waves ) -----------------------*/

					/* Forme supérieure */
					echo'.is-style-eccp-shape-divider.style-shape-top-waves::before {';
						echo'height: calc(var(--eccp-mobileTopShapeHeight,50)*1px);';
					echo'}';
					
					/* Forme inférieure */
					echo'.is-style-eccp-shape-divider.style-shape-bottom-waves::after {';
						echo'height: calc(var(--eccp-mobileBottomShapeHeight,50)*1px);';
					echo'}';
					
					/* retournement horizontal */
					echo'.is-style-eccp-shape-divider.bottom-shape-flip-horizontally.style-shape-bottom-waves::after {';
						echo'left:-1px;';
					echo'}';

					/* ------------ Forme Vagues avec opacité(waves opacity) -----------------------*/
					 
					 /* Forme supérieure */
					echo'.is-style-eccp-shape-divider.style-shape-top-waves-opacity::before {';
						echo'top: calc(var(--eccp-mobileTopShapeHeight,50)*-1px);';
						echo'height: calc(var(--eccp-mobileTopShapeHeight,50)*1px);';
					echo'}';
					
					/* Forme inférieure */
					echo'.is-style-eccp-shape-divider.style-shape-bottom-waves-opacity::after {';
						echo'bottom: calc(var(--eccp-mobileBottomShapeHeight,50)*-1px);';
						echo'height: calc(var(--eccp-mobileBottomShapeHeight,50)*1px);';
					echo'}';
					
					/* ------------ Forme Diviser(Split) -----------------------*/
					 
					 /* Forme supérieure */
					echo'.is-style-eccp-shape-divider.style-shape-top-split::before {';
						echo'height: calc(var(--eccp-mobileTopShapeHeight,50)*1px);';
					echo'}';
					

					/* Forme inférieure */
					echo'.is-style-eccp-shape-divider.style-shape-bottom-split::after {';
						echo'height: calc(var(--eccp-mobileBottomShapeHeight,50)*1px);';
					echo'}';
					

					/* ------------ Forme Livre(Book) -----------------------*/
					 
					 /* Forme supérieure */
					echo'.is-style-eccp-shape-divider.style-shape-top-book::before {';
						echo'height: calc(var(--eccp-mobileTopShapeHeight,50)*1px);';
					echo'}';
					

					/* Forme inférieure */
					echo'.is-style-eccp-shape-divider.style-shape-bottom-book::after {';
						echo'height: calc(var(--eccp-mobileBottomShapeHeight,50)*1px);';
					echo'}';
					

					/* ------------ Forme Ventilateur() -----------------------*/
					 
					 /* Forme supérieure */
					echo'.is-style-eccp-shape-divider.style-shape-top-fan::before {';
						echo'height: calc(var(--eccp-mobileTopShapeHeight,50)*1px);';
					echo'}';
					

					/* Forme inférieure */
					echo'.is-style-eccp-shape-divider.style-shape-bottom-fan::after {';
						echo'height: calc(var(--eccp-mobileBottomShapeHeight,50)*1px);';
					echo'}';

				echo'}';


				/*------------------- BLOC DÉTAILS BACK OFFICE --------------------------*/
				
				/*------------------- Icône Dashicons Arrow Back Office ----------------*/
			
				//Icône Dashicons Arrow pour indiquer si le contenu du bloc détails 
				//est affiché ou masqué
				
				/*
				On masque le petit triangle horizontal
				qui est le contrôle utilisé par la balise détails
				afin d'indiquer si son contenu est révélé ou non
				*/
				echo'.editor-styles-wrapper .wp-block-details.is-style-details-dashicons-arrow summary:first-of-type {';
					echo'list-style: none!important;';
				echo'}';
				
				/* 
				icone dashicons flêche vers le bas 
				pour la balise détails fermé
				*/
				echo'.editor-styles-wrapper .wp-block-details.is-style-details-dashicons-arrow summary::before {';
					echo'content: "\f347";';
					echo'font-family: "dashicons";';
					echo'float:left;';
					echo'margin-right:10px;';
				echo'}';


				/* 
				icone dashicons flêche vers le haut 
				pour la balise détails ouverte
				*/
				echo'.editor-styles-wrapper .wp-block-details.is-style-details-dashicons-arrow[open] summary::before {';
					echo'content: "\f343";';
					echo'font-family: "dashicons";';
					echo'float:left;';
				echo'}';
				
				/*------------------- BLOC LISTE BACK OFFICE --------------------------*/
				
				
				/* On fait correspondre respectivement la taille & couleur des items de liste à celles des Tailles de texte & couleurs sélectionné de la palette */
			
			
				//petite
				echo'.editor-styles-wrapper .wp-block-list.has-eccp-small-font-size  li{';
					echo'font-size:'.intval($editor_text_size_settings['eccp_settings_small_font_size_text_field']).'px;';
				echo'}';
				
				//normale
				echo'.editor-styles-wrapper .wp-block-list.has-eccp-regular-font-size li {';
					echo'font-size:'.intval($editor_text_size_settings['eccp_settings_regular_font_size_text_field']).'px;';
				echo'}';
				
				//grande
				echo'.editor-styles-wrapper .wp-block-list.has-eccp-large-font-size li {';
					echo'font-size:'.intval($editor_text_size_settings['eccp_settings_large_font_size_text_field']).'px;';
				echo'}';
				
				// enorme
				echo'.editor-styles-wrapper .wp-block-list.has-eccp-huge-font-size li {';
					echo'font-size:'.intval($editor_text_size_settings['eccp_settings_huge_font_size_text_field']).'px!important;';
				echo'}';
				
				// on affecte a l'item de liste la couleur sélectionnée de la palette
				echo'.editor-styles-wrapper .wp-block-list.has-text-color  li{';
					echo'color: var(--eccp-textColor);';
				echo'}';
				
				
				if( $custom_gutenberg_blocks_settings['eccp_settings_activate_styles_bullet_list_radio_field'] == 'yes' ) {
					
					// on récupère la version du thème actif
					$my_theme = wp_get_theme();
					
					// substr retourne une sous chaine de la position:1 jusqu'a la fin				
					//$icone_color = substr($custom_gutenberg_blocks_settings['eccp_settings_bulleted_list_color_text_field'],1);
					
					/*-------------------style Disc back office(style par défaut)----------------*/
					
					
					echo'body.wp-admin .is-style-default li::marker{';
					
						echo'color: var(--eccp-bulletColor,#333333);';
						// comme la variable CSS --eccp-bulletSize est de type integer
						// il faut passer par la fonction calc pour affecter une taille en px
						echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
						
					echo'}'; 	
						
					/*------------------- Style Square back office --------------------------*/
					
					echo'body.wp-admin .is-style-eccp-square-bullet-list {';
					
						echo'list-style:square;';
					
					echo'}';
					
					
					echo'body.wp-admin .is-style-eccp-square-bullet-list li::marker{';
					
						echo'color: var(--eccp-bulletColor,#333333);';
						echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
						
					echo'}';
					
					
					/*------------------- Style Check back office --------------------------*/
					
					/* icone Google
					echo'body.wp-admin .is-style-eccp-check-bullet-list {';
						
						echo'list-style-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\''.esc_html($custom_gutenberg_blocks_settings['eccp_settings_bulleted_list_size_text_field']).'px\' viewBox=\'0 0 24 24\' width=\''.esc_html($custom_gutenberg_blocks_settings['eccp_settings_bulleted_list_size_text_field']).'px\' fill=\'%23'.esc_html($icone_color).'\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z\'/%3E%3C/svg%3E")';
					
					echo'}';*/
					
					
					echo'body.wp-admin .is-style-eccp-check-bullet-list li{';
				
						// on supprime la puce disk par défaut
						echo'list-style-type: none;';
						
						echo'padding-left: 8px;';
						echo'position: relative;';
					
					echo'}';
					
					
					echo'body.wp-admin .is-style-eccp-check-bullet-list li::before{';
						
						// la taille initiale du SVG est donné par width & height
						// pour le background-size
						// la variation de la taille se fera par la régle transform
						echo' background-size: cover!important;
							  display: inline-block; 
							  height:25px;
							  width:25px;
							  left: -25px;
							  position: absolute;
							  top: 1em;                  
							  margin-top: -1em;                  	                  
							  mask-repeat: no-repeat;	                 
							  -webkit-mask-repeat: no-repeat;';
						
						// on applique une taille au svg en fonction de la variable
						// css --eccp-bulletSize donné par le script reactjs et 
						// enregistré dans le html du bloc par la régle style				
						echo'transform: scale(calc(var(--eccp-bulletSize,20) / 25));';
					
					echo'}';
					
					 
					// modification position icône selon les thèmes
					switch ($my_theme) {
						
						
						// correction theme divi
						case stristr($my_theme, 'divi'):
					
							echo'body.wp-admin .is-style-eccp-check-bullet-list li::before{';
								echo'top: 1em;';
							echo'}';
					
						break;
						
					}
					
					
					echo'body.wp-admin ul.is-style-eccp-check-bullet-list li::before{';
						
						// lorsqu'on affiche un icone avec la régle pseudo :before
						// il faut appliquer la régle content: "" pour que cela fonctionne
						// on applique une couleur de fond au svg avec la variable CSS
						// --eccp-bulletColor définit par le script ReactJS et enreigistré dans le
						// html du bloc par la régle style
						echo' content: "";
							  background-color: var(--eccp-bulletColor,#333333)!important;';
							  
					echo'}';
					
					
					echo'body.wp-admin .is-style-eccp-check-bullet-list li::before{';
						
						// icone Google
						// la régle mask-image permettra d'appliquer une couleur au SVG
						echo'-webkit-mask-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\'  viewBox=\'0 0 24 24\' fill=\'%23000000\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z\'/%3E%3C/svg%3E");';
						echo'mask-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\'  viewBox=\'0 0 24 24\' fill=\'%23000000\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z\'/%3E%3C/svg%3E");';
						
					echo'}';
					
					
					/*------------------- Style Check circle fill back office --------------------------*/
					
					/* icone Iconify
					echo'body.wp-admin .is-style-eccp-check-circle-fill-bullet-list {';
						
						echo'list-style-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' xmlns:xlink=\'http://www.w3.org/1999/xlink\' aria-hidden=\'true\' role=\'img\' width=\''.esc_html($custom_gutenberg_blocks_settings['eccp_settings_bulleted_list_size_text_field']).'px\' height=\''.esc_html($custom_gutenberg_blocks_settings['eccp_settings_bulleted_list_size_text_field']).'px\' preserveAspectRatio=\'xMidYMid meet\' viewBox=\'0 0 24 24\'%3E%3Cg fill=\'none\'%3E%3Cpath d=\'M12 22c-5.52-.006-9.994-4.48-10-10v-.2C2.11 6.305 6.635 1.928 12.13 2c5.497.074 9.904 4.569 9.868 10.065C21.962 17.562 17.497 22 12 22zM7.41 11.59L6 13l4 4l8-8l-1.41-1.42L10 14.17l-2.59-2.58z\' fill=\'%23'.esc_html($icone_color).'\'/%3E%3C/g%3E%3C/svg%3E")';
					
					echo'}';*/

					
					echo'body.wp-admin .is-style-eccp-check-circle-fill-bullet-list li{';
				
						// on supprime la puce disk par défaut
						echo'list-style-type: none;';
						
						echo'padding-left: 8px;';
						echo'position: relative;';
					
					echo'}';
					
					
					echo'body.wp-admin .is-style-eccp-check-circle-fill-bullet-list li::before{';
								
						echo' background-size: cover!important;
							  display: inline-block; 
							  height:25px;
							  width:25px;
							  left: -25px;
							  position: absolute;
							  top: 1em;                  
							  margin-top: -1em;                  	                  
							  mask-repeat: no-repeat;	                 
							  -webkit-mask-repeat: no-repeat;';
						
						// on applique une taille au svg	  
						echo'transform: scale(calc(var(--eccp-bulletSize,20) / 25));';
					
					echo'}';
					
					
					// modification position icône selon les thèmes
					switch ($my_theme) {
						
			
						// correction theme divi
						case stristr($my_theme, 'divi'):
					
							echo'body.wp-admin .is-style-eccp-check-circle-fill-bullet-list li::before{';
								echo'top: 1em;';
							echo'}';
					
						break;
						
					}
					
					
					
					echo'body.wp-admin ul.is-style-eccp-check-circle-fill-bullet-list li::before{';
						
						// lorsqu'on affiche un icone avec la régle pseudo :before
						// il faut appliquer la régle content: "" pour que cela fonctionne
						// on applique une couleur de fond au svg avec la variable CSS
						// --eccp-bulletColor définit par le script ReactJS et enreigistré dans le
						// html du bloc par la régle style
						echo' content: "";
							  background-color: var(--eccp-bulletColor,#333333)!important;';
							  
					echo'}';
					
					
					echo'body.wp-admin .is-style-eccp-check-circle-fill-bullet-list li::before{';
						
						// icone Google
						// la régle mask-image permettra d'appliquer une couleur au SVG
						echo'-webkit-mask-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'24px\' viewBox=\'0 0 24 24\' width=\'24px\' fill=\'%23000000\'%3E%3Cpath d=\'M0 0h24v24H0z\' fill=\'none\'/%3E%3Cpath d=\'M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z\'/%3E%3C/svg%3E");';
						echo'mask-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'24px\' viewBox=\'0 0 24 24\' width=\'24px\' fill=\'%23000000\'%3E%3Cpath d=\'M0 0h24v24H0z\' fill=\'none\'/%3E%3Cpath d=\'M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z\'/%3E%3C/svg%3E");';
						
					echo'}';
					
					
					/*------------------- Style Add back office --------------------------*/
					
					/* icone Google
					echo'body.wp-admin .is-style-eccp-add-bullet-list li{';
						
						// on supprime la puce disk par défaut
						echo'list-style-type: none;';
						
						echo'background:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'20px\' viewBox=\'0 0 24 24\' width=\'20px\' fill=\'%23'.esc_html($icone_color).'\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z\'/%3E%3C/svg%3E")no-repeat;';
						echo'background-size: '.esc_html($custom_gutenberg_blocks_settings['eccp_settings_bulleted_list_size_text_field']).'px;';
						echo'background-position: 7px 6px;';
						echo'padding: 0px 0px 0px 35px;';
						echo'margin-left:-35px;';
					
					echo'}';
					
					
					$my_theme = wp_get_theme();
			
					// correction theme divi pour la position des puces +
					if(stristr($my_theme, 'divi')) {
						
						echo'body.wp-admin .is-style-eccp-add-bullet-list li {';
							echo'background-position: 7px 3px!important;';
						echo'}';
					
					}*/
					
					echo'body.wp-admin .is-style-eccp-add-bullet-list li{';
				
						// on supprime la puce disk par défaut
						echo'list-style-type: none;';
						
						echo'padding-left: 8px;';
						echo'position: relative;';
					
					echo'}';
					
					
					echo'body.wp-admin .is-style-eccp-add-bullet-list li::before{';
								
						echo' background-size: cover!important;
							  display: inline-block; 
							  height:25px;
							  width:25px;
							  left: -25px;
							  position: absolute;
							  top: 1.2em;                  
							  margin-top: -1em;                  	                  
							  mask-repeat: no-repeat;	                 
							  -webkit-mask-repeat: no-repeat;';
						
						// on applique une taille au svg	  
						echo'transform: scale(calc(var(--eccp-bulletSize,20) / 25));';
					
					echo'}';
					
					
					// modification position icône selon les thèmes
					switch ($my_theme) {
						
						// correction theme divi
						case stristr($my_theme, 'divi'):
					
							echo'body.wp-admin .is-style-eccp-add-bullet-list li::before{';
								echo'top: 1.1em;';
							echo'}';
					
						break;
						
					}
					
					
					echo'body.wp-admin ul.is-style-eccp-add-bullet-list li::before{';
						
						// lorsqu'on affiche un icone avec la régle pseudo :before
						// il faut appliquer la régle content: "" pour que cela fonctionne
						// on applique une couleur de fond au svg avec la variable CSS
						// --eccp-bulletColor définit par le script ReactJS et enreigistré dans le
						// html du bloc par la régle style
						echo' content: "";
							  background-color: var(--eccp-bulletColor,#333333)!important;';
							  
					echo'}';
					
					
					echo'body.wp-admin .is-style-eccp-add-bullet-list li::before{';
						
						// icône Google
						// la régle mask-image permettra d'appliquer une couleur au SVG
						echo'-webkit-mask-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'20px\' viewBox=\'0 0 24 24\' width=\'20px\' fill=\'%23000000\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z\'/%3E%3C/svg%3E");';
						echo'mask-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'20px\' viewBox=\'0 0 24 24\' width=\'20px\' fill=\'%23000000\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z\'/%3E%3C/svg%3E");';
						
					echo'}';
					
					
					
					/*------------------- Style Add circle fill back office --------------------------*/
					
					/* icone Google
					echo'body.wp-admin .is-style-eccp-add-circle-fill-bullet-list li {';
					
						// on supprime la puce disk par défaut
						echo'list-style-type: none;';
						
						echo'background:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'20px\' viewBox=\'0 0 24 24\' width=\'20px\' fill=\'%23'.esc_html($icone_color).'\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm5 11h-4v4h-2v-4H7v-2h4V7h2v4h4v2z\'/%3E%3C/svg%3E")no-repeat;';
						echo'background-size: '.esc_html($custom_gutenberg_blocks_settings['eccp_settings_bulleted_list_size_text_field']).'px;';
						echo'background-position: 7px 6px;';
						echo'padding: 0px 0px 0px 35px;';
						echo'margin-left:-35px;';
					
					echo'}';
					
					
					// correction theme divi pour la position des puces +
					if(stristr($my_theme, 'divi')) {
						
						echo'body.wp-admin .is-style-eccp-add-circle-fill-bullet-list li {';
							echo'background-position: 7px 3px!important;';
						echo'}';
					
					}*/
					
					
					echo'body.wp-admin .is-style-eccp-add-circle-fill-bullet-list li{';
				
						// on supprime la puce disk par défaut
						echo'list-style-type: none;';
						
						echo'padding-left: 8px;';
						echo'position: relative;';
					
					echo'}';
					
					
					echo'body.wp-admin .is-style-eccp-add-circle-fill-bullet-list li::before{';
								
						echo' background-size: cover!important;
							  display: inline-block; 
							  height:25px;
							  width:25px;
							  left: -25px;
							  position: absolute;
							  top: 1.2em;                  
							  margin-top: -1em;                  	                  
							  mask-repeat: no-repeat;	                 
							  -webkit-mask-repeat: no-repeat;';
						
						// on applique une taille au svg	  
						echo'transform: scale(calc(var(--eccp-bulletSize,20) / 25));';
					
					echo'}';
					
					
					// modification position icône selon les thèmes
					switch ($my_theme) {
						
						// correction theme divi
						case stristr($my_theme, 'divi'):
					
							echo'body.wp-admin .is-style-eccp-add-circle-fill-bullet-list li::before{';
								echo'top: 1.1em;';
							echo'}';
					
						break;
						
					}
					
					
					echo'body.wp-admin ul.is-style-eccp-add-circle-fill-bullet-list li::before{';
						
						// lorsqu'on affiche un icone avec la régle pseudo :before
						// il faut appliquer la régle content: "" pour que cela fonctionne
						// on applique une couleur de fond au svg avec la variable CSS
						// --eccp-bulletColor définit par le script ReactJS et enreigistré dans le
						// html du bloc par la régle style
						echo' content: "";
							  background-color: var(--eccp-bulletColor,#333333)!important;';
							  
					echo'}';
					
					
					echo'body.wp-admin .is-style-eccp-add-circle-fill-bullet-list li::before{';
						
						// icône Google
						// la régle mask-image permettra d'appliquer une couleur au SVG
						echo'-webkit-mask-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'20px\' viewBox=\'0 0 24 24\' width=\'20px\' fill=\'%23000000\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm5 11h-4v4h-2v-4H7v-2h4V7h2v4h4v2z\'/%3E%3C/svg%3E");';
						echo'mask-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'20px\' viewBox=\'0 0 24 24\' width=\'20px\' fill=\'%23000000\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm5 11h-4v4h-2v-4H7v-2h4V7h2v4h4v2z\'/%3E%3C/svg%3E");';
						
					echo'}';
					
					
					/*------------------- Style Push Spin back office --------------------------*/

					// icone Dashicons
					echo'.is-style-eccp-push-spin-bullet-list li:before {';
			
						echo'font-family: dashicons;';
						echo'content: "\f109";';
						echo'font-weight: 400;';
						echo'vertical-align: top;';	
						echo'margin-left:-25px;';
						echo'margin-right:10px;';				
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
						echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
						echo'color:var(--eccp-bulletColor,#333333);';
						// correction WordPress 6.1
						echo'position: absolute;';
						
					echo'}';
					
					// on supprime la liste à puces par défaut
					echo'.is-style-eccp-push-spin-bullet-list{';
					
						echo'list-style-type: none;';
					
					echo'}';
					
					// modification position icône selon les thèmes
					switch ($my_theme) {
						
						// correction theme Astra
						case stristr($my_theme, 'astra'):
					
							echo'body.wp-admin .is-style-eccp-push-spin-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
							echo'}';
					
						break;
						
						// correction theme divi
						case stristr($my_theme, 'divi'):
					
							echo'body.wp-admin .is-style-eccp-push-spin-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
							echo'}';
					
						break;
						
						// correction theme Generate Press
						case stristr($my_theme, 'generatepress'):
					
							echo'body.wp-admin .is-style-eccp-push-spin-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
							echo'}';
					
						break;
						
					}
					
					
					// pour éviter que la liste ordonnée sélectionnée a partir de la barre d'outils du block
					// ne se supperpose au style Push Spin
					echo'body.wp-admin .is-style-eccp-push-spin-bullet-list li::marker{';
						
						echo'content:\'\';';
					
					echo'}';
 
 
					/*------------------- Style Circle Duotone back office --------------------------*/
					
					// en back office on  prend  70% de la taille définit dans les paramètres de réglage
					// du plugin pour un même rendu que les autres puces
					// pour ce cercle bicolore une couleur est fixé: #108bc5, l'autre couleur est réglable
					echo'body.wp-admin .is-style-eccp-circle-duotone-bullet-list li::before {';
					 
						echo'content: "";';
						echo'display: inline-block;';
						echo'margin-left: -20px;';
						echo'margin-right: 10px;';
						echo'border: 3px solid var(--eccp-bulletColor,#333333);';
						echo'border-left: 3px solid #108bc5;';
						echo'border-radius: 50%;';
						echo'height: calc(var(--eccp-bulletSize,20) * 1px * 0.45);';
						echo'width: calc(var(--eccp-bulletSize,20) * 1px * 0.45);';
						// correction WordPress 6.1
						echo'position: absolute;';
						echo'top: 10px;';
					echo'}';	

					
					$my_theme = wp_get_theme();
			
					// correction theme generatePress pour la taille des puces 
					if(stristr($my_theme, 'generatepress')|| stristr($my_theme, 'astra')) {
						
						echo'body.wp-admin .is-style-eccp-circle-duotone-bullet-list li::before {';
					 
							echo'height: calc(var(--eccp-bulletSize,20) * 1px * 0.7);';
							echo'width: calc(var(--eccp-bulletSize,20) * 1px * 0.7);';
					
						echo'}';	
					
					}
					
					echo'.is-style-eccp-circle-duotone-bullet-list li::marker{';
						
						// on supprime la puce disk par défaut
						echo'content:\'\';';
			
					echo'}';
					
					// pour éviter que la liste ordonnée sélectionnée a partir de la barre d'outils du block
					// ne se supperpose au style circle duotone
					echo'body.wp-admin .is-style-eccp-circle-duotone-bullet-list li::marker{';
						
						echo'content:\'\';';
					
					echo'}';
					
					
					/*------------------- Style Clear back office --------------------------*/

					/* icone Google
					echo'body.wp-admin .is-style-eccp-clear-bullet-list li{';
						
						// on supprime la puce disk par défaut
						echo'list-style-type: none;';
						
						echo'background:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'24px\' viewBox=\'0 0 24 24\' width=\'24px\' fill=\'%23'.esc_html($icone_color).'\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12 19 6.41z\'/%3E%3C/svg%3E")no-repeat;';
						echo'background-size: '.esc_html($custom_gutenberg_blocks_settings['eccp_settings_bulleted_list_size_text_field']).'px;';
						echo'background-position: 7px 6px;';
						echo'padding: 0px 0px 0px 35px;';
						echo'margin-left:-35px;';
					
					echo'}';
					
					
					$my_theme = wp_get_theme();
			
					// correction theme divi pour la position des puces +
					if(stristr($my_theme, 'divi')) {
						
						echo'body.wp-admin .is-style-eccp-clear-bullet-list li {';
							echo'background-position: 7px 3px!important;';
						echo'}';
					
					}*/
					
					
					
					echo'body.wp-admin .is-style-eccp-clear-bullet-list li{';
				
						// on supprime la puce disk par défaut
						echo'list-style-type: none;';
						
						echo'padding-left: 8px;';
						echo'position: relative;';
					
					echo'}';
					
					echo'.is-style-eccp-clear-bullet-list li::before{';
						
						echo' background-size: cover!important;
							  display: inline-block; 
							  height:25px;
							  width:25px;
							  left: -25px;
							  position: absolute;
							  top: 1.1em;                  
							  margin-top: -1em;                  	                  
							  mask-repeat: no-repeat;	                 
							  -webkit-mask-repeat: no-repeat;';
						
						// on applique une taille au svg	  
						echo'transform: scale(calc(var(--eccp-bulletSize,20) / 25));';
					
					echo'}';
					
					
					// modification position icône selon les thèmes
					switch ($my_theme) {
						
						// correction theme divi
						case stristr($my_theme, 'divi'):
					
							echo'body.wp-admin .is-style-eccp-clear-bullet-list li::before{';
								echo'top: 1em;';
							echo'}';
					
						break;
						
					}
					
					
					echo'body.wp-admin ul.is-style-eccp-clear-bullet-list li::before{';
				
						// lorsqu'on affiche un icone avec la régle pseudo :before
						// il faut appliquer la régle content: "" pour que cela fonctionne
						// on applique une couleur de fond au svg avec la variable CSS
						// --eccp-bulletColor définit par le script ReactJS et enreigistré dans le
						// html du bloc avec la régle style
						echo' content: "";
							  background-color: var(--eccp-bulletColor,#333333)!important;';
							  
					echo'}';
					
					
					echo'body.wp-admin .is-style-eccp-clear-bullet-list li::before{';
						
						// icône Google
						// la régle mask-image permettra d'appliquer une couleur au SVG
						echo'-webkit-mask-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'24px\' viewBox=\'0 0 24 24\' width=\'24px\' fill=\'%23000000\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12 19 6.41z\'/%3E%3C/svg%3E");';
						echo'mask-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'24px\' viewBox=\'0 0 24 24\' width=\'24px\' fill=\'%23000000\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12 19 6.41z\'/%3E%3C/svg%3E");';
						
					echo'}';
					
					/*------------------- Style Site back office  --------------------------*/			
					
					// icone Dashicons
					echo'.is-style-eccp-site-bullet-list li:before {';
			
						echo'font-family: dashicons;';
						echo'content: "\f11f";';
						echo'font-weight: 400;';
						echo'vertical-align: top;';	
						echo'margin-left:-25px;';
						echo'margin-right:10px;';				
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
						echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
						echo'color:var(--eccp-bulletColor,#333333);';
						// correction WordPress 6.1
						echo'position: absolute;';
					echo'}';
					
					// on supprime la liste à puces par défaut
					echo'.is-style-eccp-site-bullet-list{';
					
						echo'list-style-type: none;';
					
					echo'}';
					
					
					// modification position icône selon les thèmes
					switch ($my_theme) {
						
						// correction theme Generate Press
						case stristr($my_theme, 'generatepress'):
					
							echo'body.wp-admin .is-style-eccp-site-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.2em);';
							echo'}';
					
						break;
						
					}
					
					
					// pour éviter que la liste ordonnée sélectionnée a partir de la barre d'outils du block
					// ne se supperpose au style Site
					echo'body.wp-admin .is-style-eccp-site-bullet-list li::marker{';
						
						echo'content:\'\';';
					
					echo'}';
					
					
					/*------------------- Style E-Mail back office  --------------------------*/			
					
					// icone Dashicons
					echo'.is-style-eccp-mail-bullet-list li:before {';
			
						echo'font-family: dashicons;';
						echo'content: "\f465";';
						echo'font-weight: 400;';
						echo'vertical-align: top;';	
						echo'margin-left:-25px;';
						echo'margin-right:10px;';				
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
						echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
						echo'color:var(--eccp-bulletColor,#333333);';
						// correction WordPress 6.1
						echo'position: absolute;';
					echo'}';
					
					// on supprime la liste à puces par défaut
					echo'.is-style-eccp-mail-bullet-list{';
					
						echo'list-style-type: none;';
					
					echo'}';
			
					// pour éviter que la liste ordonnée sélectionnée a partir de la barre d'outils du block
					// ne se supperpose au style E-Mail
					echo'body.wp-admin .is-style-eccp-mail-bullet-list li::marker{';
						
						echo'content:\'\';';
					
					echo'}';
					
					/*------------------- Style Phone back office  --------------------------*/
			
					// icone Dashicons
					echo'.is-style-eccp-phone-bullet-list li:before {';
			
						echo'font-family: dashicons;';
						echo'content: "\f525";';
						echo'font-weight: 600;';
						echo'vertical-align: top;';	
						echo'margin-left:-25px;';
						echo'margin-right:10px;';				
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
						echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
						echo'color:var(--eccp-bulletColor,#333333);';
						// correction WordPress 6.1
						echo'position: absolute;';
					echo'}';
					
					// on supprime la liste à puces par défaut
					echo'.is-style-eccp-phone-bullet-list{';
					
						echo'list-style-type: none;';
					
					echo'}';
					
					
					// modification position icône selon les thèmes
					switch ($my_theme) {
						
						// correction theme divi
						case stristr($my_theme, 'divi'):
					
							echo'body.wp-admin .is-style-eccp-phone-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
							echo'}';
					
						break;
						
						// correction theme Generate Press
						case stristr($my_theme, 'generatepress'):
					
							echo'body.wp-admin .is-style-eccp-phone-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
							echo'}';
					
						break;
						
					}
					
					// pour éviter que la liste ordonnée sélectionnée a partir de la barre d'outils du block
					// ne se supperpose au style Phone
					echo'body.wp-admin .is-style-eccp-phone-bullet-list li::marker{';
						
						echo'content:\'\';';
					
					echo'}';
					
			
					/*------------------- Style Facebook back office  --------------------------*/			
							
					// icone Dashicons
					echo'.is-style-eccp-facebook-bullet-list li:before {';
			
						echo'font-family: dashicons;';
						echo'content: "\f305";';
						echo'font-weight: 400;';
						echo'vertical-align: top;';	
						echo'margin-left:-25px;';
						echo'margin-right:10px;';				
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
						echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
						echo'color:var(--eccp-bulletColor,#333333);';
						// correction WordPress 6.1
						echo'position: absolute;';
					echo'}';
					
					// on supprime la liste à puces par défaut
					echo'.is-style-eccp-facebook-bullet-list{';
					
						echo'list-style-type: none;';
					
					echo'}';
					
					
					// modification position icône selon les thèmes
					switch ($my_theme) {
						
						
						// correction theme divi
						case stristr($my_theme, 'divi'):
					
							echo'body.wp-admin .is-style-eccp-facebook-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.2em);';
							echo'}';
					
						break;
						
						// correction theme Generate Press
						case stristr($my_theme, 'generatepress'):
					
							echo'body.wp-admin .is-style-eccp-facebook-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
							echo'}';
					
						break;
						
					}
	
					
					// pour éviter que la liste ordonnée sélectionnée a partir de la barre d'outils du block
					// ne se supperpose au style Facebook
					echo'body.wp-admin .is-style-eccp-facebook-bullet-list li::marker{';
						
						echo'content:\'\';';
					
					echo'}';
	
					
					/*------------------- Style YouTube back office  --------------------------*/			
					
					// icone Dashicons
					echo'.is-style-eccp-youtube-bullet-list li:before {';
			
						echo'font-family: dashicons;';
						echo'content: "\f19b";';
						echo'font-weight: 400;';
						echo'vertical-align: top;';	
						echo'margin-left:-25px;';
						echo'margin-right:10px;';				
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
						echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
						echo'color:var(--eccp-bulletColor,#333333);';
						// correction WordPress 6.1
						echo'position: absolute;';
					echo'}';
					
					// on supprime la liste à puces par défaut
					echo'.is-style-eccp-youtube-bullet-list{';
					
						echo'list-style-type: none;';
					
					echo'}';
					
					// modification position icône selon les thèmes
					switch ($my_theme) {
						
						
						// correction theme divi
						case stristr($my_theme, 'divi'):
					
							echo'body.wp-admin .is-style-eccp-youtube-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.2em);';
							echo'}';
					
						break;
						
						// correction theme Generate Press
						case stristr($my_theme, 'generatepress'):
					
							echo'body.wp-admin .is-style-eccp-youtube-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
							echo'}';
					
						break;
						
					}
					
					
					// pour éviter que la liste ordonnée sélectionnée a partir de la barre d'outils du block
					// ne se supperpose au style YouTube
					echo'body.wp-admin .is-style-eccp-youtube-bullet-list li::marker{';
						
						echo'content:\'\';';
					
					echo'}';
					
					
					/*------------------- Style Twiter back office  --------------------------*/			
					
					// icone Dashicons
					echo'.is-style-eccp-twiter-bullet-list li:before {';
			
						echo'font-family: dashicons;';
						echo'content: "\f301";';
						echo'font-weight: 400;';
						echo'vertical-align: top;';	
						echo'margin-left:-25px;';
						echo'margin-right:10px;';				
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
						echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
						echo'color:var(--eccp-bulletColor,#333333);';
						// correction WordPress 6.1
						echo'position: absolute;';
					echo'}';
					
					// on supprime la liste à puces par défaut
					echo'.is-style-eccp-twiter-bullet-list{';
					
						echo'list-style-type: none;';
					
					echo'}';
					
					// modification position icône selon les thèmes
					switch ($my_theme) {
						
						
						// correction theme divi
						case stristr($my_theme, 'divi'):
					
							echo'body.wp-admin .is-style-eccp-twiter-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.2em);';
							echo'}';
					
						break;
						
						// correction theme Generate Press
						case stristr($my_theme, 'generatepress'):
					
							echo'body.wp-admin .is-style-eccp-twiter-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
							echo'}';
					
						break;
					
					}
			
					// pour éviter que la liste ordonnée sélectionnée a partir de la barre d'outils du block
					// ne se supperpose au style Twiter
					echo'body.wp-admin .is-style-eccp-twiter-bullet-list li::marker{';
						
						echo'content:\'\';';
					
					echo'}';
					
					/*------------------- Style Pinterest back office  --------------------------*/			
					
					// icone Dashicons
					echo'.is-style-eccp-pinterest-bullet-list li:before {';
			
						echo'font-family: dashicons;';
						echo'content: "\f192";';
						echo'font-weight: 400;';
						echo'vertical-align: top;';	
						echo'margin-left:-25px;';
						echo'margin-right:10px;';				
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
						echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
						echo'color:var(--eccp-bulletColor,#333333);';
						// correction WordPress 6.1
						echo'position: absolute;';
					echo'}';
					
					// on supprime la liste à puces par défaut
					echo'.is-style-eccp-pinterest-bullet-list{';
					
						echo'list-style-type: none;';
					
					echo'}';
					
					// modification position icône selon les thèmes
					switch ($my_theme) {
						
						
						// correction theme divi
						case stristr($my_theme, 'divi'):
					
							echo'body.wp-admin .is-style-eccp-pinterest-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.2em);';
							echo'}';
					
						break;
						
						// correction theme Generate Press
						case stristr($my_theme, 'generatepress'):
					
							echo'body.wp-admin .is-style-eccp-pinterest-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
							echo'}';
					
						break;
					
					}
			
					// pour éviter que la liste ordonnée sélectionnée a partir de la barre d'outils du block
					// ne se supperpose au style pinterest
					echo'body.wp-admin .is-style-eccp-pinterest-bullet-list li::marker{';
						
						echo'content:\'\';';
					
					echo'}';
					
					/*------------------- Style Instagram back office  --------------------------*/			
					
					// icone Dashicons
					echo'.is-style-eccp-instagram-bullet-list li:before {';
			
						echo'font-family: dashicons;';
						echo'content: "\f12d";';
						echo'font-weight: 400;';
						echo'vertical-align: top;';	
						echo'margin-left:-25px;';
						echo'margin-right:10px;';				
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
						echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
						echo'color:var(--eccp-bulletColor,#333333);';
						// correction WordPress 6.1
						echo'position: absolute;';
					echo'}';
					
					// on supprime la liste à puces par défaut
					echo'.is-style-eccp-instagram-bullet-list{';
					
						echo'list-style-type: none;';
					
					echo'}';
					
					// modification position icône selon les thèmes
					switch ($my_theme) {
						
						
						// correction theme divi
						case stristr($my_theme, 'divi'):
					
							echo'body.wp-admin .is-style-eccp-instagram-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.2em);';
							echo'}';
					
						break;
						
						// correction theme Generate Press
						case stristr($my_theme, 'generatepress'):
					
							echo'body.wp-admin .is-style-eccp-instagram-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
							echo'}';
					
						break;
					
					}
			
					// pour éviter que la liste ordonnée sélectionnée a partir de la barre d'outils du block
					// ne se supperpose au style instagram
					echo'body.wp-admin .is-style-eccp-instagram-bullet-list li::marker{';
						
						echo'content:\'\';';
					
					echo'}';
					
					/*------------------- Style Linkedin back office  --------------------------*/			
					
					// icone Dashicons
					echo'.is-style-eccp-linkedin-bullet-list li:before {';
			
						echo'font-family: dashicons;';
						echo'content: "\f18d";';
						echo'font-weight: 400;';
						echo'vertical-align: top;';	
						echo'margin-left:-25px;';
						echo'margin-right:10px;';				
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
						echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
						echo'color:var(--eccp-bulletColor,#333333);';
						// correction WordPress 6.1
						echo'position: absolute;';
					echo'}';
					
					// on supprime la liste à puces par défaut
					echo'.is-style-eccp-linkedin-bullet-list{';
					
						echo'list-style-type: none;';
					
					echo'}';
					
					// modification position icône selon les thèmes
					switch ($my_theme) {
						
						
						// correction theme divi
						case stristr($my_theme, 'divi'):
					
							echo'body.wp-admin .is-style-eccp-linkedin-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.2em);';
							echo'}';
					
						break;
						
						// correction theme Generate Press
						case stristr($my_theme, 'generatepress'):
					
							echo'body.wp-admin .is-style-eccp-linkedin-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
							echo'}';
					
						break;
					
					}
			
					// pour éviter que la liste ordonnée sélectionnée a partir de la barre d'outils du block
					// ne se supperpose au style Linkedin
					echo'body.wp-admin .is-style-eccp-linkedin-bullet-list li::marker{';
						
						echo'content:\'\';';
					
					echo'}';
					
					/*------------------- Style Whatsapp back office  --------------------------*/			
					
					// icone Dashicons
					echo'.is-style-eccp-whatsapp-bullet-list li:before {';
			
						echo'font-family: dashicons;';
						echo'content: "\f19a";';
						echo'font-weight: 400;';
						echo'vertical-align: top;';	
						echo'margin-left:-25px;';
						echo'margin-right:10px;';				
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
						echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
						echo'color:var(--eccp-bulletColor,#333333);';
						// correction WordPress 6.1
						echo'position: absolute;';
					echo'}';
					
					// on supprime la liste à puces par défaut
					echo'.is-style-eccp-whatsapp-bullet-list{';
					
						echo'list-style-type: none;';
					
					echo'}';
					
					// modification position icône selon les thèmes
					switch ($my_theme) {
						
						
						// correction theme divi
						case stristr($my_theme, 'divi'):
					
							echo'body.wp-admin .is-style-eccp-whatsapp-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.2em);';
							echo'}';
					
						break;
						
						// correction theme Generate Press
						case stristr($my_theme, 'generatepress'):
					
							echo'body.wp-admin .is-style-eccp-whatsapp-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
							echo'}';
					
						break;
					
					}
			
					// pour éviter que la liste ordonnée sélectionnée a partir de la barre d'outils du block
					// ne se supperpose au style Whatsapp
					echo'body.wp-admin .is-style-eccp-whatsapp-bullet-list li::marker{';
						
						echo'content:\'\';';
					
					echo'}';
					
					
					/*------------------- Style Calendar back office  --------------------------*/
			
					// icone Dashicons
					echo'.is-style-eccp-calendar-bullet-list li:before {';
			
						echo'font-family: dashicons;';
						echo'content: "\f508";';
						echo'font-weight: 400;';
						echo'vertical-align: top;';	
						echo'margin-left:-25px;';
						echo'margin-right:10px;';				
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
						echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
						echo'color:var(--eccp-bulletColor,#333333);';
						// correction WordPress 6.1
						echo'position: absolute;';
					echo'}';
					
					// on supprime la liste à puces par défaut
					echo'.is-style-eccp-calendar-bullet-list{';
					
						echo'list-style-type: none;';
					
					echo'}';
					
					
					// modification position icône selon les thèmes
					switch ($my_theme) {
						
						// correction theme Astra
						case stristr($my_theme, 'astra'):
					
							echo'body.wp-admin .is-style-eccp-calendar-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
							echo'}';
					
						break;
						
						// correction theme divi
						case stristr($my_theme, 'divi'):
					
							echo'body.wp-admin .is-style-eccp-calendar-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
							echo'}';
					
						break;
						
						// correction theme Generate Press
						case stristr($my_theme, 'generatepress'):
					
							echo'body.wp-admin .is-style-eccp-calendar-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
							echo'}';
					
						break;
					
					}
					
					// pour éviter que la liste ordonnée sélectionnée a partir de la barre d'outils du block
					// ne se supperpose au style Calendar
					echo'body.wp-admin .is-style-eccp-calendar-bullet-list li::marker{';
						
						echo'content:\'\';';
					
					echo'}';
					
			
					/*------------------- Style Clock back office  --------------------------*/			
							
					// icone Dashicons
					echo'.is-style-eccp-clock-bullet-list li:before {';
			
						echo'font-family: dashicons;';
						echo'content: "\f469";';
						echo'font-weight: 600;';
						echo'vertical-align: top;';	
						echo'margin-left:-25px;';
						echo'margin-right:10px;';				
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
						echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
						echo'color:var(--eccp-bulletColor,#333333);';
						// correction WordPress 6.1
						echo'position: absolute;';
					echo'}';
					
					// on supprime la liste à puces par défaut
					echo'.is-style-eccp-clock-bullet-list{';
					
						echo'list-style-type: none;';
					
					echo'}';
					
					
					// modification position icône selon les thèmes
					switch ($my_theme) {
						
						// correction theme Astra
						case stristr($my_theme, 'astra'):
					
							echo'body.wp-admin .is-style-eccp-clock-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
							echo'}';
					
						break;
						
						// correction theme divi
						case stristr($my_theme, 'divi'):
					
							echo'body.wp-admin .is-style-eccp-clock-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
							echo'}';
					
						break;
						
						// correction theme Generate Press
						case stristr($my_theme, 'generatepress'):
					
							echo'body.wp-admin .is-style-eccp-clock-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.2em);';
							echo'}';
					
						break;
						
						
					}
					
					
					// pour éviter que la liste ordonnée sélectionnée a partir de la barre d'outils du block
					// ne se supperpose au style Clock
					echo'body.wp-admin .is-style-eccp-clock-bullet-list li::marker{';
						
						echo'content:\'\';';
					
					echo'}';
	
					
					/*------------------- Style Location back office  --------------------------*/			
					
					// icone Dashicons
					echo'.is-style-eccp-location-bullet-list li:before {';
			
						echo'font-family: dashicons;';
						echo'content: "\f230";';
						echo'font-weight: 600;';
						echo'vertical-align: top;';	
						echo'margin-left:-25px;';
						echo'margin-right:10px;';				
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
						echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
						echo'color:var(--eccp-bulletColor,#333333);';
						// correction WordPress 6.1
						echo'position: absolute;';
					echo'}';
					
					// on supprime la liste à puces par défaut
					echo'.is-style-eccp-location-bullet-list{';
					
						echo'list-style-type: none;';
					
					echo'}';
					
					// modification position icône selon les thèmes
					switch ($my_theme) {
						
						// correction theme divi
						case stristr($my_theme, 'divi'):
					
							echo'body.wp-admin .is-style-eccp-location-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.2em);';
							echo'}';
					
						break;
						
						// correction theme Generate Press
						case stristr($my_theme, 'generatepress'):
					
							echo'body.wp-admin .is-style-eccp-location-bullet-list li::before{';
								echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.2em);';
							echo'}';
					
						break;
						
					}
					
					// pour éviter que la liste ordonnée sélectionnée a partir de la barre d'outils du block
					// ne se supperpose au style Location
					echo'body.wp-admin .is-style-eccp-location-bullet-list li::marker{';
						
						echo'content:\'\';';
					
					echo'}';
					
					
					/*------------------- Style Diagram back office  --------------------------*/
			
					/*

					Ajoutez des éléments de liste pour représenter la structure de votre diagramme. 
					Indentez les éléments de la liste qui doivent être les éléments de la sous-arborescence 
					dans le diagramme.
					Vous devez impérativement mettre en gras tous les éléments de la liste.
					Sélectionnez dans le panneau style des paramètres du bloc le style Diagram,
					pour avoir le visuel du diagramme en back office & front End.
					On ajoute au bloc liste la classe: is-style-eccp-tree-bullet-list.
					Pour toute modifications ultérieures sélectionner le style défaut,
					Une fois terminé les modifications, sélectionner le style Diagram. 

					*/


					echo'.is-style-eccp-tree-bullet-list, 
						 .is-style-eccp-tree-bullet-list ul,
						 .is-style-eccp-tree-bullet-list li{';
							//echo'list-style: none!important;';
							echo'margin: 0!important;';
							echo'padding: 0;';
							echo'position: relative;';
					echo'}';

					echo'.is-style-eccp-tree-bullet-list {';
						echo'margin: 0 0 1em;';
						echo'text-align: center;';
					echo'}';

					echo'.is-style-eccp-tree-bullet-list, .is-style-eccp-tree-bullet-list ul {';
						echo'display: table;';
					echo'}';

					echo'.is-style-eccp-tree-bullet-list ul {';
					  echo'width: 100%;';
					echo'}';

						/* encadrement des niveaux d'arborescence*/
						// Modif WordPress 6.1: ajout .editor-styles-wrapper 
						echo'.editor-styles-wrapper .is-style-eccp-tree-bullet-list li {';
							echo'display: table-cell;';
							echo'padding: .5em 0;';
							echo'vertical-align: top;';
						echo'}';
						
						echo'.is-style-eccp-tree-bullet-list li:before {';
							echo'outline: solid 1px #666;';
							echo'content: "";';
							echo'left: 0;';
							echo'position: absolute;';
							echo'right: 0;';
							echo'top: 0;';
						echo'}';
						
						echo'.is-style-eccp-tree-bullet-list li:first-child:before {';
							echo'left: 50%;';
						echo'}';
						
						echo'.is-style-eccp-tree-bullet-list li:last-child:before {';
							echo'right: 50%;';
						echo'}';

						// Modif WordPress 6.1: ajout .editor-styles-wrapper 	
						echo'.editor-styles-wrapper .is-style-eccp-tree-bullet-list strong {';
							echo'border: solid .1em #666;';
							echo'border-radius: .2em;';
							echo'display: inline-block;';
							echo'margin: 0 .2em .5em;';
							echo'padding: .2em .5em;';
							echo'position: relative;';
						echo'}';
						
						
						
					/* laison verticale du diagramme  | */
					echo'.is-style-eccp-tree-bullet-list ul:before,       
						 .is-style-eccp-tree-bullet-list strong:before {';
							echo'outline: solid 1px #666;';
							echo'content: "";';
							echo'height: .5em;';
							echo'left: 50%;';
							echo'top: -.55em;';
							echo'position: absolute;';
					echo'}';

					echo'.is-style-eccp-tree-bullet-list ul:before {';
						echo'top: -.5em;';
					echo'}';
					
					
					
					/*------------------- Style Disque Pour Liste Ordonnée back office  --------------------------*/
								
					/* Marge externe de la liste */
					echo'body.wp-admin ol.is-style-eccp-ordonned-disk-bullet-list {';
						echo'margin: 15px 0 15px 0px;';
					echo'}';

					/* type de puce de la liste */ 
					echo'body.wp-admin  ol.is-style-eccp-ordonned-disk-bullet-list {';
						echo'counter-reset: li;';
						echo'list-style: none;';
					echo'}';

					/* Régle pour la liste: marge interne, hauteur etc.. */
					echo'body.wp-admin  ol.is-style-eccp-ordonned-disk-bullet-list li {';
						echo'position: relative;';
						echo'padding-left: 20px;';
						echo'min-height: calc( ( var(--eccp-bulletSize,18) + 13 ) * 1px );';
					echo'}';

					/* Taille des chiffres de la liste ordonnée & du fond en forme de disque */
					echo'body.wp-admin  ol.is-style-eccp-ordonned-disk-bullet-list li::before {';
						echo'content: counter(li);';
						echo'counter-increment: li;';
						echo'color: #fff;';
						echo'background: var(--eccp-bulletColor,#333333);';
						echo'border-radius: 50%;';
						echo'font-size: calc( var(--eccp-bulletSize,18) * 1px );';
						echo'width: calc( (var(--eccp-bulletSize,18) + 5 ) * 1px );';
						echo'height: calc( (var(--eccp-bulletSize,18) + 5 ) * 1px );';
						echo'line-height: calc( (var(--eccp-bulletSize,18) + 5 ) * 1px );';
						echo'text-align: center;';
						echo'display: block;';
						echo'position: absolute;';
						echo'top: calc( ( (25 - var(--eccp-bulletSize,18)) / 2 ) * 1px );';
						echo'left: -20px;';
					echo'}';
					
					/* correction positionnement puces pour le thème DIVI */
					if (stristr($my_theme, 'divi')){
						
						echo'body.wp-admin ol.is-style-eccp-ordonned-disk-bullet-list li:before {';
							echo'top: calc( ( (21 - var(--eccp-bulletSize,18)) / 2 ) * 1px);';
						echo'}';
						
						echo'body.wp-admin ol.is-style-eccp-ordonned-disk-bullet-list li {';
							echo'padding-left: 20px;';
						echo'}';
						
					}
					
					/* pour les puces indentés */
					echo'body.wp-admin ol.is-style-eccp-ordonned-disk-bullet-list li::marker {';
						echo'color: transparent;';
					echo'}';
					
					
					
				}//fin si on a activé les styles liste à puces
 
 
				/*-------------------BLOC IMAGE BACK OFFICE --------------------------*/
				
				echo'.wp-block-image {
					margin-top: 1.5em!important;
					margin-bottom: 1.5em!important;
				}';
				
				// surbrillance légende image en orange foncé 
				echo'body.wp-admin .wp-block-image mark{';
				
					echo'background:'.esc_html($custom_gutenberg_blocks_settings['eccp_settings_caption_background_color_text_field']).';';
					echo'padding:'.esc_html($custom_gutenberg_blocks_settings['eccp_settings_caption_padding_text_field']).'px;';
					echo'color:'.esc_html($custom_gutenberg_blocks_settings['eccp_settings_caption_color_text_field']).';';
				
				echo'}';
				
				// Légende de l'image 
				echo'body.wp-admin .wp-block-image figcaption {';
				
					echo'font-size:'.esc_html($custom_gutenberg_blocks_settings['eccp_settings_caption_font_size_text_field']).'px!important;';
					echo'margin-top:1.5em;';
					
				echo'}'; 
				
				/*---------------------------- Style Circle back office------------------------------*/
				// utilise la régle CSS clip-path pour apliquer un masque de détourage
				// Credits: https://github.com/bennettfeely/Clippy
				
				
				if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_image_circle_radio_field'] == 'yes' ) {
					
					// image 4/3
					echo'body.wp-admin .is-style-eccp-image-circle-4-3 img {';
					
						echo'clip-path: circle(42.5% at 50% 50%)!important;';
					
					echo'}';
					
					// image 16/9
					echo'body.wp-admin .is-style-eccp-image-circle-16-9 img {';
					
						echo'clip-path: circle(33.4% at 50% 50%)!important;';
					
					echo'}';
					
				}
				
				/*---------------------------- Style Filter Grayscale back office ------------------------------*/
					
				if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_image_filter_grayscale_radio_field'] == 'yes' ) {
					
					echo'body.wp-admin .is-style-eccp-filter-grayscale img {';
					
						echo'-webkit-filter: grayscale(100%);';
						echo'filter: grayscale(100%);';
					
					echo'}';
					
					echo'body.wp-admin .is-style-eccp-filter-grayscale img:hover {';
					
						echo'-webkit-filter: grayscale(0);';
						echo'filter: grayscale(0);';
					
					echo'}';
					
				}
				
				
				/*----------------------------Style Card Image back office------------------------------*/

				if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_image_card_radio_field'] == 'yes' ) {
					
					// régles pour l'image
					// --eccp-cardStyleImageWidth est une variable css définit
					// en React JS et enregistré dans le HTML du bloc image
					echo'.wp-block[data-align="left"] .wp-block-image.is-style-eccp-card-image img,
						.wp-block[data-align="center"] .wp-block-image.is-style-eccp-card-image img,
						.wp-block[data-align="right"] .wp-block-image.is-style-eccp-card-image img,
						.wp-block-image.is-style-eccp-card-image img{';
						
						//echo'box-shadow: 0 0px 4px 2px rgba(0,0,0,.2);';
						echo'background: #ffffff;';
						echo'width: calc(var(--eccp-cardStyleImageWidth, 300)*1px)!important;';
						
					echo'}';

					// régles pour la légende
					echo'.wp-block[data-align="left"] .wp-block-image.is-style-eccp-card-image figcaption,
						 .wp-block[data-align="center"] .wp-block-image.is-style-eccp-card-image figcaption,
						 .wp-block[data-align="right"] .wp-block-image.is-style-eccp-card-image figcaption{';
						
						echo'margin-top:0em!important;';
						echo'padding:0.5em 0;';
						echo'display:block!important;';
						echo'margin:auto;';
						echo'background: #ffffff;';
						echo'box-shadow: 0 2px 1px -1px rgba(0,0,0,.2), 0 1px 1px 0 rgba(0,0,0,.14), 0 1px 3px 0 rgba(0,0,0,.12);';
						echo'width: calc(var(--eccp-cardStyleImageWidth, 300)*1px)!important;';
					
					echo'}';
					
					// régles pour la légende pour aucun alignement
					echo'.wp-block-image.is-style-eccp-card-image figcaption{';
						
						echo'margin-top:0em!important;';
						echo'padding:0.5em 0;';
						echo'box-shadow: 0 2px 1px -1px rgba(0,0,0,.2), 0 1px 1px 0 rgba(0,0,0,.14), 0 1px 3px 0 rgba(0,0,0,.12);';
						echo'width: calc(var(--eccp-cardStyleImageWidth, 300)*1px)!important;';
					
					echo'}';
					
					// régles pour un alignement left 
					// afin d'éviter une remontée du bloc suivant
					echo'.wp-block[data-align="left"] .wp-block-image.is-style-eccp-card-image{';
			
						echo'margin-right: 1000px;';
						
					echo'}';
					
					// régles pour un alignement right
					// afin d'éviter une remontée du bloc suivant
					echo'.wp-block[data-align="right"] .wp-block-image.is-style-eccp-card-image{';
			
						echo'margin-left: 1000px;';
						
					echo'}';

				}
				
		
				/*----------------------------Style Hover Zoom back office------------------------------*/
								
				// régles responsive pour les PC
				echo'@media(min-width:1100px) {';

					// régles pour une simple image
					// --eccp-customHoverZoom est une variable css définit
					// en React JS et enregistré dans le HTML du bloc image
					echo'.wp-block-image.eccp-hover-zoom:not(.is-style-eccp-card-image) img:hover{';
						
						echo'transform: scaleX(calc( 1 + var(--eccp-customHoverZoom,5)/100 )) scaleY(calc( 1 + var(--eccp-customHoverZoom,5)/100 ));';
						echo'transition: transform 300ms ease 0ms;';
					
					echo'}';
					
					// régles pour une image de style card
					echo'.wp-block-image.eccp-hover-zoom.is-style-eccp-card-image:hover {';
					
						echo'transform: scaleX(calc( 1 + var(--eccp-customHoverZoom,5)/100 )) scaleY(calc( 1 + var(--eccp-customHoverZoom,5)/100 ));';
					
					echo'}';
					
				echo'}';
				
				
				/*------------------- BLOC GALERIE BACK OFFICE --------------------------*/
				
				
				/*----------------------- Galerie Native WordPress style justifié back office ------------------------*/
				
				// suppression des marges du block image
				// de manière a avoir un style justifié
				// c'est a dire un même espacement horizontal & vertical entre les images
				echo'.wp-block-gallery.is-style-eccp-justified .wp-block-image{';
					echo'margin:0!important;';
				echo'}';
				
				// Pour une galerie ajouter a un block groupe
				echo'.wp-block-group .wp-block-gallery.is-style-eccp-justified{';
					echo'margin-top:0;';
					echo'margin-bottom:0;';
				echo'}';
				
				// régle pour une galerie grouper a partir de sa barre d'outils
				// pour l'élément de classe .wp-block ayant un enfant de classe: is-style-eccp-justified
				// on supprime la marge haute afin que lorsque le bloc galerie est grouper 
				// avec un fond de couleur la marge interne haute du bloc groupe corresponde 
				// a l'espacement des blocs images 
				// on ne supprime pas la marge basse car l'inconvénient est que le bloc gallerie 
				// avec le style justifié colle au bloc situé en dessous ce qui n'est pas le cas en Front End		
				echo'.editor-styles-wrapper .wp-block-group .wp-block:has(.is-style-eccp-justified){';
					echo'margin-top: 0;';
					//echo'margin-bottom: 0;';
				echo'}';
				
				
				
				/*---------------------------- style Galerie Border Radius back office ------------------------------*/
	
				// régles pour les images de la galerie
				// --eccp-border-radius-images-gallery est une variable css définit
				// en React JS et enregistré dans le HTML du bloc gallery
				echo'.wp-block-gallery figure.wp-block-image img{';
					
					echo'border-radius: var(--eccp-border-radius-images-gallery,10);';
				
				echo'}';
				
				// la légende a un fond avec un dégradé linéaire de la couleur noire
				// qui dépasse du bord arrondi de l'image
				// donn on applique le rayon de bordure a lapartie basse de la légende
				echo'.wp-block-gallery figure.wp-block-image figcaption{';
					
					echo'border-radius: 0px 0px var(--eccp-border-radius-images-gallery,10) var(--eccp-border-radius-images-gallery,10);';
				
				echo'}';
				
		
				/*---------------------------- style Galerie Hover Zoom back office ------------------------------*/
				
				// régles responsive pour les PC
				echo'@media(min-width:1100px) {';

					// régles pour une image de la gallerie
					// --eccp-customHoverZoom est une variable css définit
					// en React JS et enregistré dans le HTML du bloc image
					echo'.wp-block-gallery figure.wp-block-image:hover{';
						
						echo'transform: scaleX(calc( 1 + var(--eccp-customGalleryHoverZoom,0)/100 )) scaleY(calc( 1 + var(--eccp-customGalleryHoverZoom,0)/100 ));';
						echo'transition: transform 300ms ease 0ms;';
					
					echo'}';
					
					
				echo'}';
				
				
				/*----------------------------Style Card Image Gallery back office ------------------------------*/
				
				if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_image_card_radio_field'] == 'yes' ) {
			
					// régles pour les images de style card faisant partie d'une gallerie 
					// on supprime la largeur personnalisé par défaut de 300px attribué avec 
					// la variable CSS:--eccp-cardStyleImageWidth
					echo'.wp-block-gallery .wp-block-image.is-style-eccp-card-image img,
						 .wp-block[data-align="left"] .wp-block-image.is-style-eccp-card-image img,
						 .wp-block[data-align="center"] .wp-block-image.is-style-eccp-card-image img,
						 .wp-block[data-align="right"] .wp-block-image.is-style-eccp-card-image img{';
						
						echo'width: auto!important;';
						
					echo'}';
					
					
					// régles pour la légende des images d'une gallerie disposant d'un alignement
					echo'wp-block[data-align="left"] .wp-block-gallery .wp-block-image.is-style-eccp-card-image figcaption,
						.wp-block[data-align="center"] .wp-block-gallery .wp-block-image.is-style-eccp-card-image figcaption,
						.wp-block[data-align="right"] .wp-block-gallery .wp-block-image.is-style-eccp-card-image figcaption{';
						
						// on supprime le réglage de largeur du style card du bloc image
						echo'width:auto!important;';
						echo'background: #FFFFFF!important;';
					
					echo'}';
					
					
					// régles pour la légende des images faisant partie d'une gallerie 
					// avec aucun alignement
					echo'.wp-block-gallery figure.is-style-eccp-card-image figcaption{';
						
						// on supprime le réglage de largeur du style card du bloc image
						echo'width:auto!important;';
						echo'background: #FFFFFF!important;';
					
					echo'}';
				
				}
				
				
				/*-------------------BLOC BOUTON BACK OFFICE --------------------------*/
				
				
				echo'.wp-block-button__link{';
				
					echo'font-weight:600;';
					echo'text-decoration:none!important';
					
				echo'}';
				
				
				echo'.wp-block-button__link:hover{';
					echo'text-decoration:none!important';
				echo'}';
	
					
				/*----------------------------Style Plein back office ------------------------------*/
				
				// on fait la conversion en RGBA, la fonction retourne une chaine
				// soit pour une couleur #000000 avec opacité 0.5 ==> rgba(0,0,0,0.5)
				/*$rgba = eccp_hex2rgba( $custom_gutenberg_blocks_settings['eccp_settings_hover_fill_style_background_color_text_field'], 
						intval($custom_gutenberg_blocks_settings['eccp_settings_hover_fill_style_backgound_color_opacity_text_field'])/100 ); */
				
				
				$my_theme = wp_get_theme();
			
				// si ce n'est pas le théme ASTRA 	
				if(!stristr($my_theme, 'astra')) {

				
					echo'.wp-block-button.is-style-fill .wp-block-button__link {';
					  
					  echo'background-color: var(--eccp-bgColor, #0E6487);
					  border-radius: 10px;
					  color: var(--eccp-textColor, #FFFFFF);';
					
					echo'}';
				  
				}else{
					
					echo'.wp-block-button.is-style-fill .wp-block-button__link {';
					  
					  // modification pour thème Astra
					  echo'border: none!important;';
					
					echo'}';
					
				}
				
				/*	A partir de la version 2.6 le style au survol est configuré
					Dans l'editeur Gutenberg
				echo'.wp-block-button.is-style-fill .wp-block-button__link:hover{';
				   
					echo'background: '.esc_html($rgba).'!important;';
					echo'border: 2px solid'.$custom_gutenberg_blocks_settings['eccp_settings_hover_fill_style_border_color_text_field'].';';
					echo'color: '.$custom_gutenberg_blocks_settings['eccp_settings_hover_fill_style_text_color_text_field'].'!important;';
					
				echo'}';
				*/
				
				
				echo'.wp-block-button.is-style-fill .wp-block-button__link:hover{';
				   
					echo'background: var(--eccp-buttonFillBgColorHover, rgba(0,0,0,0))!important;';
					echo'border: 2px solid var(--eccp-buttonFillBorderColorHover, #0E6487)!important;';
					echo'color: var(--eccp-buttonFillColorHover, #0E6487)!important;';
					
				echo'}';
				
		
				/*----------------------------Style Contour back office ------------------------------*/	
				
				// on fait la conversion en RGBA, la fonction retourne une chaine
				// soit pour une couleur #000000 avec opacité 0.5 ==> rgba(0,0,0,0.5)
				/*$rgba = eccp_hex2rgba( $custom_gutenberg_blocks_settings['eccp_settings_hover_outline_style_background_color_text_field'], 
						intval($custom_gutenberg_blocks_settings['eccp_settings_hover_outline_style_backgound_color_opacity_text_field'])/100 );*/
				
				/* A partir de la version 2.6 le style contour du bouton au survol
				   est configuré dans l'editeur Gutenberg
				echo'.wp-block-button.is-style-outline .wp-block-button__link:hover{';
				   
					echo'background: '.esc_html($rgba).'!important;';
					echo'border: 2px solid'.$custom_gutenberg_blocks_settings['eccp_settings_hover_outline_style_border_color_text_field'].';';
					echo'color: '.$custom_gutenberg_blocks_settings['eccp_settings_hover_outline_style_text_color_text_field'].'!important;';
					
				echo'}';
				*/
				
				// si ce n'est pas le théme ASTRA 	
				if(!stristr($my_theme, 'astra')) {
				
					echo'.wp-block-button.is-style-outline .wp-block-button__link {';
					  
					  echo'border-radius: 10px;
					  color: var(--eccp-textColor, #0E6487);';
					
					echo'}';
					
				}else{
					
					echo'.wp-block-button.is-style-outline .wp-block-button__link {';
					  
					  // couleur de bordure pour surcharger la régle du thème Astra
					  echo'border-color: var(--eccp-textColor, #0E6487)!important;';
					
					echo'}';
					
				}
				
				// pour le theme GneratePress
				if(stristr($my_theme, 'generatepress')) {
					
					echo'.wp-block-button.is-style-outline .wp-block-button__link {';
					  echo'border:2px solid var(--eccp-textColor, #0E6487)!important;';
					echo'}';
				
				}
				
				echo'.wp-block-button.is-style-outline .wp-block-button__link:hover{';
				   
					echo'background: var(--eccp-buttonOutlineBgColorHover, #0E6487)!important;';
					echo'border: 2px solid var(--eccp-buttonOutlineBorderColorHover, #0E6487)!important;';
					echo'color: var(--eccp-buttonOutlineColorHover, #FFFFFF)!important;';
				
				echo'}';
				
				
				// Si on a activé les styles des boutons	
				if( $custom_gutenberg_blocks_settings['eccp_settings_activate_button_styles_hover_radio_field'] == 'yes' ) {	
					
					/*-------------------Style Contour avec icône flêche droite au survol back office----------------*/
					
					echo'.wp-block-button.is-style-eccp-outline-hover-arrow .wp-block-button__link {';
					  
					  echo'background-color: #0E6487;
					  border-radius: 6px;
					  padding: 0.5em 1em!important;
					  letter-spacing: 1px;
					  border-color: var(--eccp-bgColor, #0E6487);
					  color: var(--eccp-textColor, #FFFFFF);';
					
					echo'}';
					
					echo'.wp-block-button.is-style-eccp-outline-hover-arrow .wp-block-button__link:hover {';
					
					  echo'background-color: transparent!important;
					  border: 2px solid var(--eccp-bgColor, #0E6487);
					  border-radius: 6px;
					  padding:  0.3em 1em 0.3em 1em!important;
					  letter-spacing: 1px;
					  color: var(--eccp-bgColor, #0E6487)!important;';
					  
					echo'}';

					// icône flêche orienté vers la droite au survol
					echo'.wp-block-button.is-style-eccp-outline-hover-arrow .wp-block-button__link:hover::after {';
					
					  echo'font-family:dashicons;
					  content: "\f345";
					  font-weight:400;
					  color: var(--eccp-bgColor, #0E6487);
					  display:inline-block;
					  vertical-align:middle;
					  font-size:22px;
					  margin-left:7px;
					  transition: all 0.2s;';
					  
					echo'}';


					/*-------------------Style Download back office----------------*/
					
					echo'.wp-block-button.is-style-eccp-download .wp-block-button__link::before {';
					
					  echo'font-family:dashicons;
					  content: "\f310";
					  font-weight:400;
					  font-size:26px;
					  color: var(--eccp-textColor, #FFFFFF);
					  display:inline-block;
					  vertical-align:middle;
					  margin-right:7px;
					  transform: rotate(90deg);';
					echo'}';


					echo'.wp-block-button.is-style-eccp-download .wp-block-button__link {';
						 echo' padding: 0.6em 0.8em;';
						 // modification pour thème Astra
						 echo' border: none!important;';
					echo'}';
					
					// modification pour thème Astra
					echo'.wp-block-button.is-style-eccp-download .wp-block-button__link:hover {';
						 echo' border: none!important;';
					echo'}';
					
				}
				
				
					/*-------- Style Pour l'Icône Dashicon Ajouté au bloc bouton back office --------*/
					
					echo'.editor-styles-wrapper .wp-block-button__link  .eccp-dashicon {';
						echo'display:contents;';
						echo'font-size:inherit;';
					echo'}';
					
					echo'.editor-styles-wrapper p .eccp-dashicon {';
						echo'display:contents;';
						echo'font-size:inherit;';
					echo'}';
					
					// on supprime la marge a droite pour le bloc paragraphe
					// l'icône étant positionné a gauche par la régle css: before
					echo'.editor-styles-wrapper p .eccp-dashicon:before {';
						echo'margin-right:-10px;';
					echo'}';

					/* Icône a gauche */
					echo'.editor-styles-wrapper .eccp-dashicon:before{';
						echo'font-family:"dashicons";';
						echo'margin-right:10px;';
						echo'position:relative;';
						echo'top:0.15em;';
						echo'font-size:inherit;';
						echo'font-weight:500;';
					echo'}';

					/* Icône a droite */
					echo'.editor-styles-wrapper .eccp-dashicon.icon-right:before {';
						echo'float:right;';
						echo'margin-right:0;';
						echo'margin-left:10px;';
						echo'top:0.2em;';
					echo'}';
				
		
				/*-------------------BLOC PARENT COLONNES BACK OFFICE --------------------------*/
				
				if( $custom_gutenberg_blocks_settings['eccp_settings_activate_columns_block_styles_radio_field'] == 'yes' ) {
				
					/* ------------------------------ Régles générales Bloc Parent & bloc colonne back office ---------------*/
			
					// Marge basse pour le bloc parent container des colonnes
					/* Margin réglage natif a partir de WordPress 6.0				
					echo'body.wp-admin .wp-block-columns {';
					  echo'margin-bottom: 1.75em;';
					echo'}';
					*/

					/* marge interne pour chaque colonne*/
					
					// si on n'a pas activé pour l'editeur Gutenberg le nouveau paramètre
					/* de marge interne, on affecte une marge interne par défaut
					if (!$custom_gutenberg_editor_settings['eccp_settings_activate_support_margin_padding_checkbox_field']){
						
						echo'body.wp-admin .wp-block-column{';
							echo'padding:0.6em!important;';
						echo'}';
						
					}
					*/

					/* marge gauche de 20px pour les colonnes
					echo'@media screen and (min-width: 782px) {';
						
						echo'body.wp-admin .wp-block-column:not(:first-child) {';
							echo'margin-left: 20px!important;';
						echo'}';
						
					echo'}';
					*/

					/* marge basse pour les colonnes sur mobile*/
					echo'@media screen and (max-width: 781px) {';
					  
					  echo'body.wp-admin .wp-block-column {';
						echo'margin-bottom: 0.5em!important;';
					  echo'}';
					  
					echo'}';
					

					/*----------------------------Style Responsive three columns back office ------------------------------*/

					 /* pour un block à trois colonnes */
					echo'@media (min-width: 600px) and (max-width: 781px) {';
					  
					  // on inhibe la régle flex-basis: 100% établi par gutenberg pour les colonnes
					  // jusqu'a une résolution de 768px
					  echo'body.wp-admin .wp-block-columns:not(.is-not-stacked-on-mobile)>.wp-block-column {';
						echo'flex-basis: 33%!important;';
					  echo'}';
					  
					  
					  /* la 1ére colonne est mise a une largeur de 100% de son container
						  le bloc colonnes*/
					  echo'body.wp-admin .wp-block-column:first-child {';
						echo'flex-basis: 100%!important;'; 
					  echo'}';
					  
					  /* la direction d'empilement est la ligne (row) et on autorise avec la régle wrap
					     un retour à la ligne si on dépasse le container qui est le bloc colonnes 
						 ce qui est le cas pusique la 1ère colonne est mise a une largeur de 100% du container */
					  echo'body.wp-admin .wp-block-columns {';
						echo'flex-flow: row wrap!important;'; 
					  echo'}';
					  
					  /* marge gauche de 15px seulement pour les colonnes impaires excepté la 1ère colonne */
					  echo'.is-style-eccp-responsive-three-columns .wp-block-column:not(:first-child),
						   .is-style-eccp-responsive-three-columns .wp-block-column:nth-child(odd){';
						   
						echo'margin-left: 10px!important;';
					 
					 echo'}';
					 
					  
					echo'}';

					/*----------------------------Style Column reverse back office ------------------------------*/
					
					echo'@media only screen and (max-width : 599px) {';

						echo'body.wp-admin .is-style-eccp-column-reverse{';
							
							echo'display: -webkit-flex!important;
								 display: -ms-flex!important;
								 display: flex!important;';
							
							echo'-webkit-flex-direction: column-reverse;
								 -ms-flex-direction: column-reverse;
								 flex-direction: column-reverse!important;';
							
						echo'}';

					echo'}';
					
					
					/* ------------------------------ Suite Régles générales Bloc Parent & bloc colonne back office ---------------*/
					
					/* régles pour les colonnes sur mobile en mode portrait 
					echo'@media (max-width: 480px) {';
					   
						echo'body.wp-admin .wp-block-column {';
							echo'display:block;';
							echo'margin-left:0px!important;';
						echo'}';
					  
					echo'}';*/
					
				}	
				
				/*----------------------------Style Variation Pricing Table back office ------------------------------*/
				
				echo'body.wp-admin .is-style-eccp-pricing-table .wp-block-column{';
					   echo'padding: 0em!important;';
				echo'}';


				echo'.is-style-eccp-pricing-table .wp-block-column h3{';
					echo'margin-top: 0em;';
					// mise a jour WordPress 6.1
					echo'padding: 1.2em 1.2em;';
					echo'border-bottom-right-radius: 0px!important;';
					echo'border-bottom-left-radius: 0px!important;';
				echo'}';

				echo'body.wp-admin .is-style-eccp-pricing-table .wp-block-column ul{';
					echo'padding:20px!important;';
					echo'margin:15px 0px 15px 20px!important;';
				echo'}';
								
				// mise a jour WordPress 6.1
				echo'body.wp-admin .is-style-eccp-pricing-table .wp-block-column  .wp-block-button__link{';
					echo'margin-bottom:1.1em;';
				echo'}';
				
			
				/*-------------------BLOC MEDIA/TEXTE BACK OFFICE --------------------------*/
		
				// Si on a activé les styles du bloc media/text
				if( $custom_gutenberg_blocks_settings['eccp_settings_activate_media_text_block_styles_radio_field']== 'yes' ) {
			
			
					/*----------------------------Style Half Background back office  ------------------------------*/
					
					/* pour le containeur du bloc media/text */
					echo'.wp-block-media-text.is-style-eccp-half-background {
	
					  background-color: transparent !important;
					  padding-top: 2rem;
					  padding-bottom: 1rem;
					  column-gap: 1rem;';/* espacement des colonnes */
					  
					echo'}';


					/* pas de marge interne pour le bloc texte, et on met l'image au 1er plan par rapport au fond */
					echo'.wp-block-media-text.is-style-eccp-half-background .wp-block-media-text__media,
					.wp-block-media-text.is-style-eccp-half-background .wp-block-media-text__content {
					  position: relative;
					  z-index: 2;
					  padding: 0;
					}';
					
					
					// pour les tablettes & PC
					echo'@media (min-width: 768px) {';
									  

						/* régles pour l'image à droite */
						echo'.wp-block-media-text.is-style-eccp-half-background.has-media-on-the-right {';
							/* On utilise une unité flexible a l'intérieur du containeur en grille
							L'unité fr représente une fraction de l'espace restant dans le conteneur en grille 
							3fr pour la colonne texte, 4fr pour la colonne image */
							echo'grid-template-columns: 3fr 4fr;';
						
						echo'}';
					  
					  
						/* régles pour le fond de l'image a droite */
						  // on applique le style box shadow avec les variables
						  // css déclarées et affectées par le script en React JS
						echo'body.wp-admin .wp-block-media-text.is-style-eccp-half-background.eccp-box-shadow.has-media-on-the-right .wp-block-media-text__media img {';

							echo'box-shadow: calc(var(--eccp-horizontalBoxShadow, 20)* 1px) '.
											 'calc(var(--eccp-verticalBoxShadow, 20)* 1px) '.
											 'calc(var(--eccp-blurBoxShadow, 0)* 1px) '.
											 'calc(var(--eccp-spreadBoxShadow, 0)* 1px) '.
											 'var(--eccp-colorBoxShadow,#0E6487);';

						echo'}';
					  
					  
					  
						/* régles pour l'image a gauche */
						echo'.wp-block-media-text.is-style-eccp-half-background {
							grid-template-columns: 4fr 3fr;
						}';
					  
					  
						/* régles pour  le fond de l'image a gauche */
						// on décale le fond a gauche par une valeur négative de X
						// on applique le style box shadow avec les variables
						// css déclarées et affectées par le script en React JS
						echo'body.wp-admin .wp-block-media-text.is-style-eccp-half-background.eccp-box-shadow .wp-block-media-text__media img {';

							echo'box-shadow: calc(var(--eccp-horizontalBoxShadow, 20) * -1px) '.
											 'calc(var(--eccp-verticalBoxShadow, 20)* 1px) '.
											 'calc(var(--eccp-blurBoxShadow, 0)* 1px) '.
											 'calc(var(--eccp-spreadBoxShadow, 0)* 1px) '.
											 'var(--eccp-colorBoxShadow,#0E6487);';

						echo'}';
						 
					  
					echo'}';
					
					/* régles pour mobile: 
					   pour une résolution <= 600 px on a  déja une disposition en colonne
					   mais on force quand même la disposition en colonne lorsque la
					   résolution sera supérieure à 600px*/
					echo'@media (max-width: 767px) {';
					
						/* on force la disposition en colonne */
						echo'.wp-block-media-text.is-style-eccp-half-background{ 
							 display:block!important;
							 margin:auto;
						}';
						
						/* régle pour le bloc colonne image qui est toujours au dessus 
						   de la colonne texte quelque soit la position de l'image sur PC */
						echo'.wp-block-media-text .wp-block-media-text__media{
							  margin-bottom:2rem!important;
						}';
					  
					echo'}';
					
					
					// Pour Le Bloc Média Texte avec le style Half Background
					// on limite X & Y à 15px sur mobile
					// on applique le reste du style box shadow avec les variables
					// css déclarées et affectées par le script en React JS
					echo'@media (max-width:480px) {';
												
						/* régles pour  le fond de l'image a droite*/ 
						   // on limite le décalage a 15px
						echo'body.wp-admin .wp-block-media-text.is-style-eccp-half-background.eccp-box-shadow.has-media-on-the-right .wp-block-media-text__media img {';
					
							echo'box-shadow: 15px '.
											 '15px '.
											 'calc(var(--eccp-blurBoxShadow, 0)* 1px) '.
											 'calc(var(--eccp-spreadBoxShadow,0)* 1px) '.
											 'var(--eccp-colorBoxShadow, #0E6487);';
						 
						echo'}';
							
						// on met une marge interne a droite pour le container de l'image 
						// lorsque l'image est a droite
						echo'body.wp-admin .wp-block-media-text.is-style-eccp-half-background.eccp-box-shadow.has-media-on-the-right .wp-block-media-text__media  {';
						
							echo'padding-right: 10px;';
							
						echo'}';
							
							
						/* régles pour  le fond de l'image a gauche */
						// on décale le fond a gauche par une valeur négative de X
						// on limite le décalage a 15px
						echo'body.wp-admin .wp-block-media-text.is-style-eccp-half-background.eccp-box-shadow .wp-block-media-text__media img {';

							echo'box-shadow: -15px '.
											 '15px '.
											 'calc(var(--eccp-blurBoxShadow, 0)* 1px) '.
											 'calc(var(--eccp-spreadBoxShadow, 0)* 1px) '.
											 'var(--eccp-colorBoxShadow,#0E6487);';

						echo'}';
						
						
						// on met une marge interne à gauche pour le container de l'image 
						// lorsque l'image est a gauche
						echo'body.wp-admin .wp-block-media-text.is-style-eccp-half-background.eccp-box-shadow .wp-block-media-text__media  {';
						
							echo'padding-left: 10px;';
							
						echo'}';
							
							
					echo'}';
					
				
				}// Fin si on a activé les styles du bloc media/text
				
				
				/*------------------- BLOC SEPARATOR BACK OFFICE --------------------------*/
		
				/*---------------------------- Largeur Bloc Separator back office ------------------------------*/
						
				echo'[data-type="core/separator"].is-style-eccp-size-very-small{';
													
					echo'width: 50%!important;';
			
				echo'}';
				
				echo'[data-type="core/separator"].is-style-eccp-size-small{';
													
					echo'width: 60%!important;';
			
				echo'}';
				
				echo'[data-type="core/separator"].is-style-eccp-size-regular{';
							
					echo'width: 70%!important;';
			
				echo'}';
				
				echo'[data-type="core/separator"].is-style-eccp-size-large{';
										
					echo'width: 80%!important;';
			
				echo'}';
				
				echo'[data-type="core/separator"].is-style-eccp-size-larger{';
								
					echo'width: 90%!important;';
			
				echo'}';
				
					
				/*------------------- BLOC TABLEAU BACK OFFICE --------------------------*/
		
				/*-------------------- style ECCP Stripes back office ----------------------*/
					
				//------------- EN-TÊTE---------------------------
				
				/* couleur arrière plan en-tête */
				echo'.wp-block-table.is-style-eccp-stripes thead {';
					echo'background:var(--eccp-tableHeaderBgColor,#2B5DF2);';
					echo'border-bottom:none;';
				echo'}';

				/* Style cellule en-tête */
				echo'.wp-block-table.is-style-eccp-stripes thead tr th {';
					echo'border: 1px solid  #FFFFFF;';
					echo'font-weight:bold;';
					echo'color:var(--eccp-tableHeaderColor,#FFFFFF);';
				echo'}';

				/* Style 1ère cellule en-tête */
				echo'.wp-block-table.is-style-eccp-stripes thead tr th:first-child {';
					echo'border-radius: 10px 0px 0px 0px;';
				echo'}';

				/* Style dernière cellule en-tête */
				echo'.wp-block-table.is-style-eccp-stripes thead tr th:last-child {';
					echo'border-radius: 0px 10px 0px 0px;';
				echo'}';
				
				//------------- CORPS DE LA TABLE ---------------------------
				
				/* style des cellules de la table */
				echo'.wp-block-table.is-style-eccp-stripes tbody tr td {';
					echo'vertical-align:middle;';
					echo'padding: 8px;';
					echo'border: 1px solid;';
					echo'border-color: #EAF1F8;';
					echo'line-height:1.4em;';
				echo'}';

				/* couleur  d'arrière plan et du texte des lignes paires parentes de tbody  
			       afin d'éviter de changer la couleur d'arrière plan & du texte 
				   de la ligne d'en-tête */
				echo'.wp-block-table.is-style-eccp-stripes tbody > tr:nth-child(2n){';
					echo'background-color:var(--eccp-tableRowOddBgColor,#EFF8FE);';
					echo'color:var(--eccp-tableRowOddColor);';
				echo'}';	
				
				
				/*------------------- BLOC TITRE BACK OFFICE --------------------------*/
		
				echo'h2::before,h3::before,h4::before,h5::before{';
					echo'font-family:dashicons;';
					echo'position: relative;';
					echo'top: 0.15em;';
					echo'margin-right:0.5em;';
					echo'font-size:inherit;';
				echo'}';
			
			
				/*--------------------- Style Admin Menu back office ---------------------------*/
				
				//------------- Home---------------------------
				echo'.is-style-eccp-icon-heading-home::before {';
					echo'content: "\f102";';
					echo'font-weight:600;';
				echo'}';
				
				//------------- Site---------------------------
				echo'.is-style-eccp-icon-heading-site::before {';
					echo'content: "\f11f";';
					echo'font-weight:400;';
				echo'}';
				
				//------------- Post ---------------------------
				echo'.is-style-eccp-icon-heading-post::before {';
					echo'content: "\f109";';
					echo'font-weight:600;';
				echo'}';
				
				//------------- Links---------------------------
				echo'.is-style-eccp-icon-heading-links::before {';
					echo'content: "\f103";';
					echo'font-weight:600;';
				echo'}';
				
				//------------- Users---------------------------
				echo'.is-style-eccp-icon-heading-users::before {';
					echo'content: "\f110";';
					echo'font-weight:600;';
				echo'}';
				
				//------------- Tools---------------------------
				echo'.is-style-eccp-icon-heading-tools::before {';
					echo'content: "\f107";';
					echo'font-weight:600;';
				echo'}';

					
				/*--------------------- Style Post Formats back office ---------------------------*/
			
				//------------- Audio ---------------------------
				echo'.is-style-eccp-icon-heading-audio::before {';
					echo'content: "\f127";';
					echo'font-weight:600;';
				echo'}';
				
				//------------- Camera ---------------------------
				echo'.is-style-eccp-icon-heading-camera::before {';
					echo'content: "\f129";';
					echo'font-weight:600;';
				echo'}';
				
				//------------- Video ---------------------------
				echo'.is-style-eccp-icon-heading-video::before {';
					echo'content: "\f235";';
					echo'font-weight:600;';
				echo'}';
				
				
				/*--------------------- Style Block Editor back office ---------------------------*/
			
				//------------- Info Outline ---------------------------
				echo'.is-style-eccp-icon-heading-info-outline::before {';
					echo'content: "\f14c";';
					echo'font-weight:600;';
				echo'}';
				
				
			
				/*--------------------- Style TinyMCE back office ---------------------------*/
			
				//------------- Site---------------------------
				echo'.is-style-eccp-icon-heading-list::before {';
					echo'content: "\f203";';
					echo'font-weight:400;';
				echo'}';
				
				//------------- Quote ---------------------------
				echo'.is-style-eccp-icon-heading-quote::before {';
					echo'content: "\f205";';
					echo'font-weight:400;';
				echo'}';
				
				//------------- Film ---------------------------
				echo'.is-style-eccp-icon-heading-film::before {';
					echo'content: "\f219";';
					echo'font-weight:400;';
				echo'}';
				
				//------------- Help ---------------------------
				echo'.is-style-eccp-icon-heading-help::before {';
					echo'content: "\f223";';
					echo'font-weight:400;';
				echo'}';
				
				//------------- Code ---------------------------
				echo'.is-style-eccp-icon-heading-code::before {';
					echo'content: "\f475";';
					echo'font-weight:600;';
				echo'}';
				
				//------------- Table ---------------------------
				echo'.is-style-eccp-icon-heading-table::before {';
					echo'content: "\f535";';
					echo'font-weight:400;';
				echo'}';
				
				
				//------------- Hashtag ---------------------------
			
				echo'body.wp-admin .is-style-eccp-icon-heading-hashtag::before{';
					
				// la taille initiale du SVG est donné par width & height
				// pour le background-size
				// lorsqu'on affiche une icone avec la régle pseudo :before
				// il faut appliquer la régle content: "" pour que cela fonctionne
				// on applique une couleur de fond au svg avec la variable CSS
				// --eccp-textColor définit par la sélection de couleur pour le titre
				// dans les paramètres du bloc, sinon on applique une couleur par défaut #333333
				echo' background-size: cover!important;
					  display: inline-block; 
					  position: relative; 
					  top:0;
					  mask-repeat: no-repeat;	                 
					  -webkit-mask-repeat: no-repeat;
					  content: "";
					  background-color: var(--eccp-textColor,#333333);';
			
				echo'}';
				
				
				// taille icone pour un titre h2
				echo'body.wp-admin h2.is-style-eccp-icon-heading-hashtag::before{';
					echo'height:30px;';
					echo'width:30px;';
				echo'}';
				
				// taille icone pour un titre h3
				echo'body.wp-admin h3.is-style-eccp-icon-heading-hashtag::before{';
					echo'height:20px;';
					echo'width:20px;';
				echo'}';
				
				// taille icone pour un titre h4
				echo'body.wp-admin h4.is-style-eccp-icon-heading-hashtag::before{';
					echo'height:17px;';
					echo'width:17px;';
				echo'}';
				
				// taille icone pour un titre h5
				echo'body.wp-admin h5.is-style-eccp-icon-heading-hashtag::before{';
					echo'height:14px;';
					echo'width:14px;';
				echo'}';
				
				echo'body.wp-admin .is-style-eccp-icon-heading-hashtag::before{';
					
					// la régle mask-image permettra d'appliquer une couleur au SVG
					echo'-webkit-mask-image:url("data:image/svg+xml;charset=utf8,%3C?xml version=\'1.0\' encoding=\'utf-8\'?%3E%3Csvg version=\'1.1\' id=\'Layer_1\' xmlns=\'http://www.w3.org/2000/svg\' xmlns:xlink=\'http://www.w3.org/1999/xlink\' x=\'0px\' y=\'0px\' viewBox=\'0 0 103.41 122.88\' style=\'enable-background:new 0 0 103.41 122.88\' xml:space=\'preserve\'%3E%3Cg%3E%3Cpath d=\'M23.12,51.51L18.3,74.86H0v18.31h14.87L8.7,122.88H27.5l6.08-29.71h23.48l-5.91,29.71h18.98l5.99-29.71h27.28V74.86H79.76 l5.3-26.34h18.35V30.23H88.79L94.7,0H75.79l-6.08,30.23H46.15L52.32,0H33.36l-5.99,30.23H0v18.29h23.74L23.12,51.51L23.12,51.51z M58.74,74.86H37.17l5.55-26.34h23.46l-5.4,26.34H58.74L58.74,74.86z\'/%3E%3C/g%3E%3C/svg%3E");';
					echo'mask-image:url("data:image/svg+xml;charset=utf8,%3C?xml version=\'1.0\' encoding=\'utf-8\'?%3E%3Csvg version=\'1.1\' id=\'Layer_1\' xmlns=\'http://www.w3.org/2000/svg\' xmlns:xlink=\'http://www.w3.org/1999/xlink\' x=\'0px\' y=\'0px\' viewBox=\'0 0 103.41 122.88\' style=\'enable-background:new 0 0 103.41 122.88\' xml:space=\'preserve\'%3E%3Cg%3E%3Cpath d=\'M23.12,51.51L18.3,74.86H0v18.31h14.87L8.7,122.88H27.5l6.08-29.71h23.48l-5.91,29.71h18.98l5.99-29.71h27.28V74.86H79.76 l5.3-26.34h18.35V30.23H88.79L94.7,0H75.79l-6.08,30.23H46.15L52.32,0H33.36l-5.99,30.23H0v18.29h23.74L23.12,51.51L23.12,51.51z M58.74,74.86H37.17l5.55-26.34h23.46l-5.4,26.34H58.74L58.74,74.86z\'/%3E%3C/g%3E%3C/svg%3E");';
				
				echo'}';
				
			
				/*--------------------- Style Posts Screen back office ---------------------------*/
			
				//------------- Calendar---------------------------
				echo'.is-style-eccp-icon-heading-calendar::before {';
					echo'content: "\f508";';
					echo'font-weight:400;';
				echo'}';
				
				//------------- Edit---------------------------
				echo'.is-style-eccp-icon-heading-edit::before {';
					echo'content: "\f464";';
					echo'font-weight:400;';
				echo'}';
				
				//------------- Trash---------------------------
				echo'.is-style-eccp-icon-heading-trash::before {';
					echo'content: "\f182";';
					echo'font-weight:400;';
					echo'top:0.1em;';
				echo'}';
			
			
			    /*--------------------- Style Sorting back office ---------------------------*/
			
				//------------- List View ---------------------------
				echo'.is-style-eccp-icon-heading-list-view::before {';
					echo'content: "\f163";';
					echo'font-weight:600;';
				echo'}';
				
				
				//------------- List View Alt(Icone Font Awesome) ---------------------------
				
				echo'.is-style-eccp-icon-heading-list-view-alt::before{';
						
					// la taille initiale du SVG est donné par width & height
					// pour le background-size
					// lorsqu'on affiche une icone avec la régle pseudo :before
					// il faut appliquer la régle content: "" pour que cela fonctionne
					// on applique une couleur de fond au svg avec la variable CSS
					// --eccp-textColor définit par la sélection de couleur pour le titre
					// dans les paramètres du bloc, sinon on applique une couleur par défaut #333333
					echo' background-size: cover!important;
						  display: inline-block; 
						  position: relative; 
						  top:0.1em;					  
						  mask-repeat: no-repeat;	                 
						  -webkit-mask-repeat: no-repeat;
						  content: "";
						  background-color: var(--eccp-textColor,#333333);';
				
				echo'}';
				
				// taille icone pour un titre h2
				echo'h2.is-style-eccp-icon-heading-list-view-alt::before{';
					echo'height:30px;';
					echo'width:30px;';
				echo'}';
				
				// taille icone pour un titre h2 sur mobile
				echo '@media (max-width:767px){';
				
					echo'h2.is-style-eccp-icon-heading-list-view-alt::before{';
					echo'height:24px;';
					echo'width:24px;';
					echo'}';
					
				echo'}';
					
				// taille icone pour un titre h3
				echo'h3.is-style-eccp-icon-heading-list-view-alt::before{';
					echo'height:24px;';
					echo'width:24px;';
				echo'}';
				
				// taille icone pour un titre h4
				echo'h4.is-style-eccp-icon-heading-list-view-alt::before{';
					echo'height:20px;';
					echo'width:20px;';
				echo'}';
				
				// taille icone pour un titre h5
				echo'h5.is-style-eccp-icon-heading-list-view-alt::before{';
					echo'height:17px;';
					echo'width:17px;';
				echo'}';
				
				echo'.is-style-eccp-icon-heading-list-view-alt::before{';
					
					// Icone Font Awesome Regular List
					// https://commons.wikimedia.org/wiki/File:Font_Awesome_5_regular_list-alt.svg
					// la régle mask-image permettra d'appliquer une couleur au SVG
					echo'-webkit-mask-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 512 512\'%3E%3Cpath d=\'M464 32H48C21.49 32 0 53.49 0 80v352c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48V80c0-26.51-21.49-48-48-48zm-6 400H54a6 6 0 0 1-6-6V86a6 6 0 0 1 6-6h404a6 6 0 0 1 6 6v340a6 6 0 0 1-6 6zm-42-92v24c0 6.627-5.373 12-12 12H204c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h200c6.627 0 12 5.373 12 12zm0-96v24c0 6.627-5.373 12-12 12H204c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h200c6.627 0 12 5.373 12 12zm0-96v24c0 6.627-5.373 12-12 12H204c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h200c6.627 0 12 5.373 12 12zm-252 12c0 19.882-16.118 36-36 36s-36-16.118-36-36 16.118-36 36-36 36 16.118 36 36zm0 96c0 19.882-16.118 36-36 36s-36-16.118-36-36 16.118-36 36-36 36 16.118 36 36zm0 96c0 19.882-16.118 36-36 36s-36-16.118-36-36 16.118-36 36-36 36 16.118 36 36z\'/%3E%3C/svg%3E%3C!-- Font Awesome Free 5.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) --%3E");';
					echo'mask-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 512 512\'%3E%3Cpath d=\'M464 32H48C21.49 32 0 53.49 0 80v352c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48V80c0-26.51-21.49-48-48-48zm-6 400H54a6 6 0 0 1-6-6V86a6 6 0 0 1 6-6h404a6 6 0 0 1 6 6v340a6 6 0 0 1-6 6zm-42-92v24c0 6.627-5.373 12-12 12H204c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h200c6.627 0 12 5.373 12 12zm0-96v24c0 6.627-5.373 12-12 12H204c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h200c6.627 0 12 5.373 12 12zm0-96v24c0 6.627-5.373 12-12 12H204c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h200c6.627 0 12 5.373 12 12zm-252 12c0 19.882-16.118 36-36 36s-36-16.118-36-36 16.118-36 36-36 36 16.118 36 36zm0 96c0 19.882-16.118 36-36 36s-36-16.118-36-36 16.118-36 36-36 36 16.118 36 36zm0 96c0 19.882-16.118 36-36 36s-36-16.118-36-36 16.118-36 36-36 36 16.118 36 36z\'/%3E%3C/svg%3E%3C!-- Font Awesome Free 5.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) --%3E");';
					
				echo'}';
				
			
				/*--------------------- Style Social back office ---------------------------*/
			
				//------------- Facebook ---------------------------
				echo'.is-style-eccp-icon-heading-facebook::before {';
					echo'content: "\f305";';
					echo'font-weight:600;';
				echo'}';
				
				//------------- Instagram ---------------------------
				echo'.is-style-eccp-icon-heading-instagram::before {';
					echo'content: "\f12d";';
					echo'font-weight:600;';
				echo'}';
				
				//------------- LinkedIn ---------------------------
				echo'.is-style-eccp-icon-heading-linkedin::before {';
					echo'content: "\f18d";';
					echo'font-weight:600;';
					echo'top: 0.1em;';
				echo'}';
				
				//------------- Pinterest ---------------------------
				echo'.is-style-eccp-icon-heading-pinterest::before {';
					echo'content: "\f192";';
					echo'font-weight:600;';
				echo'}';
				
				//------------- Twiter ---------------------------
				echo'.is-style-eccp-icon-heading-twiter::before {';
					echo'content: "\f301";';
					echo'font-weight:600;';
				echo'}';
				
				//------------- YouTube ---------------------------
				echo'.is-style-eccp-icon-heading-youtube::before {';
					echo'content: "\f19b";';
					echo'font-weight:600;';
				echo'}';
			
			
				/*--------------------- Style WordPress back office ---------------------------*/
			
				//------------- Heart ---------------------------
				echo'.is-style-eccp-icon-heading-heart::before {';
					echo'content: "\f487";';
					echo'font-weight:600;';
				echo'}';
				
				
				/*--------------------- Style Buddicons back office ---------------------------*/
			
				//------------- Community ---------------------------
				echo'.is-style-eccp-icon-heading-community::before {';
					echo'content: "\f453";';
					echo'font-weight:400;';
				echo'}';
			
			
				/*--------------------- Style Products back office ---------------------------*/
			
				//------------- Info  ---------------------------
				echo'.is-style-eccp-icon-heading-info::before {';
					echo'content: "\f348";';
					echo'font-weight:400;';
				echo'}';
				
				//------------- Info Circle( icone Font Awesome) ---------------------------
				
				echo'.is-style-eccp-icon-heading-info-circle::before{';
						
					// la taille initiale du SVG est donné par width & height
					// pour le background-size
					// lorsqu'on affiche une icone avec la régle pseudo :before
					// il faut appliquer la régle content: "" pour que cela fonctionne
					// on applique une couleur de fond au svg avec la variable CSS
					// --eccp-textColor définit par la sélection de couleur pour le titre
					// dans les paramètres du bloc, sinon on applique une couleur par défaut #333333
					echo' background-size: cover!important;
						  display: inline-block; 
						  position: relative; 
						  top:0.1em;					  
						  mask-repeat: no-repeat;	                 
						  -webkit-mask-repeat: no-repeat;
						  content: "";
						  background-color: var(--eccp-textColor,#333333);';
				
				echo'}';
				
				// taille icone pour un titre h2
				echo'h2.is-style-eccp-icon-heading-info-circle::before{';
					echo'height:30px;';
					echo'width:30px;';
				echo'}';
				
				// taille icone pour un titre h2 sur mobile
				echo '@media (max-width:767px){';
				
					echo'h2.is-style-eccp-icon-heading-info-circle::before{';
					echo'height:24px;';
					echo'width:24px;';
					echo'}';
					
				echo'}';
					
				// taille icone pour un titre h3
				echo'h3.is-style-eccp-icon-heading-info-circle::before{';
					echo'height:24px;';
					echo'width:24px;';
				echo'}';
				
				// taille icone pour un titre h4
				echo'h4.is-style-eccp-icon-heading-info-circle::before{';
					echo'height:20px;';
					echo'width:20px;';
				echo'}';
				
				// taille icone pour un titre h5
				echo'h5.is-style-eccp-icon-heading-info-circle::before{';
					echo'height:17px;';
					echo'width:17px;';
				echo'}';
				
				echo'.is-style-eccp-icon-heading-info-circle::before{';
					
					// Icone Font Awesome 5 Solid
					// https://commons.wikimedia.org/wiki/File:Font_Awesome_5_solid_info-circle.svg
					// la régle mask-image permettra d'appliquer une couleur au SVG
					echo'-webkit-mask-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 512 512\'%3E%3Cpath d=\'M256 8C119.043 8 8 119.083 8 256c0 136.997 111.043 248 248 248s248-111.003 248-248C504 119.083 392.957 8 256 8zm0 110c23.196 0 42 18.804 42 42s-18.804 42-42 42-42-18.804-42-42 18.804-42 42-42zm56 254c0 6.627-5.373 12-12 12h-88c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h12v-64h-12c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h64c6.627 0 12 5.373 12 12v100h12c6.627 0 12 5.373 12 12v24z\'/%3E%3C/svg%3E%3C!-- Font Awesome Free 5.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) --%3E");';
					echo'mask-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 512 512\'%3E%3Cpath d=\'M256 8C119.043 8 8 119.083 8 256c0 136.997 111.043 248 248 248s248-111.003 248-248C504 119.083 392.957 8 256 8zm0 110c23.196 0 42 18.804 42 42s-18.804 42-42 42-42-18.804-42-42 18.804-42 42-42zm56 254c0 6.627-5.373 12-12 12h-88c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h12v-64h-12c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h64c6.627 0 12 5.373 12 12v100h12c6.627 0 12 5.373 12 12v24z\'/%3E%3C/svg%3E%3C!-- Font Awesome Free 5.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) --%3E");';
					
				echo'}';
			
				//------------- Cart ---------------------------
				echo'.is-style-eccp-icon-heading-cart::before {';
					echo'content: "\f174";';
					echo'font-weight:400;';
				echo'}';
				
				//------------- WordPress ---------------------------
				echo'.is-style-eccp-icon-heading-wordpress::before {';
					echo'content: "\f120";';
					echo'font-weight:400;';
				echo'}';
			
			
				/*--------------------- Style Widgets back office ---------------------------*/
			
				//------------- Archive ---------------------------
				echo'.is-style-eccp-icon-heading-archive::before {';
					echo'content: "\f480";';
					echo'font-weight:400;';
				echo'}';
				
				
				/*--------------------- Style Notifications back office ---------------------------*/
			
				//------------- Bell ---------------------------
				echo'.is-style-eccp-icon-heading-bell::before {';
					echo'content: "\f16d";';
					echo'font-weight:600;';
				echo'}';
				
				//------------- Star Filled ---------------------------
				echo'.is-style-eccp-icon-heading-star-filled::before {';
					echo'content: "\f155";';
					echo'font-weight:600;';
				echo'}';
				
				//------------- warning ---------------------------
				echo'.is-style-eccp-icon-heading-warning::before {';
					echo'content: "\f534";';
					echo'font-weight:400;';
				echo'}';
				
				
			
				/*--------------------- Style Miscellaneous back office ---------------------------*/
			
				//------------- Book ---------------------------
				echo'.is-style-eccp-icon-heading-book::before {';
					echo'content: "\f330";';
					echo'font-weight:600;';
				echo'}';
				
				//------------- Products ---------------------------
				echo'.is-style-eccp-icon-heading-products::before {';
					echo'content: "\f312";';
					echo'font-weight:400;';
				echo'}';
				
				//------------- Awards ---------------------------
				echo'.is-style-eccp-icon-heading-awards::before {';
					echo'content: "\f313";';
					echo'font-weight:400;';
				echo'}';
				
				//------------- Testimonial ---------------------------
				echo'.is-style-eccp-icon-heading-testimonial::before {';
					echo'content: "\f473";';
					echo'font-weight:400;';
				echo'}';
				
				//------------- Download ---------------------------
				echo'.is-style-eccp-icon-heading-download::before {';
					echo'content: "\f316";';
					echo'font-weight:600;';
				echo'}';
				
				//------------- Carrot ---------------------------
				echo'.is-style-eccp-icon-heading-carrot::before {';
					echo'content: "\f511";';
					echo'font-weight:400;';
				echo'}';
				
				//------------- Beer ---------------------------
				echo'.is-style-eccp-icon-heading-beer::before {';
					echo'content: "\f16c";';
					echo'font-weight:400;';
				echo'}';
				
				//------------- Chart Bar ---------------------------
				echo'.is-style-eccp-icon-heading-chartbar::before {';
					echo'content: "\f185";';
					echo'font-weight:600;';
				echo'}';
				
				//------------- Clock ---------------------------
				echo'.is-style-eccp-icon-heading-clock::before {';
					echo'content: "\f469";';
					echo'font-weight:600;';
				echo'}';
				
				//------------- Coffee ---------------------------
				echo'.is-style-eccp-icon-heading-coffee::before {';
					echo'content: "\f16f";';
					echo'font-weight:400;';
				echo'}';
				
				//------------- Food ---------------------------
				echo'.is-style-eccp-icon-heading-food::before {';
					echo'content: "\f187";';
					echo'font-weight:400;';
				echo'}';
				//------------- Hourglass ---------------------------
				echo'.is-style-eccp-icon-heading-hourglass::before {';
					echo'content: "\f18c";';
					echo'font-weight:400;';
				echo'}';
				
				//------------- Location ---------------------------
				echo'.is-style-eccp-icon-heading-location::before {';
					echo'content: "\f230";';
					echo'font-weight:600;';
				echo'}';
				
				//------------- PDF ---------------------------
				echo'.is-style-eccp-icon-heading-pdf::before {';
					echo'content: "\f190";';
					echo'font-weight:400;';
				echo'}';


				/*---------------- BLOC DERNIERS ARTICLES BACK OFFICE -------------------*/
				
				// Si on a activé le style card pour le bloc Derniers Articles
				if( $custom_gutenberg_blocks_settings['eccp_settings_activate_card_style_latest_posts_block_radio_field'] == 'yes' ) {
					
					/*-------- Style Card Derniers Articles en mode grille back office -----------*/
				
					/* article en mode grille */
					echo'ul.wp-block-latest-posts__list.is-grid li{';
						echo'box-shadow: 0 2px 4px 2px rgb(0 0 0 / 10%);';
						echo'padding-bottom: 1.2em;';
					echo'}';

					/* Lien image */
					echo'ul.wp-block-latest-posts__list.is-grid li div.wp-block-latest-posts__featured-image a{';
						echo'padding:0;';
						echo'display: block;';
					echo'}';

					/* Image article */
					echo'ul.wp-block-latest-posts__list.is-grid li img{';
						echo'margin-bottom:1.2em;';
						echo'width:100%;';
					echo'}';

					/* Image article au survol */
					echo'ul.wp-block-latest-posts__list.is-grid li img:hover{';
						echo'background-color: #000000;';
						echo'opacity: 0.6;';
					echo'}';

					/* Auteur & Date */
					echo'ul.wp-block-latest-posts__list.is-grid li  div.wp-block-latest-posts__post-author,
						 ul.wp-block-latest-posts__list.is-grid li time.wp-block-latest-posts__post-date{';
						echo'display:block;';
						echo'padding:0 1.5em 0 1.5em;';
					echo'}';

					/* titre & extrait */
					echo'ul.wp-block-latest-posts__list.is-grid li a,
						 ul.wp-block-latest-posts__list.is-grid li div.wp-block-latest-posts__post-excerpt{';
						echo'display:block;';
						echo'padding:0 1.2em 0 1.2em;';
					echo'}';

					/* Titre de l'article */
					echo'ul.wp-block-latest-posts__list.is-grid li a{';
						echo'font-weight:bold;';
						echo'text-decoration:none!important;';
					echo'}';
					
					// si on a activé les styles du bloc lire la suite
					// on applique le même style a la balise read more du bloc Derniers Articles
					if( $custom_gutenberg_blocks_settings['eccp_settings_activate_block_styles_read_more_radio_field'] == 'yes' ) {
					
						// on fait la conversion en RGBA pourla couleur de fond du bloc Lire La Suite, 
						// la fonction retourne une chaine
						// soit pour une couleur #000000 avec opacité 0.5 ==> rgba(0,0,0,0.5)
						$rgba = eccp_hex2rgba( $custom_gutenberg_blocks_settings['eccp_settings_block_read_more_background_color_text_field'], 
								intval($custom_gutenberg_blocks_settings['eccp_settings_block_read_more_backgound_color_opacity_text_field'])/100 );
							
					
						/*  pour la balise read more du bloc Derniers Articles */
						echo'ul.wp-block-latest-posts__list.is-grid div.wp-block-latest-posts__post-excerpt a{';					
						
							echo'background: '.esc_html($rgba).'!important;';							
							echo'border: 2px solid '.esc_html($custom_gutenberg_blocks_settings['eccp_settings_block_read_more_border_color_text_field']).';';
							echo'color: '.esc_html($custom_gutenberg_blocks_settings['eccp_settings_block_read_more_text_color_text_field']).';';
							echo'padding: 0.5em 1em!important;';
							echo'font-size: 18px;';
							echo'font-weight:600;';
							echo'line-height: 1.3333333;';
							echo'border-radius: 6px;';
							
							echo'display:block;';
							echo'margin:auto;';
							echo'width:150px;';
							echo'margin-top:15px;';
							echo'text-align:center;';
							
						echo'}';
						
						// on supprime la marges introduites avec la personnalisation 
						// du bloc liste
						echo'ul.wp-block-latest-posts__list.is-grid {';					
							echo'margin-left:0;';
						echo'}';
						
						// sur mobile on supprime le gap qui sépare les listes
						// dans la grille
						echo'@media (max-width:480px) {';
							echo'ul.wp-block-latest-posts.is-grid li {';	
								echo'margin-right:0;';
							echo'}';
						echo'}';
						
						// on fait la conversion en RGBA pour la couleur de fond au survol du bloc Lire La Suite, 
						// la fonction retourne une chaine
						// soit pour une couleur #000000 avec opacité 0.5 ==> rgba(0,0,0,0.5)
						$rgba = eccp_hex2rgba( $custom_gutenberg_blocks_settings['eccp_settings_block_read_more_hover_background_color_text_field'], 
								intval($custom_gutenberg_blocks_settings['eccp_settings_block_read_more_hover_backgound_color_opacity_text_field'])/100 );
							
						// régles au survol pour la balise read more
						echo'ul.wp-block-latest-posts__list.is-grid div.wp-block-latest-posts__post-excerpt a:hover {';
							echo'background: '.esc_html($rgba).'!important;';
							echo'border: 2px solid '.esc_html($custom_gutenberg_blocks_settings['eccp_settings_block_read_more_hover_border_color_text_field']).';';
							echo'color: '.esc_html($custom_gutenberg_blocks_settings['eccp_settings_block_read_more_hover_text_color_text_field']).';';
						echo'}';
					
					}// fin si on a activé les styles du bloc lire la suite
							
				}// fin si on a activé le style card pour le bloc Derniers Articles				
				
				
				/*---------------- BLOC BOUCLE DE REQUÊTE BACK OFFICE -------------------*/
				
				// Si on a activé le style Card pour le bloc Boucle de Requête
				if( $custom_gutenberg_blocks_settings['eccp_settings_activate_card_style_query_loop_block_radio_field'] == 'yes' ) {
					
					/*-------- Style Card Boucle De Requête en mode grille back office -----------*/
					// Remarque le bloc Derniers Articles est construit a base 
					// d'une liste non ordonnée positionnée dans une grille
				
					/* article en mode grille */
					echo'ul.wp-block-post-template li{';
						echo'box-shadow: 0 2px 4px 2px rgb(0 0 0 / 10%);';
						echo'padding-bottom: 1.2em;';
						// modif pour le thème Divi(on supprime la puce disque par défaut)
						echo'list-style-type: none;';
					echo'}';
					
					
					$my_theme = wp_get_theme();
			
					//correction pour le thème Astra 
					if(stristr($my_theme, 'astra')) {

						// écartement entre les colonnes de la grille
						echo'body.wp-admin .wp-block-post-template.is-flex-container{';
							echo'gap:1em;';
						echo'}';
					
					}
					

					/* Image article au survol */
					echo'ul.wp-block-post-template li figure:hover{';
						echo'background-color: #000000;';
						echo'opacity: 0.6;';
					echo'}';

					/* Auteur & Date */
					echo'ul.wp-block-post-template li  div.wp-block-post-author,
						 ul.wp-block-post-template li div.wp-block-post-date{';
						echo'display:block;';
						echo'padding:0 1.2em 0 1.2em;';
					echo'}';
					
					/* Avatar */
					echo'ul.wp-block-post-template li  div.wp-block-post-author__avatar{';
						echo'float:left;';
					echo'}';
					
					/* Catégories Articles */
					echo'ul.wp-block-post-template li div.taxonomy-category a{';
						echo'display:block;';
						echo'padding:0 1.2em 0 1.2em;';
					echo'}';
					
					/* Extrait */
					echo'ul.wp-block-post-template li div.wp-block-post-excerpt p{';
						echo'display:block;';
						echo'padding:0 1.2em 0 1.2em;';
					echo'}';

					/* Titre de l'article */
					echo'ul.wp-block-post-template li .wp-block-post-title a,
						 ul.wp-block-post-template li div.wp-block-post-excerpt p{';
						echo'display:block;';
						echo'padding:0 1em 0 1em;';
						echo'text-decoration:none!important;';
					echo'}';

					// si on a activé les styles du bloc lire la suite
					// on applique le même style a la balise read more du bloc Derniers Articles
					if( $custom_gutenberg_blocks_settings['eccp_settings_activate_block_styles_read_more_radio_field'] == 'yes' ) {
					
						// on fait la conversion en RGBA pourla couleur de fond du bloc Lire La Suite, 
						// la fonction retourne une chaine
						// soit pour une couleur #000000 avec opacité 0.5 ==> rgba(0,0,0,0.5)
						$rgba = eccp_hex2rgba( $custom_gutenberg_blocks_settings['eccp_settings_block_read_more_background_color_text_field'], 
								intval($custom_gutenberg_blocks_settings['eccp_settings_block_read_more_backgound_color_opacity_text_field'])/100 );
							
					
						//  pour la balise read more du bloc Derniers Articles 
						echo'ul.wp-block-post-template li a.wp-block-post-excerpt__more-link{';					
							
							echo'background: '.esc_html($rgba).'!important;';
							echo'border: 2px solid '.esc_html($custom_gutenberg_blocks_settings['eccp_settings_block_read_more_border_color_text_field']).';';
							echo'color: '.esc_html($custom_gutenberg_blocks_settings['eccp_settings_block_read_more_text_color_text_field']).';';
							echo'padding: 0.5em 1em!important;';
							echo'font-size: 18px;';
							echo'font-weight:600;';
							echo'line-height: 1.3333333;';
							echo'border-radius: 6px;';
							
							echo'display:block;';
							echo'margin:auto;';
							echo'width:150px;';
							echo'margin-top:15px;';
							echo'text-align:center;';
							echo'text-decoration:none!important;';
							
						echo'}';
						
						//  pour la balise read more du Thème Generate Press & Astra 
						echo'ul.wp-block-post-template li div.wp-block-post-excerpt a.read-more,
							 ul.wp-block-post-template li div.wp-block-post-excerpt p.read-more a{';		
						
							echo'display:none;';
						
						echo'}';
						
						// on supprime les marges introduites avec la personnalisation 
						// du bloc liste
						echo'body.wp-admin ul.wp-block-post-template{';					
							echo'margin-left:0!important;';
							// correction pour le thème Divi
							echo'padding-left:0!important;';
						echo'}';
						
						// sur mobile on supprime le gap qui sépare les listes
						// dans la grille
						echo'@media (max-width:480px) {';
							echo'ul.wp-block-post-template  li {';	
								echo'margin-right:0;';
							echo'}';
						echo'}';
						
						// on fait la conversion en RGBA pour la couleur de fond au survol du bloc Lire La Suite, 
						// la fonction retourne une chaine
						// soit pour une couleur #000000 avec opacité 0.5 ==> rgba(0,0,0,0.5)
						$rgba = eccp_hex2rgba( $custom_gutenberg_blocks_settings['eccp_settings_block_read_more_hover_background_color_text_field'], 
								intval($custom_gutenberg_blocks_settings['eccp_settings_block_read_more_hover_backgound_color_opacity_text_field'])/100 );
							
						// régles au survol pour la balise read more
						echo'ul.wp-block-post-template li a.wp-block-post-excerpt__more-link:hover{';
							echo'background: '.esc_html($rgba).'!important;';
							echo'border: 2px solid '.esc_html($custom_gutenberg_blocks_settings['eccp_settings_block_read_more_hover_border_color_text_field']).';';
							echo'color: '.esc_html($custom_gutenberg_blocks_settings['eccp_settings_block_read_more_hover_text_color_text_field']).';';
							echo'text-decoration:none!important;';
						echo'}';
					

					}// fin si on a activé les styles du bloc lire la suite
					
				
				}// fin si on a activé le style Card pour le bloc Boucle de Requête
				
				
				
				/*-------- Style d'un avatar personnalisé en back office -----------*/
				
				// Si on a activé l'utilisation d'un avatar personnalisé
				if( $custom_gutenberg_blocks_settings['eccp_settings_activate_custom_avatar_radio_field'] == 'yes' ) {
				
					/* Image Avatar */
					echo'ul.wp-block-post-template li  div.wp-block-post-author__avatar img{';
						echo'width:'.esc_html($custom_gutenberg_blocks_settings['eccp_settings_custom_avatar_size_text_field']).'px;';
						echo'height:'.esc_html($custom_gutenberg_blocks_settings['eccp_settings_custom_avatar_size_text_field']).'px;';
					echo'}';
				
				}// fin si on a activé un avatar personnalisé
				
				
				/*---------------- BLOC ESPACEMENT BACK OFFICE -------------------*/
				
				// régles pour tablette
				echo'@media (max-width:1024px) { ';
				
					echo'.wp-block-spacer.eccp-is-style-spacer-block{';
					
						echo'height: calc(var(--eccp-blockHeightSpacingTablet, 50)*1px)!important;';

					echo'}';
					
				echo'}';	
				
				// régles pour mobile
				echo'@media (max-width:600px) { ';
				
					echo'.wp-block-spacer.eccp-is-style-spacer-block{';
					
						echo'height: calc(var(--eccp-blockHeightSpacingTablet, 30)*1px)!important;';

					echo'}';
					
				echo'}';
				
				
				/*------------------- BLOC ICONES SOCIALES BACK OFFICE --------------------------*/
				
				
				// Si on a activé le style forme rectangulaire ou flottant
				if( $custom_gutenberg_blocks_settings['eccp_settings_activate_rectangle_shape_style_radio_field'] == 'yes' ) {
				
					
					//----------------   Style Forme Rectangulaire  ----------------
					
					/* On fait correspondre la taille des icônes a celles des Tailles de texte */
			
					//petite
					echo'ul.wp-block-social-links.is-style-eccp-rectangular-shape.has-small-icon-size,
						 ul.wp-block-social-links.is-style-eccp-social-icons-floating-right.has-small-icon-size,
						 ul.wp-block-social-links.is-style-eccp-social-icons-floating-left.has-small-icon-size{';
						echo'font-size:'.intval($editor_text_size_settings['eccp_settings_small_font_size_text_field']).'px;';
					echo'}';
					
					//normale
					echo'ul.wp-block-social-links.is-style-eccp-rectangular-shape.has-normal-icon-size,
						 ul.wp-block-social-links.is-style-eccp-social-icons-floating-right.has-normal-icon-size,
						 ul.wp-block-social-links.is-style-eccp-social-icons-floating-left.has-normal-icon-size{';
						echo'font-size:'.intval($editor_text_size_settings['eccp_settings_regular_font_size_text_field']).'px;';
					echo'}';
					
					//grande
					echo'ul.wp-block-social-links.is-style-eccp-rectangular-shape.has-large-icon-size,
      					 ul.wp-block-social-links.is-style-eccp-social-icons-floating-right.has-large-icon-size,
						 ul.wp-block-social-links.is-style-eccp-social-icons-floating-left.has-large-icon-size{';
						echo'font-size:'.intval($editor_text_size_settings['eccp_settings_large_font_size_text_field']).'px;';
					echo'}';
					
					// enorme
					echo'ul.wp-block-social-links.is-style-eccp-rectangular-shape.has-huge-icon-size,
					     ul.wp-block-social-links.is-style-eccp-social-icons-floating-right.has-huge-icon-size,
						 ul.wp-block-social-links.is-style-eccp-social-icons-floating-left.has-huge-icon-size{';
						echo'font-size:'.intval($editor_text_size_settings['eccp_settings_huge_font_size_text_field']).'px;';
					echo'}';
					
					
					/*flex: flex-grow flex-basis soit ici flex: flex-grow:1  flex-basis:0(par défaut) 
					flexgrow  indique la quantité d'espace restant que l'élément devrait consommer 
					dans un conteneur flexible relativement à la taille des autres éléments du même conteneur.
					les éléments voisins possèdant le même facteur d'expansion, ils recevront tous la même part d'espace.
					flex-basis: donne la taille du container flexible
					min-width: 34px ==> pour éviter que les éléments flexible ne se retrécissent en dessous de cette valeur
					*/	
					echo'ul.wp-block-social-links.is-style-eccp-rectangular-shape  li {';
						echo'flex: 1;';
						echo'margin: 5px;';
						echo'border-radius: 5px;';
						echo'min-width: 34px;';
						echo'text-align:center;';
					echo'}';
					
					// espacement entre les container icônes sociales
					echo'ul.wp-block-social-links.is-style-eccp-rectangular-shape {';
						echo'display:flex;';
						echo'gap: 0.5em!important;';
					echo'}';
					
					// Zoom container icônes sociales au survol
					echo'ul.wp-block-social-links.is-style-eccp-rectangular-shape  li:hover {';
						echo'transform: scale(1.1);';
					echo'}';
					
					/* container du lien */
					echo'ul.wp-block-social-links.is-style-eccp-rectangular-shape li button {';
						echo'padding:0.4em;';
					echo'}';

					/* libellé masqué */
					echo'ul.wp-block-social-links.is-style-eccp-rectangular-shape li button span.wp-block-social-link-label {';
						echo'font-size:0;';
					echo'}';

					/* libellé affiché au survol*/ 
					echo'ul.wp-block-social-links.is-style-eccp-rectangular-shape li:hover button span.wp-block-social-link-label {';
						echo'font-size:0.6em;';
					echo'}';
					
					
					//----------------   Style Fottant a droite & a gauche  ----------------
					
					// On impose la disposition en colonne même s'il existe ce réglage dans l'editeur
					echo'ul.wp-block-social-links.is-style-eccp-social-icons-floating-right,
						 ul.wp-block-social-links.is-style-eccp-social-icons-floating-left {';
						echo'display:flex;';
						echo'flex-direction: column;';
						echo'gap: 0.5em!important;';
						echo'margin-top: 50px;';
					echo'}';
					
					/* container icônes sociales: mise en forme rectangulaire */
					echo'ul.wp-block-social-links.is-style-eccp-social-icons-floating-right li ,
					ul.wp-block-social-links.is-style-eccp-social-icons-floating-left li {';
						echo'border-radius:5px;';
					echo'}';

						
					/* container du lien */
					echo'ul.wp-block-social-links.is-style-eccp-social-icons-floating-right li button,
					ul.wp-block-social-links.is-style-eccp-social-icons-floating-left li button {';
						echo'padding:0.4em;';
					echo'}';

					/* libellé masqué */
					echo'ul.wp-block-social-links.is-style-eccp-social-icons-floating-right li button span.wp-block-social-link-label,
					ul.wp-block-social-links.is-style-eccp-social-icons-floating-left li button span.wp-block-social-link-label {';
						echo'font-size:0;';
					echo'}';

					/* On affiche le libellé au survol*/ 
					echo'ul.wp-block-social-links.is-style-eccp-social-icons-floating-right li:hover button span.wp-block-social-link-label,
						 ul.wp-block-social-links.is-style-eccp-social-icons-floating-left li:hover button span.wp-block-social-link-label{';			
							echo'font-size:0.6em;';
							echo'transition: transform 0.3s ease-in-out;';
					echo'}';

					/* container icônes sociales fottant a droite: on crée un décalage a gauche & un effet de zoom */ 
					echo'ul.wp-block-social-links.is-style-eccp-social-icons-floating-right li:hover {';			
						echo'transform: translateX(calc(0% - 30px)) scale(1.1);';
					echo'}';

					/* container icônes sociales fottant a gauche: on crée un décalage a droite & un effet de zoom */ 
					echo'ul.wp-block-social-links.is-style-eccp-social-icons-floating-left li:hover {';			
						echo'transform: translateX(calc(0% + 30px)) scale(1.1);';
					echo'}';
					
				}
				
					//------------- Style Liens de Partage Back Office --------------------
			
					// Facebook a besoin  pour le partage du balisage open graph pour récupérer 
					// l'image en avant ,le titre , description
					// cela est fait automatiquement par l'extension Yoast SEO ou Social Warfare
					// la bonne dimension pour le partage de l'image en avant est 1200 * 630px
			
					// le style lien de partage a été activé dans le panneau ECCP Styles
					// des paramètres du bloc
					// on affiche après le bloc icône sociales l'icône de partage
					// afin de bien montrer qu'on a transformé les liens de profil 
					// en lien de partage
					echo'ul.is-style-eccp-social-sharing-link:after {';
						echo'content: "\f237";';/* icone de partage */
						echo'font-family:"dashicons";';
						echo'font-weight: 600;';
						echo'font-size: 1.1em;';
						echo'display: block;';
						echo'margin: auto;';
					echo'}';	
					
					// position absolute pour éviter déplacement lors du survol d'une icône sociale
					echo'ul.is-style-eccp-social-sharing-link.is-style-eccp-social-icons-floating-right:after {';
						echo'position:absolute;';
						echo'top:-40px;';
					echo'}';
					
					echo'ul.is-style-eccp-social-sharing-link.is-style-eccp-social-icons-floating-left:after {';
						echo'position:absolute;';
						echo'top:-40px;';
					echo'}';
				
				/*-------------------------ICÔNE TOOLBAR -------------------------------*/
					
							
				/*------------- ICÔNE TOOLBAR PARAGRAPHE -------------------- */
				echo'.ECGB-toolbar-icon-question{';
				
					echo'color: #E6E0F7!important;';
				
				echo'}';
							
				echo'.ECGB-toolbar-icon-info{';
				
					echo'color: #48ADD8!important;';
				
				echo'}';
				
				echo'.ECGB-toolbar-icon-advice{';
				
					echo'color: #83BD71!important;';
				
				echo'}';
				
				echo'.ECGB-toolbar-icon-warning{';
				
					echo'color: #FFC334!important;';
				
				echo'}';
				
				echo'.ECGB-toolbar-icon-alert{';
				
					echo'color: #B54D4D!important;';
				
				echo'}';
				
				
				/*------------- ICÔNE TOOLBAR LISTE -------------------- */
				
				echo'.ECGB-toolbar-icon-square,.ECGB-toolbar-icon-check,.ECGB-toolbar-icon-add, 
					 .ECGB-toolbar-icon-push-spin,.ECGB-toolbar-icon-circle-duotone,
					 .ECGB-toolbar-icon-clear{';
				
					echo'color: #48ADD8!important;';
				
				echo'}';
				
				// ajustement taille & position icône clear (x)
				echo'.components-button.has-icon .dashicon {';
					echo'margin-left: -2px!important;';
					echo'margin-top: -4px;';
					echo'font-size: 24px;';
				echo'}';

				/*------------------------------ SURLIGNEMENT TEXTE BACK OFFICE ------------------------------------*/

				// style pour le surlignement du texte
				echo'span.is-style-eccp-highlight {';
					echo'padding: 0.12em 0.24em;';
					echo'border-radius: 2px;';
				echo'}';
				
				
				/*------------------------------ FORMAT LIENS EXTERNE BACK OFFICE ------------------------------------*/
				
				// Ajout de l'icône External de Dashicons aprés un lien hypertexte
				// grace au format External Links de la barre d'outils du bloc
				echo'span.is-style-eccp-external-links:after{';
	
					echo'font-family: dashicons;';
					echo'content: "\f504";';
					echo'font-weight: 400;';
					echo'vertical-align: top;';	
					echo'margin-left:0.1em;';	
					echo'margin-right:0.1em;';	

				echo'}';
				
				
				/*------------------------------ RESPONSIVE BLOC GUTENBERG BACK OFFICE------------------------------------*/
					
					/*----------------- Hauteur du bloc couverture sur mobile en Back Office -----------------------*/
					
					// régle pour mobile
					echo'@media (max-width: 480px){';
						
						echo'.is-style-eccp-cover{';
							echo'min-height: calc(var( --eccp-mobileCoverHeight, 300)* 1px)!important;';
						echo'}';
						 
					echo'}';
				
				
			echo '</style>';
		
		
		}// fin si l'objet d'écran est l'éditeur
		
	
	} );// fin fonction hook admin head

}


/*----------------------------------------------------------------------------------------
		                STYLE FRONT END BLOCS EDITEUR GUTENBERG
/*---------------------------------------------------------------------------------------*/


add_action( 'wp_head','ecpp_block_style_front_end',1 );


function ecpp_block_style_front_end() {
	
	// On récupère les paramètres pour personnaliser l'éditeur
	$custom_gutenberg_editor_settings = get_option( 'eccp_settings_custom_gutenberg_editor' );
	// On récupère les paramètres pour les blocs réutilisables
	$reusable_blocks_settings = get_option( 'eccp_settings_reusable_blocks' );
	// On récupère les paramètres pour personnaliser les blocs Gutenberg
	$custom_gutenberg_blocks_settings = get_option( 'eccp_settings_custom_gutenberg_block' );
	// On récupère les paramètres pour personnaliser les Tailles de texte
	$editor_text_size_settings = get_option( 'eccp_setting_editor_text_size' );
	
	// post type ayant un slug, publicly_queryable, mais qui ne sont pas des CPT utilisateurs
	$slug_no_cpt = array('e-landing-page','seedprod' ,'product','produit',
							'/boutique','elementor-hf','nf_sub','/produit');
	
	// Style des blocs en front end
	echo '<style type="text/css">';


		/*------------------- ALIGNEMENT LARGE & PLEINE LARGEUR POUR L 'EDITEUR DE BLOCS RÉGLES FRONT END --------------------------*/
		
		// si on à activé l'alignement large pour l'éditeur de blocs
		if( $custom_gutenberg_editor_settings['eccp_settings_activate_align_wide_block_editor_checkbox_field'] == true ) {
			
			// Régles CSS pour les pages & articles pour un alignement large	
			// on fait correspondre la largeur du bloc a celle de la page ou article		
			echo'body.single-post .alignwide,body.page .alignwide{
				
				max-width: 100%!important;
				width: 100%!important;
				margin-left: unset!important;
				margin-right: unset!important;
				
			}';
			
			// Régles CSS pour les pages pour un alignement pleine largeur
			// je ne gère pas les articles car généralement il y a une sidebar
			// et il est difficile de tester si présence ou non d'une sidebar
			// ces régles correspondent a celle du thème Astra
			echo'body.page .alignfull{
				
					margin-left: calc(-50vw + 50%)!important;
					margin-right: calc(-50vw + 50%)!important;
					max-width: 100vw!important;
					width: 100vw!important;
					
			}';
			
			
			// Ajout régle pour thème OceanWP suite mise a jour 3.1.0
			echo'body.page .entry .alignfull {
				
					width: 100vw!important;
					
			}';
			
			
			// s'il ya des Customm Post Type
			if ( !empty($slug_cpt = eccp_get_registered_post_types()) ) {
				
				foreach ($slug_cpt as $key => $value) {
					
					// on récupère pour les CPT un tableau associatif : $slug_cpt
					// dont la clé donne le nom de nos CPT et la valeur le slug du CPT
					// récupère aussi a quelques exception prés des slug de post type 
					// qui ne sont pas des CPT, ex: e-landing-page que l'on écarte en les définissant dans $slug_no_cpt
					// si le slug est bien un slug de CPT alors on peut appliquer les régles CSS
					if  ( !in_array($value, $slug_no_cpt) )  {
					
						// Régles CSS pour un alignement large	
						// on fait correspondre la largeur du bloc a celle du CPT		
						echo'body.single-'.$value.' .alignwide,body.page .alignwide{
							
							max-width: 100%!important;
							width: 100%!important;
							margin-left: unset!important;
							margin-right: unset!important;
							
						}';
						
						// Régles CSS pour un alignement pleine largeur
						// ces régles correspondent a celle du thème Astra
						echo'body.single-'.$value.' .alignfull{
							
								margin-left: calc(-50vw + 50%)!important;
								margin-right: calc(-50vw + 50%)!important;
								max-width: 100vw!important;
								width: 100vw!important;
								
						}';
					
					
						// Ajout régle pour thème OceanWP suite mise a jour 3.1.0
						echo'body.single-'.$value.' .entry .alignfull {
							
								width: 100vw!important;
								
						}';
						
						
						// Régles pour le plugin The Events Calendar(Mise à jour version 2.0)
								// ce n'est pas le slug mais le nom du post type qui est pris comme référence
								// par The Events Calendar pour appliquer des régles CSS.
						if ($key == 'tribe_events') {
							
							// Régles CSS pour un alignement large	
							// on fait correspondre la largeur du bloc a celle du CPT évènement		
							echo'body.single-'.$key.' .alignwide,body.page .alignwide{
								
								max-width: 100%!important;
								width: 100%!important;
								margin-left: unset!important;
								margin-right: unset!important;
								
							}';
							
							// Régles CSS pour un alignement pleine largeur
							// ces régles correspondent a celle du thème Astra
							echo'body.single-'.$key.' .alignfull{
								
									margin-left: calc(-50vw + 50%)!important;
									margin-right: calc(-50vw + 50%)!important;
									max-width: 100vw!important;
									width: 100vw!important;
									
							}';
						
						
							// Ajout régle pour thème OceanWP suite mise a jour 3.1.0
							echo'body.single-'.$key.' .entry .alignfull {
								
									width: 100vw!important;
									
							}';
								
								
						}
						
						
					}
					
				}
			
				
			} // Fin s'il ya des Customm Post Type
			
			
		}// Fin si on à activé l'alignement large pour l'éditeur de blocs
		
		
		/*------------------- EMBEDS RESPONSIVES LARGEUR MAX VIDÉOS INTÉGRÉES FRONT END --------------------------*/
				
		// Si on à activé les embeds responsive
		if( $custom_gutenberg_editor_settings['eccp_settings_activate_responsive_embeds_checkbox_field'] == true ) {
			
			
			// Régle pour les Articles
			// on affecte au bloc d'intégration de la vidéo une largeur max
			// si c'est un article(permet d'eviter conflit avec Custom Post Type car la classe single est présente sur un CPT)
			if (is_single() && get_post_type() == 'post') {
			
				echo'body.single .wp-block-embed {'; 
				
					echo'max-width:'.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_post_embed_max_width_text_field']) ).'px!important;';
				
				echo'}';
			
			}
			
			// Régle pour les Pages
			// on affecte au bloc d'intégration de la vidéo une largeur max	

			if (is_page()) {
				
				echo'body.page .wp-block-embed {'; 
				
					echo'max-width:'.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_page_embed_max_width_text_field']) ).'px!important;';
				
				echo'}';
				
			}
			
			
			// on récupère le thème actif
			$my_theme = wp_get_theme();
	
			// Modif pour le thème DIVI 
			if(stristr($my_theme, 'divi')) {
				
				
				echo'figure.wp-block-embed {';
				
					echo'margin:20px 0px!important;';					
				
				echo'}';
			
				// Pour les tablettes & PC on rectifie la hauteur de l'iframe 
				// (container de la vidéo)qui n'est pas mis au format 16/9 
				// lorsqu'on modifie la largeur du bloc embed
				echo'.wp-block-embed iframe {';
				
					echo'max-height: calc('.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_page_embed_max_width_text_field']) ).' * 9 / 16 * 1px)!important;';				
				
				echo'}';
				
				
				// Pour les mobiles
				// on gére la hauteur de l'iframe au format 16/9
				// par un % de la largeur de la fenêtre avec vw
				echo'@media (max-width:767px) {';
				
					echo'.wp-block-embed iframe {';
					
						echo'max-height: 45vw!important;';
					
					echo'}';
					
				echo'}';
				
			}
			
			
			// Régle pour les Custom Post Type
			
			// s'il ya des Custom Post Type
			if ( !empty($slug_cpt = eccp_get_registered_post_types()) ) {
				
				foreach ($slug_cpt as $key => $value) {
					
					// on récupère pour les CPT un tableau associatif : $slug_cpt
					// dont la clé donne le nom de nos CPT et la valeur le slug du CPT
					// récupère aussi a quelques exception prés des slug de post type 
					// qui ne sont pas des CPT, ex: e-landing-page que l'on écarte en les définissant dans $slug_no_cpt
					// si le slug est bien un slug de CPT alors on peut appliquer les régles CSS
					if  ( !in_array($value, $slug_no_cpt) )  {
						
						
						// Régle pour les CPT
						// on affecte au bloc d'intégration de la vidéo une largeur max			
						echo'body.single-'.$value.' .wp-block-embed {'; 
						
							echo'max-width:'.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_cpt_embed_max_width_text_field']) ).'px!important;';
						
						echo'}';
						
						
						// Régle pour les CPT 
						// Mise à jour version 2.0: correction pour un alignement gauche & droite du bloc embed
						// pour un embed max-width de 960px 
						//@media (min-width:960px) {  margin-right:calc(109% - 960px);   }
						
						echo'@media (min-width: '.$custom_gutenberg_editor_settings['eccp_settings_cpt_embed_max_width_text_field'].'px) {';
						
							echo 'body.single-'.$value.' .wp-block-embed.alignleft {';
				
								echo'margin-right: calc(109% - '. esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_cpt_embed_max_width_text_field']) ).'px)!important;';
					
							echo'}';
							
							echo 'body.single-'.$value.' .wp-block-embed.alignright {';
							
								echo'margin-left: calc(109% - '. esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_cpt_embed_max_width_text_field']) ).'px)!important;';
					
							echo'}';
						
						echo'}';
						
						// Régles pour le plugin The Events Calendar(Mise à jour version 2.0)
						// ce n'est pas le slug mais le nom du post type qui est pris comme référence
						// par The Events Calendar pour appliquer des régles CSS.
						if ($key == 'tribe_events') {
							
							// Régle pour les CPT évènements
							// on affecte au bloc d'intégration de la vidéo une largeur max			
							echo'body.single-'.$key.' .wp-block-embed {'; 
							
								echo'max-width:'.esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_cpt_embed_max_width_text_field']) ).'px!important;';
							
							echo'}';
							
							// Régle pour les CPT évènements
							// Mise à jour version 2.0: correction pour un alignement gauche & droite du bloc embed
							// pour un embed max-width de 960px 
							//@media (min-width:960px) {  margin-right:calc(109% - 960px);   }
							
							echo'@media (min-width: '.$custom_gutenberg_editor_settings['eccp_settings_cpt_embed_max_width_text_field'].'px) {';
							
								echo 'body.single-'.$key.' .wp-block-embed.alignleft {';
					
									echo'margin-right: calc(109% - '. esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_cpt_embed_max_width_text_field']) ).'px)!important;';
						
								echo'}';
								
								echo 'body.single-'.$key.' .wp-block-embed.alignright {';
								
									echo'margin-left: calc(109% - '. esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_cpt_embed_max_width_text_field']) ).'px)!important;';
						
								echo'}';
							
							echo'}';
							
						}
			
						
					}
				
				}
			
				
			} // Fin s'il ya des Custom Post Type
			
			
			// Régle pour les Articles
			// Mise à jour version 1.7: correction pour un alignement gauche & droite du bloc embed
			// pour un embed max-width de 960px 
			//@media (min-width:960px) {  margin-right:calc(109% - 960px);   }
			
			// si c'est un article(permet d'eviter conflit avec Custom Post Type car 
			// la classe single est présente sur un CPT)
			if (is_single() && get_post_type() == 'post') {
				
				echo'@media (min-width: '.$custom_gutenberg_editor_settings['eccp_settings_post_embed_max_width_text_field'].'px) {';
				
					echo 'body.single .wp-block-embed.alignleft {';
					
						echo'margin-right: calc(109% - '. esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_post_embed_max_width_text_field']) ).'px)!important;';
			
					echo'}';
					
					echo 'body.single .wp-block-embed.alignright {';
					
						echo'margin-left: calc(109% - '. esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_post_embed_max_width_text_field']) ).'px)!important;';
			
					echo'}';
				
				echo'}';
			
			}

			
			// Régle pour les Pages
			// Mise à jour version 1.7: correction pour un alignement gauche & droite du bloc embed
			// pour un embed max-width de 960px 
			//@media (min-width:960px) {  margin-right:calc(100% - 960px);   }
			 
			
			if (is_page()) {
				
				echo'@media (min-width: '.$custom_gutenberg_editor_settings['eccp_settings_page_embed_max_width_text_field'].'px) {';
				
					echo 'body.page .wp-block-embed.alignleft {';
					
						echo'margin-right: calc(109% - '. esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_page_embed_max_width_text_field']) ).'px)!important;';
			
					echo'}';

					echo 'body.page .wp-block-embed.alignright {';
					
						echo'margin-left: calc(109% - '. esc_html( strval($custom_gutenberg_editor_settings['eccp_settings_page_embed_max_width_text_field']) ).'px)!important;';
			
					echo'}';
				
				echo'}';
			
			}
			
			
			//$my_theme = wp_get_theme();
			
			// correction pour le thème Astra ou divi
			//if(stristr($my_theme, 'astra') || stristr($my_theme, 'divi')) {
			
			// certains thèmes supporte mal l'activation Embeds Reponsive
			// on désactive alors cette fonctionnalité et cela neccesite
			// une règle pour l'alignement centré des vidéos(exemple Thème Divi, Astra)
			if( $custom_gutenberg_editor_settings['eccp_corrective_according_to_theme_radio_field'] == 'yes' ) {
			
				// on supprime une marge interne haute du container d'intégration de la vidéo
				/*
				echo'.wp-block-embed__wrapper:before {';
				
					echo'padding-top:0!important;';
					
				echo'}';
				*/
				
				// on centre la vidéo pour un alignement centré du bloc embed
				echo'.aligncenter {';
				
					echo'margin:0 auto!important;';
					
				echo'}';
			
			}
			
			
		}
		
	
		/*-------------------BLOC RÉUTILISABLE BLOCKQUOTE FRONT END --------------------------*/
		
		
		/* On régle la largeur automatique du bloc en fonction de son contenu
		   avec les régles position: absolute ou float:left mais cela pose un problème.
		   j'ai donc pris une position relative et limiter la largeur à width:60% */
		echo'.block-quote{
			
			position: relative;
			font-style: italic;
			border:none!important;
			margin: 40px 70px!important;';
			
		echo'}';
		
		/* Modif version 2.3: la graisse & taille de texte sont désormais des réglages
	       du bloc natif Bloc Quote de WordPress
		echo'.block-quote p {';
		  
		echo'font-size:'.esc_html($reusable_blocks_settings['eccp_settings_font_size_blockquote_text_field']).'px!important;';
		echo'font-weight:'.esc_html($reusable_blocks_settings['eccp_settings_font_weight_blockquote_select_field']).'!important;';
		
		echo'}';
		*/
		
		/* 
		   Modif Version 1.7
		   Blockquote de gauche,j'ai reformaté l'image SVG 
		   en URL data(https://websemantics.uk/tools/svg-to-background-image-conversion/) 
		   pour l'utiliser comme images d'arrière-plan, au lieu de l'URL relative 
		   par rapport au répertoire du plugin: 
		   echo'background: url('.EDITOR_CUSTOM_COLOR_PALETTE_URL.'/img/editeur-gutenberg/rc-blockquote.svg'.');';	
		   Ceci afin de modifier la couleur de fond($blocquote_color) 
		   et l'opacité($blocquote_opacity)directement dans l'URL data 
		*/ 
		
		// on met en forme la couleur des guillemets et l'opacité pour l'URL data 
		// qui charge l'image SVG des guillemets
		// substr retourne une sous chaine de la position:1 jusqu'a la fin				
		$blocquote_color = substr($reusable_blocks_settings['eccp_settings_quotation_marks_color_text_field'],1);
		// strval renvoi une variable au format chaine
		$blocquote_opacity = strval( intval($reusable_blocks_settings['eccp_settings_quotation_marks_opacity_text_field'])/100 );
		
		echo'.block-quote:before {
			position: absolute;
			content: "";
			top: -19px;
			left: -67px;
			height: 55px;
			width: 53px;';
		echo'background-image: url("data:image/svg+xml;charset=utf8,%3C?xml version=\'1.0\' encoding=\'UTF-8\' standalone=\'no\'?%3E%3Csvg xmlns:dc=\'http://purl.org/dc/elements/1.1/\' xmlns:cc=\'http://creativecommons.org/ns%23\' xmlns:rdf=\'http://www.w3.org/1999/02/22-rdf-syntax-ns%23\' xmlns:svg=\'http://www.w3.org/2000/svg\' xmlns=\'http://www.w3.org/2000/svg\' xmlns:sodipodi=\'http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\' xmlns:inkscape=\'http://www.inkscape.org/namespaces/inkscape\' width=\'53\' height=\'55\' version=\'1.1\' id=\'svg8\' sodipodi:docname=\'rc-blockquote.svg\' inkscape:version=\'1.0 (4035a4fb49, 2020-05-01)\'%3E%3Cmetadata id=\'metadata14\'%3E%3Crdf:RDF%3E%3Ccc:Work rdf:about=\'\'%3E%3Cdc:format%3Eimage/svg+xml%3C/dc:format%3E%3Cdc:type rdf:resource=\'http://purl.org/dc/dcmitype/StillImage\' /%3E%3Cdc:title /%3E%3C/cc:Work%3E%3C/rdf:RDF%3E%3C/metadata%3E%3Cdefs id=\'defs12\'%3E%3Cfilter height=\'1.0000094\' y=\'-4.7127273e-06\' width=\'1.0000216\' x=\'-1.08e-05\' id=\'filter842\' style=\'color-interpolation-filters:sRGB\' inkscape:collect=\'always\'%3E%3CfeGaussianBlur id=\'feGaussianBlur844\' stdDeviation=\'0.000108\' inkscape:collect=\'always\' /%3E%3C/filter%3E%3Cfilter height=\'1.0000094\' y=\'-4.7127273e-06\' width=\'1.0000216\' x=\'-1.08e-05\' id=\'filter846\' style=\'color-interpolation-filters:sRGB\' inkscape:collect=\'always\'%3E%3CfeGaussianBlur id=\'feGaussianBlur848\' stdDeviation=\'0.000108\' inkscape:collect=\'always\' /%3E%3C/filter%3E%3C/defs%3E%3Csodipodi:namedview inkscape:document-rotation=\'0\' pagecolor=\'%23ffffff\' bordercolor=\'%23666666\' borderopacity=\'1\' objecttolerance=\'10\' gridtolerance=\'10\' guidetolerance=\'10\' inkscape:pageopacity=\'0\' inkscape:pageshadow=\'2\' inkscape:window-width=\'1366\' inkscape:window-height=\'705\' id=\'namedview10\' showgrid=\'false\' inkscape:zoom=\'8.6\' inkscape:cx=\'29.175176\' inkscape:cy=\'27.5\' inkscape:window-x=\'-8\' inkscape:window-y=\'-8\' inkscape:window-maximized=\'1\' inkscape:current-layer=\'svg8\' /%3E%3Cg id=\'g840\'%3E%3Cpath id=\'‘\' d=\'m 24,0 v 7.178 c -3.11,0.905 -5.441,3.185 -6.996,6.839 -1.555,3.654 -2.332,8.681 -2.332,15.084 v 2.037 H 24 V 55 H 0 V 34.242 C 0,23.7 1.992,15.569 5.976,9.846 9.96,4.123 15.968,0.84 24,0 Z\' style=\'display:inline;opacity:'.$blocquote_opacity.';fill:%23'.$blocquote_color.';fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1;filter:url(%23filter842)\' /%3E%3Cpath id=\'‘-copy\' d=\'m 53,0 v 7.178 c -3.11,0.905 -5.441,3.185 -6.996,6.839 -1.555,3.654 -2.332,8.681 -2.332,15.084 v 2.037 H 53 V 55 H 29 V 34.242 C 29,23.701 30.992,15.569 34.976,9.846 38.96,4.123 44.968,0.84 53,0 Z\' style=\'display:inline;opacity:'.$blocquote_opacity.';fill:%23'.$blocquote_color.';fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1;filter:url(%23filter846)\' inkscape:highlight-color=\'4294967295\' /%3E%3C/g%3E%3C/svg%3E");';	
			
		echo'}';

		/* Blockquote de droite */
		echo'.block-quote:after {
			position: absolute;
			content: "";
			bottom: -19px;
			right: -67px;
			height: 55px;
			width: 53px;
			-webkit-transform: rotate(180deg);
			transform: rotate(180deg);';
		echo'background-image: url("data:image/svg+xml;charset=utf8,%3C?xml version=\'1.0\' encoding=\'UTF-8\' standalone=\'no\'?%3E%3Csvg xmlns:dc=\'http://purl.org/dc/elements/1.1/\' xmlns:cc=\'http://creativecommons.org/ns%23\' xmlns:rdf=\'http://www.w3.org/1999/02/22-rdf-syntax-ns%23\' xmlns:svg=\'http://www.w3.org/2000/svg\' xmlns=\'http://www.w3.org/2000/svg\' xmlns:sodipodi=\'http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\' xmlns:inkscape=\'http://www.inkscape.org/namespaces/inkscape\' width=\'53\' height=\'55\' version=\'1.1\' id=\'svg8\' sodipodi:docname=\'rc-blockquote.svg\' inkscape:version=\'1.0 (4035a4fb49, 2020-05-01)\'%3E%3Cmetadata id=\'metadata14\'%3E%3Crdf:RDF%3E%3Ccc:Work rdf:about=\'\'%3E%3Cdc:format%3Eimage/svg+xml%3C/dc:format%3E%3Cdc:type rdf:resource=\'http://purl.org/dc/dcmitype/StillImage\' /%3E%3Cdc:title /%3E%3C/cc:Work%3E%3C/rdf:RDF%3E%3C/metadata%3E%3Cdefs id=\'defs12\'%3E%3Cfilter height=\'1.0000094\' y=\'-4.7127273e-06\' width=\'1.0000216\' x=\'-1.08e-05\' id=\'filter842\' style=\'color-interpolation-filters:sRGB\' inkscape:collect=\'always\'%3E%3CfeGaussianBlur id=\'feGaussianBlur844\' stdDeviation=\'0.000108\' inkscape:collect=\'always\' /%3E%3C/filter%3E%3Cfilter height=\'1.0000094\' y=\'-4.7127273e-06\' width=\'1.0000216\' x=\'-1.08e-05\' id=\'filter846\' style=\'color-interpolation-filters:sRGB\' inkscape:collect=\'always\'%3E%3CfeGaussianBlur id=\'feGaussianBlur848\' stdDeviation=\'0.000108\' inkscape:collect=\'always\' /%3E%3C/filter%3E%3C/defs%3E%3Csodipodi:namedview inkscape:document-rotation=\'0\' pagecolor=\'%23ffffff\' bordercolor=\'%23666666\' borderopacity=\'1\' objecttolerance=\'10\' gridtolerance=\'10\' guidetolerance=\'10\' inkscape:pageopacity=\'0\' inkscape:pageshadow=\'2\' inkscape:window-width=\'1366\' inkscape:window-height=\'705\' id=\'namedview10\' showgrid=\'false\' inkscape:zoom=\'8.6\' inkscape:cx=\'29.175176\' inkscape:cy=\'27.5\' inkscape:window-x=\'-8\' inkscape:window-y=\'-8\' inkscape:window-maximized=\'1\' inkscape:current-layer=\'svg8\' /%3E%3Cg id=\'g840\'%3E%3Cpath id=\'‘\' d=\'m 24,0 v 7.178 c -3.11,0.905 -5.441,3.185 -6.996,6.839 -1.555,3.654 -2.332,8.681 -2.332,15.084 v 2.037 H 24 V 55 H 0 V 34.242 C 0,23.7 1.992,15.569 5.976,9.846 9.96,4.123 15.968,0.84 24,0 Z\' style=\'display:inline;opacity:'.$blocquote_opacity.';fill:%23'.$blocquote_color.';fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1;filter:url(%23filter842)\' /%3E%3Cpath id=\'‘-copy\' d=\'m 53,0 v 7.178 c -3.11,0.905 -5.441,3.185 -6.996,6.839 -1.555,3.654 -2.332,8.681 -2.332,15.084 v 2.037 H 53 V 55 H 29 V 34.242 C 29,23.701 30.992,15.569 34.976,9.846 38.96,4.123 44.968,0.84 53,0 Z\' style=\'display:inline;opacity:'.$blocquote_opacity.';fill:%23'.$blocquote_color.';fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1;filter:url(%23filter846)\' inkscape:highlight-color=\'4294967295\' /%3E%3C/g%3E%3C/svg%3E");';	
			
		echo'}';
		
		// largeur blockquote pour les articles en front end
		
		// si c'est un article(permet d'eviter conflit avec Custom Post Type car la classe single 
		// est présente sur un CPT)
		if (is_single() && get_post_type() == 'post') {
			echo'body.single .block-quote{';
			
				echo'width:'.esc_html($reusable_blocks_settings['eccp_settings_width_blockquote_post_front_end_text_field']).'%;';
			
			echo'}';
		}
		
		
		// largeur blockquote pour les pages en front end
		if (is_page()) {
			echo'body.page .block-quote{';
			
				echo'width:'.esc_html($reusable_blocks_settings['eccp_settings_width_blockquote_page_front_end_text_field']).'%;';
			
			echo'}';
		}
		
		// Régle pour les Custom Post Type
			
		// s'il ya des Custom Post Type
		if ( !empty($slug_cpt = eccp_get_registered_post_types()) ) {
			
			foreach ($slug_cpt as $key => $value) {
				
				// on récupère pour les CPT un tableau associatif : $slug_cpt
				// dont la clé donne le nom de nos CPT et la valeur le slug du CPT
				// récupère aussi a quelques exception prés des slug de post type 
				// qui ne sont pas des CPT, ex: e-landing-page que l'on écarte en les définissant dans $slug_no_cpt
				// si le slug est bien un slug de CPT alors on peut appliquer les régles CSS
				if  ( !in_array($value, $slug_no_cpt) )  {
					
					// largeur blockquote pour les CPT en front end
					echo'body.single-'.$value.' .block-quote{';
					
						echo'width:'.esc_html($reusable_blocks_settings['eccp_settings_width_blockquote_cpt_front_end_text_field']).'%;';
					
					echo'}';
					
				}
				
				// Régles pour le plugin The Events Calendar(Mise à jour version 2.0)
				// ce n'est pas le slug mais le nom du post type qui est pris comme référence
				// par The Events Calendar pour appliquer des régles CSS.
				if ($key == 'tribe_events') {
					
					// largeur blockquote pour les CPT évènements en front end
					echo'body.single-'.$key.' .block-quote{';
					
						echo'width:'.esc_html($reusable_blocks_settings['eccp_settings_width_blockquote_cpt_front_end_text_field']).'%;';
					
					echo'}';
					
				}
			
			}
		
			
		} // Fin s'il ya des Custom Post Type

		/*-------------------BLOC RÉUTILISABLE METTRE EN ÉVIDENCE FRONT END --------------------------*/
		
		/* bordure colorée orange #F37020 avec une transparence */
		echo'.mise-en-evidence {';
		
		echo'border-left: 5px solid '.esc_html($reusable_blocks_settings['eccp_settings_custom_paragraph_border_color']).';';
		
		echo'border-radius:4px;
			 padding:1.1em!important;
		     margin:1.1em;
		     font-size: 20px;';
			  
		echo'}';
		
		
		// largeur bloc Mettre en Évidence pour les articles en front end
		
		// si c'est un article(permet d'eviter conflit avec Custom Post Type car la classe single 
		// est présente sur un CPT)
		if (is_single() && get_post_type() == 'post') {
			
			echo'body.single .mise-en-evidence{';
			
				echo'width:'.esc_html($reusable_blocks_settings['eccp_settings_custom_paragraph_width_post_front_end_text_field']).'%;';
			
			echo'}';
		}
		
		
		// largeur  bloc Mettre en Évidence pour les pages en front end
		if (is_page()) {
			
			echo'body.page .mise-en-evidence{';
			
				echo'width:'.esc_html($reusable_blocks_settings['eccp_settings_custom_paragraph_width_page_front_end_text_field']).'%;';
			
			echo'}';
		}
		
		// Régle pour les Custom Post Type
		
		// s'il ya des Custom Post Type
		if ( !empty($slug_cpt = eccp_get_registered_post_types()) ) {
			
			foreach ($slug_cpt as $key => $value) {
				
				// on récupère pour les CPT un tableau associatif : $slug_cpt
				// dont la clé donne le nom de nos CPT et la valeur le slug du CPT
				// récupère aussi a quelques exception prés des slug de post type 
				// qui ne sont pas des CPT, ex: e-landing-page que l'on écarte en les définissant dans $slug_no_cpt
				// si le slug est bien un slug de CPT alors on peut appliquer les régles CSS
				if  ( !in_array($value, $slug_no_cpt) )  {
					
					// largeur  bloc Mettre en Évidence pour les CPT en front end
					echo'body.single-'.$value.' .mise-en-evidence{';
					
						echo'width:'.esc_html($reusable_blocks_settings['eccp_settings_custom_paragraph_width_cpt_front_end_text_field']).'%;';
					
					echo'}';
					
				}
				
				// Régles pour le plugin The Events Calendar(Mise à jour version 2.0)
				// ce n'est pas le slug mais le nom du post type qui est pris comme référence
				// par The Events Calendar pour appliquer des régles CSS.
				if ($key == 'tribe_events') {
					
					// largeur bloc Mettre en évidence pour les CPT évènements en Front end
					echo'body.single-'.$key.' .mise-en-evidence{';
					
						echo'width:'.esc_html($reusable_blocks_settings['eccp_settings_custom_paragraph_width_cpt_front_end_text_field']).'%;';
					
					echo'}';
					
				}
			
			}
		
			
		}
		
		/*----------------------------STYLE BOX SHADOW FRONT END ------------------------------*/
		
		
		/*-------------------- Style box shadow(page d'options du plugin) front end ---------------------*/
		  
		// a partir de la version 2.8 le réglage Box Shadow estdans les paramètres du bloc  
		  
		/*
		// on fait la conversion en RGBA, la fonction retourne une chaine
		// soit pour une couleur #000000 avec opacité 0.5 ==> rgba(0,0,0,0.5)
		$rgba = eccp_hex2rgba( $custom_gutenberg_blocks_settings['eccp_settings_box_shadow_color_text_field'], 
				intval($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_opacity_text_field'])/100 );
				
		
		// on corrige le bug avant d'appliquer l'effet Box Shadow : 
		// une valeur de 0 enregistré en base de données donne une chaine vide
		if ( empty($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_x_text_field']) ){
			$custom_gutenberg_blocks_settings['eccp_settings_box_shadow_x_text_field'] = '0';
		}
		
		if ( empty($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_y_text_field']) ){
			$custom_gutenberg_blocks_settings['eccp_settings_box_shadow_y_text_field'] = '0';
		}
		
		if ( empty($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_blur_text_field']) ){
			$custom_gutenberg_blocks_settings['eccp_settings_box_shadow_blur_text_field'] = '0';
		}
		
		if ( empty($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_spread_text_field']) ){
			$custom_gutenberg_blocks_settings['eccp_settings_box_shadow_spread_text_field'] = '0';
		}
		
		
		
		
		// si on à activé l'effet ombre de boite
		// ombre de boite par défaut: box-shadow: 8px 8px 12px -8px rgba(0,0,0,0.5); 
		if( $custom_gutenberg_blocks_settings['eccp_settings_activate_box_shadow_paragraph_block_radio_field'] == 'yes' ) {
			
			echo'.wp-block-group.is-style-eccp-box-shadow,
				 p.is-style-eccp-box-shadow {';
		
			echo'box-shadow: '.esc_html(strval($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_x_text_field'])).'px '
							  .esc_html(strval($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_y_text_field'])).'px '
							  .esc_html(strval($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_blur_text_field'])).'px '
							  .esc_html(strval($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_spread_text_field'])).'px '
							  .esc_html($rgba).';';
							  
			echo'background: #F0F2F6;';
			echo'padding: 1.25em 2.375em;';
			echo'margin-bottom:1.1em!important;';
				  
			echo'}';
			
			
			// Pour Le Bloc Colonne
			echo'.wp-block-column.is-style-eccp-box-shadow{';
		
			echo'box-shadow: '.esc_html(strval($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_x_text_field'])).'px '
							  .esc_html(strval($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_y_text_field'])).'px '
							  .esc_html(strval($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_blur_text_field'])).'px '
							  .esc_html(strval($custom_gutenberg_blocks_settings['eccp_settings_box_shadow_spread_text_field'])).'px '
							  .esc_html($rgba).';';
			echo'}';
			
		}
		*/
		
		/*-------------------- Style box shadow(React JS) front end ---------------------*/
		
		
		// bloc Paragraphe
		// le style box shadow est appliqué directement 
		// en react Js a partir de la version 2.8
		echo'p.eccp-box-shadow {';
	
			echo'padding: 1.25em 2.375em;';
			echo'margin-bottom:1.1em!important;';
			  
		echo'}';
		
		
		
		// Pour Le Bloc image
		// on cible l'image du bloc,qu'on ne peut faire en react Js 
		// pour apliquer le style box shadow avec les variables
		// css déclarées et affectées par le script en ReacT JS
		echo'.wp-block-image .eccp-box-shadow img,
			 .wp-block-image.eccp-box-shadow img{';
	
		echo'box-shadow: var(--eccp-horizontalBoxShadow, 0) '.
						 'var(--eccp-verticalBoxShadow, 0) '.
						 'var(--eccp-blurBoxShadow, 4) '.
						 'var(--eccp-spreadBoxShadow, 1) '.
						 'var(--eccp-colorBoxShadow, rgba(0,0,0,0.2));';
		 
		echo'}';
		
		
		// Pour Le Bloc Média Texte
		// on cible l'image du bloc,qu'on ne peut faire en React JS 
		// pour apliquer le style box shadow avec les variables
		// css déclarées et affectées par le script en React JS
		echo'.wp-block-media-text.eccp-box-shadow .wp-block-media-text__media img {';
	
			echo'box-shadow: var(--eccp-horizontalBoxShadow, 20) '.
							 'var(--eccp-verticalBoxShadow, 20) '.
							 'var(--eccp-blurBoxShadow, 0) '.
							 'var(--eccp-spreadBoxShadow, 0) '.
							 'var(--eccp-colorBoxShadow,#0E6487);';
		 
		echo'}';
		
		
		// Pour Le Bloc Bouton
		// On cible le lien du bouton qui a la classe: wp-block-button__link,
		// qu'on ne peut faire en React JS. 
		// On applique le style box shadow avec les variables
		// css déclarées et affectées par le script en React JS
		echo'.wp-block-button.eccp-box-shadow .wp-block-button__link {';
	
		echo'box-shadow: var(--eccp-horizontalBoxShadow, 0) '.
						 'var(--eccp-verticalBoxShadow, 0) '.
						 'var(--eccp-blurBoxShadow, 4) '.
						 'var(--eccp-spreadBoxShadow, 1) '.
						 'var(--eccp-colorBoxShadow, rgba(0,0,0,0.2));';
		 
		echo'}';
		
		
		/*-------------------BLOC PARAGRAPHE FRONT END --------------------------*/
		
		
		$my_theme = wp_get_theme();
			
		// correction theme divi ajout d'une marge basse pour le bloc paragraphe
		if(stristr($my_theme, 'divi')) {
		
			echo'p {';
				echo'margin-bottom: 1.5em!important;';
			echo'}';
		
		}
	
	    //BLOC UN SEUL PARAGRAPHE AVEC UN FOND 
	
		/* Pour les mobiles en mode portrait */
		echo'@media only screen and (max-width:480px){
			
			p.has-background{padding: 1.25em 1.25em;}
		
		}';
		
		
		/*----------------------------Style Card front end------------------------------*/
				
		if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_card_paragraph_radio_field'] == 'yes' ) {
			
			echo'p.is-style-eccp-card{';
							
				echo'box-shadow: 0 2px 1px -1px rgba(0,0,0,.2), 0 1px 1px 0 rgba(0,0,0,.14), 0 1px 3px 0 rgba(0,0,0,.12);';
				echo'border-radius: 4px;';
				echo'background: #F0F2F6;';
				echo'padding: 16px 16px 16px 16px;';

			echo'}';
					
			echo'p.is-style-eccp-card.has-background{';
			
				echo'padding: 16px 16px 16px 16px!important;';
			
			echo'}';
		
		}
		
		/*----------------------------Style Notice: question front end------------------------------*/
		
		// substr retourne une sous chaine de la position:1 jusqu'a la fin				
		$icone_color_notice_question = substr($custom_gutenberg_blocks_settings['eccp_settings_icon_color_style_notice_question_text_field'],1);
				
		
		if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_question_radio_field'] == 'yes' ) {
				
					// Version 2.7 modif pour le block Group
					echo'p.is-style-eccp-notice-question,
					     .wp-block-group.is-style-eccp-notice-question{';
					
							echo'background: #e6e0f7 url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'24px\' viewBox=\'0 0 24 24\' width=\'24px\' fill=\'%23'.esc_html($icone_color_notice_question).'\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M11 18h2v-2h-2v2zm1-16C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm0-14c-2.21 0-4 1.79-4 4h2c0-1.1.9-2 2-2s2 .9 2 2c0 2-3 1.75-3 5h2c0-2.25 3-2.5 3-5 0-2.21-1.79-4-4-4z\'/%3E%3C/svg%3E") no-repeat!important;';
							echo'background-size: 50px!important;';
							echo'min-height: 60px;';
							echo'background-position: top 20px left 10px!important;';
							echo'border-left: 4px solid rgba(0, 0, 0, 0.1);';
							echo'border-radius: 5px;';
							echo'padding: 16px 16px 16px 75px!important;';// Version 2.7 modif pour le block Group

					echo'}';
					
					// Version 2.7 modif pour le block Group
					echo'.wp-block-group.is-style-eccp-notice-question p,
					     .wp-block-group.is-style-eccp-notice-question h3,
						 .wp-block-group.is-style-eccp-notice-question h4{';
					
						echo'margin:0;';
					
					echo'}';
					
					echo'p.is-style-eccp-notice-question.has-background{';
					
					
						echo'padding: 16px 16px 16px 75px!important;';

					
					echo'}';
					
		}
		
		/*----------------------------Style Notice: info front end------------------------------*/
		
		// substr retourne une sous chaine de la position:1 jusqu'a la fin				
		$icone_color_notice_info = substr($custom_gutenberg_blocks_settings['eccp_settings_icon_color_style_notice_info_text_field'],1);
				
		
		if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_info_radio_field'] == 'yes' ) {
				
					// Version 2.7 modif pour le block Group
					echo'p.is-style-eccp-notice-info,
					     .wp-block-group.is-style-eccp-notice-info{';
					
							echo'background: #48ADD8 url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'24px\' viewBox=\'0 0 24 24\' width=\'24px\' fill=\'%23'.esc_html($icone_color_notice_info).'\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M11 7h2v2h-2zm0 4h2v6h-2zm1-9C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z\'/%3E%3C/svg%3E") no-repeat!important;';
							echo'color: #FFFFFF;';
							echo'background-size: 50px!important;';
							echo'min-height: 60px;';
							echo'background-position: top 20px left 10px!important;';
							echo'border-left: 4px solid rgba(0, 0, 0, 0.1);';
							echo'border-radius: 5px;';
							echo'padding: 16px 16px 16px 75px!important;';//Modif pour le block Group

					echo'}';
					
					// Version 2.7 modif pour le block Group
					echo'.wp-block-group.is-style-eccp-notice-info p,
					     .wp-block-group.is-style-eccp-notice-info h3,
						 .wp-block-group.is-style-eccp-notice-info h4{';
					
						echo'margin:0;';
					
					echo'}';
					
					echo'p.is-style-eccp-notice-info.has-background{';
					
					
						echo'padding: 16px 16px 16px 75px!important;';

					
					echo'}';
					
		}
		
		/*----------------------------Style Notice: Advice front end------------------------------*/
		
		// substr retourne une sous chaine de la position:1 jusqu'a la fin				
		$icone_color_notice_advice = substr($custom_gutenberg_blocks_settings['eccp_settings_icon_color_style_notice_advice_text_field'],1);
				
		
		if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_advice_radio_field'] == 'yes' ) {
				
					// Version 2.7 modif pour le block Group
					echo'p.is-style-eccp-notice-advice,
					     .wp-block-group.is-style-eccp-notice-advice{';
					
							echo'background: #83BD71 url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'24px\' viewBox=\'0 0 24 24\' width=\'24px\' fill=\'%23'.esc_html($icone_color_notice_advice).'\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\' opacity=\'.87\'/%3E%3Cpath d=\'M21 8h-6.31l.95-4.57.03-.32c0-.41-.17-.79-.44-1.06L14.17 1 7.59 7.59C7.22 7.95 7 8.45 7 9v10c0 1.1.9 2 2 2h9c.83 0 1.54-.5 1.84-1.22l3.02-7.05c.09-.23.14-.47.14-.73v-2c0-1.1-.9-2-2-2zm0 4l-3 7H9V9l4.34-4.34L12.23 10H21v2zM1 9h4v12H1z\'/%3E%3C/svg%3E") no-repeat!important;';
							echo'color: #FFFFFF;';
							echo'background-size: 50px!important;';
							echo'min-height: 60px;';
							echo'background-position: top 20px left 10px!important;';
							echo'border-left: 4px solid rgba(0, 0, 0, 0.1);';
							echo'border-radius: 5px;';
							echo'padding: 16px 16px 16px 75px!important;';// Version 2.7 modif pour le block Group

					echo'}';
					
					// Version 2.7 modif pour le block Group
					echo'.wp-block-group.is-style-eccp-notice-advice p,
					     .wp-block-group.is-style-eccp-notice-advice h3,
						 .wp-block-group.is-style-eccp-notice-advice h4{';
					
						echo'margin:0;';
					
					echo'}';
					
					echo'p.is-style-eccp-notice-advice.has-background{';
					
					
						echo'padding: 16px 16px 16px 75px!important;';

					
					echo'}';
					
		}
		
		/*----------------------------Style Notice: Warning front end------------------------------*/
		
		// substr retourne une sous chaine de la position:1 jusqu'a la fin				
		$icone_color_notice_warning = substr($custom_gutenberg_blocks_settings['eccp_settings_icon_color_style_notice_warning_text_field'],1);
				
		
		if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_warning_radio_field'] == 'yes' ) {
				
					// Version 2.7 modif pour le block Group
					echo'p.is-style-eccp-notice-warning,
					     .wp-block-group.is-style-eccp-notice-warning{';
					
							echo'background: #FFC334 url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'24px\' viewBox=\'0 0 24 24\' width=\'24px\' fill=\'%23'.esc_html($icone_color_notice_warning).'\'%3E%3Cpath d=\'M12 5.99L19.53 19H4.47L12 5.99M12 2L1 21h22L12 2zm1 14h-2v2h2v-2zm0-6h-2v4h2v-4z\'/%3E%3C/svg%3E") no-repeat!important;';
							echo'color: #FFFFFF;';
							echo'background-size: 50px!important;';
							echo'min-height: 60px;';
							echo'background-position: top 20px left 10px!important;';
							echo'border-left: 4px solid rgba(0, 0, 0, 0.1);';
							echo'border-radius: 5px;';
							echo'padding: 16px 16px 16px 75px!important;';// Version 2.7 modif pour le block Group

					echo'}';
					
					// Version 2.7 modif pour le block Group
					echo'.wp-block-group.is-style-eccp-notice-warning p,
					     .wp-block-group.is-style-eccp-notice-warning h3,
						 .wp-block-group.is-style-eccp-notice-warning h4{';
						 
						echo'margin:0;';
					
					echo'}';
					
					echo'p.is-style-eccp-notice-warning.has-background{';
					
					
						echo'padding: 16px 16px 16px 75px!important;';

					
					echo'}';
					
		}
		
		/*----------------------------Style Notice: Alert front end------------------------------*/
		
		// substr retourne une sous chaine de la position:1 jusqu'a la fin				
		$icone_color_notice_alert = substr($custom_gutenberg_blocks_settings['eccp_settings_icon_color_style_notice_alert_text_field'],1);
				
		
		if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_notice_alert_radio_field'] == 'yes' ) {
				
					// Version 2.7 modif pour le block Group
					echo'p.is-style-eccp-notice-alert,
					     .wp-block-group.is-style-eccp-notice-alert{';
					
							echo'background: #B54D4D url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'24px\' viewBox=\'0 0 24 24\' width=\'24px\' fill=\'%23'.esc_html($icone_color_notice_alert).'\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M15.73 3H8.27L3 8.27v7.46L8.27 21h7.46L21 15.73V8.27L15.73 3zM19 14.9L14.9 19H9.1L5 14.9V9.1L9.1 5h5.8L19 9.1v5.8z\'/%3E%3Ccircle cx=\'12\' cy=\'16\' r=\'1\'/%3E%3Cpath d=\'M11 7h2v7h-2z\'/%3E%3C/svg%3E") no-repeat!important;';
							echo'color: #FFFFFF;';
							echo'background-size: 50px!important;';
							echo'min-height: 60px;';
							echo'background-position: top 20px left 10px!important;';
							echo'border-left: 4px solid rgba(0, 0, 0, 0.1);';
							echo'border-radius: 5px;';
							echo'padding: 16px 16px 16px 75px!important;';// Version 2.7 modif pour le block Group

					echo'}';
					
					// Version 2.7 modif pour le block Group
					echo'.wp-block-group.is-style-eccp-notice-alert p,
					     .wp-block-group.is-style-eccp-notice-alert h3,
						 .wp-block-group.is-style-eccp-notice-alert h4{';
						 
						echo'margin:0;';
					
					echo'}';
					
					echo'p.is-style-eccp-notice-alert.has-background{';
					
					
						echo'padding: 16px 16px 16px 75px!important;';

					
					echo'}';
					
		}
		
		
		/*--------------------- Style Click to Tweet Front End ---------------------------*/

		if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_click_to_tweet_radio_field'] == 'yes' ) {

			// Bloc paragraphe de style ECCP Tweet
			echo'p.is-style-eccp-tweet {';
			
				echo'font-size: 25px;';
				echo'line-height:1.5em;';
				echo'border: 1px solid #f2f0f2;';
				echo'box-shadow: 0 2px 4px 2px rgb(0 0 0 / 10%);';
				echo'margin-bottom: 1.5em;';
				echo'margin-top: 1.5em;';
				echo'border-radius: 4px;';
				
			echo'}';


			// on récupère le thème actif
			$my_theme = wp_get_theme();
	
			// Modif pour le thème oceanWP 
			if(stristr($my_theme, 'oceanwp')) {
				
				// Bloc paragraphe de style ECCP Tweet
				echo'p.is-style-eccp-tweet {';
				
					echo'padding: 3rem 3rem;';
					
				echo'}';
				
			}else{
				
				// Bloc paragraphe de style ECCP Tweet
				echo'p.is-style-eccp-tweet {';
				
					echo'padding: 2rem 2rem;';
					
				echo'}';
				
			}


			// Bouton Click To Tweet
			echo'.eccp-tweet-button {';
				
				echo'display: block;';
				echo'float: right;';
				echo'font-size: 0.8em;';
				echo'font-weight: 600;';
				echo'padding: 8px 12px;';
				echo'text-decoration: unset!important;';
				echo'color: #fff!important;';
				echo'background-color: #1da1f2!important;';
				echo'border-color: #1a91da!important;';
				echo'border: 1px solid;';
				echo'border-radius: 4px;';
				echo'padding: 8px 12px;';
				
			echo'}';
			
			// Bouton Click To Tweet au survol
			echo'.eccp-tweet-button:hover {';
				
				echo'color: #fff;';
				echo'background-color: #1da1f2;';
				echo'border-color: #1a91da;';
				echo'border: 1px solid;';
				echo'border-radius: 4px;';
				echo'padding: 8px 12px;';
				
			echo'}';
			
			
			// alignement vertical de l'icône du bouton
			echo'.eccp-tweet-button span.dashicons {';
				
				echo'line-height:unset;';
				
			echo'}';
			
		
		
		}
		
		
		/*--------------------- Style Evidence Front End ---------------------------*/		

		// Bloc paragraphe de style Evidence
		// la couleur de la bordure est la même
		// que le bloc réutilisable mettre en évidence
		echo'p.is-style-eccp-evidence {';
		
			/* bordure colorée orange #F37020 avec une transparence */
			echo'border-left: 5px solid '.esc_html($reusable_blocks_settings['eccp_settings_custom_paragraph_border_color']).';';
			/* couleur de fond jaune pale */
			echo'background:rgba(243,230,114,0.7);';
			echo'border-radius:4px;';
			echo'box-shadow: 8px 8px 12px -8px rgba(0,0,0,0.5);';
			echo' padding:1.1em!important;';
			echo' margin:1.1em;';
			echo' font-size: 20px;';
			
		echo'}';
		
		
		/*---------------------- Style pour le format Tooltip Front End -------------------------*/
		
		/*
		Régles pour la balise <span> de classe eccp-tooltip qui 
		a l'attribut data-tooltip qui contient le message pour 
		l'info-bulle
		*/
		echo'.eccp-tooltip {';
			echo'position: relative;';
		  /* dotted ou double */
			echo'text-decoration: underline double 2px '.$custom_gutenberg_blocks_settings['eccp_settings_text_double_underline_color_text_field'].';';
		echo'}';

		/*
		container du message de l'info bulle  

		On affiche le message par la règle
		content et l'attribut data-tooltip de la balise
		<span> qui contient le message pour l'info-bulle.
		on affiche l'info-bulle au dessus et au mileu
		de la balise <span> grace a la translation
		sur l'axe X de -50%
		On calcule la position appropriée en soustrayant 
		à la largeur totale de l'élément de message (100%), 
		10 pixels supplémentaires. 
		C'est à cette distance que le message 
		est éloigné de la balise <span>
		*/
		
		echo'.eccp-tooltip:hover::after  {';
		  echo'background-color:'.$custom_gutenberg_blocks_settings['eccp_settings_tooltip_background_color_text_field'].';';
		  echo'border-radius: 8px;';
		  echo'color:'.$custom_gutenberg_blocks_settings['eccp_settings_tooltip_text_color_text_field'].';';
		  echo'padding: 6px 6px;';
		  echo'position: absolute;';
		  echo'text-align: center;';
		  echo'z-index: 999;';
		  echo'width:200px;';
		  echo'font-size:14px;';
		  echo'font-weight:normal;';
		  echo'line-height:1.5;';
		  
		  echo'content:attr(data-tooltip);';
		  echo'top: 0;';
		  echo'left: 50%;';
		  echo'transform: translate(-50%, calc(-100% - 10px));';
		echo'}';
	

		/*
		afficher une petite flèche vers le parent balise <span> 
		depuis la boîte de message info-bulle 

		Fondamentalement,ce sera un simple carré qui sera tourné de 45 degrés, 
		puis la moitié du carré sera masquée par la boîte de message réelle 
		créant une flèche. 
		De plus, on doit positionner correctement la flèche, 
		pour cela on doit prendre en considération que la moitié du carré 
		doit être couverte afin de créer la flèche, 
		pour cela on change le 10px décalage ci-dessus en seulement 5px
		*/
		
		echo'.eccp-tooltip:hover::before {';
		  echo'background-color:'.$custom_gutenberg_blocks_settings['eccp_settings_tooltip_background_color_text_field'].';';
		  echo'content:"";';
		  echo'position: absolute;';
		  echo'z-index: 999;';
		  
		  echo'top: 0;';
		  echo'left: 50%;';
		  echo'width: 15px;';
		  echo'height: 15px;';
		  echo'transform: translate(-50%, calc(-100% - 5px)) rotate(45deg);';
		echo'}';

		
		/*---------------------------- Largeur Paragraphe Front End ------------------------------*/
		
		echo'@media (min-width:768px) {';
		
			echo'p.is-style-eccp-size-very-small{';
									
				echo'width: 50%!important;';
		
			echo'}';
			
			echo'p.is-style-eccp-size-small{';
									
				echo'width: 60%!important;';
		
			echo'}';
			
			echo'p.is-style-eccp-size-regular{';
							
				echo'width: 70%!important;';
		
			echo'}';
			
			echo'p.is-style-eccp-size-large{';
							
				echo'width: 80%!important;';
		
			echo'}';
			
			echo'p.is-style-eccp-size-larger{';
							
				echo'width: 90%!important;';
		
			echo'}';
		
		echo'}';
		
		
		/*---------- Style Contour Pour l'Icône Dashicon Ajouté au bloc paragraphe front end ----------------*/
		
		
		
		echo'body.single p .eccp-dashicon.icon-outline:before, 
			 body.page p .eccp-dashicon.icon-outline:before {';
			
			echo'outline-style: solid;';
			echo'outline-offset: 0.75rem;';
			echo'outline-color: inherit;';
			echo'outline-width: 4px;';
			echo'border-radius: 50%;';
			
		echo'}';

		
		/*------------------- BLOC GROUP FRONT END --------------------------*/
		
		
		// version 2.4 correction pour thème astra
		// Padding & Margin réglages natif à partir de WordPress 6.0
		echo'.wp-block-group {';
			echo'padding: 1.25em 2.375em;';
			echo'margin:0 0 1.2em 0;';
		echo'}';
		
		
		// BLOC GROUPER AVEC UN FOND 
		// padding: 20px 30px valeur par défaut de padding en interface publique 
		// correspondant a celles de l'éditeur Gutenberg 
		/* Margin réglages natif à partir de WordPress 6.0
		echo'.wp-block-group.has-background{
		  
		  margin: 20px 0;
			 
		}';
		*/
		
		// correction thème Generate Press pour un bloc de paragraphe groupés
		echo'.wp-block-group__inner-container{';
		
			echo'padding:0px!important;';
		
		echo'}';
				
		/*---------------------------- Largeur Bloc Group Front End ------------------------------*/
				
		// version 2.4 correction pour thème Astra
		// sélecteur body.page & body.single
		echo'@media (min-width:1025px) {';
		
			echo'body.page .is-style-eccp-size-very-small.wp-block-group,
			     body.single .is-style-eccp-size-very-small.wp-block-group{';
												
				echo'width: 50%!important;';
		
			echo'}';
		
			echo'body.page .is-style-eccp-size-small.wp-block-group,
			     body.single .is-style-eccp-size-small.wp-block-group{';
												
				echo'width: 60%!important;';
		
			echo'}';
			
			echo'body.page .is-style-eccp-size-regular.wp-block-group,
			     body.single .is-style-eccp-size-regular.wp-block-group{';
				 		
				echo'width: 70%!important;';
		
			echo'}';
			
			echo'body.page .is-style-eccp-size-large.wp-block-group,
			     body.single .is-style-eccp-size-large.wp-block-group{';
									
				echo'width: 80%!important;';
		
			echo'}';
			
			echo'body.page .is-style-eccp-size-larger.wp-block-group,
			     body.single .is-style-eccp-size-larger.wp-block-group{';
							
				echo'width: 90%!important;';
		
			echo'}';
		
		echo'}';
		
		
		// régle pour les mobiles
		echo'@media (max-width:480px) {';
		
			echo'body.page .wp-block-group,
			     body.single .wp-block-group{';
									
				echo'margin-right: 0;';
				echo'width: 100%;';
		
			echo'}';
		
		echo'}';
		
		
		/*---------------------------- Border Radius ------------------------------*/
			
		/* appliqué directement par une régle style
		   enregistré dans le HTML du bloc a partir de la version 2.5 
		echo'.is-style-eccp-border-radius{';
			echo'border-radius: 8px;';
		echo'}';
		*/
		
		/*---------------------------- Alignement Left & Right & Center Front End ------------------------------*/
		
		echo'@media (min-width:1025px) {';
		
			// Régles pour alignement à gauche
			echo'.wp-block-group.alignleft.is-style-eccp-size-larger {';
				/*comme le block groupe a une largeur a 90%
			   dans les paramètres du block panneau ECCP Style
			   si on met une marge droite de 10% au block qui a un style floattant a gauche
			   on est sur que le block suivant ne va pas remonter*/
				echo'margin-right: 10%;';
			echo'}';

			echo'.wp-block-group.alignleft.is-style-eccp-size-large {';
				echo'margin-right: 20%;';
			echo'}';

			echo'.wp-block-group.alignleft.is-style-eccp-size-regular {';
				echo'margin-right: 30%;';
			echo'}';

			echo'.wp-block-group.alignleft.is-style-eccp-size-small {';
				echo'margin-right: 40%;';
			echo'}';
			
			echo'.wp-block-group.alignleft.is-style-eccp-size-very-small {';
				echo'margin-right: 50%;';
			echo'}';
			
			
			// Régles pour alignement centré
			echo'.wp-block-group.aligncenter.is-style-eccp-size-larger {';
				echo'margin-bottom: 1.5em!important;';
			echo'}';
			
			echo'.wp-block-group.aligncenter.is-style-eccp-size-large {';
				echo'margin-bottom: 1.5em!important;';
			echo'}';

			echo'.wp-block-group.aligncenter.is-style-eccp-size-regular {';
				echo'margin-bottom: 1.5em!important;';
			echo'}';

			echo'.wp-block-group.aligncenter.is-style-eccp-size-small {';
				echo'margin-bottom: 1.5em!important;';
			echo'}';
			
			echo'.wp-block-group.aligncenter.is-style-eccp-size-very-small {';
				echo'margin-bottom: 1.5em!important;';
			echo'}';
			
			
			// Régles pour alignement à droite
			echo'.wp-block-group.alignright.is-style-eccp-size-larger {';
				echo'margin-left: 10%;';
			echo'}';

			echo'.wp-block-group.alignright.is-style-eccp-size-large {';
				echo'margin-left: 20%;';
			echo'}';

			echo'.wp-block-group.alignright.is-style-eccp-size-regular {';
				echo'margin-left: 30%;';
			echo'}';

			echo'.wp-block-group.alignright.is-style-eccp-size-small {';
				echo'margin-left: 40%;';
			echo'}';
			
			echo'.wp-block-group.alignright.is-style-eccp-size-very-small {';
				echo'margin-left: 50%;';
			echo'}';
				
		
		echo'}';
		
		/*---------------------------- Style Variation InfoBox Front End ------------------------------*/
		
		
		echo'.is-style-eccp-infobox.wp-block-group {';
			echo'padding: 1.25em!important;';
			echo'background: #F0F2F6;';
			echo'margin-bottom: 1.3em!important;;';
		echo'}';


		echo'.is-style-eccp-infobox .wp-block-columns {';
			echo'margin-bottom: 0em!important;';
		echo'}';


		echo'.is-style-eccp-infobox .wp-block-button__link {';
		   echo'margin-bottom: 0em!important;';
		echo'}';

		// le point de rupture de Gutenberg pour un empilement des colonnes
		// sur mobile est de 599px
		// On réduit l'espacement des colonnes
		// On supprime les marges pour le bloc groupe & texte & image
		// On centre le texte et le bouton 
		echo'@media screen and (max-width: 599px) {';
		
			// on réduit l'espacement des colonnes
			echo'body.page .wp-block-group.is-style-eccp-infobox .wp-block-columns,
				 body.single .wp-block-group.is-style-eccp-infobox .wp-block-columns {';
				 echo'gap: 1em;';
			echo'}';
		
			// on annulle marges paragraphe
			echo'body.page .is-style-eccp-infobox p,
				 body.single .is-style-eccp-infobox p {';
				echo'text-align: center!important;';
				// pour thème Astra
				echo'margin: 0 0 20px;';
			echo'}';
			
			// on annulle marges image
			echo'body.page .wp-block-group.is-style-eccp-infobox .wp-block-image,
				 body.single .wp-block-group.is-style-eccp-infobox .wp-block-image {';
				 echo'margin-top: 0!important;';
				 echo'margin-bottom: 0!important;';
			echo'}';
			
			// on centre le bouton
			echo'body.page .is-style-eccp-infobox .wp-block-button,
				 body.single .is-style-eccp-infobox .wp-block-button {';
				echo'margin: 0!important;';
				echo'float:none!important;';
			echo'}';
			
			// on centre le bouton
			echo'body.page .is-style-eccp-infobox .wp-block-button__link,
				 body.single .is-style-eccp-infobox .wp-block-button__link{';
				echo'display: block!important;';
				echo'margin: auto!important;';
			echo'}';
			
		echo'}';
		
		// on supprime les marges apportées par WordPress
		echo'@media screen and (max-width: 781px) {';
		
			// on supprime les marges apportées par le theme
			echo'body.page .wp-block-group.is-style-eccp-infobox,
				 body.single .wp-block-group.is-style-eccp-infobox {';
				echo'margin: 0;';
			echo'}';
			
			echo'.is-style-eccp-infobox .wp-block-column {';
				echo'margin-bottom: 0em!important;';
			echo'}';
			
			echo'.is-style-eccp-infobox h2,.is-style-eccp-infobox h3,
				 .is-style-eccp-infobox h4,.is-style-eccp-infobox h5 {';
				echo'margin: 0em!important;';
			echo'}';
			
		echo'}';
		
		
		echo'@media (min-width: 600px) and (max-width: 781px) {';
			  
			  // on inhibe pour la 1ère colonne la régle flex-basis: 100% établi par Gutenberg  
			  // jusqu'a une résolution de 768px qui a pour conséquence que les colonnes s'empilent
			  echo'body.page .wp-block-group.is-style-eccp-infobox .wp-block-column:first-child,
                   body.single .wp-block-group.is-style-eccp-infobox .wp-block-column:first-child {';
				echo'flex-basis: 66.66%!important;';
			  echo'}';
			  
			  // on inhibe pour la 2ème colonne la régle flex-basis: 100% établi par Gutenberg  
			  // jusqu'a une résolution de 768px qui a pour conséquence que les colonnes s'empilent
			  echo'body.page .wp-block-group.is-style-eccp-infobox .wp-block-column:nth-child(2),
                   body.single .wp-block-group.is-style-eccp-infobox .wp-block-column:nth-child(2) {';
				echo'flex-basis: 33.33%!important;';
			  echo'}';
			  
			  // flex-flow est une propriété raccourcie pour les propriétés flex-direction et flex-wrap
			  // flex-direction: les containers sont placé en ligne:row 
			  // flex-wrap: les éléments flexibles sont contraints à être disposés sur une seule ligne: nowrap
			  // sans retour a la ligne possible
			  echo'body.page .wp-block-group.is-style-eccp-infobox .wp-block-columns,
                   body.single .wp-block-group.is-style-eccp-infobox .wp-block-columns {';
				echo'flex-flow: row nowrap!important;';
			  echo'}';
		
		echo'}';
		
		
		/*----------------------- Style Variation Countdown Timer Front End ---------------------------*/
		
		/* Balisage de la liste a puce container du compte a rebours 
			<ul id="countdown">
				<li>
					<p class="timeRefWeeks">Semaines</p>
					<span class="weeks">09</span>
				</li>
				<li>
				<p class="timeRefDays">Jours</p>
				<span class="days">00</span>
				</li>
			</ul>
		*/

		// style par défaut de la variation du bloc groupe
		// container principal du compte a rebours
		echo'body.page .wp-block-group.is-style-eccp-countdown,
		     body.single .wp-block-group.is-style-eccp-countdown {';
		
			echo'box-shadow:0px 0px 4px 1px rgba(0,0,0,0.2);';
			echo'padding:1em 1em;';
			echo'margin-bottom:1.5em;';
			
		echo'}';
		
		// on supprime les marges de la liste a puce
		// container du compte a rebours
		echo'body.page .wp-block-group.is-style-eccp-countdown ul,
			 body.single .wp-block-group.is-style-eccp-countdown ul {';
			echo'margin: 0 0 1em 0!important;';
		echo'}';
		
		// Paragraphe d'intro du compte a rebours
		echo'body.page .wp-block-group.is-style-eccp-countdown p,
		     body.single .wp-block-group.is-style-eccp-countdown p {';
		
			echo'margin-bottom:20px!important';
			
		echo'}';
		
		// on centre la liste a puce donc le compte a rebours dans le bloc groupe
		echo'ul#countdown {';
			echo'text-align:center;';
			echo'display:flex;';
			echo'align-items:center;';
			echo'justify-content:center;';
			echo'flex-wrap: wrap;';
			echo'gap:1em;';
		echo'}';
		 
		// syle compte a rebours: dimensionnement,arrière plan etc..
		echo'ul#countdown li {';
		
			echo'color:#fff;';
			echo'display: inline-block;';
			echo'padding:0.1em;';
			echo'width: 100px;';
			echo'height: 90px;';
			echo'-webkit-border-radius: 10px;';
			echo'-moz-border-radius: 10px;';
			echo'border-radius: 10px;';
			echo'background: #333333;';
			echo'-webkit-box-shadow: 0px 0px 4px 1px rgba(50, 50, 50, 0.6);';
			echo'-moz-box-shadow: 0px 0px 4px 1px rgba(50, 50, 50, 0.6);';
			echo'box-shadow: 0px 0px 4px 1px rgba(50, 50, 50, 0.6);';
			
		echo'}';
		
		// paragraphe texte: Semaines ou Jours
		echo'ul#countdown li p.timeRefDays,ul#countdown li p.timeRefHours,
			 ul#countdown li p.timeRefMinutes,ul#countdown li p.timeRefSeconds{';
			echo'text-shadow: 1px 1px 2px rgba(150, 150, 150, 1);';	
		echo'}';
		
		// Nombre de jours ou semaines
		echo'ul#countdown li span {';
		
			echo'font-size: 42px;';
			echo'font-weight: bold;';
			echo'color: #fff;';
			echo'text-shadow: 1px 1px 2px rgba(150, 150, 150, 1);';
			echo'position: relative;';
			echo'top: -40px;';
			
		echo'}';
		 
		// modification positionnement indicateur
		// compte a rebours selon les thèmes
		switch ($my_theme) {
			
			// correction theme Generate Press
			case stristr($my_theme, 'generatepress'):
			
				echo'ul#countdown li {';
					echo'padding:0.3em;';	
				echo'}';
				
				echo'ul#countdown li span {';
					echo'top: -30px;';
				echo'}';
				
			break;
				
				
			// correction theme Divi
			case stristr($my_theme, 'divi'):
			
				// on supprime les marges de la liste a puce
				// container du compte a rebours
				echo'body.page .wp-block-group.is-style-eccp-countdown ul,
					 body.single .wp-block-group.is-style-eccp-countdown ul {';
					echo'margin:0!important;';
					echo'padding: 0 0 23px 0!important;';
				echo'}';
			
				echo'ul#countdown li {';
					echo'padding:0.3em;';	
				echo'}';
			
				echo'ul#countdown li span {';
					echo'top: -10px;';
				echo'}';
		
			break;
			
			// correction theme Astra
			case stristr($my_theme, 'astra'):
							
				echo'ul#countdown li span {';
					echo'top: -20px;';
				echo'}';
		
			break;
			
			
		}
		
		
		// Régles pour les mobiles
		echo'@media (max-width:480px){';
		
			echo'ul#countdown {';
				
			echo'}';
		
		echo'}';
		
		/*-----------  Style Table Of Contents Front End -------------------*/ 
		
		// On masque en Front End la balise <pre> du bloc code 
		// qui permet de renseigner en back office un intitulé Table Des Matières
		// on utilise un bloc code pour éviter que l'intitulé soit repris
		// dans le résumé apparaissant dans le bloc boucle de requête
		// ou Derniers Articles
		echo'body.page .wp-block-group.is-style-eccp-toc pre.wp-block-code,
			 body.single .wp-block-group.is-style-eccp-toc pre.wp-block-code {';
			echo'display:none!important;';
		echo'}';
		
		
		// on supprime l'affichage de la table des matières
		// sur la page Blog et Catégories
		echo'body.blog .is-style-eccp-toc,body.category .is-style-eccp-toc {';
			echo'display: none;';
		echo'}';
		
		// bloc Groupe container de la table des matières
		echo'body.page .wp-block-group.is-style-eccp-toc,
			 body.single .wp-block-group.is-style-eccp-toc 	{';
			echo'padding: 0!important;';
			echo'margin-bottom: 1.1em;';
			
		echo'}';
		
		// bloc Groupe container de la table des matières
		// bordure gris léger dans le cas ou il n'ya pas de couleur
		// d'arrière plan
		echo'body.page .wp-block-group.is-style-eccp-toc:not(.has-background),
			 body.single .wp-block-group.is-style-eccp-toc:not(.has-background) 	{';
			echo'border: 1px solid lightgray';
		echo'}';
		
		/* DIV container principal de la table des matières */
		echo'.eccp-toc {';
		  echo'display: flex;';
		  echo'flex-direction: column;';
		  /* pour un alignement gauche thème Astra */
		  echo'margin-top: 0!important;';
		echo'}';

		/* 
		on initialise le curseur a un pointer
		pour indiquer que l'élément est cliquable
		et on inhibe la sélection de l'intitulé
		*/
		echo'.eccp-toc  summary {';
		  echo'cursor: pointer;';
		  echo'user-select: none;';
		echo'}';

		/* 
		Balise details qui affiche ou masque son contenu
		selon la valeur de l'attribut open ou close
		*/
		echo'.eccp-toc details {';
			echo'padding: 1em;';
		echo'}';

		// Titre de la table des matières
		echo'.eccp-toc summary {';
			echo'color:'.$custom_gutenberg_blocks_settings['eccp_settings_title_color_table_of_contents_text_field'].';';
			echo'font-size: 18px;';
			echo'font-weight:600;';
		echo'}';

		/* 
		espace entre la balise navigation 
		et la liste du sommaire
		*/
		echo'.eccp-toc nav {';
		  echo'margin-block-start: 1rem;';
		echo'}';

		/*
		on masque le petit triangle horizontal
		qui est le contrôle utilisé par la balise détails
		afin d'indiquer si son contenu est révélé ou non
		*/
		echo'.eccp-toc details > summary::-webkit-details-marker,
             .eccp-toc details > summary::marker {';
		  echo'display: none!important;';
		echo'}';
		
		echo'.eccp-toc details summary {';
		  echo'list-style: none!important;';
		echo'}';


		/* 
		icone dashicons flêche vers le bas 
		pour la balise détails fermé
		*/
		echo'.eccp-toc details summary::after {';
			echo'content: "\f347";';
			echo'font-family: "dashicons";';
			echo'float:right;';
		echo'}';

		/* 
		icone dashicons flêche vers le haut 
		pour la balise détails ouverte
		*/
		echo'.eccp-toc details[open] summary::after {';
			echo'content: "\f343";';
			echo'font-family: "dashicons";';
			echo'float:right;';
		echo'}';

		/* espacement entre les items de la liste */
		echo'body.single .eccp-toc ol,body.page .eccp-toc ol{';
			  echo'margin: 5px 0px 5px 20px!important;';
			  echo'padding: 0!important;';
		echo'}';
		   
		/* lien des items de la liste */
		echo'.is-style-eccp-table-of-contents-bullet-list a {';
			 echo'text-decoration: none!important;';
			 echo'color: currentcolor!important;';
			 echo'font-weight: inherit!important;';
		echo'}';


		if( $custom_gutenberg_blocks_settings['eccp_settings_activate_underline_table_of_contents_links_on_hover_radio_field'] == 'yes' ) {
		
			/* On souligne les Liens de la table des matières au survol */
			echo'.is-style-eccp-table-of-contents-bullet-list a:hover {';
				 echo'color: currentcolor!important;';
				 echo'background: linear-gradient(180deg,transparent 75%,rgba(25,133,255,0.3) 0);';
			echo'}';
		
		}

		/*
		Le style le plus courant pour une table des matières 
		est une liste numérotée ordinale
		Le lien vers le premier h2 porte le numéro 1 . 
		Le lien vers le second h2 reçoit le numéro 2 , 
		le premier h3 étant le numéro 2.1 , et ainsi de suite.
		le style par défaut des listes ordonnées imbriquées 
		fait que la numérotation redémarre pour chaque liste
		Pour y palier on utilise des compteurs CSS pour numéroter 
		les éléments comme on le souhaite. 
		*/
		echo'.eccp-toc ol {';
			
			/* on supprime les numéros existants de notre liste */
			echo'list-style-type: none!important;';
			
			/* Pour utiliser un compteur, il doit d'abord être initialisé 
			   avec la counter-reset propriété et on le nomme toc-counter
			   Par défaut, les compteurs ont une valeur initiale de 0 et 
			   comptent à partir de la valeur initiale*/
			
			echo'counter-reset: toc-counter;';
		echo'}';
		
		// on force la prise en compte de la taille de caractère
		// personnalisé définit dans l'editeur Gutenberg
		// pour la liste ordonnée de la table des matières
		echo'.eccp-toc ol li {';
		 echo'font-size:inherit!important;';
		echo'}';

		echo'.eccp-toc ol li::before {';
			
		  /* On affiche le compteur formaté selon notre style ordinal 
			 pour la counter() fonction on utilise la forme
			counters(<nom-compteur>, <separateur>, <style-compteur>)
			pour le style-compteur on ajoute deux espaces à la fin du texte 
			du compteur qui séparera le nombre du contenu textuel de l'élément de liste */
		  
		  echo'content: counters(toc-counter, ".") "  ";'; 

		/* on incrémente le compteur */
		  echo'counter-increment: toc-counter;';
		  
		  echo'font-weight: inherit!important;';
		  
		echo'}';		


		/* Défilement fluide vers les ancres */
		echo'html {';
			echo'scroll-behavior: smooth;';
		echo'}';

		/* décalage des ancres de navigation pour un en-tête fixe */
		echo'h2,h3,h4,h5,h6 {';
		  echo'scroll-margin-top:'.$custom_gutenberg_blocks_settings['eccp_settings_offset_navigation_anchors_text_field'].'px;';
		echo'}';
		
		
		/*-----------  Formes de séparation Front End -------------------*/ 
		
		/*
		 En ajoutant l'attribut préservationAspectRatio="none"
		 dans les proriétés du SVG, 
		 on peut définir une hauteur personnalisée.
		 Ce qui signifie aussi que la forme sera « déformée » 
		 pour garder la même hauteur.
		 grâce a la propriété css: -webkit-mask-image,
		 on va pouvoir appliquer une couleur d'arrière plan aux SVG.
		 Cette couleur d'arrière plan du SVG correspondra à la couleur
		 d'arrière plan de la publication excepté pour les styles:
		 • vagues avec opacité(waves opacity) 
		 • Inclinée avec opacité(Tilt Opacity) 
		 ces styles prennent la couleur d'arrière plan du bloc groupe.
		*/

		/* Le bloc groupe auquel on applique
		une forme de séparation a reçu en ReactJS la classe:
		.is-style-eccp-shape-divider */
		echo'.is-style-eccp-shape-divider {';
			echo'position: relative;';
		echo'}';


		/* ------------ Forme Inclinée(tilt) Front End -----------------------*/

		/* réglage de l'angle par la hauteur de 0 à 500px 
		inversion: transform: rotateY(180deg)
		la couleur de la forme doit être celui de l'arrière plan de la publication
		remarque width fait aussi varier l'angle*/
		echo'.is-style-eccp-shape-divider.style-shape-top-tilt::before {';
			echo'content: "";';
			echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M1200 120L0 16.48 0 0 1200 0 1200 120z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M1200 120L0 16.48 0 0 1200 0 1200 120z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'position: absolute;';
			echo'top: 0;';
			echo'left: 0;';
			echo'width: calc(var(--eccp-topShapeWidth,100)*1%);';
			echo'height: calc(var(--eccp-topShapeHeight,50)*1px);';
			echo'background-color: var(--eccp-topShapeBackgroundColor,#E6E8ED);';
			echo'z-index:1;';
		echo'}';

		// retournement horizontal 
		echo'.is-style-eccp-shape-divider.top-shape-flip-horizontally.style-shape-top-tilt::before {';
			echo'transform: rotateY(180deg);';
		echo'}';

		/* inversion: transform: rotateX(180deg) 
		 la couleur de la forme doit être celui de l'arrière plan de la publication*/
		echo'.is-style-eccp-shape-divider.style-shape-bottom-tilt::after {';
			echo'content: "";';
			echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M1200 120L0 16.48 0 0 1200 0 1200 120z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M1200 120L0 16.48 0 0 1200 0 1200 120z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'position: absolute;';
			echo'bottom: 0;';
			echo'left: 0;';
			echo'width: calc(var(--eccp-bottomShapeWidth,100)*1%);';
			echo'height: calc(var(--eccp-bottomShapeHeight,50)*1px);';
			echo'background-color: var(--eccp-bottomShapeBackgroundColor,#E6E8ED);';
			echo'transform: rotate(180deg);';
			echo'z-index:1;';
		echo'}';

		// retournement horizontal 
		echo'.is-style-eccp-shape-divider.bottom-shape-flip-horizontally.style-shape-bottom-tilt::after {';
			echo'transform: rotateX(180deg);';
		echo'}';

		/* ------------ Forme Inclinée avec opacité(tilt opacity) Front End -----------------------*/

		/* séparation Forme Inclinée avec opacité partie supérieure
		réglage dimmensions avec les propriétés height & top
		la couleur de la forme doit être celui de l'arrière plan de la publication
		inversion: transform: rotateX(180deg);';*/


		 echo'.is-style-eccp-shape-divider.style-shape-top-tilt-opacity::before {';
			echo'content: "";';
			echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 2600 131.1\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M0 0L2600 0 2600 69.1 0 0z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.5\' d=\'M0 0L2600 0 2600 69.1 0 69.1z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.25\' d=\'M2600 0L0 0 0 130.1 2600 69.1z\'%3E%3C/path%3E%3C/svg%3E");';
			echo'mask-image: url("data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 2600 131.1\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M0 0L2600 0 2600 69.1 0 0z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.5\' d=\'M0 0L2600 0 2600 69.1 0 69.1z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.25\' d=\'M2600 0L0 0 0 130.1 2600 69.1z\'%3E%3C/path%3E%3C/svg%3E");';
			echo'position: absolute;';
			echo'top: calc(var(--eccp-topShapeHeight,50)*-1px);';
			echo'left: 0;';
			echo'width: 100%;';
			echo'height: calc(var(--eccp-topShapeHeight,50)*1px);';
			echo'background-color: var(--eccp-topShapeBackgroundColor,#E6E8ED);';
			echo'transform: rotate(180deg);';
			echo'z-index:1;';
		echo'}';

		// retournement horizontal 
		echo'.is-style-eccp-shape-divider.top-shape-flip-horizontally.style-shape-top-tilt-opacity::before {';
			echo'transform: rotateX(180deg);';
		echo'}';

		/* séparation Forme Inclinée avec opacité partie inférieure
		réglage dimmensions avec les propriétés height & bottom
		inversion: transform: rotateY(180deg)*/
		echo'.is-style-eccp-shape-divider.style-shape-bottom-tilt-opacity::after {';
			echo'content: "";';
			echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 2600 131.1\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M0 0L2600 0 2600 69.1 0 0z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.5\' d=\'M0 0L2600 0 2600 69.1 0 69.1z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.25\' d=\'M2600 0L0 0 0 130.1 2600 69.1z\'%3E%3C/path%3E%3C/svg%3E");';
			echo'mask-image: url("data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 2600 131.1\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M0 0L2600 0 2600 69.1 0 0z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.5\' d=\'M0 0L2600 0 2600 69.1 0 69.1z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.25\' d=\'M2600 0L0 0 0 130.1 2600 69.1z\'%3E%3C/path%3E%3C/svg%3E");';
			echo'position: absolute;';
			echo'bottom:calc(var(--eccp-bottomShapeHeight,50)*-1px);';
			echo'left: 0;';
			echo'width: 100%;';
			echo'height: calc(var(--eccp-bottomShapeHeight,50)*1px);';
			echo'background-color: var(--eccp-bottomShapeBackgroundColor,#E6E8ED);';
			echo'z-index:1;';
		echo'}';

		// retournement horizontal 
		echo'.is-style-eccp-shape-divider.bottom-shape-flip-horizontally.style-shape-bottom-tilt-opacity::after {';
			echo'transform: rotateY(180deg);';
		echo'}';
		 

		/* ------------ Forme Flèche(Arrow) Front End -----------------------*/

		/* séparation Flèche partie supérieure
		réglage avec la propriété height 
		width permet d'excentrer la flêche vers la droite
		transform: translateX(-50%) de -10% a +50% permet de déplacer la fleche
		de gauche à droite
		la couleur de la forme doit être celui de l'arrière plan de la publication*/

		echo'.is-style-eccp-shape-divider.style-shape-top-arrow::before {';
			echo'content: "";';
			echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M649.97 0L550.03 0 599.91 54.12 649.97 0z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M649.97 0L550.03 0 599.91 54.12 649.97 0z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'position: absolute;';
			echo'top: 0;';
			echo'left: 0;';
			echo'width: calc(var(--eccp-topShapeWidth,100)*1%);';
			echo'height: calc(var(--eccp-topShapeHeight,50)*1px);';
			echo'background-color: var(--eccp-topShapeBackgroundColor,#E6E8ED);';
			echo'z-index:1;';
		echo'}';


		/* séparation Flèche partie inférieure
		réglage avec les propriétées transform, bottom , height
		pour la partie inférieure
		width permet d'excentrer la flêche vers la droite
		la couleur de la forme doit être celui de l'arrière plan de la publication*/ 
		echo'.is-style-eccp-shape-divider.style-shape-bottom-arrow::after {';
			echo'content: "";';
			echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M649.97 0L550.03 0 599.91 54.12 649.97 0z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M649.97 0L550.03 0 599.91 54.12 649.97 0z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'position: absolute;';
			echo'bottom: calc(var(--eccp-bottomShapeHeight,50)*-1px);';
			echo'left: 0;';
			echo'width: calc(var(--eccp-bottomShapeWidth,100)*1%);';
			echo'height: calc(var(--eccp-bottomShapeHeight,50)*1px);';
			echo'background-color: var(--eccp-bottomShapeBackgroundColor,#E6E8ED);';
			echo'transform: rotate(180deg) translateY(100%);';
			echo'z-index:1;';
		echo'}';

		/* ------------ Forme Incurvée(incurved) Front End -----------------------*/

		/* séparation incurvée partie supérieure
		réglage dimmensions avec la propriété height
		width permet d'aplanir la courbe 
		la couleur de la forme doit être celui de l'arrière plan de la publication*/
		echo'.is-style-eccp-shape-divider.style-shape-top-curve::before {';
			echo'content: "";';
			echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M600,112.77C268.63,112.77,0,65.52,0,7.23V120H1200V7.23C1200,65.52,931.37,112.77,600,112.77Z\' class=\'shape-fill\'%3E%3C/path%3E%3C/svg%3E");';
			echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M600,112.77C268.63,112.77,0,65.52,0,7.23V120H1200V7.23C1200,65.52,931.37,112.77,600,112.77Z\' class=\'shape-fill\'%3E%3C/path%3E%3C/svg%3E");';
			echo'position: absolute;';
			echo'top: 0;';
			echo'left: 0;';
			echo'width: calc(var(--eccp-topShapeWidth,100)*1%);';
			echo'height: calc(var(--eccp-topShapeHeight,50)*1px);';
			echo'background-color: var(--eccp-topShapeBackgroundColor,#E6E8ED);';
			echo'transform: rotate(180deg);';
			echo'z-index:1;';
		echo'}';


		/* séparation incurvée partie inférieure
		réglage dimmensions avec la propriété height 
		la couleur de la forme doit être celui de l'arrière plan de la publication*/
		echo'.is-style-eccp-shape-divider.style-shape-bottom-curve::after {';
			echo'content: "";';
			echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M600,112.77C268.63,112.77,0,65.52,0,7.23V120H1200V7.23C1200,65.52,931.37,112.77,600,112.77Z\' class=\'shape-fill\'%3E%3C/path%3E%3C/svg%3E");';
			echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M600,112.77C268.63,112.77,0,65.52,0,7.23V120H1200V7.23C1200,65.52,931.37,112.77,600,112.77Z\' class=\'shape-fill\'%3E%3C/path%3E%3C/svg%3E");';
			echo'position: absolute;';
			echo'bottom: 0;';
			echo'left: 0;';
			echo'width: calc(var(--eccp-bottomShapeWidth,100)*1%);';
			echo'height: calc(var(--eccp-bottomShapeHeight,50)*1px);';
			echo'background-color: var(--eccp-bottomShapeBackgroundColor,#E6E8ED);';
			echo'z-index:1;';
		echo'}';

		/* ------------ Forme Incurvée assymétrique(curve asymmetrical) Front End -----------------------*/

		/* séparation incurvée assymétrique partie supérieure
		réglage dimmensions avec la propriété height
		width permet d'aplanir la courbe
		la couleur de la forme doit être celui de l'arrière plan de la publication
		retournement horizontal: transform: rotateX(180deg);'; */
		echo'.is-style-eccp-shape-divider.style-shape-top-curve-asymmetrical::before {';
			echo'content: "";';
			echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M741,116.23C291,117.43,0,27.57,0,6V120H1200V6C1200,27.93,1186.4,119.83,741,116.23Z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M741,116.23C291,117.43,0,27.57,0,6V120H1200V6C1200,27.93,1186.4,119.83,741,116.23Z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'position: absolute;';
			echo'top: 0;';
			echo'left: 0;';
			echo'width: calc((var(--eccp-topShapeWidth,100) + 1) *1%);';
			echo'height: calc(var(--eccp-topShapeHeight,50)*1px);';
			echo'background-color: var(--eccp-topShapeBackgroundColor,#E6E8ED);';
			echo'transform: rotate(180deg);';
			echo'z-index:1;';
		echo'}';

		// retournement horizontal 
		echo'.is-style-eccp-shape-divider.top-shape-flip-horizontally.style-shape-top-curve-asymmetrical::before {';
			echo'transform: rotateX(180deg);';
		echo'}';

		/* séparation incurvée assymétrique partie inférieure
		réglage dimmensions avec la propriété height
		la couleur de la forme doit être celui de l'arrière plan de la publication 
		retournement horizontal: transform: rotateY(180deg)*/
		echo'.is-style-eccp-shape-divider.style-shape-bottom-curve-asymmetrical::after {';
			echo'content: "";';
			echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M741,116.23C291,117.43,0,27.57,0,6V120H1200V6C1200,27.93,1186.4,119.83,741,116.23Z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M741,116.23C291,117.43,0,27.57,0,6V120H1200V6C1200,27.93,1186.4,119.83,741,116.23Z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'position: absolute;';
			echo'bottom: 0;';
			echo'left: 0;';
			echo'width: calc((var(--eccp-bottomShapeWidth,100) + 1) *1%);';
			echo'height: calc(var(--eccp-bottomShapeHeight,50)*1px);';
			echo'background-color: var(--eccp-bottomShapeBackgroundColor,#E6E8ED);';
			echo'z-index:1;';
		echo'}';

		// retournement horizontal 
		echo'.is-style-eccp-shape-divider.bottom-shape-flip-horizontally.style-shape-bottom-curve-asymmetrical::after {';
			echo'transform: rotateY(180deg);';
		echo'}';

		/* ------------ Triangle (Triangle) Front End -----------------------*/
		 
		 /* séparation Triangle partie supérieure
		réglage dimmensions avec la propriétés height
		la couleur de la forme doit être celui de l'arrière plan de la publication
		on peut aussi jouer avec width*/

		 echo'.is-style-eccp-shape-divider.style-shape-top-triangle::before {';
			echo'content: "";';
			echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M598.97 114.72L0 0 0 120 1200 120 1200 0 598.97 114.72z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M598.97 114.72L0 0 0 120 1200 120 1200 0 598.97 114.72z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'position: absolute;';
			echo'top: 0;';
			echo'left: 0;';
			echo'width:100%;';
			echo'height: calc(var(--eccp-topShapeHeight,50)*1px);';
			echo'background-color: var(--eccp-topShapeBackgroundColor,#E6E8ED);';
			echo'transform: rotate(180deg);';
			echo'z-index:1;';
		echo'}';


		/* séparation Triangle partie inférieure
		réglage dimmensions avec la propriété height
		la couleur de la forme doit être celui de l'arrière plan de la publication
		on peut aussi jouer avec width*/

		echo'.is-style-eccp-shape-divider.style-shape-bottom-triangle::after {';
			echo'content: "";';
			echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M598.97 114.72L0 0 0 120 1200 120 1200 0 598.97 114.72z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M598.97 114.72L0 0 0 120 1200 120 1200 0 598.97 114.72z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'position: absolute;';
			echo'bottom:0;';
			echo'left: 0;';
			echo'width:100%;';
			echo'height: calc(var(--eccp-bottomShapeHeight,50)*1px);';
			echo'background-color: var(--eccp-bottomShapeBackgroundColor,#E6E8ED);';
			echo'z-index:1;';
		echo'}';


		/* ------------ Triangle Assymétrique(Triangle Asymmetrical) Front End -----------------------*/
		 
		 /* séparation Triangle Assymétrique partie supérieure
		réglage dimmensions avec la propriétés height
		la couleur de la forme doit être celui de l'arrière plan de la publication
		retournement horizontal: transform: rotateY(180deg);';
		on peut aussi jouer avec width*/

		 echo'.is-style-eccp-shape-divider.style-shape-top-triangle-asymmetrical::before {';
			echo'content: "";';
			echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M1200 0L0 0 892.25 114.72 1200 0z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M1200 0L0 0 892.25 114.72 1200 0z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'position: absolute;';
			echo'top: 0;';
			echo'left: 0;';
			echo'width: calc(var(--eccp-topShapeWidth,100)*1%);';
			echo'height: calc(var(--eccp-topShapeHeight,50)*1px);';
			echo'background-color: var(--eccp-topShapeBackgroundColor,#E6E8ED);';
			echo'z-index:1;';
		echo'}';

		// retournement horizontal 
		echo'.is-style-eccp-shape-divider.top-shape-flip-horizontally.style-shape-top-triangle-asymmetrical::before {';
			echo'transform: rotateY(180deg);';
		echo'}';

		/* séparation Triangle Assymétrique partie inférieure
		réglage dimmensions avec la propriété height
		on peut aussi jouer avec width
		la couleur de la forme doit être celui de l'arrière plan de la publication
		retournement horizontal: transform: rotateX(180deg);';*/
		echo'.is-style-eccp-shape-divider.style-shape-bottom-triangle-asymmetrical::after {';
			echo'content: "";';
			echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M1200 0L0 0 892.25 114.72 1200 0z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M1200 0L0 0 892.25 114.72 1200 0z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'position: absolute;';
			echo'bottom:0;';
			echo'left: 0;';
			echo'width: calc(var(--eccp-bottomShapeWidth,100)*1%);';
			echo'height: calc(var(--eccp-bottomShapeHeight,50)*1px);';
			echo'background-color: var(--eccp-bottomShapeBackgroundColor,#E6E8ED);';
			echo'transform: rotate(180deg);';
			echo'z-index:1;';
		echo'}';

		// retournement horizontal 
		echo'.is-style-eccp-shape-divider.bottom-shape-flip-horizontally.style-shape-bottom-triangle-asymmetrical::after {';
			echo'transform: rotateX(180deg);';
		echo'}';

		/* ------------ Forme Vagues(waves) Front End -----------------------*/

		/* séparation vagues partie supérieure
		réglage dimmensions avec la propriété height
		la couleur de la forme doit être celui de l'arrière plan de la publication
		inversion: transform: rotateX(180deg);';
		on peut aussi varier avec width*/
		 echo'.is-style-eccp-shape-divider.style-shape-top-waves::before {';
			echo'content: "";';
			echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M985.66,92.83C906.67,72,823.78,31,743.84,14.19c-82.26-17.34-168.06-16.33-250.45.39-57.84,11.73-114,31.07-172,41.86A600.21,600.21,0,0,1,0,27.35V120H1200V95.8C1132.19,118.92,1055.71,111.31,985.66,92.83Z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M985.66,92.83C906.67,72,823.78,31,743.84,14.19c-82.26-17.34-168.06-16.33-250.45.39-57.84,11.73-114,31.07-172,41.86A600.21,600.21,0,0,1,0,27.35V120H1200V95.8C1132.19,118.92,1055.71,111.31,985.66,92.83Z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'position: absolute;';
			echo'top: 0;';
			echo'left: 0;';
			echo'width: calc(var(--eccp-topShapeWidth,100)*1%);';
			echo'height: calc(var(--eccp-topShapeHeight,50)*1px);';
			echo'background-color: var(--eccp-topShapeBackgroundColor,#E6E8ED);';
			echo'transform: rotate(180deg);';
			echo'z-index:1;';
		echo'}';

		// retournement horizontal 
		echo'.is-style-eccp-shape-divider.top-shape-flip-horizontally.style-shape-top-waves::before {';
			echo'transform: rotateX(180deg);';
		echo'}';

		/* séparation vagues  partie inférieure
		réglage dimmensions avec la propriété height
		la couleur de la forme doit être celui de l'arrière plan de la publication
		inversion: transform: rotateY(180deg)*/
		echo'.is-style-eccp-shape-divider.style-shape-bottom-waves::after {';
			echo'content: "";';
			echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M985.66,92.83C906.67,72,823.78,31,743.84,14.19c-82.26-17.34-168.06-16.33-250.45.39-57.84,11.73-114,31.07-172,41.86A600.21,600.21,0,0,1,0,27.35V120H1200V95.8C1132.19,118.92,1055.71,111.31,985.66,92.83Z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M985.66,92.83C906.67,72,823.78,31,743.84,14.19c-82.26-17.34-168.06-16.33-250.45.39-57.84,11.73-114,31.07-172,41.86A600.21,600.21,0,0,1,0,27.35V120H1200V95.8C1132.19,118.92,1055.71,111.31,985.66,92.83Z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'position: absolute;';
			echo'bottom:0;';
			echo'left:0;';
			echo'width: calc(var(--eccp-bottomShapeWidth,100)*1%);';
			echo'height: calc(var(--eccp-bottomShapeHeight,50)*1px);';
			echo'background-color: var(--eccp-bottomShapeBackgroundColor,#E6E8ED);';
			echo'z-index:1;';
		echo'}';

		// retournement horizontal 
		echo'.is-style-eccp-shape-divider.bottom-shape-flip-horizontally.style-shape-bottom-waves::after {';
			echo'transform: rotateY(180deg);';
		echo'}';

		/* ------------ Forme Vagues avec opacité(waves opacity) Front End -----------------------*/
		 
		 /* séparation vagues avec opacité partie supérieure
		réglage dimmensions avec les propriétés top & height
		inversion: transform: rotateX(180deg);';*/
		 echo'.is-style-eccp-shape-divider.style-shape-top-waves-opacity::before {';
			echo'content: "";';
			echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M0,0V46.29c47.79,22.2,103.59,32.17,158,28,70.36-5.37,136.33-33.31,206.8-37.5C438.64,32.43,512.34,53.67,583,72.05c69.27,18,138.3,24.88,209.4,13.08,36.15-6,69.85-17.84,104.45-29.34C989.49,25,1113-14.29,1200,52.47V0Z\' opacity=\'.25\' class=\'shape-fill\'%3E%3C/path%3E%3Cpath d=\'M0,0V15.81C13,36.92,27.64,56.86,47.69,72.05,99.41,111.27,165,111,224.58,91.58c31.15-10.15,60.09-26.07,89.67-39.8,40.92-19,84.73-46,130.83-49.67,36.26-2.85,70.9,9.42,98.6,31.56,31.77,25.39,62.32,62,103.63,73,40.44,10.79,81.35-6.69,119.13-24.28s75.16-39,116.92-43.05c59.73-5.85,113.28,22.88,168.9,38.84,30.2,8.66,59,6.17,87.09-7.5,22.43-10.89,48-26.93,60.65-49.24V0Z\' opacity=\'.5\' %3E%3C/path%3E%3Cpath d=\'M0,0V5.63C149.93,59,314.09,71.32,475.83,42.57c43-7.64,84.23-20.12,127.61-26.46,59-8.63,112.48,12.24,165.56,35.4C827.93,77.22,886,95.24,951.2,90c86.53-7,172.46-45.71,248.8-84.81V0Z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M0,0V46.29c47.79,22.2,103.59,32.17,158,28,70.36-5.37,136.33-33.31,206.8-37.5C438.64,32.43,512.34,53.67,583,72.05c69.27,18,138.3,24.88,209.4,13.08,36.15-6,69.85-17.84,104.45-29.34C989.49,25,1113-14.29,1200,52.47V0Z\' opacity=\'.25\' class=\'shape-fill\'%3E%3C/path%3E%3Cpath d=\'M0,0V15.81C13,36.92,27.64,56.86,47.69,72.05,99.41,111.27,165,111,224.58,91.58c31.15-10.15,60.09-26.07,89.67-39.8,40.92-19,84.73-46,130.83-49.67,36.26-2.85,70.9,9.42,98.6,31.56,31.77,25.39,62.32,62,103.63,73,40.44,10.79,81.35-6.69,119.13-24.28s75.16-39,116.92-43.05c59.73-5.85,113.28,22.88,168.9,38.84,30.2,8.66,59,6.17,87.09-7.5,22.43-10.89,48-26.93,60.65-49.24V0Z\' opacity=\'.5\' %3E%3C/path%3E%3Cpath d=\'M0,0V5.63C149.93,59,314.09,71.32,475.83,42.57c43-7.64,84.23-20.12,127.61-26.46,59-8.63,112.48,12.24,165.56,35.4C827.93,77.22,886,95.24,951.2,90c86.53-7,172.46-45.71,248.8-84.81V0Z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'position: absolute;';
			echo'top: calc(var(--eccp-topShapeHeight,50)*-1px);';
			echo'left: 0;';
			echo'width: 100%;';
			echo'height: calc(var(--eccp-topShapeHeight,50)*1px);';
			echo'background-color: var(--eccp-topShapeBackgroundColor,#E6E8ED);';
			echo'transform: rotate(180deg);';
			echo'z-index:1;';
		echo'}';

		// retournement horizontal 
		echo'.is-style-eccp-shape-divider.top-shape-flip-horizontally.style-shape-top-waves-opacity::before {';
			echo'transform: rotateX(180deg);';
		echo'}';

		/* séparation vagues avec opacité partie inférieure
		réglage dimmensions avec les propriétés bottom & height
		inversion: transform: rotateY(180deg);';*/
		echo'.is-style-eccp-shape-divider.style-shape-bottom-waves-opacity::after {';
			echo'content: "";';
			echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M0,0V46.29c47.79,22.2,103.59,32.17,158,28,70.36-5.37,136.33-33.31,206.8-37.5C438.64,32.43,512.34,53.67,583,72.05c69.27,18,138.3,24.88,209.4,13.08,36.15-6,69.85-17.84,104.45-29.34C989.49,25,1113-14.29,1200,52.47V0Z\' opacity=\'.25\' class=\'shape-fill\'%3E%3C/path%3E%3Cpath d=\'M0,0V15.81C13,36.92,27.64,56.86,47.69,72.05,99.41,111.27,165,111,224.58,91.58c31.15-10.15,60.09-26.07,89.67-39.8,40.92-19,84.73-46,130.83-49.67,36.26-2.85,70.9,9.42,98.6,31.56,31.77,25.39,62.32,62,103.63,73,40.44,10.79,81.35-6.69,119.13-24.28s75.16-39,116.92-43.05c59.73-5.85,113.28,22.88,168.9,38.84,30.2,8.66,59,6.17,87.09-7.5,22.43-10.89,48-26.93,60.65-49.24V0Z\' opacity=\'.5\' %3E%3C/path%3E%3Cpath d=\'M0,0V5.63C149.93,59,314.09,71.32,475.83,42.57c43-7.64,84.23-20.12,127.61-26.46,59-8.63,112.48,12.24,165.56,35.4C827.93,77.22,886,95.24,951.2,90c86.53-7,172.46-45.71,248.8-84.81V0Z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M0,0V46.29c47.79,22.2,103.59,32.17,158,28,70.36-5.37,136.33-33.31,206.8-37.5C438.64,32.43,512.34,53.67,583,72.05c69.27,18,138.3,24.88,209.4,13.08,36.15-6,69.85-17.84,104.45-29.34C989.49,25,1113-14.29,1200,52.47V0Z\' opacity=\'.25\' class=\'shape-fill\'%3E%3C/path%3E%3Cpath d=\'M0,0V15.81C13,36.92,27.64,56.86,47.69,72.05,99.41,111.27,165,111,224.58,91.58c31.15-10.15,60.09-26.07,89.67-39.8,40.92-19,84.73-46,130.83-49.67,36.26-2.85,70.9,9.42,98.6,31.56,31.77,25.39,62.32,62,103.63,73,40.44,10.79,81.35-6.69,119.13-24.28s75.16-39,116.92-43.05c59.73-5.85,113.28,22.88,168.9,38.84,30.2,8.66,59,6.17,87.09-7.5,22.43-10.89,48-26.93,60.65-49.24V0Z\' opacity=\'.5\' %3E%3C/path%3E%3Cpath d=\'M0,0V5.63C149.93,59,314.09,71.32,475.83,42.57c43-7.64,84.23-20.12,127.61-26.46,59-8.63,112.48,12.24,165.56,35.4C827.93,77.22,886,95.24,951.2,90c86.53-7,172.46-45.71,248.8-84.81V0Z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'position: absolute;';
			echo'bottom: calc(var(--eccp-bottomShapeHeight,50)*-1px);';
			echo'left: 0;';
			echo'width: 100%;';
			echo'height: calc(var(--eccp-bottomShapeHeight,50)*1px);';
			echo'background-color: var(--eccp-bottomShapeBackgroundColor,#E6E8ED);';
			echo'z-index:1;';
		echo'}';

		// retournement horizontal 
		echo'.is-style-eccp-shape-divider.bottom-shape-flip-horizontally.style-shape-bottom-waves-opacity::after {';
			echo'transform: rotateY(180deg);';
		echo'}';

		/* ------------ Forme Diviser(Split) Front End -----------------------*/
		 
		 /* séparation Diviser partie supérieure
		réglage dimmensions avec la propriété height
		la couleur de la forme doit être celui de l'arrière plan de la publication*/

		echo'.is-style-eccp-shape-divider.style-shape-top-split::before {';
			echo'content: "";';
			echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Crect x=\'1200\' height=\'3.6\'%3E%3C/rect%3E%3Crect height=\'3.6\'%3E%3C/rect%3E%3Cpath d=\'M0,0V3.6H580.08c11,0,19.92,5.09,19.92,13.2,0-8.14,8.88-13.2,19.92-13.2H1200V0Z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Crect x=\'1200\' height=\'3.6\'%3E%3C/rect%3E%3Crect height=\'3.6\'%3E%3C/rect%3E%3Cpath d=\'M0,0V3.6H580.08c11,0,19.92,5.09,19.92,13.2,0-8.14,8.88-13.2,19.92-13.2H1200V0Z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'position: absolute;';
			echo'top: 0px;';
			echo'left: 0;';
			echo'width: 100%;';
			echo'height: calc(var(--eccp-topShapeHeight,50)*1px);';
			echo'background-color: var(--eccp-topShapeBackgroundColor,#E6E8ED);';
			echo'z-index:1;';
		echo'}';


		/* séparation Diviser partie inférieure
		réglage dimmensions avec la propriété height
		la couleur de la forme doit être celui de l'arrière plan de la publication*/
		echo'.is-style-eccp-shape-divider.style-shape-bottom-split::after {';
			echo'content: "";';
			echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Crect x=\'1200\' height=\'3.6\'%3E%3C/rect%3E%3Crect height=\'3.6\'%3E%3C/rect%3E%3Cpath d=\'M0,0V3.6H580.08c11,0,19.92,5.09,19.92,13.2,0-8.14,8.88-13.2,19.92-13.2H1200V0Z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Crect x=\'1200\' height=\'3.6\'%3E%3C/rect%3E%3Crect height=\'3.6\'%3E%3C/rect%3E%3Cpath d=\'M0,0V3.6H580.08c11,0,19.92,5.09,19.92,13.2,0-8.14,8.88-13.2,19.92-13.2H1200V0Z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'position: absolute;';
			echo'bottom: 0;';
			echo'left: 0;';
			echo'width: 100%;';
			echo'height: calc(var(--eccp-bottomShapeHeight,50)*1px);';
			echo'background-color: var(--eccp-bottomShapeBackgroundColor,#E6E8ED);';
			echo'transform: rotate(180deg);';
			echo'z-index:1;';
		echo'}';


		/* ------------ Forme Livre(Book) Front End -----------------------*/
		 
		 /* séparation Livre partie supérieure
		réglage dimmensions avec la propriétés height
		la couleur de la forme doit être celui de l'arrière plan de la publication*/

		echo'.is-style-eccp-shape-divider.style-shape-top-book::before {';
			echo'content: "";';
			echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M602.45,3.86h0S572.9,116.24,281.94,120H923C632,116.24,602.45,3.86,602.45,3.86Z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M602.45,3.86h0S572.9,116.24,281.94,120H923C632,116.24,602.45,3.86,602.45,3.86Z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'position: absolute;';
			echo'top: 0;';
			echo'left: 0;';
			echo'width: 100%;';
			echo'height: calc(var(--eccp-topShapeHeight,50)*1px);';
			echo'background-color: var(--eccp-topShapeBackgroundColor,#E6E8ED);';
			echo'transform: rotate(180deg);';
			echo'z-index:1;';
		echo'}';


		/* séparation Livre partie inférieure
		réglage dimmensions avec la propriété height
		la couleur de la forme doit être celui de l'arrière plan de la publication*/
		echo'.is-style-eccp-shape-divider.style-shape-bottom-book::after {';
			echo'content: "";';
			echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M602.45,3.86h0S572.9,116.24,281.94,120H923C632,116.24,602.45,3.86,602.45,3.86Z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'mask-image: url("data:image/svg+xml,%3Csvg data-name=\'Layer 1\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 1200 120\' preserveAspectRatio=\'none\'%3E%3Cpath d=\'M602.45,3.86h0S572.9,116.24,281.94,120H923C632,116.24,602.45,3.86,602.45,3.86Z\' %3E%3C/path%3E%3C/svg%3E");';
			echo'position: absolute;';
			echo'bottom:0;';
			echo'left: 0;';
			echo'width: 100%;';
			echo'height: calc(var(--eccp-bottomShapeHeight,50)*1px);';
			echo'background-color: var(--eccp-bottomShapeBackgroundColor,#E6E8ED);';
			echo'z-index:1;';
		echo'}';


		/* ------------ Forme Ventilateur(Fan) Front End -----------------------*/
		 
		 /* séparation Ventilateur partie supérieure
		réglage dimmensions avec la propriétés height
		la couleur de la forme doit être celui de l'arrière plan de la publication
		on peut faire varier width pour rendre le ventilateur assymétrique*/

		 echo'.is-style-eccp-shape-divider.style-shape-top-fan::before {';
			echo'content: "";';
			echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 283.5 19.6\' preserveAspectRatio=\'none\'%3E%3Cpath style=\'opacity:0.33\' d=\'M0 0L0 18.8 141.8 4.1 283.5 18.8 283.5 0z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.33\' d=\'M0 0L0 12.6 141.8 4 283.5 12.6 283.5 0z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.33\' d=\'M0 0L0 6.4 141.8 4 283.5 6.4 283.5 0z\'%3E%3C/path%3E%3Cpath d=\'M0 0L0 1.2 141.8 4 283.5 1.2 283.5 0z\'%3E%3C/path%3E%3C/svg%3E");';
			echo'mask-image: url("data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 283.5 19.6\' preserveAspectRatio=\'none\'%3E%3Cpath style=\'opacity:0.33\' d=\'M0 0L0 18.8 141.8 4.1 283.5 18.8 283.5 0z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.33\' d=\'M0 0L0 12.6 141.8 4 283.5 12.6 283.5 0z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.33\' d=\'M0 0L0 6.4 141.8 4 283.5 6.4 283.5 0z\'%3E%3C/path%3E%3Cpath d=\'M0 0L0 1.2 141.8 4 283.5 1.2 283.5 0z\'%3E%3C/path%3E%3C/svg%3E");';
			echo'position: absolute;';
			echo'top: 0;';
			echo'left: 0;';
			echo'width: 100%;';
			echo'height: calc(var(--eccp-topShapeHeight,50)*1px);';
			echo'background-color: var(--eccp-topShapeBackgroundColor,#E6E8ED);';
			echo'z-index:1;';
		echo'}';


		/* séparation Ventilateur partie inférieure
		réglage dimmensions avec la propriété height
		la couleur de la forme doit être celui de l'arrière plan de la publication
		on peut faire varier width pour rendre le ventilateur assymétrique*/
		echo'.is-style-eccp-shape-divider.style-shape-bottom-fan::after {';
			echo'content: "";';
			echo'-webkit-mask-image: url("data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 283.5 19.6\' preserveAspectRatio=\'none\'%3E%3Cpath style=\'opacity:0.33\' d=\'M0 0L0 18.8 141.8 4.1 283.5 18.8 283.5 0z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.33\' d=\'M0 0L0 12.6 141.8 4 283.5 12.6 283.5 0z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.33\' d=\'M0 0L0 6.4 141.8 4 283.5 6.4 283.5 0z\'%3E%3C/path%3E%3Cpath d=\'M0 0L0 1.2 141.8 4 283.5 1.2 283.5 0z\'%3E%3C/path%3E%3C/svg%3E");';
			echo'mask-image: url("data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 283.5 19.6\' preserveAspectRatio=\'none\'%3E%3Cpath style=\'opacity:0.33\' d=\'M0 0L0 18.8 141.8 4.1 283.5 18.8 283.5 0z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.33\' d=\'M0 0L0 12.6 141.8 4 283.5 12.6 283.5 0z\'%3E%3C/path%3E%3Cpath style=\'opacity:0.33\' d=\'M0 0L0 6.4 141.8 4 283.5 6.4 283.5 0z\'%3E%3C/path%3E%3Cpath d=\'M0 0L0 1.2 141.8 4 283.5 1.2 283.5 0z\'%3E%3C/path%3E%3C/svg%3E");';
			echo'position: absolute;';
			echo'bottom:0;';
			echo'left: 0;';
			echo'width: 100%;';
			echo'height: calc(var(--eccp-bottomShapeHeight,50)*1px);';
			echo'background-color: var(--eccp-bottomShapeBackgroundColor,#E6E8ED);';
			echo'transform: rotate(180deg);';
			echo'z-index:1;';
		echo'}';
		
		/*--------------- Régles Mobiles & tablettes Front End --------------- */

		echo'@media(max-width:767px){';

			
			/* ------------ Forme Inclinée(tilt) -----------------------*/

			/* Forme supérieure */
			echo'.is-style-eccp-shape-divider.style-shape-top-tilt::before {';
				echo'height: calc(var(--eccp-mobileTopShapeHeight,50)*1px);';
			echo'}';
			
			/* Forme inférieure */ 
			echo'.is-style-eccp-shape-divider.style-shape-bottom-tilt::after {';
				echo'height: calc(var(--eccp-mobileBottomShapeHeight,50)*1px);';
			echo'}';
			
			/* ------------ Forme Inclinée avec opacité(tilt opacity)-----------------------*/

			/* Forme  supérieure */
			echo'.is-style-eccp-shape-divider.style-shape-top-tilt-opacity::before {';
				echo'top:calc(var(--eccp-mobileTopShapeHeight,50)*-1px);';
				echo'height: calc(var(--eccp-mobileTopShapeHeight,50)*1px);';
			echo'}';

			/* séparation Forme Inclinée avec opacité partie inférieure */
			echo'.is-style-eccp-shape-divider.style-shape-bottom-tilt-opacity::after {';
				echo'bottom:calc(var(--eccp-mobileBottomShapeHeight,50)*-1px);';
				echo'height: calc(var(--eccp-mobileBottomShapeHeight,50)*1px);';
			echo'}';
			
			/* ------------ Forme Flèche(Arrow) -----------------------*/

			/* Forme supérieure */
			echo'.is-style-eccp-shape-divider.style-shape-top-arrow::before {';
				echo'height: calc(var(--eccp-mobileTopShapeHeight,50)*1px);';
			echo'}';

			/* Forme inférieure */
			echo'.is-style-eccp-shape-divider.style-shape-bottom-arrow::after {';
				echo'bottom: calc(var(--eccp-mobileBottomShapeHeight,50)*-1px);';
				echo'height: calc(var(--eccp-mobileBottomShapeHeight,50)*1px);';
			echo'}';
			

			/* ------------ Forme Incurvée(incurved) -----------------------*/

			
			/* Forme supérieure */
			echo'.is-style-eccp-shape-divider.style-shape-top-curve::before {';
				echo'height: calc(var(--eccp-mobileTopShapeHeight,50)*1px);';
			echo'}';
			

			/* Forme inférieure */
			echo'.is-style-eccp-shape-divider.style-shape-bottom-curve::after {';
				echo'left:-1px;';
				echo'height: calc(var(--eccp-mobileBottomShapeHeight,50)*1px);';
			echo'}';
			

			/* ------------ Forme Incurvée assymétrique(curve asymmetrical) -----------------------*/

			/* Forme supérieure */ 
			echo'.is-style-eccp-shape-divider.style-shape-top-curve-asymmetrical::before {';
				echo'height: calc(var(--eccp-mobileTopShapeHeight,50)*1px);';
				echo'left:-1px;';
			echo'}';
			

			/* Forme inférieure */
			echo'.is-style-eccp-shape-divider.style-shape-bottom-curve-asymmetrical::after {';
				echo'height: calc(var(--eccp-mobileBottomShapeHeight,50)*1px);';
				echo'left:-1px;';
			echo'}';
			

			/* ------------ Triangle (Triangle) -----------------------*/
			 
			/* Forme supérieure */
			echo'.is-style-eccp-shape-divider.style-shape-top-triangle::before {';
				echo'height: calc(var(--eccp-mobileTopShapeHeight,50)*1px);';
			echo'}';
			

			/* Forme inférieure */
			echo'.is-style-eccp-shape-divider.style-shape-bottom-triangle::after {';
				echo'height: calc(var(--eccp-mobileBottomShapeHeight,50)*1px);';
			echo'}';
			

			/* ------------ Triangle Assymétrique(Triangle Asymmetrical) -----------------------*/
			 
			 /* Forme supérieure */
			echo'.is-style-eccp-shape-divider.style-shape-top-triangle-asymmetrical::before {';
				echo'height: calc(var(--eccp-mobileTopShapeHeight,50)*1px);';
			echo'}';

			/* Forme inférieure */
			echo'.is-style-eccp-shape-divider.style-shape-bottom-triangle-asymmetrical::after {';
				echo'height: calc(var(--eccp-mobileBottomShapeHeight,50)*1px);';
			echo'}';
			
			/* ------------ Forme Vagues(waves ) -----------------------*/

			/* Forme supérieure */
			echo'.is-style-eccp-shape-divider.style-shape-top-waves::before {';
				echo'height: calc(var(--eccp-mobileTopShapeHeight,50)*1px);';
			echo'}';
			
			/* Forme inférieure */
			echo'.is-style-eccp-shape-divider.style-shape-bottom-waves::after {';
				echo'height: calc(var(--eccp-mobileBottomShapeHeight,50)*1px);';
			echo'}';
			
			/* retournement horizontal */
			echo'.is-style-eccp-shape-divider.bottom-shape-flip-horizontally.style-shape-bottom-waves::after {';
				echo'left:-1px;';
			echo'}';

			/* ------------ Forme Vagues avec opacité(waves opacity) -----------------------*/
			 
			 /* Forme supérieure */
			echo'.is-style-eccp-shape-divider.style-shape-top-waves-opacity::before {';
				echo'top: calc(var(--eccp-mobileTopShapeHeight,50)*-1px);';
				echo'height: calc(var(--eccp-mobileTopShapeHeight,50)*1px);';
			echo'}';
			
			/* Forme inférieure */
			echo'.is-style-eccp-shape-divider.style-shape-bottom-waves-opacity::after {';
				echo'bottom: calc(var(--eccp-mobileBottomShapeHeight,50)*-1px);';
				echo'height: calc(var(--eccp-mobileBottomShapeHeight,50)*1px);';
			echo'}';
			
			/* ------------ Forme Diviser(Split) -----------------------*/
			 
			 /* Forme supérieure */
			echo'.is-style-eccp-shape-divider.style-shape-top-split::before {';
				echo'height: calc(var(--eccp-mobileTopShapeHeight,50)*1px);';
			echo'}';
			

			/* Forme inférieure */
			echo'.is-style-eccp-shape-divider.style-shape-bottom-split::after {';
				echo'height: calc(var(--eccp-mobileBottomShapeHeight,50)*1px);';
			echo'}';
			

			/* ------------ Forme Livre(Book) -----------------------*/
			 
			 /* Forme supérieure */
			echo'.is-style-eccp-shape-divider.style-shape-top-book::before {';
				echo'height: calc(var(--eccp-mobileTopShapeHeight,50)*1px);';
			echo'}';
			

			/* Forme inférieure */
			echo'.is-style-eccp-shape-divider.style-shape-bottom-book::after {';
				echo'height: calc(var(--eccp-mobileBottomShapeHeight,50)*1px);';
			echo'}';
			

			/* ------------ Forme Ventilateur() -----------------------*/
			 
			 /* Forme supérieure */
			echo'.is-style-eccp-shape-divider.style-shape-top-fan::before {';
				echo'height: calc(var(--eccp-mobileTopShapeHeight,50)*1px);';
			echo'}';
			

			/* Forme inférieure */
			echo'.is-style-eccp-shape-divider.style-shape-bottom-fan::after {';
				echo'height: calc(var(--eccp-mobileBottomShapeHeight,50)*1px);';
			echo'}';

		echo'}';
		
		
		/*-------------------BLOC DÉTAILS FRONT END -----------------------------------------*/
			
			/*------------------- Largeur Bloc Détails Front End----------------*/
			
			// version 2.4 correction pour thème Astra
			// sélecteur body.page & body.single
			echo'@media (min-width:1025px) {';
			
				echo'body.page .wp-block-details.is-style-eccp-size-very-small,
					 body.single .wp-block-details.is-style-eccp-size-very-small{';
													
					echo'width: 50%!important;';
			
				echo'}';
			
				echo'body.page .wp-block-details.is-style-eccp-size-small,
					 body.single .wp-block-details.is-style-eccp-size-small{';
													
					echo'width: 60%!important;';
			
				echo'}';
				
				echo'body.page .wp-block-details.is-style-eccp-size-regular,
					 body.single .wp-block-details.is-style-eccp-size-regular{';
							
					echo'width: 70%!important;';
			
				echo'}';
				
				echo'body.page .wp-block-details.is-style-eccp-size-large,
					 body.single .wp-block-details.is-style-eccp-size-large{';
										
					echo'width: 80%!important;';
			
				echo'}';
				
				echo'body.page .wp-block-details.is-style-eccp-size-larger,
					 body.single .wp-block-details.is-style-eccp-size-larger{';
								
					echo'width: 90%!important;';
			
				echo'}';
			
			echo'}';
			
			
			// régle pour les mobiles
			echo'@media (max-width:480px) {';
			
				echo'body.page .wp-block-details,
					 body.single .wp-block-details{';
										
					echo'margin-right: 0;';
					echo'width: 100%;';
			
				echo'}';
			
			echo'}';
			
			
			/*------------------- Icône Dashicons Arrow Front End ----------------*/
			
			//Icône Dashicons Arrow pour indiquer si le contenu du bloc détails 
			//est affiché ou masqué
			
			/*
			on masque le petit triangle horizontal
			qui est le contrôle utilisé par la balise détails
			afin d'indiquer si son contenu est révélé ou non
			*/
			echo'.wp-block-details.is-style-details-dashicons-arrow summary:first-of-type{';
			  echo'list-style: none!important;';
			echo'}';
			
			/* 
			icone dashicons flêche vers le bas 
			pour la balise détails fermé
			*/
			echo'.wp-block-details.is-style-details-dashicons-arrow summary::before {';
				echo'content: "\f347";';
				echo'font-family: "dashicons";';
				echo'float:left;';
				echo'margin-right:10px;';
			echo'}';


			/* 
			icone dashicons flêche vers le haut 
			pour la balise détails ouverte
			*/
			echo'.wp-block-details.is-style-details-dashicons-arrow[open] summary::before {';
				echo'content: "\f343";';
				echo'font-family: "dashicons";';
				echo'float:left;';
			echo'}';

		
		
		/*-------------------BLOC LISTE FRONT END -----------------------------------------*/
		
		/* Excepté Pour les mobiles en mode portrait*/ 
		echo'@media only screen and (min-width:480px){';
			
			echo'body.single .site-content ul,
				 body.page .site-content ul {';
			
				echo'margin: 15px 0 20px 20px!important;';
			
			echo'}';
			
		echo'}';
		
		
		if( $custom_gutenberg_blocks_settings['eccp_settings_activate_styles_bullet_list_radio_field'] == 'yes' ) {
					
			// substr retourne une sous chaine de la position:1 jusqu'a la fin				
			//$icone_color = substr($custom_gutenberg_blocks_settings['eccp_settings_bulleted_list_color_text_field'],1);
			
			// on récupère le nom du thème actif
			$my_theme = wp_get_theme();
			
			
			/*------------------- Largeur Bloc Liste Front End----------------*/
			
			echo'@media (min-width:1025px) {';
		
			echo'body.page ul.is-style-eccp-size-very-small,
			     body.single ul.is-style-eccp-size-very-small,
				 body.page ol.is-style-eccp-size-very-small,
			     body.single ol.is-style-eccp-size-very-small{';
												
				echo'width: 50%!important;';
		
			echo'}';
		
			echo'body.page ul.is-style-eccp-size-small,
			     body.single ul.is-style-eccp-size-small,
				 body.page ol.is-style-eccp-size-small,
			     body.single ol.is-style-eccp-size-small{';
												
				echo'width: 60%!important;';
		
			echo'}';
			
			echo'body.page ul.is-style-eccp-size-regular,
			     body.single ul.is-style-eccp-size-regular,
				 body.page ol.is-style-eccp-size-regular,
			     body.single ol.is-style-eccp-size-regular{';
				 		
				echo'width: 70%!important;';
		
			echo'}';
			
			echo'body.page ul.is-style-eccp-size-large,
			     body.single ul.is-style-eccp-size-large,
				 body.page ol.is-style-eccp-size-large,
			     body.single ol.is-style-eccp-size-large{';
									
				echo'width: 80%!important;';
		
			echo'}';
			
			echo'body.page ul.is-style-eccp-size-larger,
			     body.single ul.is-style-eccp-size-larger,
				 body.page ol.is-style-eccp-size-larger,
			     body.single ol.is-style-eccp-size-larger{';
							
				echo'width: 90%!important;';
		
			echo'}';
		
			echo'}';
			
			
			// régle pour les mobiles
			echo'@media (max-width:480px) {';
			
				/*
				echo'body.page .wp-block-group,
					 body.single .wp-block-group{';
										
					echo'margin-right: 0;';
					echo'width: 100%;';
			
				echo'}';
				*/
			
			echo'}';
			
			
			
			/*-------------------style Disc front end(style par défaut)----------------*/
		
			echo'body.single .is-style-default li::marker,
				 body.page .is-style-default li::marker,
				 body.blog .is-style-default li::marker,
				 body.single-tribe_events .is-style-default li::marker,
				 .is-style-default li::marker{';
			
				echo'color: var(--eccp-bulletColor,#333333);';
				// comme la variable CSS --eccp-bulletSize est de type integer
				// il faut passer par la fonction calc pour affecter une taille en px
				echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
				
			echo'}';
			
			
			/* Régles Pour les mobiles en mode portrait*/ 
			echo'@media only screen and (max-width:480px){';
			
				echo'body.single .is-style-default li::marker,
				 body.page .is-style-default li::marker,
				 body.blog .is-style-default li::marker,
				 body.single-tribe_events .is-style-default li::marker,
				 .is-style-default li::marker{';
				
					echo'font-size:20px;';
				
				echo'}';
			
			echo'}';
			
			/*-------------------Style Square front end --------------------------*/ 
			
			echo'.is-style-eccp-square-bullet-list {';
			
				echo'list-style:square;';
			
			echo'}';
			
			echo'.is-style-eccp-square-bullet-list li::marker{';
					
				echo'color: var(--eccp-bulletColor,#333333);';
				echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
				
			echo'}';
			
			
			// correction theme divi pour la position des puces +
			if(stristr($my_theme, 'divi')) {
				
				echo'body.page #left-area ul.is-style-eccp-square-bullet-list, body.page .entry-content ul.is-style-eccp-square-bullet-list,
					 body.single #left-area ul.is-style-eccp-square-bullet-list, body.single .entry-content ul.is-style-eccp-square-bullet-list{';
					
					echo'list-style-type: square;';
				
				echo'}';
			
			}
			
			
			/* Régles Pour les mobiles en mode portrait*/ 
			echo'@media only screen and (max-width:480px){';
			
				echo'.is-style-eccp-square-bullet-list li::marker{';
				
					echo'font-size:20px;';
				
				echo'}';
			
			echo'}';
			
			/*------------------- Style Check front end --------------------------*/
			
			/* icone Google
			echo'.is-style-eccp-check-bullet-list {';
				
				// on supprime la puce disk par défaut
				echo'list-style-type: none;';
				
				echo'list-style-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\''.esc_html($custom_gutenberg_blocks_settings['eccp_settings_bulleted_list_size_text_field']).'px\' viewBox=\'0 0 24 24\' width=\''.esc_html($custom_gutenberg_blocks_settings['eccp_settings_bulleted_list_size_text_field']).'px\' fill=\'%23'.esc_html($icone_color).'\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z\'/%3E%3C/svg%3E")';
			
			echo'}';*/
			
			
			echo'.is-style-eccp-check-bullet-list li{';
				
				// on supprime la puce disk par défaut
				echo'list-style-type: none;';
				
				echo'padding-left: 8px;';
				echo'position: relative;';
			
			echo'}';
			
			// la taille initiale du SVG est donné par width & height
			// pour le background-size
			// la variation de la taille se fera par la régle transform
			echo'.is-style-eccp-check-bullet-list li::before{';
						
				echo' background-size: cover!important;
					  display: inline-block; 
					  height:25px;
					  width:25px;
					  left: -25px;
					  position: absolute;
					  top: 1em;                  
					  margin-top: -1em;                  	                  
					  mask-repeat: no-repeat;	                 
					  -webkit-mask-repeat: no-repeat;';
				
				// on applique une taille au svg en fonction de la variable
				// css --eccp-bulletSize donné par le script reactjs et 
				// enregistré dans le html du bloc par la régle style		  
				echo'transform: scale(calc(var(--eccp-bulletSize,20) / 25));';
			
			echo'}';
			
			// modification position icône 
			switch ($my_theme) {
				
				// correction theme astra
				case stristr($my_theme, 'astra'):
			
					echo'.is-style-eccp-check-bullet-list li::before{';
						echo'top: 1.2em;';
					echo'}';
			
				break;
				
			}
			
			echo'ul.is-style-eccp-check-bullet-list li::before{';
				
				// lorsqu'on affiche un icone avec la régle pseudo :before
				// il faut appliquer la régle content: "" pour que cela fonctionne
				// on applique une couleur de fond au svg avec la variable CSS
				// --eccp-bulletColor définit par le script ReactJS et enregistré dans le
				// html du bloc par la régle style
				echo' content: "";
					  background-color: var(--eccp-bulletColor,#333333)!important;';
					  
			echo'}';
			
			
			echo'.is-style-eccp-check-bullet-list li::before{';
				
				// icone Google
				// la régle mask-image permettra d'appliquer une couleur au SVG
				echo'-webkit-mask-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\'  viewBox=\'0 0 24 24\' fill=\'%23000000\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z\'/%3E%3C/svg%3E");';
				echo'mask-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\'  viewBox=\'0 0 24 24\' fill=\'%23000000\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z\'/%3E%3C/svg%3E");';
				
			echo'}';
			
			
			
			/* Régles Pour les mobiles en mode portrait*/ 
			echo'@media only screen and (max-width:480px){';
			
				echo'.is-style-eccp-check-bullet-list li::before{';
				
					echo'transform: scale(calc(20 / 25));';
					echo'top: 1.2em;';
				
				echo'}';
			
			echo'}';
			
					
			/*------------------- Style Check circle fill front end --------------------------*/
			
			/* icone Iconify
			echo'.is-style-eccp-check-circle-fill-bullet-list {';
			
				// on supprime la puce disk par défaut
				echo'list-style-type: none;';
				
				echo'list-style-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' xmlns:xlink=\'http://www.w3.org/1999/xlink\' aria-hidden=\'true\' role=\'img\' width=\''.esc_html($custom_gutenberg_blocks_settings['eccp_settings_bulleted_list_size_text_field']).'px\' height=\''.esc_html($custom_gutenberg_blocks_settings['eccp_settings_bulleted_list_size_text_field']).'px\' preserveAspectRatio=\'xMidYMid meet\' viewBox=\'0 0 24 24\'%3E%3Cg fill=\'none\'%3E%3Cpath d=\'M12 22c-5.52-.006-9.994-4.48-10-10v-.2C2.11 6.305 6.635 1.928 12.13 2c5.497.074 9.904 4.569 9.868 10.065C21.962 17.562 17.497 22 12 22zM7.41 11.59L6 13l4 4l8-8l-1.41-1.42L10 14.17l-2.59-2.58z\' fill=\'%23'.esc_html($icone_color).'\'/%3E%3C/g%3E%3C/svg%3E")';
			
			echo'}';*/
			
			
			echo'.is-style-eccp-check-circle-fill-bullet-list li{';
				
				// on supprime la puce disk par défaut
				echo'list-style-type: none;';
				
				echo'padding-left: 8px;';
				echo'position: relative;';
			
			echo'}';
			
			
			echo'.is-style-eccp-check-circle-fill-bullet-list li::before{';
						
				echo' background-size: cover!important;
					  display: inline-block; 
					  height:25px;
					  width:25px;
					  left: -25px;
					  position: absolute;
					  top: 1em;                  
					  margin-top: -1em;                  	                  
					  mask-repeat: no-repeat;	                 
					  -webkit-mask-repeat: no-repeat;';
				
				// on applique une taille au svg	  
				echo'transform: scale(calc(var(--eccp-bulletSize,20) / 25));';
			
			echo'}';
			
			// modification position icône 
			switch ($my_theme) {
				
				// correction theme astra
				case stristr($my_theme, 'astra'):
			
					echo'.is-style-eccp-check-circle-fill-bullet-list li::before{';
						echo'top: 1.2em;';
					echo'}';
			
				break;

				
			}
			
			
			echo'ul.is-style-eccp-check-circle-fill-bullet-list li::before{';
				
				// lorsqu'on affiche un icone avec la régle pseudo :before
				// il faut appliquer la régle content: "" pour que cela fonctionne
				// on applique une couleur de fond au svg avec la variable CSS
				// --eccp-bulletColor définit par le script ReactJS et enreigistré dans le
				// html du bloc par la régle style
				echo' content: "";
					  background-color: var(--eccp-bulletColor,#333333)!important;';
					  
			echo'}';
			
			
			echo'.is-style-eccp-check-circle-fill-bullet-list li::before{';
				
				// icone Google
				// la régle mask-image permettra d'appliquer une couleur au SVG
				echo'-webkit-mask-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'24px\' viewBox=\'0 0 24 24\' width=\'24px\' fill=\'%23000000\'%3E%3Cpath d=\'M0 0h24v24H0z\' fill=\'none\'/%3E%3Cpath d=\'M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z\'/%3E%3C/svg%3E");';
				echo'mask-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'24px\' viewBox=\'0 0 24 24\' width=\'24px\' fill=\'%23000000\'%3E%3Cpath d=\'M0 0h24v24H0z\' fill=\'none\'/%3E%3Cpath d=\'M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z\'/%3E%3C/svg%3E");';
				
			echo'}';
			
			
			/* Régles Pour les mobiles en mode portrait*/ 
			echo'@media only screen and (max-width:480px){';
			
				echo'.is-style-eccp-check-circle-fill-bullet-list li::before{';
				
					echo'transform: scale(calc(20 / 25));';
					echo'top: 1.2em;';
				
				echo'}';
			
			echo'}';
			
			/*------------------- Style Add front end --------------------------*/
			
			/* icone Google
			echo'.is-style-eccp-add-bullet-list li {';
			
				// on supprime la puce disk par défaut
				echo'list-style-type: none;';
				
				echo'background:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'20px\' viewBox=\'0 0 24 24\' width=\'20px\' fill=\'%23'.esc_html($icone_color).'\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z\'/%3E%3C/svg%3E")no-repeat;';
				echo'background-size: '.esc_html($custom_gutenberg_blocks_settings['eccp_settings_bulleted_list_size_text_field']).'px;';
				echo'background-position: 7px 6px;';
				echo'padding: 0px 0px 0px 35px;';
				echo'margin-left:-35px;';
			
			echo'}';
			
			$my_theme = wp_get_theme();
			
			// correction theme divi pour la position des puces +
			if(stristr($my_theme, 'divi')) {
				
				echo'.is-style-eccp-add-bullet-list li {';
					echo'background-position: 7px 3px!important;';
				echo'}';
			
			}*/
			
			echo'.is-style-eccp-add-bullet-list li{';
				
				// on supprime la puce disk par défaut
				echo'list-style-type: none;';
				
				echo'padding-left: 8px;';
				echo'position: relative;';
			
			echo'}';
			
			
			echo'.is-style-eccp-add-bullet-list li::before{';
						
				echo' background-size: cover!important;
					  display: inline-block; 
					  height:25px;
					  width:25px;
					  left: -25px;
					  position: absolute;
					  top: 1.2em;                  
					  margin-top: -1em;                  	                  
					  mask-repeat: no-repeat;	                 
					  -webkit-mask-repeat: no-repeat;';
				
				// on applique une taille au svg	  
				echo'transform: scale(calc(var(--eccp-bulletSize,20) / 25));';
			
			echo'}';
			
			
			// modification position icône 
			switch ($my_theme) {
				
				// correction theme astra
				case stristr($my_theme, 'astra'):
			
					echo'.is-style-eccp-add-bullet-list li::before{';
						echo'top: 1.3em;';
					echo'}';
			
				break;
				
			}
			
			
			echo'ul.is-style-eccp-add-bullet-list li::before{';
				
				// lorsqu'on affiche un icone avec la régle pseudo :before
				// il faut appliquer la régle content: "" pour que cela fonctionne
				// on applique une couleur de fond au svg avec la variable CSS
				// --eccp-bulletColor définit par le script ReactJS et enreigistré dans le
				// html du bloc par la régle style
				echo' content: "";
					  background-color: var(--eccp-bulletColor,#333333)!important;';
					  
			echo'}';
			
			
			echo'.is-style-eccp-add-bullet-list li::before{';
				
				// icône Google
				// la régle mask-image permettra d'appliquer une couleur au SVG
				echo'-webkit-mask-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'20px\' viewBox=\'0 0 24 24\' width=\'20px\' fill=\'%23000000\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z\'/%3E%3C/svg%3E");';
				echo'mask-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'20px\' viewBox=\'0 0 24 24\' width=\'20px\' fill=\'%23000000\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z\'/%3E%3C/svg%3E");';
				
			echo'}';
			
			
			/* Régles Pour les mobiles en mode portrait*/ 
			echo'@media only screen and (max-width:480px){';
			
				echo'.is-style-eccp-add-bullet-list li::before{';
				
					echo'transform: scale(calc(20 / 25));';
					echo'top: 1.3em;';
				
				echo'}';
			
			echo'}';
		
			
			/*------------------- Style Add circle fill front end --------------------------*/
			
			/* icone Google
			echo'.is-style-eccp-add-circle-fill-bullet-list li {';
			
				// on supprime la puce disk par défaut
				echo'list-style-type: none;';
				
				echo'background:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'20px\' viewBox=\'0 0 24 24\' width=\'20px\' fill=\'%23'.esc_html($icone_color).'\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm5 11h-4v4h-2v-4H7v-2h4V7h2v4h4v2z\'/%3E%3C/svg%3E")no-repeat;';
				echo'background-size: '.esc_html($custom_gutenberg_blocks_settings['eccp_settings_bulleted_list_size_text_field']).'px;';
				echo'background-position: 7px 6px;';
				echo'padding: 0px 0px 0px 35px;';
				echo'margin-left:-35px;';
			
			echo'}';
			
			
			// correction theme divi pour la position des puces +
			if(stristr($my_theme, 'divi')) {
				
				echo'.is-style-eccp-add-circle-fill-bullet-list li {';
					echo'background-position: 7px 3px!important;';
				echo'}';
			
			}*/
			
			
			echo'.is-style-eccp-add-circle-fill-bullet-list li{';
				
				// on supprime la puce disk par défaut
				echo'list-style-type: none;';
				
				echo'padding-left: 8px;';
				echo'position: relative;';
			
			echo'}';
			
			
			echo'.is-style-eccp-add-circle-fill-bullet-list li::before{';
						
				echo' background-size: cover!important;
					  display: inline-block; 
					  height:25px;
					  width:25px;
					  left: -25px;
					  position: absolute;
					  top: 1.2em;                  
					  margin-top: -1em;                  	                  
					  mask-repeat: no-repeat;	                 
					  -webkit-mask-repeat: no-repeat;';
				
				// on applique une taille au svg	  
				echo'transform: scale(calc(var(--eccp-bulletSize,20) / 25));';
			
			echo'}';
			
			
			// modification position icône 
			switch ($my_theme) {
				
				// correction theme astra
				case stristr($my_theme, 'astra'):
			
					echo'.is-style-eccp-add-circle-fill-bullet-list li::before{';
						echo'top: 1.3em;';
					echo'}';
			
				break;
	
			}
			
			
			echo'ul.is-style-eccp-add-circle-fill-bullet-list li::before{';
				
				// lorsqu'on affiche un icone avec la régle pseudo :before
				// il faut appliquer la régle content: "" pour que cela fonctionne
				// on applique une couleur de fond au svg avec la variable CSS
				// --eccp-bulletColor définit par le script ReactJS et enreigistré dans le
				// html du bloc par la régle style
				echo' content: "";
                      background-color: var(--eccp-bulletColor,#333333)!important;';
					  
			echo'}';
			
			
			echo'.is-style-eccp-add-circle-fill-bullet-list li::before{';
				
				// icône Google
				// la régle mask-image permettra d'appliquer une couleur au SVG
				echo'-webkit-mask-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'20px\' viewBox=\'0 0 24 24\' width=\'20px\' fill=\'%23000000\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm5 11h-4v4h-2v-4H7v-2h4V7h2v4h4v2z\'/%3E%3C/svg%3E");';
				echo'mask-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'20px\' viewBox=\'0 0 24 24\' width=\'20px\' fill=\'%23000000\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm5 11h-4v4h-2v-4H7v-2h4V7h2v4h4v2z\'/%3E%3C/svg%3E");';
				
			echo'}';
			
			
			/* Régles Pour les mobiles en mode portrait*/ 
			echo'@media only screen and (max-width:480px){';
			
				echo'.is-style-eccp-add-circle-fill-bullet-list li::before{';
				
					echo'transform: scale(calc(22 / 25));';
					echo'top: 1.3em;';
				
				echo'}';
			
			echo'}';
			
			
			/*------------------- Style Push Spin front end --------------------------*/			
					
			// icone Dashicons
			echo'.is-style-eccp-push-spin-bullet-list li:before {';
	
				echo'font-family: dashicons;';
				echo'content: "\f109";';
				echo'font-weight: 400;';
				echo'vertical-align: top;';	
				echo'margin-left:-25px;';
				echo'margin-right:10px;';				
				echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
				echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
				echo'color:var(--eccp-bulletColor,#333333);';
				
			echo'}';
			
			// on supprime la liste à puces par défaut
			echo'.is-style-eccp-push-spin-bullet-list{';
			
				echo'list-style-type: none!important;';
			
			echo'}';
			
			switch ($my_theme) {
				
				// correction theme divi
				case stristr($my_theme, 'divi'):
			
					echo'.is-style-eccp-push-spin-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
					echo'}';
			
				break;
				
				// correction theme Generate Press
				case stristr($my_theme, 'generatepress'):
			
					echo'.is-style-eccp-push-spin-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
					echo'}';
			
				break;
				
			}

			//Régles Pour les mobiles en mode portrait 
			echo'@media only screen and (max-width:480px){';
			
				echo'.is-style-eccp-push-spin-bullet-list li:before{';
				
					echo'line-height: calc(25 / 20 * 1.3em);';
					echo'font-size:20px;';
				
				echo'}';
			
			echo'}';


			/*------------------- Style Circle Duotone front end --------------------------*/
			
			// pour un même rendu que les autres puces on ne prend que 70% de la taille définit
			// dans les paramètres de réglage du plugin
			// pour ce cercle bicolore une couleur est fixé: #108bc5, l'autre couleur est réglable
			echo'.is-style-eccp-circle-duotone-bullet-list li::before {';
			
				echo'content: "";';
				echo'display: inline-block;';
				echo'margin-left: -20px;';
				echo'margin-right: 10px;';
				echo'border: 3px solid var(--eccp-bulletColor,#333333);';
				echo'border-left: 3px solid #108bc5;';
				echo'border-radius: 50%;';
				echo'height: calc(var(--eccp-bulletSize,20) * 1px * 0.7);';
				echo'width: calc(var(--eccp-bulletSize,20) * 1px * 0.7);';
				
			echo'}';
			
			echo'.is-style-eccp-circle-duotone-bullet-list li::marker{';
						
				// on supprime la puce disk par défaut
				echo'content:\'\';';
			
			echo'}';
			
			
			// correction theme divi pour la taille des puces circulaire bicolore
			if(stristr($my_theme, 'divi')) {
				
				echo'.is-style-eccp-circle-duotone-bullet-list li::before {';
			
					echo'height: calc(var(--eccp-bulletSize,20) * 1px * 0.4)!important;';
					echo'width: calc(var(--eccp-bulletSize,20) * 1px * 0.4)!important;';
			
				echo'}';
				
			}
			
			
			/* Régles Pour les mobiles en mode portrait*/ 
			echo'@media only screen and (max-width:480px){';
			
				if(stristr($my_theme, 'divi')) {
			
					echo'.is-style-eccp-circle-duotone-bullet-list li::before{';
					
						echo'height: calc(20 * 1px * 0.4)!important;';
						echo'width: calc(20 * 1px * 0.4)!important;';
					
					echo'}';
				
				}else{
					
					echo'.is-style-eccp-circle-duotone-bullet-list li::before{';
					
						echo'height: calc(20 * 1px * 0.7)!important;';
						echo'width: calc(20 * 1px * 0.7)!important;';
					
					echo'}';
					
				}
			
			echo'}';
			
			/*------------------- Style Clear front end --------------------------*/			
					
			
			/* icone Google
			echo'.is-style-eccp-clear-bullet-list li{';
				
				// on supprime la puce disk par défaut
				echo'list-style-type: none;';
				
				echo'background:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'24px\' viewBox=\'0 0 24 24\' width=\'24px\' fill=\'%23'.esc_html($icone_color).'\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12 19 6.41z\'/%3E%3C/svg%3E")no-repeat;';
				echo'background-size: '.esc_html($custom_gutenberg_blocks_settings['eccp_settings_bulleted_list_size_text_field']).'px;';
				echo'background-position: 7px 6px;';
				echo'padding: 0px 0px 0px 35px;';
				echo'margin-left:-35px;';
			
			echo'}';
			
			
			$my_theme = wp_get_theme();
	
			// correction theme divi pour la position des puces +
			if(stristr($my_theme, 'divi')) {
				
				echo'.is-style-eccp-clear-bullet-list li {';
					echo'background-position: 7px 3px!important;';
				echo'}';
			
			}*/
			
			echo'.is-style-eccp-clear-bullet-list li{';
				
				// on supprime la puce disk par défaut
				echo'list-style-type: none;';
				
				echo'padding-left: 8px;';
				echo'position: relative;';
			
			echo'}';
			
			
			echo'.is-style-eccp-clear-bullet-list li::before{';
						
				echo' background-size: cover!important;
					  display: inline-block; 
					  height:25px;
					  width:25px;
					  left: -25px;
					  position: absolute;
					  top: 1.3em;                  
					  margin-top: -1em;                  	                  
					  mask-repeat: no-repeat;	                 
					  -webkit-mask-repeat: no-repeat;';
				
				// on applique une taille au svg	  
				echo'transform: scale(calc(var(--eccp-bulletSize,20) / 25));';
			
			echo'}';
			
			
			// modification position icône 
			switch ($my_theme) {
				
				// correction theme astra
				case stristr($my_theme, 'astra'):
			
					echo'.is-style-eccp-clear-bullet-list li::before{';
						echo'top: 1.3em;';
					echo'}';
			
				break;
	
				// correction theme divi
				case stristr($my_theme, 'divi'):
			
					echo'.is-style-eccp-clear-bullet-list li::before{';
						echo'top: 1.1em;';
					echo'}';
			
				break;
				
				// correction theme generatepress
				case stristr($my_theme, 'generatepress'):
			
					echo'.is-style-eccp-clear-bullet-list li::before{';
						echo'top: 1.1em;';
					echo'}';
			
				break;
				
			}
			
			echo'.is-style-eccp-clear-bullet-list li::before{';
				
				// lorsqu'on affiche un icone avec la régle pseudo :before
				// il faut appliquer la régle content: "" pour que cela fonctionne
				// on applique une couleur de fond au svg avec la variable CSS
				// --eccp-bulletColor définit par le script ReactJS et enreigistré dans le
				// html du bloc par la régle style
				echo' content: "";
                      background-color: var(--eccp-bulletColor,#333333)!important;';
					  
			echo'}';
			
			
			echo'.is-style-eccp-clear-bullet-list li::before{';
				
				// icône Google
				// la régle mask-image permettra d'appliquer une couleur au SVG
				echo'-webkit-mask-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'24px\' viewBox=\'0 0 24 24\' width=\'24px\' fill=\'%23000000\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12 19 6.41z\'/%3E%3C/svg%3E");';
				echo'mask-image:url("data:image/svg+xml;charset=utf8,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' height=\'24px\' viewBox=\'0 0 24 24\' width=\'24px\' fill=\'%23000000\'%3E%3Cpath d=\'M0 0h24v24H0V0z\' fill=\'none\'/%3E%3Cpath d=\'M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12 19 6.41z\'/%3E%3C/svg%3E");';
				
			echo'}';
			
	    
			/* Régles Pour les mobiles en mode portrait*/ 
			echo'@media only screen and (max-width:480px){';
			
				echo'.is-style-eccp-clear-bullet-list li::before{';
				
					echo'transform: scale(calc(20 / 25));';
					echo'top: 1.2em;';
				
				echo'}';
			
			echo'}';
			
  
			/*------------------- Style Site front end --------------------------*/			
					
			
			// icone Dashicons
			echo'.is-style-eccp-site-bullet-list li:before {';
	
				echo'font-family: dashicons;';
				echo'content: "\f11f";';
				echo'font-weight: 400;';
				echo'vertical-align: top;';	
				echo'margin-left:-25px;';
				echo'margin-right:10px;';				
				echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
				echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
				echo'color:var(--eccp-bulletColor,#333333);';
				
			echo'}';
			
			// on supprime la liste à puces par défaut
			echo'.is-style-eccp-site-bullet-list{';
			
				echo'list-style-type: none!important;';
			
			echo'}';
			
			
			// modification position icône selon thème
			switch ($my_theme) {
				
				// correction theme astra
				case stristr($my_theme, 'astra'):
			
					echo'.is-style-eccp-site-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.5em);';
					echo'}';
			
				break;
	
				// correction theme divi
				case stristr($my_theme, 'divi'):
			
					echo'.is-style-eccp-site-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.2em);';
					echo'}';
			
				break;
				
				// correction theme Generate Press
				case stristr($my_theme, 'generatepress'):
			
					echo'.is-style-eccp-site-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.2em);';
					echo'}';
			
				break;
				
			}


			//Régles Pour les mobiles en mode portrait 
			echo'@media only screen and (max-width:480px){';
			
				echo'.is-style-eccp-site-bullet-list li:before{';
				
					echo'line-height: calc(25 / 20 * 1.4em);';
					echo'font-size:20px;';
				
				echo'}';
			
			echo'}';

		
			/*------------------- Style E-Mail front end  --------------------------*/			
							
			echo'.is-style-eccp-mail-bullet-list li:before {';
			
				echo'font-family: dashicons;';
				echo'content: "\f465";';
				echo'font-weight: 400;';
				echo'vertical-align: top;';	
				echo'margin-left:-25px;';
				echo'margin-right:10px;';				
				echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
				echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
				echo'color:var(--eccp-bulletColor,#333333);';
				
			echo'}';
			
			// on supprime la liste à puces par défaut
			echo'.is-style-eccp-mail-bullet-list{';
			
				echo'list-style-type: none!important;';
			
			echo'}';
			
			// modification position icône selon thème
			switch ($my_theme) {
				
				// correction theme astra
				case stristr($my_theme, 'astra'):
			
					echo'.is-style-eccp-mail-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.5em);';
					echo'}';
			
				break;
	
				// correction theme divi
				case stristr($my_theme, 'divi'):
			
					echo'.is-style-eccp-mail-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.2em);';
					echo'}';
			
				break;
				
			}
			
			
			//Régles Pour les mobiles en mode portrait 
			echo'@media only screen and (max-width:480px){';
			
				echo'.is-style-eccp-mail-bullet-list li:before{';
				
					echo'line-height: calc(25 / 20 * 1.4em);';
					echo'font-size:20px;';
				
				echo'}';
			
			echo'}';
			
			
			/*------------------- Style Phone front end  --------------------------*/
			
			// icone Dashicons
			echo'.is-style-eccp-phone-bullet-list li:before {';
	
				echo'font-family: dashicons;';
				echo'content: "\f525";';
				echo'font-weight: 600;';
				echo'vertical-align: top;';	
				echo'margin-left:-25px;';
				echo'margin-right:10px;';				
				echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
				echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
				echo'color:var(--eccp-bulletColor,#333333);';
				
			echo'}';
			
			// on supprime la liste à puces par défaut
			echo'.is-style-eccp-phone-bullet-list{';
			
				echo'list-style-type: none!important;';
			
			echo'}';
			
			// modification position icône selon les thèmes
			switch ($my_theme) {
				
				// correction theme divi
				case stristr($my_theme, 'divi'):
			
					echo'.is-style-eccp-phone-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
					echo'}';
			
				break;
				
				// correction theme Generate Press
				case stristr($my_theme, 'generatepress'):
			
					echo'.is-style-eccp-phone-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
					echo'}';
			
				break;
				
			}
			
			
			//Régles Pour les mobiles en mode portrait 
			echo'@media only screen and (max-width:480px){';
			
				echo'.is-style-eccp-phone-bullet-list li:before{';
				
					echo'line-height: calc(25 / 20 * 1.4em);';
					echo'font-size:20px;';
				
				echo'}';
			
			echo'}';
			
			
			
			/*------------------- Style Facebook front end  --------------------------*/			
					
			
			// icone Dashicons
			echo'.is-style-eccp-facebook-bullet-list li:before {';
	
				echo'font-family: dashicons;';
				echo'content: "\f305";';
				echo'font-weight: 400;';
				echo'vertical-align: top;';	
				echo'margin-left:-25px;';
				echo'margin-right:10px;';				
				echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
				echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
				echo'color:var(--eccp-bulletColor,#333333);';
				
			echo'}';
			
			// on supprime la liste à puces par défaut
			echo'.is-style-eccp-facebook-bullet-list{';
			
				echo'list-style-type: none!important;';
			
			echo'}';
			
			// modification position icône selon thème
			switch ($my_theme) {
				
				// correction theme astra
				case stristr($my_theme, 'astra'):
			
					echo'.is-style-eccp-facebook-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.4em);';
					echo'}';
			
				break;
	
				// correction theme divi
				case stristr($my_theme, 'divi'):
			
					echo'.is-style-eccp-facebook-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.2em);';
					echo'}';
			
				break;
				
				// correction theme Generate Press
				case stristr($my_theme, 'generatepress'):
			
					echo'.is-style-eccp-facebook-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
					echo'}';
			
				break;
				
			}
	
	
			//Régles Pour les mobiles en mode portrait 
			echo'@media only screen and (max-width:480px){';
			
				echo'.is-style-eccp-facebook-bullet-list li:before{';
				
					echo'line-height: calc(25 / 22 * 1.4em);';
					echo'font-size:22px;';
				
				echo'}';
			
			echo'}';
			
			
			/*------------------- Style YouTube front end  --------------------------*/			
					
			// icone Dashicons
			echo'.is-style-eccp-youtube-bullet-list li:before {';
	
				echo'font-family: dashicons;';
				echo'content: "\f19b";';
				echo'font-weight: 400;';
				echo'vertical-align: top;';	
				echo'margin-left:-25px;';
				echo'margin-right:10px;';				
				echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
				echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
				echo'color:var(--eccp-bulletColor,#333333);';
				
			echo'}';
			
			// on supprime la liste à puces par défaut
			echo'.is-style-eccp-youtube-bullet-list{';
			
				echo'list-style-type: none!important;';
			
			echo'}';
			
			
			// modification position icône selon thème
			switch ($my_theme) {
				
				// correction theme astra
				case stristr($my_theme, 'astra'):
			
					echo'.is-style-eccp-youtube-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.4em);';
					echo'}';
			
				break;
	
				// correction theme divi
				case stristr($my_theme, 'divi'):
			
					echo'.is-style-eccp-youtube-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.2em);';
					echo'}';
			
				break;
				
				// correction theme Generate Press
				case stristr($my_theme, 'generatepress'):
			
					echo'.is-style-eccp-youtube-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
					echo'}';
			
				break;
				
			}
			
			//Régles Pour les mobiles en mode portrait 
			echo'@media only screen and (max-width:480px){';
			
				echo'.is-style-eccp-youtube-bullet-list li:before{';
				
					echo'line-height: calc(25 / 22 * 1.4em);';
					echo'font-size:22px;';
				
				echo'}';
			
			echo'}';
			
			
			/*------------------- Style Twiter front end  --------------------------*/			
							
			echo'.is-style-eccp-twiter-bullet-list li:before {';
			
				echo'font-family: dashicons;';
				echo'content: "\f301";';
				echo'font-weight: 400;';
				echo'vertical-align: top;';	
				echo'margin-left:-25px;';
				echo'margin-right:10px;';				
				echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
				echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
				echo'color:var(--eccp-bulletColor,#333333);';
				
			echo'}';
			
			// on supprime la liste à puces par défaut
			echo'.is-style-eccp-twiter-bullet-list{';
			
				echo'list-style-type: none!important;';
			
			echo'}';
			
			// modification position icône selon thème
			switch ($my_theme) {
				
				// correction theme astra
				case stristr($my_theme, 'astra'):
			
					echo'.is-style-eccp-twiter-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.4em);';
					echo'}';
			
				break;
	
				// correction theme divi
				case stristr($my_theme, 'divi'):
			
					echo'.is-style-eccp-twiter-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.2em);';
					echo'}';
			
				break;
				
				// correction theme Generate Press
				case stristr($my_theme, 'generatepress'):
			
					echo'.is-style-eccp-twiter-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
					echo'}';
			
				break;
				
			}
			
			
			//Régles Pour les mobiles en mode portrait 
			echo'@media only screen and (max-width:480px){';
			
				echo'.is-style-eccp-twiter-bullet-list li:before{';
				
					echo'line-height: calc(25 / 20 * 1.3em);';
					echo'font-size:20px;';
				
				echo'}';
			
			echo'}';
			
			
			/*------------------- Style Pinterest front end  --------------------------*/			
							
			echo'.is-style-eccp-pinterest-bullet-list li:before {';
			
				echo'font-family: dashicons;';
				echo'content: "\f192";';
				echo'font-weight: 400;';
				echo'vertical-align: top;';	
				echo'margin-left:-25px;';
				echo'margin-right:10px;';				
				echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
				echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
				echo'color:var(--eccp-bulletColor,#333333);';
				
			echo'}';
			
			// on supprime la liste à puces par défaut
			echo'.is-style-eccp-pinterest-bullet-list{';
			
				echo'list-style-type: none!important;';
			
			echo'}';
			
			// modification position icône selon thème
			switch ($my_theme) {
				
				// correction theme astra
				case stristr($my_theme, 'astra'):
			
					echo'.is-style-eccp-pinterest-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.4em);';
					echo'}';
			
				break;
	
				// correction theme divi
				case stristr($my_theme, 'divi'):
			
					echo'.is-style-eccp-pinterest-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.2em);';
					echo'}';
			
				break;
				
				// correction theme Generate Press
				case stristr($my_theme, 'generatepress'):
			
					echo'.is-style-eccp-pinterest-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
					echo'}';
			
				break;
				
			}
			
			
			//Régles Pour les mobiles en mode portrait 
			echo'@media only screen and (max-width:480px){';
			
				echo'.is-style-eccp-pinterest-bullet-list li:before{';
				
					echo'line-height: calc(25 / 20 * 1.3em);';
					echo'font-size:20px;';
				
				echo'}';
			
			echo'}';
			
			/*------------------- Style Instagram front end  --------------------------*/			
							
			echo'.is-style-eccp-instagram-bullet-list li:before {';
			
				echo'font-family: dashicons;';
				echo'content: "\f12d";';
				echo'font-weight: 400;';
				echo'vertical-align: top;';	
				echo'margin-left:-25px;';
				echo'margin-right:10px;';				
				echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
				echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
				echo'color:var(--eccp-bulletColor,#333333);';
				
			echo'}';
			
			// on supprime la liste à puces par défaut
			echo'.is-style-eccp-instagram-bullet-list{';
			
				echo'list-style-type: none!important;';
			
			echo'}';
			
			// modification position icône selon thème
			switch ($my_theme) {
				
				// correction theme astra
				case stristr($my_theme, 'astra'):
			
					echo'.is-style-eccp-instagram-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.4em);';
					echo'}';
			
				break;
	
				// correction theme divi
				case stristr($my_theme, 'divi'):
			
					echo'.is-style-eccp-instagram-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.2em);';
					echo'}';
			
				break;
				
				// correction theme Generate Press
				case stristr($my_theme, 'generatepress'):
			
					echo'.is-style-eccp-instagram-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
					echo'}';
			
				break;
				
			}
			
			
			//Régles Pour les mobiles en mode portrait 
			echo'@media only screen and (max-width:480px){';
			
				echo'.is-style-eccp-instagram-bullet-list li:before{';
				
					echo'line-height: calc(25 / 20 * 1.3em);';
					echo'font-size:20px;';
				
				echo'}';
			
			echo'}';
			
			/*------------------- Style Linkedin front end  --------------------------*/			
							
			echo'.is-style-eccp-linkedin-bullet-list li:before {';
			
				echo'font-family: dashicons;';
				echo'content: "\f18d";';
				echo'font-weight: 400;';
				echo'vertical-align: top;';	
				echo'margin-left:-25px;';
				echo'margin-right:10px;';				
				echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
				echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
				echo'color:var(--eccp-bulletColor,#333333);';
				
			echo'}';
			
			// on supprime la liste à puces par défaut
			echo'.is-style-eccp-linkedin-bullet-list{';
			
				echo'list-style-type: none!important;';
			
			echo'}';
			
			// modification position icône selon thème
			switch ($my_theme) {
				
				// correction theme astra
				case stristr($my_theme, 'astra'):
			
					echo'.is-style-eccp-linkedin-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.4em);';
					echo'}';
			
				break;
	
				// correction theme divi
				case stristr($my_theme, 'divi'):
			
					echo'.is-style-eccp-linkedin-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.2em);';
					echo'}';
			
				break;
				
				// correction theme Generate Press
				case stristr($my_theme, 'generatepress'):
			
					echo'.is-style-eccp-linkedin-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
					echo'}';
			
				break;
				
			}
			
			
			//Régles Pour les mobiles en mode portrait 
			echo'@media only screen and (max-width:480px){';
			
				echo'.is-style-eccp-linkedin-bullet-list li:before{';
				
					echo'line-height: calc(25 / 20 * 1.3em);';
					echo'font-size:20px;';
				
				echo'}';
			
			echo'}';
			
			/*------------------- Style Whatsappp front end  --------------------------*/			
							
			echo'.is-style-eccp-whatsapp-bullet-list li:before {';
			
				echo'font-family: dashicons;';
				echo'content: "\f19a";';
				echo'font-weight: 400;';
				echo'vertical-align: top;';	
				echo'margin-left:-25px;';
				echo'margin-right:10px;';				
				echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
				echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
				echo'color:var(--eccp-bulletColor,#333333);';
				
			echo'}';
			
			// on supprime la liste à puces par défaut
			echo'.is-style-eccp-whatsapp-bullet-list{';
			
				echo'list-style-type: none!important;';
			
			echo'}';
			
			// modification position icône selon thème
			switch ($my_theme) {
				
				// correction theme astra
				case stristr($my_theme, 'astra'):
			
					echo'.is-style-eccp-whatsapp-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.4em);';
					echo'}';
			
				break;
	
				// correction theme divi
				case stristr($my_theme, 'divi'):
			
					echo'.is-style-eccp-whatsapp-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.2em);';
					echo'}';
			
				break;
				
				// correction theme Generate Press
				case stristr($my_theme, 'generatepress'):
			
					echo'.is-style-eccp-whatsapp-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
					echo'}';
			
				break;
				
			}
			
			
			//Régles Pour les mobiles en mode portrait 
			echo'@media only screen and (max-width:480px){';
			
				echo'.is-style-eccp-whatsapp-bullet-list li:before{';
				
					echo'line-height: calc(25 / 20 * 1.3em);';
					echo'font-size:20px;';
				
				echo'}';
			
			echo'}';
			
			
			
			/*------------------- Style Calendar front end  --------------------------*/
			
			// icone Dashicons
			echo'.is-style-eccp-calendar-bullet-list li:before {';
	
				echo'font-family: dashicons;';
				echo'content: "\f508";';
				echo'font-weight: 400;';
				echo'vertical-align: top;';	
				echo'margin-left:-25px;';
				echo'margin-right:10px;';				
				echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
				echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
				echo'color:var(--eccp-bulletColor,#333333);';
				
			echo'}';
			
			// on supprime la liste à puces par défaut
			echo'.is-style-eccp-calendar-bullet-list{';
			
				echo'list-style-type: none!important;';
			
			echo'}';
			
			
			// modification position icône selon thème
			switch ($my_theme) {
			
				// correction theme divi
				case stristr($my_theme, 'divi'):
			
					echo'.is-style-eccp-calendar-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
					echo'}';
			
				break;
				
				// correction theme Generate Press
				case stristr($my_theme, 'generatepress'):
			
					echo'.is-style-eccp-calendar-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
					echo'}';
			
				break;
				
			}
			
			
			//Régles Pour les mobiles en mode portrait 
			echo'@media only screen and (max-width:480px){';
			
				echo'.is-style-eccp-calendar-bullet-list li:before{';
				
					echo'line-height: calc(25 / 20 * 1.3em);';
					echo'font-size:20px;';
				
				echo'}';
			
			echo'}';
			
			
			
			/*------------------- Style Clock front end  --------------------------*/			
					
			
			// icone Dashicons
			echo'.is-style-eccp-clock-bullet-list li:before {';
	
				echo'font-family: dashicons;';
				echo'content: "\f469";';
				echo'font-weight: 600;';
				echo'vertical-align: top;';	
				echo'margin-left:-25px;';
				echo'margin-right:10px;';				
				echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
				echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
				echo'color:var(--eccp-bulletColor,#333333);';
				
			echo'}';
			
			// on supprime la liste à puces par défaut
			echo'.is-style-eccp-clock-bullet-list{';
			
				echo'list-style-type: none!important;';
			
			echo'}';
			
			// modification position icône selon thème
			switch ($my_theme) {
				
				// correction theme astra
				case stristr($my_theme, 'astra'):
			
					echo'.is-style-eccp-clock-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.4em);';
					echo'}';
			
				break;
	
				// correction theme divi
				case stristr($my_theme, 'divi'):
			
					echo'.is-style-eccp-clock-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.1em);';
					echo'}';
			
				break;
				
				// correction theme Generate Press
				case stristr($my_theme, 'generatepress'):
			
					echo'.is-style-eccp-clock-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.2em);';
					echo'}';
			
				break;
				
			}
	
	
			//Régles Pour les mobiles en mode portrait 
			echo'@media only screen and (max-width:480px){';
			
				echo'.is-style-eccp-clock-bullet-list li:before{';
				
					echo'line-height: calc(25 / 20 * 1.3em);';
					echo'font-size:20px;';
				
				echo'}';
			
			echo'}';
			
			
			/*------------------- Style Location front end  --------------------------*/			
					
			// icone Dashicons
			echo'.is-style-eccp-location-bullet-list li:before {';
	
				echo'font-family: dashicons;';
				echo'content: "\f230";';
				echo'font-weight: 600;';
				echo'vertical-align: top;';	
				echo'margin-left:-25px;';
				echo'margin-right:10px;';				
				echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.3em);';
				echo'font-size:calc(var(--eccp-bulletSize,20)*1px);';
				echo'color:var(--eccp-bulletColor,#333333);';
				
			echo'}';
			
			// on supprime la liste à puces par défaut
			echo'.is-style-eccp-location-bullet-list{';
			
				echo'list-style-type: none!important;';
			
			echo'}';
			
			
			// modification position icône selon thème
			switch ($my_theme) {
				
				// correction theme astra
				case stristr($my_theme, 'astra'):
			
					echo'.is-style-eccp-location-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.4em);';
					echo'}';
			
				break;
	
				// correction theme divi
				case stristr($my_theme, 'divi'):
			
					echo'.is-style-eccp-location-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.2em);';
					echo'}';
			
				break;
				
				// correction theme Generate Press
				case stristr($my_theme, 'generatepress'):
			
					echo'.is-style-eccp-location-bullet-list li::before{';
						echo'line-height: calc(25 / var(--eccp-bulletSize,20) * 1.2em);';
					echo'}';
			
				break;
				
			}
	
			//Régles Pour les mobiles en mode portrait 
			echo'@media only screen and (max-width:480px){';
			
				echo'.is-style-eccp-location-bullet-list li:before{';
				
					echo'line-height: calc(25 / 20 * 1.4em);';
					echo'font-size:20px;';
				
				echo'}';
			
			echo'}';
			
			
			/*------------------- Style Diagram front end  --------------------------*/
			
			/*

			On ajoute au bloc liste la classe: is-style-eccp-tree-bullet-list
			Ajoutez des éléments de liste pour représenter la structure de votre diagramme. 
			Indentez les éléments de la liste qui doivent être les éléments de la sous-arborescence 
			dans le diagramme
			Vous devez impérativement mettre en gras tous les éléments de la liste.

			*/


			echo'.is-style-eccp-tree-bullet-list, 
				 .is-style-eccp-tree-bullet-list ul,
				 .is-style-eccp-tree-bullet-list li,
				  body.single .site-content .is-style-eccp-tree-bullet-list ul, 
			      body.page .site-content .is-style-eccp-tree-bullet-list ul {';
					echo'list-style: none!important;';
					echo'margin: 0!important;';
					echo'padding: 0;';
					echo'position: relative;';
			echo'}';

			echo'.is-style-eccp-tree-bullet-list {';
				echo'margin: 0 0 1em;';
				echo'text-align: center;';
			echo'}';

			echo'.is-style-eccp-tree-bullet-list, .is-style-eccp-tree-bullet-list ul {';
				echo'display: table;';
			echo'}';

			echo'.is-style-eccp-tree-bullet-list ul {';
			  echo'width: 100%;';
			echo'}';

				/* encadrement des niveaux d'arborescence*/
				echo'.is-style-eccp-tree-bullet-list li {';
					echo'display: table-cell;';
					echo'padding: .5em 0;';
					echo'vertical-align: top;';
				echo'}';
				
			    echo'.is-style-eccp-tree-bullet-list li:before {';
					echo'outline: solid 1px #666;';
					echo'content: "";';
					echo'left: 0;';
					echo'position: absolute;';
					echo'right: 0;';
					echo'top: 0;';
				echo'}';
				
				echo'.is-style-eccp-tree-bullet-list li:first-child:before {';
					echo'left: 50%;';
				echo'}';
				
				echo'.is-style-eccp-tree-bullet-list li:last-child:before {';
					echo'right: 50%;';
				echo'}';

					
				echo'.is-style-eccp-tree-bullet-list strong {';
					echo'border: solid .1em #666;';
					echo'border-radius: .2em;';
					echo'display: inline-block;';
					echo'margin: 0 .2em .5em;';
					echo'padding: .2em .5em;';
					echo'position: relative;';
				echo'}';
				
				
				
			/* laison verticale du diagramme  | */
			echo'.is-style-eccp-tree-bullet-list ul:before,       
				 .is-style-eccp-tree-bullet-list strong:before {';
					echo'outline: solid 1px #666;';
					echo'content: "";';
					echo'height: .5em;';
					echo'left: 50%;';
					echo'top: -.55em;';
					echo'position: absolute;';
			echo'}';

			echo'.is-style-eccp-tree-bullet-list ul:before {';
				echo'top: -.5em;';
			echo'}';
			
			
			/*------------------- Style Disque Pour Liste Ordonnée front end  --------------------------*/
						
			/* Marge externe de la liste */
			echo'ol.is-style-eccp-ordonned-disk-bullet-list {';
				echo'margin: 15px 0 15px 0px;';
			echo'}';

			/* type de puce de la liste */ 
			echo' ol.is-style-eccp-ordonned-disk-bullet-list {';
				echo'counter-reset: li;';
				echo'list-style: none;';
			echo'}';

			/* Régle pour la liste: marge interne, hauteur etc.. */
			echo' ol.is-style-eccp-ordonned-disk-bullet-list li {';
				echo'position: relative;';
				echo'padding-left: 35px;';
				echo'min-height: calc( (var(--eccp-bulletSize,18) + 13) * 1px);';
			echo'}';

			/* Taille des chiffres de la liste ordonnée & du fond en forme de disque */
			echo' ol.is-style-eccp-ordonned-disk-bullet-list li:before {';
				echo'content: counter(li);';
				echo'counter-increment: li;';
				echo'color: #fff;';
				echo'background: var(--eccp-bulletColor,#333333);';
				echo'border-radius: 50%;';
				echo'font-size: calc(var(--eccp-bulletSize,18)*1px);';
				echo'width: calc( (var(--eccp-bulletSize,18) + 5) * 1px);';
				echo'height: calc( (var(--eccp-bulletSize,18) + 5) * 1px);';
				echo'line-height: calc( (var(--eccp-bulletSize,18) + 5) * 1px);';
				echo'text-align: center;';
				echo'display: block;';
				echo'position: absolute;';
				echo'top: calc( ( (25 - var(--eccp-bulletSize,18)) / 2 ) * 1px);';
				echo'left: 0;';
			echo'}';
			
			
			/* correction positionnement puces & marge interne liste pour le thème DIVI */
			if (stristr($my_theme, 'divi')){
				
				echo' ol.is-style-eccp-ordonned-disk-bullet-list li:before {';
					echo'top: calc( ( (21 - var(--eccp-bulletSize,18)) / 2 ) * 1px);';
				echo'}';
				
				echo' ol.is-style-eccp-ordonned-disk-bullet-list li {';
					echo'padding-left: 20px;';
				echo'}';
				
			}
			
			
			/* Régles pour mobile pour la taille des chiffres de la liste ordonnée 
			   & du fond en forme de disque & hauteur de la liste */
			echo'@media (max-width:480px) {';
			
				echo' ol.is-style-eccp-ordonned-disk-bullet-list li:before {';
				
					echo'font-size: 18px;';
					echo'width: calc( (18 + 5) * 1px);';
					echo'height: calc( (18 + 5) * 1px);';
					echo'line-height: calc( (18 + 5) * 1px);';
					echo'top: calc( ( (28 - 18) / 2 ) * 1px);';
				
				echo'}';
				
				/* correction positionnement puces pour le thème DIVI */
				if (stristr($my_theme, 'divi')){
				
					echo' ol.is-style-eccp-ordonned-disk-bullet-list li:before {';
						echo'top: calc( ( (21 - 18) / 2 ) * 1px);';
					echo'}';
				
				}
				
				echo' ol.is-style-eccp-ordonned-disk-bullet-list li {';
					echo'min-height: calc( (18 + 13) * 1px);';
				echo'}';
				
			echo'}';
			
			
			/* pour les puces indentés */
			echo'ol.is-style-eccp-ordonned-disk-bullet-list li::marker {';
				echo'color: transparent;';
			echo'}';
			
			/*------------------- Style Accordion front end  --------------------------*/
			
			/*
			On utilise conjointement les régles CSS et le script JS: eccp-accordion-list-block.js
			dans les paramètres du bloc liste panneau Style on sélectionne le style accordéon
			pour attribuer la classe is-style-eccp-accordion-bullet-list au bloc liste
			la question est le 1er item de la liste	
			la réponse est le deuxième item de la liste qu'on a identé
			a l'initialisation du script toutes les réponses sont masquées
			A l'événement click sur le container de la question sélectionnée 
			Alors si la réponse sélectionnée est masquée:
			- si une réponse d'une autre question est visible on la masque et on supprime 
			la classe open au container de la question.
			- on attribue la classe:open au container de la question sélectionnée.
			*/

			/*-----------  Balisage du bloc LISTE transformé en accordéon -------------------*/ 
			/*

			<ul class="is-style-eccp-accordion-bullet-list">
			
				<li class="eccp-accordion-question">Question 1  ----> 1er item de la liste
					<ul class="eccp-accordion-answer"> ----> 2ème item de la liste identé
						<li class="">Réponse 1</li>
					</ul>
				</li>
				
				<li class="eccp-accordion-question">Question 2
					<ul class="eccp-accordion-answer">
						<li class="">Réponse 2</li>
					</ul>
				</li>
				
			</ul>

			*/
			
			// on supprime notament la marge a gauche du bloc liste
			echo'body.page ul.is-style-eccp-accordion-bullet-list,
                 body.single ul.is-style-eccp-accordion-bullet-list	{';
				echo'margin:20px 0 20px 0!important;';
				echo'padding:0!important;';
			echo'}';
			
			// container de la question
			echo'ul.is-style-eccp-accordion-bullet-list .eccp-accordion-question {';
				echo'border:1px solid #D4D4D4;';
				echo'border-radius: 4px;';
				echo'margin-bottom: 20px;';
				echo'background-color: #FDFEFF;';
				echo'list-style-type: none;';
				echo'padding: 20px 15px;';
				echo'font-weight: 700;';
				echo'cursor: pointer;';
				echo'padding: 1em 0 1em 0;';
			echo'}';

			// container de la réponse fermé par défaut
			echo'ul.is-style-eccp-accordion-bullet-list .eccp-accordion-answer {';
				echo'color:#333333;';
				echo'list-style-type: none!important;';
				echo'display:none;';
				echo'font-weight:400;';
			echo'}';

			// pour l' accordéon ouvert car le container de la question
			// a la classe open alors on affiche la réponse
			echo'.eccp-accordion-question.open .eccp-accordion-answer {';
				echo'display:block;';
				echo'background: #FFFFFF;';
				echo'border-top: 1px solid #D4D4D4;';
				echo'padding: 1em 1em 0 1em!important;';
				echo'margin: 1em 0 0 0!important;';
			echo'}';

			// icone dashicons flêche vers le bas
			// pour un accordéon fermé
			echo'.eccp-accordion-question::before {';
				echo'content: "\f347";';
				echo'font-family: "dashicons";';
				echo'margin: 0 15px 0 15px;';
				echo'vertical-align: middle;';
			echo'}';

			// icone dashicons flêche vers le haut
			// pour un accordéon ouvert
			echo'.eccp-accordion-question.open::before {';
				echo'content: "\f343";';
			echo'}';
			
			/*-----------  Style Table Of Contents Front End -------------------*/ 
			
			// on supprime l'affichage de la table des matières
			// sur la page Blog
			echo'body.blog .eccp-toc {';
				echo'display: none;';
			echo'}';
			
			// on supprime l'affichage de la table des matières
			// sur la page archive des Étiquettes
			echo'body.archive .is-style-eccp-toc {';
				echo'display: none;';
			echo'}';
			
		}//fin si on a activé les styles liste à puces
		
				
		/*-------------------BLOC IMAGE FRONT END --------------------------*/
		
		echo'.wp-block-image {
			margin-top: 1.5em!important;
			margin-bottom: 1.5em!important;
		}';
		
		/* surbrillance légende image en orange foncé */
		echo'.wp-block-image mark{';
		
			echo'background:'.esc_html($custom_gutenberg_blocks_settings['eccp_settings_caption_background_color_text_field']).';';
			echo'padding:'.esc_html($custom_gutenberg_blocks_settings['eccp_settings_caption_padding_text_field']).'px;';
			echo'color:'.esc_html($custom_gutenberg_blocks_settings['eccp_settings_caption_color_text_field']).';';
		
		echo'}';
		
		/* Légende de l'image */
		echo'body.single .wp-block-image figcaption,
			 body.page .wp-block-image figcaption,
			 body.blog .wp-block-image figcaption {';
		
			echo'font-size:'.esc_html($custom_gutenberg_blocks_settings['eccp_settings_caption_font_size_text_field']).'px!important;';
			echo'margin-top:1.5em;';
			
		echo'}';
		
		
		/* On supprime la légende pour la lightbox */
		echo'.fbx-modal .fbx-caption-title{
			display:none;
		}';
		
		/*----------------------------Style Circle front end------------------------------*/
		// utilise la régle CSS clip-path pour apliquer un masque de détourage
		// Credits: https://github.com/bennettfeely/Clippy
		
		
		if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_image_circle_radio_field'] == 'yes' ) {
					
					// image 4/3
					echo'.is-style-eccp-image-circle-4-3 img {';
					
						echo'clip-path: circle(42.5% at 50% 50%)!important;';
					
					echo'}';
					
					// image 16/9
					echo'.is-style-eccp-image-circle-16-9 img {';
					
						echo'clip-path: circle(33.4% at 50% 50%)!important;';
					
					echo'}';
					
		}
		
		/*----------------------------Style Filter Grayscale front end------------------------------*/

		if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_image_filter_grayscale_radio_field'] == 'yes' ) {
			
			echo'.is-style-eccp-filter-grayscale img {';
					
				echo'-webkit-filter: grayscale(100%);';
				echo'filter: grayscale(100%);';
					
			echo'}';
			
			echo'.is-style-eccp-filter-grayscale img:hover {';
					
				echo'-webkit-filter: grayscale(0);';
				echo'filter: grayscale(0);';
					
			echo'}';
		
			
		}
		
		
		/*----------------------------Style Card Image front end------------------------------*/

		if( $custom_gutenberg_blocks_settings['eccp_settings_activate_style_image_card_radio_field'] == 'yes' ) {
			
			// régles pour l'image
			// --eccp-cardStyleImageWidth est une variable javasscript définit
			// en React JS et enregistré dans le HTML du bloc image
			echo'.wp-block-image.is-style-eccp-card-image img{';
				
				//echo'box-shadow: 0 0px 4px 2px rgba(0,0,0,.2);';
				echo'background: #ffffff;';
				echo'width: var(--eccp-cardStyleImageWidth, 300px)!important;';
				
			echo'}';
			
			// régles pour la légende
			echo'body.single .wp-block-image.is-style-eccp-card-image figcaption, 
				 body.page .wp-block-image.is-style-eccp-card-image figcaption, 
				 body.blog .wp-block-image.is-style-eccp-card-image figcaption{';
			
				//echo'display: block;';
				//echo'margin:auto;';
				echo'width: var(--eccp-cardStyleImageWidth, 300px)!important;';
				echo'background: #ffffff;';
				echo'box-shadow: 0 2px 1px -1px rgba(0,0,0,.2), 0 1px 1px 0 rgba(0,0,0,.14), 0 1px 3px 0 rgba(0,0,0,.12);';
				echo'margin-top:0em;';
				echo'padding:0.5em 0;';
				echo'text-align:center;';
			
			echo'}';
			
			// régles responsive pour les mobiles
			echo'@media(max-width:480px) {';
			
				// régles pour l'image
				echo'.wp-block-image.is-style-eccp-card-image img{';
				
					echo'width:90vw!important;';
				
				echo'}';
				
				// régles pour la légende
				echo'body.single .wp-block-image.is-style-eccp-card-image figcaption, 
				 body.page .wp-block-image.is-style-eccp-card-image figcaption, 
				 body.blog .wp-block-image.is-style-eccp-card-image figcaption{';
			
					echo'width:90vw!important;';
				
				echo'}';
			
			echo'}';
			
			
			$my_theme = wp_get_theme();
			
			// suite régles légende
			if(stristr($my_theme, 'oceanwp')) {
				
				echo'body.single .wp-block-image.is-style-eccp-card-image figcaption, 
				 body.page .wp-block-image.is-style-eccp-card-image figcaption, 
				 body.blog .wp-block-image.is-style-eccp-card-image figcaption{';
			
					echo'display: block;';
					echo'margin:auto;';
			
				echo'}';
				
			}else{
				
				// display:block ne fonctionne pas pour un alignement centré
				// pour les thèmes différent de OceanWP
				echo'.wp-block-image.is-style-eccp-card-image .alignleft figcaption,
				     .wp-block-image.is-sty